/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.har;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hcatalog.common.HCatException;

public class HarOutputCommitterPostProcessor {
    boolean isEnabled = false;

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void exec(JobContext context, Partition partition, Path partPath) throws IOException {
        HarOutputCommitterPostProcessor.makeHar(context, partPath.toUri().toString(), this.harFile(partPath));
        partition.getParameters().put("is_archived", "true");
    }

    public String harFile(Path ptnPath) throws IOException {
        String harFile = ptnPath.toString().replaceFirst("/+$", "") + ".har";
        return harFile;
    }

    public String getParentFSPath(Path ptnPath) throws IOException {
        return ptnPath.toUri().getPath().replaceFirst("/+$", "");
    }

    public String getProcessedLocation(Path ptnPath) throws IOException {
        String harLocn = ("har://" + ptnPath.toUri().getPath()).replaceFirst("/+$", "") + ".har" + "/";
        return harLocn;
    }

    public static void makeHar(JobContext context, String dir, String harFile) throws IOException {
        int lastSep = harFile.lastIndexOf(47);
        Path archivePath = new Path(harFile.substring(0, lastSep));
        String[] args = new String[]{"-archiveName", harFile.substring(lastSep + 1, harFile.length()), "-p", dir, "*", archivePath.toString()};
        try {
            HadoopArchives har;
            int rc;
            Configuration newConf = new Configuration();
            FileSystem fs = archivePath.getFileSystem(newConf);
            String hadoopTokenFileLocationEnvSetting = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
            if (hadoopTokenFileLocationEnvSetting != null && !hadoopTokenFileLocationEnvSetting.isEmpty()) {
                newConf.set("mapreduce.job.credentials.binary", hadoopTokenFileLocationEnvSetting);
            }
            if ((rc = ToolRunner.run((Tool)(har = new HadoopArchives(newConf)), (String[])args)) != 0) {
                throw new Exception("Har returned error code " + rc);
            }
            fs.delete(new Path(dir), true);
        }
        catch (Exception e) {
            throw new HCatException("Error creating Har [" + harFile + "] from [" + dir + "]", (Throwable)e);
        }
    }
}

