/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.rcfile;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class RCFileMapReduceRecordReader<K extends LongWritable, V extends BytesRefArrayWritable>
extends RecordReader<LongWritable, BytesRefArrayWritable> {
    private RCFile.Reader in;
    private long start;
    private long end;
    private boolean more = true;
    private LongWritable key;
    private BytesRefArrayWritable value;

    public void close() throws IOException {
        this.in.close();
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public BytesRefArrayWritable getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.in.getPosition() - this.start) / (float)(this.end - this.start));
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.more = this.next(this.key);
        if (this.more) {
            this.in.getCurrentRow(this.value);
        }
        return this.more;
    }

    private boolean next(LongWritable key) throws IOException {
        if (!this.more) {
            return false;
        }
        this.more = this.in.next(key);
        if (!this.more) {
            return false;
        }
        if (this.in.lastSeenSyncPos() >= this.end) {
            this.more = false;
            return this.more;
        }
        return this.more;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fSplit = (FileSplit)split;
        Path path = fSplit.getPath();
        Configuration conf = context.getConfiguration();
        this.in = new RCFile.Reader(path.getFileSystem(conf), path, conf);
        this.end = fSplit.getStart() + fSplit.getLength();
        if (fSplit.getStart() > this.in.getPosition()) {
            this.in.sync(fSplit.getStart());
        }
        this.start = this.in.getPosition();
        this.more = this.start < this.end;
        this.key = new LongWritable();
        this.value = new BytesRefArrayWritable();
    }
}

