/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hive.hcatalog.mapreduce.HCatBaseInputFormat;
import org.apache.hive.hcatalog.mapreduce.InitializeInput;
import org.apache.hive.hcatalog.mapreduce.InputJobInfo;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HCatInputFormat
extends HCatBaseInputFormat {
    private Configuration conf;
    private InputJobInfo inputJobInfo;

    @Deprecated
    public static void setInput(Job job, InputJobInfo inputJobInfo) throws IOException {
        HCatInputFormat.setInput(job.getConfiguration(), inputJobInfo);
    }

    @Deprecated
    public static void setInput(Configuration conf, InputJobInfo inputJobInfo) throws IOException {
        HCatInputFormat.setInput(conf, inputJobInfo.getDatabaseName(), inputJobInfo.getTableName()).setFilter(inputJobInfo.getFilter()).setProperties(inputJobInfo.getProperties());
    }

    public static HCatInputFormat setInput(Job job, String dbName, String tableName) throws IOException {
        return HCatInputFormat.setInput(job.getConfiguration(), dbName, tableName);
    }

    public static HCatInputFormat setInput(Configuration conf, String dbName, String tableName) throws IOException {
        Preconditions.checkNotNull((Object)conf, (Object)"required argument 'conf' is null");
        Preconditions.checkNotNull((Object)tableName, (Object)"required argument 'tableName' is null");
        HCatInputFormat hCatInputFormat = new HCatInputFormat();
        hCatInputFormat.conf = conf;
        hCatInputFormat.inputJobInfo = InputJobInfo.create(dbName, tableName, null, null);
        try {
            InitializeInput.setInput(conf, hCatInputFormat.inputJobInfo);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return hCatInputFormat;
    }

    public HCatInputFormat setFilter(String filter) throws IOException {
        if (filter != null) {
            this.inputJobInfo = InputJobInfo.create(this.inputJobInfo.getDatabaseName(), this.inputJobInfo.getTableName(), filter, this.inputJobInfo.getProperties());
            try {
                InitializeInput.setInput(this.conf, this.inputJobInfo);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return this;
    }

    public HCatInputFormat setProperties(Properties properties) throws IOException {
        Preconditions.checkNotNull((Object)properties, (Object)"required argument 'properties' is null");
        this.inputJobInfo = InputJobInfo.create(this.inputJobInfo.getDatabaseName(), this.inputJobInfo.getTableName(), this.inputJobInfo.getFilter(), properties);
        try {
            InitializeInput.setInput(this.conf, this.inputJobInfo);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this;
    }
}

