/**
 * @file
 * @brief Test for second @vsnprintf call error case.
 *
 * This is test for second @vsnprintf call error case of @asprintf and
 * @vasprintf.
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <cutter.h>

#include "asprintf.h"

static int mock_vsnprintf2(
    char * restrict str __attribute__((unused)), size_t size,
    const char * restrict format __attribute__((unused)),
    va_list ap __attribute__((unused)))
{
    return size;
}

static int free_count;

static void mock_free(void *ptr)
{
    free_count++;
    free(ptr);
}

/**
 * @brief Setup for second @vsnprintf call error case.
 *
 * This is a setup function for second @vsnprintf call error case.
 *
 * This function sets @c mockable_vsnprintf2 and @c mockable_free to be mock
 * function @c mock_vsnprintf2 and @c mock_free respectively, and resets
 * @c free_count.
 *
 * The mock function @c mock_vsnprintf2 always returns its second parameter,
 * that is not equal to return value of first @vsnprintf call.
 *
 * The mock function @c mock_free counts @c free_count up, and calls @free.
 */
void cut_setup(void)
{
    mockable_vsnprintf2 = mock_vsnprintf2;
    mockable_free = mock_free;
    free_count = 0;
}

/**
 * @brief Teardown for second @vsnprintf call error case.
 *
 * This is a teardown function for second @vsnprintf call error case.
 *
 * This function resets @c mockable_vsnprintf2 and @c mockable_free.
 */
void cut_teardown(void)
{
    mockable_vsnprintf2 = vsnprintf;
    mockable_free = free;
}

/**
 * @brief Test for second @vsnprintf call error case.
 *
 * This is a test for second @vsnprintf call error case.
 *
 * In this case, @vasprintf should call @free for allocated memory,
 * @asprintf should return @c -1 and set pointer to be @c NULL.
 */
void test_vsnprintf2_error_case(void)
{
    char *str;
    int size = asprintf(&str, "ABCDEFG");
    cut_assert_equal_int(-1, size);
    cut_assert_null(str);
    cut_assert_equal_int(1, free_count);
}
