/**
 * @file
 * @brief Test for @malloc call parameter check case.
 *
 * This is test for @malloc call parameter check case of @asprintf and
 * @vasprintf.
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <cutter.h>

#include "asprintf.h"

static int vsnprintf1_ret;

static int mock_vsnprintf1(
    char * restrict str, size_t size,
    const char * restrict format, va_list ap)
{
    vsnprintf1_ret = vsnprintf(str, size, format, ap);
    return vsnprintf1_ret;
}

static size_t malloc_size;

static void *mock_malloc(size_t size)
{
    malloc_size = size;
    return NULL;
}

/**
 * @brief Setup for @malloc call parameter check case.
 *
 * This is a setup function for @malloc call parameter check case.
 *
 * This function sets @c mockable_vsnprintf1 and @c mockable_malloc to be
 * mock function @c mock_vsnprintf1 and @c mock_malloc respectively, and
 * resets all save area.
 *
 * The mock function @c mock_vsnprintf1 saves and returns @vsnprintf return
 * value.
 *
 * The mock function @c mock_malloc saves its parameter, and returns @c NULL.
 */
void cut_setup(void)
{
    mockable_vsnprintf1 = mock_vsnprintf1;
    mockable_malloc = mock_malloc;
    vsnprintf1_ret = 0;
    malloc_size = 0;
}

/**
 * @brief Teardown for @malloc call parameter check case.
 *
 * This is a teardown function for @malloc call parameter check case.
 *
 * This function resets @c mockable_vsnprintf1 and @c mockable_malloc.
 */
void cut_teardown(void)
{
    mockable_vsnprintf1 = vsnprintf;
    mockable_malloc = malloc;
}

/**
 * @brief Test for @malloc call parameter check case.
 *
 * This is a test for @malloc call parameter check case.
 */
void test_malloc_parameter_check_case(void)
{
    char *str;
    asprintf(&str, "%d", 123);
    cut_assert_equal_size(vsnprintf1_ret + 1, malloc_size);
    free(str);
}
