/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.CHArrayList;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

class FloorTile {
    public static final int BLANK = 0;
    public static final int WALL = 1;
    public static final int UPSTAIRS = 2;
    public static final int DOWNSTAIRS = 3;
    static Image blank;
    static Image wall;
    static Image upstairs;
    static Image downstairs;
    static Image parts;
    int id;
    CHArrayList item = new CHArrayList();

    public static void init(Object obj, MediaTracker mt) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        blank = tk.getImage(obj.getClass().getResource("tile/tileblank.png"));
        mt.addImage(blank, 0);
        wall = tk.getImage(obj.getClass().getResource("tile/wall.png"));
        mt.addImage(wall, 0);
        upstairs = tk.getImage(obj.getClass().getResource("tile/upstairs.png"));
        mt.addImage(upstairs, 0);
        downstairs = tk.getImage(obj.getClass().getResource("tile/downstairs.png"));
        mt.addImage(downstairs, 0);
        parts = tk.getImage(obj.getClass().getResource("tile/parts.png"));
        mt.addImage(parts, 0);
    }

    public static int startup_image(Graphics g, int x, int y, int cx, ImageObserver obs) {
        int n = 0;
        g.drawImage(blank, x, y, obs);
        if ((x += 16) >= cx) {
            x = 0;
            y += 16;
        }
        ++n;
        g.drawImage(wall, x, y, obs);
        if ((x += 16) >= cx) {
            x = 0;
            y += 16;
        }
        ++n;
        g.drawImage(upstairs, x, y, obs);
        if ((x += 16) >= cx) {
            x = 0;
            y += 16;
        }
        ++n;
        g.drawImage(downstairs, x, y, obs);
        if ((x += 16) >= cx) {
            x = 0;
            y += 16;
        }
        ++n;
        g.drawImage(parts, x, y, obs);
        return ++n;
    }

    FloorTile() {
        this.id = 0;
    }

    FloorTile(int n) {
        this.id = n;
    }

    public int get_id() {
        return this.id;
    }

    public void set_id(int n) {
        this.id = n;
    }

    public CHArrayList get_item() {
        return this.item;
    }

    public void draw(Graphics g, int x, int y, Component compo) {
        Image icon;
        if (this.item.size() > 0) {
            icon = parts;
        } else {
            switch (this.id) {
                case 0: {
                    icon = blank;
                    break;
                }
                case 1: {
                    icon = wall;
                    break;
                }
                case 2: {
                    icon = upstairs;
                    break;
                }
                case 3: {
                    icon = downstairs;
                    break;
                }
                default: {
                    icon = null;
                }
            }
        }
        if (icon != null) {
            g.drawImage(icon, x, y, compo);
        }
    }
}

