/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.CarnageHack;
import CarnageHack.OkeSoftChip;
import CarnageHack.OkeSoftChipPanel;
import CarnageHack.OkeSoftData;
import CarnageHack.OkeSoftFilter;
import CarnageHack.OkeSoftPanelEvent;
import CarnageHack.OkeSoftPanelMouseEvent;
import CarnageHack.OkeSoftPanelMouseMotionEvent;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OkeSoftPanel
extends Canvas {
    static Image blank_chip;
    static final Color OuterColor;
    static final Color InnerColor;
    static final Color GreenColor;
    static final Color RedColor;
    OkeSoftData software;
    OkeSoftChipPanel chippanel;
    int mousex;
    int mousey;
    Image mouse_image;
    private static String datadir;
    private static final long serialVersionUID = 20L;

    static void init(Object obj, MediaTracker mt) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        blank_chip = tk.getImage(obj.getClass().getResource("chip/blank.png"));
        mt.addImage(blank_chip, 0);
    }

    OkeSoftPanel(CarnageHack chack, Frame fr, Dialog p, OkeSoftData sd) {
        this.software = sd == null ? new OkeSoftData() : sd;
        this.setSize(288, 288);
        Dialog chiptable = new Dialog(fr, "CHIP TABLE", false);
        OkeSoftPanelEvent pevent = new OkeSoftPanelEvent(chack, fr, chiptable, this, p);
        this.chippanel = new OkeSoftChipPanel(this, p);
        chiptable.add(this.chippanel);
        chiptable.pack();
        chiptable.setLocation(CarnageHack.chiptablepos);
        chiptable.setVisible(true);
        p.addWindowListener(pevent);
        this.addMouseListener(new OkeSoftPanelMouseEvent(this, this.chippanel));
        this.addMouseMotionListener(new OkeSoftPanelMouseMotionEvent(this));
        Button button = new Button(CarnageHack.resource.getString("buttonOK"));
        button.setActionCommand("OK");
        button.addActionListener(pevent);
        p.add((Component)button, "South");
        Label label = new Label(CarnageHack.resource.getString("chipeditInfo"), 1);
        label.setBackground(Color.darkGray);
        label.setForeground(Color.white);
        p.add((Component)label, "North");
    }

    void draw_arrow(Graphics g, int narrow, int x, int y) {
        int npoint;
        int[] pointx = new int[3];
        int[] pointy = new int[3];
        switch (narrow) {
            case 1: {
                pointx[0] = x * 40 + 20;
                pointy[0] = y * 40 + 8;
                pointx[1] = pointx[0] + 8;
                pointy[1] = pointy[0];
                pointx[2] = pointx[0] + 4;
                pointy[2] = y * 40;
                npoint = 3;
                break;
            }
            case 7: {
                pointx[0] = x * 40 + 4;
                pointy[0] = y * 40 + 4;
                pointx[1] = pointx[0] + 8;
                pointy[1] = pointy[0];
                pointx[2] = pointx[0];
                pointy[2] = pointy[0] + 8;
                npoint = 3;
                break;
            }
            case 5: {
                pointx[0] = x * 40 + 40 + 4;
                pointy[0] = y * 40 + 4;
                pointx[1] = pointx[0] - 8;
                pointy[1] = pointy[0];
                pointx[2] = pointx[0];
                pointy[2] = pointy[0] + 8;
                npoint = 3;
                break;
            }
            case 2: {
                pointx[0] = x * 40 + 20;
                pointy[0] = y * 40 + 40;
                pointx[1] = pointx[0] + 8;
                pointy[1] = pointy[0];
                pointx[2] = pointx[0] + 4;
                pointy[2] = y * 40 + 48;
                npoint = 3;
                break;
            }
            case 8: {
                pointx[0] = x * 40 + 4;
                pointy[0] = y * 40 + 40 + 4;
                pointx[1] = pointx[0] + 8;
                pointy[1] = pointy[0];
                pointx[2] = pointx[0];
                pointy[2] = pointy[0] - 8;
                npoint = 3;
                break;
            }
            case 6: {
                pointx[0] = x * 40 + 40 + 4;
                pointy[0] = y * 40 + 40 + 4;
                pointx[1] = pointx[0] - 8;
                pointy[1] = pointy[0];
                pointx[2] = pointx[0];
                pointy[2] = pointy[0] - 8;
                npoint = 3;
                break;
            }
            case 3: {
                pointx[0] = x * 40 + 40;
                pointy[0] = y * 40 + 20;
                pointx[1] = pointx[0];
                pointy[1] = pointy[0] + 8;
                pointx[2] = pointx[0] + 8;
                pointy[2] = pointy[0] + 4;
                npoint = 3;
                break;
            }
            case 4: {
                pointx[0] = x * 40 + 8;
                pointy[0] = y * 40 + 20;
                pointx[1] = pointx[0];
                pointy[1] = pointy[0] + 8;
                pointx[2] = pointx[0] - 8;
                pointy[2] = pointy[0] + 4;
                npoint = 3;
                break;
            }
            default: {
                return;
            }
        }
        g.fillPolygon(pointx, pointy, npoint);
    }

    public void paint(Graphics orgg) {
        Image offscreen = this.createImage(288, 288);
        Graphics g = offscreen.getGraphics();
        g.setColor(OuterColor);
        g.fillRect(0, 0, 288, 288);
        g.setColor(InnerColor);
        g.fillRect(8, 8, 272, 272);
        g.setColor(GreenColor);
        this.draw_arrow(g, 2, 0, -1);
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 7; ++y) {
                OkeSoftChip chip = this.software.get(x, y);
                if (chip != null && !chip.get_id().equals("NONE")) {
                    Image chipimage;
                    if (chip.get_green_arrow() != 0) {
                        g.setColor(GreenColor);
                        this.draw_arrow(g, chip.get_green_arrow(), x, y);
                    }
                    if (chip.get_red_arrow() != 0) {
                        g.setColor(RedColor);
                        this.draw_arrow(g, chip.get_red_arrow(), x, y);
                    }
                    if ((chipimage = this.chippanel.get_chip(chip.get_id())) != null) {
                        g.drawImage(chipimage, x * 40 + 8, y * 40 + 8, this);
                        continue;
                    }
                    g.drawImage(blank_chip, x * 40 + 8, y * 40 + 8, this);
                    continue;
                }
                g.drawImage(blank_chip, x * 40 + 8, y * 40 + 8, this);
            }
        }
        if (this.mouse_image != null) {
            g.drawRect(this.mousex - 1, this.mousey - 1, 34, 34);
            g.drawImage(this.mouse_image, this.mousex, this.mousey, this);
        }
        orgg.drawImage(offscreen, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void set_mouse_image(Image p) {
        this.mouse_image = p;
    }

    public Image get_mouse_image() {
        return this.mouse_image;
    }

    public void set_mouse_position(int x, int y) {
        this.mousex = x;
        this.mousey = y;
    }

    public void plot_chip(int x, int y, String id) {
        int newx = x / 40;
        int newy = y / 40;
        OkeSoftChip chip = this.software.get(newx, newy);
        OkeSoftChip wkchip = new OkeSoftChip(this);
        wkchip.set_id(id);
        if (chip != null && id.equals(chip.get_id())) {
            wkchip.set_param(chip.get_param());
            wkchip.set_green_arrow(chip.get_green_arrow());
            wkchip.set_red_arrow(chip.get_red_arrow());
        }
        if (wkchip.edit(newx, newy, this.software)) {
            this.software.set(newx, newy, wkchip);
            this.repaint();
        }
    }

    public void edit_chip(int x, int y) {
        int newx = x / 40;
        int newy = y / 40;
        OkeSoftChip chip = this.software.get(newx, newy);
        if (chip != null) {
            try {
                OkeSoftChip wkchip = (OkeSoftChip)chip.clone();
                if (wkchip.edit(newx, newy, this.software)) {
                    this.software.set(newx, newy, wkchip);
                    this.repaint();
                }
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(OkeSoftPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void delete_chip(int x, int y) {
        int newx = x / 40;
        int newy = y / 40;
        OkeSoftChip chip = this.software.get(newx, newy);
        if (chip != null) {
            this.software.set(newx, newy, null);
            this.repaint();
        }
    }

    public OkeSoftChip get_chip(int x, int y) {
        int newx = x / 40;
        int newy = y / 40;
        return this.software.get(newx, newy);
    }

    public void copy_chip(int sx, int sy, int tx, int ty) {
        int newsx = sx / 40;
        int newsy = sy / 40;
        int newtx = tx / 40;
        int newty = ty / 40;
        if (newsx != newtx || newsy != newty) {
            try {
                OkeSoftChip wkchip = (OkeSoftChip)this.software.get(newsx, newsy).clone();
                if (!this.software.check_arrow(newtx, newty, wkchip.get_green_arrow())) {
                    wkchip.set_green_arrow(0);
                }
                if (!this.software.check_arrow(newtx, newty, wkchip.get_red_arrow())) {
                    wkchip.set_red_arrow(0);
                }
                this.software.set(newtx, newty, wkchip);
                this.repaint();
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(OkeSoftPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void move_chip(int sx, int sy, int tx, int ty) {
        int newsx = sx / 40;
        int newsy = sy / 40;
        int newtx = tx / 40;
        int newty = ty / 40;
        if (newsx != newtx || newsy != newty) {
            OkeSoftChip wkchip = this.software.get(newsx, newsy);
            this.software.set(newsx, newsy, null);
            this.repaint();
            if (!this.software.check_arrow(newtx, newty, wkchip.get_green_arrow())) {
                wkchip.set_green_arrow(0);
            }
            if (!this.software.check_arrow(newtx, newty, wkchip.get_red_arrow())) {
                wkchip.set_red_arrow(0);
            }
            this.software.set(newtx, newty, wkchip);
            this.repaint();
        }
    }

    public void clear() {
        this.software.clear();
        this.repaint();
    }

    public void save() {
        FileDialog fd = new FileDialog(CarnageHack.getFrame(), "SAVE SOFTWARE", 1);
        fd.setDirectory(datadir);
        fd.setFilenameFilter(new OkeSoftFilter(true));
        fd.setFile(this.software.get_filename());
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname != null) {
            datadir = fd.getDirectory();
            this.software.save(datadir + fname);
        }
    }

    public void load() {
        FileDialog fd = new FileDialog(CarnageHack.getFrame(), "LOAD SOFTWARE", 0);
        fd.setDirectory(datadir);
        fd.setFilenameFilter(new OkeSoftFilter(true));
        fd.setFile(this.software.get_filename());
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname != null) {
            datadir = fd.getDirectory();
            this.software.load(datadir + fname);
            this.repaint();
        }
    }

    public OkeSoftData get_software() {
        return this.software;
    }

    public void resetChipPanel() {
        OkeSoftChipPanel.setLastActiveChip("");
        this.chippanel.repaint();
    }

    public static void setDataDir(String s) {
        datadir = s;
    }

    public static String getDataDir() {
        return datadir;
    }

    static {
        OuterColor = new Color(128, 128, 128);
        InnerColor = new Color(0, 0, 0);
        GreenColor = new Color(0, 255, 0);
        RedColor = new Color(255, 0, 0);
    }
}

