using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Drawing;
using System.Diagnostics;
using System.IO;
using System.Security.Cryptography;
using System.Reflection;
using System.Globalization;
using System.Threading;
//using System.Windows.Forms;
using FDK;

namespace DTXMania
{
	internal class CDTX : CActivity
	{
		// 定数

		public enum E種別 { DTX, GDA, G2D, BMS, BME, SMF }
		public enum Eレーンビットパターン
		{
			OPEN = 0,
			xxB = 1,
			xGx = 2,
			xGB = 3,
			Rxx = 4,
			RxB = 5,
			RGx = 6,
			RGB = 7
		};


		// クラス

		public class CAVI : IDisposable
		{
			public CAvi avi;
			private bool bDispose済み;
			public int n番号;
			public string strコメント文 = "";
			public string strファイル名 = "";

			public void OnDeviceCreated()
			{
				#region [ strAVIファイル名の作成。]
				//-----------------
				string strAVIファイル名;
				if( !string.IsNullOrEmpty( CDTXMania.DTX.PATH_WAV ) )
					strAVIファイル名 = CDTXMania.DTX.PATH_WAV + this.strファイル名;
				else
					strAVIファイル名 = CDTXMania.DTX.strフォルダ名 + this.strファイル名;
				//-----------------
				#endregion

				if( !File.Exists( strAVIファイル名 ) )
				{
					Trace.TraceWarning( "ファイルが存在しません。({0})({1})", this.strコメント文, strAVIファイル名 );
					this.avi = null;
					return;
				}

				// AVI の生成。

				try
				{
					this.avi = new CAvi( strAVIファイル名 );
					Trace.TraceInformation( "動画を生成しました。({0})({1})({2}frames)", this.strコメント文, strAVIファイル名, this.avi.GetMaxFrameCount() );
				}
				catch( Exception e )
				{
					Trace.TraceError( e.Message );
					Trace.TraceError( "動画の生成に失敗しました。({0})({1})", this.strコメント文, strAVIファイル名 );
					this.avi = null;
				}
			}
			public override string ToString()
			{
				return string.Format( "CAVI{0}: File:{1}, Comment:{2}", CDTX.tZZ( this.n番号 ), this.strファイル名, this.strコメント文 );
			}

			#region [ IDisposable 実装 ]
			//-----------------
			public void Dispose()
			{
				if( this.bDispose済み )
					return;

				if( this.avi != null )
				{
					#region [ strAVIファイル名 の作成。 ]
					//-----------------
					string strAVIファイル名;
					if( !string.IsNullOrEmpty( CDTXMania.DTX.PATH_WAV ) )
						strAVIファイル名 = CDTXMania.DTX.PATH_WAV + this.strファイル名;
					else
						strAVIファイル名 = CDTXMania.DTX.strフォルダ名 + this.strファイル名;
					//-----------------
					#endregion

					this.avi.Dispose();
					this.avi = null;
					
					Trace.TraceInformation( "動画を解放しました。({0})({1})", this.strコメント文, strAVIファイル名 );
				}

				this.bDispose済み = true;
			}
			//-----------------
			#endregion
		}
        public class CAVIPAN
		{
			public int nAVI番号;
			public int n移動時間ct;
			public int n番号;
			public Point pt動画側開始位置 = new Point( 0, 0 );
			public Point pt動画側終了位置 = new Point( 0, 0 );
			public Point pt表示側開始位置 = new Point( 0, 0 );
			public Point pt表示側終了位置 = new Point( 0, 0 );
			public Size sz開始サイズ = new Size( 0, 0 );
			public Size sz終了サイズ = new Size( 0, 0 );

			public override string ToString()
			{
				return string.Format( "CAVIPAN{0}: AVI:{14}, 開始サイズ:{1}x{2}, 終了サイズ:{3}x{4}, 動画側開始位置:{5}x{6}, 動画側終了位置:{7}x{8}, 表示側開始位置:{9}x{10}, 表示側終了位置:{11}x{12}, 移動時間:{13}ct",
					CDTX.tZZ( this.n番号 ),
					this.sz開始サイズ.Width, this.sz開始サイズ.Height,
					this.sz終了サイズ.Width, this.sz終了サイズ.Height,
					this.pt動画側開始位置.X, this.pt動画側開始位置.Y,
					this.pt動画側終了位置.X, this.pt動画側終了位置.Y,
					this.pt表示側開始位置.X, this.pt表示側開始位置.Y,
					this.pt表示側終了位置.X, this.pt表示側終了位置.Y,
					this.n移動時間ct,
					CDTX.tZZ( this.nAVI番号 ) );
			}
		}
        public class CDirectShow : IDisposable
		{
			public FDK.CDirectShow dshow;
			private bool bDispose済み;
			public int n番号;
			public string strコメント文 = "";
			public string strファイル名 = "";

			public void OnDeviceCreated()
			{
				#region [ str動画ファイル名の作成。]
				//-----------------
				string str動画ファイル名;
				if( !string.IsNullOrEmpty( CDTXMania.DTX.PATH_WAV ) )
					str動画ファイル名 = CDTXMania.DTX.PATH_WAV + this.strファイル名;
				else
					str動画ファイル名 = CDTXMania.DTX.strフォルダ名 + this.strファイル名;
				//-----------------
				#endregion

				if( !File.Exists( str動画ファイル名 ) )
				{
					Trace.TraceWarning( "ファイルが存在しません。({0})({1})", this.strコメント文, str動画ファイル名 );
					this.dshow = null;
				}

				// AVI の生成。

				try
				{
                    this.dshow = new FDK.CDirectShow( CDTXMania.stage選曲.r確定されたスコア.ファイル情報.フォルダの絶対パス + this.strファイル名, CDTXMania.app.WindowHandle, true);
					Trace.TraceInformation( "DirectShowを生成しました。({0})({1})({2}byte)", this.strコメント文, str動画ファイル名, this.dshow.nデータサイズbyte );
				}
				catch( Exception e )
				{
					Trace.TraceError( e.Message );
					Trace.TraceError( "DirectShowの生成に失敗しました。({0})({1})", this.strコメント文, str動画ファイル名 );
					this.dshow= null;
				}
			}
			public override string ToString()
			{
				return string.Format( "CAVI{0}: File:{1}, Comment:{2}", CDTX.tZZ( this.n番号 ), this.strファイル名, this.strコメント文 );
			}

			#region [ IDisposable 実装 ]
			//-----------------
			public void Dispose()
			{
				if( this.bDispose済み )
					return;

				if( this.dshow != null )
				{
					#region [ strAVIファイル名 の作成。 ]
					//-----------------
					string str動画ファイル名;
					if( !string.IsNullOrEmpty( CDTXMania.DTX.PATH_WAV ) )
						str動画ファイル名 = CDTXMania.DTX.PATH_WAV + this.strファイル名;
					else
						str動画ファイル名 = CDTXMania.DTX.strフォルダ名 + this.strファイル名;
					//-----------------
					#endregion

					this.dshow.Dispose();
					this.dshow = null;
					
					Trace.TraceInformation( "動画を解放しました。({0})({1})", this.strコメント文, str動画ファイル名 );
				}

				this.bDispose済み = true;
			}
			//-----------------
			#endregion
		}

		public class CBPM
		{
			public double dbBPM値;
			public int n内部番号;
			public int n表記上の番号;

			public override string ToString()
			{
				StringBuilder builder = new StringBuilder( 0x80 );
				if( this.n内部番号 != this.n表記上の番号 )
				{
					builder.Append( string.Format( "CBPM{0}(内部{1})", CDTX.tZZ( this.n表記上の番号 ), this.n内部番号 ) );
				}
				else
				{
					builder.Append( string.Format( "CBPM{0}", CDTX.tZZ( this.n表記上の番号 ) ) );
				}
				builder.Append( string.Format( ", BPM:{0}", this.dbBPM値 ) );
				return builder.ToString();
			}
		}
		public class CSCROLL
		{
			public double dbSCROLL値;
			public int n内部番号;
			public int n表記上の番号;

			public override string ToString()
			{
				StringBuilder builder = new StringBuilder( 0x80 );
				if( this.n内部番号 != this.n表記上の番号 )
				{
					builder.Append( string.Format( "CSCROLL{0}(内部{1})", CDTX.tZZ( this.n表記上の番号 ), this.n内部番号 ) );
				}
				else
				{
					builder.Append( string.Format( "CSCROLL{0}", CDTX.tZZ( this.n表記上の番号 ) ) );
				}
				builder.Append( string.Format( ", SCROLL:{0}", this.dbSCROLL値 ) );
				return builder.ToString();
			}
		}

        public class CDELAY
        {
			public int nDELAY値; //格納時にはmsになっているため、doubleにはしない。
			public int n内部番号;
			public int n表記上の番号;

			public override string ToString()
			{
				StringBuilder builder = new StringBuilder( 0x80 );
				if( this.n内部番号 != this.n表記上の番号 )
				{
					builder.Append( string.Format( "CDELAY{0}(内部{1})", CDTX.tZZ( this.n表記上の番号 ), this.n内部番号 ) );
				}
				else
				{
					builder.Append( string.Format( "CDELAY{0}", CDTX.tZZ( this.n表記上の番号 ) ) );
				}
				builder.Append( string.Format( ", DELAY:{0}", this.nDELAY値 ) );
				return builder.ToString();
			}
        }

        public class CBRANCH
        {
            public int n分岐の種類; //0:精度分岐 1:連打分岐 2:スコア分岐 3:大音符のみの精度分岐
            public double n条件数値A;
            public double n条件数値B;
            public double db分岐時間;
            public double db分岐時間ms;
            public double db判定時間;
            public int n現在の小節;
            public int n命令時のChipList番号;

            public int n表記上の番号;
            public int n内部番号;

			public override string ToString()
			{
				StringBuilder builder = new StringBuilder( 0x80 );
				if( this.n内部番号 != this.n表記上の番号 )
				{
					builder.Append( string.Format( "CBRANCH{0}(内部{1})", CDTX.tZZ( this.n表記上の番号 ), this.n内部番号 ) );
				}
				else
				{
					builder.Append( string.Format( "CBRANCH{0}", CDTX.tZZ( this.n表記上の番号 ) ) );
				}
				builder.Append( string.Format( ", BRANCH:{0}", this.n分岐の種類 ) );
				return builder.ToString();
			}
        }


		public class CChip : IComparable<CDTX.CChip>, ICloneable
		{
			public bool bHit;
			public bool b可視 = true;
            public bool bShow;
            public bool bBranch = false;
			public double dbチップサイズ倍率 = 1.0;
			public double db実数値;
            public double dbBPM;
            public double dbSCROLL;
            public int nコース;
            public int nSenote;
            public int nState;
            public int nRollCount;
            public int nBalloon;
            public int nProcessTime;
            public ENoteState eNoteState;
            public EAVI種別 eAVI種別;
			public E楽器パート e楽器パート = E楽器パート.UNKNOWN;
			public int nチャンネル番号;
			public STDGBVALUE<int> nバーからの距離dot;
			public STDGBVALUE<int> nバーからのノーツ末端距離dot;
			public int n整数値;
			public int n整数値・内部番号;
			public int n総移動時間;
			public int n透明度 = 0xff;
			public int n発声位置;
			public float f発声位置;
            public double fBMSCROLLTime;
			public int n発声時刻ms;
            public float f発声時刻ms;
			public int nノーツ終了位置;
			public int nノーツ終了時刻ms;
            public int n分岐回数;
            public int n連打音符State;
			public int nLag;				// 2011.2.1 yyagi
			public CDTX.CAVI rAVI;
            public CDTX.CAVIPAN rAVIPan;
            public CDTX.CDirectShow rDShow;
			public bool bBPMチップである
			{
				get
				{
					if (this.nチャンネル番号 == 3 || this.nチャンネル番号 == 8) {
						return true;
					} else {
						return false;
					}
				}
			}
			public bool bWAVを使うチャンネルである
			{
				get
				{
					switch( this.nチャンネル番号 )
					{
						case 0x01:
						case 0x11:
						case 0x12:
						case 0x13:
						case 0x14:
						case 0x15:
						case 0x16:
						case 0x17:
						case 0x18:
						case 0x19:
						case 0x1a:
                        case 0x1b:
                        case 0x1c:
						case 0x1f:
						case 0x20:
						case 0x21:
						case 0x22:
						case 0x23:
						case 0x24:
						case 0x25:
						case 0x26:
						case 0x27:
						case 0x2f:
						case 0x31:
						case 0x32:
						case 0x33:
						case 0x34:
						case 0x35:
						case 0x36:
						case 0x37:
						case 0x38:
						case 0x39:
						case 0x3a:
						case 0x61:
						case 0x62:
						case 0x63:
						case 0x64:
						case 0x65:
						case 0x66:
						case 0x67:
						case 0x68:
						case 0x69:
						case 0x70:
						case 0x71:
						case 0x72:
						case 0x73:
						case 0x74:
						case 0x75:
						case 0x76:
						case 0x77:
						case 0x78:
						case 0x79:
						case 0x80:
						case 0x81:
						case 0x82:
						case 0x83:
						case 0x84:
						case 0x85:
						case 0x86:
						case 0x87:
						case 0x88:
						case 0x89:
						case 0x90:
						case 0x91:
						case 0x92:
						case 0xa0:
						case 0xa1:
						case 0xa2:
						case 0xa3:
						case 0xa4:
						case 0xa5:
						case 0xa6:
						case 0xa7:
						case 0xaf:
						case 0xb1:
						case 0xb2:
						case 0xb3:
						case 0xb4:
						case 0xb5:
						case 0xb6:
						case 0xb7:
						case 0xb8:
						case 0xb9:
						case 0xba:
						case 0xbb:
						case 0xbc:
							return true;
					}
					return false;
				}
			}
			public bool b自動再生音チャンネルである
			{
				get
				{
					int num = this.nチャンネル番号;
					if( ( ( ( num != 1 ) && ( ( 0x61 > num ) || ( num > 0x69 ) ) ) && ( ( 0x70 > num ) || ( num > 0x79 ) ) ) && ( ( 0x80 > num ) || ( num > 0x89 ) ) )
					{
						return ( ( 0x90 <= num ) && ( num <= 0x92 ) );
					}
					return true;
				}
			}
			public bool bIsAutoPlayed;							// 2011.6.10 yyagi
			public bool b演奏終了後も再生が続くチップである;	// #32248 2013.10.14 yyagi

			public CChip()
			{
				this.nバーからの距離dot = new STDGBVALUE<int>() {
					Drums = 0,
					Guitar = 0,
					Bass = 0,
				};
			}
			public void t初期化()
			{
                this.bBranch = false;
				this.nチャンネル番号 = 0;
				this.n整数値 = 0;
				this.n整数値・内部番号 = 0;
				this.db実数値 = 0.0;
				this.n発声位置 = 0;
                this.f発声位置 = 0.0f;
				this.n発声時刻ms = 0;
                this.f発声時刻ms = 0.0f;
                this.fBMSCROLLTime = 0;
                this.nノーツ終了位置 = 0;
                this.nノーツ終了時刻ms = 0;
				this.nLag = -999;
				this.bIsAutoPlayed = false;
				this.b演奏終了後も再生が続くチップである = false;
				this.dbチップサイズ倍率 = 1.0;
				this.bHit = false;
				this.b可視 = true;
				this.e楽器パート = E楽器パート.UNKNOWN;
				this.n透明度 = 0xff;
				this.nバーからの距離dot.Drums = 0;
				this.nバーからの距離dot.Guitar = 0;
				this.nバーからの距離dot.Bass = 0;
                this.nバーからの距離dot.Taiko = 0;
                this.nバーからのノーツ末端距離dot.Drums = 0;
                this.nバーからのノーツ末端距離dot.Guitar = 0;
                this.nバーからのノーツ末端距離dot.Bass = 0;
                this.nバーからのノーツ末端距離dot.Taiko = 0;
				this.n総移動時間 = 0;
                this.dbBPM = 120.0;
			}
			public override string ToString()
			{
				string[] chToStr = 
				{
					"??", "バックコーラス", "小節長変更", "BPM変更", "BMPレイヤ1", "??", "??", "BMPレイヤ2",
					"BPM変更(拡張)", "??", "??", "??", "??", "??", "??", "??",
					"??", "HHClose", "Snare", "Kick", "HiTom", "LowTom", "Cymbal", "FloorTom",
					"HHOpen", "RideCymbal", "LeftCymbal", "LeftPedal", "LeftBD", "", "", "ドラム歓声切替",
					"ギターOPEN", "ギター - - B", "ギター - G -", "ギター - G B", "ギター R - -", "ギター R - B", "ギター R G -", "ギター R G B",
					"ギターWailing", "??", "??", "??", "??", "??", "??", "ギターWailing音切替",
					"??", "HHClose(不可視)", "Snare(不可視)", "Kick(不可視)", "HiTom(不可視)", "LowTom(不可視)", "Cymbal(不可視)", "FloorTom(不可視)",
					"HHOpen(不可視)", "RideCymbal(不可視)", "LeftCymbal(不可視)", "??", "??", "??", "??", "??",
					"??", "??", "??", "??", "??", "??", "??", "??", 
					"??", "??", "??", "??", "??", "??", "??", "??", 
					"小節線", "拍線", "MIDIコーラス", "フィルイン", "AVI", "BMPレイヤ3", "BMPレイヤ4", "BMPレイヤ5",
					"BMPレイヤ6", "BMPレイヤ7", "??", "??", "??", "??", "??", "??", 
					"BMPレイヤ8", "SE01", "SE02", "SE03", "SE04", "SE05", "SE06", "SE07",
					"SE08", "SE09", "??", "??", "??", "??", "??", "??", 
					"SE10", "SE11", "SE12", "SE13", "SE14", "SE15", "SE16", "SE17",
					"SE18", "SE19", "??", "??", "??", "??", "??", "??", 
					"SE20", "SE21", "SE22", "SE23", "SE24", "SE25", "SE26", "SE27",
					"SE28", "SE29", "??", "??", "??", "??", "??", "??", 
					"SE30", "SE31", "SE32", "太鼓_赤", "太鼓_青", "太鼓_赤(大)", "太鼓_青(大)", "太鼓_黄", 
					"太鼓_黄(大)", "太鼓_風船", "太鼓_連打末端", "太鼓_芋", "??", "SCROLL", "ゴーゴータイム開始", "ゴーゴータイム終了", 
					"ベースOPEN", "ベース - - B", "ベース - G -", "ベース - G B", "ベース R - -", "ベース R - B", "ベース R G -", "ベース R G B",
					"ベースWailing", "??", "??", "??", "??", "??", "??", "ベースWailing音切替",
					"??", "HHClose(空うち)", "Snare(空うち)", "Kick(空うち)", "HiTom(空うち)", "LowTom(空うち)", "Cymbal(空うち)", "FloorTom(空うち)",
					"HHOpen(空うち)", "RideCymbal(空うち)", "ギター(空打ち)", "ベース(空打ち)", "LeftCymbal(空うち)", "??", "??", "??", 
					"??", "??", "??", "??", "BGAスコープ画像切替1", "0xC5", "0xC6", "BGAスコープ画像切替2",
					"??", "??", "0xCA", "??", "??", "??", "??", "0xCF", 
					"0xD0", "??", "??", "??", "??", "BGAスコープ画像切替3", "BGAスコープ画像切替4", "BGAスコープ画像切替5",
					"BGAスコープ画像切替6", "BGAスコープ画像切替7", "0xDA", "0xDB", "DELAY", "譜面分岐リセット", "譜面分岐スタート", "??", 
					"BGAスコープ画像切替8", "0xE1"
				};
				return string.Format( "CChip: 位置:{0:D4}.{1:D3}, 時刻{2:D6}, Ch:{3:X2}({4}), Pn:{5}({11})(内部{6}), Pd:{7}, Sz:{8}, UseWav:{9}, Auto:{10}, コース:{11}",
					this.n発声位置 / 384, this.n発声位置 % 384,
					this.n発声時刻ms,
					this.nチャンネル番号, chToStr[ this.nチャンネル番号 ],
					this.n整数値, this.n整数値・内部番号,
					this.db実数値,
					this.dbチップサイズ倍率,
					this.bWAVを使うチャンネルである,
					this.b自動再生音チャンネルである,
                    this.nコース,
					CDTX.tZZ( this.n整数値 ) );
			}
			/// <summary>
			/// チップの再生長を取得する。現状、WAVチップとBGAチップでのみ使用可能。
			/// </summary>
			/// <returns>再生長(ms)</returns>
			public int GetDuration()
			{
				int nDuration = 0;

				if ( this.bWAVを使うチャンネルである )		// WAV
				{
					CDTX.CWAV wc;
					CDTXMania.DTX.listWAV.TryGetValue( this.n整数値・内部番号, out wc );
					if ( wc == null )
					{
						nDuration = 0;
					}
					else
					{
						nDuration = ( wc.rSound[ 0 ] == null ) ? 0 : wc.rSound[ 0 ].n総演奏時間ms;
					}
				}
				else if ( this.nチャンネル番号 == 0x54 )	// AVI
				{
					if ( this.rAVI != null && this.rAVI.avi != null )
					{
						int dwRate = (int) this.rAVI.avi.dwレート;
						int dwScale = (int) this.rAVI.avi.dwスケール;
						nDuration = (int) ( 1000.0f * dwScale / dwRate * this.rAVI.avi.GetMaxFrameCount() );
					}
				}

				double _db再生速度 = ( CDTXMania.DTXVmode.Enabled ) ? CDTXMania.DTX.dbDTXVPlaySpeed : CDTXMania.DTX.db再生速度;
				return (int) ( nDuration / _db再生速度 );
			}

			#region [ IComparable 実装 ]
			//-----------------
			public int CompareTo( CDTX.CChip other )
			{
				byte[] n優先度 = new byte[] {
					5, 5, 3, 7, 5, 5, 5, 5, 3, 5, 5, 5, 5, 5, 5, 5, //0x00
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0x10
					7, 7, 7, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 5, 5, 5, //0x20
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0x30
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0x40
					9, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0x50
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0x60
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0x70
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0x80
					5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 3, 3, 3, //0x90
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0xA0
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0xB0
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0xC0
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 5, //0xD0
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0xE0
					5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, //0xF0
				};


				// まずは位置で比較。

				if( this.n発声位置 < other.n発声位置 )
					return -1;

				if( this.n発声位置 > other.n発声位置 )
					return 1;


				// 位置が同じなら優先度で比較。

				if( n優先度[ this.nチャンネル番号 ] < n優先度[ other.nチャンネル番号 ] )
					return -1;

				if( n優先度[ this.nチャンネル番号 ] > n優先度[ other.nチャンネル番号 ] )
					return 1;


				// 位置も優先度も同じなら同じと返す。

				return 0;
			}
			//-----------------
			#endregion
			/// <summary>
			/// shallow copyです。
			/// </summary>
			/// <returns></returns>
			public object Clone()
			{
				return MemberwiseClone();
			}
		}
		public class CWAV : IDisposable
		{
			public bool bBGMとして使う;
			public List<int> listこのWAVを使用するチャンネル番号の集合 = new List<int>( 16 );
			public int nチップサイズ = 100;
			public int n位置;
			public long[] n一時停止時刻 = new long[ CDTXMania.ConfigIni.nPoliphonicSounds ];	// 4
			public int n音量 = 100;
			public int n現在再生中のサウンド番号;
			public long[] n再生開始時刻 = new long[ CDTXMania.ConfigIni.nPoliphonicSounds ];	// 4
			public int n内部番号;
			public int n表記上の番号;
			public CSound[] rSound = new CSound[ CDTXMania.ConfigIni.nPoliphonicSounds ];		// 4
			public string strコメント文 = "";
			public string strファイル名 = "";
			public bool bBGMとして使わない
			{
				get
				{
					return !this.bBGMとして使う;
				}
				set
				{
					this.bBGMとして使う = !value;
				}
			}
			public bool bIsBassSound = false;
			public bool bIsGuitarSound = false;
			public bool bIsDrumsSound = false;
			public bool bIsSESound = false;
			public bool bIsBGMSound = false;

			public override string ToString()
			{
				var sb = new StringBuilder( 128 );
				
				if( this.n表記上の番号 == this.n内部番号 )
				{
					sb.Append( string.Format( "CWAV{0}: ", CDTX.tZZ( this.n表記上の番号 ) ) );
				}
				else
				{
					sb.Append( string.Format( "CWAV{0}(内部{1}): ", CDTX.tZZ( this.n表記上の番号 ), this.n内部番号 ) );
				}
				sb.Append( string.Format( "音量:{0}, 位置:{1}, サイズ:{2}, BGM:{3}, File:{4}, Comment:{5}", this.n音量, this.n位置, this.nチップサイズ, this.bBGMとして使う ? 'Y' : 'N', this.strファイル名, this.strコメント文 ) );
				
				return sb.ToString();
			}

			#region [ Dispose-Finalize パターン実装 ]
			//-----------------
			public void Dispose()
			{
				this.Dispose( true );
				GC.SuppressFinalize( this );
			}
			public void Dispose( bool bManagedリソースの解放も行う )
			{
				if( this.bDisposed済み )
					return;

				if( bManagedリソースの解放も行う )
				{
					for ( int i = 0; i < CDTXMania.ConfigIni.nPoliphonicSounds; i++ )	// 4
					{
						if( this.rSound[ i ] != null )
							CDTXMania.Sound管理.tサウンドを破棄する( this.rSound[ i ] );
						this.rSound[ i ] = null;

						if( ( i == 0 ) && CDTXMania.ConfigIni.bLog作成解放ログ出力 )
							Trace.TraceInformation( "サウンドを解放しました。({0})({1})", this.strコメント文, this.strファイル名 );
					}
				}

				this.bDisposed済み = true;
			}
			~CWAV()
			{
				this.Dispose( false );
			}
			//-----------------
			#endregion

			#region [ private ]
			//-----------------
			private bool bDisposed済み;
			//-----------------
			#endregion
		}
		

		// 構造体

		public struct STLANEINT
		{
			public int HH;
			public int SD;
			public int BD;
			public int HT;
			public int LT;
			public int CY;
			public int FT;
			public int HHO;
			public int RD;
			public int LC;
            public int LP;
            public int LBD;

			public int Drums
			{
				get
				{
					return this.HH + this.SD + this.BD + this.HT + this.LT + this.CY + this.FT + this.HHO + this.RD + this.LC + this.LP + this.LBD;
				}
			}
			public int Guitar;
			public int Bass;
            public int Taiko_Red;
            public int Taiko_Blue;

			public int this[ int index ]
			{
				get
				{
					switch( index )
					{
						case 0:
							return this.HH;

						case 1:
							return this.SD;

						case 2:
							return this.BD;

						case 3:
							return this.HT;

						case 4:
							return this.LT;

						case 5:
							return this.CY;

						case 6:
							return this.FT;

						case 7:
							return this.HHO;

						case 8:
							return this.RD;

						case 9:
							return this.LC;

						case 10:
                            return this.LP;

						case 11:
							return this.LBD;

						case 12:
							return this.Guitar;

						case 13:
							return this.Bass;

                        case 14:
                            return this.Taiko_Red;

                        case 15:
                            return this.Taiko_Blue;
					}
					throw new IndexOutOfRangeException();
				}
				set
				{
					if( value < 0 )
					{
						throw new ArgumentOutOfRangeException();
					}
					switch( index )
					{
						case 0:
							this.HH = value;
							return;

						case 1:
							this.SD = value;
							return;

						case 2:
							this.BD = value;
							return;

						case 3:
							this.HT = value;
							return;

						case 4:
							this.LT = value;
							return;

						case 5:
							this.CY = value;
							return;

						case 6:
							this.FT = value;
							return;

						case 7:
							this.HHO = value;
							return;

						case 8:
							this.RD = value;
							return;

						case 9:
							this.LC = value;
							return;

						case 10:
							this.LP = value;
							return;

						case 11:
							this.LBD = value;
							return;

						case 12:
							this.Guitar = value;
							return;

						case 13:
							this.Bass = value;
							return;

                        case 14:
                            this.Taiko_Red = value;
                            return;

                        case 15:
                            this.Taiko_Blue = value;
                            return;
					}
					throw new IndexOutOfRangeException();
				}
			}
		}
		public struct STRESULT
		{
			public string SS;
			public string S;
			public string A;
			public string B;
			public string C;
			public string D;
			public string E;

			public string this[ int index ]
			{
				get
				{
					switch( index )
					{
						case 0:
							return this.SS;

						case 1:
							return this.S;

						case 2:
							return this.A;

						case 3:
							return this.B;

						case 4:
							return this.C;

						case 5:
							return this.D;

						case 6:
							return this.E;
					}
					throw new IndexOutOfRangeException();
				}
				set
				{
					switch( index )
					{
						case 0:
							this.SS = value;
							return;

						case 1:
							this.S = value;
							return;

						case 2:
							this.A = value;
							return;

						case 3:
							this.B = value;
							return;

						case 4:
							this.C = value;
							return;

						case 5:
							this.D = value;
							return;

						case 6:
							this.E = value;
							return;
					}
					throw new IndexOutOfRangeException();
				}
			}
		}
		public struct STチップがある
		{
			public bool Drums;
			public bool Guitar;
			public bool Bass;

			public bool HHOpen;
			public bool Ride;
			public bool LeftCymbal;
			public bool OpenGuitar;
			public bool OpenBass;

            public bool Branch;
			
			public bool this[ int index ]
			{
				get
				{
					switch( index )
					{
						case 0:
							return this.Drums;

						case 1:
							return this.Guitar;

						case 2:
							return this.Bass;

						case 3:
							return this.HHOpen;

						case 4:
							return this.Ride;

						case 5:
							return this.LeftCymbal;

						case 6:
							return this.OpenGuitar;

						case 7:
							return this.OpenBass;

                        case 8:
                            return this.Branch;
					}
					throw new IndexOutOfRangeException();
				}
				set
				{
					switch( index )
					{
						case 0:
							this.Drums = value;
							return;

						case 1:
							this.Guitar = value;
							return;

						case 2:
							this.Bass = value;
							return;

						case 3:
							this.HHOpen = value;
							return;

						case 4:
							this.Ride = value;
							return;

						case 5:
							this.LeftCymbal = value;
							return;

						case 6:
							this.OpenGuitar = value;
							return;

						case 7:
							this.OpenBass = value;
							return;

                        case 8:
                            this.Branch = value;
                            return;
					}
					throw new IndexOutOfRangeException();
				}
			}
		}


		// プロパティ

		public int nBGMAdjust
		{
			get; 
			private set;
		}
		public string ARTIST;
		public string BACKGROUND;
		public string BACKGROUND_GR;
		public double BASEBPM;
		public bool BLACKCOLORKEY;
		public double BPM;
		public STチップがある bチップがある;
		public string COMMENT;
		public double db再生速度;
		public E種別 e種別;
		public string GENRE;
		public bool HIDDENLEVEL;
		public STDGBVALUE<int> LEVEL;
		public Dictionary<int, CAVI> listAVI;
        public Dictionary<int, CAVIPAN> listAVIPAN;
        public Dictionary<int, CDirectShow> listDS;
		public Dictionary<int, CBPM> listBPM;
		public List<CChip> listChip;
		public Dictionary<int, CWAV> listWAV;
		public Dictionary<int, CSCROLL> listSCROLL;
		public Dictionary<int, CSCROLL> listSCROLL_Normal;
		public Dictionary<int, CSCROLL> listSCROLL_Expert;
		public Dictionary<int, CSCROLL> listSCROLL_Master;

        private int listSCROLL_Normal_数値管理;
        private int listSCROLL_Expert_数値管理;
        private int listSCROLL_Master_数値管理;

        private double dbNowSCROLL_Normal;
        private double dbNowSCROLL_Expert;
        private double dbNowSCROLL_Master;


        public Dictionary<int, CDELAY> listDELAY;
        public Dictionary<int, CBRANCH> listBRANCH;
		public string MIDIFILE;
		public int MIDIレベル;
		public STLANEINT n可視チップ数;
		public const int n最大音数 = 4;
		public const int n小節の解像度 = 384;
		public string PANEL;
		public string PATH_WAV;
		public string PREIMAGE;
		public string PREMOVIE;
		public string PREVIEW;
		public string STAGEFILE;
		public string strハッシュofDTXファイル;
		public string strファイル名;
		public string strファイル名の絶対パス;
		public string strフォルダ名;
		public string TITLE;
		public double dbDTXVPlaySpeed;
        public double dbScrollSpeed;
        public int nデモBGMオフセット;

        public double fNowTime = 0.0;
        public double fNowBMScrollTime = 0.0;

        private int n現在の小節数 = 1;
        private bool bBarLine = true;
        private int n命令数 = 0;
        private string[] strSplitした後の譜面; //0:ヘッダー情報 1:#START以降 となる。個数の定義は後からされるため、ここでは省略。
        private string[] strSplitしたヘッダ;
        private string[] strSplitした譜面;

        private int nNowRoll = 0;
        private int nNowRollCount = 0;

        private int n現在処理中のListChip番号 = 0;
        private int[] n連打チップ_temp = new int[3];

        //まさか時間軸に影響がある命令を譜面分岐先でバラバラに使おうという酔狂な人は居ないだろうから、一応SCROLLだけでいいか。
        private double[] dbSCROLL_temp = new double[3];

        private int nCount = 0;

        private int nOFFSET = 0;
        private bool bOFFSETの値がマイナスである = false;
        private double dbNowBPM = 120.0;
        private double dbNowSCROLL = 1.0;
        private int nDELAY = 0;

        //分岐関連
        private int n現在の発声時刻;
        private int n現在の発声時刻ms;
        private int n現在のコース;

        private bool b最初の分岐である;
        public int[] nノーツ数 = new int[ 4 ]; //0～2:各コース 3:共通
        private bool b次の小節が分岐である;

        private string strTemp;
        private int n文字数;
        private bool b直前の行に小節末端定義が無かった = false;
        private int n命令行のチップ番号_temp = 0;
        private int nDTXTime_temp = 0;


        public int nScoreMode;
        public int[] nScoreInit = new int[ 2 ];
        public int nScoreDiff;

        private double dbBarLength;


        //Normal Regular Masterにしたいけどここは我慢。
        private List<int> listBalloon_Normal;
        private List<int> listBalloon_Expert;
        private List<int> listBalloon_Master;

        private int listBalloon_Normal_数値管理;
        private int listBalloon_Expert_数値管理;
        private int listBalloon_Master_数値管理;

        public bool[] b譜面が存在する = new bool[5];



        public string strBGM_PATH;


#if TEST_NOTEOFFMODE
		public STLANEVALUE<bool> b演奏で直前の音を消音する;
//		public bool bHH演奏で直前のHHを消音する;
//		public bool bGUITAR演奏で直前のGUITARを消音する;
//		public bool bBASS演奏で直前のBASSを消音する;
#endif
		// コンストラクタ

		public CDTX()
		{
			this.TITLE = "";
			this.ARTIST = "";
			this.COMMENT = "";
			this.PANEL = "";
			this.GENRE = "";
			this.PREVIEW = "";
			this.PREIMAGE = "";
			this.PREMOVIE = "";
			this.STAGEFILE = "";
			this.BACKGROUND = "";
			this.BACKGROUND_GR = "";
			this.PATH_WAV = "";
			this.MIDIFILE = "";
			this.BPM = 120.0;
			this.BLACKCOLORKEY = true;
			STDGBVALUE<int> stdgbvalue = new STDGBVALUE<int>();
			stdgbvalue.Drums = 0;
			stdgbvalue.Guitar = 0;
			stdgbvalue.Bass = 0;
			this.LEVEL = stdgbvalue;
			this.db再生速度 = 1.0;
			this.strハッシュofDTXファイル = "";
			this.bチップがある = new STチップがある();
			this.bチップがある.Drums = false;
			this.bチップがある.Guitar = false;
			this.bチップがある.Bass = false;
			this.bチップがある.HHOpen = false;
			this.bチップがある.Ride = false;
			this.bチップがある.LeftCymbal = false;
			this.bチップがある.OpenGuitar = false;
			this.bチップがある.OpenBass = false;
			this.strファイル名 = "";
			this.strフォルダ名 = "";
			this.strファイル名の絶対パス = "";
			this.n無限管理WAV = new int[ 36 * 36 ];
			this.n無限管理BPM = new int[ 36 * 36 ];
			this.n無限管理VOL = new int[ 36 * 36 ];
			this.n無限管理PAN = new int[ 36 * 36 ];
			this.n無限管理SIZE = new int[ 36 * 36 ];
            this.listBalloon_Normal_数値管理 = 0;
            this.listBalloon_Expert_数値管理 = 0;
            this.listBalloon_Master_数値管理 = 0;
			this.nRESULTIMAGE用優先順位 = new int[ 7 ];
			this.nRESULTMOVIE用優先順位 = new int[ 7 ];
			this.nRESULTSOUND用優先順位 = new int[ 7 ];

			#region [ 2011.1.1 yyagi GDA->DTX変換テーブル リファクタ後 ]
			STGDAPARAM[] stgdaparamArray = new STGDAPARAM[] {		// GDA->DTX conversion table
				new STGDAPARAM("TC", 0x03),	new STGDAPARAM("BL", 0x02),	new STGDAPARAM("GS", 0x29),
				new STGDAPARAM("DS", 0x30),	new STGDAPARAM("FI", 0x53),	new STGDAPARAM("HH", 0x11),
				new STGDAPARAM("SD", 0x12),	new STGDAPARAM("BD", 0x13),	new STGDAPARAM("HT", 0x14),
				new STGDAPARAM("LT", 0x15),	new STGDAPARAM("CY", 0x16),	new STGDAPARAM("G1", 0x21),
				new STGDAPARAM("G2", 0x22),	new STGDAPARAM("G3", 0x23),	new STGDAPARAM("G4", 0x24),
				new STGDAPARAM("G5", 0x25),	new STGDAPARAM("G6", 0x26),	new STGDAPARAM("G7", 0x27),
				new STGDAPARAM("GW", 0x28),	new STGDAPARAM("01", 0x61),	new STGDAPARAM("02", 0x62),
				new STGDAPARAM("03", 0x63),	new STGDAPARAM("04", 0x64),	new STGDAPARAM("05", 0x65),
				new STGDAPARAM("06", 0x66),	new STGDAPARAM("07", 0x67),	new STGDAPARAM("08", 0x68),
				new STGDAPARAM("09", 0x69),	new STGDAPARAM("0A", 0x70),	new STGDAPARAM("0B", 0x71),
				new STGDAPARAM("0C", 0x72),	new STGDAPARAM("0D", 0x73),	new STGDAPARAM("0E", 0x74),
				new STGDAPARAM("0F", 0x75),	new STGDAPARAM("10", 0x76),	new STGDAPARAM("11", 0x77),
				new STGDAPARAM("12", 0x78),	new STGDAPARAM("13", 0x79),	new STGDAPARAM("14", 0x80),
				new STGDAPARAM("15", 0x81),	new STGDAPARAM("16", 0x82),	new STGDAPARAM("17", 0x83),
				new STGDAPARAM("18", 0x84),	new STGDAPARAM("19", 0x85),	new STGDAPARAM("1A", 0x86),
				new STGDAPARAM("1B", 0x87),	new STGDAPARAM("1C", 0x88),	new STGDAPARAM("1D", 0x89),
				new STGDAPARAM("1E", 0x90),	new STGDAPARAM("1F", 0x91),	new STGDAPARAM("20", 0x92),
				new STGDAPARAM("B1", 0xA1),	new STGDAPARAM("B2", 0xA2),	new STGDAPARAM("B3", 0xA3),
				new STGDAPARAM("B4", 0xA4),	new STGDAPARAM("B5", 0xA5),	new STGDAPARAM("B6", 0xA6),
				new STGDAPARAM("B7", 0xA7),	new STGDAPARAM("BW", 0xA8),	new STGDAPARAM("G0", 0x20),
				new STGDAPARAM("B0", 0xA0)
			};
			this.stGDAParam = stgdaparamArray;
			#endregion
			this.nBGMAdjust = 0;
			this.nPolyphonicSounds = CDTXMania.ConfigIni.nPoliphonicSounds;
			this.dbDTXVPlaySpeed = 1.0f;

            this.nScoreMode = 1;
            this.nScoreInit[ 0 ] = 300;
            this.nScoreInit[ 1 ] = 1000;
            this.nScoreDiff = 120;

            this.dbBarLength = 1.0;

            this.b最初の分岐である = true;
            this.b次の小節が分岐である = false;

#if TEST_NOTEOFFMODE
			this.bHH演奏で直前のHHを消音する = true;
			this.bGUITAR演奏で直前のGUITARを消音する = true;
			this.bBASS演奏で直前のBASSを消音する = true;
#endif
	
		}
		public CDTX( string str全入力文字列 )
			: this()
		{
			this.On活性化();
			this.t入力・全入力文字列から( str全入力文字列 );
		}
		public CDTX( string strファイル名, bool bヘッダのみ )
			: this()
		{
			this.On活性化();
			this.t入力( strファイル名, bヘッダのみ );
		}
		public CDTX( string str全入力文字列, double db再生速度, int nBGMAdjust )
			: this()
		{
			this.On活性化();
			this.t入力・全入力文字列から( str全入力文字列, str全入力文字列, db再生速度, nBGMAdjust );
		}
		public CDTX( string strファイル名, bool bヘッダのみ, double db再生速度, int nBGMAdjust )
			: this()
		{
			this.On活性化();
			this.t入力( strファイル名, bヘッダのみ, db再生速度, nBGMAdjust );
		}
		public CDTX( string strファイル名, bool bヘッダのみ, double db再生速度, int nBGMAdjust, int nコース )
			: this()
		{
			this.On活性化();
			this.t入力( strファイル名, bヘッダのみ, db再生速度, nBGMAdjust );
		}


		// メソッド

		public int nモニタを考慮した音量( E楽器パート part )
		{
			CConfigIni configIni = CDTXMania.ConfigIni;
			switch( part )
			{
				case E楽器パート.DRUMS:
					if( configIni.b演奏音を強調する.Drums )
					{
						return configIni.n自動再生音量;
					}
					return configIni.n手動再生音量;

				case E楽器パート.GUITAR:
					if( configIni.b演奏音を強調する.Guitar )
					{
						return configIni.n自動再生音量;
					}
					return configIni.n手動再生音量;

				case E楽器パート.BASS:
					if( configIni.b演奏音を強調する.Bass )
					{
						return configIni.n自動再生音量;
					}
					return configIni.n手動再生音量;
			}
			if( ( !configIni.b演奏音を強調する.Drums && !configIni.b演奏音を強調する.Guitar ) && !configIni.b演奏音を強調する.Bass )
			{
				return configIni.n手動再生音量;
			}
			return configIni.n自動再生音量;
		}
		public void tAVIの読み込み()
		{
			if( this.listAVI != null )
			{
				foreach( CAVI cavi in this.listAVI.Values )
				{
					cavi.OnDeviceCreated();
				}
			}
            if( this.listDS != null)
            {
                foreach( CDirectShow cds in this.listDS.Values)
                {
                    cds.OnDeviceCreated();
                }
            }
			if( !this.bヘッダのみ )//&& this.b動画読み込み )
			{
				foreach( CChip chip in this.listChip )
				{
					if( chip.nチャンネル番号 == 0x54 || chip.nチャンネル番号 == 0x5A )
					{
						chip.eAVI種別 = EAVI種別.Unknown;
						chip.rAVI = null;
                        chip.rDShow = null;
						chip.rAVIPan = null;
						if( this.listAVIPAN.ContainsKey( chip.n整数値 ) )
						{
							CAVIPAN cavipan = this.listAVIPAN[ chip.n整数値 ];
							if( this.listAVI.ContainsKey( cavipan.nAVI番号 ) && ( this.listAVI[ cavipan.nAVI番号 ].avi != null ) )
							{
								chip.eAVI種別 = EAVI種別.AVIPAN;
								chip.rAVI = this.listAVI[ cavipan.nAVI番号 ];
                                //if( CDTXMania.ConfigIni.bDirectShowMode == true )
                                    chip.rDShow = this.listDS[ cavipan.nAVI番号 ];
								chip.rAVIPan = cavipan;
								continue;
							}
						}
						if( this.listAVI.ContainsKey( chip.n整数値 ) && ( this.listAVI[ chip.n整数値 ].avi != null ) || ( this.listDS.ContainsKey( chip.n整数値 ) && ( this.listDS[ chip.n整数値 ].dshow != null ) ) )
						{
							chip.eAVI種別 = EAVI種別.AVI;
							chip.rAVI = this.listAVI[ chip.n整数値 ];
                            //if(CDTXMania.ConfigIni.bDirectShowMode == true)
                                chip.rDShow = this.listDS[ chip.n整数値 ];
						}
					}
				}
			}
		}

		public void tWave再生位置自動補正()
		{
			foreach( CWAV cwav in this.listWAV.Values )
			{
				this.tWave再生位置自動補正( cwav );
			}
		}
		public void tWave再生位置自動補正( CWAV wc )
		{
			if ( wc.rSound[ 0 ] != null && wc.rSound[ 0 ].n総演奏時間ms >= 5000 )
			{
				for ( int i = 0; i < nPolyphonicSounds; i++ )
				{
					if ( ( wc.rSound[ i ] != null ) && ( wc.rSound[ i ].b再生中 ) )
					{
						long nCurrentTime = CSound管理.rc演奏用タイマ.nシステム時刻ms;
						if ( nCurrentTime > wc.n再生開始時刻[ i ] )
						{
							long nAbsTimeFromStartPlaying = nCurrentTime - wc.n再生開始時刻[ i ];
							//Trace.TraceInformation( "再生位置自動補正: {0}, seek先={1}ms, 全音長={2}ms",
							//    Path.GetFileName( wc.rSound[ 0 ].strファイル名 ),
							//    nAbsTimeFromStartPlaying,
							//    wc.rSound[ 0 ].n総演奏時間ms
							//);
							// wc.rSound[ i ].t再生位置を変更する( wc.rSound[ i ].t時刻から位置を返す( nAbsTimeFromStartPlaying ) );
							wc.rSound[ i ].t再生位置を変更する( nAbsTimeFromStartPlaying );	// WASAPI/ASIO用
						}
					}
				}
			}
		}
		public void tWavの再生停止( int nWaveの内部番号 )
		{
			tWavの再生停止( nWaveの内部番号, false );
		}
		public void tWavの再生停止( int nWaveの内部番号, bool bミキサーからも削除する )
		{
			if( this.listWAV.ContainsKey( nWaveの内部番号 ) )
			{
				CWAV cwav = this.listWAV[ nWaveの内部番号 ];
				for ( int i = 0; i < nPolyphonicSounds; i++ )
				{
					if( cwav.rSound[ i ] != null && cwav.rSound[ i ].b再生中 )
					{
						if ( bミキサーからも削除する )
						{
							cwav.rSound[ i ].tサウンドを停止してMixerからも削除する();
						}
						else
						{
							cwav.rSound[ i ].t再生を停止する();
						}
					}
				}
			}
		}
		public void tWAVの読み込み( CWAV cwav )
		{
//			Trace.TraceInformation("WAV files={0}", this.listWAV.Count);
//			int count = 0;
//			foreach (CWAV cwav in this.listWAV.Values)
			{
//				string strCount = count.ToString() + " / " + this.listWAV.Count.ToString();
//				Debug.WriteLine(strCount);
//				CDTXMania.act文字コンソール.tPrint(0, 0, C文字コンソール.Eフォント種別.白, strCount);
//				count++;

				string str = string.IsNullOrEmpty(this.PATH_WAV) ? this.strフォルダ名 : this.PATH_WAV;
				str = str + cwav.strファイル名;
				bool bIsDirectSound = ( CDTXMania.Sound管理.GetCurrentSoundDeviceType() == "DirectSound" );
				try
				{
					//try
					//{
					//    cwav.rSound[ 0 ] = CDTXMania.Sound管理.tサウンドを生成する( str );
					//    cwav.rSound[ 0 ].n音量 = 100;
					//    if ( CDTXMania.ConfigIni.bLog作成解放ログ出力 )
					//    {
					//        Trace.TraceInformation( "サウンドを作成しました。({3})({0})({1})({2}bytes)", cwav.strコメント文, str, cwav.rSound[ 0 ].nサウンドバッファサイズ, cwav.rSound[ 0 ].bストリーム再生する ? "Stream" : "OnMemory" );
					//    }
					//}
					//catch
					//{
					//    cwav.rSound[ 0 ] = null;
					//    Trace.TraceError( "サウンドの作成に失敗しました。({0})({1})", cwav.strコメント文, str );
					//}
					//if ( cwav.rSound[ 0 ] == null )	// #xxxxx 2012.5.3 yyagi rSound[1-3]もClone()するようにし、これらのストリーム再生がおかしくなる問題を修正
					//{
					//    for ( int j = 1; j < nPolyphonicSounds; j++ )
					//    {
					//        cwav.rSound[ j ] = null;
					//    }
					//}
					//else
					//{
					//    for ( int j = 1; j < nPolyphonicSounds; j++ )
					//    {
					//        cwav.rSound[ j ] = (CSound) cwav.rSound[ 0 ].Clone();	// #24007 2011.9.5 yyagi add: to accelerate loading chip sounds
					//        CDTXMania.Sound管理.tサウンドを登録する( cwav.rSound[ j ] );
					//    }
					//}

					// まず1つめを登録する
					try
					{
						cwav.rSound[ 0 ] = CDTXMania.Sound管理.tサウンドを生成する( str );
						cwav.rSound[ 0 ].n音量 = 100;
						if ( !CDTXMania.ConfigIni.bDynamicBassMixerManagement )
						{
							cwav.rSound[ 0 ].tBASSサウンドをミキサーに追加する();
						}
						if ( CDTXMania.ConfigIni.bLog作成解放ログ出力 )
						{
							Trace.TraceInformation( "サウンドを作成しました。({3})({0})({1})({2}bytes)", cwav.strコメント文, str, cwav.rSound[ 0 ].nサウンドバッファサイズ, cwav.rSound[ 0 ].bストリーム再生する ? "Stream" : "OnMemory" );
						}
					}
					catch ( Exception e )
					{
						cwav.rSound[ 0 ] = null;
						Trace.TraceError( "サウンドの作成に失敗しました。({0})({1})", cwav.strコメント文, str );
						Trace.TraceError( "例外: " + e.Message );
					}

					#region [ 同時発音数を、チャンネルによって変える ]
					int nPoly = nPolyphonicSounds;
					if ( CDTXMania.Sound管理.GetCurrentSoundDeviceType() != "DirectSound" )	// DShowでの再生の場合はミキシング負荷が高くないため、
					{																		// チップのライフタイム管理を行わない
						if      ( cwav.bIsBassSound )   nPoly = (nPolyphonicSounds >= 2)? 2 : 1;
						else if ( cwav.bIsGuitarSound ) nPoly = (nPolyphonicSounds >= 2)? 2 : 1;
						else if ( cwav.bIsSESound )     nPoly = 1;
						else if ( cwav.bIsBGMSound)     nPoly = 1;
					}
					if ( cwav.bIsBGMSound ) nPoly = 1;
					#endregion

					// 残りはClone等で登録する
					//if ( bIsDirectSound )	// DShowでの再生の場合はCloneする
					//{
					//    for ( int i = 1; i < nPoly; i++ )
					//    {
					//        cwav.rSound[ i ] = (CSound) cwav.rSound[ 0 ].Clone();	// #24007 2011.9.5 yyagi add: to accelerate loading chip sounds
					//        // CDTXMania.Sound管理.tサウンドを登録する( cwav.rSound[ j ] );
					//    }
					//    for ( int i = nPoly; i < nPolyphonicSounds; i++ )
					//    {
					//        cwav.rSound[ i ] = null;
					//    }
					//}
					//else															// WASAPI/ASIO時は通常通り登録
					{
						for ( int i = 1; i < nPoly; i++ )
						{
							try
							{
								cwav.rSound[ i ] = CDTXMania.Sound管理.tサウンドを生成する( str );
								cwav.rSound[ i ].n音量 = 100;
								if ( !CDTXMania.ConfigIni.bDynamicBassMixerManagement )
								{
									cwav.rSound[ i ].tBASSサウンドをミキサーに追加する();
								}
								if ( CDTXMania.ConfigIni.bLog作成解放ログ出力 )
								{
									Trace.TraceInformation( "サウンドを作成しました。({3})({0})({1})({2}bytes)", cwav.strコメント文, str, cwav.rSound[ 0 ].nサウンドバッファサイズ, cwav.rSound[ 0 ].bストリーム再生する ? "Stream" : "OnMemory" );
								}
							}
							catch ( Exception e )
							{
								cwav.rSound[ i ] = null;
								Trace.TraceError( "サウンドの作成に失敗しました。({0})({1})", cwav.strコメント文, str );
								Trace.TraceError( "例外: " + e.Message );
							}
						}
					}
				}
				catch( Exception exception )
				{
					Trace.TraceError( "サウンドの生成に失敗しました。({0})({1})({2})", exception.Message, cwav.strコメント文, str );
					for ( int j = 0; j < nPolyphonicSounds; j++ )
					{
						cwav.rSound[ j ] = null;
					}
					//continue;
				}
			}
		}
		public static string tZZ( int n )
		{
			if( n < 0 || n >= 36 * 36 )
				return "!!";	// オーバー／アンダーフロー。

			// n を36進数2桁の文字列にして返す。

			string str = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
			return new string( new char[] { str[ n / 36 ], str[ n % 36 ] } );
		}
		public void tギターとベースのランダム化(E楽器パート part, Eランダムモード eRandom)
		{
			if( ( ( part == E楽器パート.GUITAR ) || ( part == E楽器パート.BASS ) ) && ( eRandom != Eランダムモード.OFF ) )
			{
				int[,] nランダムレーン候補 = new int[ , ] { { 0, 1, 2, 3, 4, 5, 6, 7 }, { 0, 2, 1, 3, 4, 6, 5, 7 }, { 0, 1, 4, 5, 2, 3, 6, 7 }, { 0, 2, 4, 6, 1, 3, 5, 7 }, { 0, 4, 1, 5, 2, 6, 3, 7 }, { 0, 4, 2, 6, 1, 5, 3, 7 } };
				int n小節番号 = -10000;
				int n小節内乱数6通り = 0;
				// int GOTO_END = 0;	// gotoの飛び先のダミーコードで使うダミー変数
				foreach( CChip chip in this.listChip )
				{
					int nRGBレーンビットパターン;
					int n新RGBレーンビットパターン = 0;				// 「未割り当てのローカル変数」ビルドエラー回避のために0を初期値に設定
					bool flag;
					if( ( chip.n発声位置 / 384 ) != n小節番号 )		// 小節が変化したら
					{
						n小節番号 = chip.n発声位置 / 384;
						n小節内乱数6通り = CDTXMania.Random.Next( 6 );
					}
					int nランダム化前チャンネル番号 = chip.nチャンネル番号;
					if(		( ( ( part != E楽器パート.GUITAR ) || ( 0x20 > nランダム化前チャンネル番号 ) ) || ( nランダム化前チャンネル番号 > 0x27 ) )
						&&	( ( ( part != E楽器パート.BASS )   || ( 0xA0 > nランダム化前チャンネル番号 ) ) || ( nランダム化前チャンネル番号 > 0xa7 ) )
					)
					{
						continue;
					}
					switch( eRandom )
					{
						case Eランダムモード.RANDOM:		// 1小節単位でレーンのR/G/Bがランダムに入れ替わる
							chip.nチャンネル番号 = ( nランダム化前チャンネル番号 & 0xF0 ) | nランダムレーン候補[ n小節内乱数6通り, nランダム化前チャンネル番号 & 0x07 ];
							continue;	// goto Label_02C4;

						case Eランダムモード.SUPERRANDOM:	// チップごとにR/G/Bがランダムで入れ替わる(レーンの本数までは変わらない)。
							chip.nチャンネル番号 = ( nランダム化前チャンネル番号 & 0xF0 ) | nランダムレーン候補[ CDTXMania.Random.Next( 6 ), nランダム化前チャンネル番号 & 0x07 ];
							continue;	// goto Label_02C4;

						case Eランダムモード.HYPERRANDOM:	// レーンの本数も変わる
							nRGBレーンビットパターン = nランダム化前チャンネル番号 & 7;
							// n新RGBレーンビットパターン = (int)Eレーンビットパターン.OPEN;	// この値は結局未使用なので削除
							flag = ((part == E楽器パート.GUITAR) && this.bチップがある.OpenGuitar) || ((part == E楽器パート.BASS) && this.bチップがある.OpenBass);	// #23546 2010.10.28 yyagi fixed (bチップがある.Bass→bチップがある.OpenBass)
							if (((nRGBレーンビットパターン != (int)Eレーンビットパターン.xxB) && (nRGBレーンビットパターン != (int)Eレーンビットパターン.xGx)) && (nRGBレーンビットパターン != (int)Eレーンビットパターン.Rxx))		// xxB, xGx, Rxx レーン1本相当
							{
								break;															// レーン1本相当でなければ、とりあえず先に進む
							}
							n新RGBレーンビットパターン = CDTXMania.Random.Next( 6 ) + 1;		// レーン1本相当なら、レーン1本か2本(1～6)に変化して終了
							goto Label_02B2;

						default:
							continue;	// goto Label_02C4;
					}
					switch( nRGBレーンビットパターン )
					{
						case (int)Eレーンビットパターン.xGB:	// xGB	レーン2本相当
						case (int)Eレーンビットパターン.RxB:	// RxB
						case (int)Eレーンビットパターン.RGx:	// RGx
							n新RGBレーンビットパターン = flag ? CDTXMania.Random.Next( 8 ) : ( CDTXMania.Random.Next( 7 ) + 1 );	// OPENあり譜面ならOPENを含むランダム, OPENなし譜面ならOPENを含まないランダム
							break;	// goto Label_02B2;

						default:
							if( nRGBレーンビットパターン == (int)Eレーンビットパターン.RGB )	// RGB レーン3本相当
							{
								if( flag )	// OPENあり譜面の場合
								{
									int n乱数パーセント = CDTXMania.Random.Next( 100 );
									if( n乱数パーセント < 30 )
									{
										n新RGBレーンビットパターン = (int)Eレーンビットパターン.OPEN;
									}
									else if( n乱数パーセント < 60 )
									{
										n新RGBレーンビットパターン = (int)Eレーンビットパターン.RGB;
									}
									else if( n乱数パーセント < 85 )
									{
										switch( CDTXMania.Random.Next( 3 ) )
										{
											case 0:
												n新RGBレーンビットパターン = (int)Eレーンビットパターン.xGB;
												break;	// goto Label_02B2;

											case 1:
												n新RGBレーンビットパターン = (int)Eレーンビットパターン.RxB;
												break;	// goto Label_02B2;
										}
										n新RGBレーンビットパターン = (int)Eレーンビットパターン.RGx;
									}
									else	// OPENでない場合
									{
										switch( CDTXMania.Random.Next( 3 ) )
										{
											case 0:
												n新RGBレーンビットパターン = (int)Eレーンビットパターン.xxB;
												break;	// goto Label_02B2;

											case 1:
												n新RGBレーンビットパターン = (int)Eレーンビットパターン.xGx;
												break;	// goto Label_02B2;
										}
										n新RGBレーンビットパターン = (int)Eレーンビットパターン.Rxx;
									}
								}
								else	// OPENなし譜面の場合
								{
									int n乱数パーセント = CDTXMania.Random.Next( 100 );
									if( n乱数パーセント < 60 )
									{
										n新RGBレーンビットパターン = (int)Eレーンビットパターン.RGB;
									}
									else if( n乱数パーセント < 85 )
									{
										switch( CDTXMania.Random.Next( 3 ) )
										{
											case 0:
												n新RGBレーンビットパターン = (int)Eレーンビットパターン.xGB;
												break;	// goto Label_02B2;

											case 1:
												n新RGBレーンビットパターン = (int)Eレーンビットパターン.RxB;
												break;	// goto Label_02B2;
										}
										n新RGBレーンビットパターン = (int)Eレーンビットパターン.RGx;
									}
									else
									{
										switch( CDTXMania.Random.Next( 3 ) )
										{
											case 0:
												n新RGBレーンビットパターン = (int)Eレーンビットパターン.xxB;
												break;	// goto Label_02B2;

											case 1:
												n新RGBレーンビットパターン = (int)Eレーンビットパターン.xGx;
												break;	// goto Label_02B2;
										}
										n新RGBレーンビットパターン = (int)Eレーンビットパターン.Rxx;
									}
								}
							}
							break;	// goto Label_02B2;
					}
				Label_02B2:
					chip.nチャンネル番号 = ( nランダム化前チャンネル番号 & 0xF0 ) | n新RGBレーンビットパターン;
//				Label_02C4:
//					GOTO_END++;		// goto用のダミーコード
				}
			}
		}

		#region [ チップの再生と停止 ]
		public void tチップの再生( CChip rChip, long n再生開始システム時刻ms, int nLane )
		{
			this.tチップの再生( rChip, n再生開始システム時刻ms, nLane, CDTXMania.ConfigIni.n自動再生音量, false, false );
		}
		public void tチップの再生( CChip rChip, long n再生開始システム時刻ms, int nLane, int nVol )
		{
			this.tチップの再生( rChip, n再生開始システム時刻ms, nLane, nVol, false, false );
		}
		public void tチップの再生( CChip rChip, long n再生開始システム時刻ms, int nLane, int nVol, bool bMIDIMonitor )
		{
			this.tチップの再生( rChip, n再生開始システム時刻ms, nLane, nVol, bMIDIMonitor, false );
		}
		public void tチップの再生( CChip pChip, long n再生開始システム時刻ms, int nLane, int nVol, bool bMIDIMonitor, bool bBad )
		{
			if( pChip.n整数値・内部番号 >= 0 )
			{
				if( ( nLane < (int) Eレーン.LC ) || ( (int) Eレーン.BGM < nLane ) )
				{
					throw new ArgumentOutOfRangeException();
				}
				if( this.listWAV.ContainsKey( pChip.n整数値・内部番号 ) )
				{
					CWAV wc = this.listWAV[ pChip.n整数値・内部番号 ];
					int index = wc.n現在再生中のサウンド番号 = ( wc.n現在再生中のサウンド番号 + 1 ) % nPolyphonicSounds;
					if( ( wc.rSound[ 0 ] != null ) && 
						( wc.rSound[ 0 ].bストリーム再生する || wc.rSound[index] == null ) )
					{
						index = wc.n現在再生中のサウンド番号 = 0;
					}
					CSound sound = wc.rSound[ index ];
					if( sound != null )
					{
						if( bBad )
						{
							sound.db周波数倍率 = ( (float) ( 100 + ( ( ( CDTXMania.Random.Next( 3 ) + 1 ) * 7 ) * ( 1 - ( CDTXMania.Random.Next( 2 ) * 2 ) ) ) ) ) / 100f;
						}
						else
						{
							sound.db周波数倍率 = 1.0;
						}
						sound.db再生速度 = ( (double) CDTXMania.ConfigIni.n演奏速度 ) / 20.0;
						// 再生速度によって、WASAPI/ASIOで使う使用mixerが決まるため、付随情報の設定(音量/PAN)は、再生速度の設定後に行う
						sound.n音量 = (int) ( ( (double) ( nVol * wc.n音量 ) ) / 100.0 );
						sound.n位置 = wc.n位置;
						sound.t再生を開始する();
					}
					wc.n再生開始時刻[ wc.n現在再生中のサウンド番号 ] = n再生開始システム時刻ms;
					this.tWave再生位置自動補正( wc );
				}
			}
		}
		public void t各自動再生音チップの再生時刻を変更する( int nBGMAdjustの増減値 )
		{
			this.nBGMAdjust += nBGMAdjustの増減値;
			for( int i = 0; i < this.listChip.Count; i++ )
			{
				int nChannelNumber = this.listChip[ i ].nチャンネル番号;
				if( ( (
						( nChannelNumber == 1 ) ||
						( ( 0x61 <= nChannelNumber ) && ( nChannelNumber <= 0x69 ) )
					  ) ||
						( ( 0x70 <= nChannelNumber ) && ( nChannelNumber <= 0x79 ) )
					) ||
					( ( ( 0x80 <= nChannelNumber ) && ( nChannelNumber <= 0x89 ) ) || ( ( 0x90 <= nChannelNumber ) && ( nChannelNumber <= 0x92 ) ) )
				  )
				{
					this.listChip[ i ].n発声時刻ms += nBGMAdjustの増減値;
				}
			}
			foreach( CWAV cwav in this.listWAV.Values )
			{
				for ( int j = 0; j < nPolyphonicSounds; j++ )
				{
					if( ( cwav.rSound[ j ] != null ) && cwav.rSound[ j ].b再生中 )
					{
						cwav.n再生開始時刻[ j ] += nBGMAdjustの増減値;
					}
				}
			}
		}
		public void t全チップの再生一時停止()
		{
			foreach( CWAV cwav in this.listWAV.Values )
			{
				for ( int i = 0; i < nPolyphonicSounds; i++ )
				{
					if( ( cwav.rSound[ i ] != null ) && cwav.rSound[ i ].b再生中 )
					{
						cwav.rSound[ i ].t再生を一時停止する();
						cwav.n一時停止時刻[ i ] = CSound管理.rc演奏用タイマ.nシステム時刻ms;
					}
				}
			}
		}
		public void t全チップの再生再開()
		{
			foreach( CWAV cwav in this.listWAV.Values )
			{
				for ( int i = 0; i < nPolyphonicSounds; i++ )
				{
					if( ( cwav.rSound[ i ] != null ) && cwav.rSound[ i ].b一時停止中 )
					{
						//long num1 = cwav.n一時停止時刻[ i ];
						//long num2 = cwav.n再生開始時刻[ i ];
						cwav.rSound[ i ].t再生を再開する( cwav.n一時停止時刻[ i ] - cwav.n再生開始時刻[ i ] );
						cwav.n再生開始時刻[ i ] += CSound管理.rc演奏用タイマ.nシステム時刻ms - cwav.n一時停止時刻[ i ];
					}
				}
			}
		}
		public void t全チップの再生停止()
		{
			foreach( CWAV cwav in this.listWAV.Values )
			{
				this.tWavの再生停止( cwav.n内部番号 );
			}
		}
		public void t全チップの再生停止とミキサーからの削除()
		{
			foreach( CWAV cwav in this.listWAV.Values )
			{
				this.tWavの再生停止( cwav.n内部番号, true );
			}
		}
		#endregion

		public void t入力( string strファイル名, bool bヘッダのみ )
		{
			this.t入力( strファイル名, bヘッダのみ, 1.0, 0 );
		}
		public void t入力( string strファイル名, bool bヘッダのみ, double db再生速度, int nBGMAdjust )
		{
			this.bヘッダのみ = bヘッダのみ;
			this.strファイル名の絶対パス = Path.GetFullPath( strファイル名 );
			this.strファイル名 = Path.GetFileName( this.strファイル名の絶対パス );
			this.strフォルダ名 = Path.GetDirectoryName( this.strファイル名の絶対パス ) + @"\";
			string ext = Path.GetExtension( this.strファイル名 ).ToLower();
			if ( ext != null )
			{
				if ( !( ext == ".dtx" ) )
				{
					if ( ext == ".gda" )
					{
						this.e種別 = E種別.GDA;
					}
					else if ( ext == ".g2d" )
					{
						this.e種別 = E種別.G2D;
					}
					else if ( ext == ".bms" )
					{
						this.e種別 = E種別.BMS;
					}
					else if ( ext == ".bme" )
					{
						this.e種別 = E種別.BME;
					}
					else if ( ext == ".mid" )
					{
						this.e種別 = E種別.SMF;
					}
				}
				else
				{
					this.e種別 = E種別.DTX;
				}
			}
			if ( this.e種別 != E種別.SMF )
			{
				try
				{
					//DateTime timeBeginLoad = DateTime.Now;
					//TimeSpan span;
			        string[] files = Directory.GetFiles( this.strフォルダ名, "*.tja" );

					StreamReader reader = new StreamReader( strファイル名, Encoding.GetEncoding( "Shift_JIS" ) );
					string str2 = reader.ReadToEnd();
					reader.Close();

					//StreamReader reader2 = new StreamReader( this.strフォルダ名 + "test.tja", Encoding.GetEncoding( "Shift_JIS" ) );
                    StreamReader reader2 = new StreamReader( files[0], Encoding.GetEncoding( "Shift_JIS" ) );
					string str3 = reader2.ReadToEnd();
					reader2.Close();

					//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
					//Trace.TraceInformation( "DTXfileload時間:          {0}", span.ToString() );

					this.t入力・全入力文字列から( str2, str3, db再生速度, nBGMAdjust );
				}
				catch( Exception ex )
				{
                    //MessageBox.Show( "おや?エラーが出たようです。お兄様。" );
                    Trace.TraceError( "おや?エラーが出たようです。お兄様。" );
                    Trace.TraceError( "エラー:{0}", ex.StackTrace );
				}
			}
			else
			{
				Trace.TraceWarning( "SMF の演奏は未対応です。（検討中）" );
			}
		}
		public void t入力・全入力文字列から( string str全入力文字列 )
		{
			this.t入力・全入力文字列から( str全入力文字列, str全入力文字列, 1.0, 0 );
		}
		public unsafe void t入力・全入力文字列から( string str全入力文字列, string str1, double db再生速度, int nBGMAdjust )
		{
			//DateTime timeBeginLoad = DateTime.Now;
			//TimeSpan span;

			if ( !string.IsNullOrEmpty( str全入力文字列 ) )
			{
				#region [ 改行カット ]
				this.db再生速度 = db再生速度;
				str全入力文字列 = str全入力文字列.Replace( Environment.NewLine, "\n" );
				str全入力文字列 = str全入力文字列.Replace( '\t', ' ' );
				str全入力文字列 = str全入力文字列 + "\n";
				#endregion
				//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
				//Trace.TraceInformation( "改行カット時間:           {0}", span.ToString() );
				//timeBeginLoad = DateTime.Now;
				#region [ 初期化 ]
				for ( int j = 0; j < 36 * 36; j++ )
				{
					this.n無限管理WAV[ j ] = -j;
					this.n無限管理BPM[ j ] = -j;
					this.n無限管理VOL[ j ] = -j;
					this.n無限管理PAN[ j ] = -10000 - j;
					this.n無限管理SIZE[ j ] = -j;
				}
				this.n内部番号WAV1to = 1;
				this.n内部番号BPM1to = 1;
				this.bstackIFからENDIFをスキップする = new Stack<bool>();
				this.bstackIFからENDIFをスキップする.Push( false );
				this.n現在の乱数 = 0;
				for ( int k = 0; k < 7; k++ )
				{
					this.nRESULTIMAGE用優先順位[ k ] = 0;
					this.nRESULTMOVIE用優先順位[ k ] = 0;
					this.nRESULTSOUND用優先順位[ k ] = 0;
				}
				#endregion
				#region [ 入力/行解析 ]
				CharEnumerator ce = str全入力文字列.GetEnumerator();
				if ( ce.MoveNext() )
				{
					this.n現在の行数 = 1;
					do
					{
						if ( !this.t入力・空白と改行をスキップする( ref ce ) )
						{
							break;
						}
                        if (this.listChip.Count == 0)
                        {
                            //this.t入力(str1);
                            this.t入力_V3( str1, 3 );
                        }
						if ( ce.Current == '#' )
						{
							if ( ce.MoveNext() )
							{
								StringBuilder builder = new StringBuilder( 0x20 );
								if ( this.t入力・コマンド文字列を抜き出す( ref ce, ref builder ) )
								{
									StringBuilder builder2 = new StringBuilder( 0x400 );
									if ( this.t入力・パラメータ文字列を抜き出す( ref ce, ref builder2 ) )
									{
										StringBuilder builder3 = new StringBuilder( 0x400 );
										if ( this.t入力・コメント文字列を抜き出す( ref ce, ref builder3 ) )
										{
											this.t入力・行解析( ref builder, ref builder2, ref builder3 );

											this.n現在の行数++;
											continue;
										}
									}
								}
							}
							break;
						}
                        //this.t入力(str1);
					}
					while ( this.t入力・コメントをスキップする( ref ce ) );

				#endregion
					//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
					//Trace.TraceInformation( "抜き出し時間:             {0}", span.ToString() );
					//timeBeginLoad = DateTime.Now;
					this.n無限管理WAV = null;
					this.n無限管理BPM = null;
					this.n無限管理VOL = null;
					this.n無限管理PAN = null;
					this.n無限管理SIZE = null;
                    this.t入力・行解析ヘッダ( str1 );
					if ( !this.bヘッダのみ )
					{
						#region [ BPM/BMP初期化 ]
						int ch;
						CBPM cbpm = null;
						foreach ( CBPM cbpm2 in this.listBPM.Values )
						{
							if ( cbpm2.n表記上の番号 == 0 )
							{
								cbpm = cbpm2;
								break;
							}
						}
						if ( cbpm == null )
						{
							cbpm = new CBPM();
							cbpm.n内部番号 = this.n内部番号BPM1to++;
							cbpm.n表記上の番号 = 0;
							cbpm.dbBPM値 = 120.0;
							this.listBPM.Add( cbpm.n内部番号, cbpm );
							CChip chip = new CChip();
							chip.n発声位置 = 0;
							chip.nチャンネル番号 = 8;		// 拡張BPM
							chip.n整数値 = 0;
							chip.n整数値・内部番号 = cbpm.n内部番号;
							this.listChip.Insert( 0, chip );
						}
						else
						{
							CChip chip = new CChip();
							chip.n発声位置 = 0;
							chip.nチャンネル番号 = 8;		// 拡張BPM
							chip.n整数値 = 0;
							chip.n整数値・内部番号 = cbpm.n内部番号;
							this.listChip.Insert( 0, chip );
						}
						#endregion
						//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
						//Trace.TraceInformation( "前準備完了時間:           {0}", span.ToString() );
						//timeBeginLoad = DateTime.Now;
						#region [ CWAV初期化 ]
						foreach ( CWAV cwav in this.listWAV.Values )
						{
							if ( cwav.nチップサイズ < 0 )
							{
								cwav.nチップサイズ = 100;
							}
							if ( cwav.n位置 <= -10000 )
							{
								cwav.n位置 = 0;
							}
							if ( cwav.n音量 < 0 )
							{
								cwav.n音量 = 100;
							}
						}
						#endregion
						//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
						//Trace.TraceInformation( "CWAV前準備時間:           {0}", span.ToString() );
						//timeBeginLoad = DateTime.Now;
						#region [ チップ倍率設定 ]						// #28145 2012.4.22 yyagi 二重ループを1重ループに変更して高速化)
						//foreach ( CWAV cwav in this.listWAV.Values )
						//{
						//    foreach( CChip chip in this.listChip )
						//    {
						//        if( chip.n整数値・内部番号 == cwav.n内部番号 )
						//        {
						//            chip.dbチップサイズ倍率 = ( (double) cwav.nチップサイズ ) / 100.0;
						//            if (chip.nチャンネル番号 == 0x01 )	// BGMだったら
						//            {
						//                cwav.bIsOnBGMLane = true;
						//            }
						//        }
						//    }
						//}
						foreach ( CChip chip in this.listChip )
						{
							if ( this.listWAV.ContainsKey( chip.n整数値・内部番号 ) )
							//foreach ( CWAV cwav in this.listWAV.Values )
							{
								CWAV cwav = this.listWAV[ chip.n整数値・内部番号 ];
								//	if ( chip.n整数値・内部番号 == cwav.n内部番号 )
								//	{
								chip.dbチップサイズ倍率 = ( (double) cwav.nチップサイズ ) / 100.0;
								//if ( chip.nチャンネル番号 == 0x01 )	// BGMだったら
								//{
								//	cwav.bIsOnBGMLane = true;
								//}
								//	}
							}
						}
						#endregion
						//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
						//Trace.TraceInformation( "CWAV全準備時間:           {0}", span.ToString() );
						//timeBeginLoad = DateTime.Now;
						#region [ 必要に応じて空打ち音を0小節に定義する ]
						//for ( int m = 0xb1; m <= 0xbc; m++ )			// #28146 2012.4.21 yyagi; bb -> bc
						//{
						//    foreach ( CChip chip in this.listChip )
						//    {
						//        if ( chip.nチャンネル番号 == m )
						//        {
						//            CChip c = new CChip();
						//            c.n発声位置 = 0;
						//            c.nチャンネル番号 = chip.nチャンネル番号;
						//            c.n整数値 = chip.n整数値;
						//            c.n整数値・内部番号 = chip.n整数値・内部番号;
						//            this.listChip.Insert( 0, c );
						//            break;
						//        }
						//    }
						//}
						#endregion
						//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
						//Trace.TraceInformation( "空打確認時間:             {0}", span.ToString() );
						//timeBeginLoad = DateTime.Now;
						#region [ 拍子・拍線の挿入 ]
						if ( this.listChip.Count > 0 )
						{
							this.listChip.Sort();		// 高速化のためにはこれを削りたいが、listChipの最後がn発声位置の終端である必要があるので、
							// 保守性確保を優先してここでのソートは残しておく
							// なお、093時点では、このソートを削除しても動作するようにはしてある。
							// (ここまでの一部チップ登録を、listChip.Add(c)から同Insert(0,c)に変更してある)
							// これにより、数ms程度ながらここでのソートも高速化されている。
							double barlength = 1.0;
                            int nEndOfSong = ( this.listChip[ this.listChip.Count - 1 ].n発声位置 + 384 ) - ( this.listChip[ this.listChip.Count - 1 ].n発声位置 % 384 );
                            for ( int tick384 = 0; tick384 <= nEndOfSong; tick384 += 384 )	// 小節線の挿入　(後に出てくる拍子線とループをまとめようとするなら、forループの終了条件の微妙な違いに注意が必要)
                            {
                                CChip chip = new CChip();
                                chip.n発声位置 = tick384;
                                chip.nチャンネル番号 = 0x50;	// 小節線
                                chip.n整数値 = 36 * 36 - 1;
                                chip.dbSCROLL = 1.0;
                                this.listChip.Add( chip );
                            }
                            //this.listChip.Sort();				// ここでのソートは不要。ただし最後にソートすること
                            int nChipNo_BarLength = 0;
                            int nChipNo_C1 = 0;
                            for ( int tick384 = 0; tick384 < nEndOfSong; tick384 += 384 )
                            {
                                int n発声位置_C1_同一小節内 = 0;
                                while ( ( nChipNo_C1 < this.listChip.Count ) && ( this.listChip[ nChipNo_C1 ].n発声位置 < ( tick384 + 384 ) ) )
                                {
                                    if ( this.listChip[ nChipNo_C1 ].nチャンネル番号 == 0xc1 )				// 拍線シフトの検出
                                    {
                                        n発声位置_C1_同一小節内 = this.listChip[ nChipNo_C1 ].n発声位置 - tick384;
                                    }
                                    nChipNo_C1++;
                                }
                                if ( ( this.e種別 == E種別.BMS ) || ( this.e種別 == E種別.BME ) )
                                {
                                    barlength = 1.0;
                                }
                                while ( ( nChipNo_BarLength < this.listChip.Count ) && ( this.listChip[ nChipNo_BarLength ].n発声位置 <= tick384 ) )
                                {
                                    if ( this.listChip[ nChipNo_BarLength ].nチャンネル番号 == 0x02 )		// bar lengthの検出
                                    {
                                        barlength = this.listChip[ nChipNo_BarLength ].db実数値;
                                    }
                                    nChipNo_BarLength++;
                                }
                                for ( int i = 0; i < 100; i++ )								// 拍線の挿入
                                {
                                    int tickBeat = (int) ( ( (double) ( 384 * i ) ) / ( 4.0 * barlength ) );
                                    if ( ( tickBeat + n発声位置_C1_同一小節内 ) >= 384 )
                                    {
                                        break;
                                    }
                                    if ( ( ( tickBeat + n発声位置_C1_同一小節内 ) % 384 ) != 0 )
                                    {
                                        CChip chip = new CChip();
                                        chip.n発声位置 = tick384 + ( tickBeat + n発声位置_C1_同一小節内 );
                                        chip.nチャンネル番号 = 0x51;						// beat line 拍線
                                        chip.n整数値 = 36 * 36 - 1;
                                        //this.listChip.Add( chip );
                                    }
                                }
                            }
							this.listChip.Sort();
						}
						#endregion
						//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
						//Trace.TraceInformation( "拍子・拍線挿入時間:       {0}", span.ToString() );
						//timeBeginLoad = DateTime.Now;
						#region [ C2 [拍線・小節線表示指定] の処理 ]		// #28145 2012.4.21 yyagi; 2重ループをほぼ1重にして高速化
						bool bShowBeatBarLine = true;
						for ( int i = 0; i < this.listChip.Count; i++ )
						{
							bool bChangedBeatBarStatus = false;
							if ( ( this.listChip[ i ].nチャンネル番号 == 0xc2 ) )
							{
								if ( this.listChip[ i ].n整数値 == 1 )				// BAR/BEAT LINE = ON
								{
									bShowBeatBarLine = true;
									bChangedBeatBarStatus = true;
								}
								else if ( this.listChip[ i ].n整数値 == 2 )			// BAR/BEAT LINE = OFF
								{
									bShowBeatBarLine = false;
									bChangedBeatBarStatus = true;
								}
							}
							int startIndex = i;
							if ( bChangedBeatBarStatus )							// C2チップの前に50/51チップが来ている可能性に配慮
							{
								while ( startIndex > 0 && this.listChip[ startIndex ].n発声位置 == this.listChip[ i ].n発声位置 )
								{
									startIndex--;
								}
								startIndex++;	// 1つ小さく過ぎているので、戻す
							}
							for ( int j = startIndex; j <= i; j++ )
							{
								if ( ( ( this.listChip[ j ].nチャンネル番号 == 0x50 ) || ( this.listChip[ j ].nチャンネル番号 == 0x51 ) ) &&
									( this.listChip[ j ].n整数値 == ( 36 * 36 - 1 ) ) )
								{
									this.listChip[ j ].b可視 = bShowBeatBarLine;
								}
							}
						}
						#endregion
						//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
						//Trace.TraceInformation( "C2 [拍線・小節線表示指定]:  {0}", span.ToString() );
						//timeBeginLoad = DateTime.Now;
                        this.n内部番号BRANCH1to = 0;
						#region [ 発声時刻の計算 ]
						double bpm = 120.0;
						//double dbBarLength = 1.0;
						int n発声位置 = 0;
						int ms = 0;
						int nBar = 0;
                        this.nNowRollCount = 0;

                        #region[初期化]
                        this.dbNowSCROLL = 1.0;
                        this.dbNowSCROLL_Normal = 1.0;
                        this.dbNowSCROLL_Expert = 1.0;
                        this.dbNowSCROLL_Master = 1.0;
                        this.n現在のコース = 0;
                        #endregion

                        foreach ( CChip chip in this.listChip )
						{
                            //if( chip.nチャンネル番号 < 0x93 )
							    chip.n発声時刻ms = ms + ( (int) ( ( ( 625 * ( chip.n発声位置 - n発声位置 ) ) * this.dbBarLength ) / bpm ) );
                            //chip.f発声時刻ms = (float)( ms + ( ( ( ( 625.0f * (float)( chip.f発声位置 - n発声位置 ) ) * (float)this.dbBarLength ) / (float)bpm ) ) );
                            chip.n発声時刻ms += nDELAY;
                            chip.nノーツ終了時刻ms = ms + ( (int) ( ( ( 0x271 * ( chip.nノーツ終了位置 - n発声位置 ) ) * this.dbBarLength ) / bpm ) );
                            chip.nノーツ終了時刻ms += nDELAY;
                            if ( ( ( this.e種別 == E種別.BMS ) || ( this.e種別 == E種別.BME ) ) && ( ( this.dbBarLength != 1.0 ) && ( ( chip.n発声位置 / 384 ) != nBar ) ) )
							{
								n発声位置 = chip.n発声位置;
								ms = chip.n発声時刻ms;
								this.dbBarLength = 1.0;
							}
							nBar = chip.n発声位置 / 384;
							ch = chip.nチャンネル番号;

                            this.nNowRollCount++;
                            
                            switch ( ch )
							{
                                case 0x01:
									{
										n発声位置 = chip.n発声位置;

                                        if( this.bOFFSETの値がマイナスである == false )
                                            chip.n発声時刻ms += this.nOFFSET;
										ms = chip.n発声時刻ms;
										continue;
									}
								case 0x02:	// BarLength
									{
										n発声位置 = chip.n発声位置;
                                        if( this.bOFFSETの値がマイナスである == false )
                                            chip.n発声時刻ms += this.nOFFSET;
										ms = chip.n発声時刻ms;
										dbBarLength = chip.db実数値;
										continue;
									}
								case 0x03:	// BPM
									{
										n発声位置 = chip.n発声位置;
                                        if( this.bOFFSETの値がマイナスである == false )
										    chip.n発声時刻ms += this.nOFFSET;
                                        ms = chip.n発声時刻ms;
										bpm = this.BASEBPM + chip.n整数値;
                                        this.dbNowBPM = bpm;
										continue;
									}
								case 0x04:	// BGA (レイヤBGA1)
								case 0x07:	// レイヤBGA2
								case 0x55:	// レイヤBGA3
								case 0x56:	// レイヤBGA4
								case 0x57:	// レイヤBGA5
								case 0x58:	// レイヤBGA6
								case 0x59:	// レイヤBGA7
								case 0x60:	// レイヤBGA8
									break;

                                case 0x50:
                                    {
                                        if( this.bOFFSETの値がマイナスである )
                                            chip.n発声時刻ms += this.nOFFSET;
                                        //chip.n発声時刻ms += this.nDELAY;
                                        chip.dbBPM = this.dbNowBPM;
                                        chip.dbSCROLL = this.dbNowSCROLL;

                                        if( this.n内部番号BRANCH1to + 1 > this.listBRANCH.Count )
                                            continue;

                                        if( this.listBRANCH[ this.n内部番号BRANCH1to ].n現在の小節 == nBar )
                                        {
                                            chip.bBranch = true;
                                            this.b次の小節が分岐である = false;
                                            this.n内部番号BRANCH1to++;
                                        }

                                        //switch (this.n現在のコース)
                                        //{
                                        //    case 0:
                                        //        chip.dbSCROLL = this.dbNowSCROLL_Normal;
                                        //        break;
                                        //    case 1:
                                        //        chip.dbSCROLL = this.dbNowSCROLL_Expert;
                                        //        break;
                                        //    case 2:
                                        //        chip.dbSCROLL = this.dbNowSCROLL_Master;
                                        //        break;
                                        //}

                                        if( this.bBarLine == true )
                                            chip.b可視 = true;
                                        else
                                            chip.b可視 = false;

                                        //if( this.b次の小節が分岐である )
                                        //{
                                        //    chip.bBranch = true;
                                        //    this.b次の小節が分岐である = false;
                                        //}
                                        continue;
                                    }

								case 0x05:	// Extended Object (非対応)
								case 0x06:	// Missアニメ (非対応)
								case 0x5A:	// 未定義
								case 0x5b:	// 未定義
								case 0x5c:	// 未定義
								case 0x5d:	// 未定義
								case 0x5e:	// 未定義
								case 0x5f:	// 未定義
									{
										continue;
									}
								case 0x08:	// 拡張BPM
									{
										n発声位置 = chip.n発声位置;
                                        if( this.bOFFSETの値がマイナスである == false )
                                            chip.n発声時刻ms += this.nOFFSET;
										ms = chip.n発声時刻ms;
										if ( this.listBPM.ContainsKey( chip.n整数値・内部番号 ) )
										{
											bpm = ( ( this.listBPM[ chip.n整数値・内部番号 ].n表記上の番号 == 0 ) ? 0.0 : this.BASEBPM ) + this.listBPM[ chip.n整数値・内部番号 ].dbBPM値;
                                            this.dbNowBPM = bpm;
										}
										continue;
									}
								case 0x54:	// 動画再生
									{
                                        if( this.bOFFSETの値がマイナスである == false )
                                            chip.n発声時刻ms += this.nOFFSET;
										if ( this.listAVIPAN.ContainsKey( chip.n整数値 ) )
										{
											int num21 = ms + ( (int) ( ( ( 0x271 * ( chip.n発声位置 - n発声位置 ) ) * this.dbBarLength ) / bpm ) );
											int num22 = ms + ( (int) ( ( ( 0x271 * ( ( chip.n発声位置 + this.listAVIPAN[ chip.n整数値 ].n移動時間ct ) - n発声位置 ) ) * this.dbBarLength ) / bpm ) );
											chip.n総移動時間 = num22 - num21;
										}
										continue;
									}
                                case 0x97:
                                case 0x98:
                                case 0x99:
                                    {
                                        if( this.bOFFSETの値がマイナスである )
                                        {
                                            chip.n発声時刻ms += this.nOFFSET;
                                            chip.nノーツ終了時刻ms += this.nOFFSET;
                                        }

                                        chip.dbBPM = this.dbNowBPM;
                                        chip.dbSCROLL = this.dbNowSCROLL;
                                        this.nNowRoll = this.nNowRollCount - 1;

                                        //chip.nノーツ終了時刻ms = ms + ( (int) ( ( ( 0x271 * ( chip.nノーツ終了位置 - n発声位置 ) ) * dbBarLength ) / bpm ) );

                                        #region[チップ番号を記録]
                                        switch(chip.nコース)
                                        {
                                            case 0:
                                                this.n連打チップ_temp[0] = this.nNowRoll;
                                                this.dbSCROLL_temp[0] = this.dbNowSCROLL;
                                                break;
                                            case 1:
                                                this.n連打チップ_temp[1] = this.nNowRoll;
                                                this.dbSCROLL_temp[1] = this.dbNowSCROLL;
                                                break;
                                            case 2:
                                                this.n連打チップ_temp[2] = this.nNowRoll;
                                                this.dbSCROLL_temp[2] = this.dbNowSCROLL;
                                                break;
                                        }

                                        #endregion

                                        continue;
                                    }
                                case 0x9A:
                                    {

                                        if( this.bOFFSETの値がマイナスである )
                                            chip.n発声時刻ms += this.nOFFSET;
                                        //chip.n発声時刻ms += this.nDELAY;
                                        chip.dbBPM = this.dbNowBPM;
                                        chip.dbSCROLL = this.dbNowSCROLL;

                                        #region[チップ番号を記録]
                                        //風船は現時点では未実装のため処理しない。


                                        switch (chip.nコース)
                                        {
                                            case 0:
                                                if (this.listChip[this.n連打チップ_temp[0]].nチャンネル番号 == 0x99) break;
                                                this.listChip[this.n連打チップ_temp[0]].nノーツ終了時刻ms = chip.n発声時刻ms;
                                                this.listChip[this.n連打チップ_temp[0]].dbSCROLL = this.dbSCROLL_temp[0];
                                                break;
                                            case 1:
                                                if (this.listChip[this.n連打チップ_temp[1]].nチャンネル番号 == 0x99) break;
                                                this.listChip[this.n連打チップ_temp[1]].nノーツ終了時刻ms = chip.n発声時刻ms;
                                                this.listChip[this.n連打チップ_temp[1]].dbSCROLL = this.dbSCROLL_temp[1];
                                                break;
                                            case 2:
                                                if (this.listChip[this.n連打チップ_temp[2]].nチャンネル番号 == 0x99) break;
                                                this.listChip[this.n連打チップ_temp[2]].nノーツ終了時刻ms = chip.n発声時刻ms;
                                                this.listChip[this.n連打チップ_temp[2]].dbSCROLL = this.dbSCROLL_temp[2];
                                                break;
                                        }

                                        #endregion

                                        //this.listChip[this.nNowRoll].nノーツ終了時刻ms = chip.n発声時刻ms;
                                        //this.listChip[this.nNowRoll].dbSCROLL = this.dbNowSCROLL;
                                        //this.listChip[this.nNowRoll].dbBPM = this.dbNowBPM;
                                        continue;
                                    }
                                case 0x9D:
                                    {
										if ( this.listSCROLL.ContainsKey( chip.n整数値・内部番号 ) )
										{
                                            this.dbNowSCROLL = ( ( this.listSCROLL[ chip.n整数値・内部番号 ].n表記上の番号 == 0 ) ? 0.0 : 1.0 ) + this.listSCROLL[ chip.n整数値・内部番号 ].dbSCROLL値;
										}

                                        //switch (chip.nコース)
                                        //{
                                        //    case 0:
                                        //        this.dbNowSCROLL_Normal = this.dbNowSCROLL;
                                        //        this.n現在のコース = 0;
                                        //        break;
                                        //    case 1:
                                        //        this.dbNowSCROLL_Expert = this.dbNowSCROLL;
                                        //        this.n現在のコース = 1;
                                        //        break;
                                        //    case 2:
                                        //        this.dbNowSCROLL_Master = this.dbNowSCROLL;
                                        //        this.n現在のコース = 2;
                                        //        break;
                                        //}

										continue;
                                    }
                                case 0xDC:
                                    {
										if ( this.listDELAY.ContainsKey( chip.n整数値・内部番号 ) )
										{
                                            this.nDELAY = ( ( this.listDELAY[ chip.n整数値・内部番号 ].n表記上の番号 == 0 ) ? 0 : 0 ) + this.listDELAY[ chip.n整数値・内部番号 ].nDELAY値;
										}
										continue;
                                    }
                                case 0xDE:
                                    {
                                        if (this.bOFFSETの値がマイナスである)
                                            chip.n発声時刻ms += this.nOFFSET;
                                        //chip.n発声時刻ms += this.nDELAY;
                                        chip.dbBPM = this.dbNowBPM;
                                        chip.dbSCROLL = this.dbNowSCROLL;

                                        this.b次の小節が分岐である = true;
                                        this.n現在のコース = chip.nコース;
                                        continue;
                                    }
                                case 0xDF:
                                    {
										if ( this.listBRANCH.ContainsKey( chip.n整数値・内部番号 ) )
										{
                                            this.listBRANCH[chip.n整数値・内部番号].db分岐時間ms = chip.n発声時刻ms + ( this.bOFFSETの値がマイナスである ? this.nOFFSET : 0 );
                                        }
                                        continue;
                                    }
                                case 0xE0:
                                    {
                                        //if (this.bOFFSETの値がマイナスである)
                                        //    chip.n発声時刻ms += this.nOFFSET;

                                        chip.dbBPM = this.dbNowBPM;
                                        chip.dbSCROLL = this.dbNowSCROLL;
                                        if( chip.n整数値・内部番号 == 1 )
                                            this.bBarLine = false;
                                        else
                                            this.bBarLine = true;
                                        continue;
                                    }
								default:
									{
                                        if( this.bOFFSETの値がマイナスである )
                                            chip.n発声時刻ms += this.nOFFSET;
                                        //chip.n発声時刻ms += this.nDELAY;
                                        chip.dbBPM = this.dbNowBPM;
                                        chip.dbSCROLL = this.dbNowSCROLL;
										continue;
									}
							}

						}
						if ( this.db再生速度 > 0.0 )
						{
							double _db再生速度 = ( CDTXMania.DTXVmode.Enabled ) ? this.dbDTXVPlaySpeed : this.db再生速度;
							foreach ( CChip chip in this.listChip )
							{
								chip.n発声時刻ms = (int) ( ( (double) chip.n発声時刻ms ) / _db再生速度 );
                                chip.f発声時刻ms = (float)( ( (float) chip.n発声時刻ms ) / _db再生速度 );
                                chip.nノーツ終了時刻ms = (int) ( ( (double) chip.nノーツ終了時刻ms ) / _db再生速度 );
							}
						}
						#endregion
						//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
						//Trace.TraceInformation( "発声時刻計算:             {0}", span.ToString() );
						//timeBeginLoad = DateTime.Now;
						this.nBGMAdjust = 0;
						this.t各自動再生音チップの再生時刻を変更する( nBGMAdjust );
						//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
						//Trace.TraceInformation( "再生時刻変更:             {0}", span.ToString() );
						//timeBeginLoad = DateTime.Now;
						#region [ 可視チップ数カウント ]
						for ( int n = 0; n < 14; n++ )
						{
							this.n可視チップ数[ n ] = 0;
						}
						foreach ( CChip chip in this.listChip )
						{
							int c = chip.nチャンネル番号;
							if ( ( 0x11 <= c ) && ( c <= 0x1C ) )
							{
								this.n可視チップ数[ c - 0x11 ]++;
							}
							if ( ( 0x20 <= c ) && ( c <= 0x27 ) )
							{
								this.n可視チップ数.Guitar++;
							}
							if ( ( 0xA0 <= c ) && ( c <= 0xa7 ) )
							{
								this.n可視チップ数.Bass++;
							}
                            if( ( 0x93 <= c ) && ( c <= 0x96 ) )
                            {
                                if( c == 0x93 || c == 0x95 )
                                    this.n可視チップ数.Taiko_Red++;
                                else if( c == 0x94 || c == 0x96 )
                                    this.n可視チップ数.Taiko_Blue++;
                            }
						}
						#endregion
						//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
						//Trace.TraceInformation( "可視チップ数カウント      {0}", span.ToString() );
						//timeBeginLoad = DateTime.Now;
						#region [ チップの種類を分類し、対応するフラグを立てる ]
						foreach ( CChip chip in this.listChip )
						{
							if ( ( chip.bWAVを使うチャンネルである && this.listWAV.ContainsKey( chip.n整数値・内部番号 ) ) && !this.listWAV[ chip.n整数値・内部番号 ].listこのWAVを使用するチャンネル番号の集合.Contains( chip.nチャンネル番号 ) )
							{
								this.listWAV[ chip.n整数値・内部番号 ].listこのWAVを使用するチャンネル番号の集合.Add( chip.nチャンネル番号 );

								int c = chip.nチャンネル番号 >> 4;
								switch ( c )
								{
									case 0x01:
										this.listWAV[ chip.n整数値・内部番号 ].bIsDrumsSound = true; break;
									case 0x02:
										this.listWAV[ chip.n整数値・内部番号 ].bIsGuitarSound = true; break;
									case 0x0A:
										this.listWAV[ chip.n整数値・内部番号 ].bIsBassSound = true; break;
									case 0x06:
									case 0x07:
									case 0x08:
									case 0x09:
										this.listWAV[ chip.n整数値・内部番号 ].bIsSESound = true; break;
									case 0x00:
										if ( chip.nチャンネル番号 == 0x01 )
										{
											this.listWAV[ chip.n整数値・内部番号 ].bIsBGMSound = true; break;
										}
										break;
								}
							}
						}
						#endregion
						//span = (TimeSpan) ( DateTime.Now - timeBeginLoad );
						//Trace.TraceInformation( "ch番号集合確認:           {0}", span.ToString() );
                        //timeBeginLoad = DateTime.Now;
                        #region[ seNotes計算 ]
                        if( this.listBRANCH.Count != 0 )
                            this.tSetSenotes_branch();
                        else
                            this.tSetSenotes();

                        #endregion
                        #region [ bLogDTX詳細ログ出力 ]
                        if ( CDTXMania.ConfigIni.bLogDTX詳細ログ出力 )
						{
							foreach ( CWAV cwav in this.listWAV.Values )
							{
								Trace.TraceInformation( cwav.ToString() );
							}
							foreach ( CAVI cavi in this.listAVI.Values )
							{
								Trace.TraceInformation( cavi.ToString() );
							}
							foreach ( CBPM cbpm3 in this.listBPM.Values )
							{
								Trace.TraceInformation( cbpm3.ToString() );
							}
							foreach ( CChip chip in this.listChip )
							{
								Trace.TraceInformation( chip.ToString() );
							}
						}
						#endregion

                        //ソートっぽい
                        //this.listChip.Sort(delegate(CChip pchipA, CChip pchipB) { return pchipA.n発声時刻ms - pchipB.n発声時刻ms; } );
                                Random ran1 = new Random();
                        for (int n = 0; n < this.listChip.Count; n++ )
                        {

                            if (CDTXMania.ConfigIni.bHispeedRandom)
                            {

                                int nRan = ran1.Next(5, 40);
                                this.listChip[n].dbSCROLL = nRan / 10.0;
                            }
                        }


					}
				}
			}
		}

        /// <summary>
        /// 多分DTXとはまったく違う処理のしかたを強要されそう(震え声)
        /// </summary>
        /// <param name="strInput">譜面のデータ</param>
        private void t入力( string strInput )
        {
            if( !String.IsNullOrEmpty( strInput ) ) //空なら通さない
            {
                //ヘッダ用にひとまずSplitしたほうがいいのか・・・?
                //作戦→COURSEに対応させる予定は無いから、#STARTの「#」をデリミタとしてSplitさせたほうがよさそう。
                string[] strDelimiter = { "#START" };
                strSplitした後の譜面 = strInput.Split( strDelimiter, StringSplitOptions.RemoveEmptyEntries );
                strSplitした後の譜面[1] = "#START" + strSplitした後の譜面[1];

                //2個やる必要があるね。
                //まずはヘッダからカット、分析していこう。
                #region[ヘッダ]
                strSplitした後の譜面[0] = strSplitした後の譜面[0].Replace( Environment.NewLine, "\n" ); //改行文字を別の文字列に差し替え。
                strSplitした後の譜面[0] = strSplitした後の譜面[0].Replace( '\t', ' ' ); //何の文字か知らないけどスペースに差し替え。
                strSplitした後の譜面[0] = strSplitした後の譜面[0] + "\n";

                //おいしく仕上がったので、\nでじっくりとSplitしていこう。
                //(譜面本体と処理を同じにすると、改行文字スキップでチェックが通らない。ヘッダと譜面本体では処理の方法が違う。)
                string[] strDelimiter2 = { "\n" };
                strSplitしたヘッダ = strSplitした後の譜面[0].Split( strDelimiter2, StringSplitOptions.RemoveEmptyEntries );

                //SplitしたヘッダのLengthの回数だけ、forで回して各種情報を読み取っていく。
                //ここでフォームにも命令数を表示させておこう。
                //lblHeaderCommandNum.Text = strSplitしたヘッダ.Length.ToString();
                for( int i = 0; strSplitしたヘッダ.Length > i; i++ )
                {
                    if( strSplitしたヘッダ[ i ].StartsWith("//") == false )
                    {
                        this.t入力・行解析ヘッダ( strSplitしたヘッダ[ i ] );
                    }
                }

                #endregion


                //次に問題の譜面のほうをカット、分析していこう。
                #region[譜面]
                //まずは1行ずつ取り出していく。
                //ここでは命令部分をカットしていない。
                
                //改行文字をカット
                strSplitした後の譜面[1] = strSplitした後の譜面[1].Replace(Environment.NewLine, "\n"); //改行文字を別の文字列に差し替え。
                strSplitした後の譜面[1] = strSplitした後の譜面[1].Replace( '\t', ' ' ); //何の文字か知らないけどスペースに差し替え。
                strSplitした後の譜面[1] = strSplitした後の譜面[1] + "\n";

                //ヘッダと同じくSplitしていく。
                strSplitした譜面 = strSplitした後の譜面[1].Split( strDelimiter2, StringSplitOptions.RemoveEmptyEntries );

                //SplitしたヘッダのLengthの回数だけ、forで回して各種情報を読み取っていく。
                //ヘッダとは違い、メソッド内でフォームに命令数を表示させる。

                try
                {
                    for( int i = 0; strSplitした譜面.Length > i; i++ )
                    {
                        this.t入力・行解析譜面_test( strSplitした譜面[ i ] );
                    }
                }
                catch( Exception ex )
                {
                    Trace.WriteLine( "譜面の解析中にエラーが起きたようです。お兄様。" );
                    Trace.WriteLine( "{0}" , ex.StackTrace );
                }



                #endregion
            }
        }

        private void t入力_New( string strInput, int nコース )
        {
            if( !String.IsNullOrEmpty( strInput ) ) //空なら通さない
            {
                //まずは#COURSEでSplit。Splitできなかった場合は従来の読み込み方をします。

                //ヘッダ用にひとまずSplitしたほうがいいのか・・・?
                //作戦→COURSEに対応させる予定は無いから、#STARTの「#」をデリミタとしてSplitさせたほうがよさそう。
                string[] strDelimiter = { "#START" };
                strSplitした後の譜面 = strInput.Split( strDelimiter, StringSplitOptions.RemoveEmptyEntries );
                strSplitした後の譜面[1] = "#START" + strSplitした後の譜面[1];

                //2個やる必要があるね。
                //まずはヘッダからカット、分析していこう。
                #region[ヘッダ]
                strSplitした後の譜面[0] = strSplitした後の譜面[0].Replace( Environment.NewLine, "\n" ); //改行文字を別の文字列に差し替え。
                strSplitした後の譜面[0] = strSplitした後の譜面[0].Replace( '\t', ' ' ); //何の文字か知らないけどスペースに差し替え。
                strSplitした後の譜面[0] = strSplitした後の譜面[0] + "\n";

                //おいしく仕上がったので、\nでじっくりとSplitしていこう。
                //(譜面本体と処理を同じにすると、改行文字スキップでチェックが通らない。ヘッダと譜面本体では処理の方法が違う。)
                string[] strDelimiter2 = { "\n" };
                strSplitしたヘッダ = strSplitした後の譜面[0].Split( strDelimiter2, StringSplitOptions.RemoveEmptyEntries );

                //SplitしたヘッダのLengthの回数だけ、forで回して各種情報を読み取っていく。
                //ここでフォームにも命令数を表示させておこう。
                //lblHeaderCommandNum.Text = strSplitしたヘッダ.Length.ToString();
                for( int i = 0; strSplitしたヘッダ.Length > i; i++ )
                {
                    if( strSplitしたヘッダ[ i ].StartsWith("//") == false )
                    {
                        this.t入力・行解析ヘッダ( strSplitしたヘッダ[ i ] );
                    }
                }

                #endregion


                //次に問題の譜面のほうをカット、分析していこう。
                #region[譜面]
                //まずは1行ずつ取り出していく。
                //ここでは命令部分をカットしていない。
                
                //改行文字をカット
                strSplitした後の譜面[1] = strSplitした後の譜面[1].Replace(Environment.NewLine, "\n"); //改行文字を別の文字列に差し替え。
                strSplitした後の譜面[1] = strSplitした後の譜面[1].Replace( '\t', ' ' ); //何の文字か知らないけどスペースに差し替え。
                strSplitした後の譜面[1] = strSplitした後の譜面[1] + "\n";

                //ヘッダと同じくSplitしていく。
                strSplitした譜面 = strSplitした後の譜面[1].Split( strDelimiter2, StringSplitOptions.RemoveEmptyEntries );

                //SplitしたヘッダのLengthの回数だけ、forで回して各種情報を読み取っていく。
                //ヘッダとは違い、メソッド内でフォームに命令数を表示させる。

                try
                {
                    for( int i = 0; strSplitした譜面.Length > i; i++ )
                    {
                        this.t入力・行解析譜面_test( strSplitした譜面[ i ] );
                    }
                }
                catch( Exception ex )
                {
                    Trace.WriteLine( "譜面の解析中にエラーが起きたようです。お兄様。" );
                    Trace.WriteLine( "{0}" , ex.StackTrace );
                }



                #endregion
            }
        }

        private void t入力_V3( string strInput, int nコース )
        {
            if( !String.IsNullOrEmpty( strInput ) ) //空なら通さない
            {
                //各種フラグ設定
                bool b新処理 = false;

                //まずは#COURSEでSplit。Splitできなかった場合は従来の読み込み方をします。
                string[] strDelimiter = { "COURSE:" };
                strSplitした後の譜面 = strInput.Split( strDelimiter, StringSplitOptions.RemoveEmptyEntries );

                string[] str各コースの譜面 = new string[4];

                if( strSplitした後の譜面.Length > 1 )
                {
                    b新処理 = true;
                    for( int i = 1; i < strSplitした後の譜面.Length; i++ )
                    {
                        //0はヘッダ情報なので、iは1から開始。
                        string strCourse = strSplitした後の譜面[ i ].Substring( 0, 1 ); //どのコースかを取得。

                        int nCourse = 0;
                        if( this.CharConvertNote( strCourse ) != -1 )
                        {
                            nCourse = Convert.ToInt16( strCourse );
                            if( nCourse == 5 )
                            {
                                nCourse = 3; //現在太鼓タワー難易度は未実装。
                            }
                        }
                        else
                        {
                            if( strSplitした後の譜面[ i ].StartsWith( "Easy" ) || strSplitした後の譜面[ i ].StartsWith( "EASY" ) )
                                nCourse = 0;
                            else if( strSplitした後の譜面[ i ].StartsWith( "Normal" ) || strSplitした後の譜面[ i ].StartsWith( "NORMAL" ) )
                                nCourse = 1;
                            else if( strSplitした後の譜面[ i ].StartsWith( "Hard" ) || strSplitした後の譜面[ i ].StartsWith( "HARD" ) )
                                nCourse = 2;
                            else if( strSplitした後の譜面[ i ].StartsWith( "Oni" ) || strSplitした後の譜面[ i ].StartsWith( "ONI" ) )
                                nCourse = 3;
                            else if( strSplitした後の譜面[ i ].StartsWith( "Edit" ) || strSplitした後の譜面[ i ].StartsWith( "EDIT" ) )
                                nCourse = 4;
                        }

                        str各コースの譜面[ nCourse ] = strSplitした後の譜面[ i ].Remove( 0, 1 ); //ここで一番最初のコース判別用数字を削除。

                        if( str各コースの譜面[ nCourse ] != null )
                            this.b譜面が存在する[ nCourse ] = true;
                    }
                }
                else
                {
                    //従来の形式。
                    //ヘッダ用にひとまずSplitしたほうがいいのか・・・?
                    //作戦→COURSEに対応させる予定は無いから、#STARTの「#」をデリミタとしてSplitさせたほうがよさそう。
                    string[] strSTART = { "#START" };
                    strSplitした後の譜面 = strInput.Split( strSTART, StringSplitOptions.RemoveEmptyEntries );
                    strSplitした後の譜面[1] = "#START" + strSplitした後の譜面[1];
                }

                //2個やる必要があるね。
                //まずはヘッダからカット、分析していこう。
                #region[ヘッダ]
                //V3からは全部の文字列から取る方式に変更します。
                string strTemp = "";
                strTemp = strInput.Replace( Environment.NewLine, "\n" ); //改行文字を別の文字列に差し替え。
                strTemp = strTemp.Replace( '\t', ' ' ); //何の文字か知らないけどスペースに差し替え。
                strTemp = strTemp + "\n";

                //おいしく仕上がったので、\nでじっくりとSplitしていこう。
                //(譜面本体と処理を同じにすると、改行文字スキップでチェックが通らない。ヘッダと譜面本体では処理の方法が違う。)
                string[] strDelimiter2 = { "\n" };
                strSplitしたヘッダ = strTemp.Split( strDelimiter2, StringSplitOptions.RemoveEmptyEntries );

                //SplitしたヘッダのLengthの回数だけ、forで回して各種情報を読み取っていく。
                //ここでフォームにも命令数を表示させておこう。
                //lblHeaderCommandNum.Text = strSplitしたヘッダ.Length.ToString();
                for( int i = 0; strSplitしたヘッダ.Length > i; i++ )
                {
                    if( strSplitしたヘッダ[ i ].StartsWith("//") == false && this.CharConvertNote( strSplitしたヘッダ[i] ) == -1 )
                    {
                        try
                        {
                            this.t入力・行解析ヘッダ( strSplitしたヘッダ[ i ] );
                        }
                        catch( Exception ex )
                        {

                        }
                    }
                }

                #endregion


                //次に問題の譜面のほうをカット、分析していこう。
                #region[譜面]
                //まずは1行ずつ取り出していく。
                //ここでは命令部分をカットしていない。
                
                //改行文字をカット

                int n読み込むコース = 0;
                #region[検索]
                if (this.b譜面が存在する[CDTXMania.stage選曲.n確定された曲の難易度] == false)
                {
                    n読み込むコース = CDTXMania.stage選曲.n確定された曲の難易度;
                    n読み込むコース++;
                    for (int n = 1; n < 5; n++)
                    {
                        if (this.b譜面が存在する[n読み込むコース] == false)
                        {
                            n読み込むコース++;
                            if (n読み込むコース > 4)
                                n読み込むコース = 0;
                        }
                        else
                            break;
                    }
                }
                else
                    n読み込むコース = CDTXMania.stage選曲.n確定された曲の難易度;
                #endregion

                if ( b新処理 == true )
                {
                    //新処理では呼び出されたコースの譜面を解析していく。
                    str各コースの譜面[ n読み込むコース ] = str各コースの譜面[ n読み込むコース ].Replace(Environment.NewLine, "\n"); //改行文字を別の文字列に差し替え。
                    str各コースの譜面[ n読み込むコース ] = str各コースの譜面[ n読み込むコース ].Replace( '\t', ' ' ); //何の文字か知らないけどスペースに差し替え。
                    str各コースの譜面[ n読み込むコース ] = str各コースの譜面[ n読み込むコース ] + "\n";

                    //ここから下は旧処理のまま

                    strSplitした譜面 = str各コースの譜面[ n読み込むコース ].Split( strDelimiter2, StringSplitOptions.RemoveEmptyEntries );

                    //SplitしたヘッダのLengthの回数だけ、forで回して各種情報を読み取っていく。
                    //ヘッダとは違い、メソッド内でフォームに命令数を表示させる。

                    for( int i = 0; strSplitした譜面.Length > i; i++ )
                    {
                        this.t入力・譜面内ヘッダ解析( strSplitした譜面[ i ] );
                    }

                    try
                    {
                        #region[]
                        ////譜面本体のみ切り抜く
                        //str各コースの譜面[ n読み込むコース ] = str各コースの譜面[ n読み込むコース ].Replace( Environment.NewLine, "\n" ); //改行文字を別の文字列に差し替え。
                        //str各コースの譜面[ n読み込むコース ] = str各コースの譜面[ n読み込むコース ].Replace( '\t', ' ' ); //何の文字か知らないけどスペースに差し替え。
                        //str各コースの譜面[ n読み込むコース ] = str各コースの譜面[ n読み込むコース ] + "\n";
                        //strSplitした譜面 = str各コースの譜面[ n読み込むコース ].Split( strDelimiter2, StringSplitOptions.RemoveEmptyEntries );

                        ////ここでコメントを抹消。
                        //for( int i = 0; strSplitした譜面.Length > i; i++ )
                        //{
                        //    this.t行のコメント処理( ref strSplitした譜面[ i ] );
                        //}
                        ////削除した後に結合。
                        //str各コースの譜面[ n読み込むコース ] = string.Join( " ", strSplitした譜面 );

                        //string[] strSTART = { "#START" };
                        //string[] str譜面本体;
                        //str譜面本体 = str各コースの譜面[ n読み込むコース ].Split( strSTART, StringSplitOptions.RemoveEmptyEntries );


                        //str譜面本体 = str譜面本体[1].Split(',');
                        
                        ////譜面の解析開始前にOFFSETの処理。
                        //this.fNowTime = this.fNowTime + ( this.nOFFSET / 1000.0 );

                        //#region[ ここで挿入するのはどうかと思うけど、とりあえずここでBGMチップを追加。 ]
                        //var chip = new CChip();

                        //chip.nチャンネル番号 = 0x01;
                        //chip.n発声位置 = 384 * 2;
                        //chip.n整数値 = 0x01;
                        //chip.n整数値・内部番号 = 1;

                        //// チップを配置。
                        //this.listChip.Add( chip );

                        //var chip1 = new CChip();
                        //chip1.nチャンネル番号 = 0x54;
                        //chip1.n発声位置 = 384 * 2;
                        //chip1.n整数値 = 0x01;
                        //chip1.n整数値・内部番号 = 1;


                        //// チップを配置。

                        //this.listChip.Add( chip1 );
                        //#endregion

                        //for( int i = 0; str譜面本体.Length > i; i++ )
                        //{
                        //    this.t入力・行解析譜面_V3( str譜面本体[ i ] + "," ); //譜面を作る人がすんごい馬鹿じゃなければ多分これでいけるでしょ。
                        //}
                        #endregion
                        #region[ Ver2015051000まで。動かなくなったら迷わずここを使うこと。 ]
                        //譜面本体のみ切り抜く
                        str各コースの譜面[ n読み込むコース ] = str各コースの譜面[ n読み込むコース ].Replace( Environment.NewLine, "\n" ); //改行文字を別の文字列に差し替え。
                        str各コースの譜面[ n読み込むコース ] = str各コースの譜面[ n読み込むコース ].Replace( '\t', ' ' ); //何の文字か知らないけどスペースに差し替え。
                        str各コースの譜面[ n読み込むコース ] = str各コースの譜面[ n読み込むコース ] + "\n";
                        strSplitした譜面 = str各コースの譜面[ n読み込むコース ].Split( strDelimiter2, StringSplitOptions.RemoveEmptyEntries );

                        //ここでコメントを抹消。
                        for( int i = 0; strSplitした譜面.Length > i; i++ )
                        {
                            this.t行のコメント処理( ref strSplitした譜面[ i ] );
                        }
                        //削除した後に結合。
                        //str各コースの譜面[ n読み込むコース ] = string.Join( " ", strSplitした譜面 );

                        string[] strSTART = { "#START" };
                        string[] str譜面本体;
                        str各コースの譜面 = str各コースの譜面[ n読み込むコース ].Split( strSTART, StringSplitOptions.RemoveEmptyEntries );

                        str各コースの譜面[ 1 ] = "#START" + str各コースの譜面[ 1 ];
                        str各コースの譜面[ 1 ] = str各コースの譜面[ 1 ].Replace( Environment.NewLine, "\n" ); //改行文字を別の文字列に差し替え。
                        str各コースの譜面[ 1 ] = str各コースの譜面[ 1 ].Replace( '\t', ' ' ); //何の文字か知らないけどスペースに差し替え。
                        str各コースの譜面[ 1 ] = str各コースの譜面[ 1 ] + "\n";
                        strSplitした譜面 = str各コースの譜面[ 1 ].Split( strDelimiter2, StringSplitOptions.RemoveEmptyEntries );


                        for( int i = 0; strSplitした譜面.Length > i; i++ )
                        {
                            this.t入力・行解析譜面_test( strSplitした譜面[ i ] );
                            //this.t入力・行解析譜面_V3( str譜面本体[ i ] ); //譜面を作る人がすんごい馬鹿じゃなければ多分これでいけるでしょ。
                        }
                        #endregion
                    }
                    catch( Exception ex )
                    {
                        Trace.WriteLine( "譜面の解析中にエラーが起きたようです。お兄様。" );
                        Trace.WriteLine( "{0}" , ex.StackTrace );
                    }
                }
                else
                {
                    strSplitした後の譜面[1] = strSplitした後の譜面[1].Replace(Environment.NewLine, "\n"); //改行文字を別の文字列に差し替え。
                    strSplitした後の譜面[1] = strSplitした後の譜面[1].Replace( '\t', ' ' ); //何の文字か知らないけどスペースに差し替え。
                    strSplitした後の譜面[1] = strSplitした後の譜面[1] + "\n";


                    //ヘッダと同じくSplitしていく。
                    strSplitした譜面 = strSplitした後の譜面[1].Split( strDelimiter2, StringSplitOptions.RemoveEmptyEntries );

                    //SplitしたヘッダのLengthの回数だけ、forで回して各種情報を読み取っていく。
                    //ヘッダとは違い、メソッド内でフォームに命令数を表示させる。

                    this.b譜面が存在する[ 3 ] = true;

                    try
                    {
                        for( int i = 0; strSplitした譜面.Length > i; i++ )
                        {
                            this.t入力・行解析譜面_test( strSplitした譜面[ i ] );
                        }
                    }
                    catch( Exception ex )
                    {
                        Trace.WriteLine( "譜面の解析中にエラーが起きたようです。お兄様。" );
                        Trace.WriteLine( "{0}" , ex.StackTrace );
                    }
                }
                #endregion
            }
        }

		//現在、以下のような行には対応できていません。
		//・パラメータを持つ命令がある
		//・行の途中に命令がある
        private int t文字数解析( string InputText )
        {
            int n文字数 = 0;

            for( int i = 0; i < InputText.Length; i++ )
            {
                if( this.CharConvertNote( InputText.Substring( i, 1 ) ) != -1 )
                {
                    n文字数++;
                }
            }


            return n文字数;
        }

        private void t入力・譜面内ヘッダ解析( string InputText )
        {
            #region[ ヘッダ命令 ]
            //ヘッダ命令だった場合、読み取りが終わったら即return。
            //条件文は「命令行以外」「行最初の文字列が数字以外」
            if( this.CharConvertNote( InputText.Substring( 0, 1 ) ) == -1 )
            {
                string[] strArray = InputText.Split( new char[] { ':' } );
                string strCommandName = "";
                string strCommandParam = "";

                //まずは「:」でSplitして、コマンド名、パラメータを分ける。
                if( strArray.Length == 2 )
                {
                    strCommandName = strArray[0].Trim();
                    strCommandParam = strArray[1].Trim();
                }

                if( strCommandName.Equals( "LEVEL" ) )
                {
                    this.LEVEL.Drums = Convert.ToInt16( strCommandParam );
                }
                else if( strCommandName.Equals( "" ) )
                {

                }
                else if( strCommandName.Equals( "BALLOON" ) )
                {
                    string[] strParam = strCommandParam.Split( ',' );
                    for( int n = 0; n < strParam.Length; n++ )
                    {
                        int n打数;
                        try
                        {
                            n打数 = Convert.ToInt32( strParam[ n ] );
                        }
                        catch(Exception ex)
                        {
                            Trace.TraceError( "おや?エラーが出たようです。お兄様。" );
                            Trace.TraceError( "エラー:{0}", ex.StackTrace );
                            break;
                        }
                        this.listBalloon_Normal.Add( n打数 );
                    }
                }
                else if( strCommandName.Equals( "BALLOONNOR" ) )
                {
                    string[] strParam = strCommandParam.Split( ',' );
                    for( int n = 0; n < strParam.Length; n++ )
                    {
                        int n打数;
                        try
                        {
                            n打数 = Convert.ToInt32( strParam[ n ] );
                        }
                        catch(Exception ex)
                        {
                            Trace.TraceError( "おや?エラーが出たようです。お兄様。" );
                            Trace.TraceError( "エラー:{0}", ex.StackTrace );
                            break;
                        }
                        this.listBalloon_Normal.Add( n打数 );
                    }
                }
                else if( strCommandName.Equals( "BALLOONEXP" ) )
                {
                    string[] strParam = strCommandParam.Split( ',' );
                    for( int n = 0; n < strParam.Length; n++ )
                    {
                        int n打数;
                        try
                        {
                            n打数 = Convert.ToInt32( strParam[ n ] );
                        }
                        catch(Exception ex)
                        {
                            Trace.TraceError( "おや?エラーが出たようです。お兄様。" );
                            Trace.TraceError( "エラー:{0}", ex.StackTrace );
                            break;
                        }
                        this.listBalloon_Expert.Add( n打数 );
                    }
                }
                else if( strCommandName.Equals( "BALLOONMAS" ) )
                {
                    string[] strParam = strCommandParam.Split( ',' );
                    for( int n = 0; n < strParam.Length; n++ )
                    {
                        int n打数;
                        try
                        {
                            n打数 = Convert.ToInt32( strParam[ n ] );
                        }
                        catch(Exception ex)
                        {
                            Trace.TraceError( "おや?エラーが出たようです。お兄様。" );
                            Trace.TraceError( "エラー:{0}", ex.StackTrace );
                            break;
                        }
                        this.listBalloon_Master.Add( n打数 );
                    }
                }
                else if( strCommandName.Equals( "SCOREMODE" ) )
                {
                    if( !string.IsNullOrEmpty( strCommandParam ) )
                    {
                        this.nScoreMode = Convert.ToInt16( strCommandParam );
                    }
                }
                else if( strCommandName.Equals( "SCOREINIT" ) )
                {
                    if( !string.IsNullOrEmpty( strCommandParam ) )
                    {
                        string[] scoreinit = strCommandParam.Split(',');

                        this.nScoreInit[ 0 ] = Convert.ToInt16( scoreinit[ 0 ] );
                        if( scoreinit.Length == 2 )
                        this.nScoreInit[ 1 ] = Convert.ToInt16( scoreinit[ 1 ] );
                    }
                }
                else if( strCommandName.Equals( "SCOREDIFF" ) )
                {
                    if( !string.IsNullOrEmpty( strCommandParam ) )
                    {
                        this.nScoreDiff = Convert.ToInt16( strCommandParam );
                    }
                }

                return;
            }
            #endregion
        }

        /// <summary>
        /// V3では一部のヘッダーも解析する。
        /// </summary>
        /// <param name="InputText"></param>
        private void t入力・行解析譜面_V3( string InputText )
		{
            //bool b命令行である = false;

            //if( InputText.StartsWith( "#" ) )
            //{
            //    b命令行である = true;
            //}

            this.n文字数 = this.t文字数解析( InputText );


            //命令じゃない行。つまり普通の行。
            #region[ 命令以外の行 ]
            //if( b命令行である == false )
            {
                #region[ 配置 ]
                //DTXManiaは2文字で1つだが、TJAはそうでもないので特に考慮とかはしない。
                for( int i = 0; i < InputText.Length; i++ )
                {
                    #region [ nオブジェクト数値 を１つ取得する。'0' なら無視。]
				    //-----------------
				    int nオブジェクト数値 = 0;

					nオブジェクト数値 = this.CharConvertNote( InputText.Substring( i, 1 ) );
			    	//-----------------
		    		#endregion

                    if( InputText.Substring(i, 1) == "," )
                    {
                        //発声時刻の計算メソッド依存を消してみるテスト。
                        //「,」の後に「#BRANCHSTART」が設置されるから、list中の位置を記録しておいて、
                        //BRANCHSTARTが命令されたら記録されていた位置にある小節線チップの黄色フラグを入れる。
                        //var chipBar = new CChip();

                        //chipBar.nチャンネル番号 = 0x50;
                        //chipBar.n発声位置 = ( ( this.n現在の小節数 ) * 384 ) - 1;
                        //chipBar.n整数値 = 0x50;
                        //chipBar.n整数値・内部番号 = 1;
                        //chipBar.n発声時刻ms = (int)(this.fNowTime * 1000);

                        //this.listChip.Add( chipBar );

                        this.n現在の小節数++;
                        continue;
                    }
                    if( InputText.Substring(i, 1) == "#" )
                    {
                        string strTemp = InputText.Substring( i, InputText.Length - i );
                        this.t入力・命令チップ挿入( ref strTemp );
                        InputText = strTemp;
                        i = 0;
                        continue;
                    }
                    if( nオブジェクト数値 == -1 )   continue;

                    //Senotes用の発声位置計算の設置のため構造変更。
    				if( nオブジェクト数値 > 0 )
                    {

                        if( nオブジェクト数値 >= 5 && nオブジェクト数値 <= 7 )
                        {
                            if( nNowRoll != 0 )
                                continue;
                            else
                            {
                                this.nNowRollCount = listChip.Count;
                                nNowRoll = nオブジェクト数値;
                            }
                        }


                        //ためしに割り込む。
                        var chip = new CChip();

				        chip.nチャンネル番号 = 0x92 + nオブジェクト数値;
				        chip.n発声位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / this.n文字数 );
                        chip.f発声位置 = ( this.n現在の小節数 * 384.0f ) + (float)( ( 384.0f * i ) / this.n文字数 );
                        chip.fBMSCROLLTime = this.fNowBMScrollTime;
    				    chip.n整数値 = nオブジェクト数値;
				        chip.n整数値・内部番号 = 1;
                        chip.dbBPM = this.dbNowBPM;
                        chip.dbSCROLL = this.dbNowSCROLL;
                        chip.nコース = this.n現在のコース;
                        chip.n分岐回数 = this.n内部番号BRANCH1to;

                        chip.n発声時刻ms = (int)(this.fNowTime * 1000);
                        chip.f発声時刻ms = (float)this.fNowTime * 1000.0f;

                        //2015.03.27 kairera0467
                        if( this.bチップがある.Branch )
                        {
                            switch( this.n現在のコース )
                            {
                                case 0:
                                    chip.dbSCROLL = this.dbNowSCROLL_Normal;
                                    break;
                                case 1:
                                    chip.dbSCROLL = this.dbNowSCROLL_Expert;
                                    break;
                                case 2:
                                    chip.dbSCROLL = this.dbNowSCROLL_Master;
                                    break;
                            }

                            if (chip.dbSCROLL == 0.0) chip.dbSCROLL = 1.0;
                        }

                        if( nオブジェクト数値 == 7 )
                        {
                            switch( this.n現在のコース )
                            {
                                case 0:
                                    if( this.listBalloon_Normal.Count == 0 )
                                    {
                                        chip.nBalloon = 5;
                                        break;
                                    }

                                    chip.nBalloon = this.listBalloon_Normal[ this.listBalloon_Normal_数値管理 ];
                                    this.listBalloon_Normal_数値管理++;
                                    break;
                                case 1:
                                    if( this.listBalloon_Expert.Count == 0 )
                                    {
                                        chip.nBalloon = 5;
                                        break;
                                    }
                                    
                                    chip.nBalloon = this.listBalloon_Expert[ this.listBalloon_Expert_数値管理 ];
                                    this.listBalloon_Expert_数値管理++;
                                    break;
                                case 2:
                                    if( this.listBalloon_Master.Count == 0 )
                                    {
                                        chip.nBalloon = 5;
                                        break;
                                    }

                                    chip.nBalloon = this.listBalloon_Master[ this.listBalloon_Master_数値管理 ];
                                    this.listBalloon_Master_数値管理++;
                                    break;
                            }
                        }

                        if( nオブジェクト数値 == 8 )
                        {
                            //たぶんこれlistChipを弄らなきゃいけないパターンですよ。
                        
                            //this.nCount--;
                            chip.nノーツ終了位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / this.n文字数 );
                            chip.n連打音符State = nNowRoll;
                            listChip[ nNowRollCount ].nノーツ終了位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / this.n文字数 );
                            //listChip[ nNowRollCount ].dbBPM = this.dbNowBPM;
                            //listChip[ nNowRollCount ].dbSCROLL = this.dbNowSCROLL;
                            nNowRoll = 0;
                            //continue;
                        }

	    			    #region [ chip.e楽器パート = ... ]
				        //-----------------
                        //全部太鼓扱い
        				chip.e楽器パート = E楽器パート.TAIKO;
	    	    		//-----------------
		    	    	#endregion

        				// チップを配置。

                        #region[ 固定される種類のsenotesはここで設定しておく。 ]
                        switch( nオブジェクト数値 )
                        {
                            case 3:
                                chip.nSenote = 5;
                                break;
                            case 4:
                                chip.nSenote = 6;
                                break;
                            case 5:
                                chip.nSenote = 7;
                                break;
                            case 6:
                                chip.nSenote = 0xA;
                                break;
                            case 7:
                                chip.nSenote = 0xB;
                                break;
                            case 8:
                                chip.nSenote = 0xC;
                                break;
                        }
                        #endregion

                        if( nオブジェクト数値 < 5 )
                        {
                            if( this.b最初の分岐である == false )
                                this.nノーツ数[ this.n現在のコース ]++;
                            else
                                this.nノーツ数[ 3 ]++;
                        }


				        this.listChip.Add( chip );

                    }
                    this.fNowTime += (double)( ( 15000.0 / this.dbNowBPM * ( this.dbBarLength ) * (16.0 / this.n文字数)) / 1000.0 );
                    this.fNowBMScrollTime += (double)(( this.dbBarLength ) * (16.0 / this.n文字数));
                }

                #endregion
            }
            #endregion
        }

        /// <summary>
        /// Substringで切り抜きを開始する位置は命令の文字数です。(「#GOGOSTART」なら10文字)
        /// パラメータが存在するものは、上にパラメータの文字数合計とスペースの文字数を考慮して削ります。
        /// </summary>
        /// <param name="InputText"></param>
        private void t入力・命令チップ挿入( ref string InputText )
        {
            #region[ 命令行 ]
            {
                //命令には数値入りのものがあるので、慎重に取り扱いましょう。
                //数値入りのものにもデリミタ文字が違うものがありますので、スプリットは分岐内で行う必要があります。
                char[] chDelimiter = new char[] { ' ' };
                string[] strArray;

                if( InputText.StartsWith( "#START" )  )
                {
                    //#STARTと同時に鳴らすのはどうかと思うけどしゃーなしだな。
                    
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x01;
				    chip.n発声位置 = 384;
				    chip.n整数値 = 0x01;
				    chip.n整数値・内部番号 = 1;

    				// チップを配置。
				    this.listChip.Add( chip );

                    var chip1 = new CChip();
				    chip1.nチャンネル番号 = 0x54;
				    chip1.n発声位置 = 384;
				    chip1.n整数値 = 0x01;
				    chip1.n整数値・内部番号 = 1;

    				// チップを配置。

				    this.listChip.Add( chip1 );
                }
                else if( InputText.StartsWith( "#END" )  )
                {
                    //ためしに割り込む。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xFF;
				    chip.n発声位置 = ( ( this.n現在の小節数 + 2 ) * 384 );
                    chip.n発声時刻ms = (int)( this.fNowTime * 1000 );
				    chip.n整数値 = 0xFF;
				    chip.n整数値・内部番号 = 1;
    				// チップを配置。

				    this.listChip.Add( chip );

                    if( this.bチップがある.Branch )
                    {
                        for( int f = 0; f <= 2; f++ )
                        {
                            this.nノーツ数[ f ] = this.nノーツ数[ f ] + this.nノーツ数[ 3 ];
                        }
                    }

                    //InputText = InputText.Substring( 4, InputText.Length - 4 );
                }

                else if( InputText.StartsWith( "#BPMCHANGE" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    double dbBPM = Convert.ToDouble( strArray[1] );

                    this.listBPM.Add( this.n内部番号BPM1to - 1, new CBPM() { n内部番号 = this.n内部番号BPM1to - 1, n表記上の番号 = 0, dbBPM値 = dbBPM, } );


                    //チップ追加して割り込んでみる。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x08;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0x00;
				    chip.n整数値・内部番号 = this.n内部番号BPM1to - 1;

    				// チップを配置。
                    
				    this.listChip.Add( chip );
                    this.n内部番号BPM1to++;

                    InputText = InputText.Substring( 10, InputText.Length - 10 );
                }
                else if( InputText.StartsWith( "#SCROLL" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    double dbSCROLL = Convert.ToDouble( strArray[1] );

                    this.listSCROLL.Add( this.n内部番号SCROLL1to, new CSCROLL() { n内部番号 = this.n内部番号SCROLL1to, n表記上の番号 = 0, dbSCROLL値 = dbSCROLL, } );

                    switch (this.n現在のコース)
                    {
                        case 0:
                            this.dbNowSCROLL_Normal = dbSCROLL;
                            break;
                        case 1:
                            this.dbNowSCROLL_Expert = dbSCROLL;
                            break;
                        case 2:
                            this.dbNowSCROLL_Master = dbSCROLL;
                            break;
                    }

                    //チップ追加して割り込んでみる。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x9D;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 ) - 1;
                    chip.n発声時刻ms = (int)( this.fNowTime * 1000 );
				    chip.n整数値 = 0x00;
				    chip.n整数値・内部番号 = this.n内部番号SCROLL1to;
                    chip.dbSCROLL = dbSCROLL;
                    chip.nコース = this.n現在のコース;

    				// チップを配置。
                    
				    this.listChip.Add( chip );
                    this.n内部番号SCROLL1to++;

                    //7 + 1 + パラメータの文字数
                    int nLength = dbSCROLL.ToString().Length;
                    InputText = InputText.Substring( 8 + nLength, InputText.Length - ( 8 + nLength ) );
                }
                else if( InputText.StartsWith( "#MEASURE" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    strArray = strArray[1].Split( new char[]{ '/' } );

                    double[] dbLength = new double[2];
                    dbLength[ 0 ] = Convert.ToDouble( strArray[ 0 ] );
                    dbLength[ 1 ] = Convert.ToDouble( strArray[ 1 ] );

                    double db小節長倍率 = dbLength[ 0 ] / dbLength[ 1 ];
                    this.dbBarLength = db小節長倍率;

                    var chip = new CChip();

                    chip.nチャンネル番号 = 0x02;
                    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
                    chip.db実数値 = db小節長倍率;
                    chip.n整数値 = 0x01;
                    chip.n整数値・内部番号 = 1;
                    // チップを配置。

                    this.listChip.Add(chip);
                    
                    //lbMaster.Items.Add( ";拍子変更 " + strArray[0] + "/" + strArray[1] );
                }
                else if( InputText.StartsWith( "#DELAY" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    int nDELAY = (int)( Convert.ToDouble( strArray[1] ) * 1000 );
                    

                    this.listDELAY.Add( this.n内部番号DELAY1to, new CDELAY() { n内部番号 = this.n内部番号DELAY1to, n表記上の番号 = 0, nDELAY値 = nDELAY, } );


                    //チップ追加して割り込んでみる。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xDC;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0x00;
				    chip.n整数値・内部番号 = this.n内部番号DELAY1to;

    				// チップを配置。
                    
				    this.listChip.Add( chip );
                    this.n内部番号DELAY1to++;

                }

                else if( InputText.StartsWith( "#GOGOSTART" ) )
                {
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x9E;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
                    chip.n発声時刻ms = (int)( this.fNowTime * 1000 );
				    chip.n整数値 = 0x9E;
				    chip.n整数値・内部番号 = 1;


    				// チップを配置。
				    this.listChip.Add( chip );

                    InputText = InputText.Substring( 10, InputText.Length - 10 );
                }
                else if( InputText.StartsWith( "#GOGOEND" ) )
                {
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x9F;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
                    chip.n発声時刻ms = (int)( this.fNowTime * 1000 );
				    chip.n整数値 = 0x9E;
				    chip.n整数値・内部番号 = 1;

    				// チップを配置。
				    this.listChip.Add( chip );

                    InputText = InputText.Substring( 8, InputText.Length - 8 );
                }
                else if( InputText.StartsWith( "#SECTION" ) )
                {
                    //分岐:条件リセット
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xDD;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0xDD;
				    chip.n整数値・内部番号 = 1;

    				// チップを配置。
				    this.listChip.Add( chip );
                }
                else if( InputText.StartsWith( "#BRANCHSTART" ) )
                {
                    this.bチップがある.Branch = true;
                    this.b最初の分岐である = false;

                    //分岐:分岐スタート
                    int n条件 = 0;
                    strArray = InputText.Split( chDelimiter );
                    strArray = strArray[1].Split( ',' );
                    
                    //条件数値。めちゃくちゃ無理やりな実装でスマン。
                    double[] nNum = new double[2];
                    string strNumA;
                    string strNumB;

                    if (strArray.Length == 3)
                    {
                        strNumA = strArray[1];
                        strNumB = strArray[2];

                        nNum[0] = Convert.ToDouble( strNumA );
                        nNum[1] = Convert.ToDouble( strNumB );
                        switch (strArray[0])
                        {
                            case "p":
                                n条件 = 0;
                                break;
                            case "r":
                                n条件 = 1;
                                break;
                            case "s":
                                n条件 = 2;
                                break;
                            case "d":
                                n条件 = 3;
                                break;
                            default:
                                n条件 = 0;
                                break;
                        }
                    }

                    if( strArray.Length == 2 )
                    {
                        strArray = InputText.Split( chDelimiter );
                        strNumA = strArray[2].Split( ',' )[0];
                        strNumB = strArray[3].Split( ',' )[0];

                        nNum[0] = Convert.ToDouble( strNumA );
                        nNum[1] = Convert.ToDouble( strNumB );
                        switch (strArray[1])
                        {
                            case "p,":
                                n条件 = 0;
                                break;
                            case "r,":
                                n条件 = 1;
                                break;
                            case "s,":
                                n条件 = 2;
                                break;
                            case "d,":
                                n条件 = 3;
                                break;
                            default:
                                n条件 = 0;
                                break;
                        }


                    }



                    //まずはリストに現在の小節、発声位置、分岐条件を追加。
                    var branch = new CBRANCH();
                    branch.db判定時間 = 0;
                    branch.db分岐時間 = ( ( this.n現在の小節数 ) * 384 );
                    branch.n現在の小節 = this.n現在の小節数;
                    branch.n条件数値A = nNum[0];
                    branch.n条件数値B = nNum[1];
                    branch.n内部番号 = this.n内部番号BRANCH1to;
                    branch.n表記上の番号 = 0;
                    branch.n分岐の種類 = n条件;
                    branch.n命令時のChipList番号 = this.listChip.Count;

                    this.listBRANCH.Add( this.n内部番号BRANCH1to, branch );


                    //分岐アニメ開始時に設置。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xDE;
				    chip.n発声位置 = ( ( this.n現在の小節数 - 1 ) * 384 );
				    chip.n整数値 = 0xDE;
				    chip.n整数値・内部番号 = this.n内部番号BRANCH1to;

    				// チップを配置。
				    this.listChip.Add( chip );

                    //実質的な位置に配置
                    var chip2 = new CChip();

				    chip2.nチャンネル番号 = 0xDF;
				    chip2.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip2.n整数値 = 0xDF;
				    chip2.n整数値・内部番号 = this.n内部番号BRANCH1to;

				    this.listChip.Add( chip2 );

                    this.n内部番号BRANCH1to++;
                }
                else if( InputText.StartsWith( "#N" ) )
                {
                    //分岐:普通譜面
                    this.n現在のコース = 0;
                    this.n現在の小節数 = this.listBRANCH[ this.n内部番号BRANCH1to - 1 ].n現在の小節;
                }
                else if( InputText.StartsWith( "#E" ) )
                {
                    //分岐:玄人譜面
                    this.n現在のコース = 1;
                    this.n現在の小節数 = this.listBRANCH[ this.n内部番号BRANCH1to - 1 ].n現在の小節;
                }
                else if( InputText.StartsWith( "#M") )
                {
                    //分岐:達人譜面
                    this.n現在のコース = 2;
                    this.n現在の小節数 = this.listBRANCH[ this.n内部番号BRANCH1to - 1 ].n現在の小節;
                }
                else if( InputText.StartsWith( "#BARLINEOFF") )
                {
                    var chip = new CChip();

                    chip.nチャンネル番号 = 0xE0;
                    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 ) - 1;
                    chip.n整数値 = 0xE0;
                    chip.n整数値・内部番号 = 1;

                    this.listChip.Add( chip );
                }
                else if( InputText.StartsWith( "#BARLINEON" ) )
                {
                    var chip = new CChip();

                    chip.nチャンネル番号 = 0xE0;
                    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 ) - 1;
                    chip.n整数値 = 0xE0;
                    chip.n整数値・内部番号 = 2;

                    this.listChip.Add( chip );
                }
            }
            #endregion
        }



        private void t入力・行解析譜面_test( string InputText )
		{
            bool b命令行である = false;

            if( InputText.StartsWith( "#" ) )
            {
                b命令行である = true;
            }

            //命令じゃない行。つまり普通の行。
            if( b命令行である == false )
            {
                //lbMaster.Items.Add( InputText );
                
                //小節末端を削除。2行以上に渡る譜面?忘れてしまえそんなもん。
                //ついでにInputTextに上書き。余計な変数を減らす。
                string[] strA = InputText.Split( ',' );
                InputText = strA[0];

                //この順番は変えたほうがいいかも。
                //this.n現在の小節数++;
                //lblLineCountNum.Text = this.n現在の小節数.ToString();
                if( strA.Length == 1 )
                {
                    this.strTemp = strA[0];
                    this.n文字数 = strA[0].Length;
                    this.b直前の行に小節末端定義が無かった = true;

                    return;
                }
                if( this.b直前の行に小節末端定義が無かった == true )
                {
                    strA[0] = this.strTemp + strA[0];

                }



                #region[ 1行の文字数を取得する ]

                //int n文字数 = 0;

			    var sb = new StringBuilder( InputText.Length );

			    // strパラメータを先頭から1文字ずつ見ながら正規化（無効文字('_')を飛ばしたり不正な文字でエラーを出したり）し、sb へ格納する。

			    CharEnumerator ce = InputText.GetEnumerator();
			    while( ce.MoveNext() )
			    {
				    if( ce.Current == ',' )		// '_' は無視。
					    continue;

				    sb.Append( ce.Current );
				    this.n文字数++;
			    }
                #endregion

                #region[ 配置 ]
                //DTXManiaは2文字で1つだが、TJAはそうでもないので特に考慮とかはしない。
                for( int i = 0; i < this.n文字数; i++ )
                {
                    #region [ nオブジェクト数値 を１つ取得する。'0' なら無視。]
				    //-----------------
				    int nオブジェクト数値 = 0;

					//nオブジェクト数値 = this.CharConvertNote( InputText.Substring( i, 1 ) );
                    nオブジェクト数値 = this.CharConvertNote( strA[0].Substring( i, 1 ) );

                    //Senotes用の発声位置計算の設置のため構造変更。
    				if( nオブジェクト数値 != 0 )
                    {

                        if( nオブジェクト数値 >= 5 && nオブジェクト数値 <= 7 )
                        {
                            if( nNowRoll != 0 )
                                continue;
                            else
                            {
                                this.nNowRollCount = listChip.Count;
                                nNowRoll = nオブジェクト数値;
                            }
                        }

			    	    //-----------------
		    		    #endregion

                        //ためしに割り込む。
                        var chip = new CChip();

				        chip.nチャンネル番号 = 0x92 + nオブジェクト数値;
				        chip.n発声位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / this.n文字数 );
                        chip.f発声位置 = ( this.n現在の小節数 * 384.0f ) + (float)( ( 384.0f * i ) / this.n文字数 );
                        //chip.fBMSCROLLTime = (float)(( this.dbBarLength ) * (16.0f / this.n文字数));
                        chip.fBMSCROLLTime = this.fNowBMScrollTime;
    				    chip.n整数値 = nオブジェクト数値;
				        chip.n整数値・内部番号 = 1;
                        chip.dbBPM = this.dbNowBPM;
                        chip.dbSCROLL = this.dbNowSCROLL;
                        chip.nコース = this.n現在のコース;
                        chip.n分岐回数 = this.n内部番号BRANCH1to;

                        //2015.03.27 kairera0467
                        if( this.bチップがある.Branch )
                        {
                            switch( this.n現在のコース )
                            {
                                case 0:
                                    chip.dbSCROLL = this.dbNowSCROLL_Normal;
                                    break;
                                case 1:
                                    chip.dbSCROLL = this.dbNowSCROLL_Expert;
                                    break;
                                case 2:
                                    chip.dbSCROLL = this.dbNowSCROLL_Master;
                                    break;
                            }

                            if (chip.dbSCROLL == 0.0) chip.dbSCROLL = 1.0;
                        }

                        if( nオブジェクト数値 == 7 )
                        {
                            switch( this.n現在のコース )
                            {
                                case 0:
                                    if( this.listBalloon_Normal.Count == 0 )
                                    {
                                        chip.nBalloon = 5;
                                        break;
                                    }

                                    chip.nBalloon = this.listBalloon_Normal[ this.listBalloon_Normal_数値管理 ];
                                    this.listBalloon_Normal_数値管理++;
                                    break;
                                case 1:
                                    if( this.listBalloon_Expert.Count == 0 )
                                    {
                                        chip.nBalloon = 5;
                                        break;
                                    }
                                    
                                    chip.nBalloon = this.listBalloon_Expert[ this.listBalloon_Expert_数値管理 ];
                                    this.listBalloon_Expert_数値管理++;
                                    break;
                                case 2:
                                    if( this.listBalloon_Master.Count == 0 )
                                    {
                                        chip.nBalloon = 5;
                                        break;
                                    }

                                    chip.nBalloon = this.listBalloon_Master[ this.listBalloon_Master_数値管理 ];
                                    this.listBalloon_Master_数値管理++;
                                    break;
                            }
                        }

                        if( nオブジェクト数値 == 8 )
                        {
                            //たぶんこれlistChipを弄らなきゃいけないパターンですよ。
                        
                            //this.nCount--;
                            chip.nノーツ終了位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / this.n文字数 );
                            chip.n連打音符State = nNowRoll;
                            listChip[ nNowRollCount ].nノーツ終了位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / this.n文字数 );
                            //listChip[ nNowRollCount ].dbBPM = this.dbNowBPM;
                            //listChip[ nNowRollCount ].dbSCROLL = this.dbNowSCROLL;
                            nNowRoll = 0;
                            //continue;
                        }

	    			    #region [ chip.e楽器パート = ... ]
				    //-----------------
                    //全部太鼓扱い
    				chip.e楽器パート = E楽器パート.TAIKO;
		    		//-----------------
			    	#endregion

        				// チップを配置。

                        #region[ 固定される種類のsenotesはここで設定しておく。 ]
                    switch( nオブジェクト数値 )
                    {
                        case 3:
                            chip.nSenote = 5;
                            break;
                        case 4:
                            chip.nSenote = 6;
                            break;
                        case 5:
                            chip.nSenote = 7;
                            break;
                        case 6:
                            chip.nSenote = 0xA;
                            break;
                        case 7:
                            chip.nSenote = 0xB;
                            break;
                        case 8:
                            chip.nSenote = 0xC;
                            break;
                    }
                    #endregion

                        if( nオブジェクト数値 < 5 )
                        {
                            if( this.b最初の分岐である == false )
                                this.nノーツ数[ this.n現在のコース ]++;
                            else
                                this.nノーツ数[ 3 ]++;
                        }


				        this.listChip.Add( chip );

                    }
                    this.fNowBMScrollTime += (double)(( this.dbBarLength ) * (16.0 / this.n文字数));
                }



                if( this.b直前の行に小節末端定義が無かった == true )
                {
                    this.listChip[ this.n命令行のチップ番号_temp - 1 ].n発声位置 = ( ( this.n現在の小節数 * 384 ) + ( ( 384 * strTemp.Length ) / this.n文字数 ) );
                    this.b直前の行に小節末端定義が無かった = false;
                    this.n文字数 = 0;
                }

                if( strA.Length == 2 )
                {
                    this.n現在の小節数++;
                    this.n文字数 = 0;
                }
                #endregion
            }
            else
            {
                //命令には数値入りのものがあるので、慎重に取り扱いましょう。
                //数値入りのものにもデリミタ文字が違うものがありますので、スプリットは分岐内で行う必要があります。
                char[] chDelimiter = new char[] { ' ' };
                string[] strArray;

                if( InputText.StartsWith( "#START" )  )
                {
                    //#STARTと同時に鳴らすのはどうかと思うけどしゃーなしだな。
                    
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x01;
				    chip.n発声位置 = 384;
				    chip.n整数値 = 0x01;
				    chip.n整数値・内部番号 = 1;

    				// チップを配置。
				    this.listChip.Add( chip );

                    var chip1 = new CChip();
				    chip1.nチャンネル番号 = 0x54;
				    chip1.n発声位置 = 384;
				    chip1.n整数値 = 0x01;
				    chip1.n整数値・内部番号 = 1;

    				// チップを配置。

				    this.listChip.Add( chip1 );
                }
                else if( InputText.StartsWith( "#END" )  )
                {
                    //ためしに割り込む。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xFF;
				    chip.n発声位置 = ( ( this.n現在の小節数 + 2 ) * 384 );
				    chip.n整数値 = 0xFF;
				    chip.n整数値・内部番号 = 1;
    				// チップを配置。

				    this.listChip.Add( chip );

                    if( this.bチップがある.Branch )
                    {
                        for( int f = 0; f <= 2; f++ )
                        {
                            this.nノーツ数[ f ] = this.nノーツ数[ f ] + this.nノーツ数[ 3 ];
                        }
                    }
                }

                else if( InputText.StartsWith( "#BPMCHANGE" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    double dbBPM = Convert.ToDouble( strArray[1] );

                    this.listBPM.Add( this.n内部番号BPM1to - 1, new CBPM() { n内部番号 = this.n内部番号BPM1to - 1, n表記上の番号 = 0, dbBPM値 = dbBPM, } );


                    //チップ追加して割り込んでみる。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x08;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0x00;
				    chip.n整数値・内部番号 = this.n内部番号BPM1to - 1;

    				// チップを配置。
                    
				    this.listChip.Add( chip );
                    this.n内部番号BPM1to++;
                }
                else if( InputText.StartsWith( "#SCROLL" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    double dbSCROLL = Convert.ToDouble( strArray[1] );

                    this.listSCROLL.Add( this.n内部番号SCROLL1to, new CSCROLL() { n内部番号 = this.n内部番号SCROLL1to, n表記上の番号 = 0, dbSCROLL値 = dbSCROLL, } );

                    switch (this.n現在のコース)
                    {
                        case 0:
                            this.dbNowSCROLL_Normal = dbSCROLL;
                            break;
                        case 1:
                            this.dbNowSCROLL_Expert = dbSCROLL;
                            break;
                        case 2:
                            this.dbNowSCROLL_Master = dbSCROLL;
                            break;
                    }

                    //チップ追加して割り込んでみる。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x9D;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 ) - 1;
				    chip.n整数値 = 0x00;
				    chip.n整数値・内部番号 = this.n内部番号SCROLL1to;
                    chip.dbSCROLL = dbSCROLL;
                    chip.nコース = this.n現在のコース;

    				// チップを配置。
                    
				    this.listChip.Add( chip );
                    this.n内部番号SCROLL1to++;
                }
                else if( InputText.StartsWith( "#MEASURE" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    strArray = strArray[1].Split( new char[]{ '/' } );

                    double[] dbLength = new double[2];
                    dbLength[ 0 ] = Convert.ToDouble( strArray[ 0 ] );
                    dbLength[ 1 ] = Convert.ToDouble( strArray[ 1 ] );

                    double db小節長倍率 = dbLength[ 0 ] / dbLength[ 1 ];
                    this.dbBarLength = db小節長倍率;

                    var chip = new CChip();

                    chip.nチャンネル番号 = 0x02;
                    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
                    chip.db実数値 = db小節長倍率;
                    chip.n整数値 = 0x01;
                    chip.n整数値・内部番号 = 1;
                    // チップを配置。

                    this.listChip.Add(chip);
                    
                    //lbMaster.Items.Add( ";拍子変更 " + strArray[0] + "/" + strArray[1] );
                }
                else if( InputText.StartsWith( "#DELAY" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    int nDELAY = (int)( Convert.ToDouble( strArray[1] ) * 1000 );
                    

                    this.listDELAY.Add( this.n内部番号DELAY1to, new CDELAY() { n内部番号 = this.n内部番号DELAY1to, n表記上の番号 = 0, nDELAY値 = nDELAY, } );


                    //チップ追加して割り込んでみる。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xDC;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0x00;
				    chip.n整数値・内部番号 = this.n内部番号DELAY1to;

    				// チップを配置。
                    
				    this.listChip.Add( chip );
                    this.n内部番号DELAY1to++;

                }

                else if( InputText.StartsWith( "#GOGOSTART" ) )
                {
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x9E;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0x9E;
				    chip.n整数値・内部番号 = 1;


    				// チップを配置。
				    this.listChip.Add( chip );
                }
                else if( InputText.StartsWith( "#GOGOEND" ) )
                {
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x9F;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0x9E;
				    chip.n整数値・内部番号 = 1;

    				// チップを配置。
				    this.listChip.Add( chip );
                }
                else if( InputText.StartsWith( "#SECTION" ) )
                {
                    //分岐:条件リセット
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xDD;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0xDD;
				    chip.n整数値・内部番号 = 1;

    				// チップを配置。
				    this.listChip.Add( chip );
                }
                else if( InputText.StartsWith( "#BRANCHSTART" ) )
                {
                    this.bチップがある.Branch = true;
                    this.b最初の分岐である = false;

                    //分岐:分岐スタート
                    int n条件 = 0;
                    strArray = InputText.Split( chDelimiter );
                    strArray = strArray[1].Split( ',' );
                    
                    //条件数値。めちゃくちゃ無理やりな実装でスマン。
                    double[] nNum = new double[2];
                    string strNumA;
                    string strNumB;

                    if (strArray.Length == 3)
                    {
                        strNumA = strArray[1];
                        strNumB = strArray[2];

                        nNum[0] = Convert.ToDouble( strNumA );
                        nNum[1] = Convert.ToDouble( strNumB );
                        switch (strArray[0])
                        {
                            case "p":
                                n条件 = 0;
                                break;
                            case "r":
                                n条件 = 1;
                                break;
                            case "s":
                                n条件 = 2;
                                break;
                            case "d":
                                n条件 = 3;
                                break;
                            default:
                                n条件 = 0;
                                break;
                        }
                    }

                    if( strArray.Length == 2 )
                    {
                        strArray = InputText.Split( chDelimiter );
                        strNumA = strArray[2].Split( ',' )[0];
                        strNumB = strArray[3].Split( ',' )[0];

                        nNum[0] = Convert.ToDouble( strNumA );
                        nNum[1] = Convert.ToDouble( strNumB );
                        switch (strArray[1])
                        {
                            case "p,":
                                n条件 = 0;
                                break;
                            case "r,":
                                n条件 = 1;
                                break;
                            case "s,":
                                n条件 = 2;
                                break;
                            case "d,":
                                n条件 = 3;
                                break;
                            default:
                                n条件 = 0;
                                break;
                        }


                    }



                    //まずはリストに現在の小節、発声位置、分岐条件を追加。
                    var branch = new CBRANCH();
                    branch.db判定時間 = 0;
                    branch.db分岐時間 = ( ( this.n現在の小節数 ) * 384 );
                    branch.n現在の小節 = this.n現在の小節数;
                    branch.n条件数値A = nNum[0];
                    branch.n条件数値B = nNum[1];
                    branch.n内部番号 = this.n内部番号BRANCH1to;
                    branch.n表記上の番号 = 0;
                    branch.n分岐の種類 = n条件;
                    branch.n命令時のChipList番号 = this.listChip.Count;

                    this.listBRANCH.Add( this.n内部番号BRANCH1to, branch );


                    //分岐アニメ開始時に設置。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xDE;
				    chip.n発声位置 = ( ( this.n現在の小節数 - 1 ) * 384 );
				    chip.n整数値 = 0xDE;
				    chip.n整数値・内部番号 = this.n内部番号BRANCH1to;

    				// チップを配置。
				    this.listChip.Add( chip );

                    //実質的な位置に配置
                    var chip2 = new CChip();

				    chip2.nチャンネル番号 = 0xDF;
				    chip2.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip2.n整数値 = 0xDF;
				    chip2.n整数値・内部番号 = this.n内部番号BRANCH1to;

				    this.listChip.Add( chip2 );

                    this.n内部番号BRANCH1to++;
                }
                else if( InputText.StartsWith( "#N" ) )
                {
                    //分岐:普通譜面
                    this.n現在のコース = 0;
                    this.n現在の小節数 = this.listBRANCH[ this.n内部番号BRANCH1to - 1 ].n現在の小節;
                }
                else if( InputText.StartsWith( "#E" ) )
                {
                    //分岐:玄人譜面
                    this.n現在のコース = 1;
                    this.n現在の小節数 = this.listBRANCH[ this.n内部番号BRANCH1to - 1 ].n現在の小節;
                }
                else if( InputText.StartsWith( "#M") )
                {
                    //分岐:達人譜面
                    this.n現在のコース = 2;
                    this.n現在の小節数 = this.listBRANCH[ this.n内部番号BRANCH1to - 1 ].n現在の小節;
                }
                else if( InputText.StartsWith( "#BARLINEOFF") )
                {
                    var chip = new CChip();

                    chip.nチャンネル番号 = 0xE0;
                    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 ) - 1;
                    chip.n整数値 = 0xE0;
                    chip.n整数値・内部番号 = 1;

                    this.listChip.Add( chip );
                }
                else if( InputText.StartsWith( "#BARLINEON") )
                {
                    var chip = new CChip();

                    chip.nチャンネル番号 = 0xE0;
                    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 ) - 1;
                    chip.n整数値 = 0xE0;
                    chip.n整数値・内部番号 = 2;

                    this.listChip.Add( chip );
                }

                if( this.b直前の行に小節末端定義が無かった )
                {
                    this.n命令行のチップ番号_temp = this.listChip.Count;
                }


                //this.n命令数++;
                //lblSharpCommandNum.Text = this.n命令数.ToString();
            }
        }

        private void t入力・行解析ヘッダ( string InputText )
		{
            //やべー。先頭にコメント行あったらやばいやん。
            string[] strArray = InputText.Split( new char[] { ':' } );
            string strCommandName = "";
            string strCommandParam = "";

            //まずは「:」でSplitして割り当てる。
            if( strArray.Length == 2 )
            {
                strCommandName = strArray[0].Trim();
                strCommandParam = strArray[1].Trim();
            }
            else if( strArray.Length > 2 )
            {
                //strArrayが2じゃない場合、ヘッダのSplitを通していない可能性がある。
                //この処理自体は「t入力」を改造したもの。STARTでSplitしていない等、一部の処理が異なる。

                #region[ヘッダ]
                InputText = InputText.Replace( Environment.NewLine, "\n" ); //改行文字を別の文字列に差し替え。
                InputText = InputText.Replace( '\t', ' ' ); //何の文字か知らないけどスペースに差し替え。
                InputText = InputText + "\n";

                string[] strDelimiter = { "#START" };
                strArray = InputText.Split( strDelimiter, StringSplitOptions.RemoveEmptyEntries );

                string[] strDelimiter2 = { "\n" };
                strArray = InputText.Split( strDelimiter2, StringSplitOptions.RemoveEmptyEntries );


                strArray = strArray[ 0 ].Split( new char[] { ':' } );

                strCommandName = strArray[0].Trim();
                strCommandParam = strArray[1].Trim();

                #endregion
                //lblMessage.Text = "おや?strArrayのLengthが2じゃないようですね。お兄様。";
            }

            //パラメータを分別、そこから割り当てていきます。
            if( strCommandName.Equals( "TITLE" ) )
            {
                this.TITLE = strCommandParam;
                //tbTitle.Text = strCommandParam;
            }
            else if( strCommandName.Equals( "LEVEL" ) )
            {
                this.LEVEL.Taiko = Convert.ToInt16( strCommandParam );
                //tbLevel.Text = strCommandParam;
            }
            else if( strCommandName.Equals( "BPM" ) )
            {
                this.BPM = Convert.ToDouble( strCommandParam );
                this.BASEBPM = Convert.ToDouble( strCommandParam );
                this.dbNowBPM = Convert.ToDouble( strCommandParam );

                double dbBPM = Convert.ToDouble( strCommandParam );

                this.listBPM.Add( this.n内部番号BPM1to - 1, new CBPM() { n内部番号 = this.n内部番号BPM1to - 1, n表記上の番号 = this.n内部番号BPM1to - 1, dbBPM値 = dbBPM, } );
                this.n内部番号BPM1to++;


                //チップ追加して割り込んでみる。
                var chip = new CChip();

				chip.nチャンネル番号 = 0x03;
				chip.n発声位置 = ( ( this.n現在の小節数 - 1 ) * 384 );
				chip.n整数値 = 0x00;
				chip.n整数値・内部番号 = 1;
                    
				this.listChip.Add( chip );
                //tbBPM.Text = strCommandParam;
            }
            else if( strCommandName.Equals( "WAVE" ) )
            {
                this.strBGM_PATH = strCommandParam;
                //tbWave.Text = strCommandParam;
            }
            else if( strCommandName.Equals( "OFFSET" ) )
            {
                this.nOFFSET = (int)( Convert.ToDouble( strCommandParam ) * 1000 );
                this.bOFFSETの値がマイナスである = this.nOFFSET < 0 ? true : false;

                if (this.bOFFSETの値がマイナスである == true)
                    this.nOFFSET = this.nOFFSET * -1; //OFFSETは秒を加算するので、必ず正の数にすること。
                //tbOFFSET.Text = strCommandParam;
            }
            else if( strCommandName.Equals( "BALLOON" ) )
            {
                string[] strParam = strCommandParam.Split( ',' );
                for( int n = 0; n < strParam.Length; n++ )
                {
                    int n打数;
                    try
                    {
                        n打数 = Convert.ToInt32( strParam[ n ] );
                    }
                    catch(Exception ex)
                    {
                        Trace.TraceError( "おや?エラーが出たようです。お兄様。" );
                        Trace.TraceError( "エラー:{0}", ex.StackTrace );
                        break;
                    }
                    this.listBalloon_Normal.Add( n打数 );
                }
            }
            else if( strCommandName.Equals( "BALLOONNOR" ) )
            {
                string[] strParam = strCommandParam.Split( ',' );
                for( int n = 0; n < strParam.Length; n++ )
                {
                    int n打数;
                    try
                    {
                        n打数 = Convert.ToInt32( strParam[ n ] );
                    }
                    catch(Exception ex)
                    {
                        Trace.TraceError( "おや?エラーが出たようです。お兄様。" );
                        Trace.TraceError( "エラー:{0}", ex.StackTrace );
                        break;
                    }
                    this.listBalloon_Normal.Add( n打数 );
                }
            }
            else if( strCommandName.Equals( "BALLOONEXP" ) )
            {
                string[] strParam = strCommandParam.Split( ',' );
                for( int n = 0; n < strParam.Length; n++ )
                {
                    int n打数;
                    try
                    {
                        n打数 = Convert.ToInt32( strParam[ n ] );
                    }
                    catch(Exception ex)
                    {
                        Trace.TraceError( "おや?エラーが出たようです。お兄様。" );
                        Trace.TraceError( "エラー:{0}", ex.StackTrace );
                        break;
                    }
                    this.listBalloon_Expert.Add( n打数 );
                }
                //tbBALLOON.Text = strCommandParam;
            }
            else if( strCommandName.Equals( "BALLOONMAS" ) )
            {
                string[] strParam = strCommandParam.Split( ',' );
                for( int n = 0; n < strParam.Length; n++ )
                {
                    int n打数;
                    try
                    {
                        n打数 = Convert.ToInt32( strParam[ n ] );
                    }
                    catch(Exception ex)
                    {
                        Trace.TraceError( "おや?エラーが出たようです。お兄様。" );
                        Trace.TraceError( "エラー:{0}", ex.StackTrace );
                        break;
                    }
                    this.listBalloon_Master.Add( n打数 );
                }
                //tbBALLOON.Text = strCommandParam;
            }
            else if( strCommandName.Equals( "SONGVOL" ) )
            {
                //tbSongVol.Text = strCommandParam;
            }
            else if( strCommandName.Equals( "SEVOL" ) )
            {
                //tbSeVol.Text = strCommandParam;
            }
            else if( strCommandName.Equals( "SCOREMODE" ) )
            {
                if( !string.IsNullOrEmpty( strCommandParam ) )
                {
                    this.nScoreMode = Convert.ToInt16( strCommandParam );
                }

            }
            else if( strCommandName.Equals( "SCOREINIT" ) )
            {
                if( !string.IsNullOrEmpty( strCommandParam ) )
                {
                    string[] scoreinit = strCommandParam.Split(',');

                    this.nScoreInit[ 0 ] = Convert.ToInt16( scoreinit[ 0 ] );
                    if( scoreinit.Length == 2 )
                        this.nScoreInit[ 1 ] = Convert.ToInt16( scoreinit[ 1 ] );
                    //tbScoreInit.Text = scoreinit[0];
                    //if( scoreinit.Length == 2 )
                        //tbScoreInit2.Text = scoreinit[1];
                }

            }
            else if( strCommandName.Equals( "SCOREDIFF" ) )
            {
                if( !string.IsNullOrEmpty( strCommandParam ) )
                {
                    this.nScoreDiff = Convert.ToInt16( strCommandParam );
                    //tbScoreDiff.Text = strCommandParam;
                }

            }
            else if( strCommandName.Equals( "HEADSCROLL" ) )
            {
                //新定義:初期スクロール速度設定(というよりこのシステムに合わせるには必須。)
                //どうしても一番最初に1小節挿入されるから、こうするしかなかったんだ・・・

                this.dbScrollSpeed = Convert.ToDouble( strCommandParam );

                this.listSCROLL.Add( this.n内部番号SCROLL1to, new CSCROLL() { n内部番号 = this.n内部番号SCROLL1to, n表記上の番号 = 0, dbSCROLL値 = this.dbScrollSpeed, } );


                //チップ追加して割り込んでみる。
                var chip = new CChip();

				chip.nチャンネル番号 = 0x9D;
                chip.n発声位置 = ((this.n現在の小節数 - 2) * 384);
				chip.n整数値 = 0x00;
				chip.n整数値・内部番号 = this.n内部番号SCROLL1to;
                chip.dbSCROLL = this.dbScrollSpeed;

    	        // チップを配置。
                    
				this.listChip.Add( chip );
                this.n内部番号SCROLL1to++;

                //this.nScoreDiff = Convert.ToInt16( strCommandParam );
                //tbScoreDiff.Text = strCommandParam;
            }
            else if( strCommandName.Equals( "GENRE" ) )
            {
                //2015.03.28 kairera0467
                //ジャンルの定義。DTXから入力もできるが、tjaからも入力できるようにする。
                //日本語名だと選曲画面でバグが出るので、そこもどうにかしていく予定。

                if( !string.IsNullOrEmpty( strCommandParam ) )
                {
                    this.GENRE = strCommandParam;
                }
            }
            else if( strCommandName.Equals( "DEMOSTART" ) )
            {
                //2015.04.10 kairera0467

                if( !string.IsNullOrEmpty( strCommandParam ) )
                {
                    int nOFFSETms;
                    try
                    {
                        nOFFSETms = (int)( Convert.ToDouble( strCommandParam ) * 1000.0 );
                    }
                    catch
                    {
                        nOFFSETms = 0;
                    }


                    this.nデモBGMオフセット = nOFFSETms;
                }
            }
        }

        private void t入力・行解析譜面( string InputText )
		{
            //1行ずつ読み取っていく。
            //まずは小節数をカウントさせる。
            //原理としては、
            //　・1行ずつ確認
            //　・先頭が「#」ならスルー。命令行とみなす。
            //　・命令行じゃなかった場合、その中で「,」があれば1小節とカウント。
            //こんなかんじでどうだろうか。
            //課題としては、
            //　・複数行にわたる譜面はどうするべきか
            //　　・まあ公開するわけじゃないし、これやらんでもええかも。
            //　・分解能の計算
            //　・時間等を計測して、音符一つ一つの位置を計算する。
            //　・そんでもってログ出力できるようにする。


            //命令の小節数を計測する場合、現在の小節数+1すれば正常に出てくるはず。

            bool b命令行である = false;

            if( InputText.StartsWith( "#" ) )
            {
                b命令行である = true;
            }

            //命令じゃない行。つまり普通の行。
            if( b命令行である == false )
            {
                //lbMaster.Items.Add( InputText );
                
                //小節末端を削除。2行以上に渡る譜面?忘れてしまえそんなもん。
                //ついでにInputTextに上書き。余計な変数を減らす。
                string[] strA = InputText.Split( ',' );
                InputText = strA[0];

                //この順番は変えたほうがいいかも。
                //this.n現在の小節数++;
                //lblLineCountNum.Text = this.n現在の小節数.ToString();

                #region[ 1行の文字数を取得する ]
                int n文字数 = 0;

			    var sb = new StringBuilder( InputText.Length );

			    // strパラメータを先頭から1文字ずつ見ながら正規化（無効文字('_')を飛ばしたり不正な文字でエラーを出したり）し、sb へ格納する。

			    CharEnumerator ce = InputText.GetEnumerator();
			    while( ce.MoveNext() )
			    {
				    if( ce.Current == ',' )		// '_' は無視。
					    continue;

                    //if( this.str有効文字列.IndexOf( ce.Current ) < 0 )	// オブジェクト記述は36進数文字であること。
				    {
					    
				    }

				    sb.Append( ce.Current );
				    n文字数++;
			    }
                #endregion


                //新しいやつ
                #region[ 配置 ]
                //DTXManiaは2文字で1つだが、TJAはそうでもないので特に考慮とかはしない。
                //for( int i = 0; i < n文字数; i++ )
                //{
                //    #region [ nオブジェクト数値 を１つ取得する。]
                //    //-----------------
                //    int nオブジェクト数値 = 0;

                //    nオブジェクト数値 = this.CharConvertNote( InputText.Substring( i, 1 ) );

                //    //-----------------
                //    #endregion
                //    if( nオブジェクト数値 != 0 && nオブジェクト数値 != nNowRoll )
                //    {
                //        if( nオブジェクト数値 != 8 && nNowRoll != 0 && nCount >= 1 )
                //        {
                //            if( this.listChip != null )
                //            {
                //                this.listChip[ nNowRollCount ].nノーツ終了位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / n文字数 );
                //            }
                //            nNowRoll = 0;
                //            nNowRollCount = -1;
                //        }

                //        //TJAP2上ではオブジェクト番号8はリストに追加しない仕様だが、こちらでは追加しないと末端が描画できない。
                //        //if( nオブジェクト数値 == 8 )
                //        //{
                //            //this.nCount--;
                //            //if( this.listChip != null )
                //            //{
                //                //this.listChip[ nNowRollCount ].n発声位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / n文字数 );
                //                //this.listChip[ nNowRollCount ].nノーツ終了位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / n文字数 );
                //            //}
                //        //}
                //        //else
                //        //{


                //            //ためしに割り込む。
                //            var chip = new CChip();

                //            chip.nチャンネル番号 = 0x92 + nオブジェクト数値;
                //            chip.n発声位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / n文字数 );
                //            chip.n整数値 = nオブジェクト数値;
                //            chip.n整数値・内部番号 = 1;
                //            chip.dbBPM = this.dbNowBPM;
                //            chip.dbSCROLL = this.dbNowSCROLL;
                //            chip.nコース = this.n現在のコース;

                //            if( nオブジェクト数値 == 8 )
                //            {
                //                //たぶんこれlistChipを弄らなきゃいけないパターンですよ。

                //                this.nCount--;
                //                listChip[ nNowRollCount ].nノーツ終了位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / n文字数 );
                //                chip.nノーツ終了位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / n文字数 );
                //                nNowRoll = 0;
                //                //continue;
                //            }

                //            #region [ chip.e楽器パート = ... ]
                //            //-----------------
                //            //全部太鼓扱い
                //            chip.e楽器パート = E楽器パート.TAIKO;
                //            //-----------------
                //            #endregion

                //            // チップを配置。
                        
                //            this.listChip.Add( chip );
                //            this.nCount++;
                //        //}


                //        if( nオブジェクト数値 == 5 )
                //        {
                //            nNowRoll = 5;
                //            //nNowRollCount = this.nCount;
                //            nNowRollCount = this.listChip.Count - 1;
                //        }
                //        else if( nオブジェクト数値 == 6 )
                //        {
                //            nNowRoll = 5;
                //            //nNowRollCount = this.nCount;
                //            nNowRollCount = this.listChip.Count - 1;
                //        }
                //        else if( nオブジェクト数値 == 7 )
                //        {
                //            nNowRoll = 5;
                //            //nNowRollCount = this.nCount;
                //            nNowRollCount = this.listChip.Count - 1;
                //        }
                //        else
                //        {
                //            nNowRoll = 0;
                //            nNowRollCount = -1;
                //        }

                //    }
                //}
                #endregion

                //一応古いやつ
                #region[ 配置 ]
                //DTXManiaは2文字で1つだが、TJAはそうでもないので特に考慮とかはしない。
                for( int i = 0; i < n文字数; i++ )
                {
                    #region [ nオブジェクト数値 を１つ取得する。'0' なら無視。]
				    //-----------------
				    int nオブジェクト数値 = 0;

					nオブジェクト数値 = this.CharConvertNote( InputText.Substring( i, 1 ) );

    				if( nオブジェクト数値 == 0 )
					    continue;

                    if( nオブジェクト数値 >= 5 && nオブジェクト数値 <= 7 )
                    {
                        if( nNowRoll == 1 )
                            continue;
                        else
                        {
                            this.nNowRollCount = listChip.Count;
                            nNowRoll = 1;
                        }
                    }

				    //-----------------
				    #endregion

                    //ためしに割り込む。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x92 + nオブジェクト数値;
				    chip.n発声位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / n文字数 );
				    chip.n整数値 = nオブジェクト数値;
				    chip.n整数値・内部番号 = 1;
                    chip.dbBPM = this.dbNowBPM;
                    chip.dbSCROLL = this.dbNowSCROLL;
                    chip.nコース = this.n現在のコース;

                    if( nオブジェクト数値 == 8 )
                    {
                        //this.nCount--;
                        chip.nノーツ終了位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / n文字数 );
                        listChip[ nNowRollCount ].nノーツ終了位置 = ( this.n現在の小節数 * 384 ) + ( ( 384 * i ) / n文字数 );
                        nNowRoll = 0;
                        //continue;
                    }

				    #region [ chip.e楽器パート = ... ]
				    //-----------------
                    //全部太鼓扱い
    				chip.e楽器パート = E楽器パート.TAIKO;
		    		//-----------------
			    	#endregion

				    #region [ 無限定義への対応 → 内部番号の取得。]
    				//-----------------
	    			if( chip.bWAVを使うチャンネルである )
		    		{
			    		chip.n整数値・内部番号 = 1;	// これが本当に一意なWAV番号となる。（無限定義の場合、chip.n整数値 は一意である保証がない。）
				    }
				    else if( chip.bBPMチップである )
				    {
					    chip.n整数値・内部番号 = 1;	// これが本当に一意なBPM番号となる。（同上。）
				    }
				    //-----------------
				    #endregion

    				// チップを配置。

                    #region[ 固定される種類のsenotesはここで設定しておく。 ]
                    switch( nオブジェクト数値 )
                    {
                        case 3:
                            chip.nSenote = 5;
                            break;
                        case 4:
                            chip.nSenote = 6;
                            break;
                        case 5:
                            chip.nSenote = 7;
                            break;
                        case 6:
                            chip.nSenote = 0xA;
                            break;
                        case 7:
                            chip.nSenote = 0xB;
                            break;
                        case 8:
                            chip.nSenote = 0xC;
                            break;
                    }
                    #endregion

                    if( nオブジェクト数値 < 5 )
                    {
                        if( this.b最初の分岐である == false )
                            this.nノーツ数[ this.n現在のコース ]++;
                        else
                            this.nノーツ数[ 3 ]++;
                    }

				    this.listChip.Add( chip );

                }

                if( strA.Length == 2 )
                {
                    this.n現在の小節数++;
                }
                #endregion
            }
            else
            {
                //命令には数値入りのものがあるので、慎重に取り扱いましょう。
                //数値入りのものにもデリミタ文字が違うものがありますので、スプリットは分岐内で行う必要があります。
                char[] chDelimiter = new char[] { ' ' };
                string[] strArray;

                if( InputText.StartsWith( "#START" )  )
                {
                    //#STARTと同時に鳴らすのはどうかと思うけどしゃーなしだな。
                    
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x01;
				    chip.n発声位置 = 384;
				    chip.n整数値 = 0x01;
				    chip.n整数値・内部番号 = 1;

    				// チップを配置。
				    this.listChip.Add( chip );

                    var chip1 = new CChip();
				    chip1.nチャンネル番号 = 0x54;
				    chip1.n発声位置 = 384;
				    chip1.n整数値 = 0x01;
				    chip1.n整数値・内部番号 = 1;

    				// チップを配置。

				    this.listChip.Add( chip1 );
                }
                else if( InputText.StartsWith( "#END" )  )
                {
                    //ためしに割り込む。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xFF;
				    chip.n発声位置 = ( ( this.n現在の小節数 + 3 ) * 384 );
				    chip.n整数値 = 0xFF;
				    chip.n整数値・内部番号 = 1;
    				// チップを配置。

				    this.listChip.Add( chip );

                    if( this.bチップがある.Branch )
                    {
                        for( int f = 0; f <= 2; f++ )
                        {
                            this.nノーツ数[ f ] = this.nノーツ数[ f ] + this.nノーツ数[ 3 ];
                        }
                    }
                }

                else if( InputText.StartsWith( "#BPMCHANGE" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    double dbBPM = Convert.ToDouble( strArray[1] );

                    this.listBPM.Add( this.n内部番号BPM1to - 1, new CBPM() { n内部番号 = this.n内部番号BPM1to - 1, n表記上の番号 = 0, dbBPM値 = dbBPM, } );


                    //チップ追加して割り込んでみる。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x08;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0x00;
				    chip.n整数値・内部番号 = this.n内部番号BPM1to - 1;

    				// チップを配置。
                    
				    this.listChip.Add( chip );
                    this.n内部番号BPM1to++;
                }
                else if( InputText.StartsWith( "#SCROLL" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    double dbSCROLL = Convert.ToDouble( strArray[1] );

                    this.listSCROLL.Add( this.n内部番号SCROLL1to, new CSCROLL() { n内部番号 = this.n内部番号SCROLL1to, n表記上の番号 = 0, dbSCROLL値 = dbSCROLL, } );


                    //チップ追加して割り込んでみる。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x9D;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 ) - 1;
				    chip.n整数値 = 0x00;
				    chip.n整数値・内部番号 = this.n内部番号SCROLL1to;
                    chip.dbSCROLL = dbSCROLL;

    				// チップを配置。
                    
				    this.listChip.Add( chip );
                    this.n内部番号SCROLL1to++;
                }
                else if( InputText.StartsWith( "#MEASURE" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    strArray = strArray[1].Split( new char[]{ '/' } );

                    double[] dbLength = new double[2];
                    dbLength[ 0 ] = Convert.ToDouble( strArray[ 0 ] );
                    dbLength[ 1 ] = Convert.ToDouble( strArray[ 1 ] );

                    double db小節長倍率 = dbLength[ 0 ] / dbLength[ 1 ];

                    var chip = new CChip();

                    chip.nチャンネル番号 = 0x02;
                    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
                    chip.db実数値 = db小節長倍率;
                    chip.n整数値 = 0x01;
                    chip.n整数値・内部番号 = 1;
                    // チップを配置。

                    this.listChip.Add(chip);
                    
                    //lbMaster.Items.Add( ";拍子変更 " + strArray[0] + "/" + strArray[1] );
                }
                else if( InputText.StartsWith( "#DELAY" ) )
                {
                    strArray = InputText.Split( chDelimiter );
                    int nDELAY = (int)( Convert.ToDouble( strArray[1] ) * 1000 );
                    

                    this.listDELAY.Add( this.n内部番号DELAY1to, new CDELAY() { n内部番号 = this.n内部番号DELAY1to, n表記上の番号 = 0, nDELAY値 = nDELAY, } );


                    //チップ追加して割り込んでみる。
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xDC;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0x00;
				    chip.n整数値・内部番号 = this.n内部番号DELAY1to;

    				// チップを配置。
                    
				    this.listChip.Add( chip );
                    this.n内部番号DELAY1to++;

                }

                else if( InputText.StartsWith( "#GOGOSTART" ) )
                {
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x9E;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0x9E;
				    chip.n整数値・内部番号 = 1;


    				// チップを配置。
				    this.listChip.Add( chip );
                }
                else if( InputText.StartsWith( "#GOGOEND" ) )
                {
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0x9F;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0x9E;
				    chip.n整数値・内部番号 = 1;

    				// チップを配置。
				    this.listChip.Add( chip );
                }
                else if( InputText.StartsWith( "#SECTION" ) )
                {
                    //分岐:条件リセット
                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xDD;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0xDD;
				    chip.n整数値・内部番号 = 1;

    				// チップを配置。
				    this.listChip.Add( chip );
                }
                else if( InputText.StartsWith( "#BRANCHSTART" ) )
                {
                    this.bチップがある.Branch = true;
                    this.b最初の分岐である = false;

                    //分岐:分岐スタート
                    int n条件 = 0;
                    strArray = InputText.Split( chDelimiter );
                    strArray = strArray[1].Split( ',' );
                    switch( strArray[0] )
                    {
                        case "p":
                            n条件 = 0;
                            break;
                        case "r":
                            n条件 = 1;
                            break;
                        case "s":
                            n条件 = 2;
                            break;
                        case "d":
                            n条件 = 3;
                            break;
                        default:
                            break;
                    }

                    //条件数値
                    double[] nNum = new double[2];
                    nNum[0] = Convert.ToDouble( strArray[1] );
                    nNum[1] = Convert.ToDouble( strArray[2] );

                    //まずはリストに現在の小節、発声位置、分岐条件を追加。
                    //
                    this.listBRANCH.Add( this.n内部番号DELAY1to, new CBRANCH() { n内部番号 = this.n内部番号BRANCH1to, db分岐時間 = ( ( this.n現在の小節数 + 1 ) * 384 ), n分岐の種類 = n条件, n表記上の番号 = 0, n条件数値A = nNum[0], n条件数値B = nNum[1], n現在の小節 = this.n現在の小節数  } );


                    var chip = new CChip();

				    chip.nチャンネル番号 = 0xDE;
				    chip.n発声位置 = ( ( this.n現在の小節数 ) * 384 );
				    chip.n整数値 = 0x9E;
				    chip.n整数値・内部番号 = 1;

    				// チップを配置。
				    this.listChip.Add( chip );

                    this.n内部番号BRANCH1to++;
                }
                else if( InputText.StartsWith( "#N" ) )
                {
                    //分岐:普通譜面
                    this.n現在のコース = 0;
                    this.n現在の小節数 = this.listBRANCH[ this.n内部番号BRANCH1to - 1 ].n現在の小節;
                }
                else if( InputText.StartsWith( "#E" ) )
                {
                    //分岐:玄人譜面
                    this.n現在のコース = 1;
                    this.n現在の小節数 = this.listBRANCH[ this.n内部番号BRANCH1to - 1 ].n現在の小節;
                }
                else if( InputText.StartsWith( "#M") )
                {
                    //分岐:達人譜面
                    this.n現在のコース = 2;
                    this.n現在の小節数 = this.listBRANCH[ this.n内部番号BRANCH1to - 1 ].n現在の小節;
                }

                this.n命令行のチップ番号_temp = this.listChip.Count;

                //this.n命令数++;
                //lblSharpCommandNum.Text = this.n命令数.ToString();
            }
        }
        /// <summary>
        /// string型からint型に変換する。
        /// TJAP2から持ってきた。
        /// </summary>
        private int CharConvertNote( string str )
        {
        	switch( str )
        	{
        		case "0":
        			return 0;
        		case "1":
        			return 1;
        		case "2":
        			return 2;
        		case "3":
        			return 3;
        		case "4":
        			return 4;
        		case "5":
        			return 5;
        		case "6":
        			return 6;
        		case "7":
        			return 7;
        		case "8":
        			return 8;
        		case "9":
        			return 9;
        		default:
        			return -1;
        	}
        }

        private void tSetSenotes()
        {
            #region[ list作成 ]
            //ひとまずチップだけのリストを作成しておく。
            List<CDTX.CChip> list音符のみのリスト;
            list音符のみのリスト = new List<CChip>();
            int nCount = 0;
            int dkdkCount = 0;

            foreach( CChip chip in this.listChip )
            {
                if( chip.nチャンネル番号 >= 0x93 && chip.nチャンネル番号 < 0x9A )
                {
                    list音符のみのリスト.Add( chip );
                }
            }
            #endregion

            //時間判定は、「次のチップの発声時刻」から「現在(過去)のチップの発声時刻」で引く必要がある。
            //逆にしてしまうと計算がとてつもないことになるので注意。

            try
            {
                //this.tSenotes_Core( list音符のみのリスト );
                this.tSenotes_Core_V2( list音符のみのリスト );
            }
            catch(Exception ex)
            {

            }


            #region[統合前]
            //foreach( CChip pChip in list音符のみのリスト )
            //{
            //    int dbUnitTime = ( int )( ( ( 60.0 / this.dbNowBPM ) / 4.0 ) * 1000.0 );
            //    int nUnit4 = dbUnitTime * 4;
            //    int nUnit8 = dbUnitTime * 2;
            //    int nUnit16 = dbUnitTime;

            //    if( nCount == 0  )
            //    {
            //        nCount++;
            //        continue;
            //    }

            //    double db1個前の発生時刻ms = list音符のみのリスト[nCount - 1].n発声時刻ms * 1;

            //    if( nCount == 1 )
            //    {
            //        //nCount - 1は一番最初のノーツになる。

            //        if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms >= nUnit4 )
            //        {
            //            if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
            //                list音符のみのリスト[ nCount - 1 ].nSenote = 0;
            //            else if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
            //                list音符のみのリスト[ nCount - 1 ].nSenote = 3;

            //            if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms < nUnit4 )
            //            {
            //                if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms < nUnit8 )
            //                {
            //                    //16分なら「ド」
            //                    pChip.nSenote = 1;
            //                }
            //                else
            //                {
            //                    if( dkdkCount == 0 )
            //                    {
            //                        pChip.nSenote = 1;
            //                        dkdkCount++;
            //                    }
            //                    else if( dkdkCount == 1 )
            //                    {
            //                        pChip.nSenote = 2;
            //                        dkdkCount = 0;
            //                    }
                                    
            //                }
            //            }
            //            else
            //            {
            //                //次も4分なら「ドン」か「カッ」
            //                if( pChip.nチャンネル番号 == 0x93 )
            //                {
            //                    pChip.nSenote = 0;
            //                }
            //                else if( pChip.nチャンネル番号 == 0x94 )
            //                {
            //                    pChip.nSenote = 3;
            //                }
            //            }
            //        }
            //        else if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms <= nUnit4 && pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms >= nUnit8 )
            //        {
            //            if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
            //                list音符のみのリスト[ nCount - 1 ].nSenote = 1;
            //            else if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
            //                list音符のみのリスト[ nCount - 1 ].nSenote = 4;

            //            if( pChip.nチャンネル番号 == 0x93 )
            //            {
            //                pChip.nSenote = 1;
            //            }
            //            else if( pChip.nチャンネル番号 == 0x94 )
            //            {
            //                pChip.nSenote = 4;
            //            }
            //        }
            //        else if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms < nUnit8 )
            //        {
            //            if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
            //                list音符のみのリスト[ nCount - 1 ].nSenote = 1;
            //            else if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
            //                list音符のみのリスト[ nCount - 1 ].nSenote = 4;

            //            if( pChip.nチャンネル番号 == 0x93 )
            //            {
            //                pChip.nSenote = 1;
            //            }
            //            else if( pChip.nチャンネル番号 == 0x94 )
            //            {
            //                pChip.nSenote = 4;
            //            }
            //        }

            //        nCount++;
            //        continue;
            //    }

            //    double db2個前の発声時刻ms = list音符のみのリスト[ nCount - 2 ].n発声時刻ms * 1;

            //    #region[新しいやつ]
            //    if( nCount + 1 >= list音符のみのリスト.Count )
            //        break;

            //    if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms >= nUnit4 )
            //    {
            //        if( pChip.nチャンネル番号 == 0x93 )
            //        {
            //            pChip.nSenote = 0;
            //        }
            //        else if( pChip.nチャンネル番号 == 0x94 )
            //        {
            //            pChip.nSenote = 3;
            //        }

            //        if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms <= nUnit4 )
            //        {
            //            if( pChip.nチャンネル番号 == 0x93 )
            //                pChip.nSenote = 1;
            //            else if( pChip.nチャンネル番号 == 0x94 )
            //                pChip.nSenote = 4;
            //        }
            //    }
            //    else if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms < nUnit4 && pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms >= nUnit8 )
            //    {
            //        if( pChip.nチャンネル番号 == 0x93 )
            //        {
            //            pChip.nSenote = 1;
            //        }
            //        else if( pChip.nチャンネル番号 == 0x94 )
            //        {
            //            pChip.nSenote = 4;
            //        }

            //        if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms <= nUnit4 )
            //        {
            //            if( pChip.nチャンネル番号 == 0x93 )
            //                pChip.nSenote = 0;
            //            else if( pChip.nチャンネル番号 == 0x94 )
            //                pChip.nSenote = 3;

            //            if( list音符のみのリスト[ nCount + 2 ].n発声時刻ms - list音符のみのリスト[ nCount + 1 ].n発声時刻ms >= nUnit8 )
            //            {
            //                if( pChip.nチャンネル番号 == 0x93 )
            //                    pChip.nSenote = 1;
            //                else if( pChip.nチャンネル番号 == 0x94 )
            //                    pChip.nSenote = 4;
            //            }
            //            else if( list音符のみのリスト[ nCount + 2 ].n発声時刻ms - list音符のみのリスト[ nCount + 1 ].n発声時刻ms < nUnit8 )
            //            {
            //                if( pChip.nチャンネル番号 == 0x93 )
            //                    pChip.nSenote = 1;
            //                else if( pChip.nチャンネル番号 == 0x94 )
            //                    pChip.nSenote = 4;
            //            }

            //        }
            //        else
            //        {
            //            if( pChip.nチャンネル番号 == 0x93 )
            //                pChip.nSenote = 0;
            //            else if( pChip.nチャンネル番号 == 0x94 )
            //                pChip.nSenote = 3;
            //        }
            //    }
            //    else if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms < nUnit8 ) //8分以下
            //    {
            //        if( pChip.nチャンネル番号 == 0x93 )
            //        {
            //            pChip.nSenote = 1;
            //        }
            //        else if( pChip.nチャンネル番号 == 0x94 )
            //        {
            //            pChip.nSenote = 4;
            //        }

            //        //後ろが4分
            //        try
            //        {
            //            if( nCount + 1 >= list音符のみのリスト.Count )
            //                break;

            //            if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms >= nUnit8 ) //分岐があるとここがバグるっぽい?(Indexエラー)
            //            {
            //                if( pChip.nチャンネル番号 == 0x93 )
            //                {
            //                    pChip.nSenote = 0;
            //                }
            //                else if( pChip.nチャンネル番号 == 0x94 )
            //                {
            //                    pChip.nSenote = 3;
            //                }
            //            }
            //        }
            //        catch( Exception ex )
            //        {

            //        }


            //    }
            //    #endregion

            //    #region[古いやつ]
            //    ////2つ前と1つ前のチップのSenoteを決めていく。
            //    ////連打、大音符などはチップ配置の際に決めます。
            //    //if (( db1個前の発生時刻ms - db2個前の発声時刻ms ) >= nUnit4)
            //    //{
            //    //    //2つ前の音符と1つ前の音符の間が4分以上でかつ、その音符がドンなら2つ前のSenoteは「ドン」で確定。
            //    //    //同時にdkdkをリセット
            //    //    dkdkCount = false;
            //    //    if( list音符のみのリスト[nCount - 2].nチャンネル番号 == 0x93 )
            //    //        list音符のみのリスト[nCount - 2].nSenote = 0;
            //    //    else if( list音符のみのリスト[nCount - 2].nチャンネル番号 == 0x94 )
            //    //        list音符のみのリスト[nCount - 2].nSenote = 3;

            //    //    if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) >= nUnit4 )
            //    //    {
            //    //        //1つ前の音符と現在の音符の間が4分以上かつ、その音符がドンなら1つ前の音符は「ドン」で確定。
            //    //        if( list音符のみのリスト[nCount - 1].nチャンネル番号 == 0x93 )
            //    //            list音符のみのリスト[nCount - 1].nSenote = 0;
            //    //        else if( list音符のみのリスト[nCount - 1].nチャンネル番号 == 0x94 )
            //    //            list音符のみのリスト[nCount - 1].nSenote = 3;
            //    //    }
            //    //    else if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) <= nUnit4 )
            //    //    {
            //    //        //4分
            //    //        if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) >= nUnit8 )
            //    //        {
            //    //            dkdkCount = false;
            //    //            //1つ前の音符と現在の音符の間が8分以内で16分以上でかつ、その音符が赤なら1つ前の音符は「ド」で確定。
            //    //            if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
            //    //                list音符のみのリスト[ nCount - 1 ].nSenote = 2;
            //    //            else if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
            //    //                list音符のみのリスト[ nCount - 1 ].nSenote = 4;
            //    //        }
            //    //        else if( ( db1個前の発生時刻ms - db2個前の発声時刻ms ) <= nUnit8 )
            //    //        {
            //    //            dkdkCount = false;
            //    //            if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
            //    //            {
            //    //                list音符のみのリスト[ nCount - 2 ].nSenote = 1;
                                
            //    //                //ドコドン
            //    //                if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
            //    //                {
            //    //                    if( pChip.nチャンネル番号 == 0x93 )
            //    //                        pChip.nSenote = dkdkCount ? 2 : 1;
            //    //                    if( dkdkCount == false )
            //    //                        dkdkCount = true;
            //    //                    else
            //    //                        dkdkCount = false;
            //    //                }
            //    //            }
            //    //            else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
            //    //                list音符のみのリスト[ nCount - 2 ].nSenote = 4;
            //    //        }

            //    //    }
            //    //}
            //    //else if ( ( db1個前の発生時刻ms - db2個前の発声時刻ms ) <= nUnit4 && ( db1個前の発生時刻ms - db2個前の発声時刻ms ) >= nUnit8)
            //    //{
            //    //    //2つ前の音符と1つ前の音符の間が8分以上でかつ、16分以内

            //    //    if( ( db1個前の発生時刻ms - db2個前の発声時刻ms ) >= nUnit8 && ( db1個前の発生時刻ms - db2個前の発声時刻ms ) > nUnit16 )
            //    //    {
            //    //        //2つ前の音符と1つ前の音符の間が8分以上でかつ、16分以内なら「ド」
            //    //        if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
            //    //        {
            //    //            list音符のみのリスト[ nCount - 2 ].nSenote = 1;
            //    //        }
            //    //        else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
            //    //        {
            //    //            list音符のみのリスト[ nCount - 2 ].nSenote = 4;
            //    //        }
            //    //    }
            //    //    else if( ( db1個前の発生時刻ms - db2個前の発声時刻ms ) < nUnit8 )
            //    //    {
            //    //        //2つ前の音符と1つ前の音符の間が16分以内なら「ド」で確定
            //    //        if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
            //    //        {
            //    //            list音符のみのリスト[ nCount - 2 ].nSenote = 1;
            //    //        }
            //    //        else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
            //    //            list音符のみのリスト[ nCount - 2 ].nSenote = 4;
            //    //    }

            //    //    if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) >= nUnit16 )
            //    //    {
            //    //        if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) >= nUnit8 )
            //    //        {
            //    //            if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
            //    //            {
            //    //                list音符のみのリスト[ nCount - 1 ].nSenote = 0;
            //    //            }
            //    //            else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
            //    //                list音符のみのリスト[ nCount - 1 ].nSenote = 3;
            //    //        }
            //    //    }
            //    //}
            //    //else if ( ( db1個前の発生時刻ms - db2個前の発声時刻ms ) >= nUnit16 && ( db1個前の発生時刻ms - db2個前の発声時刻ms ) <= nUnit8 )
            //    //{
            //    //    //2つ前の音符と1つ前の音符の間が16分以上
            //    //    if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
            //    //    {
            //    //        list音符のみのリスト[ nCount - 2 ].nSenote = 1;
            //    //    }
            //    //    else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
            //    //        list音符のみのリスト[ nCount - 2 ].nSenote = 4;

            //    //    if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) >= nUnit8 )
            //    //    {
            //    //        if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
            //    //        {
            //    //            list音符のみのリスト[ nCount - 1 ].nSenote = 0;
            //    //        }
            //    //        else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
            //    //            list音符のみのリスト[ nCount - 1 ].nSenote = 3;
            //    //    }


            //    //}
            //    #endregion

            //    nCount++;
            //}
            #endregion


        }

        /// <summary>
        /// 譜面分岐がある場合はこちらを使う
        /// </summary>
        private void tSetSenotes_branch()
        {
            #region[ list作成 ]
            //ひとまずチップだけのリストを作成しておく。
            List<CDTX.CChip> list音符のみのリスト;
            List<CDTX.CChip> list普通譜面のみのリスト;
            List<CDTX.CChip> list玄人譜面のみのリスト;
            List<CDTX.CChip> list達人譜面のみのリスト;
            list音符のみのリスト = new List<CChip>();
            list普通譜面のみのリスト = new List<CChip>();
            list玄人譜面のみのリスト = new List<CChip>();
            list達人譜面のみのリスト = new List<CChip>();
            int nCount = 0;
            int dkdkCount = 0;

            foreach( CChip chip in this.listChip )
            {
                if( chip.nチャンネル番号 >= 0x93 && chip.nチャンネル番号 < 0x9A )
                {
                    list音符のみのリスト.Add( chip );

                    switch( chip.nコース )
                    {
                        case 0:
                            list普通譜面のみのリスト.Add( chip );
                            break;
                        case 1:
                            list玄人譜面のみのリスト.Add( chip );
                            break;
                        case 2:
                            list達人譜面のみのリスト.Add( chip );
                            break;
                    }
                }
            }
            #endregion

            //forで処理。
            for( int n = 0; n < 3; n++ )
            {
                switch( n )
                {
                    case 0:
                        list音符のみのリスト = list普通譜面のみのリスト;
                        break;
                    case 1:
                        list音符のみのリスト =  list玄人譜面のみのリスト;
                        break;
                    case 2:
                        list音符のみのリスト =  list達人譜面のみのリスト;
                        break;
                }

                //this.tSenotes_Core( list音符のみのリスト );
                this.tSenotes_Core_V2( list音符のみのリスト );
            }

        }

        /// <summary>
        /// コア部分。譜面分岐時の処理実装にあたって分離。
        /// </summary>
        private void tSenotes_Core( List<CChip> list音符のみのリスト )
        {
            int nCount = 0;
            int dkdkCount = 0;

            foreach( CChip pChip in list音符のみのリスト )
            {
                int dbUnitTime = (int)(((60.0 / pChip.dbBPM) / 4.0) * 1000.0);
                int nUnit4 = dbUnitTime * 4;
                int nUnit6 = dbUnitTime * 3;
                int nUnit8 = dbUnitTime * 2;
                int nUnit16 = dbUnitTime;

                float fUnitTime = ( ( ( 60.0f / (float)pChip.dbBPM ) / 4.0f ) * 1000.0f );
                //float fUnitTime = (float)Math.Round( ( ( ( 60.0f / (float)pChip.dbBPM ) / 4.0f ) * 1000.0f ), 0 );
                float fUnit4 = fUnitTime * 4.0f;
                float fUnit8 = fUnitTime * 2.0f;
                float fUnit16 = fUnitTime;

                if( pChip.dbBPM < 120 )
                {
                    nUnit4 = ( dbUnitTime * 4 ) / 2;
                    nUnit8 = ( dbUnitTime * 2 ) / 2;
                    nUnit16 = dbUnitTime / 2;

                    fUnit4 = fUnitTime * 4.0f;
                    fUnit8 = fUnitTime * 2.0f;
                    fUnit16 = fUnitTime;
                }

                if( nCount == 0  )
                {
                    nCount++;
                    continue;
                }

                double db1個前の発生時刻ms = list音符のみのリスト[nCount - 1].n発声時刻ms * 1;

                #region[ float ]
                /*
                if( nCount == 1 )
                {
                    //nCount - 1は一番最初のノーツになる。

                    if( pChip.f発声時刻ms - list音符のみのリスト[ nCount - 1 ].f発声時刻ms >= fUnit4 )
                    {
                        //2番目のノーツと1番目のノーツの間隔が4分かそれ以上
                        if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
                            list音符のみのリスト[ nCount - 1 ].nSenote = 0;
                        else if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
                            list音符のみのリスト[ nCount - 1 ].nSenote = 3;

                        if( list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms < fUnit4 )
                        {
                            if( list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms < fUnit8 )
                            {
                                //16分なら「ド」
                                if( pChip.nチャンネル番号 == 0x93 )
                                    pChip.nSenote = 1;
                            }
                            else
                            {
                                if (pChip.nチャンネル番号 != 0x93)
                                    break;

                                if( dkdkCount == 0 )
                                {
                                    pChip.nSenote = 1;
                                    dkdkCount++;
                                }
                                else if( dkdkCount == 1 )
                                {
                                    pChip.nSenote = 2;
                                    dkdkCount = 0;
                                }
                                    
                            }
                        }
                        else
                        {
                            //次も4分なら「ドン」か「カッ」
                            if( pChip.nチャンネル番号 == 0x93 )
                            {
                                pChip.nSenote = 0;
                            }
                            else if( pChip.nチャンネル番号 == 0x94 )
                            {
                                pChip.nSenote = 3;
                            }
                        }
                    }
                    else if( pChip.f発声時刻ms - list音符のみのリスト[ nCount - 1 ].f発声時刻ms < fUnit4 && pChip.f発声時刻ms - list音符のみのリスト[ nCount - 1 ].f発声時刻ms > fUnit16 )
                    {
                        //2番目のチップと1番目のチップの間隔が4分以下でかつ16分以上
                        if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
                            list音符のみのリスト[ nCount - 1 ].nSenote = 1;
                        else if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
                            list音符のみのリスト[ nCount - 1 ].nSenote = 4;



                        if( pChip.nチャンネル番号 == 0x93 )
                        {
                            pChip.nSenote = 1;
                        }
                        else if( pChip.nチャンネル番号 == 0x94 )
                        {
                            pChip.nSenote = 4;
                        }
                            //
                            //if (list音符のみのリスト[nCount - 1].nチャンネル番号 == 0x93)
                            //    list音符のみのリスト[nCount - 1].nSenote = 0;
                            //else if (list音符のみのリスト[nCount - 1].nチャンネル番号 == 0x94)
                            //    list音符のみのリスト[nCount - 1].nSenote = 3;

                        if (list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms >= fUnit4)
                        {
                            //3番目のチップと2番目のチップの間隔が4分以上
                            if( pChip.nチャンネル番号 == 0x93 )
                            {
                                pChip.nSenote = 0;
                            }
                            else if( pChip.nチャンネル番号 == 0x94 )
                            {
                                pChip.nSenote = 3;
                            }
                        }
                    }
                    else if( pChip.f発声時刻ms - list音符のみのリスト[ nCount - 1 ].f発声時刻ms <= fUnit16 )
                    {
                        //2番目のチップと1番目のチップの間隔が16分かそれ以下
                        if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
                            list音符のみのリスト[ nCount - 1 ].nSenote = 1;
                        else if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
                            list音符のみのリスト[ nCount - 1 ].nSenote = 4;

                        if (pChip.nチャンネル番号 == 0x93)
                        {
                            pChip.nSenote = 1;
                        }
                        else if (pChip.nチャンネル番号 == 0x94)
                        {
                            pChip.nSenote = 4;
                        }

                        //1番目のチップが0x93
                        if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
                        {
                            //3番目のチップと2番目のチップの間隔が16分
                            if( list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms == fUnit16 )
                            {
                                if( list音符のみのリスト[ nCount + 1 ].nチャンネル番号 == 0x93 )
                                {
                                    pChip.nSenote = 2;
                                }
                            }
                        }


                    }

                    nCount++;
                    continue;
                }

                double db2個前の発声時刻ms = list音符のみのリスト[ nCount - 2 ].n発声時刻ms * 1;

                #region[新しいやつ]
                if( pChip.f発声時刻ms - list音符のみのリスト[ nCount - 1 ].f発声時刻ms >= fUnit4 )
                {
                    //現在のチップと1つ前のチップの間隔が4分以上
                    dkdkCount = 0;
                    if( pChip.nチャンネル番号 == 0x93 )
                    {
                        pChip.nSenote = 0;
                        //break;
                    }
                    else if( pChip.nチャンネル番号 == 0x94 )
                    {
                        pChip.nSenote = 3;
                    }

                    if( nCount + 1 >= list音符のみのリスト.Count )
                        break;

                    //次のチップと現在のチップの間が4分以下
                    if( list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms < fUnit4 )
                    {
                        if( pChip.nチャンネル番号 == 0x93 )
                            pChip.nSenote = 1;
                        else if( pChip.nチャンネル番号 == 0x94 )
                            pChip.nSenote = 4;
                    }
                }
                else if( pChip.f発声時刻ms - list音符のみのリスト[ nCount - 1 ].f発声時刻ms < fUnit4 && pChip.f発声時刻ms - list音符のみのリスト[ nCount - 1 ].f発声時刻ms > fUnit16 )
                {
                    //現在のチップと1つ前のチップの間隔が4分以下かつ16分以上
                    dkdkCount = 0;
                    if( pChip.nチャンネル番号 == 0x93 )
                    {
                        pChip.nSenote = 1;
                    }
                    else if( pChip.nチャンネル番号 == 0x94 )
                    {
                        pChip.nSenote = 4;
                    }

                    if( nCount + 1 >= list音符のみのリスト.Count )
                        break;


                    if( list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms >= fUnit4 )
                    {
                        //次のチップと現在のチップの間隔が4分以上
                        if( pChip.nチャンネル番号 == 0x93 )
                            pChip.nSenote = 0;
                        else if( pChip.nチャンネル番号 == 0x94 )
                            pChip.nSenote = 3;
                    }
                    else if( list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms < fUnit4 && list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms > fUnit16 )
                    {
                        //次のチップと現在のチップの間隔が4分以下
                        if( pChip.nチャンネル番号 == 0x93 )
                            pChip.nSenote = 1;
                        else if( pChip.nチャンネル番号 == 0x94 )
                            pChip.nSenote = 4;

                        if( nCount + 2 >= list音符のみのリスト.Count )
                            break;

                        //次のチップが0x93
                        //if( list音符のみのリスト[ nCount + 1 ].nチャンネル番号 == 0x93 )
                        //{
                        //    if( list音符のみのリスト[ nCount + 2 ].n発声時刻ms - list音符のみのリスト[ nCount + 1 ].n発声時刻ms < nUnit8 )
                        //    {
                        //        list音符のみのリスト[ nCount + 1 ].nSenote = 2;
                        //    }
                        //}
                    }
                    else if( list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms <= fUnit16 )
                    {
                        //次のチップと現在のチップの間隔が16分以下
                        //そうなると1つ前のチップは「ドン」か「カッ」になる
                        //if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
                        //    list音符のみのリスト[ nCount - 1 ].nSenote = 0;
                        //else if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
                        //    list音符のみのリスト[ nCount - 1 ].nSenote = 0;
                    }
                }
                else if( pChip.f発声時刻ms - list音符のみのリスト[ nCount - 1 ].f発声時刻ms <= fUnit16 )
                {
                    //現在のノーツと1つ前のノーツの間隔が16分かそれ以下
                    if( pChip.nチャンネル番号 == 0x93 )
                    {
                        pChip.nSenote = 1;
                    }
                    else if( pChip.nチャンネル番号 == 0x94 )
                    {
                        pChip.nSenote = 4;
                    }

                    
                    try
                    {
                        if( nCount + 1 >= list音符のみのリスト.Count ) //一番最後のノーツだった時のエラー対策。
                            break;

                        //後ろが4分
                        if( list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms >= fUnit4 )
                        {
                            dkdkCount = 0;
                            if( pChip.nチャンネル番号 == 0x93 )
                            {
                                pChip.nSenote = 0;
                            }
                            else if( pChip.nチャンネル番号 == 0x94 )
                            {
                                pChip.nSenote = 3;
                            }
                        }
                        else if( list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms <= fUnit8 && list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms > fUnit16 )
                        {
                            //次のノーツと現在のノーツの間隔が8分かそれ以下でかつ16分以上
                            dkdkCount = 0;
                            if( pChip.nチャンネル番号 == 0x93 )
                            {
                                pChip.nSenote = 0;
                            }
                            else if( pChip.nチャンネル番号 == 0x94 )
                            {
                                pChip.nSenote = 3;
                            }
                        }
                        else if( list音符のみのリスト[ nCount + 1 ].f発声時刻ms - pChip.f発声時刻ms <= fUnit16 )
                        {
                            if( pChip.nチャンネル番号 == 0x93 )
                            {
                                pChip.nSenote = 1;

                                if( nCount + 2 >= list音符のみのリスト.Count )
                                    break;

                                if( pChip.f発声時刻ms - list音符のみのリスト[ nCount - 1 ].f発声時刻ms == fUnit16 )
                                {
                                    //1つ前のノーツと現在のノーツの間隔が16分
                                    if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
                                    {
                                        //チャンネル番号が0x93
                                        if( dkdkCount == 0 )
                                        {
                                            pChip.nSenote = 2;
                                            dkdkCount = 1;
                                        }
                                        else
                                        {
                                            pChip.nSenote = 1;
                                            dkdkCount = 0;
                                        }
                                    }
                                    
                                }
                                else
                                {
                                    if (pChip.nチャンネル番号 == 0x93)
                                        pChip.nSenote = 1;
                                    else
                                        pChip.nSenote = 4;
                                }
                            }
                            else if( pChip.nチャンネル番号 == 0x94 )
                            {
                                pChip.nSenote = 4;
                            }
                        }
                    }
                    catch( Exception ex )
                    {

                    }


                }
                #endregion
                */
                #endregion

                #region[ ミリ秒 ]
                
                if( nCount == 1 )
                {
                    #region[ 一番最初 ]
                    //nCount - 1は一番最初のノーツになる。

                    if( pChip.n発声時刻ms - list音符のみのリスト[ 0 ].n発声時刻ms >= nUnit4 )
                    {
                        //2番目のノーツと1番目のノーツの間隔が4分かそれ以上
                        if( list音符のみのリスト[ 0 ].nチャンネル番号 == 0x93 )
                            list音符のみのリスト[ 0 ].nSenote = 0;
                        else if( list音符のみのリスト[ 0 ].nチャンネル番号 == 0x94 )
                            list音符のみのリスト[ 0 ].nSenote = 3;

                        if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms < nUnit4 )
                        {
                            if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms < nUnit8 )
                            {



                                //16分なら「ド」
                                if( pChip.nチャンネル番号 == 0x93 )
                                    pChip.nSenote = 1;
                            }
                            else
                            {
                                if (pChip.nチャンネル番号 == 0x93)
                                {
                                    pChip.nSenote = 0;
                                }
                                else if (pChip.nチャンネル番号 == 0x94)
                                {
                                    pChip.nSenote = 3;
                                }
                            }
                        }
                        else
                        {
                            //次も4分なら「ドン」か「カッ」
                            if( pChip.nチャンネル番号 == 0x93 )
                            {
                                pChip.nSenote = 0;
                            }
                            else if( pChip.nチャンネル番号 == 0x94 )
                            {
                                pChip.nSenote = 3;
                            }
                        }
                    }
                    else if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms < nUnit4 && pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms > nUnit16 )
                    {
                        //2番目のチップと1番目のチップの間隔が4分以下でかつ16分以上
                        if( list音符のみのリスト[ 0 ].nチャンネル番号 == 0x93 )
                            list音符のみのリスト[ 0 ].nSenote = 1;
                        else if( list音符のみのリスト[ 0 ].nチャンネル番号 == 0x94 )
                            list音符のみのリスト[ 0 ].nSenote = 4;



                        if( pChip.nチャンネル番号 == 0x93 )
                        {
                            pChip.nSenote = 1;
                        }
                        else if( pChip.nチャンネル番号 == 0x94 )
                        {
                            pChip.nSenote = 4;
                        }

                        if (list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms >= nUnit4)
                        {
                            //3番目のチップと2番目のチップの間隔が4分以上
                            if( pChip.nチャンネル番号 == 0x93 )
                            {
                                pChip.nSenote = 0;
                            }
                            else if( pChip.nチャンネル番号 == 0x94 )
                            {
                                pChip.nSenote = 3;
                            }
                        }
                        if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms < nUnit4 )
                        {
                            //3番目のチップと2番目のチップの間隔が4分以下
                            if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms <= nUnit8 )
                            {

                                if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms < nUnit8 )
                                {
                                    if( list音符のみのリスト[ 0 ].nチャンネル番号 == 0x93 )
                                        list音符のみのリスト[ 0 ].nSenote = 0;
                                    else if( list音符のみのリスト[ 0 ].nチャンネル番号 == 0x94 )
                                        list音符のみのリスト[ 0 ].nSenote = 3;
                                }




                                //16分なら「ド」
                                if( pChip.nチャンネル番号 == 0x93 )
                                    pChip.nSenote = 1;
                            }
                            else
                            {
                                if (pChip.nチャンネル番号 == 0x93)
                                {
                                    pChip.nSenote = 1;
                                }
                                else if (pChip.nチャンネル番号 == 0x94)
                                {
                                    pChip.nSenote = 4;
                                }
                            }
                        }
                    }
                    else if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms <= nUnit16 )
                    {
                        //2番目のチップと1番目のチップの間隔が16分かそれ以下
                        if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
                            list音符のみのリスト[ nCount - 1 ].nSenote = 1;
                        else if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
                            list音符のみのリスト[ nCount - 1 ].nSenote = 4;

                        if (pChip.nチャンネル番号 == 0x93)
                        {
                            pChip.nSenote = 1;
                        }
                        else if (pChip.nチャンネル番号 == 0x94)
                        {
                            pChip.nSenote = 4;
                        }

                        //1番目のチップが0x93
                        if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
                        {
                            //3番目のチップと2番目のチップの間隔が16分
                            if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms == nUnit16 )
                            {
                                if( list音符のみのリスト[ nCount + 1 ].nチャンネル番号 == 0x93 )
                                {
                                    pChip.nSenote = 2;
                                }
                            }
                        }


                    }

                    nCount++;
                    continue;

                    #endregion
                }

                double db2個前の発声時刻ms = list音符のみのリスト[ nCount - 2 ].n発声時刻ms * 1;

                #region[新しいやつ]
                if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms >= nUnit4 )
                {
                    //現在のチップと1つ前のチップの間隔が4分以上
                    dkdkCount = 0;
                    if( pChip.nチャンネル番号 == 0x93 )
                    {
                        pChip.nSenote = 0;
                    }
                    else if( pChip.nチャンネル番号 == 0x94 )
                    {
                        pChip.nSenote = 3;
                    }

                    if( nCount + 1 >= list音符のみのリスト.Count )
                        break;

                    //次のチップと現在のチップの間が4分以下
                    if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms < nUnit6 )
                    {
                        if( pChip.nチャンネル番号 == 0x93 )
                            pChip.nSenote = 1;
                        else if( pChip.nチャンネル番号 == 0x94 )
                            pChip.nSenote = 4;

                        //12、16分があるなら「ドン」か「カッ」に変える

                        if( list音符のみのリスト[ nCount + 2 ].n発声時刻ms - list音符のみのリスト[ nCount + 1 ].n発声時刻ms <= nUnit16 )
                        {
                            if( pChip.nチャンネル番号 == 0x93 )
                                pChip.nSenote = 1;
                            else if( pChip.nチャンネル番号 == 0x94 )
                                pChip.nSenote = 4;
                        }
                        if( list音符のみのリスト[ nCount + 2 ].n発声時刻ms - list音符のみのリスト[ nCount + 1 ].n発声時刻ms < nUnit8 )
                        {
                            if( pChip.nチャンネル番号 == 0x93 )
                                pChip.nSenote = 0;
                            else if( pChip.nチャンネル番号 == 0x94 )
                                pChip.nSenote = 3;
                        }
                    }
                    //else
                    //{
                    //    if( pChip.nチャンネル番号 == 0x93 )
                    //    {
                    //        pChip.nSenote = 0;
                    //    }
                    //    else if( pChip.nチャンネル番号 == 0x94 )
                    //    {
                    //        pChip.nSenote = 3;
                    //    }
                    //}
                }
                else if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms < nUnit4 && pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms > nUnit16 )
                {
                    //現在のチップと1つ前のチップの間隔が4分以下かつ16分以上
                    dkdkCount = 0;
                    if( pChip.nチャンネル番号 == 0x93 )
                    {
                        pChip.nSenote = 1;
                    }
                    else if( pChip.nチャンネル番号 == 0x94 )
                    {
                        pChip.nSenote = 4;
                    }

                    if( nCount + 1 >= list音符のみのリスト.Count )
                        break;


                    if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms >= nUnit4 )
                    {
                        //次のチップと現在のチップの間隔が4分以上
                        if( pChip.nチャンネル番号 == 0x93 )
                            pChip.nSenote = 0;
                        else if( pChip.nチャンネル番号 == 0x94 )
                            pChip.nSenote = 3;
                    }
                    else if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms < nUnit4 && list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms > nUnit16 )
                    {
                        //次のチップと現在のチップの間隔が4分以下
                        if( pChip.nチャンネル番号 == 0x93 )
                            pChip.nSenote = 1;
                        else if( pChip.nチャンネル番号 == 0x94 )
                            pChip.nSenote = 4;

                        if( nCount + 2 >= list音符のみのリスト.Count )
                            break;

                        //次のチップが0x93
                        //if( list音符のみのリスト[ nCount + 1 ].nチャンネル番号 == 0x93 )
                        //{
                        //    if( list音符のみのリスト[ nCount + 2 ].n発声時刻ms - list音符のみのリスト[ nCount + 1 ].n発声時刻ms < nUnit8 )
                        //    {
                        //        list音符のみのリスト[ nCount + 1 ].nSenote = 2;
                        //    }
                        //}

                        //12、16分があるなら「ドン」か「カッ」に変える
                        if (list音符のみのリスト[nCount + 2].n発声時刻ms - list音符のみのリスト[nCount + 1].n発声時刻ms < nUnit8)
                        {
                            if (pChip.nチャンネル番号 == 0x93)
                                pChip.nSenote = 0;
                            else if (pChip.nチャンネル番号 == 0x94)
                                pChip.nSenote = 3;

                            if( list音符のみのリスト[nCount - 1].n発声時刻ms - list音符のみのリスト[nCount - 2].n発声時刻ms >= nUnit8 )
                            {
                        if( pChip.nチャンネル番号 == 0x93 )
                            pChip.nSenote = 1;
                        else if( pChip.nチャンネル番号 == 0x94 )
                            pChip.nSenote = 4;
                            }


                        }
                    }
                    else if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms <= nUnit16 )
                    {
                        //次のチップと現在のチップの間隔が16分以下
                        //そうなると1つ前のチップは「ドン」か「カッ」になる
                        //if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
                        //    list音符のみのリスト[ nCount - 1 ].nSenote = 0;
                        //else if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
                        //    list音符のみのリスト[ nCount - 1 ].nSenote = 3;
                    }
                    else
                    {
                        if( pChip.nチャンネル番号 == 0x93 )
                            pChip.nSenote = 0;
                        else if( pChip.nチャンネル番号 == 0x94 )
                            pChip.nSenote = 3;
                    }
                }
                else if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms <= nUnit16 )
                {
                    //現在のノーツと1つ前のノーツの間隔が16分かそれ以下
                    if( pChip.nチャンネル番号 == 0x93 )
                    {
                        pChip.nSenote = 1;
                    }
                    else if( pChip.nチャンネル番号 == 0x94 )
                    {
                        pChip.nSenote = 4;
                    }

                    
                    try
                    {
                        if( nCount + 1 >= list音符のみのリスト.Count ) //一番最後のノーツだった時のエラー対策。
                            break;

                        //後ろが4分
                        if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms >= nUnit4 )
                        {
                            dkdkCount = 0;
                            if( pChip.nチャンネル番号 == 0x93 )
                            {
                                pChip.nSenote = 0;
                            }
                            else if( pChip.nチャンネル番号 == 0x94 )
                            {
                                pChip.nSenote = 3;
                            }
                        }
                        else if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms <= nUnit4 && list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms >= nUnit8 )
                        {
                            //次のノーツと現在のノーツの間隔が8分かそれ以下でかつ16分以上
                            dkdkCount = 0;
                            if( pChip.nチャンネル番号 == 0x93 )
                            {
                                pChip.nSenote = 0;
                            }
                            else if( pChip.nチャンネル番号 == 0x94 )
                            {
                                pChip.nSenote = 3;
                            }
                        }
                        else if( list音符のみのリスト[ nCount + 1 ].n発声時刻ms - pChip.n発声時刻ms < nUnit8 )
                        {
                            if( pChip.nチャンネル番号 == 0x93 )
                            {
                                pChip.nSenote = 1;

                                if( nCount + 2 >= list音符のみのリスト.Count )
                                    break;


                                //2015.03.31 kairera0467　「コ」を調節する部分。ただし動作があやしすぎるため、いったん封印。
                                if( pChip.n発声時刻ms - list音符のみのリスト[ nCount - 1 ].n発声時刻ms <= nUnit16 )
                                {
                                    //1つ前のノーツと現在のノーツの間隔が16分
                                    if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
                                    {
                                        //チャンネル番号が0x93
                                        //if( dkdkCount == 0 )
                                        //{
                                        //    pChip.nSenote = 2;
                                        //    dkdkCount = 1;
                                        //}
                                        //else
                                        //{
                                        //    pChip.nSenote = 1;
                                        //    dkdkCount = 0;
                                        //}
                                    }
                                    
                                }
                            }
                            else if( pChip.nチャンネル番号 == 0x94 )
                            {
                                pChip.nSenote = 4;
                            }
                        }
                    }
                    catch( Exception ex )
                    {

                    }
                }
                else
                {
                    if( pChip.nチャンネル番号 == 0x93 )
                    {
                        pChip.nSenote = 0;
                    }
                    else if( pChip.nチャンネル番号 == 0x94 )
                    {
                        pChip.nSenote = 3;
                    }
                }
                #endregion
                
                #endregion

                #region[古いやつ]
                ////2つ前と1つ前のチップのSenoteを決めていく。
                ////連打、大音符などはチップ配置の際に決めます。
                //if (( db1個前の発生時刻ms - db2個前の発声時刻ms ) >= nUnit4)
                //{
                //    //2つ前の音符と1つ前の音符の間が4分以上でかつ、その音符がドンなら2つ前のSenoteは「ドン」で確定。
                //    //同時にdkdkをリセット
                //    dkdkCount = false;
                //    if( list音符のみのリスト[nCount - 2].nチャンネル番号 == 0x93 )
                //        list音符のみのリスト[nCount - 2].nSenote = 0;
                //    else if( list音符のみのリスト[nCount - 2].nチャンネル番号 == 0x94 )
                //        list音符のみのリスト[nCount - 2].nSenote = 3;

                //    if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) >= nUnit4 )
                //    {
                //        //1つ前の音符と現在の音符の間が4分以上かつ、その音符がドンなら1つ前の音符は「ドン」で確定。
                //        if( list音符のみのリスト[nCount - 1].nチャンネル番号 == 0x93 )
                //            list音符のみのリスト[nCount - 1].nSenote = 0;
                //        else if( list音符のみのリスト[nCount - 1].nチャンネル番号 == 0x94 )
                //            list音符のみのリスト[nCount - 1].nSenote = 3;
                //    }
                //    else if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) <= nUnit4 )
                //    {
                //        //4分
                //        if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) >= nUnit8 )
                //        {
                //            dkdkCount = false;
                //            //1つ前の音符と現在の音符の間が8分以内で16分以上でかつ、その音符が赤なら1つ前の音符は「ド」で確定。
                //            if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
                //                list音符のみのリスト[ nCount - 1 ].nSenote = 2;
                //            else if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x94 )
                //                list音符のみのリスト[ nCount - 1 ].nSenote = 4;
                //        }
                //        else if( ( db1個前の発生時刻ms - db2個前の発声時刻ms ) <= nUnit8 )
                //        {
                //            dkdkCount = false;
                //            if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
                //            {
                //                list音符のみのリスト[ nCount - 2 ].nSenote = 1;
                                
                //                //ドコドン
                //                if( list音符のみのリスト[ nCount - 1 ].nチャンネル番号 == 0x93 )
                //                {
                //                    if( pChip.nチャンネル番号 == 0x93 )
                //                        pChip.nSenote = dkdkCount ? 2 : 1;
                //                    if( dkdkCount == false )
                //                        dkdkCount = true;
                //                    else
                //                        dkdkCount = false;
                //                }
                //            }
                //            else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
                //                list音符のみのリスト[ nCount - 2 ].nSenote = 4;
                //        }

                //    }
                //}
                //else if ( ( db1個前の発生時刻ms - db2個前の発声時刻ms ) <= nUnit4 && ( db1個前の発生時刻ms - db2個前の発声時刻ms ) >= nUnit8)
                //{
                //    //2つ前の音符と1つ前の音符の間が8分以上でかつ、16分以内

                //    if( ( db1個前の発生時刻ms - db2個前の発声時刻ms ) >= nUnit8 && ( db1個前の発生時刻ms - db2個前の発声時刻ms ) > nUnit16 )
                //    {
                //        //2つ前の音符と1つ前の音符の間が8分以上でかつ、16分以内なら「ド」
                //        if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
                //        {
                //            list音符のみのリスト[ nCount - 2 ].nSenote = 1;
                //        }
                //        else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
                //        {
                //            list音符のみのリスト[ nCount - 2 ].nSenote = 4;
                //        }
                //    }
                //    else if( ( db1個前の発生時刻ms - db2個前の発声時刻ms ) < nUnit8 )
                //    {
                //        //2つ前の音符と1つ前の音符の間が16分以内なら「ド」で確定
                //        if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
                //        {
                //            list音符のみのリスト[ nCount - 2 ].nSenote = 1;
                //        }
                //        else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
                //            list音符のみのリスト[ nCount - 2 ].nSenote = 4;
                //    }

                //    if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) >= nUnit16 )
                //    {
                //        if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) >= nUnit8 )
                //        {
                //            if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
                //            {
                //                list音符のみのリスト[ nCount - 1 ].nSenote = 0;
                //            }
                //            else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
                //                list音符のみのリスト[ nCount - 1 ].nSenote = 3;
                //        }
                //    }
                //}
                //else if ( ( db1個前の発生時刻ms - db2個前の発声時刻ms ) >= nUnit16 && ( db1個前の発生時刻ms - db2個前の発声時刻ms ) <= nUnit8 )
                //{
                //    //2つ前の音符と1つ前の音符の間が16分以上
                //    if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
                //    {
                //        list音符のみのリスト[ nCount - 2 ].nSenote = 1;
                //    }
                //    else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
                //        list音符のみのリスト[ nCount - 2 ].nSenote = 4;

                //    if( ( pChip.n発声時刻ms - db1個前の発生時刻ms ) >= nUnit8 )
                //    {
                //        if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x93 )
                //        {
                //            list音符のみのリスト[ nCount - 1 ].nSenote = 0;
                //        }
                //        else if( list音符のみのリスト[ nCount - 2 ].nチャンネル番号 == 0x94 )
                //            list音符のみのリスト[ nCount - 1 ].nSenote = 3;
                //    }


                //}
                #endregion

                nCount++;
            }
        }

        /// <summary>
        /// コア部分Ver2。TJAP2から移植しただけ。
        /// </summary>
        /// <param name="list音符のみのリスト"></param>
        private void tSenotes_Core_V2( List<CChip> list音符のみのリスト )
        {
	        const int DATA = 3;
	        int doco_count = 0;
	        int[] sort = new int [7];
	        double[] time = new double[7];
	        double[] scroll = new double [7];
	        double time_tmp;

          	for(int i = 0; i < list音符のみのリスト.Count; i++)
            {
                for (int j = 0; j < 7; j++)
                {
                    if (i + (j - 3) < 0)
                    {
                        sort[j] = -1;
                        time[j] = -1000000000;
                        scroll[j] = 1.0;
                    }
                    else if (i + (j - 3) >= list音符のみのリスト.Count)
                    {
                        sort[j] = -1;
                        time[j] = 1000000000;
                        scroll[j] = 1.0;
                    }
                    else
                    {
                        sort[j] = list音符のみのリスト[i + (j - 3)].nチャンネル番号;
                        time[j] = list音符のみのリスト[i + (j - 3)].fBMSCROLLTime;
                        scroll[j] = list音符のみのリスト[i + (j - 3)].dbSCROLL;
                    }
                }
                time_tmp = time[DATA];
                for (int j = 0; j < 7; j++)
                {
                    time[j] = (time[j] - time_tmp) * scroll[j];
                    if (time[j] < 0) time[j] *= -1;
                }

                switch( list音符のみのリスト[i].nチャンネル番号 )
                {
                    case 0x93:

                        //（左2より離れている｜）・右2・右ドン・右右4・右右ドン…
                        if ((time[DATA - 1] > 2/* || (sort[DATA-1] != 1 && time[DATA-1] >= 2 && time[DATA-2] >= 4 && time[DATA-3] <= 5)*/) && time[DATA + 1] == 2 && sort[DATA + 1] == 1 && time[DATA + 2] == 4 && sort[DATA + 2] == 1 && time[DATA + 3] == 6 && sort[DATA + 3] == 1)
                        {
                            list音符のみのリスト[i].nSenote = 1;
                            doco_count = 1;
                            break;
                        }
                        //ドコドコ中・左2・右2・右ドン
                        else if (doco_count != 0 && time[DATA - 1] == 2 && time[DATA + 1] == 2 && (sort[DATA + 1] == 1 || sort[DATA + 1] == 3))
                        {
                            if (doco_count % 2 == 0)
                                list音符のみのリスト[i].nSenote = 1;
                            else
                                list音符のみのリスト[i].nSenote = 2;
                            doco_count++;
                            break;
                        }
                        else
                        {
                            doco_count = 0;
                        }

                        //ドコドコドン
                        if (time[DATA - 3] >= 3.4 && time[DATA - 2] == 2 && time[DATA - 1] == 1 && time[DATA + 1] == 1 && time[DATA + 2] == 2 && time[DATA + 3] >= 3.4 && sort[DATA - 2] == 1 && sort[DATA - 1] == 1 && sort[DATA + 1] == 1 && sort[DATA + 2] == 1)
                        {
                            list音符のみのリスト[i - 2].nSenote = 1;
                            list音符のみのリスト[i - 1].nSenote = 2;
                            list音符のみのリスト[i + 0].nSenote = 1;
                            list音符のみのリスト[i + 1].nSenote = 2;
                            list音符のみのリスト[i + 2].nSenote = 0;
                            i += 2;
                        }
                        //ドコドン
                        else if (time[DATA - 2] >= 2.4 && time[DATA - 1] == 1 && time[DATA + 1] == 1 && time[DATA + 2] >= 2.4 && sort[DATA - 1] == 1 && sort[DATA + 1] == 1)
                        {
                            list音符のみのリスト[i].nSenote = 2;
                        }
                        //右の音符が2以上離れている
                        else if (time[DATA + 1] > 2)
                        {
                            list音符のみのリスト[i].nSenote = 0;
                        }
                        //右の音符が1.4以上・左の音符が1.4以内
                        else if (time[DATA + 1] >= 1.4 && time[DATA - 1] <= 1.4)
                        {
                            list音符のみのリスト[i].nSenote = 0;
                        }
                        //右の音符が2以上・右右の音符が3以内
                        else if (time[DATA + 1] >= 2 && time[DATA + 2] <= 3)
                        {
                            list音符のみのリスト[i].nSenote = 0;
                        }
                        //右の音符が2以上・大音符
                        else if (time[DATA + 1] >= 2 && (sort[DATA + 1] == 3 || sort[DATA + 1] == 4))
                        {
                            list音符のみのリスト[i].nSenote = 0;
                        }
                        else
                        {
                            list音符のみのリスト[i].nSenote = 1;
                        }
                        break;
                    case 0x94:
                        doco_count = 0;

                        //右の音符が2以上離れている
                        if (time[DATA + 1] > 2)
                        {
                            list音符のみのリスト[i].nSenote = 3;
                        }
                        //右の音符が1.4以上・左の音符が1.4以内
                        else if (time[DATA + 1] >= 1.4 && time[DATA - 1] <= 1.4)
                        {
                            list音符のみのリスト[i].nSenote = 3;
                        }
                        //右の音符が2以上・右右の音符が3以内
                        else if (time[DATA + 1] >= 2 && time[DATA + 2] <= 3)
                        {
                            list音符のみのリスト[i].nSenote = 3;
                        }
                        //右の音符が2以上・大音符
                        else if (time[DATA + 1] >= 2 && (sort[DATA + 1] == 3 || sort[DATA + 1] == 4))
                        {
                            list音符のみのリスト[i].nSenote = 3;
                        }
                        else
                        {
                            list音符のみのリスト[i].nSenote = 4;
                        }
                        break;
                    default:
                        doco_count = 0;
                        break;
                }
            }



        }

		/// <summary>
		/// サウンドミキサーにサウンドを登録・削除する時刻を事前に算出する
		/// </summary>
		public void PlanToAddMixerChannel()
		{
			if ( CDTXMania.Sound管理.GetCurrentSoundDeviceType() == "DirectSound" )	// DShowでの再生の場合はミキシング負荷が高くないため、
			{																		// チップのライフタイム管理を行わない
				return;
			}

			List<CChip> listAddMixerChannel = new List<CChip>( 128 ); ;
			List<CChip> listRemoveMixerChannel = new List<CChip>( 128 );
			List<CChip> listRemoveTiming = new List<CChip>( 128 );

			foreach ( CChip pChip in listChip )
			{
				switch ( pChip.nチャンネル番号 )
				{
					// BGM, 演奏チャネル, 不可視サウンド, フィルインサウンド, 空打ち音はミキサー管理の対象
					// BGM:
					case 0x01:
					// Dr演奏チャネル
					case 0x11:	case 0x12:	case 0x13:	case 0x14:	case 0x15:	case 0x16:	case 0x17:	case 0x18:	case 0x19:	case 0x1A:  case 0x1B:  case 0x1C:
					// Gt演奏チャネル
					case 0x20:	case 0x21:	case 0x22:	case 0x23:	case 0x24:	case 0x25:	case 0x26:	case 0x27:	case 0x28:
					// Bs演奏チャネル
					case 0xA0:	case 0xA1:	case 0xA2:	case 0xA3:	case 0xA4:	case 0xA5:	case 0xA6:	case 0xA7:	case 0xA8:
					// Dr不可視チップ
					case 0x31:	case 0x32:	case 0x33:	case 0x34:	case 0x35:	case 0x36:	case 0x37:
					case 0x38:	case 0x39:	case 0x3A:
					// Dr/Gt/Bs空打ち
					case 0xB1:	case 0xB2:	case 0xB3:	case 0xB4:	case 0xB5:	case 0xB6:	case 0xB7:	case 0xB8:
					case 0xB9:	case 0xBA:	case 0xBB:	case 0xBC:
					// フィルインサウンド
					case 0x1F:	case 0x2F:	case 0xAF:
					// 自動演奏チップ
					case 0x61:	case 0x62:	case 0x63:	case 0x64:	case 0x65:	case 0x66:	case 0x67:	case 0x68:	case 0x69:
					case 0x70:	case 0x71:	case 0x72:	case 0x73:	case 0x74:	case 0x75:	case 0x76:	case 0x77:	case 0x78:	case 0x79:
					case 0x80:	case 0x81:	case 0x82:	case 0x83:	case 0x84:	case 0x85:	case 0x86:	case 0x87:	case 0x88:	case 0x89:
					case 0x90:	case 0x91:	case 0x92:

						#region [ 発音1秒前のタイミングを算出 ]
						int n発音前余裕ms = 1000, n発音後余裕ms = 800;
						{
							int ch = pChip.nチャンネル番号 >> 4;
							if ( ch == 0x02 || ch == 0x0A )
							{
								n発音前余裕ms = 800;
								n発音前余裕ms = 500;
							}
							if ( ch == 0x06 || ch == 0x07 || ch == 0x08 || ch == 0x09 )
							{
								n発音前余裕ms = 200;
								n発音前余裕ms = 500;
							}
						}
						#endregion
						#region [ BGMチップならば即ミキサーに追加 ]
						//if ( pChip.nチャンネル番号 == 0x01 )	// BGMチップは即ミキサーに追加
						//{
						//    if ( listWAV.ContainsKey( pChip.n整数値・内部番号 ) )
						//    {
						//        CDTX.CWAV wc = CDTXMania.DTX.listWAV[ pChip.n整数値・内部番号 ];
						//        if ( wc.rSound[ 0 ] != null )
						//        {
						//            CDTXMania.Sound管理.AddMixer( wc.rSound[ 0 ] );	// BGMは多重再生しない仕様としているので、1個目だけミキサーに登録すればよい
						//        }
						//    }
						//}
						#endregion
						#region [ 発音1秒前のタイミングを算出 ]
						int nAddMixer時刻ms, nAddMixer位置 = 0;
//Debug.WriteLine("==================================================================");
//Debug.WriteLine( "Start: ch=" + pChip.nチャンネル番号.ToString("x2") + ", nWAV番号=" + pChip.n整数値 + ", time=" + pChip.n発声時刻ms + ", lasttime=" + listChip[ listChip.Count - 1 ].n発声時刻ms );
						t発声時刻msと発声位置を取得する( pChip.n発声時刻ms - n発音前余裕ms, out nAddMixer時刻ms, out nAddMixer位置 );
//Debug.WriteLine( "nAddMixer時刻ms=" + nAddMixer時刻ms + ",nAddMixer位置=" + nAddMixer位置 );

						CChip c_AddMixer = new CChip()
						{
							nチャンネル番号 = 0xDA,
							n整数値 = pChip.n整数値,
							n整数値・内部番号 = pChip.n整数値・内部番号,
							n発声時刻ms = nAddMixer時刻ms,
							n発声位置 = nAddMixer位置,
							b演奏終了後も再生が続くチップである = false
						};
						listAddMixerChannel.Add( c_AddMixer );
//Debug.WriteLine("listAddMixerChannel:" );
//DebugOut_CChipList( listAddMixerChannel );
						#endregion

						int duration = 0;
						if ( listWAV.ContainsKey( pChip.n整数値・内部番号 ) )
						{
							CDTX.CWAV wc = CDTXMania.DTX.listWAV[ pChip.n整数値・内部番号 ];
							double _db再生速度 = ( CDTXMania.DTXVmode.Enabled ) ? this.dbDTXVPlaySpeed : this.db再生速度;
							duration = ( wc.rSound[ 0 ] == null ) ? 0 : (int) ( wc.rSound[ 0 ].n総演奏時間ms / _db再生速度 );	// #23664 durationに再生速度が加味されておらず、低速再生でBGMが途切れる問題を修正 (発声時刻msは、DTX読み込み時に再生速度加味済)
						}
//Debug.WriteLine("duration=" + duration );
						int n新RemoveMixer時刻ms, n新RemoveMixer位置;
						t発声時刻msと発声位置を取得する( pChip.n発声時刻ms + duration + n発音後余裕ms, out n新RemoveMixer時刻ms, out n新RemoveMixer位置 );
//Debug.WriteLine( "n新RemoveMixer時刻ms=" + n新RemoveMixer時刻ms + ",n新RemoveMixer位置=" + n新RemoveMixer位置 );
						if ( n新RemoveMixer時刻ms < pChip.n発声時刻ms + duration )	// 曲の最後でサウンドが切れるような場合は
						{
							CChip c_AddMixer_noremove = c_AddMixer;
							c_AddMixer_noremove.b演奏終了後も再生が続くチップである = true;
							listAddMixerChannel[ listAddMixerChannel.Count - 1 ] = c_AddMixer_noremove;
							//continue;												// 発声位置の計算ができないので、Mixer削除をあきらめる・・・のではなく
																					// #32248 2013.10.15 yyagi 演奏終了後も再生を続けるチップであるというフラグをpChip内に立てる
							break;
						}
						#region [ 未使用コード ]
						//if ( n新RemoveMixer時刻ms < pChip.n発声時刻ms + duration )	// 曲の最後でサウンドが切れるような場合
						//{
						//    n新RemoveMixer時刻ms = pChip.n発声時刻ms + duration;
						//    // 「位置」は比例計算で求めてお茶を濁す...このやり方だと誤動作したため対応中止
						//    n新RemoveMixer位置 = listChip[ listChip.Count - 1 ].n発声位置 * n新RemoveMixer時刻ms / listChip[ listChip.Count - 1 ].n発声時刻ms;
						//}
						#endregion

						#region [ 発音終了2秒後にmixerから削除するが、その前に再発音することになるのかを確認(再発音ならmixer削除タイミングを延期) ]
						int n整数値 = pChip.n整数値;
						int index = listRemoveTiming.FindIndex(
							delegate( CChip cchip ) { return cchip.n整数値 == n整数値; }
						);
//Debug.WriteLine( "index=" + index );
						if ( index >= 0 )													// 過去に同じチップで発音中のものが見つかった場合
						{																	// 過去の発音のmixer削除を確定させるか、延期するかの2択。
							int n旧RemoveMixer時刻ms = listRemoveTiming[ index ].n発声時刻ms;
							int n旧RemoveMixer位置 = listRemoveTiming[ index ].n発声位置;

//Debug.WriteLine( "n旧RemoveMixer時刻ms=" + n旧RemoveMixer時刻ms + ",n旧RemoveMixer位置=" + n旧RemoveMixer位置 );
							if ( pChip.n発声時刻ms - n発音前余裕ms <= n旧RemoveMixer時刻ms )	// mixer削除前に、同じ音の再発音がある場合は、
							{																	// mixer削除時刻を遅延させる(if-else後に行う)
//Debug.WriteLine( "remove TAIL of listAddMixerChannel. TAIL INDEX=" + listAddMixerChannel.Count );
//DebugOut_CChipList( listAddMixerChannel );
								listAddMixerChannel.RemoveAt( listAddMixerChannel.Count - 1 );	// また、同じチップ音の「mixerへの再追加」は削除する
//Debug.WriteLine( "removed result:" );
//DebugOut_CChipList( listAddMixerChannel );
							}
							else															// 逆に、時間軸上、mixer削除後に再発音するような流れの場合は
							{
//Debug.WriteLine( "Publish the value(listRemoveTiming[index] to listRemoveMixerChannel." );
								listRemoveMixerChannel.Add( listRemoveTiming[ index ] );	// mixer削除を確定させる
//Debug.WriteLine( "listRemoveMixerChannel:" );
//DebugOut_CChipList( listRemoveMixerChannel );
								//listRemoveTiming.RemoveAt( index );
							}
							CChip c = new CChip()											// mixer削除時刻を更新(遅延)する
							{
								nチャンネル番号 = 0xDB,
								n整数値 = listRemoveTiming[ index ].n整数値,
								n整数値・内部番号 = listRemoveTiming[ index ].n整数値・内部番号,
								n発声時刻ms = n新RemoveMixer時刻ms,
								n発声位置 = n新RemoveMixer位置
							};
							listRemoveTiming[ index ] = c;
							//listRemoveTiming[ index ].n発声時刻ms = n新RemoveMixer時刻ms;	// mixer削除時刻を更新(遅延)する
							//listRemoveTiming[ index ].n発声位置 = n新RemoveMixer位置;
//Debug.WriteLine( "listRemoveTiming: modified" );
//DebugOut_CChipList( listRemoveTiming );
						}
						else																// 過去に同じチップを発音していないor
						{																	// 発音していたが既にmixer削除確定していたなら
							CChip c = new CChip()											// 新しくmixer削除候補として追加する
							{
								nチャンネル番号 = 0xDB,
								n整数値 = pChip.n整数値,
								n整数値・内部番号 = pChip.n整数値・内部番号,
								n発声時刻ms = n新RemoveMixer時刻ms,
								n発声位置 = n新RemoveMixer位置
							};
//Debug.WriteLine( "Add new chip to listRemoveMixerTiming: " );
//Debug.WriteLine( "ch=" + c.nチャンネル番号.ToString( "x2" ) + ", nWAV番号=" + c.n整数値 + ", time=" + c.n発声時刻ms + ", lasttime=" + listChip[ listChip.Count - 1 ].n発声時刻ms );
							listRemoveTiming.Add( c );
//Debug.WriteLine( "listRemoveTiming:" );
//DebugOut_CChipList( listRemoveTiming );
						}
						#endregion
						break;
				}
			}
//Debug.WriteLine("==================================================================");
//Debug.WriteLine( "Result:" );
//Debug.WriteLine( "listAddMixerChannel:" );
//DebugOut_CChipList( listAddMixerChannel );
//Debug.WriteLine( "listRemoveMixerChannel:" );
//DebugOut_CChipList( listRemoveMixerChannel );
//Debug.WriteLine( "listRemoveTiming:" );
//DebugOut_CChipList( listRemoveTiming );
//Debug.WriteLine( "==================================================================" );

			listChip.AddRange( listAddMixerChannel );
			listChip.AddRange( listRemoveMixerChannel );
			listChip.AddRange( listRemoveTiming );
			listChip.Sort();
		}
		private void DebugOut_CChipList( List<CChip> c )
		{
//Debug.WriteLine( "Count=" + c.Count );
			for ( int i = 0; i < c.Count; i++ )
			{
				Debug.WriteLine( i + ": ch=" + c[ i ].nチャンネル番号.ToString("x2") + ", WAV番号=" + c[ i ].n整数値 + ", time=" + c[ i ].n発声時刻ms );
			}
		}
		private bool t発声時刻msと発声位置を取得する( int n希望発声時刻ms, out int n新発声時刻ms, out int n新発声位置 )
		{
			// 発声時刻msから発声位置を逆算することはできないため、近似計算する。
			// 具体的には、希望発声位置前後の2つのチップの発声位置の中間を取る。

			if ( n希望発声時刻ms < 0 )
			{
				n希望発声時刻ms = 0;
			}
			//else if ( n希望発声時刻ms > listChip[ listChip.Count - 1 ].n発声時刻ms )		// BGMの最後の余韻を殺してしまうので、この条件は外す
			//{
			//    n希望発声時刻ms = listChip[ listChip.Count - 1 ].n発声時刻ms;
			//}

			int index_min = -1, index_max = -1;
			for ( int i = 0; i < listChip.Count; i++ )		// 希望発声位置前後の「前」の方のチップを検索
			{
				if ( listChip[ i ].n発声時刻ms >= n希望発声時刻ms )
				{
					index_min = i;
					break;
				}
			}
			if ( index_min < 0 )	// 希望発声時刻に至らずに曲が終了してしまう場合
			{
				// listの最終項目の時刻をそのまま使用する
								//・・・のではダメ。BGMが尻切れになる。
								// そこで、listの最終項目の発声時刻msと発生位置から、希望発声時刻に相当する希望発声位置を比例計算して求める。
				//n新発声時刻ms = n希望発声時刻ms;
				//n新発声位置 = listChip[ listChip.Count - 1 ].n発声位置 * n希望発声時刻ms / listChip[ listChip.Count - 1 ].n発声時刻ms;
				n新発声時刻ms = listChip[ listChip.Count - 1 ].n発声時刻ms;
				n新発声位置   = listChip[ listChip.Count - 1 ].n発声位置;
				return false;
			}
			index_max = index_min + 1;
			if ( index_max >= listChip.Count )
			{
				index_max = index_min;
			}
			n新発声時刻ms = ( listChip[ index_max ].n発声時刻ms + listChip[ index_min ].n発声時刻ms ) / 2;
			n新発声位置   = ( listChip[ index_max ].n発声位置   + listChip[ index_min ].n発声位置   ) / 2;

			return true;
		}


		/// <summary>
		/// Swap infos between Guitar and Bass (notes, level, n可視チップ数, bチップがある)
		/// </summary>
		public void SwapGuitarBassInfos()						// #24063 2011.1.24 yyagi ギターとベースの譜面情報入替
		{
			for (int i = this.listChip.Count - 1; i >= 0; i--) {
				if (listChip[i].e楽器パート == E楽器パート.BASS) {
					listChip[i].e楽器パート = E楽器パート.GUITAR;
					listChip[i].nチャンネル番号 -= ( 0xA0 - 0x20 );
				}
				else if ( listChip[i].e楽器パート == E楽器パート.GUITAR )
				{
					listChip[i].e楽器パート = E楽器パート.BASS;
					listChip[i].nチャンネル番号 += ( 0xA0 - 0x20 );
				}
				else if ( listChip[ i ].nチャンネル番号 == 0x28 )		// #25215 2011.5.21 yyagi wailingはE楽器パート.UNKNOWNが割り当てられているので個別に対応
				{
					listChip[ i ].nチャンネル番号 += ( 0xA0 - 0x20 );
				}
				else if ( listChip[ i ].nチャンネル番号 == 0xA8 )		// #25215 2011.5.21 yyagi wailingはE楽器パート.UNKNOWNが割り当てられているので個別に対応
				{
					listChip[ i ].nチャンネル番号 -= ( 0xA0 - 0x20 );
				}
			}
			int t = this.LEVEL.Bass;
			this.LEVEL.Bass = this.LEVEL.Guitar;
			this.LEVEL.Guitar = t;

			t = this.n可視チップ数.Bass;
			this.n可視チップ数.Bass = this.n可視チップ数.Guitar;
			this.n可視チップ数.Guitar = t;

			bool ts = this.bチップがある.Bass;
			this.bチップがある.Bass = this.bチップがある.Guitar;
			this.bチップがある.Guitar = ts;

//			SwapGuitarBassInfos_AutoFlags();
		}

		// SwapGuitarBassInfos_AutoFlags()は、CDTXからCConfigIniに移動。

		// CActivity 実装

		public override void On活性化()
		{
			this.listWAV = new Dictionary<int, CWAV>();
			this.listBPM = new Dictionary<int, CBPM>();
            this.listSCROLL = new Dictionary<int, CSCROLL>();
            this.listSCROLL_Normal = new Dictionary<int, CSCROLL>();
            this.listSCROLL_Expert = new Dictionary<int, CSCROLL>();
            this.listSCROLL_Master = new Dictionary<int, CSCROLL>();
            this.listDELAY = new Dictionary<int, CDELAY>();
            this.listBRANCH = new Dictionary<int, CBRANCH>();
			this.listAVI = new Dictionary<int, CAVI>();
			this.listAVIPAN = new Dictionary<int, CAVIPAN>();
            this.listDS = new Dictionary<int, CDirectShow>();
			this.listChip = new List<CChip>();
            this.listBalloon_Normal = new List<int>();
            this.listBalloon_Expert = new List<int>();
            this.listBalloon_Master = new List<int>();
			base.On活性化();
		}
		public override void On非活性化()
		{
			if( this.listWAV != null )
			{
				foreach( CWAV cwav in this.listWAV.Values )
				{
					cwav.Dispose();
				}
				this.listWAV = null;
			}
			if( this.listAVI != null )
			{
				foreach( CAVI cavi in this.listAVI.Values )
				{
					cavi.Dispose();
				}
				this.listAVI = null;
			}
			if( this.listAVIPAN != null )
			{
				this.listAVIPAN.Clear();
				this.listAVIPAN = null;
			}
            if( this.listDS != null )
            {
                foreach ( CDirectShow cds in this.listDS.Values )
                {
                    cds.Dispose();
                }
                this.listDS = null;
            }
			if( this.listBPM != null )
			{
				this.listBPM.Clear();
				this.listBPM = null;
			}
			if( this.listDELAY != null )
			{
				this.listDELAY.Clear();
				this.listDELAY = null;
			}
			if( this.listBRANCH != null )
			{
				this.listBRANCH.Clear();
				this.listBRANCH = null;
			}
			if( this.listSCROLL != null )
			{
				this.listSCROLL.Clear();
				this.listSCROLL = null;
			}

			if( this.listSCROLL_Normal != null )
			{
				this.listSCROLL_Normal.Clear();
				this.listSCROLL_Normal = null;
			}
			if( this.listSCROLL_Expert != null )
			{
				this.listSCROLL_Expert.Clear();
				this.listSCROLL_Expert = null;
			}
			if( this.listSCROLL_Master != null )
			{
				this.listSCROLL_Master.Clear();
				this.listSCROLL_Master = null;
			}

			if( this.listChip != null )
			{
				this.listChip.Clear();
			}

			if( this.listBalloon_Normal != null )
			{
				this.listBalloon_Normal.Clear();
			}
			if( this.listBalloon_Expert != null )
			{
				this.listBalloon_Expert.Clear();
			}
			if( this.listBalloon_Master != null )
			{
				this.listBalloon_Master.Clear();
			}
			base.On非活性化();
		}
		public override void OnManagedリソースの作成()
		{
			if( !base.b活性化してない )
			{
				this.tAVIの読み込み();
				base.OnManagedリソースの作成();
			}
		}
		public override void OnManagedリソースの解放()
		{
			if( !base.b活性化してない )
			{
				if( this.listAVI != null )
				{
					foreach( CAVI cavi in this.listAVI.Values )
					{
						cavi.Dispose();
					}
				}
                if( this.listDS != null )
                {
                    foreach( CDirectShow cds in this.listDS.Values )
                    {
                        cds.Dispose();
                    }
                }
				base.OnManagedリソースの解放();
			}
		}

		// その他
		
		#region [ private ]
		//-----------------
		/// <summary>
		/// <para>GDAチャンネル番号に対応するDTXチャンネル番号。</para>
		/// </summary>
		[StructLayout( LayoutKind.Sequential )]
		private struct STGDAPARAM
		{
			public string strGDAのチャンネル文字列;	
			public int nDTXのチャンネル番号;

			public STGDAPARAM( string strGDAのチャンネル文字列, int nDTXのチャンネル番号 )		// 2011.1.1 yyagi 構造体のコンストラクタ追加(初期化簡易化のため)
			{
				this.strGDAのチャンネル文字列 = strGDAのチャンネル文字列;
				this.nDTXのチャンネル番号 = nDTXのチャンネル番号;
			}
		}

		private readonly STGDAPARAM[] stGDAParam;
		private bool bヘッダのみ;
		private Stack<bool> bstackIFからENDIFをスキップする;
	
		private int n現在の行数;
		private int n現在の乱数;

		private int nPolyphonicSounds = 4;							// #28228 2012.5.1 yyagi

		private int n内部番号BPM1to;
		private int n内部番号SCROLL1to;
		private int n内部番号DELAY1to;
		private int n内部番号BRANCH1to;
		private int n内部番号WAV1to;
		private int[] n無限管理BPM;
		private int[] n無限管理PAN;
		private int[] n無限管理SIZE;
		private int[] n無限管理VOL;
		private int[] n無限管理WAV;
		private int[] nRESULTIMAGE用優先順位;
		private int[] nRESULTMOVIE用優先順位;
		private int[] nRESULTSOUND用優先順位;

        private void t行のコメント処理( ref string strText )
        {
            int nCommentPos = strText.IndexOf("//");
            if( nCommentPos != -1 )
                strText = strText.Remove( nCommentPos );
        }

		private bool t入力・コマンド文字列を抜き出す( ref CharEnumerator ce, ref StringBuilder sb文字列 )
		{
			if( !this.t入力・空白をスキップする( ref ce ) )
				return false;	// 文字が尽きた

			#region [ コマンド終端文字(':')、半角空白、コメント開始文字(';')、改行のいずれかが出現するまでをコマンド文字列と見なし、sb文字列 にコピーする。]
			//-----------------
			while( ce.Current != ':' && ce.Current != ' ' && ce.Current != ';' && ce.Current != '\n' )
			{
				sb文字列.Append( ce.Current );

				if( !ce.MoveNext() )
					return false;	// 文字が尽きた
			}
			//-----------------
			#endregion

			#region [ コマンド終端文字(':')で終端したなら、その次から空白をスキップしておく。]
			//-----------------
			if( ce.Current == ':' )
			{
				if( !ce.MoveNext() )
					return false;	// 文字が尽きた

				if( !this.t入力・空白をスキップする( ref ce ) )
					return false;	// 文字が尽きた
			}
			//-----------------
			#endregion

			return true;
		}
		private bool t入力・コメントをスキップする( ref CharEnumerator ce )
		{
			// 改行が現れるまでをコメントと見なしてスキップする。

			while( ce.Current != '\n' )
			{
				if( !ce.MoveNext() )
					return false;	// 文字が尽きた
			}

			// 改行の次の文字へ移動した結果を返す。

			return ce.MoveNext();
		}
		private bool t入力・コメント文字列を抜き出す( ref CharEnumerator ce, ref StringBuilder sb文字列 )
		{
			if( ce.Current != ';' )		// コメント開始文字(';')じゃなければ正常帰還。
				return true;

			if( !ce.MoveNext() )		// ';' の次で文字列が終わってたら終了帰還。
				return false;

			#region [ ';' の次の文字から '\n' の１つ前までをコメント文字列と見なし、sb文字列にコピーする。]
			//-----------------
			while( ce.Current != '\n' )
			{
				sb文字列.Append( ce.Current );

				if( !ce.MoveNext() )
					return false;
			}
			//-----------------
			#endregion

			return true;
		}
		private void t入力・パラメータ食い込みチェック( string strコマンド名, ref string strコマンド, ref string strパラメータ )
		{
			if( ( strコマンド.Length > strコマンド名.Length ) && strコマンド.StartsWith( strコマンド名, StringComparison.OrdinalIgnoreCase ) )
			{
				strパラメータ = strコマンド.Substring( strコマンド名.Length ).Trim();
				strコマンド = strコマンド.Substring( 0, strコマンド名.Length );
			}
		}
		private bool t入力・パラメータ文字列を抜き出す( ref CharEnumerator ce, ref StringBuilder sb文字列 )
		{
			if( !this.t入力・空白をスキップする( ref ce ) )
				return false;	// 文字が尽きた

			#region [ 改行またはコメント開始文字(';')が出現するまでをパラメータ文字列と見なし、sb文字列 にコピーする。]
			//-----------------
			while( ce.Current != '\n' && ce.Current != ';' )
			{
				sb文字列.Append( ce.Current );

				if( !ce.MoveNext() )
					return false;
			}
			//-----------------
			#endregion

			return true;
		}
		private bool t入力・空白と改行をスキップする( ref CharEnumerator ce )
		{
			// 空白と改行が続く間はこれらをスキップする。

			while( ce.Current == ' ' || ce.Current == '\n' )
			{
				if( ce.Current == '\n' )
					this.n現在の行数++;		// 改行文字では行番号が増える。

				if( !ce.MoveNext() )
					return false;	// 文字が尽きた
			}

			return true;
		}
		private bool t入力・空白をスキップする( ref CharEnumerator ce )
		{
			// 空白が続く間はこれをスキップする。

			while( ce.Current == ' ' )
			{
				if( !ce.MoveNext() )
					return false;	// 文字が尽きた
			}

			return true;
		}
		private void t入力・行解析( ref StringBuilder sbコマンド, ref StringBuilder sbパラメータ, ref StringBuilder sbコメント )
		{
			string strコマンド = sbコマンド.ToString();
			string strパラメータ = sbパラメータ.ToString().Trim();
			string strコメント = sbコメント.ToString();

			// 行頭コマンドの処理

			#region [ IF ]
			//-----------------
			if( strコマンド.StartsWith( "IF", StringComparison.OrdinalIgnoreCase ) )
			{
				this.t入力・パラメータ食い込みチェック( "IF", ref strコマンド, ref strパラメータ );

				if( this.bstackIFからENDIFをスキップする.Count == 255 )
				{
					Trace.TraceWarning( "#IF の入れ子の数が 255 を超えました。この #IF を無視します。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
				}
				else if( this.bstackIFからENDIFをスキップする.Peek() )
				{
					this.bstackIFからENDIFをスキップする.Push( true );	// 親が true ならその入れ子も問答無用で true 。
				}
				else													// 親が false なら入れ子はパラメータと乱数を比較して結果を判断する。
				{
					int n数値 = 0;

					if( !int.TryParse( strパラメータ, out n数値 ) )
						n数値 = 1;

					this.bstackIFからENDIFをスキップする.Push( n数値 != this.n現在の乱数 );		// 乱数と数値が一致したら true 。
				}
			}
			//-----------------
			#endregion
			#region [ ENDIF ]
			//-----------------
			else if( strコマンド.StartsWith( "ENDIF", StringComparison.OrdinalIgnoreCase ) )
			{
				this.t入力・パラメータ食い込みチェック( "ENDIF", ref strコマンド, ref strパラメータ );

				if( this.bstackIFからENDIFをスキップする.Count > 1 )
				{
					this.bstackIFからENDIFをスキップする.Pop();		// 入れ子を１つ脱出。
				}
				else
				{
					Trace.TraceWarning( "#ENDIF に対応する #IF がありません。この #ENDIF を無視します。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
				}
			}
			//-----------------
			#endregion

			else if( !this.bstackIFからENDIFをスキップする.Peek() )		// IF～ENDIF をスキップするなら以下はすべて無視。
			{
				#region [ PATH_WAV ]
				//-----------------
				if( strコマンド.StartsWith( "PATH_WAV", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "PATH_WAV", ref strコマンド, ref strパラメータ );
					this.PATH_WAV = strパラメータ;
				}
				//-----------------
				#endregion
				#region [ TITLE ]
				//-----------------
				else if( strコマンド.StartsWith( "TITLE", StringComparison.OrdinalIgnoreCase ) )
				{
					//this.t入力・パラメータ食い込みチェック( "TITLE", ref strコマンド, ref strパラメータ );
					//this.TITLE = strパラメータ;
				}
				//-----------------
				#endregion
				#region [ ARTIST ]
				//-----------------
				else if( strコマンド.StartsWith( "ARTIST", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "ARTIST", ref strコマンド, ref strパラメータ );
					this.ARTIST = strパラメータ;
				}
				//-----------------
				#endregion
				#region [ COMMENT ]
				//-----------------
				else if( strコマンド.StartsWith( "COMMENT", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "COMMENT", ref strコマンド, ref strパラメータ );
					this.COMMENT = strパラメータ;
				}
				//-----------------
				#endregion
				#region [ DLEVEL, PLAYLEVEL ]
				//-----------------
				else if(
					strコマンド.StartsWith( "DLEVEL", StringComparison.OrdinalIgnoreCase ) ||
					strコマンド.StartsWith( "PLAYLEVEL", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "DLEVEL", ref strコマンド, ref strパラメータ );
					this.t入力・パラメータ食い込みチェック( "PLAYLEVEL", ref strコマンド, ref strパラメータ );

					int dlevel;
					if( int.TryParse( strパラメータ, out dlevel ) )
					{
						this.LEVEL.Drums = Math.Min( Math.Max( dlevel, 0 ), 100 );	// 0～100 に丸める
					}
				}
				//-----------------
				#endregion
				#region [ GLEVEL ]
				//-----------------
				else if( strコマンド.StartsWith( "GLEVEL", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "GLEVEL", ref strコマンド, ref strパラメータ );

					int glevel;
					if( int.TryParse( strパラメータ, out glevel ) )
					{
						this.LEVEL.Guitar = Math.Min( Math.Max( glevel, 0 ), 100 );		// 0～100 に丸める
					}
				}
				//-----------------
				#endregion
				#region [ BLEVEL ]
				//-----------------
				else if( strコマンド.StartsWith( "BLEVEL", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "BLEVEL", ref strコマンド, ref strパラメータ );

					int blevel;
					if( int.TryParse( strパラメータ, out blevel ) )
					{
						this.LEVEL.Bass = Math.Min( Math.Max( blevel, 0 ), 100 );		// 0～100 に丸める
					}
				}
				//-----------------
				#endregion
#if TEST_NOTEOFFMODE
				else if (str.StartsWith("SUPRESSNOTEOFF_HIHAT", StringComparison.OrdinalIgnoreCase)) {
					this.t入力・パラメータ食い込みチェック("SUPRESSNOTEOFF_HIHAT", ref str, ref str2);
					this.bHH演奏で直前のHHを消音する = !str2.ToLower().Equals("on");
				} 
				else if (str.StartsWith("SUPRESSNOTEOFF_GUITAR", StringComparison.OrdinalIgnoreCase)) {
					this.t入力・パラメータ食い込みチェック("SUPRESSNOTEOFF_GUITAR", ref str, ref str2);
					this.bGUITAR演奏で直前のGUITARを消音する = !str2.ToLower().Equals("on");
				}
				else if (str.StartsWith("SUPRESSNOTEOFF_BASS", StringComparison.OrdinalIgnoreCase)) {
					this.t入力・パラメータ食い込みチェック("SUPRESSNOTEOFF_BASS", ref str, ref str2);
					this.bBASS演奏で直前のBASSを消音する = !str2.ToLower().Equals("on");
				}
#endif
				#region [ GENRE ]
				//-----------------
				else if( strコマンド.StartsWith( "GENRE", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "GENRE", ref strコマンド, ref strパラメータ );
					this.GENRE = strパラメータ;
				}
				//-----------------
				#endregion
				#region [ HIDDENLEVEL ]
				//-----------------
				else if( strコマンド.StartsWith( "HIDDENLEVEL", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "HIDDENLEVEL", ref strコマンド, ref strパラメータ );
					this.HIDDENLEVEL = strパラメータ.ToLower().Equals( "on" );
				}
				//-----------------
				#endregion
				#region [ STAGEFILE ]
				//-----------------
				else if( strコマンド.StartsWith( "STAGEFILE", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "STAGEFILE", ref strコマンド, ref strパラメータ );
					this.STAGEFILE = strパラメータ;
				}
				//-----------------
				#endregion
				#region [ PREVIEW ]
				//-----------------
				else if( strコマンド.StartsWith( "PREVIEW", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "PREVIEW", ref strコマンド, ref strパラメータ );
					this.PREVIEW = strパラメータ;
				}
				//-----------------
				#endregion
				#region [ PREIMAGE ]
				//-----------------
				else if( strコマンド.StartsWith( "PREIMAGE", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "PREIMAGE", ref strコマンド, ref strパラメータ );
					this.PREIMAGE = strパラメータ;
				}
				//-----------------
				#endregion
				#region [ PREMOVIE ]
				//-----------------
				else if( strコマンド.StartsWith( "PREMOVIE", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "PREMOVIE", ref strコマンド, ref strパラメータ );
					this.PREMOVIE = strパラメータ;
				}
				//-----------------
				#endregion
				#region [ RANDOM ]
				//-----------------
				else if( strコマンド.StartsWith( "RANDOM", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "RANDOM", ref strコマンド, ref strパラメータ );

					int n数値 = 1;
					if( !int.TryParse( strパラメータ, out n数値 ) )
						n数値 = 1;

					this.n現在の乱数 = CDTXMania.Random.Next( n数値 ) + 1;		// 1～数値 までの乱数を生成。
				}
				//-----------------
				#endregion
				#region [ BPM ]
				//-----------------
				else if( strコマンド.StartsWith( "BPM", StringComparison.OrdinalIgnoreCase ) )
				{
					//this.t入力・行解析・BPM_BPMzz( strコマンド, strパラメータ, strコメント );
				}
				//-----------------
				#endregion
				#region [ DTXVPLAYSPEED ]
				//-----------------
				else if ( strコマンド.StartsWith( "DTXVPLAYSPEED", StringComparison.OrdinalIgnoreCase ) )
				{
					this.t入力・パラメータ食い込みチェック( "DTXVPLAYSPEED", ref strコマンド, ref strパラメータ );

					double dtxvplayspeed = 0.0;
					if ( TryParse( strパラメータ, out dtxvplayspeed ) && dtxvplayspeed > 0.0 )
					{
						this.dbDTXVPlaySpeed = dtxvplayspeed;
					}
				}
				//-----------------
				#endregion
				else if( !this.bヘッダのみ )		// ヘッダのみの解析の場合、以下は無視。
				{
					#region [ PANEL ]
					//-----------------
					if( strコマンド.StartsWith( "PANEL", StringComparison.OrdinalIgnoreCase ) )
					{
						this.t入力・パラメータ食い込みチェック( "PANEL", ref strコマンド, ref strパラメータ );

						int dummyResult;								// #23885 2010.12.12 yyagi: not to confuse "#PANEL strings (panel)" and "#PANEL int (panpot of EL)"
						if( !int.TryParse( strパラメータ, out dummyResult ) )
						{		// 数値じゃないならPANELとみなす
							this.PANEL = strパラメータ;							//
							goto EOL;									//
						}												// 数値ならPAN ELとみなす

					}
					//-----------------
					#endregion
					#region [ BASEBPM ]
					//-----------------
					else if( strコマンド.StartsWith( "BASEBPM", StringComparison.OrdinalIgnoreCase ) )
					{
						this.t入力・パラメータ食い込みチェック( "BASEBPM", ref strコマンド, ref strパラメータ );

						double basebpm = 0.0;
						//if( double.TryParse( str2, out num6 ) && ( num6 > 0.0 ) )
						if( TryParse( strパラメータ, out basebpm ) && basebpm > 0.0 )	// #23880 2010.12.30 yyagi: alternative TryParse to permit both '.' and ',' for decimal point
						{													// #24204 2011.01.21 yyagi: Fix the condition correctly
							this.BASEBPM = basebpm;
						}
					}
					//-----------------
					#endregion

					// オブジェクト記述コマンドの処理。

					else if( !this.t入力・行解析・WAVVOL_VOLUME( strコマンド, strパラメータ, strコメント ) &&
						!this.t入力・行解析・WAVPAN_PAN( strコマンド, strパラメータ, strコメント ) &&
						!this.t入力・行解析・WAV( strコマンド, strBGM_PATH != null ? strBGM_PATH : strパラメータ, strコメント ) &&
                        !this.t入力・行解析・AVIPAN( strコマンド, strパラメータ, strコメント ) &&
						!this.t入力・行解析・AVI_VIDEO( strコマンド, strパラメータ, strコメント ) &&
					//	!this.t入力・行解析・BPM_BPMzz( strコマンド, strパラメータ, strコメント ) &&	// bヘッダのみ==trueの場合でもチェックするよう変更
						!this.t入力・行解析・SIZE( strコマンド, strパラメータ, strコメント ) )
					{
						this.t入力・行解析・チップ配置( strコマンド, strパラメータ, strコメント );
					}
				EOL:
					Debug.Assert( true );		// #23885 2010.12.12 yyagi: dummy line to exit parsing the line
												// 2011.8.17 from: "int xx=0;" から変更。毎回警告が出るので。
				}
				//else
				//{	// Duration測定のため、bヘッダのみ==trueでも、チップ配置は行う
				//	this.t入力・行解析・チップ配置( strコマンド, strパラメータ, strコメント );
				//}
			}
		}
		private bool t入力・行解析・AVI_VIDEO( string strコマンド, string strパラメータ, string strコメント )
		{
			// (1) コマンドを処理。

			#region [ "AVI" or "VIDEO" で始まらないコマンドは無効。]
			//-----------------
			if( strコマンド.StartsWith( "AVI", StringComparison.OrdinalIgnoreCase ) )
				strコマンド = strコマンド.Substring( 3 );		// strコマンド から先頭の"AVI"文字を除去。

			else if( strコマンド.StartsWith( "VIDEO", StringComparison.OrdinalIgnoreCase ) )
				strコマンド = strコマンド.Substring( 5 );		// strコマンド から先頭の"VIDEO"文字を除去。

			else
				return false;
			//-----------------
			#endregion

			// (2) パラメータを処理。

			if( strコマンド.Length < 2 )
				return false;	// AVI番号 zz がないなら無効。

			#region [ AVI番号 zz を取得する。]
			//-----------------
			int zz = C変換.n36進数2桁の文字列を数値に変換して返す( strコマンド.Substring( 0, 2 ) );
			if( zz < 0 || zz >= 36 * 36 )
			{
				Trace.TraceError( "AVI(VIDEO)番号に 00～ZZ 以外の値または不正な文字列が指定されました。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
				return false;
			}
			//-----------------
			#endregion

			#region [ AVIリストに {zz, avi} の組を登録する。 ]
			//-----------------
			var avi = new CAVI() {
				n番号 = zz,
				strファイル名 = strパラメータ,
				strコメント文 = strコメント,
			};

			if( this.listAVI.ContainsKey( zz ) )	// 既にリスト中に存在しているなら削除。後のものが有効。
				this.listAVI.Remove( zz );

			this.listAVI.Add( zz, avi );

            var ds = new CDirectShow()
            {
                n番号 = zz,
                strファイル名 = strパラメータ,
                strコメント文 = strコメント,
            };

            if (this.listDS.ContainsKey(zz))	// 既にリスト中に存在しているなら削除。後のものが有効。
                this.listDS.Remove(zz);

            this.listDS.Add(zz, ds);
			//-----------------
			#endregion

			return true;
		}
		private bool t入力・行解析・AVIPAN( string strコマンド, string strパラメータ, string strコメント )
		{
			// (1) コマンドを処理。

			#region [ "AVIPAN" で始まらないコマンドは無効。]
			//-----------------
			if( !strコマンド.StartsWith( "AVIPAN", StringComparison.OrdinalIgnoreCase ) )
				return false;

			strコマンド = strコマンド.Substring( 6 );	// strコマンド から先頭の"AVIPAN"文字を除去。
			//-----------------
			#endregion

			// (2) パラメータを処理。

			if( strコマンド.Length < 2 )
				return false;	// AVIPAN番号 zz がないなら無効。

			#region [ AVIPAN番号 zz を取得する。]
			//-----------------
			int zz = C変換.n36進数2桁の文字列を数値に変換して返す( strコマンド.Substring( 0, 2 ) );
			if( zz < 0 || zz >= 36 * 36 )
			{
				Trace.TraceError( "AVIPAN番号に 00～ZZ 以外の値または不正な文字列が指定されました。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
				return false;
			}
			//-----------------
			#endregion

			var avipan = new CAVIPAN() {
				n番号 = zz,
			};

			// パラメータ引数（14個）を取得し、avipan に登録していく。

			string[] strParams = strパラメータ.Split( new char[] { ' ', ',', '(', ')', '[', ']', 'x', '|' }, StringSplitOptions.RemoveEmptyEntries );

			#region [ パラメータ引数は全14個ないと無効。]
			//-----------------
			if( strParams.Length < 14 )
			{
				Trace.TraceError( "AVIPAN: 引数が足りません。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
				return false;
			}
			//-----------------
			#endregion

			int i = 0;
			int n値 = 0;

			#region [ 1. AVI番号 ]
			//-----------------
			if( string.IsNullOrEmpty( strParams[ i ] ) || strParams[ i ].Length > 2 )
			{
				Trace.TraceError( "AVIPAN: {2}番目の数（AVI番号）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.nAVI番号 = C変換.n36進数2桁の文字列を数値に変換して返す( strParams[ i ] );
			if( avipan.nAVI番号 < 1 || avipan.nAVI番号 >= 36 * 36 )
			{
				Trace.TraceError( "AVIPAN: {2}番目の数（AVI番号）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			i++;
			//-----------------
			#endregion
			#region [ 2. 開始転送サイズ・幅 ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（開始転送サイズ・幅）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.sz開始サイズ.Width = n値;
			i++;
			//-----------------
			#endregion
			#region [ 3. 転送サイズ・高さ ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（開始転送サイズ・高さ）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.sz開始サイズ.Height = n値;
			i++;
			//-----------------
			#endregion
			#region [ 4. 終了転送サイズ・幅 ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（終了転送サイズ・幅）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.sz終了サイズ.Width = n値;
			i++;
			//-----------------
			#endregion
			#region [ 5. 終了転送サイズ・高さ ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（終了転送サイズ・高さ）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.sz終了サイズ.Height = n値;
			i++;
			//-----------------
			#endregion
			#region [ 6. 動画側開始位置・X ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（動画側開始位置・X）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.pt動画側開始位置.X = n値;
			i++;
			//-----------------
			#endregion
			#region [ 7. 動画側開始位置・Y ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（動画側開始位置・Y）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.pt動画側開始位置.Y = n値;
			i++;
			//-----------------
			#endregion
			#region [ 8. 動画側終了位置・X ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（動画側終了位置・X）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.pt動画側終了位置.X = n値;
			i++;
			//-----------------
			#endregion
			#region [ 9. 動画側終了位置・Y ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（動画側終了位置・Y）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.pt動画側終了位置.Y = n値;
			i++;
			//-----------------
			#endregion
			#region [ 10.表示側開始位置・X ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（表示側開始位置・X）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.pt表示側開始位置.X = n値;
			i++;
			//-----------------
			#endregion
			#region [ 11.表示側開始位置・Y ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（表示側開始位置・Y）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.pt表示側開始位置.Y = n値;
			i++;
			//-----------------
			#endregion
			#region [ 12.表示側終了位置・X ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（表示側終了位置・X）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.pt表示側終了位置.X = n値;
			i++;
			//-----------------
			#endregion
			#region [ 13.表示側終了位置・Y ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（表示側終了位置・Y）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}
			avipan.pt表示側終了位置.Y = n値;
			i++;
			//-----------------
			#endregion
			#region [ 14.移動時間 ]
			//-----------------
			n値 = 0;
			if( !int.TryParse( strParams[ i ], out n値 ) )
			{
				Trace.TraceError( "AVIPAN: {2}番目の引数（移動時間）が異常です。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数, i + 1 );
				return false;
			}

			if( n値 < 0 )
				n値 = 0;

			avipan.n移動時間ct = n値;
			i++;
			//-----------------
			#endregion

			#region [ AVIPANリストに {zz, avipan} の組を登録する。]
			//-----------------
			if( this.listAVIPAN.ContainsKey( zz ) )	// 既にリスト中に存在しているなら削除。後のものが有効。
				this.listAVIPAN.Remove( zz );

			this.listAVIPAN.Add( zz, avipan );
			//-----------------
			#endregion

			return true;
		}
		private bool t入力・行解析・BPM_BPMzz( string strコマンド, string strパラメータ, string strコメント )
		{
			// (1) コマンドを処理。

			#region [ "BPM" で始まらないコマンドは無効。]
			//-----------------
			if( !strコマンド.StartsWith( "BPM", StringComparison.OrdinalIgnoreCase ) )
				return false;

			strコマンド = strコマンド.Substring( 3 );	// strコマンド から先頭の"BPM"文字を除去。
			//-----------------
			#endregion

			// (2) パラメータを処理。

			int zz = 0;

			#region [ BPM番号 zz を取得する。]
			//-----------------
			if( strコマンド.Length < 2 )
			{
				#region [ (A) "#BPM:" の場合 → zz = 00 ]
				//-----------------
				zz = 0;
				//-----------------
				#endregion
			}
			else
			{
				#region [ (B) "#BPMzz:" の場合 → zz = 00 ～ ZZ ]
				//-----------------
				zz = C変換.n36進数2桁の文字列を数値に変換して返す( strコマンド.Substring( 0, 2 ) );
				if( zz < 0 || zz >= 36 * 36 )
				{
					Trace.TraceError( "BPM番号に 00～ZZ 以外の値または不正な文字列が指定されました。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
					return false;
				}
				//-----------------
				#endregion
			}
			//-----------------
			#endregion

			double dbBPM = 0.0;

			#region [ BPM値を取得する。]
			//-----------------
			//if( !double.TryParse( strパラメータ, out result ) )
			if( !TryParse( strパラメータ, out dbBPM ) )			// #23880 2010.12.30 yyagi: alternative TryParse to permit both '.' and ',' for decimal point
				return false;

			if( dbBPM <= 0.0 )
				return false;
			//-----------------
			#endregion

			if( zz == 0 )			// "#BPM00:" と "#BPM:" は等価。
				this.BPM = dbBPM;	// この曲の代表 BPM に格納する。

			#region [ BPMリストに {内部番号, zz, dbBPM} の組を登録。]
			//-----------------
			this.listBPM.Add(
				this.n内部番号BPM1to,
				new CBPM() {
					n内部番号 = this.n内部番号BPM1to,
					n表記上の番号 = zz,
					dbBPM値 = dbBPM,
				} );
			//-----------------
			#endregion

			#region [ BPM番号が zz であるBPM未設定のBPMチップがあれば、そのサイズを変更する。無限管理に対応。]
			//-----------------
			if( this.n無限管理BPM[ zz ] == -zz )	// 初期状態では n無限管理BPM[zz] = -zz である。この場合、#BPMzz がまだ出現していないことを意味する。
			{
				for( int i = 0; i < this.listChip.Count; i++ )	// これまでに出てきたチップのうち、該当する（BPM値が未設定の）BPMチップの値を変更する（仕組み上、必ず後方参照となる）。
				{
					var chip = this.listChip[ i ];

					if( chip.bBPMチップである && chip.n整数値・内部番号 == -zz )	// #BPMzz 行より前の行に出現した #BPMzz では、整数値・内部番号は -zz に初期化されている。
						chip.n整数値・内部番号 = this.n内部番号BPM1to;
				}
			}
			this.n無限管理BPM[ zz ] = this.n内部番号BPM1to;			// 次にこの BPM番号 zz を使うBPMチップが現れたら、このBPM値が格納されることになる。
			this.n内部番号BPM1to++;		// 内部番号は単純増加連番。
			//-----------------
			#endregion

			return true;
		}

		private bool t入力・行解析・SIZE( string strコマンド, string strパラメータ, string strコメント )
		{
			// (1) コマンドを処理。

			#region [ "SIZE" で始まらないコマンドや、その後ろに2文字（番号）が付随してないコマンドは無効。]
			//-----------------
			if( !strコマンド.StartsWith( "SIZE", StringComparison.OrdinalIgnoreCase ) )
				return false;

			strコマンド = strコマンド.Substring( 4 );	// strコマンド から先頭の"SIZE"文字を除去。

			if( strコマンド.Length < 2 )	// サイズ番号の指定がない場合は無効。
				return false;
			//-----------------
			#endregion

			#region [ nWAV番号（36進数2桁）を取得。]
			//-----------------
			int nWAV番号 = C変換.n36進数2桁の文字列を数値に変換して返す( strコマンド.Substring( 0, 2 ) );

			if( nWAV番号 < 0 || nWAV番号 >= 36 * 36 )
			{
				Trace.TraceError( "SIZEのWAV番号に 00～ZZ 以外の値または不正な文字列が指定されました。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
				return false;
			}
			//-----------------
			#endregion


			// (2) パラメータを処理。

			#region [ nサイズ値 を取得する。値は 0～100 に収める。]
			//-----------------
			int nサイズ値;

			if( !int.TryParse( strパラメータ, out nサイズ値 ) )
				return true;	// int変換に失敗しても、この行自体の処理は終えたのでtrueを返す。

			nサイズ値 = Math.Min( Math.Max( nサイズ値, 0 ), 100 );	// 0未満は0、100超えは100に強制変換。
			//-----------------
			#endregion

			#region [ nWAV番号で示されるサイズ未設定のWAVチップがあれば、そのサイズを変更する。無限管理に対応。]
			//-----------------
			if( this.n無限管理SIZE[ nWAV番号 ] == -nWAV番号 )	// 初期状態では n無限管理SIZE[xx] = -xx である。この場合、#SIZExx がまだ出現していないことを意味する。
			{
				foreach( CWAV wav in this.listWAV.Values )		// これまでに出てきたWAVチップのうち、該当する（サイズが未設定の）チップのサイズを変更する（仕組み上、必ず後方参照となる）。
				{
					if( wav.nチップサイズ == -nWAV番号 )		// #SIZExx 行より前の行に出現した #WAVxx では、チップサイズは -xx に初期化されている。
						wav.nチップサイズ = nサイズ値;
				}
			}
			this.n無限管理SIZE[ nWAV番号 ] = nサイズ値;			// 次にこの nWAV番号を使うWAVチップが現れたら、負数の代わりに、このサイズ値が格納されることになる。
			//-----------------
			#endregion

			return true;
		}
		private bool t入力・行解析・WAV( string strコマンド, string strパラメータ, string strコメント )
		{
			// (1) コマンドを処理。

			#region [ "WAV" で始まらないコマンドは無効。]
			//-----------------
			if( !strコマンド.StartsWith( "WAV", StringComparison.OrdinalIgnoreCase ) )
				return false;

			strコマンド = strコマンド.Substring( 3 );	// strコマンド から先頭の"WAV"文字を除去。
			//-----------------
			#endregion

			// (2) パラメータを処理。

			if( strコマンド.Length < 2 )
				return false;	// WAV番号 zz がないなら無効。

			#region [ WAV番号 zz を取得する。]
			//-----------------
			int zz = C変換.n36進数2桁の文字列を数値に変換して返す( strコマンド.Substring( 0, 2 ) );
			if( zz < 0 || zz >= 36 * 36 )
			{
				Trace.TraceError( "WAV番号に 00～ZZ 以外の値または不正な文字列が指定されました。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
				return false;
			}
			//-----------------
			#endregion

			var wav = new CWAV() {
				n内部番号 = this.n内部番号WAV1to,
				n表記上の番号 = zz,
				nチップサイズ = this.n無限管理SIZE[ zz ],
				n位置 = this.n無限管理PAN[ zz ],
				n音量 = this.n無限管理VOL[ zz ],
				strファイル名 = strパラメータ,
				strコメント文 = strコメント,
			};

			#region [ WAVリストに {内部番号, wav} の組を登録。]
			//-----------------
			this.listWAV.Add( this.n内部番号WAV1to, wav );
			//-----------------
			#endregion

			#region [ WAV番号が zz である内部番号未設定のWAVチップがあれば、その内部番号を変更する。無限管理対応。]
			//-----------------
			if( this.n無限管理WAV[ zz ] == -zz )	// 初期状態では n無限管理WAV[zz] = -zz である。この場合、#WAVzz がまだ出現していないことを意味する。
			{
				for( int i = 0; i < this.listChip.Count; i++ )	// これまでに出てきたチップのうち、該当する（内部番号が未設定の）WAVチップの値を変更する（仕組み上、必ず後方参照となる）。
				{
					var chip = this.listChip[ i ];

					if( chip.bWAVを使うチャンネルである && ( chip.n整数値・内部番号 == -zz ) )	// この #WAVzz 行より前の行に出現した #WAVzz では、整数値・内部番号は -zz に初期化されている。
						chip.n整数値・内部番号 = this.n内部番号WAV1to;
				}
			}
			this.n無限管理WAV[ zz ] = this.n内部番号WAV1to;			// 次にこの WAV番号 zz を使うWAVチップが現れたら、この内部番号が格納されることになる。
			this.n内部番号WAV1to++;		// 内部番号は単純増加連番。
			//-----------------
			#endregion

			return true;
		}
		private bool t入力・行解析・WAVPAN_PAN( string strコマンド, string strパラメータ, string strコメント )
		{
			// (1) コマンドを処理。

			#region [ "WAVPAN" or "PAN" で始まらないコマンドは無効。]
			//-----------------
			if( strコマンド.StartsWith( "WAVPAN", StringComparison.OrdinalIgnoreCase ) )
				strコマンド = strコマンド.Substring( 6 );		// strコマンド から先頭の"WAVPAN"文字を除去。

			else if( strコマンド.StartsWith( "PAN", StringComparison.OrdinalIgnoreCase ) )
				strコマンド = strコマンド.Substring( 3 );		// strコマンド から先頭の"PAN"文字を除去。

			else
				return false;
			//-----------------
			#endregion

			// (2) パラメータを処理。

			if( strコマンド.Length < 2 )
				return false;	// WAV番号 zz がないなら無効。

			#region [ WAV番号 zz を取得する。]
			//-----------------
			int zz = C変換.n36進数2桁の文字列を数値に変換して返す( strコマンド.Substring( 0, 2 ) );
			if( zz < 0 || zz >= 36 * 36 )
			{
				Trace.TraceError( "WAVPAN(PAN)のWAV番号に 00～ZZ 以外の値または不正な文字列が指定されました。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
				return false;
			}
			//-----------------
			#endregion

			#region [ WAV番号 zz を持つWAVチップの位置を変更する。無限定義対応。]
			//-----------------
			int n位置;
			if( int.TryParse( strパラメータ, out n位置 ) )
			{
				n位置 = Math.Min( Math.Max( n位置, -100 ), 100 );	// -100～+100 に丸める

				if( this.n無限管理PAN[ zz ] == ( -10000 - zz ) )	// 初期状態では n無限管理PAN[zz] = -10000 - zz である。この場合、#WAVPANzz, #PANzz がまだ出現していないことを意味する。
				{
					foreach( CWAV wav in this.listWAV.Values )	// これまでに出てきたチップのうち、該当する（位置が未設定の）WAVチップの値を変更する（仕組み上、必ず後方参照となる）。
					{
						if( wav.n位置 == ( -10000 - zz ) )	// #WAVPANzz, #PANzz 行より前の行に出現した #WAVzz では、位置は -10000-zz に初期化されている。
							wav.n位置 = n位置;
					}
				}
				this.n無限管理PAN[ zz ] = n位置;			// 次にこの WAV番号 zz を使うWAVチップが現れたら、この位置が格納されることになる。
			}
			//-----------------
			#endregion

			return true;
		}
		private bool t入力・行解析・WAVVOL_VOLUME( string strコマンド, string strパラメータ, string strコメント )
		{
			// (1) コマンドを処理。

			#region [ "WAVCOL" or "VOLUME" で始まらないコマンドは無効。]
			//-----------------
			if( strコマンド.StartsWith( "WAVVOL", StringComparison.OrdinalIgnoreCase ) )
				strコマンド = strコマンド.Substring( 6 );		// strコマンド から先頭の"WAVVOL"文字を除去。

			else if( strコマンド.StartsWith( "VOLUME", StringComparison.OrdinalIgnoreCase ) )
				strコマンド = strコマンド.Substring( 6 );		// strコマンド から先頭の"VOLUME"文字を除去。

			else
				return false;
			//-----------------
			#endregion

			// (2) パラメータを処理。

			if( strコマンド.Length < 2 )
				return false;	// WAV番号 zz がないなら無効。

			#region [ WAV番号 zz を取得する。]
			//-----------------
			int zz = C変換.n36進数2桁の文字列を数値に変換して返す( strコマンド.Substring( 0, 2 ) );
			if( zz < 0 || zz >= 36 * 36 )
			{
				Trace.TraceError( "WAV番号に 00～ZZ 以外の値または不正な文字列が指定されました。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
				return false;
			}
			//-----------------
			#endregion

			#region [ WAV番号 zz を持つWAVチップの音量を変更する。無限定義対応。]
			//-----------------
			int n音量;
			if( int.TryParse( strパラメータ, out n音量 ) )
			{
				n音量 = Math.Min( Math.Max( n音量, 0 ), 100 );	// 0～100に丸める。

				if( this.n無限管理VOL[ zz ] == -zz )	// 初期状態では n無限管理VOL[zz] = - zz である。この場合、#WAVVOLzz, #VOLUMEzz がまだ出現していないことを意味する。
				{
					foreach( CWAV wav in this.listWAV.Values )	// これまでに出てきたチップのうち、該当する（音量が未設定の）WAVチップの値を変更する（仕組み上、必ず後方参照となる）。
					{
						if( wav.n音量 == -zz )	// #WAVVOLzz, #VOLUMEzz 行より前の行に出現した #WAVzz では、音量は -zz に初期化されている。
							wav.n音量 = n音量;
					}
				}
				this.n無限管理VOL[ zz ] = n音量;			// 次にこの WAV番号 zz を使うWAVチップが現れたら、この音量が格納されることになる。
			}
			//-----------------
			#endregion

			return true;
		}
		private bool t入力・行解析・チップ配置( string strコマンド, string strパラメータ, string strコメント )
		{
			// (1) コマンドを処理。

			if( strコマンド.Length != 5 )	// コマンドは必ず5文字であること。
				return false;

			#region [ n小節番号 を取得する。]
			//-----------------
			int n小節番号 = C変換.n小節番号の文字列3桁を数値に変換して返す( strコマンド.Substring( 0, 3 ) );
			if( n小節番号 < 0 )
				return false;

			n小節番号++;	// 先頭に空の1小節を設ける。
			//-----------------
			#endregion

			#region [ nチャンネル番号 を取得する。]
			//-----------------
			int nチャンネル番号 = -1;

			// ファイルフォーマットによって処理が異なる。

			if( this.e種別 == E種別.GDA || this.e種別 == E種別.G2D )
			{
				#region [ (A) GDA, G2D の場合：チャンネル文字列をDTXのチャンネル番号へ置き換える。]
				//-----------------
				string strチャンネル文字列 = strコマンド.Substring( 3, 2 );

				foreach( STGDAPARAM param in this.stGDAParam )
				{
					if( strチャンネル文字列.Equals( param.strGDAのチャンネル文字列, StringComparison.OrdinalIgnoreCase ) )
					{
						nチャンネル番号 = param.nDTXのチャンネル番号;
						break;	// 置き換え成功
					}
				}
				if( nチャンネル番号 < 0 )
					return false;	// 置き換え失敗
				//-----------------
				#endregion
			}
			else
			{
				#region [ (B) その他の場合：チャンネル番号は16進数2桁。]
				//-----------------
				nチャンネル番号 = C変換.n16進数2桁の文字列を数値に変換して返す( strコマンド.Substring( 3, 2 ) );

				if( nチャンネル番号 < 0 )
					return false;
				//-----------------
				#endregion
			}
			//-----------------
			#endregion
			#region [ 取得したチャンネル番号で、this.bチップがある に該当があれば設定する。]
			//-----------------
			if( ( nチャンネル番号 >= 0x11 ) && ( nチャンネル番号 <= 0x1a ) )
			{
				this.bチップがある.Drums = true;
			}
			else if( ( nチャンネル番号 >= 0x20 ) && ( nチャンネル番号 <= 0x27 ) )
			{
				this.bチップがある.Guitar = true;
			}
			else if( ( nチャンネル番号 >= 0xA0 ) && ( nチャンネル番号 <= 0xa7 ) )
			{
				this.bチップがある.Bass = true;
			}
			switch( nチャンネル番号 )
			{
				case 0x18:
					this.bチップがある.HHOpen = true;
					break;

				case 0x19:
					this.bチップがある.Ride = true;
					break;

				case 0x1a:
					this.bチップがある.LeftCymbal = true;
					break;

				case 0x20:
					this.bチップがある.OpenGuitar = true;
					break;

				case 0xA0:
					this.bチップがある.OpenBass = true;
					break;
			}
			//-----------------
			#endregion


			// (2) Ch.02を処理。

			#region [ 小節長変更(Ch.02)は他のチャンネルとはパラメータが特殊なので、先にとっとと終わらせる。 ]
			//-----------------
			if( nチャンネル番号 == 0x02 )
			{
				// 小節長倍率を取得する。

				double db小節長倍率 = 1.0;
				//if( !double.TryParse( strパラメータ, out result ) )
				if( !this.TryParse( strパラメータ, out db小節長倍率 ) )			// #23880 2010.12.30 yyagi: alternative TryParse to permit both '.' and ',' for decimal point
				{
					Trace.TraceError( "小節長倍率に不正な値を指定しました。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
					return false;
				}

				// 小節長倍率チップを配置する。

				this.listChip.Insert(
					0,
					new CChip() {
						nチャンネル番号 = nチャンネル番号,
						db実数値 = db小節長倍率,
						n発声位置 = n小節番号 * 384,
					} );

				return true;	// 配置終了。
			}
			//-----------------
			#endregion


			// (3) パラメータを処理。

			if( string.IsNullOrEmpty( strパラメータ ) )		// パラメータはnullまたは空文字列ではないこと。
				return false;

			#region [ strパラメータ にオブジェクト記述を格納し、その n文字数 をカウントする。]
			//-----------------
			int n文字数 = 0;

			var sb = new StringBuilder( strパラメータ.Length );

			// strパラメータを先頭から1文字ずつ見ながら正規化（無効文字('_')を飛ばしたり不正な文字でエラーを出したり）し、sb へ格納する。

			CharEnumerator ce = strパラメータ.GetEnumerator();
			while( ce.MoveNext() )
			{
				if( ce.Current == '_' )		// '_' は無視。
					continue;

				if( C変換.str36進数文字.IndexOf( ce.Current ) < 0 )	// オブジェクト記述は36進数文字であること。
				{
					Trace.TraceError( "不正なオブジェクト指定があります。[{0}: {1}行]", this.strファイル名の絶対パス, this.n現在の行数 );
					return false;
				}

				sb.Append( ce.Current );
				n文字数++;
			}

			strパラメータ = sb.ToString();	// 正規化された文字列になりました。

			if( ( n文字数 % 2 ) != 0 )		// パラメータの文字数が奇数の場合、最後の1文字を無視する。
				n文字数--;
			//-----------------
			#endregion


			// (4) パラメータをオブジェクト数値に分解して配置する。

			for( int i = 0; i < ( n文字数 / 2 ); i++ )	// 2文字で1オブジェクト数値
			{
				#region [ nオブジェクト数値 を１つ取得する。'00' なら無視。]
				//-----------------
				int nオブジェクト数値 = 0;

				if( nチャンネル番号 == 0x03 )
				{
					// Ch.03 のみ 16進数2桁。
					nオブジェクト数値 = C変換.n16進数2桁の文字列を数値に変換して返す( strパラメータ.Substring( i * 2, 2 ) );
				}
				else
				{
					// その他のチャンネルは36進数2桁。
					nオブジェクト数値 = C変換.n36進数2桁の文字列を数値に変換して返す( strパラメータ.Substring( i * 2, 2 ) );
				}

				if( nオブジェクト数値 == 0x00 )
					continue;
				//-----------------
				#endregion

				// オブジェクト数値に対応するチップを生成。

				var chip = new CChip();

				chip.nチャンネル番号 = nチャンネル番号;
				chip.n発声位置 = ( n小節番号 * 384 ) + ( ( 384 * i ) / ( n文字数 / 2 ) );
				chip.n整数値 = nオブジェクト数値;
				chip.n整数値・内部番号 = nオブジェクト数値;

				#region [ chip.e楽器パート = ... ]
				//-----------------
				if( ( nチャンネル番号 >= 0x11 ) && ( nチャンネル番号 <= 0x1C ) )
				{
					chip.e楽器パート = E楽器パート.DRUMS;
				}
				if( ( nチャンネル番号 >= 0x20 ) && ( nチャンネル番号 <= 0x27 ) )
				{
					chip.e楽器パート = E楽器パート.GUITAR;
				}
				if( ( nチャンネル番号 >= 160 ) && ( nチャンネル番号 <= 0xA7 ) )
				{
					chip.e楽器パート = E楽器パート.BASS;
				}
				//-----------------
				#endregion

				#region [ 無限定義への対応 → 内部番号の取得。]
				//-----------------
				if( chip.bWAVを使うチャンネルである )
				{
					chip.n整数値・内部番号 = this.n無限管理WAV[ nオブジェクト数値 ];	// これが本当に一意なWAV番号となる。（無限定義の場合、chip.n整数値 は一意である保証がない。）
				}
				else if( chip.bBPMチップである )
				{
					chip.n整数値・内部番号 = this.n無限管理BPM[ nオブジェクト数値 ];	// これが本当に一意なBPM番号となる。（同上。）
				}
				//-----------------
				#endregion

				#region [ フィルインON/OFFチャンネル(Ch.53)の場合、発声位置を少し前後にずらす。]
				//-----------------
				if( nチャンネル番号 == 0x53 )
				{
					// ずらすのは、フィルインONチップと同じ位置にいるチップでも確実にフィルインが発動し、
					// 同様に、フィルインOFFチップと同じ位置にいるチップでも確実にフィルインが終了するようにするため。

					if( ( nオブジェクト数値 > 0 ) && ( nオブジェクト数値 != 2 ) )
					{
						chip.n発声位置 -= 32;	// 384÷32＝12 ということで、フィルインONチップは12分音符ほど前へ移動。
					}
					else if( nオブジェクト数値 == 2 )
					{
						chip.n発声位置 += 32;	// 同じく、フィルインOFFチップは12分音符ほど後ろへ移動。
					}
				}
				//-----------------
				#endregion

				// チップを配置。

				this.listChip.Add( chip );
			}
			return true;
		}
		#region [#23880 2010.12.30 yyagi: コンマとスペースの両方を小数点として扱うTryParse]
		/// <summary>
		/// 小数点としてコンマとピリオドの両方を受け付けるTryParse()
		/// </summary>
		/// <param name="s">strings convert to double</param>
		/// <param name="result">parsed double value</param>
		/// <returns>s が正常に変換された場合は true。それ以外の場合は false。</returns>
		/// <exception cref="ArgumentException">style が NumberStyles 値でないか、style に NumberStyles.AllowHexSpecifier 値が含まれている</exception>
		private bool TryParse(string s, out double result) {	// #23880 2010.12.30 yyagi: alternative TryParse to permit both '.' and ',' for decimal point
																// EU諸国での #BPM 123,45 のような記述に対応するため、
																// 小数点の最終位置を検出して、それをlocaleにあった
																// 文字に置き換えてからTryParse()する
																// 桁区切りの文字はスキップする

			const string DecimalSeparators = ".,";				// 小数点文字
			const string GroupSeparators = ".,' ";				// 桁区切り文字
			const string NumberSymbols = "0123456789";			// 数値文字

			int len = s.Length;									// 文字列長
			int decimalPosition = len;							// 真の小数点の位置 最初は文字列終端位置に仮置きする

			for (int i = 0; i < len; i++) {							// まず、真の小数点(一番最後に現れる小数点)の位置を求める
				char c = s[i];
				if (NumberSymbols.IndexOf(c) >= 0) {				// 数値だったらスキップ
					continue;
				} else if (DecimalSeparators.IndexOf(c) >= 0) {		// 小数点文字だったら、その都度位置を上書き記憶
					decimalPosition = i;
				} else if (GroupSeparators.IndexOf(c) >= 0) {		// 桁区切り文字の場合もスキップ
					continue;
				} else {											// 数値・小数点・区切り文字以外がきたらループ終了
					break;
				}
			}

			StringBuilder decimalStr = new StringBuilder(16);
			for (int i = 0; i < len; i++) {							// 次に、localeにあった数値文字列を生成する
				char c = s[i];
				if (NumberSymbols.IndexOf(c) >= 0) {				// 数値だったら
					decimalStr.Append(c);							// そのままコピー
				} else if (DecimalSeparators.IndexOf(c) >= 0) {		// 小数点文字だったら
					if (i == decimalPosition) {						// 最後に出現した小数点文字なら、localeに合った小数点を出力する
						decimalStr.Append(CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator);
					}
				} else if (GroupSeparators.IndexOf(c) >= 0) {		// 桁区切り文字だったら
					continue;										// 何もしない(スキップ)
				} else {
					break;
				}
			}
			return double.TryParse(decimalStr.ToString(), out result);	// 最後に、自分のlocale向けの文字列に対してTryParse実行
		}
		#endregion
		//-----------------
		#endregion
	}
}
