using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime;
using System.Runtime.InteropServices;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Diagnostics;
using System.Threading;
using SlimDX;
using SlimDX.Direct3D9;
using FDK;

namespace DTXMania
{
	/// <summary>
	/// 演奏画面の共通クラス (ドラム演奏画面, ギター演奏画面の継承元)
	/// </summary>
	internal abstract class CStage演奏画面共通 : CStage
	{
		// プロパティ

		public bool bAUTOでないチップが１つでもバーを通過した	// 誰も参照していない？？
		{
			get;
			protected set;
		}

		// メソッド

		#region [ t演奏結果を格納する・ドラム() ]
		public void t演奏結果を格納する・ドラム( out CScoreIni.C演奏記録 Drums )
		{
			Drums = new CScoreIni.C演奏記録();

			//if (  )
			{
				Drums.nスコア = (long) this.actScore.Get( E楽器パート.DRUMS );
				Drums.dbゲーム型スキル値 = CScoreIni.tゲーム型スキルを計算して返す( CDTXMania.DTX.LEVEL.Drums, CDTXMania.DTX.n可視チップ数.Drums, this.nヒット数・Auto含まない.Drums.Perfect, this.actCombo.n現在のコンボ数.Drums最高値, E楽器パート.DRUMS, bIsAutoPlay );
				Drums.db演奏型スキル値 = CScoreIni.t演奏型スキルを計算して返す( CDTXMania.DTX.n可視チップ数.Drums, this.nヒット数・Auto含まない.Drums.Perfect, this.nヒット数・Auto含まない.Drums.Great, this.nヒット数・Auto含まない.Drums.Good, this.nヒット数・Auto含まない.Drums.Poor, this.nヒット数・Auto含まない.Drums.Miss, E楽器パート.DRUMS, bIsAutoPlay );
				Drums.nPerfect数 = CDTXMania.ConfigIni.bドラムが全部オートプレイである ? this.nヒット数・Auto含む.Drums.Perfect : this.nヒット数・Auto含まない.Drums.Perfect;
				Drums.nGreat数 = CDTXMania.ConfigIni.bドラムが全部オートプレイである ? this.nヒット数・Auto含む.Drums.Great : this.nヒット数・Auto含まない.Drums.Great;
				Drums.nGood数 = CDTXMania.ConfigIni.bドラムが全部オートプレイである ? this.nヒット数・Auto含む.Drums.Good : this.nヒット数・Auto含まない.Drums.Good;
				Drums.nPoor数 = CDTXMania.ConfigIni.bドラムが全部オートプレイである ? this.nヒット数・Auto含む.Drums.Poor : this.nヒット数・Auto含まない.Drums.Poor;
				Drums.nMiss数 = CDTXMania.ConfigIni.bドラムが全部オートプレイである ? this.nヒット数・Auto含む.Drums.Miss : this.nヒット数・Auto含まない.Drums.Miss;
				Drums.nPerfect数・Auto含まない = this.nヒット数・Auto含まない.Drums.Perfect;
				Drums.nGreat数・Auto含まない = this.nヒット数・Auto含まない.Drums.Great;
				Drums.nGood数・Auto含まない = this.nヒット数・Auto含まない.Drums.Good;
				Drums.nPoor数・Auto含まない = this.nヒット数・Auto含まない.Drums.Poor;
				Drums.nMiss数・Auto含まない = this.nヒット数・Auto含まない.Drums.Miss;
				Drums.n最大コンボ数 = this.actCombo.n現在のコンボ数.Drums最高値;
				Drums.n全チップ数 = CDTXMania.DTX.n可視チップ数.Drums;
				for ( int i = 0; i < (int) Eレーン.MAX;  i++ )
				{
					Drums.bAutoPlay[ i ] = bIsAutoPlay[ i ];
				}
				Drums.bTight = CDTXMania.ConfigIni.bTight;
				for ( int i = 0; i < 3; i++ )
				{
					Drums.bSudden[ i ] = CDTXMania.ConfigIni.bSudden[ i ];
					Drums.bHidden[ i ] = CDTXMania.ConfigIni.bHidden[ i ];
					Drums.eInvisible[ i ] = CDTXMania.ConfigIni.eInvisible[ i ];
					Drums.bReverse[ i ] = CDTXMania.ConfigIni.bReverse[ i ];
					Drums.eRandom[ i ] = CDTXMania.ConfigIni.eRandom[ i ];
					Drums.bLight[ i ] = CDTXMania.ConfigIni.bLight[ i ];
					Drums.bLeft[ i ] = CDTXMania.ConfigIni.bLeft[ i ];
					Drums.f譜面スクロール速度[ i ] = ( (float) ( CDTXMania.ConfigIni.n譜面スクロール速度[ i ] + 1 ) ) * 0.5f;
				}
				Drums.eDark = CDTXMania.ConfigIni.eDark;
				Drums.n演奏速度分子 = CDTXMania.ConfigIni.n演奏速度;
				Drums.n演奏速度分母 = 20;
				Drums.eHHGroup = CDTXMania.ConfigIni.eHHGroup;
				Drums.eFTGroup = CDTXMania.ConfigIni.eFTGroup;
				Drums.eCYGroup = CDTXMania.ConfigIni.eCYGroup;
				Drums.eHitSoundPriorityHH = CDTXMania.ConfigIni.eHitSoundPriorityHH;
				Drums.eHitSoundPriorityFT = CDTXMania.ConfigIni.eHitSoundPriorityFT;
				Drums.eHitSoundPriorityCY = CDTXMania.ConfigIni.eHitSoundPriorityCY;
				Drums.bGuitar有効 = CDTXMania.ConfigIni.bGuitar有効;
				Drums.bDrums有効 = CDTXMania.ConfigIni.bDrums有効;
				Drums.bSTAGEFAILED有効 = CDTXMania.ConfigIni.bSTAGEFAILED有効;
				Drums.eダメージレベル = CDTXMania.ConfigIni.eダメージレベル;
				Drums.b演奏にキーボードを使用した = this.b演奏にキーボードを使った.Drums;
				Drums.b演奏にMIDI入力を使用した = this.b演奏にMIDI入力を使った.Drums;
				Drums.b演奏にジョイパッドを使用した = this.b演奏にジョイパッドを使った.Drums;
				Drums.b演奏にマウスを使用した = this.b演奏にマウスを使った.Drums;
				Drums.nPerfectになる範囲ms = CDTXMania.nPerfect範囲ms;
				Drums.nGreatになる範囲ms = CDTXMania.nGreat範囲ms;
				Drums.nGoodになる範囲ms = CDTXMania.nGood範囲ms;
				Drums.nPoorになる範囲ms = CDTXMania.nPoor範囲ms;
				Drums.strDTXManiaのバージョン = CDTXMania.VERSION;
				Drums.最終更新日時 = DateTime.Now.ToString();
				Drums.Hash = CScoreIni.t演奏セクションのMD5を求めて返す( Drums );
                Drums.fゲージ = (float)this.actGauge.db現在のゲージ値.Taiko;
                if( !CDTXMania.ConfigIni.b太鼓パートAutoPlay )
                {
                    Drums.nハイスコア = CDTXMania.stage選曲.r確定されたスコア.譜面情報.nハイスコア; //2015.06.16 kairera0467 他難易度の上書き防止。
                    if( CDTXMania.stage選曲.r確定されたスコア.譜面情報.nハイスコア[ CDTXMania.stage選曲.n確定された曲の難易度 ] < (int)this.actScore.Get( E楽器パート.DRUMS ) )
                        Drums.nハイスコア[ CDTXMania.stage選曲.n確定された曲の難易度 ] = (int)this.actScore.Get( E楽器パート.DRUMS );
                }
			}
		}
		#endregion
		#region [ t演奏結果を格納する・ギター() ]
		public void t演奏結果を格納する・ギター( out CScoreIni.C演奏記録 Guitar )
		{
			Guitar = new CScoreIni.C演奏記録();

			if ( CDTXMania.DTX.bチップがある.Guitar )
			{
				Guitar.nスコア = (long) this.actScore.Get( E楽器パート.GUITAR );
				Guitar.dbゲーム型スキル値 = CScoreIni.tゲーム型スキルを計算して返す( CDTXMania.DTX.LEVEL.Guitar, CDTXMania.DTX.n可視チップ数.Guitar, this.nヒット数・Auto含まない.Guitar.Perfect, this.actCombo.n現在のコンボ数.Guitar最高値, E楽器パート.GUITAR, bIsAutoPlay );
				Guitar.db演奏型スキル値 = CScoreIni.t演奏型スキルを計算して返す( CDTXMania.DTX.n可視チップ数.Guitar, this.nヒット数・Auto含まない.Guitar.Perfect, this.nヒット数・Auto含まない.Guitar.Great, this.nヒット数・Auto含まない.Guitar.Good, this.nヒット数・Auto含まない.Guitar.Poor, this.nヒット数・Auto含まない.Guitar.Miss, E楽器パート.GUITAR, bIsAutoPlay );
				Guitar.nPerfect数 = CDTXMania.ConfigIni.bギターが全部オートプレイである ? this.nヒット数・Auto含む.Guitar.Perfect : this.nヒット数・Auto含まない.Guitar.Perfect;
				Guitar.nGreat数 = CDTXMania.ConfigIni.bギターが全部オートプレイである ? this.nヒット数・Auto含む.Guitar.Great : this.nヒット数・Auto含まない.Guitar.Great;
				Guitar.nGood数 = CDTXMania.ConfigIni.bギターが全部オートプレイである ? this.nヒット数・Auto含む.Guitar.Good : this.nヒット数・Auto含まない.Guitar.Good;
				Guitar.nPoor数 = CDTXMania.ConfigIni.bギターが全部オートプレイである ? this.nヒット数・Auto含む.Guitar.Poor : this.nヒット数・Auto含まない.Guitar.Poor;
				Guitar.nMiss数 = CDTXMania.ConfigIni.bギターが全部オートプレイである ? this.nヒット数・Auto含む.Guitar.Miss : this.nヒット数・Auto含まない.Guitar.Miss;
				Guitar.nPerfect数・Auto含まない = this.nヒット数・Auto含まない.Guitar.Perfect;
				Guitar.nGreat数・Auto含まない = this.nヒット数・Auto含まない.Guitar.Great;
				Guitar.nGood数・Auto含まない = this.nヒット数・Auto含まない.Guitar.Good;
				Guitar.nPoor数・Auto含まない = this.nヒット数・Auto含まない.Guitar.Poor;
				Guitar.nMiss数・Auto含まない = this.nヒット数・Auto含まない.Guitar.Miss;
				Guitar.n最大コンボ数 = this.actCombo.n現在のコンボ数.Guitar最高値;
				Guitar.n全チップ数 = CDTXMania.DTX.n可視チップ数.Guitar;
				for ( int i = 0; i < (int) Eレーン.MAX; i++ )
				{
					Guitar.bAutoPlay[ i ] = bIsAutoPlay[ i ];
				}
				Guitar.bTight = CDTXMania.ConfigIni.bTight;
				for ( int i = 0; i < 3; i++ )
				{
					Guitar.bSudden[ i ] = CDTXMania.ConfigIni.bSudden[ i ];
					Guitar.bHidden[ i ] = CDTXMania.ConfigIni.bHidden[ i ];
					Guitar.eInvisible[ i ] = CDTXMania.ConfigIni.eInvisible[ i ];
					Guitar.bReverse[ i ] = CDTXMania.ConfigIni.bReverse[ i ];
					Guitar.eRandom[ i ] = CDTXMania.ConfigIni.eRandom[ i ];
					Guitar.bLight[ i ] = CDTXMania.ConfigIni.bLight[ i ];
					Guitar.bLeft[ i ] = CDTXMania.ConfigIni.bLeft[ i ];
					Guitar.f譜面スクロール速度[ i ] = ( (float) ( CDTXMania.ConfigIni.n譜面スクロール速度[ i ] + 1 ) ) * 0.5f;
				}
				Guitar.eDark = CDTXMania.ConfigIni.eDark;
				Guitar.n演奏速度分子 = CDTXMania.ConfigIni.n演奏速度;
				Guitar.n演奏速度分母 = 20;
				Guitar.eHHGroup = CDTXMania.ConfigIni.eHHGroup;
				Guitar.eFTGroup = CDTXMania.ConfigIni.eFTGroup;
				Guitar.eCYGroup = CDTXMania.ConfigIni.eCYGroup;
				Guitar.eHitSoundPriorityHH = CDTXMania.ConfigIni.eHitSoundPriorityHH;
				Guitar.eHitSoundPriorityFT = CDTXMania.ConfigIni.eHitSoundPriorityFT;
				Guitar.eHitSoundPriorityCY = CDTXMania.ConfigIni.eHitSoundPriorityCY;
				Guitar.bGuitar有効 = CDTXMania.ConfigIni.bGuitar有効;
				Guitar.bDrums有効 = CDTXMania.ConfigIni.bDrums有効;
				Guitar.bSTAGEFAILED有効 = CDTXMania.ConfigIni.bSTAGEFAILED有効;
				Guitar.eダメージレベル = CDTXMania.ConfigIni.eダメージレベル;
				Guitar.b演奏にキーボードを使用した = this.b演奏にキーボードを使った.Guitar;
				Guitar.b演奏にMIDI入力を使用した = this.b演奏にMIDI入力を使った.Guitar;
				Guitar.b演奏にジョイパッドを使用した = this.b演奏にジョイパッドを使った.Guitar;
				Guitar.b演奏にマウスを使用した = this.b演奏にマウスを使った.Guitar;
				Guitar.nPerfectになる範囲ms = CDTXMania.nPerfect範囲ms;
				Guitar.nGreatになる範囲ms = CDTXMania.nGreat範囲ms;
				Guitar.nGoodになる範囲ms = CDTXMania.nGood範囲ms;
				Guitar.nPoorになる範囲ms = CDTXMania.nPoor範囲ms;
				Guitar.strDTXManiaのバージョン = CDTXMania.VERSION;
				Guitar.最終更新日時 = DateTime.Now.ToString();
				Guitar.Hash = CScoreIni.t演奏セクションのMD5を求めて返す( Guitar );
			}
		}
		#endregion
		#region [ t演奏結果を格納する・ベース() ]
		public void t演奏結果を格納する・ベース( out CScoreIni.C演奏記録 Bass )
		{
			Bass = new CScoreIni.C演奏記録();

			if ( CDTXMania.DTX.bチップがある.Bass )
			{
				Bass.nスコア = (long) this.actScore.Get( E楽器パート.BASS );
				Bass.dbゲーム型スキル値 = CScoreIni.tゲーム型スキルを計算して返す( CDTXMania.DTX.LEVEL.Bass, CDTXMania.DTX.n可視チップ数.Bass, this.nヒット数・Auto含まない.Bass.Perfect, this.actCombo.n現在のコンボ数.Bass最高値, E楽器パート.BASS, bIsAutoPlay );
				Bass.db演奏型スキル値 = CScoreIni.t演奏型スキルを計算して返す( CDTXMania.DTX.n可視チップ数.Bass, this.nヒット数・Auto含まない.Bass.Perfect, this.nヒット数・Auto含まない.Bass.Great, this.nヒット数・Auto含まない.Bass.Good, this.nヒット数・Auto含まない.Bass.Poor, this.nヒット数・Auto含まない.Bass.Miss, E楽器パート.BASS, bIsAutoPlay );
				Bass.nPerfect数 = CDTXMania.ConfigIni.bベースが全部オートプレイである ? this.nヒット数・Auto含む.Bass.Perfect : this.nヒット数・Auto含まない.Bass.Perfect;
				Bass.nGreat数 = CDTXMania.ConfigIni.bベースが全部オートプレイである ? this.nヒット数・Auto含む.Bass.Great : this.nヒット数・Auto含まない.Bass.Great;
				Bass.nGood数 = CDTXMania.ConfigIni.bベースが全部オートプレイである ? this.nヒット数・Auto含む.Bass.Good : this.nヒット数・Auto含まない.Bass.Good;
				Bass.nPoor数 = CDTXMania.ConfigIni.bベースが全部オートプレイである ? this.nヒット数・Auto含む.Bass.Poor : this.nヒット数・Auto含まない.Bass.Poor;
				Bass.nMiss数 = CDTXMania.ConfigIni.bベースが全部オートプレイである ? this.nヒット数・Auto含む.Bass.Miss : this.nヒット数・Auto含まない.Bass.Miss;
				Bass.nPerfect数・Auto含まない = this.nヒット数・Auto含まない.Bass.Perfect;
				Bass.nGreat数・Auto含まない = this.nヒット数・Auto含まない.Bass.Great;
				Bass.nGood数・Auto含まない = this.nヒット数・Auto含まない.Bass.Good;
				Bass.nPoor数・Auto含まない = this.nヒット数・Auto含まない.Bass.Poor;
				Bass.nMiss数・Auto含まない = this.nヒット数・Auto含まない.Bass.Miss;
				Bass.n最大コンボ数 = this.actCombo.n現在のコンボ数.Bass最高値;
				Bass.n全チップ数 = CDTXMania.DTX.n可視チップ数.Bass;
				for ( int i = 0; i < (int) Eレーン.MAX; i++ )
				{
					Bass.bAutoPlay[ i ] = bIsAutoPlay[ i ];
				}
				Bass.bTight = CDTXMania.ConfigIni.bTight;
				for ( int i = 0; i < 3; i++ )
				{
					Bass.bSudden[ i ] = CDTXMania.ConfigIni.bSudden[ i ];
					Bass.bHidden[ i ] = CDTXMania.ConfigIni.bHidden[ i ];
					Bass.eInvisible[ i ] = CDTXMania.ConfigIni.eInvisible[ i ];
					Bass.bReverse[ i ] = CDTXMania.ConfigIni.bReverse[ i ];
					Bass.eRandom[ i ] = CDTXMania.ConfigIni.eRandom[ i ];
					Bass.bLight[ i ] = CDTXMania.ConfigIni.bLight[ i ];
					Bass.bLeft[ i ] = CDTXMania.ConfigIni.bLeft[ i ];
					Bass.f譜面スクロール速度[ i ] = ( (float) ( CDTXMania.ConfigIni.n譜面スクロール速度[ i ] + 1 ) ) * 0.5f;
				}
				Bass.eDark = CDTXMania.ConfigIni.eDark;
				Bass.n演奏速度分子 = CDTXMania.ConfigIni.n演奏速度;
				Bass.n演奏速度分母 = 20;
				Bass.eHHGroup = CDTXMania.ConfigIni.eHHGroup;
				Bass.eFTGroup = CDTXMania.ConfigIni.eFTGroup;
				Bass.eCYGroup = CDTXMania.ConfigIni.eCYGroup;
				Bass.eHitSoundPriorityHH = CDTXMania.ConfigIni.eHitSoundPriorityHH;
				Bass.eHitSoundPriorityFT = CDTXMania.ConfigIni.eHitSoundPriorityFT;
				Bass.eHitSoundPriorityCY = CDTXMania.ConfigIni.eHitSoundPriorityCY;
				Bass.bGuitar有効 = CDTXMania.ConfigIni.bGuitar有効;
				Bass.bDrums有効 = CDTXMania.ConfigIni.bDrums有効;
				Bass.bSTAGEFAILED有効 = CDTXMania.ConfigIni.bSTAGEFAILED有効;
				Bass.eダメージレベル = CDTXMania.ConfigIni.eダメージレベル;
				Bass.b演奏にキーボードを使用した = this.b演奏にキーボードを使った.Bass;			// #24280 2011.1.29 yyagi
				Bass.b演奏にMIDI入力を使用した = this.b演奏にMIDI入力を使った.Bass;				//
				Bass.b演奏にジョイパッドを使用した = this.b演奏にジョイパッドを使った.Bass;		//
				Bass.b演奏にマウスを使用した = this.b演奏にマウスを使った.Bass;					//
				Bass.nPerfectになる範囲ms = CDTXMania.nPerfect範囲ms;
				Bass.nGreatになる範囲ms = CDTXMania.nGreat範囲ms;
				Bass.nGoodになる範囲ms = CDTXMania.nGood範囲ms;
				Bass.nPoorになる範囲ms = CDTXMania.nPoor範囲ms;
				Bass.strDTXManiaのバージョン = CDTXMania.VERSION;
				Bass.最終更新日時 = DateTime.Now.ToString();
				Bass.Hash = CScoreIni.t演奏セクションのMD5を求めて返す( Bass );
			}
		}
		#endregion
		#region [ t演奏結果を格納する・太鼓() ]
		public void t演奏結果を格納する・太鼓( out CScoreIni.C演奏記録 Drums )
		{
			Drums = new CScoreIni.C演奏記録();

			//if ( CDTXMania.DTX.bチップがある.Drums )
			{
				Drums.nスコア = (long) this.actScore.Get( E楽器パート.DRUMS );
				Drums.dbゲーム型スキル値 = CScoreIni.tゲーム型スキルを計算して返す( CDTXMania.DTX.LEVEL.Drums, CDTXMania.DTX.n可視チップ数.Drums, this.nヒット数・Auto含まない.Drums.Perfect, this.actCombo.n現在のコンボ数.Drums最高値, E楽器パート.DRUMS, bIsAutoPlay );
				Drums.db演奏型スキル値 = CScoreIni.t演奏型スキルを計算して返す( CDTXMania.DTX.n可視チップ数.Drums, this.nヒット数・Auto含まない.Drums.Perfect, this.nヒット数・Auto含まない.Drums.Great, this.nヒット数・Auto含まない.Drums.Good, this.nヒット数・Auto含まない.Drums.Poor, this.nヒット数・Auto含まない.Drums.Miss, E楽器パート.DRUMS, bIsAutoPlay );
				Drums.nPerfect数 = this.nヒット数・Auto含まない.Taiko.Perfect;
				Drums.nGreat数 = this.nヒット数・Auto含まない.Taiko.Great;
				Drums.nGood数 = this.nヒット数・Auto含まない.Taiko.Good;
				Drums.nPoor数 = this.nヒット数・Auto含まない.Taiko.Poor;
				Drums.nMiss数 = this.nヒット数・Auto含まない.Taiko.Miss;
				Drums.nPerfect数・Auto含まない = this.nヒット数・Auto含まない.Taiko.Perfect;
				Drums.nGreat数・Auto含まない = this.nヒット数・Auto含まない.Taiko.Great;
				Drums.nGood数・Auto含まない = this.nヒット数・Auto含まない.Taiko.Good;
				Drums.nPoor数・Auto含まない = this.nヒット数・Auto含まない.Taiko.Poor;
				Drums.nMiss数・Auto含まない = this.nヒット数・Auto含まない.Taiko.Miss;
				Drums.n最大コンボ数 = this.actCombo.n現在のコンボ数.Taiko最高値;
				Drums.n全チップ数 = CDTXMania.DTX.nノーツ数[ 3 ];
				for ( int i = 0; i < (int) Eレーン.MAX;  i++ )
				{
					Drums.bAutoPlay[ i ] = bIsAutoPlay[ i ];
				}
				Drums.bTight = CDTXMania.ConfigIni.bTight;
				for ( int i = 0; i < 3; i++ )
				{
					Drums.bSudden[ i ] = CDTXMania.ConfigIni.bSudden[ i ];
					Drums.bHidden[ i ] = CDTXMania.ConfigIni.bHidden[ i ];
					Drums.eInvisible[ i ] = CDTXMania.ConfigIni.eInvisible[ i ];
					Drums.bReverse[ i ] = CDTXMania.ConfigIni.bReverse[ i ];
					Drums.eRandom[ i ] = CDTXMania.ConfigIni.eRandom[ i ];
					Drums.bLight[ i ] = CDTXMania.ConfigIni.bLight[ i ];
					Drums.bLeft[ i ] = CDTXMania.ConfigIni.bLeft[ i ];
					Drums.f譜面スクロール速度[ i ] = ( (float) ( CDTXMania.ConfigIni.n譜面スクロール速度[ i ] + 1 ) ) * 0.5f;
				}
				Drums.eDark = CDTXMania.ConfigIni.eDark;
				Drums.n演奏速度分子 = CDTXMania.ConfigIni.n演奏速度;
				Drums.n演奏速度分母 = 20;
				Drums.eHHGroup = CDTXMania.ConfigIni.eHHGroup;
				Drums.eFTGroup = CDTXMania.ConfigIni.eFTGroup;
				Drums.eCYGroup = CDTXMania.ConfigIni.eCYGroup;
				Drums.eHitSoundPriorityHH = CDTXMania.ConfigIni.eHitSoundPriorityHH;
				Drums.eHitSoundPriorityFT = CDTXMania.ConfigIni.eHitSoundPriorityFT;
				Drums.eHitSoundPriorityCY = CDTXMania.ConfigIni.eHitSoundPriorityCY;
				Drums.bGuitar有効 = CDTXMania.ConfigIni.bGuitar有効;
				Drums.bDrums有効 = CDTXMania.ConfigIni.bDrums有効;
				Drums.bSTAGEFAILED有効 = CDTXMania.ConfigIni.bSTAGEFAILED有効;
				Drums.eダメージレベル = CDTXMania.ConfigIni.eダメージレベル;
				Drums.b演奏にキーボードを使用した = this.b演奏にキーボードを使った.Drums;
				Drums.b演奏にMIDI入力を使用した = this.b演奏にMIDI入力を使った.Drums;
				Drums.b演奏にジョイパッドを使用した = this.b演奏にジョイパッドを使った.Drums;
				Drums.b演奏にマウスを使用した = this.b演奏にマウスを使った.Drums;
				Drums.nPerfectになる範囲ms = CDTXMania.nPerfect範囲ms;
				Drums.nGreatになる範囲ms = CDTXMania.nGreat範囲ms;
				Drums.nGoodになる範囲ms = CDTXMania.nGood範囲ms;
				Drums.nPoorになる範囲ms = CDTXMania.nPoor範囲ms;
				Drums.strDTXManiaのバージョン = CDTXMania.VERSION;
				Drums.最終更新日時 = DateTime.Now.ToString();
				Drums.Hash = CScoreIni.t演奏セクションのMD5を求めて返す( Drums );
                Drums.fゲージ = (float)this.actGauge.db現在のゲージ値.Drums;
			}
		}
		#endregion

		// CStage 実装

		public override void On活性化()
		{
			listChip = CDTXMania.DTX.listChip;
			listWAV = CDTXMania.DTX.listWAV;

			this.eフェードアウト完了時の戻り値 = E演奏画面の戻り値.継続;
			this.n現在のトップChip = ( listChip.Count > 0 ) ? 0 : -1;
			this.L最後に再生したHHの実WAV番号 = new List<int>( 16 );
			this.n最後に再生したHHのチャンネル番号 = 0;
			this.n最後に再生した実WAV番号.Guitar = -1;
			this.n最後に再生した実WAV番号.Bass = -1;
			for ( int i = 0; i < 50; i++ )
			{
				this.n最後に再生したBGMの実WAV番号[ i ] = -1;
			}
			this.r次にくるギターChip = null;
			this.r次にくるベースChip = null;
			for ( int j = 0; j < 10; j++ )
			{
				this.r現在の空うちドラムChip[ j ] = null;
			}
			this.r現在の空うちギターChip = null;
			this.r現在の空うちベースChip = null;
			cInvisibleChip = new CInvisibleChip( CDTXMania.ConfigIni.nDisplayTimesMs, CDTXMania.ConfigIni.nFadeoutTimeMs );
			this.演奏判定ライン座標 = new C演奏判定ライン座標共通();
			for ( int k = 0; k < 4; k++ )
			{
				//for ( int n = 0; n < 5; n++ )
				//{
					this.nヒット数・Auto含まない[ k ] = new CHITCOUNTOFRANK();
					this.nヒット数・Auto含む[ k ] = new CHITCOUNTOFRANK();
				//}
				this.queWailing[ k ] = new Queue<CDTX.CChip>();
				this.r現在の歓声Chip[ k ] = null;
				cInvisibleChip.eInvisibleMode[ k ] = CDTXMania.ConfigIni.eInvisible[ k ];
				if ( CDTXMania.DTXVmode.Enabled )
				{
					CDTXMania.ConfigIni.n譜面スクロール速度[ k ] = CDTXMania.ConfigIni.nViewerScrollSpeed[ k ];
				}

				this.nInputAdjustTimeMs[ k ] = CDTXMania.ConfigIni.nInputAdjustTimeMs[ k ];			// #23580 2011.1.3 yyagi
																									//        2011.1.7 ikanick 修正
				//this.nJudgeLinePosY_delta[ k ] = CDTXMania.ConfigIni.nJudgeLinePosOffset[ k ];		// #31602 2013.6.23 yyagi

				this.演奏判定ライン座標.n判定位置[ k ] = CDTXMania.ConfigIni.e判定位置[ k ];
				this.演奏判定ライン座標.nJudgeLinePosY_delta[ k ] = CDTXMania.ConfigIni.nJudgeLinePosOffset[ k ];
				this.bReverse[ k ]             = CDTXMania.ConfigIni.bReverse[ k ];					//

			}
			actCombo.演奏判定ライン座標 = 演奏判定ライン座標;
			for ( int i = 0; i < 3; i++ )
			{
				this.b演奏にキーボードを使った[ i ] = false;
				this.b演奏にジョイパッドを使った[ i ] = false;
				this.b演奏にMIDI入力を使った[ i ] = false;
				this.b演奏にマウスを使った[ i ] = false;
			}
			this.bAUTOでないチップが１つでもバーを通過した = false;
			cInvisibleChip.Reset();
			base.On活性化();
			this.tステータスパネルの選択();
			this.tパネル文字列の設定();
			//this.演奏判定ライン座標();
            this.bIsGOGOTIME = false;
            this.bUseBranch = false;
            this.n現在のコース = 0;
            this.n次回のコース = 0;
            this.b連打中 = false;
            this.n現在の連打数 = 0;
            this.n分岐した回数 = 0;
            this.bLEVELHOLD = false;

            this.combo50 = CDTXMania.Sound管理.tサウンドを生成する( CSkin.Path( @"Sounds\50combo.ogg" ) );
            this.combo100 = CDTXMania.Sound管理.tサウンドを生成する( CSkin.Path( @"Sounds\100combo.ogg" ) );
            this.combo200 = CDTXMania.Sound管理.tサウンドを生成する( CSkin.Path( @"Sounds\200combo.ogg" ) );
            this.combo300 = CDTXMania.Sound管理.tサウンドを生成する( CSkin.Path( @"Sounds\300combo.ogg" ) );
            this.combo400 = CDTXMania.Sound管理.tサウンドを生成する( CSkin.Path( @"Sounds\400combo.ogg" ) );


            #region[ branch ]
            this.nBranch_Perfect = 0;
            this.nBranch_Good = 0;
            this.nBranch_Miss = 0;
            this.nBranch_roll = 0;
            #endregion

            this.bIsAutoPlay = CDTXMania.ConfigIni.bAutoPlay;									// #24239 2011.1.23 yyagi

			
			//this.bIsAutoPlay.Guitar = CDTXMania.ConfigIni.bギターが全部オートプレイである;
			//this.bIsAutoPlay.Bass = CDTXMania.ConfigIni.bベースが全部オートプレイである;
//			this.nRisky = CDTXMania.ConfigIni.nRisky;											// #23559 2011.7.28 yyagi
			actGauge.Init( CDTXMania.ConfigIni.nRisky );									// #23559 2011.7.28 yyagi
			this.nPolyphonicSounds = CDTXMania.ConfigIni.nPoliphonicSounds;
			e判定表示優先度 = CDTXMania.ConfigIni.e判定表示優先度;

			CDTXMania.Skin.tRemoveMixerAll();	// 効果音のストリームをミキサーから解除しておく

			queueMixerSound = new Queue<stmixer>( 64 );
			bIsDirectSound = ( CDTXMania.Sound管理.GetCurrentSoundDeviceType() == "DirectSound" );
			bUseOSTimer = CDTXMania.ConfigIni.bUseOSTimer;
			this.bPAUSE = false;
			if ( CDTXMania.DTXVmode.Enabled )
			{
				db再生速度 = CDTXMania.DTX.dbDTXVPlaySpeed;
				CDTXMania.ConfigIni.n演奏速度 = (int) (CDTXMania.DTX.dbDTXVPlaySpeed * 20 + 0.5 );
			}
			else
			{
				db再生速度 = ( (double) CDTXMania.ConfigIni.n演奏速度 ) / 20.0;
			}
			bValidScore = ( CDTXMania.DTXVmode.Enabled ) ? false : true;

			#region [ 演奏開始前にmixer登録しておくべきサウンド(開幕してすぐに鳴らすことになるチップ音)を登録しておく ]
			foreach ( CDTX.CChip pChip in listChip )
			{
//				Debug.WriteLine( "CH=" + pChip.nチャンネル番号.ToString( "x2" ) + ", 整数値=" + pChip.n整数値 +  ", time=" + pChip.n発声時刻ms );
				if ( pChip.n発声時刻ms <= 0 )
				{
					if ( pChip.nチャンネル番号 == 0xDA )
					{
						pChip.bHit = true;
//						Trace.TraceInformation( "first [DA] BAR=" + pChip.n発声位置 / 384 + " ch=" + pChip.nチャンネル番号.ToString( "x2" ) + ", wav=" + pChip.n整数値 + ", time=" + pChip.n発声時刻ms );
						if ( listWAV.ContainsKey( pChip.n整数値・内部番号 ) )
						{
							CDTX.CWAV wc = listWAV[ pChip.n整数値・内部番号 ];
							for ( int i = 0; i < nPolyphonicSounds; i++ )
							{
								if ( wc.rSound[ i ] != null )
								{
									CDTXMania.Sound管理.AddMixer( wc.rSound[ i ], db再生速度, pChip.b演奏終了後も再生が続くチップである );
									//AddMixer( wc.rSound[ i ] );		// 最初はqueueを介さず直接ミキサー登録する
								}
							}
						}
					}
				}
				else
				{
					break;
				}
			}
			#endregion

			if ( CDTXMania.ConfigIni.bIsSwappedGuitarBass )	// #24063 2011.1.24 yyagi Gt/Bsの譜面情報入れ替え
			{
				CDTXMania.DTX.SwapGuitarBassInfos();
			}
			this.sw = new Stopwatch();
			this.sw2 = new Stopwatch();
//			this.gclatencymode = GCSettings.LatencyMode;
//			GCSettings.LatencyMode = GCLatencyMode.Batch;	// 演奏画面中はGCを抑止する
		}
		public override void On非活性化()
		{
			this.L最後に再生したHHの実WAV番号.Clear();	// #23921 2011.1.4 yyagi
			this.L最後に再生したHHの実WAV番号 = null;	//
			for ( int i = 0; i < 3; i++ )
			{
				this.queWailing[ i ].Clear();
				this.queWailing[ i ] = null;
			}
			this.ctWailingチップ模様アニメ = null;
			this.ctチップ模様アニメ.Drums = null;
			this.ctチップ模様アニメ.Guitar = null;
			this.ctチップ模様アニメ.Bass = null;
			this.ctチップ模様アニメ.Taiko = null;
			//listWAV.Clear();
			listWAV = null;
			listChip = null;
			queueMixerSound.Clear();
			queueMixerSound = null;
			cInvisibleChip.Dispose();
			cInvisibleChip = null;
//			GCSettings.LatencyMode = this.gclatencymode;

            #region[ コンボ音声解放 ]
            //今のところnullだと解放処理メソッドに飛べないので、ここで分岐処理をするしかない。
            if( this.combo50 != null )
                this.combo50.t解放する();
            if( this.combo100 != null )
                this.combo100.t解放する();
            if( this.combo200 != null )
                this.combo200.t解放する();
            if( this.combo300 != null )
                this.combo300.t解放する();
            if( this.combo400 != null )
                this.combo400.t解放する();
            #endregion

            base.On非活性化();
		}
		public override void OnManagedリソースの作成()
		{
			if ( !base.b活性化してない )
			{
				this.t背景テクスチャの生成();


				base.OnManagedリソースの作成();
			}
		}
		public override void OnManagedリソースの解放()
		{
			if ( !base.b活性化してない )
			{
				CDTXMania.tテクスチャの解放( ref this.tx背景 );
				base.OnManagedリソースの解放();
			}
		}

		// その他

		#region [ protected ]
		//-----------------
		protected class CHITCOUNTOFRANK
		{
			// Fields
			public int Good;
			public int Great;
			public int Miss;
			public int Perfect;
			public int Poor;

			// Properties
			public int this[ int index ]
			{
				get
				{
					switch ( index )
					{
						case 0:
							return this.Perfect;

						case 1:
							return this.Great;

						case 2:
							return this.Good;

						case 3:
							return this.Poor;

						case 4:
							return this.Miss;
					}
					throw new IndexOutOfRangeException();
				}
				set
				{
					switch ( index )
					{
						case 0:
							this.Perfect = value;
							return;

						case 1:
							this.Great = value;
							return;

						case 2:
							this.Good = value;
							return;

						case 3:
							this.Poor = value;
							return;

						case 4:
							this.Miss = value;
							return;
					}
					throw new IndexOutOfRangeException();
				}
			}
		}

		[StructLayout( LayoutKind.Sequential )]
		protected struct STKARAUCHI
		{
			public CDTX.CChip HH;
			public CDTX.CChip SD;
			public CDTX.CChip BD;
			public CDTX.CChip HT;
			public CDTX.CChip LT;
			public CDTX.CChip FT;
			public CDTX.CChip CY;
			public CDTX.CChip HHO;
			public CDTX.CChip RD;
			public CDTX.CChip LC;
            public CDTX.CChip LP;
            public CDTX.CChip LBD;
			public CDTX.CChip this[ int index ]
			{
				get
				{
					switch ( index )
					{
						case 0:
							return this.HH;

						case 1:
							return this.SD;

						case 2:
							return this.BD;

						case 3:
							return this.HT;

						case 4:
							return this.LT;

						case 5:
							return this.FT;

						case 6:
							return this.CY;

						case 7:
							return this.HHO;

						case 8:
							return this.RD;

						case 9:
							return this.LC;

                        case 10:
                            return this.LP;

                        case 11:
                            return this.LBD;
					}
					throw new IndexOutOfRangeException();
				}
				set
				{
					switch ( index )
					{
						case 0:
							this.HH = value;
							return;

						case 1:
							this.SD = value;
							return;

						case 2:
							this.BD = value;
							return;

						case 3:
							this.HT = value;
							return;

						case 4:
							this.LT = value;
							return;

						case 5:
							this.FT = value;
							return;

						case 6:
							this.CY = value;
							return;

						case 7:
							this.HHO = value;
							return;

						case 8:
							this.RD = value;
							return;

						case 9:
							this.LC = value;
							return;

                        case 10:
                            this.LP = value;
                            return;
					}
					throw new IndexOutOfRangeException();
				}
			}
		}

		protected struct stmixer
		{
			internal bool bIsAdd;
			internal CSound csound;
			internal bool b演奏終了後も再生が続くチップである;
		};

		protected CAct演奏AVI actAVI;
        public CAct演奏Drums飛んでいく音符 actChipFireTaiko;
		protected CAct演奏チップファイアGB actChipFireGB;
		protected CAct演奏Combo共通 actCombo;
		protected CAct演奏Danger共通 actDANGER;
		//protected CActFIFOBlack actFI;
        protected CActFIFOStart actFI;
		protected CActFIFOBlack actFO;
		protected CActFIFOResult actFOClear;
		public    CAct演奏ゲージ共通 actGauge;

		protected CAct演奏判定文字列共通 actJudgeString;
		public CAct演奏DrumsレーンフラッシュD actLaneFlushD;
		protected CAct演奏レーンフラッシュGB共通 actLaneFlushGB;
		protected CAct演奏パネル文字列 actPanel;
		protected CAct演奏演奏情報 actPlayInfo;
		protected CAct演奏RGB共通 actRGB;
		protected CAct演奏スコア共通 actScore;
		protected CAct演奏ステージ失敗 actStageFailed;
		protected CAct演奏ステータスパネル共通 actStatusPanels;
		protected CAct演奏WailingBonus共通 actWailingBonus;
		protected CAct演奏スクロール速度 act譜面スクロール速度;
		public    C演奏判定ライン座標共通 演奏判定ライン座標;
        protected CAct演奏Drums連打 actRoll;
        protected CAct演奏Drums風船 actBalloon;
        public CAct演奏Drumsキャラクター actChara;
		protected bool bPAUSE;
		protected STDGBVALUE<bool> b演奏にMIDI入力を使った;
		protected STDGBVALUE<bool> b演奏にキーボードを使った;
		protected STDGBVALUE<bool> b演奏にジョイパッドを使った;
		protected STDGBVALUE<bool> b演奏にマウスを使った;
		protected CCounter ctWailingチップ模様アニメ;
		protected STDGBVALUE<CCounter> ctチップ模様アニメ;

		protected E演奏画面の戻り値 eフェードアウト完了時の戻り値;
		protected readonly int[,] nBGAスコープチャンネルマップ = new int[ , ] { { 0xc4, 0xc7, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xe0 }, { 4, 7, 0x55, 0x56, 0x57, 0x58, 0x59, 0x60 } };
        protected readonly int[] nチャンネル0Atoパッド08 = new int[] { 1, 2, 3, 4, 5, 7, 6, 1, 8, 0, 9, 9 };
        protected readonly int[] nチャンネル0Atoレーン07 = new int[] { 1, 2, 3, 4, 5, 7, 6, 1, 9, 0, 8, 8 };
                                                                    //                         RD LC  LP  RD
		protected readonly int[] nパッド0Atoチャンネル0A = new int[] { 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x16, 0x18, 0x19, 0x1a, 0x1b, 0x1c };
        protected readonly int[] nパッド0Atoパッド08 = new int[] { 1, 2, 3, 4, 5, 6, 7, 1, 8, 0, 9, 9 };// パッド画像のヒット処理用
                                                              //   HH SD BD HT LT FT CY HHO RD LC LP LBD
        protected readonly int[] nパッド0Atoレーン07 = new int[] { 1, 2, 3, 4, 5, 6, 7, 1, 9, 0, 8, 8 };
		protected STDGBVALUE<CHITCOUNTOFRANK> nヒット数・Auto含まない;
		protected STDGBVALUE<CHITCOUNTOFRANK> nヒット数・Auto含む;
		protected int n現在のトップChip = -1;
		protected int[] n最後に再生したBGMの実WAV番号 = new int[ 50 ];
		protected int n最後に再生したHHのチャンネル番号;
		protected List<int> L最後に再生したHHの実WAV番号;		// #23921 2011.1.4 yyagi: change "int" to "List<int>", for recording multiple wav No.
		protected STLANEVALUE<int> n最後に再生した実WAV番号;	// #26388 2011.11.8 yyagi: change "n最後に再生した実WAV番号.GUITAR" and "n最後に再生した実WAV番号.BASS"
																//							into "n最後に再生した実WAV番号";
//		protected int n最後に再生した実WAV番号.GUITAR;
//		protected int n最後に再生した実WAV番号.BASS;

		protected volatile Queue<stmixer> queueMixerSound;		// #24820 2013.1.21 yyagi まずは単純にAdd/Removeを1個のキューでまとめて管理するやり方で設計する
		protected DateTime dtLastQueueOperation;				//
		protected bool bIsDirectSound;							//
		protected double db再生速度;
		protected bool bValidScore;
//		protected bool bDTXVmode;
//		protected STDGBVALUE<int> nJudgeLinePosY_delta;			// #31602 2013.6.23 yyagi 表示遅延対策として、判定ラインの表示位置をずらす機能を追加する
		protected STDGBVALUE<bool> bReverse;

		protected STDGBVALUE<Queue<CDTX.CChip>> queWailing;
		protected STDGBVALUE<CDTX.CChip> r現在の歓声Chip;
		protected CDTX.CChip r現在の空うちギターChip;
		protected STKARAUCHI r現在の空うちドラムChip;
		protected CDTX.CChip r現在の空うちベースChip;
		protected CDTX.CChip r次にくるギターChip;
		protected CDTX.CChip r次にくるベースChip;
		protected CTexture txWailing枠;
		protected CTexture txチップ;
		protected CTexture txヒットバー;

		protected CTexture tx背景;

		protected STDGBVALUE<int> nInputAdjustTimeMs;		// #23580 2011.1.3 yyagi
		protected STAUTOPLAY bIsAutoPlay;		// #24239 2011.1.23 yyagi
//		protected int nRisky_InitialVar, nRiskyTime;		// #23559 2011.7.28 yyagi → CAct演奏ゲージ共通クラスに隠蔽
		protected int nPolyphonicSounds;
		protected List<CDTX.CChip> listChip;
		protected Dictionary<int, CDTX.CWAV> listWAV;
		protected CInvisibleChip cInvisibleChip;
		protected bool bUseOSTimer;
		protected E判定表示優先度 e判定表示優先度;

        public bool bIsGOGOTIME;
        public bool bUseBranch;
        public int n現在のコース; //0:普通譜面 1:玄人譜面 2:達人譜面
        public int n次回のコース;
        public bool b連打中 = false; //奥の手
        protected int n風船残り = 0;
        protected int n現在の連打数 = 0;
        protected bool b譜面分岐中 = false;
        protected int n分岐した回数 = 0;

        private bool b強制的に分岐させた = false;
        private bool bLEVELHOLD = false;
        protected int nBranch_roll = 0;
        protected int nBranch_Perfect = 0;
        protected int nBranch_Good = 0;
        protected int nBranch_Miss = 0;
        protected int nListCount;

        private int n連打終了時間ms;

        private long n制御タイマ;
        protected int n現在の音符の顔番号;

        protected int nWaitButton;

        protected E連打State eRollState;
        protected CDTX.CChip chip現在処理中の連打チップ;

        //Type-Bの場合
        //0:1～9
        //1:10～19
        //2:20～29
        //3:
        //4:
        //5:
        //6:
        //7:
        //8:
        //9:
        //10:100以降
        //
        //Type-Cの場合
        //0:1～9
        //1:10～29
        //2:30～49
        //3:50～99
        //4:100以降
        //5～9:使用しない
        //
        //Type-Aの場合は使いません。
        protected int[] nScore = new int[11];

        protected int nHand = 0;

        protected CSound soundRed;
        protected CSound soundBlue;
        protected CSound soundBalloon;

        private CSound combo50;
        private CSound combo100;
        private CSound combo200;
        private CSound combo300;
        private CSound combo400;


		protected Stopwatch sw;		// 2011.6.13 最適化検討用のストップウォッチ
		protected Stopwatch sw2;
//		protected GCLatencyMode gclatencymode;

		public void AddMixer( CSound cs, bool _b演奏終了後も再生が続くチップである )
		{
			stmixer stm = new stmixer()
			{
				bIsAdd = true,
				csound = cs,
				b演奏終了後も再生が続くチップである = _b演奏終了後も再生が続くチップである
			};
			queueMixerSound.Enqueue( stm );
//		Debug.WriteLine( "★Queue: add " + Path.GetFileName( stm.csound.strファイル名 ));
		}
		public void RemoveMixer( CSound cs )
		{
			stmixer stm = new stmixer()
			{
				bIsAdd = false,
				csound = cs,
				b演奏終了後も再生が続くチップである = false
			};
			queueMixerSound.Enqueue( stm );
//		Debug.WriteLine( "★Queue: remove " + Path.GetFileName( stm.csound.strファイル名 ));
		}
		public void ManageMixerQueue()
		{
			// もしサウンドの登録/削除が必要なら、実行する
			if ( queueMixerSound.Count > 0 )
			{
				//Debug.WriteLine( "☆queueLength=" + queueMixerSound.Count );
				DateTime dtnow = DateTime.Now;
				TimeSpan ts = dtnow - dtLastQueueOperation;
				if ( ts.Milliseconds > 7 )
				{
					for ( int i = 0; i < 2 && queueMixerSound.Count > 0; i++ )
					{
						dtLastQueueOperation = dtnow;
						stmixer stm = queueMixerSound.Dequeue();
						if ( stm.bIsAdd )
						{
							CDTXMania.Sound管理.AddMixer( stm.csound, db再生速度, stm.b演奏終了後も再生が続くチップである );
						}
						else
						{
							CDTXMania.Sound管理.RemoveMixer( stm.csound );
						}
					}
				}
			}
		}

		protected E判定 e指定時刻からChipのJUDGEを返す( long nTime, CDTX.CChip pChip, int nInputAdjustTime )
		{
			if ( pChip != null )
			{
				pChip.nLag = (int) ( nTime + nInputAdjustTime - pChip.n発声時刻ms );		// #23580 2011.1.3 yyagi: add "nInputAdjustTime" to add input timing adjust feature
				int nDeltaTime = Math.Abs( pChip.nLag );
				//Debug.WriteLine("nAbsTime=" + (nTime - pChip.n発声時刻ms) + ", nDeltaTime=" + (nTime + nInputAdjustTime - pChip.n発声時刻ms));

                if( pChip.nチャンネル番号 == 0x97 || pChip.nチャンネル番号 == 0x98 || pChip.nチャンネル番号 == 0x99 )
                {
				    if ( CSound管理.rc演奏用タイマ.n現在時刻ms > pChip.n発声時刻ms && CSound管理.rc演奏用タイマ.n現在時刻ms < pChip.nノーツ終了時刻ms )
				    {
					    return E判定.Perfect;
				    }
                }
				if ( nDeltaTime <= 25 )
				{
					return E判定.Perfect;
				}
				if ( nDeltaTime <= 75 )
				{
					return E判定.Good;
				}
				if ( nDeltaTime <= 108 )
				{
					return E判定.Poor;
				}
			}
			return E判定.Miss;
		}

		protected CDTX.CChip r空うちChip( E楽器パート part, Eパッド pad )
		{
			return null;
		}
		protected CDTX.CChip r指定時刻に一番近いChip・ヒット未済問わず不可視考慮( long nTime, int nChannel, int nInputAdjustTime )
		{
			sw2.Start();
//Trace.TraceInformation( "NTime={0}, nChannel={1:x2}", nTime, nChannel );
			nTime += nInputAdjustTime;						// #24239 2011.1.23 yyagi InputAdjust

			int nIndex_InitialPositionSearchingToPast;
			if ( this.n現在のトップChip == -1 )				// 演奏データとして1個もチップがない場合は
			{
				sw2.Stop();
				return null;
			}
			int count = listChip.Count;
			int nIndex_NearestChip_Future = nIndex_InitialPositionSearchingToPast = this.n現在のトップChip;
			if ( this.n現在のトップChip >= count )			// その時点で演奏すべきチップが既に全部無くなっていたら
			{
				nIndex_NearestChip_Future = nIndex_InitialPositionSearchingToPast = count - 1;
			}
			//int nIndex_NearestChip_Future;	// = nIndex_InitialPositionSearchingToFuture;
			//while ( nIndex_NearestChip_Future < count )		// 未来方向への検索
			for ( ; nIndex_NearestChip_Future < count; nIndex_NearestChip_Future++)
			{
				CDTX.CChip chip = listChip[ nIndex_NearestChip_Future ];
                if (((0x11 <= nChannel) && (nChannel <= 0x1C)))
                {
                    if ((chip.nチャンネル番号 == nChannel) || (chip.nチャンネル番号 == (nChannel + 0x20)))
                    {
                        if (chip.n発声時刻ms > nTime)
                        {
                            break;
                        }
                        nIndex_InitialPositionSearchingToPast = nIndex_NearestChip_Future;
                    }
                    continue;	// ほんの僅かながら高速化
                }
                else if (((nChannel == 0x2f) && (chip.e楽器パート == E楽器パート.GUITAR)) || (((0x20 <= nChannel) && (nChannel <= 0x28)) && (chip.nチャンネル番号 == nChannel)))
                {
                    if (chip.n発声時刻ms > nTime)
                    {
                        break;
                    }
                    nIndex_InitialPositionSearchingToPast = nIndex_NearestChip_Future;
                }
                else if (((nChannel == 0xaf) && (chip.e楽器パート == E楽器パート.BASS)) || (((0xa0 <= nChannel) && (nChannel <= 0xa8)) && (chip.nチャンネル番号 == nChannel)))
                {
                    if (chip.n発声時刻ms > nTime)
                    {
                        break;
                    }
                    nIndex_InitialPositionSearchingToPast = nIndex_NearestChip_Future;
                }

				if ( ( ( 0x93 <= nChannel ) && ( nChannel <= 0x96 ) ) )
				{
					if ( ( ( chip.nチャンネル番号 == nChannel ) || ( chip.nチャンネル番号 == ( nChannel ) ) ) )
					{
						if ( chip.n発声時刻ms > nTime )
						{
							break;
						}
                        if( chip.nコース != this.n次回のコース )
                        {
                            break;
                        }
						nIndex_InitialPositionSearchingToPast = nIndex_NearestChip_Future;
					}
					continue;	// ほんの僅かながら高速化
				}

				// nIndex_NearestChip_Future++;
			}
			int nIndex_NearestChip_Past = nIndex_InitialPositionSearchingToPast;
			//while ( nIndex_NearestChip_Past >= 0 )			// 過去方向への検索
			for ( ; nIndex_NearestChip_Past >= 0; nIndex_NearestChip_Past-- )
			{
				CDTX.CChip chip = listChip[ nIndex_NearestChip_Past ];
                if ((0x11 <= nChannel) && (nChannel <= 0x1C))
                {
                    if ((chip.nチャンネル番号 == nChannel) || (chip.nチャンネル番号 == (nChannel + 0x20)))
                    {
                        break;
                    }
                }
                else if (((nChannel == 0x2f) && (chip.e楽器パート == E楽器パート.GUITAR)) || (((0x20 <= nChannel) && (nChannel <= 0x28)) && (chip.nチャンネル番号 == nChannel)))
                {
                    if ((0x20 <= chip.nチャンネル番号) && (chip.nチャンネル番号 <= 0x28))
                    {
                        break;
                    }
                }
                else if ((((nChannel == 0xaf) && (chip.e楽器パート == E楽器パート.BASS)) || (((0xa0 <= nChannel) && (nChannel <= 0xa8)) && (chip.nチャンネル番号 == nChannel)))
                    && ((0xa0 <= chip.nチャンネル番号) && (chip.nチャンネル番号 <= 0xa8)))
                {
                    break;
                }

				if ( ( 0x93 <= nChannel ) && ( nChannel <= 0x96 ) )
				{
					if ( ( ( chip.nチャンネル番号 == nChannel ) )  )
					{
						break;
					}
				}
				// nIndex_NearestChip_Past--;
			}

			if ( nIndex_NearestChip_Future >= count )
			{
				if ( nIndex_NearestChip_Past < 0 )	// 検索対象が過去未来どちらにも見つからなかった場合
				{
					return null;
				}
				else 								// 検索対象が未来方向には見つからなかった(しかし過去方向には見つかった)場合
				{
					sw2.Stop();
					return listChip[ nIndex_NearestChip_Past ];
				}
			}
			else if ( nIndex_NearestChip_Past < 0 )	// 検索対象が過去方向には見つからなかった(しかし未来方向には見つかった)場合
			{
				sw2.Stop();
				return listChip[ nIndex_NearestChip_Future ];
			}
													// 検索対象が過去未来の双方に見つかったなら、より近い方を採用する
			CDTX.CChip nearestChip_Future = listChip[ nIndex_NearestChip_Future ];
			CDTX.CChip nearestChip_Past   = listChip[ nIndex_NearestChip_Past ];
			int nDiffTime_Future = Math.Abs( (int) ( nTime - nearestChip_Future.n発声時刻ms ) );
			int nDiffTime_Past   = Math.Abs( (int) ( nTime - nearestChip_Past.n発声時刻ms ) );
			if ( nDiffTime_Future >= nDiffTime_Past )
			{
				sw2.Stop();
				return nearestChip_Past;
			}
			sw2.Stop();
			return nearestChip_Future;
		}
		protected void tサウンド再生( CDTX.CChip rChip, long n再生開始システム時刻ms, E楽器パート part )
		{
			this.tサウンド再生( rChip, n再生開始システム時刻ms, part, CDTXMania.ConfigIni.n手動再生音量, false, false );
		}
		protected void tサウンド再生( CDTX.CChip rChip, long n再生開始システム時刻ms, E楽器パート part, int n音量 )
		{
			this.tサウンド再生( rChip, n再生開始システム時刻ms, part, n音量, false, false );
		}
		protected void tサウンド再生( CDTX.CChip rChip, long n再生開始システム時刻ms, E楽器パート part, int n音量, bool bモニタ )
		{
			this.tサウンド再生( rChip, n再生開始システム時刻ms, part, n音量, bモニタ, false );
		}
		protected void tサウンド再生( CDTX.CChip pChip, long n再生開始システム時刻ms, E楽器パート part, int n音量, bool bモニタ, bool b音程をずらして再生 )
		{
			// mute sound (auto)
			// 4A: HH
			// 4B: CY
			// 4C: RD
			// 4D: LC
			// 2A: Gt
			// AA: Bs
			//

			if ( pChip != null )
			{
				bool overwrite = false;
				switch ( part )
				{
					case E楽器パート.DRUMS:
					#region [ DRUMS ]
						{
							int index = pChip.nチャンネル番号;
							if ( ( 0x11 <= index ) && ( index <= 0x1C ) )
							{
								index -= 0x11;
							}
							else if ( ( 0x31 <= index ) && ( index <= 0x3c ) )
							{
								index -= 0x31;
							}
							// mute sound (auto)
							// 4A: 84: HH (HO/HC)
							// 4B: 85: CY
							// 4C: 86: RD
							// 4D: 87: LC
							// 2A: 88: Gt
							// AA: 89: Bs
							else if ( 0x84 == index )	// 仮に今だけ追加 HHは消音処理があるので overwriteフラグ系の処理は改めて不要
							{
								index = 0;
							}
							else if ( ( 0x85 <= index ) && ( index <= 0x87 ) )	// 仮に今だけ追加
							{
								//            CY    RD    LC
								int[] ch = { 0x16, 0x19, 0x1A };
								pChip.nチャンネル番号 = ch[ pChip.nチャンネル番号 - 0x85 ];
								index = pChip.nチャンネル番号 - 0x11;
								overwrite = true;
							}
							else
							{
								return;
							}
							int nLane = this.nチャンネル0Atoレーン07[ index ];
							//if ( ( nLane == 1 ) &&	// 今回演奏するのがHC or HO
							//	( ( index == 0 || ( index == 7 && this.n最後に再生したHHのチャンネル番号 != 0x18 && this.n最後に再生したHHのチャンネル番号 != 0x38 ) ||
							//	( index == 8 || ( index == 10 && this.n最後に再生したHHのチャンネル番号 != 0x18 && this.n最後に再生したHHのチャンネル番号 != 0x38 ) ) ) )
							//	// HCを演奏するか、またはHO演奏＆以前HO演奏でない＆以前不可視HO演奏でない
							//)
                            if (((((nLane == 1) && (index == 0)) && ((this.n最後に再生したHHのチャンネル番号 != 0x18) && (this.n最後に再生したHHのチャンネル番号 != 0x38))) || ((((nLane == 8)) && ((index == 10) && (this.n最後に再生したHHのチャンネル番号 != 0x18))) && (this.n最後に再生したHHのチャンネル番号 != 0x38))))
							// #24772 2011.4.4 yyagi
							// == HH mute condition == 
							//			current HH		So, the mute logics are:
							//				HC	HO		1) All played HC/HOs should be queueing
							// last HH	HC  Yes	Yes		2) If you aren't in "both current/last HH are HO", queued HH should be muted.
							//			HO	Yes	No
							{
								// #23921 2011.1.4 yyagi: 2種類以上のオープンハイハットが発音済みだと、最後のHHOしか消せない問題に対応。
#if TEST_NOTEOFFMODE	// 2011.1.1 yyagi test
								if (CDTXMania.DTX.b演奏で直前の音を消音する.HH)
								{
#endif
								for ( int i = 0; i < this.L最後に再生したHHの実WAV番号.Count; i++ )		// #23921 2011.1.4 yyagi
								{
									// CDTXMania.DTX.tWavの再生停止(this.L最後に再生したHHの実WAV番号);
									CDTXMania.DTX.tWavの再生停止( this.L最後に再生したHHの実WAV番号[ i ] );	// #23921 yyagi ストック分全て消音する
								}
								this.L最後に再生したHHの実WAV番号.Clear();
#if TEST_NOTEOFFMODE	// 2011.1.1 yyagi test
								}
#endif
								//this.n最後に再生したHHの実WAV番号 = pChip.n整数値・内部番号;
								this.n最後に再生したHHのチャンネル番号 = pChip.nチャンネル番号;
							}
#if TEST_NOTEOFFMODE	// 2011.1.4 yyagi test
							if (CDTXMania.DTX.b演奏で直前の音を消音する.HH)
							{
#endif

							if ( index == 0 || index == 7 || index == 0x20 || index == 0x27 )			// #23921 HOまたは不可視HO演奏時はそのチップ番号をストックしておく
							{																			// #24772 HC, 不可視HCも消音キューに追加
								if ( this.L最後に再生したHHの実WAV番号.Count >= 16 )	// #23921 ただしストック数が16以上になるようなら、頭の1個を削って常に16未満に抑える
								{													// (ストックが増えてList<>のrealloc()が発生するのを予防する)
									this.L最後に再生したHHの実WAV番号.RemoveAt( 0 );
								}
								if ( !this.L最後に再生したHHの実WAV番号.Contains( pChip.n整数値・内部番号 ) )	// チップ音がまだストックされてなければ
								{
									this.L最後に再生したHHの実WAV番号.Add( pChip.n整数値・内部番号 );			// ストックする
								}
							}
#if TEST_NOTEOFFMODE	// 2011.1.4 yyagi test
							}
#endif
                            //CDTXMania.stage演奏ドラム画面.actDrumSet.Start( nLane );
							if ( overwrite )
							{
								CDTXMania.DTX.tWavの再生停止( this.n最後に再生した実WAV番号[index] );
							}
							CDTXMania.DTX.tチップの再生( pChip, n再生開始システム時刻ms, nLane, n音量, bモニタ );
							this.n最後に再生した実WAV番号[ nLane ] = pChip.n整数値・内部番号;		// nLaneでなくindexにすると、LC(1A-11=09)とギター(enumで09)がかぶってLC音が消されるので注意
							return;
						}
					#endregion
					case E楽器パート.GUITAR:
					#region [ GUITAR ]
#if TEST_NOTEOFFMODE	// 2011.1.1 yyagi test
						if (CDTXMania.DTX.b演奏で直前の音を消音する.Guitar) {
#endif
						CDTXMania.DTX.tWavの再生停止( this.n最後に再生した実WAV番号.Guitar );
#if TEST_NOTEOFFMODE
						}
#endif
						CDTXMania.DTX.tチップの再生( pChip, n再生開始システム時刻ms, (int) Eレーン.Guitar, n音量, bモニタ, b音程をずらして再生 );
						this.n最後に再生した実WAV番号.Guitar = pChip.n整数値・内部番号;
						return;
					#endregion
					case E楽器パート.BASS:
					#region [ BASS ]
#if TEST_NOTEOFFMODE
						if (CDTXMania.DTX.b演奏で直前の音を消音する.Bass) {
#endif
						CDTXMania.DTX.tWavの再生停止( this.n最後に再生した実WAV番号.Bass );
#if TEST_NOTEOFFMODE
						}
#endif
						CDTXMania.DTX.tチップの再生( pChip, n再生開始システム時刻ms, (int) Eレーン.Bass, n音量, bモニタ, b音程をずらして再生 );
						this.n最後に再生した実WAV番号.Bass = pChip.n整数値・内部番号;
						return;
					#endregion
                    case E楽器パート.TAIKO:
						{
							int index = pChip.nチャンネル番号;
                            if( index == 0x93 || index == 0x95 )
                                this.soundRed.t再生を開始する();
                                //CDTXMania.Skin.soundRed.t再生する();
                            else if( index == 0x94 || index == 0x96 )
                                this.soundBlue.t再生を開始する();
                                //CDTXMania.Skin.soundBlue.t再生する();

                            if( this.nHand == 0 )
                                this.nHand++;
                            else
                                this.nHand = 0;

							return;
						}

					default:
						break;
				}
			}
		}
		protected void tステータスパネルの選択()
		{
			if ( CDTXMania.bコンパクトモード )
			{
				this.actStatusPanels.tラベル名からステータスパネルを決定する( null );
			}
			else if ( CDTXMania.stage選曲.r確定された曲 != null )
			{
				this.actStatusPanels.tラベル名からステータスパネルを決定する( CDTXMania.stage選曲.r確定された曲.ar難易度ラベル[ CDTXMania.stage選曲.n確定された曲の難易度 ] );
			}
		}

        protected bool tRollProcess( CDTX.CChip pChip, double dbProcess_time, int num, int sort, int Input )
        {
            if( dbProcess_time >= pChip.n発声時刻ms && dbProcess_time < pChip.nノーツ終了時刻ms )
            {
                this.b連打中 = true;
                if (pChip.nチャンネル番号 == 0x97)
                    this.eRollState = E連打State.roll;
                else
                    this.eRollState = E連打State.rollB;
                pChip.nRollCount++;
                this.n現在の連打数++;
                this.nBranch_roll++;

                if( this.bIsGOGOTIME )
                {
                    if( CDTXMania.ConfigIni.nScoreMode == 0 || CDTXMania.ConfigIni.nScoreMode == 1 )
                    {
                        if( pChip.nチャンネル番号 == 0x97 )
                            this.actScore.Add( E楽器パート.TAIKO, this.bIsAutoPlay, (long)( 300 * 1.2f ) );
                        else
                            this.actScore.Add( E楽器パート.TAIKO, this.bIsAutoPlay, (long)( 360 * 1.2f ) );
                    }
                    else
                    {
                        if( pChip.nチャンネル番号 == 0x97 )
                            this.actScore.Add( E楽器パート.TAIKO, this.bIsAutoPlay, (long)( 100 * 1.2f ) );
                        else
                            this.actScore.Add( E楽器パート.TAIKO, this.bIsAutoPlay, (long)( 200 * 1.2f ) );
                    }
                }
                else
                {
                    if( CDTXMania.ConfigIni.nScoreMode == 0 || CDTXMania.ConfigIni.nScoreMode == 1 )
                    {
                        if( pChip.nチャンネル番号 == 0x97 )
                            this.actScore.Add( E楽器パート.TAIKO, this.bIsAutoPlay, 100L );
                        else
                            this.actScore.Add( E楽器パート.TAIKO, this.bIsAutoPlay, 200L );
                    }
                    else
                    {
                        if( pChip.nチャンネル番号 == 0x97 )
                            this.actScore.Add( E楽器パート.TAIKO, this.bIsAutoPlay, 100L );
                        else
                            this.actScore.Add( E楽器パート.TAIKO, this.bIsAutoPlay, 200L );
                    }
                }


                //赤か青かの分岐
                if( sort == 0 )
                {
                    this.soundRed.t再生を開始する();
                    if( pChip.nチャンネル番号 == 0x97 )
                    {
                        //CDTXMania.Skin.soundRed.t再生する();
                        CDTXMania.stage演奏ドラム画面.actChipFireTaiko.Start(1);
                    }
                    else
                    {
                        //CDTXMania.Skin.soundRed.t再生する();
                        CDTXMania.stage演奏ドラム画面.actChipFireTaiko.Start(3);
                    }
                }
                else
                {
                    this.soundBlue.t再生を開始する();
                    if( pChip.nチャンネル番号 == 0x97 )
                    {
                        //CDTXMania.Skin.soundBlue.t再生する();
                        CDTXMania.stage演奏ドラム画面.actChipFireTaiko.Start(2);
                    }
                    else
                    {
                        //CDTXMania.Skin.soundBlue.t再生する();
                        CDTXMania.stage演奏ドラム画面.actChipFireTaiko.Start(4);
                    }
                }
            }
            else
            {
                this.b連打中 = false;
                return true;
            }

            return false;
        }

        protected bool tBalloonProcess( CDTX.CChip pChip, double dbProcess_time, int num )
        {
            //if( dbProcess_time >= pChip.n発声時刻ms && dbProcess_time < pChip.nノーツ終了時刻ms )
            if ((int)CSound管理.rc演奏用タイマ.n現在時刻ms >= pChip.n発声時刻ms && (int)CSound管理.rc演奏用タイマ.n現在時刻ms <= pChip.nノーツ終了時刻ms)
            {
                if( pChip.nRollCount == 0 )
                {
                    this.n風船残り = pChip.nBalloon;
                }

                this.b連打中 = true;
                this.eRollState = E連打State.balloon;
                pChip.nRollCount++;
                this.n風船残り--;

                //分岐のための処理。実装してない。

                //赤か青かの分岐
                if( pChip.nBalloon == pChip.nRollCount )
                {
                    //ﾊﾟｧｰﾝ
                    CDTXMania.Skin.soundBalloon.t再生する();
                    CDTXMania.stage演奏ドラム画面.actChipFireTaiko.Start( 3 ); //ここで飛ばす。飛ばされるのは大音符のみ。
                    CDTXMania.stage演奏ドラム画面.actChipFireTaiko.t虹();
                    CDTXMania.stage演奏ドラム画面.actChipFireD.Start( 0 );
                    this.actScore.Add( E楽器パート.TAIKO, this.bIsAutoPlay, 5000L );
                    pChip.bHit = true;
                    chip現在処理中の連打チップ.bHit = true;
                    //this.b連打中 = false;
                    //this.actChara.b風船連打中 = false;
                    pChip.b可視 = false;
                    this.eRollState = E連打State.none;
                }
                else
                {
                    this.actScore.Add( E楽器パート.TAIKO, this.bIsAutoPlay, 300L );
                    //CDTXMania.Skin.soundRed.t再生する();
                    this.soundRed.t再生を開始する();
                }
            }
            else
            {
                if( chip現在処理中の連打チップ != null )
                    chip現在処理中の連打チップ.bHit = true;
                this.b連打中 = false;
                this.actChara.b風船連打中 = false;
                return false;
            }

            return true;
        }

		protected E判定 tチップのヒット処理( long nHitTime, CDTX.CChip pChip )
		{
			return tチップのヒット処理( nHitTime, pChip, true );
		}
		protected abstract E判定 tチップのヒット処理( long nHitTime, CDTX.CChip pChip, bool bCorrectLane );
		protected E判定 tチップのヒット処理( long nHitTime, CDTX.CChip pChip, E楽器パート screenmode )		// E楽器パート screenmode
		{
			return tチップのヒット処理( nHitTime, pChip, screenmode, true, 1 );
		}
		protected unsafe E判定 tチップのヒット処理( long nHitTime, CDTX.CChip pChip, E楽器パート screenmode, bool bCorrectLane, int nNowInput )
		{
            //unsafeコードにつき、デバッグ中の変更厳禁!

            //if( ( pChip.nコース != this.n現在のコース ) && !CDTXMania.DTX.bチップがある.Branch )
                //return E判定.Auto;

            if( !pChip.b可視 )
                return E判定.Auto;

            if( pChip.nチャンネル番号 != 0x97 && pChip.nチャンネル番号 != 0x98 && pChip.nチャンネル番号 != 0x99 && pChip.nチャンネル番号 != 0x9A )
            {
			    pChip.bHit = true;
            }

#region [メソッド化する前の記述(注釈化)]
//            bool bPChipIsAutoPlay = false;
//            bool bGtBsR = ( ( pChip.nチャンネル番号 & 4 ) > 0 );
//            bool bGtBsG = ( ( pChip.nチャンネル番号 & 2 ) > 0 );
//            bool bGtBsB = ( ( pChip.nチャンネル番号 & 1 ) > 0 );
//            bool bGtBsW = ( ( pChip.nチャンネル番号 & 0x0F ) == 0x08 );
//            bool bGtBsO = ( ( pChip.nチャンネル番号 & 0x0F ) == 0x00 );
//            if ( pChip.e楽器パート == E楽器パート.DRUMS )
//            {
//                if ( bIsAutoPlay[ this.nチャンネル0Atoレーン07[ pChip.nチャンネル番号 - 0x11 ] ] )
//                {
//                    bPChipIsAutoPlay = true;
//                }
//            }
//            else if ( pChip.e楽器パート == E楽器パート.GUITAR )
//            {
////Trace.TraceInformation( "chip:{0}{1}{2} ", bGtBsR, bGtBsG, bGtBsB );
////Trace.TraceInformation( "auto:{0}{1}{2} ", bIsAutoPlay[ (int) Eレーン.GtR ], bIsAutoPlay[ (int) Eレーン.GtG ], bIsAutoPlay[ (int) Eレーン.GtB ]);
//                bPChipIsAutoPlay = true;
//                if ( !bIsAutoPlay[ (int) Eレーン.GtPick ] ) bPChipIsAutoPlay = false;
//                else
//                {
//                    if ( bGtBsR  && !bIsAutoPlay[ (int) Eレーン.GtR ] ) bPChipIsAutoPlay = false;
//                    else if ( bGtBsG && !bIsAutoPlay[ (int) Eレーン.GtG ] ) bPChipIsAutoPlay = false;
//                    else if ( bGtBsB && !bIsAutoPlay[ (int) Eレーン.GtB ] ) bPChipIsAutoPlay = false;
//                    else if ( bGtBsW && !bIsAutoPlay[ (int) Eレーン.GtW ] ) bPChipIsAutoPlay = false;
//                    else if ( bGtBsO &&
//                        ( !bIsAutoPlay[ (int) Eレーン.GtR] || !bIsAutoPlay[ (int) Eレーン.GtG] || !bIsAutoPlay[ (int) Eレーン.GtB] ) )
//                        bPChipIsAutoPlay = false;
//                }
//            }
//            else if ( pChip.e楽器パート == E楽器パート.BASS )
//            {
//                bPChipIsAutoPlay = true;
//                if ( !bIsAutoPlay[ (int) Eレーン.BsPick ] ) bPChipIsAutoPlay = false;
//                else
//                {
//                    if ( bGtBsR && !bIsAutoPlay[ (int) Eレーン.BsR ] ) bPChipIsAutoPlay = false;
//                    else if ( bGtBsG && bIsAutoPlay[ (int) Eレーン.BsG ] ) bPChipIsAutoPlay = false;
//                    else if ( bGtBsB && bIsAutoPlay[ (int) Eレーン.BsB ] ) bPChipIsAutoPlay = false;
//                    else if ( bGtBsW && bIsAutoPlay[ (int) Eレーン.BsW ] ) bPChipIsAutoPlay = false;
//                    else if ( bGtBsO &&
//                        ( !bIsAutoPlay[ (int) Eレーン.BsR ] || !bIsAutoPlay[ (int) Eレーン.BsG ] || !bIsAutoPlay[ (int) Eレーン.BsB ] ) )
//                        bPChipIsAutoPlay = false;
//                }
//            }
//            else
//            {
//                this.bAUTOでないチップが１つでもバーを通過した = true;
//            }
////Trace.TraceInformation( "ch={0:x2}, flag={1}",  pChip.nチャンネル番号, bPChipIsAutoPlay.ToString() );
#endregion
			if ( pChip.e楽器パート == E楽器パート.UNKNOWN )
			{
				this.bAUTOでないチップが１つでもバーを通過した = true;
			}
			else
			{
				//cInvisibleChip.StartSemiInvisible( pChip.e楽器パート );
			}
			bool bPChipIsAutoPlay = bCheckAutoPlay( pChip );

			pChip.bIsAutoPlayed = bPChipIsAutoPlay;			// 2011.6.10 yyagi
			E判定 eJudgeResult = E判定.Auto;
			switch ( pChip.e楽器パート )
			{
				case E楽器パート.DRUMS:
					{
                        //int nInputAdjustTime = bPChipIsAutoPlay ? 0 : this.nInputAdjustTimeMs.Drums;
                        //eJudgeResult = (bCorrectLane)? this.e指定時刻からChipのJUDGEを返す( nHitTime, pChip, nInputAdjustTime ) : E判定.Miss;
						//.actJudgeString.Start( this.nチャンネル0Atoレーン07[ pChip.nチャンネル番号 - 0x11 ], bPChipIsAutoPlay ? E判定.Auto : eJudgeResult, pChip.nLag );
					}
					break;

				case E楽器パート.GUITAR:
					{
                        //int nInputAdjustTime = bPChipIsAutoPlay ? 0 : this.nInputAdjustTimeMs.Guitar;
                        //eJudgeResult = (bCorrectLane)? this.e指定時刻からChipのJUDGEを返す( nHitTime, pChip, nInputAdjustTime ) : E判定.Miss;
						//this.actJudgeString.Start( 10, bPChipIsAutoPlay ? E判定.Auto : eJudgeResult, pChip.nLag );
						break;
					}

				case E楽器パート.BASS:
					{
                        //int nInputAdjustTime = bPChipIsAutoPlay ? 0 : this.nInputAdjustTimeMs.Bass;
                        //eJudgeResult = (bCorrectLane)? this.e指定時刻からChipのJUDGEを返す( nHitTime, pChip, nInputAdjustTime ) : E判定.Miss;
						//this.actJudgeString.Start( 11, bPChipIsAutoPlay ? E判定.Auto : eJudgeResult, pChip.nLag );
					}
					break;
				case E楽器パート.TAIKO:
					{
                        //連打が短すぎると発声されない
                        int nInputAdjustTime = bPChipIsAutoPlay ? 0 : this.nInputAdjustTimeMs.Taiko;
						eJudgeResult = (bCorrectLane)? this.e指定時刻からChipのJUDGEを返す( nHitTime, pChip, nInputAdjustTime ) : E判定.Miss;
                        if( pChip.nチャンネル番号 == 0x97 || pChip.nチャンネル番号 == 0x98 )
                        {
                            this.b連打中 = true;
                            if( pChip != null )
                            {
                                //if( pChip.n発声時刻ms > CSound管理.rc演奏用タイマ.n現在時刻ms && pChip.nノーツ終了時刻ms < CSound管理.rc演奏用タイマ.n現在時刻ms )
                                //{
                                //    this.eRollState = E連打State.none;
                                //    this.b連打中 = false;
                                //    break;
                                //}
                            }

                            //if (pChip.n発声時刻ms > CSound管理.rc演奏用タイマ.n現在時刻ms || pChip.nノーツ終了時刻ms < CSound管理.rc演奏用タイマ.n現在時刻ms)

                            //CDTXMania.stage演奏ドラム画面.actChipFireD.Start( pChip.nチャンネル番号, eJudgeResult );

                            if( CDTXMania.ConfigIni.b太鼓パートAutoPlay && CDTXMania.ConfigIni.bAuto先生の連打 )
                            {
                                if( CSound管理.rc演奏用タイマ.n現在時刻ms > ( pChip.n発声時刻ms + ( 1000.0 / 15.0 ) * pChip.nRollCount ) )
                                {
                                    if( this.nHand == 0 )
                                        this.nHand++;
                                    else
                                        this.nHand = 0;
                                        
                                    CDTXMania.stage演奏ドラム画面.actLaneFlushD.Start(2, 0);
                                    CDTXMania.stage演奏ドラム画面.actChipFireTaiko.Start( pChip.nチャンネル番号 == 0x97 ? 1 : 3 );
                                    CDTXMania.stage演奏ドラム画面.actMtaiko.tMtaikoEvent( pChip.nチャンネル番号, this.nHand );
                                

                                    if( this.tRollProcess( pChip, CSound管理.rc演奏用タイマ.n現在時刻ms, 1, 0, 0 ) )
                                    {
                                    }
                                }
                            }
                            else if( CDTXMania.ConfigIni.b太鼓パートAutoPlay && !CDTXMania.ConfigIni.bAuto先生の連打 )
                            {

                            }
                            else
                            {
                                this.eRollState = E連打State.roll;
                                this.tRollProcess( pChip, CSound管理.rc演奏用タイマ.n現在時刻ms, 1, nNowInput, 0 );
                            }


                            break;
                        }
                        else if( pChip.nチャンネル番号 == 0x99 )
                        {
                            this.b連打中 = true;
                            this.actChara.b風船連打中 = true;

                            //if( pChip.n発声時刻ms > CSound管理.rc演奏用タイマ.n現在時刻ms && pChip.nノーツ終了時刻ms < CSound管理.rc演奏用タイマ.n現在時刻ms )
                            //{
                            //    this.b連打中 = false;
                            //    this.n現在の連打数 = 0;
                            //    break;
                            //}


                            //CDTXMania.stage演奏ドラム画面.actChipFireD.Start( pChip.nチャンネル番号, eJudgeResult );

                            if( CDTXMania.ConfigIni.b太鼓パートAutoPlay )
                            {
                                if( CSound管理.rc演奏用タイマ.n現在時刻ms > ( pChip.n発声時刻ms + ( ( pChip.nノーツ終了時刻ms - pChip.n発声時刻ms ) / pChip.nBalloon ) * pChip.nRollCount ) )
                                {
                                    if( this.nHand == 0 )
                                        this.nHand++;
                                    else
                                        this.nHand = 0;

                                    CDTXMania.stage演奏ドラム画面.actLaneFlushD.Start(2, 0);
                                    CDTXMania.stage演奏ドラム画面.actMtaiko.tMtaikoEvent( pChip.nチャンネル番号, this.nHand );
                                

                                    if( this.tBalloonProcess( pChip, CSound管理.rc演奏用タイマ.n現在時刻ms, 0 ) )
                                    {
                                    }
                                }
                            }
                            else
                            {
                                this.tBalloonProcess( pChip, CSound管理.rc演奏用タイマ.n現在時刻ms, 0 );
                            }


                            break;
                        }
                        else if( pChip.nチャンネル番号 == 0x9A )
                        {
                            if( pChip.nノーツ終了時刻ms <= CSound管理.rc演奏用タイマ.n現在時刻ms )
                            {
                                this.b連打中 = false;
                                //this.actChara.b風船連打中 = false;
                                pChip.bHit = true;
                                break;
                            }
                        }

                        //this.n現在の連打数 = 0;//やや強引

                        if( eJudgeResult != E判定.Auto && eJudgeResult != E判定.Miss  )
                        {
						    this.actJudgeString.Start( 0, CDTXMania.ConfigIni.b太鼓パートAutoPlay ? E判定.Auto : eJudgeResult, pChip.nLag, pChip );
                            CDTXMania.stage演奏ドラム画面.actLaneTaiko.Start( pChip.nチャンネル番号, eJudgeResult, true );
                            CDTXMania.stage演奏ドラム画面.actChipFireD.Start( pChip.nチャンネル番号, eJudgeResult );

                            if( nNowInput == 2 || nNowInput == 3 )
                            {
                                if( pChip.nチャンネル番号 == 0x95 )
                                    CDTXMania.stage演奏ドラム画面.actChipFireD.Start( 0 );
                                else if( pChip.nチャンネル番号 == 0x96 )
                                   CDTXMania.stage演奏ドラム画面.actChipFireD.Start( 1 );
                            }
                        }
                        else if( eJudgeResult != E判定.Poor && eJudgeResult != E判定.Bad )
                        {
						    this.actJudgeString.Start( 0, CDTXMania.ConfigIni.b太鼓パートAutoPlay ? E判定.Auto : eJudgeResult, pChip.nLag, pChip );
                        }

					}
					break;
			}
			if ( ( pChip.e楽器パート != E楽器パート.UNKNOWN ) )
			{
                if( pChip.nチャンネル番号 != 0x97 && pChip.nチャンネル番号 != 0x98 && pChip.nチャンネル番号 != 0x99 && pChip.nチャンネル番号 != 0x9A )
                {
                    if( pChip.nコース == this.n現在のコース )
                    {
				        actGauge.Damage( screenmode, pChip.e楽器パート, eJudgeResult );
                    }
                }

			}
			if ( eJudgeResult == E判定.Poor || eJudgeResult == E判定.Miss || eJudgeResult == E判定.Bad )
			{
				cInvisibleChip.ShowChipTemporally( pChip.e楽器パート );
			}
			switch ( pChip.e楽器パート )
			{
				case E楽器パート.DRUMS:
				case E楽器パート.GUITAR:
				case E楽器パート.BASS:
					break;
                case E楽器パート.TAIKO:
                    if( !CDTXMania.ConfigIni.b太鼓パートAutoPlay )
                    {
                        if( pChip.nチャンネル番号 == 0x97 || pChip.nチャンネル番号 == 0x98 || pChip.nチャンネル番号 == 0x99 || pChip.nチャンネル番号 == 0x9A )
                            break;

					    switch ( eJudgeResult )
					    {
                            case E判定.Perfect:
                                {
                                    this.nBranch_Perfect++;
                                    this.nヒット数・Auto含まない.Drums.Perfect++;
                                    this.actCombo.n現在のコンボ数.Drums++;
                                    this.actCombo.ctコンボ加算.n現在の値 = 0;
                                }
                                break;
                            case E判定.Great:
                            case E判定.Good:
                                {
                                    this.nBranch_Good++;
                                    this.nヒット数・Auto含まない.Drums.Great++;
                                    this.actCombo.n現在のコンボ数.Drums++;
                                    //this.actCombo.ctコンボ加算 = new CCounter( 0, 8, 10, CDTXMania.Timer );
                                    //this.actCombo.ctコンボ加算.t進行();
                                    this.actCombo.ctコンボ加算.n現在の値 = 0;
                                }
                                break;
                            case E判定.Poor:
		    				case E判定.Miss:
			    			case E判定.Bad:
                                {
                                    this.nBranch_Miss++;
					    		    this.nヒット数・Auto含まない.Drums.Miss++;
                                    this.actCombo.n現在のコンボ数.Drums = 0;
                                }
			    				break;
				    		default:
					    		this.nヒット数・Auto含む.Drums[ (int) eJudgeResult ]++;
		    					break;
			    		}
                    }
					else if ( CDTXMania.ConfigIni.b太鼓パートAutoPlay )
					{
						switch ( eJudgeResult )
						{
                            case E判定.Perfect:
                            case E判定.Great:
                            case E判定.Good:
                                {
                                    if( pChip.nチャンネル番号 != 0x97 && pChip.nチャンネル番号 != 0x98 && pChip.nチャンネル番号 != 0x99 && pChip.nチャンネル番号 != 0x9A )
                                    {
                                        this.nBranch_Perfect++;
                                        this.nヒット数・Auto含む.Drums.Perfect++;
                                        this.actCombo.n現在のコンボ数.Drums++;
                                        //this.actCombo.ctコンボ加算.t進行();
                                        this.actCombo.ctコンボ加算.n現在の値 = 0;
                                    }
                                }
                                break;

							default:
                                {
                                    if( pChip.nチャンネル番号 != 0x97 && pChip.nチャンネル番号 != 0x98 && pChip.nチャンネル番号 != 0x99 && pChip.nチャンネル番号 != 0x9A )
                                    {
                                        this.nBranch_Miss++;
								        this.actCombo.n現在のコンボ数.Drums = 0;
                                    }
                                }
								break;
						}
					}

                    #region[ コンボ音声 ]
                    try
                    {
                        switch( this.actCombo.n現在のコンボ数.Drums )
                        {
                            case 50:
                                if( this.combo50 != null )
                                    this.combo50.t再生を開始する();
                                //CDTXMania.Skin.sound50combo.t再生する();
                                break;
                            case 100:
                                if( this.combo100 != null )
                                    this.combo100.t再生を開始する();
                                //CDTXMania.Skin.sound100combo.t再生する();
                                break;
                            case 200:
                                if( this.combo200 != null )
                                    this.combo200.t再生を開始する();
                                //CDTXMania.Skin.sound200combo.t再生する();
                                break;
                            case 300:
                                if( this.combo300 != null )
                                    this.combo300.t再生を開始する();
                                //CDTXMania.Skin.sound300combo.t再生する();
                                break;
                            case 400:
                                if( this.combo400 != null )
                                    this.combo400.t再生を開始する();
                                //CDTXMania.Skin.sound400combo.t再生する();
                                break;
                            case 500:
                                CDTXMania.Skin.sound500combo.t再生する();
                                break;
                            case 600:
                                CDTXMania.Skin.sound600combo.t再生する();
                                break;
                            case 700:
                                CDTXMania.Skin.sound700combo.t再生する();
                                break;
                            case 800:
                                CDTXMania.Skin.sound800combo.t再生する();
                                break;
                            case 900:
                                CDTXMania.Skin.sound900combo.t再生する();
                                break;
                            case 1000:
                                CDTXMania.Skin.sound1000combo.t再生する();
                                break;
                        }
                    }
                    catch
                    {
                        //特に何も返さない。
                    }
                    #endregion

					break;


				default:
					break;
			}
			if ( ( ( pChip.e楽器パート != E楽器パート.UNKNOWN ) ) && ( eJudgeResult != E判定.Miss ) && ( eJudgeResult != E判定.Bad ) && ( eJudgeResult != E判定.Poor ) && ( pChip.nチャンネル番号 <= 0x96 ) )
			{
				int nCombos = this.actCombo.n現在のコンボ数.Drums;
                long nInit = CDTXMania.DTX.nScoreInit[ 0, CDTXMania.stage選曲.n確定された曲の難易度 ];
                long nDiff = CDTXMania.DTX.nScoreDiff[ CDTXMania.stage選曲.n確定された曲の難易度 ];
                long nAddScore = 0;

                if( CDTXMania.ConfigIni.nScoreMode == 2 )
                {
                    if (nCombos < 10)
                    {
                        nAddScore = this.nScore[ 0 ];
                    }
                    else if( nCombos >= 10 && nCombos <= 29 )
                    {
                        nAddScore = this.nScore[ 1 ];
                    }
                    else if( nCombos >= 30 && nCombos <= 49 )
                    {
                        nAddScore = this.nScore[ 2 ];
                    }
                    else if( nCombos >= 50 && nCombos <= 99 )
                    {
                        nAddScore = this.nScore[ 3 ];
                    }
                    else if (nCombos >= 100)
                    {
                        nAddScore = this.nScore[ 4 ];
                    }

                    if (eJudgeResult == E判定.Great || eJudgeResult == E判定.Good)
                    {
                        nAddScore = nAddScore / 2;
                    }

                    if( this.bIsGOGOTIME )
                    {
                        nAddScore = (int)(nAddScore * 1.2f);
                    }

                    //100コンボ毎のボーナス
                    if (nCombos % 100 == 0 && nCombos > 99)
                    {
                        this.actScore.BonusAdd();
                    }

                    nAddScore = (int)( nAddScore / 10 );
                    nAddScore = (int)( nAddScore * 10 );

                    //大音符のボーナス
                    if (pChip.nチャンネル番号 == 0x95 || pChip.nチャンネル番号 == 0x96)
                    {
                        nAddScore = nAddScore * 2;
                    }

                    this.actScore.Add( E楽器パート.TAIKO, bIsAutoPlay, nAddScore );
                    //this.actScore.Add( E楽器パート.DRUMS, bIsAutoPlay, nAddScore );
                }
                else if( CDTXMania.ConfigIni.nScoreMode == 1 )
                {
                    if (nCombos < 10)
                    {
                        nAddScore = this.nScore[ 0 ];
                    }
                    else if( nCombos >= 10 && nCombos <= 19 )
                    {
                        nAddScore = this.nScore[ 1 ];
                    }
                    else if( nCombos >= 20 && nCombos <= 29 )
                    {
                        nAddScore = this.nScore[ 2 ];
                    }
                    else if( nCombos >= 30 && nCombos <= 39 )
                    {
                        nAddScore = this.nScore[ 3 ];
                    }
                    else if( nCombos >= 40 && nCombos <= 49 )
                    {
                        nAddScore = this.nScore[ 4 ];
                    }
                    else if( nCombos >= 50 && nCombos <= 59 )
                    {
                        nAddScore = this.nScore[ 5 ];
                    }
                    else if( nCombos >= 60 && nCombos <= 69 )
                    {
                        nAddScore = this.nScore[ 6 ];
                    }
                    else if( nCombos >= 70 && nCombos <= 79 )
                    {
                        nAddScore = this.nScore[ 7 ];
                    }
                    else if( nCombos >= 80 && nCombos <= 89 )
                    {
                        nAddScore = this.nScore[ 8 ];
                    }
                    else if( nCombos >= 90 && nCombos <= 99 )
                    {
                        nAddScore = this.nScore[ 9 ];
                    }
                    else if( nCombos >= 100 )
                    {
                        nAddScore = this.nScore[ 10 ];
                    }

                    if (eJudgeResult == E判定.Great || eJudgeResult == E判定.Good)
                    {
                        nAddScore = nAddScore / 2;
                    }


                    if( this.bIsGOGOTIME )
                        nAddScore = (int)(nAddScore * 1.2f);

                    nAddScore = (int)( nAddScore / 10.0 );
                    nAddScore = (int)( nAddScore * 10 );

                    //大音符のボーナス
                    if (pChip.nチャンネル番号 == 0x95 || pChip.nチャンネル番号 == 0x96)
                    {
                        nAddScore = nAddScore * 2;
                    }

                    this.actScore.Add( E楽器パート.TAIKO, bIsAutoPlay, nAddScore );
                }
                else
                {
                    if( eJudgeResult == E判定.Perfect )
                    {
                        if( nCombos < 200 )
                        {
                            nAddScore = 1000;
                        }
                        else
                        {
                            nAddScore = 2000;
                        }
                    }
                    else if (eJudgeResult == E判定.Great || eJudgeResult == E判定.Good)
                    {
                        if( nCombos < 200 )
                        {
                            nAddScore = 500;
                        }
                        else
                        {
                            nAddScore = 1000;
                        }
                    }

                    if (this.bIsGOGOTIME)
                        nAddScore = (int)(nAddScore * 1.2f);

                    //大音符のボーナス
                    if (pChip.nチャンネル番号 == 0x95 || pChip.nチャンネル番号 == 0x96)
                    {
                        nAddScore = nAddScore * 2;
                    }


                    this.actScore.Add( E楽器パート.TAIKO, bIsAutoPlay, nAddScore );
                    //this.actScore.Add( E楽器パート.DRUMS, bIsAutoPlay, nAddScore );              
                }

                //CDTXMania.act文字コンソール.tPrint( 50, 220, C文字コンソール.Eフォント種別.赤, nAddScore.ToString() );
			}
			return eJudgeResult;
		}

        protected void t分岐状況チェック( int n現在時刻 )
        {

            //if()
            {


                for (int i = this.n現在のトップChip; i < CDTXMania.DTX.listChip.Count; i++ )
                {
                    if( (CDTXMania.DTX.listChip[ i ].nチャンネル番号 <= 0x93 && CDTXMania.DTX.listChip[ i ].nチャンネル番号 >= 0x9A) != false )
                    {
                        if (CDTXMania.DTX.listChip[i].nコース == this.n現在のコース)
                        {
                            CDTXMania.DTX.listChip[i].b可視 = true;
                        }
                        else
                        {
                            CDTXMania.DTX.listChip[i].b可視 = false;
                        }
                    }

                }
            }
        }


		protected abstract void tチップのヒット処理・BadならびにTight時のMiss( E楽器パート part );
		protected abstract void tチップのヒット処理・BadならびにTight時のMiss( E楽器パート part, int nLane );
		protected void tチップのヒット処理・BadならびにTight時のMiss( E楽器パート part, E楽器パート screenmode )
		{
			this.tチップのヒット処理・BadならびにTight時のMiss( part, 0, screenmode );
		}
		protected void tチップのヒット処理・BadならびにTight時のMiss( E楽器パート part, int nLane, E楽器パート screenmode )
		{
            //まだpChipでのチャンネル判別に対応していない。

			this.bAUTOでないチップが１つでもバーを通過した = true;
			cInvisibleChip.StartSemiInvisible( part );
			cInvisibleChip.ShowChipTemporally( part );
			//this.t判定にあわせてゲージを増減する( screenmode, part, E判定.Miss );
			actGauge.Damage( screenmode, part, E判定.Miss );
			switch ( part )
			{
				case E楽器パート.DRUMS:
					if ( ( nLane >= 0 ) && ( nLane <= 10 ) )
					{
						//this.actJudgeString.Start( nLane, bIsAutoPlay[ nLane ] ? E判定.Auto : E判定.Miss, 999 );
					}
					this.actCombo.n現在のコンボ数.Drums = 0;
					return;

				case E楽器パート.GUITAR:
					//this.actJudgeString.Start( 13, E判定.Bad, 999 );
					this.actCombo.n現在のコンボ数.Guitar = 0;
					return;

				case E楽器パート.BASS:
					//this.actJudgeString.Start( 14, E判定.Bad, 999 );
					this.actCombo.n現在のコンボ数.Bass = 0;
					break;

				case E楽器パート.TAIKO:
					//this.actJudgeString.Start( 0, E判定.Bad, 999 );
					this.actCombo.n現在のコンボ数.Taiko = 0;
					break;

				default:
					return;
			}
		}

		protected CDTX.CChip r指定時刻に一番近い未ヒットChipを過去方向優先で検索する( long nTime, int nInputAdjustTime )
		{
			sw2.Start();
			nTime += nInputAdjustTime;

			int nIndex_InitialPositionSearchingToPast;
			int nTimeDiff;
			int count = listChip.Count;
			if ( count <= 0 )			// 演奏データとして1個もチップがない場合は
			{
				sw2.Stop();
				return null;
			}

			int nIndex_NearestChip_Future = nIndex_InitialPositionSearchingToPast = this.n現在のトップChip;
			if ( this.n現在のトップChip >= count )		// その時点で演奏すべきチップが既に全部無くなっていたら
			{
				nIndex_NearestChip_Future  = nIndex_InitialPositionSearchingToPast = count - 1;
			}
			// int nIndex_NearestChip_Future = nIndex_InitialPositionSearchingToFuture;
//			while ( nIndex_NearestChip_Future < count )	// 未来方向への検索
			for ( ; nIndex_NearestChip_Future < count; nIndex_NearestChip_Future++ )
			{
				CDTX.CChip chip = listChip[ nIndex_NearestChip_Future ];
				if ( !chip.bHit && chip.b可視 )
				{
					if ( ( ( 0x93 <= chip.nチャンネル番号 ) && ( chip.nチャンネル番号 <= 0x99 ) ) )
					{
						if ( chip.n発声時刻ms > nTime )
						{
							break;
						}
                        nIndex_InitialPositionSearchingToPast = nIndex_NearestChip_Future;
					}

				}
//				nIndex_NearestChip_Future++;
			}
			int nIndex_NearestChip_Past = nIndex_InitialPositionSearchingToPast;
//			while ( nIndex_NearestChip_Past >= 0 )		// 過去方向への検索
			for ( ; nIndex_NearestChip_Past >= 0; nIndex_NearestChip_Past-- )
			{
				CDTX.CChip chip = listChip[ nIndex_NearestChip_Past ];
				if ( (!chip.bHit && chip.b可視 ) && ( (  0x93 <= chip.nチャンネル番号 ) && ( chip.nチャンネル番号 <= 0x99 ) ) )
					{
						break;
					}
//				nIndex_NearestChip_Past--;
			}
			if ( ( nIndex_NearestChip_Future >= count ) && ( nIndex_NearestChip_Past < 0 ) )	// 検索対象が過去未来どちらにも見つからなかった場合
			{
				sw2.Stop();
				return null;
			}
			CDTX.CChip nearestChip;	// = null;	// 以下のifブロックのいずれかで必ずnearestChipには非nullが代入されるので、null初期化を削除
			if ( nIndex_NearestChip_Future >= count )											// 検索対象が未来方向には見つからなかった(しかし過去方向には見つかった)場合
			{
				nearestChip = listChip[ nIndex_NearestChip_Past ];
//				nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
			}
			else if ( nIndex_NearestChip_Past < 0 )												// 検索対象が過去方向には見つからなかった(しかし未来方向には見つかった)場合
			{
				nearestChip = listChip[ nIndex_NearestChip_Future ];
//				nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
			}
			else
			{
				int nTimeDiff_Future = Math.Abs( (int) ( nTime - listChip[ nIndex_NearestChip_Future ].n発声時刻ms ) );
				int nTimeDiff_Past   = Math.Abs( (int) ( nTime - listChip[ nIndex_NearestChip_Past   ].n発声時刻ms ) );
				if ( nTimeDiff_Future < nTimeDiff_Past )
				{
                    if( !listChip[ nIndex_NearestChip_Past ].bHit && ( listChip[ nIndex_NearestChip_Past ].n発声時刻ms + ( 108 ) >= nTime ) )
                    {
					    nearestChip = listChip[ nIndex_NearestChip_Past ];
                    }
                    else
					    nearestChip = listChip[ nIndex_NearestChip_Future ];
//					nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
				}
				else
				{
					nearestChip = listChip[ nIndex_NearestChip_Past ];
//					nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
				}
			}
			nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
            int n検索範囲時間ms = 0;
			if ( ( n検索範囲時間ms > 0 ) && ( nTimeDiff > n検索範囲時間ms ) )					// チップは見つかったが、検索範囲時間外だった場合
			{
				sw2.Stop();
				return null;
			}
			sw2.Stop();
			return nearestChip;
		}

		protected CDTX.CChip r指定時刻に一番近い未ヒットChip( long nTime, int nInputAdjustTime )
		{
			sw2.Start();
//Trace.TraceInformation( "nTime={0}, nChannel={1:x2}, 現在のTop={2}", nTime, nChannel,CDTXMania.DTX.listChip[ this.n現在のトップChip ].n発声時刻ms );
			nTime += nInputAdjustTime;

			int nIndex_InitialPositionSearchingToPast;
			int nTimeDiff;
			if ( this.n現在のトップChip == -1 )			// 演奏データとして1個もチップがない場合は
			{
				sw2.Stop();
				return null;
			}
			int count = listChip.Count;
			int nIndex_NearestChip_Future = nIndex_InitialPositionSearchingToPast = this.n現在のトップChip;
			if ( this.n現在のトップChip >= count )		// その時点で演奏すべきチップが既に全部無くなっていたら
			{
				nIndex_NearestChip_Future  = nIndex_InitialPositionSearchingToPast = count - 1;
			}
			// int nIndex_NearestChip_Future = nIndex_InitialPositionSearchingToFuture;
//			while ( nIndex_NearestChip_Future < count )	// 未来方向への検索
			for ( ; nIndex_NearestChip_Future < count; nIndex_NearestChip_Future++ )
			{
				CDTX.CChip chip = listChip[ nIndex_NearestChip_Future ];
				if ( !chip.bHit && chip.b可視 )
				{
					if ( ( ( 0x93 <= chip.nチャンネル番号 ) && ( chip.nチャンネル番号 <= 0x99 ) ) )
					{
						if ( chip.n発声時刻ms > nTime )
						{
							break;
						}
						nIndex_InitialPositionSearchingToPast = nIndex_NearestChip_Future;
					}

				}
//				nIndex_NearestChip_Future++;
			}
			int nIndex_NearestChip_Past = nIndex_InitialPositionSearchingToPast;
//			while ( nIndex_NearestChip_Past >= 0 )		// 過去方向への検索
			for ( ; nIndex_NearestChip_Past >= 0; nIndex_NearestChip_Past-- )
			{
				CDTX.CChip chip = listChip[ nIndex_NearestChip_Past ];
				if ( (!chip.bHit && chip.b可視 ) &&
						(
							(
								( ( (  0x93 <= chip.nチャンネル番号 ) && ( chip.nチャンネル番号 <= 0x99 ) ) )
							)
						)
					)
					{
						break;
					}
//				nIndex_NearestChip_Past--;
			}
			if ( ( nIndex_NearestChip_Future >= count ) && ( nIndex_NearestChip_Past < 0 ) )	// 検索対象が過去未来どちらにも見つからなかった場合
			{
				sw2.Stop();
				return null;
			}
			CDTX.CChip nearestChip;	// = null;	// 以下のifブロックのいずれかで必ずnearestChipには非nullが代入されるので、null初期化を削除
			if ( nIndex_NearestChip_Future >= count )											// 検索対象が未来方向には見つからなかった(しかし過去方向には見つかった)場合
			{
				nearestChip = listChip[ nIndex_NearestChip_Past ];
//				nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
			}
			else if ( nIndex_NearestChip_Past < 0 )												// 検索対象が過去方向には見つからなかった(しかし未来方向には見つかった)場合
			{
				nearestChip = listChip[ nIndex_NearestChip_Future ];
//				nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
			}
			else
			{
				int nTimeDiff_Future = Math.Abs( (int) ( nTime - listChip[ nIndex_NearestChip_Future ].n発声時刻ms ) );
				int nTimeDiff_Past   = Math.Abs( (int) ( nTime - listChip[ nIndex_NearestChip_Past   ].n発声時刻ms ) );
				if ( nTimeDiff_Future < nTimeDiff_Past )
				{
					nearestChip = listChip[ nIndex_NearestChip_Future ];
//					nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
				}
				else
				{
					nearestChip = listChip[ nIndex_NearestChip_Past ];
//					nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
				}
			}
			nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
            int n検索範囲時間ms = 0;
			if ( ( n検索範囲時間ms > 0 ) && ( nTimeDiff > n検索範囲時間ms ) )					// チップは見つかったが、検索範囲時間外だった場合
			{
				sw2.Stop();
				return null;
			}
			sw2.Stop();
			return nearestChip;
		}
	
		protected CDTX.CChip r指定時刻に一番近い未ヒットChip( long nTime, int nChannelFlag, int nInputAdjustTime )
		{
			return this.r指定時刻に一番近い未ヒットChip( nTime, nChannelFlag, nInputAdjustTime, 0 );
		}
		protected CDTX.CChip r指定時刻に一番近い未ヒットChip( long nTime, int nChannel, int nInputAdjustTime, int n検索範囲時間ms )
		{
			sw2.Start();
//Trace.TraceInformation( "nTime={0}, nChannel={1:x2}, 現在のTop={2}", nTime, nChannel,CDTXMania.DTX.listChip[ this.n現在のトップChip ].n発声時刻ms );
			nTime += nInputAdjustTime;

			int nIndex_InitialPositionSearchingToPast;
			int nTimeDiff;
			if ( this.n現在のトップChip == -1 )			// 演奏データとして1個もチップがない場合は
			{
				sw2.Stop();
				return null;
			}
			int count = listChip.Count;
			int nIndex_NearestChip_Future = nIndex_InitialPositionSearchingToPast = this.n現在のトップChip;
			if ( this.n現在のトップChip >= count )		// その時点で演奏すべきチップが既に全部無くなっていたら
			{
				nIndex_NearestChip_Future  = nIndex_InitialPositionSearchingToPast = count - 1;
			}
			// int nIndex_NearestChip_Future = nIndex_InitialPositionSearchingToFuture;
//			while ( nIndex_NearestChip_Future < count )	// 未来方向への検索
			for ( ; nIndex_NearestChip_Future < count; nIndex_NearestChip_Future++ )
			{
				CDTX.CChip chip = listChip[ nIndex_NearestChip_Future ];
				if ( !chip.bHit )
				{
                    if ((0x11 <= nChannel) && (nChannel <= 0x1C))
                    {
                        if ((chip.nチャンネル番号 == nChannel) || (chip.nチャンネル番号 == (nChannel + 0x20)))
                        {
                            if (chip.n発声時刻ms > nTime)
                            {
                                break;
                            }
                            nIndex_InitialPositionSearchingToPast = nIndex_NearestChip_Future;
                        }
                        continue;
                    }
                    else if ((((nChannel == 0x2f) && (chip.e楽器パート == E楽器パート.GUITAR)) || (((0x20 <= nChannel) && (nChannel <= 0x28)) && (chip.nチャンネル番号 == nChannel))))
                    {
                        if (chip.n発声時刻ms > nTime)
                        {
                            break;
                        }
                        nIndex_InitialPositionSearchingToPast = nIndex_NearestChip_Future;
                    }
                    else if ((((nChannel == 0xaf) && (chip.e楽器パート == E楽器パート.BASS)) || (((0xa0 <= nChannel) && (nChannel <= 0xa8)) && (chip.nチャンネル番号 == nChannel))))
                    {
                        if (chip.n発声時刻ms > nTime)
                        {
                            break;
                        }
                        nIndex_InitialPositionSearchingToPast = nIndex_NearestChip_Future;
                    }

					if ( ( ( 0x93 <= nChannel ) && ( nChannel <= 0x96 ) ) )
					{
                        if( chip.nチャンネル番号 == nChannel )
                        {
						    if ( chip.n発声時刻ms > nTime )
						    {
							    break;
						    }

						    nIndex_InitialPositionSearchingToPast = nIndex_NearestChip_Future;
                        }
					}

					//if ( ( ( 0xDE <= nChannel ) && ( nChannel <= 0xDF ) ) )
                    if ( ( ( 0xDF == nChannel ) ) )
					{
                        if( chip.nチャンネル番号 == nChannel )
                        {
						    if ( chip.n発声時刻ms > nTime )
						    {
						    	break;
						    }
						    nIndex_InitialPositionSearchingToPast = nIndex_NearestChip_Future;
                        }
					}

				}
//				nIndex_NearestChip_Future++;
			}
			int nIndex_NearestChip_Past = nIndex_InitialPositionSearchingToPast;
//			while ( nIndex_NearestChip_Past >= 0 )		// 過去方向への検索
			for ( ; nIndex_NearestChip_Past >= 0; nIndex_NearestChip_Past-- )
			{
				CDTX.CChip chip = listChip[ nIndex_NearestChip_Past ];
				if ( (!chip.bHit) &&
						(
							( ( nChannel >= 0x11 ) && ( nChannel <= 0x1C ) &&
								( ( chip.nチャンネル番号 == nChannel ) || ( chip.nチャンネル番号 == ( nChannel + 0x20 ) ) )
							)
							||
							(
								( ( nChannel == 0x2f ) && ( chip.e楽器パート == E楽器パート.GUITAR ) ) ||
								( ( ( nChannel >= 0x20 ) && ( nChannel <= 0x28 ) ) && ( chip.nチャンネル番号 == nChannel ) )
							)
							||
							(
								( ( nChannel == 0xaf ) && ( chip.e楽器パート == E楽器パート.BASS ) ) ||
								( ( ( nChannel >= 0xA0 ) && ( nChannel <= 0xa8 ) ) && ( chip.nチャンネル番号 == nChannel ) )
							)
							||
							(
								( ( ( nChannel >= 0x93 ) && ( nChannel <= 0x96 ) ) && ( chip.nチャンネル番号 == nChannel ) )
							)
							||
							(
							//	( ( ( nChannel >= 0xDE ) && ( nChannel <= 0xDF ) ) && ( chip.nチャンネル番号 == nChannel ) )
	                            ( ( ( nChannel == 0xDF ) ) && ( chip.nチャンネル番号 == nChannel ) )
							)
						)
					)
					{
						break;
					}
//				nIndex_NearestChip_Past--;
			}
			if ( ( nIndex_NearestChip_Future >= count ) && ( nIndex_NearestChip_Past < 0 ) )	// 検索対象が過去未来どちらにも見つからなかった場合
			{
				sw2.Stop();
				return null;
			}
			CDTX.CChip nearestChip;	// = null;	// 以下のifブロックのいずれかで必ずnearestChipには非nullが代入されるので、null初期化を削除
			if ( nIndex_NearestChip_Future >= count )											// 検索対象が未来方向には見つからなかった(しかし過去方向には見つかった)場合
			{
				nearestChip = listChip[ nIndex_NearestChip_Past ];
//				nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
			}
			else if ( nIndex_NearestChip_Past < 0 )												// 検索対象が過去方向には見つからなかった(しかし未来方向には見つかった)場合
			{
				nearestChip = listChip[ nIndex_NearestChip_Future ];
//				nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
			}
			else
			{
				int nTimeDiff_Future = Math.Abs( (int) ( nTime - listChip[ nIndex_NearestChip_Future ].n発声時刻ms ) );
				int nTimeDiff_Past   = Math.Abs( (int) ( nTime - listChip[ nIndex_NearestChip_Past   ].n発声時刻ms ) );

                if( nChannel == 0xDF ) //0xDFの場合は過去方向への検索をしない
                {
                    return listChip[ nIndex_NearestChip_Future ];
                }

				if ( nTimeDiff_Future < nTimeDiff_Past )
				{
					nearestChip = listChip[ nIndex_NearestChip_Future ];
//					nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
				}
				else
				{
					nearestChip = listChip[ nIndex_NearestChip_Past ];
//					nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
				}
			}
			nTimeDiff = Math.Abs( (int) ( nTime - nearestChip.n発声時刻ms ) );
			if ( ( n検索範囲時間ms > 0 ) && ( nTimeDiff > n検索範囲時間ms ) )					// チップは見つかったが、検索範囲時間外だった場合
			{
				sw2.Stop();
				return null;
			}
			sw2.Stop();
			return nearestChip;
		}

		protected CDTX.CChip r次に来る指定楽器Chipを更新して返す( E楽器パート inst )
		{
			switch ( (int) inst )
			{
				case (int)E楽器パート.GUITAR:
					return r次にくるギターChipを更新して返す();
				case (int)E楽器パート.BASS:
					return r次にくるベースChipを更新して返す();
				default:
					return null;
			}
		}
		protected CDTX.CChip r次にくるギターChipを更新して返す()
		{
			int nInputAdjustTime = this.bIsAutoPlay.GtPick ? 0 : this.nInputAdjustTimeMs.Guitar;
			this.r次にくるギターChip = this.r指定時刻に一番近い未ヒットChip( CSound管理.rc演奏用タイマ.n現在時刻, 0x2f, nInputAdjustTime, 500 );
			return this.r次にくるギターChip;
		}
		protected CDTX.CChip r次にくるベースChipを更新して返す()
		{
			int nInputAdjustTime = this.bIsAutoPlay.BsPick ? 0 : this.nInputAdjustTimeMs.Bass;
			this.r次にくるベースChip = this.r指定時刻に一番近い未ヒットChip( CSound管理.rc演奏用タイマ.n現在時刻, 0xaf, nInputAdjustTime, 500 );
			return this.r次にくるベースChip;
		}

		protected void ChangeInputAdjustTimeInPlaying( IInputDevice keyboard, int plusminus )		// #23580 2011.1.16 yyagi UI for InputAdjustTime in playing screen.
		{
			int part, offset = plusminus;
			if ( keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.LeftShift ) || keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.RightShift ) )	// Guitar InputAdjustTime
			{
				part = (int) E楽器パート.GUITAR;
			}
			else if ( keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.LeftAlt ) || keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.RightAlt ) )	// Bass InputAdjustTime
			{
				part = (int) E楽器パート.BASS;
			}
			else	// Drums InputAdjustTime
			{
				part = (int) E楽器パート.DRUMS;
			}
			if ( !keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.LeftControl ) && !keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.RightControl ) )
			{
				offset *= 10;
			}

			this.nInputAdjustTimeMs[ part ] += offset;
			if ( this.nInputAdjustTimeMs[ part ] > 99 )
			{
				this.nInputAdjustTimeMs[ part ] = 99;
			}
			else if ( this.nInputAdjustTimeMs[ part ] < -99 )
			{
				this.nInputAdjustTimeMs[ part ] = -99;
			}
			CDTXMania.ConfigIni.nInputAdjustTimeMs[ part ] = this.nInputAdjustTimeMs[ part ];
		}

		protected abstract void t入力処理・ドラム();
		protected abstract void ドラムスクロール速度アップ();
		protected abstract void ドラムスクロール速度ダウン();
		protected void tキー入力()
		{
			IInputDevice keyboard = CDTXMania.Input管理.Keyboard;
			if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.F1 ) &&
				( keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.RightShift ) || keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.LeftShift ) ) )
			{	// shift+f1 (pause)
				this.bPAUSE = !this.bPAUSE;
				if ( this.bPAUSE )
				{
                    CSound管理.rc演奏用タイマ.t一時停止();
					CDTXMania.Timer.t一時停止();
					CDTXMania.DTX.t全チップの再生一時停止();
				}
				else
				{
                    CSound管理.rc演奏用タイマ.t再開();
					CDTXMania.Timer.t再開();
					CDTXMania.DTX.t全チップの再生再開();
				}
			}
			if ( ( !this.bPAUSE && ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED ) ) && ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト ) )
			{
				this.t入力処理・ドラム();
				this.t入力処理・ギターベース( E楽器パート.GUITAR );
				this.t入力処理・ギターベース( E楽器パート.BASS );
				if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.UpArrow ) && ( keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.RightShift ) || keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.LeftShift ) ) )
				{	// shift (+ctrl) + UpArrow (BGMAdjust)
					CDTXMania.DTX.t各自動再生音チップの再生時刻を変更する( ( keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.LeftControl ) || keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.RightControl ) ) ? 1 : 10 );
					CDTXMania.DTX.tWave再生位置自動補正();
				}
				else if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.DownArrow ) && ( keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.RightShift ) || keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.LeftShift ) ) )
				{	// shift + DownArrow (BGMAdjust)
					CDTXMania.DTX.t各自動再生音チップの再生時刻を変更する( ( keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.LeftControl ) || keyboard.bキーが押されている( (int) SlimDX.DirectInput.Key.RightControl ) ) ? -1 : -10 );
					CDTXMania.DTX.tWave再生位置自動補正();
				}
				else if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.UpArrow ) )
				{	// UpArrow(scrollspeed up)
					ドラムスクロール速度アップ();
				}
				else if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.DownArrow ) )
				{	// DownArrow (scrollspeed down)
					ドラムスクロール速度ダウン();
				}
				else if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.Delete ) )
				{	// del (debug info)
					CDTXMania.ConfigIni.b演奏情報を表示する = !CDTXMania.ConfigIni.b演奏情報を表示する;
				}
				else if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.LeftArrow ) )		// #24243 2011.1.16 yyagi UI for InputAdjustTime in playing screen.
				{
					ChangeInputAdjustTimeInPlaying( keyboard, -1 );
				}
				else if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.RightArrow ) )		// #24243 2011.1.16 yyagi UI for InputAdjustTime in playing screen.
				{
					ChangeInputAdjustTimeInPlaying( keyboard, +1 );
				}
				else if ( ( base.eフェーズID == CStage.Eフェーズ.共通_通常状態 ) && ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.Escape ) || CDTXMania.Pad.b押されたGB( Eパッド.FT ) ) )
				{	// escape (exit)
					this.actFO.tフェードアウト開始();
					base.eフェーズID = CStage.Eフェーズ.共通_フェードアウト;
					this.eフェードアウト完了時の戻り値 = E演奏画面の戻り値.演奏中断;
				}
				else if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.D1 ) )
				{
                    if( this.n分岐した回数 < CDTXMania.DTX.listBRANCH.Count )
                        this.t分岐処理( 0, CDTXMania.DTX.listBRANCH[ this.n分岐した回数 ].n命令時のChipList番号 );
                    CDTXMania.stage演奏ドラム画面.actLaneTaiko.t分岐レイヤー・コース変化( this.n現在のコース, 0 );
                    CDTXMania.stage演奏ドラム画面.actMtaiko.tBranchEvent( this.n現在のコース, 0 );
                    this.n現在のコース = 0;
                    this.n次回のコース = 0;
                    this.b強制的に分岐させた = true;
				}
				else if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.D2 ) )		// #24243 2011.1.16 yyagi UI for InputAdjustTime in playing screen.
				{
                    if( this.n分岐した回数 < CDTXMania.DTX.listBRANCH.Count )
                        this.t分岐処理( 1, CDTXMania.DTX.listBRANCH[ this.n分岐した回数 ].n命令時のChipList番号 );
                    CDTXMania.stage演奏ドラム画面.actLaneTaiko.t分岐レイヤー・コース変化( this.n現在のコース, 1 );
                    CDTXMania.stage演奏ドラム画面.actMtaiko.tBranchEvent( this.n現在のコース, 1 );
                    this.n現在のコース = 1;
                    this.n次回のコース = 1;
                    this.b強制的に分岐させた = true;
				}
				else if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.D3 ) )		// #24243 2011.1.16 yyagi UI for InputAdjustTime in playing screen.
				{
                    if( this.n分岐した回数 < CDTXMania.DTX.listBRANCH.Count )
                        this.t分岐処理( 2, CDTXMania.DTX.listBRANCH[ this.n分岐した回数 ].n命令時のChipList番号 );
                    CDTXMania.stage演奏ドラム画面.actLaneTaiko.t分岐レイヤー・コース変化( this.n現在のコース, 2 );
                    CDTXMania.stage演奏ドラム画面.actMtaiko.tBranchEvent( this.n現在のコース, 2 );
                    this.n現在のコース = 2;
                    this.n次回のコース = 2;
                    this.b強制的に分岐させた = true;
				}

				if ( keyboard.bキーが押された( (int) SlimDX.DirectInput.Key.D5 ) )
				{
                    if( CDTXMania.ConfigIni.b太鼓パートAutoPlay == false )
                        CDTXMania.ConfigIni.b太鼓パートAutoPlay = true;
                    else
                        CDTXMania.ConfigIni.b太鼓パートAutoPlay = false;
				}
			}
		}

		protected void t入力メソッド記憶( E楽器パート part )
		{
			if ( CDTXMania.Pad.st検知したデバイス.Keyboard )
			{
				this.b演奏にキーボードを使った[ (int) part ] = true;
			}
			if ( CDTXMania.Pad.st検知したデバイス.Joypad )
			{
				this.b演奏にジョイパッドを使った[ (int) part ] = true;
			}
			if ( CDTXMania.Pad.st検知したデバイス.MIDIIN )
			{
				this.b演奏にMIDI入力を使った[ (int) part ] = true;
			}
			if ( CDTXMania.Pad.st検知したデバイス.Mouse )
			{
				this.b演奏にマウスを使った[ (int) part ] = true;
			}
		}


		protected abstract void t進行描画・AVI();
		protected void t進行描画・AVI(int x, int y)
		{
			if ( ( ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED ) && ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト ) ) && ( !CDTXMania.ConfigIni.bストイックモード && CDTXMania.ConfigIni.bAVI有効 ) )
			{
				this.actAVI.t進行描画( x, y );
			}
		}
		protected abstract void t進行描画・DANGER();
		protected void t進行描画・MIDIBGM()
		{
			if ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED )
			{
				CStage.Eフェーズ eフェーズid1 = base.eフェーズID;
			}
		}
		protected void t進行描画・RGBボタン()
		{
			if ( CDTXMania.ConfigIni.eDark != Eダークモード.FULL )
			{
				this.actRGB.t進行描画( 演奏判定ライン座標 );
			}
		}
		protected void t進行描画・STAGEFAILED()
		{
			if ( ( ( base.eフェーズID == CStage.Eフェーズ.演奏_STAGE_FAILED ) || ( base.eフェーズID == CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト ) ) && ( ( this.actStageFailed.On進行描画() != 0 ) && ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト ) ) )
			{
				this.eフェードアウト完了時の戻り値 = E演奏画面の戻り値.ステージ失敗;
				base.eフェーズID = CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト;
				this.actFO.tフェードアウト開始();
			}
		}
		protected void t進行描画・WailingBonus()
		{
			if ( ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED ) && ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト ) )
			{
				this.actWailingBonus.On進行描画();
			}
		}
		protected abstract void t進行描画・Wailing枠();
		protected void t進行描画・Wailing枠(int GtWailingFrameX, int BsWailingFrameX, int GtWailingFrameY, int BsWailingFrameY)
		{
			if ( ( CDTXMania.ConfigIni.eDark != Eダークモード.FULL ) && CDTXMania.ConfigIni.bGuitar有効 )
			{
				if ( this.txWailing枠 != null )
				{
					if ( CDTXMania.DTX.bチップがある.Guitar )
					{
						this.txWailing枠.t2D描画( CDTXMania.app.Device, GtWailingFrameX, GtWailingFrameY );
					}
					if ( CDTXMania.DTX.bチップがある.Bass )
					{
						this.txWailing枠.t2D描画( CDTXMania.app.Device, BsWailingFrameX, BsWailingFrameY );
					}
				}
			}
		}


		protected void t進行描画・チップファイアGB()
		{
			this.actChipFireGB.On進行描画();
		}
		protected abstract void t進行描画・パネル文字列();
		protected void t進行描画・パネル文字列(int x, int y)
		{
			if ( ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED ) && ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト ) )
			{
				this.actPanel.t進行描画( x, y );
			}
		}
		protected void tパネル文字列の設定()
		{
			this.actPanel.SetPanelString( string.IsNullOrEmpty( CDTXMania.DTX.PANEL ) ? CDTXMania.DTX.TITLE : CDTXMania.DTX.PANEL );
		}


		protected void t進行描画・ゲージ()
		{
			if ( ( ( ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED ) && ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト ) ) ) )
			{
				this.actGauge.On進行描画();
			}
		}
		protected void t進行描画・コンボ()
		{
			this.actCombo.On進行描画();
		}
		protected void t進行描画・スコア()
		{
			this.actScore.On進行描画();
		}
		protected void t進行描画・ステータスパネル()
		{
			this.actStatusPanels.On進行描画();
		}
		protected bool t進行描画・チップ( E楽器パート ePlayMode )
		{
			if ( ( base.eフェーズID == CStage.Eフェーズ.演奏_STAGE_FAILED ) || ( base.eフェーズID == CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト ) )
			{
				return true;
			}
			if ( ( this.n現在のトップChip == -1 ) || ( this.n現在のトップChip >= listChip.Count ) )
			{
				return true;
			}
			if ( this.n現在のトップChip == -1 )
			{
				return true;
			}

			//double speed = 264.0;	// BPM150の時の1小節の長さ[dot]
			const double speed = 324.0;	// BPM150の時の1小節の長さ[dot]

			//double ScrollSpeedDrums = (( this.act譜面スクロール速度.db現在の譜面スクロール速度.Drums + 1.0 ) * speed ) * 0.5 * 37.5 / 60000.0;
            double ScrollSpeedDrums = ((  this.act譜面スクロール速度.db現在の譜面スクロール速度.Drums + 1.0 ) * speed ) * 0.5 * 37.5 / 60000.0;
			double ScrollSpeedGuitar = ( this.act譜面スクロール速度.db現在の譜面スクロール速度.Guitar + 1.0 ) * 0.5 * 0.5 * 37.5 * speed / 60000.0;
			double ScrollSpeedBass = ( this.act譜面スクロール速度.db現在の譜面スクロール速度.Bass + 1.0 ) * 0.5 * 0.5 * 37.5 * speed / 60000.0;
            double ScrollSpeedTaiko = (( this.act譜面スクロール速度.db現在の譜面スクロール速度.Drums + 1.0 ) * speed ) * 0.5 * 37.5 / 60000.0;

			CDTX dTX = CDTXMania.DTX;
			CConfigIni configIni = CDTXMania.ConfigIni;
            this.bUseBranch = dTX.bチップがある.Branch;

            //for ( int nCurrentTopChip = this.n現在のトップChip; nCurrentTopChip < dTX.listChip.Count; nCurrentTopChip++ )
            for ( int nCurrentTopChip = dTX.listChip.Count - 1; nCurrentTopChip > 0; nCurrentTopChip-- )
			{
				CDTX.CChip pChip = dTX.listChip[ nCurrentTopChip ];
//Debug.WriteLine( "nCurrentTopChip=" + nCurrentTopChip + ", ch=" + pChip.nチャンネル番号.ToString("x2") + ", 発音位置=" + pChip.n発声位置 + ", 発声時刻ms=" + pChip.n発声時刻ms );
				pChip.nバーからの距離dot.Drums = (int) ( ( pChip.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻 ) * ScrollSpeedDrums );
				pChip.nバーからの距離dot.Guitar = (int) ( ( pChip.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻 ) * ScrollSpeedGuitar );
				pChip.nバーからの距離dot.Bass = (int) ( ( pChip.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻 ) * ScrollSpeedBass );
                pChip.nバーからの距離dot.Taiko = (int) ( ( ( pChip.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻 ) * pChip.dbBPM * pChip.dbSCROLL * ( this.act譜面スクロール速度.db現在の譜面スクロール速度.Drums + 1.5 ) ) / 628.7 );
                pChip.nバーからのノーツ末端距離dot.Drums = 0;
                pChip.nバーからのノーツ末端距離dot.Guitar = 0;
                pChip.nバーからのノーツ末端距離dot.Bass = 0;
                if( pChip.nノーツ終了時刻ms != 0 )
                    pChip.nバーからのノーツ末端距離dot.Taiko = (int) ( ( ( pChip.nノーツ終了時刻ms - CSound管理.rc演奏用タイマ.n現在時刻 ) * pChip.dbBPM * pChip.dbSCROLL * ( this.act譜面スクロール速度.db現在の譜面スクロール速度.Drums + 1.5 ) ) / 628.7 );
                
//				if ( ( ( nCurrentTopChip == this.n現在のトップChip ) && ( pChip.nバーからの距離dot.Drums < -65 ) ) && pChip.bHit )
				// #28026 2012.4.5 yyagi; 信心ワールドエンドの曲終了後リザルトになかなか行かない問題の修正
				//if ( ( dTX.listChip[ nCurrentTopChip ].nバーからの距離dot.Drums < -65 ) && dTX.listChip[ nCurrentTopChip ].bHit )
				{
//					nCurrentTopChip = ++this.n現在のトップChip;
					//++this.n現在のトップChip;
					//continue;
				}


				bool bPChipIsAutoPlay = bCheckAutoPlay( pChip );

				int nInputAdjustTime = ( bPChipIsAutoPlay || (pChip.e楽器パート == E楽器パート.UNKNOWN) )? 0 : this.nInputAdjustTimeMs[ (int) pChip.e楽器パート ];

				int instIndex = (int) pChip.e楽器パート;
                /*
				if ( ( ( pChip.e楽器パート != E楽器パート.UNKNOWN ) && !pChip.bHit ) &&
				    ( ( pChip.nバーからの距離dot[ instIndex ] < -40 ) && ( this.e指定時刻からChipのJUDGEを返す( CSound管理.rc演奏用タイマ.n現在時刻, pChip, nInputAdjustTime ) == E判定.Miss ) ) )
				{
				    this.tチップのヒット処理( CSound管理.rc演奏用タイマ.n現在時刻, pChip );
				}
                */

                if( pChip.nチャンネル番号 >= 0x93 && pChip.nチャンネル番号 <= 0x96 )//|| pChip.nチャンネル番号 == 0x9A )
                {
				    if ( ( !pChip.bHit ) &&
                       ( ( ( pChip.n発声時刻ms + 120 ) < CSound管理.rc演奏用タイマ.n現在時刻ms ) && ( this.e指定時刻からChipのJUDGEを返す( CSound管理.rc演奏用タイマ.n現在時刻, pChip, nInputAdjustTime ) == E判定.Miss ) ) )
                       //( ( pChip.nバーからの距離dot.Taiko < -40 ) && ( this.e指定時刻からChipのJUDGEを返す( CSound管理.rc演奏用タイマ.n現在時刻, pChip, nInputAdjustTime ) == E判定.Miss ) ) )
				    {
    				    this.tチップのヒット処理( CSound管理.rc演奏用タイマ.n現在時刻, pChip );
	    			}
                }
                else
                {
				    if ( ( ( pChip.e楽器パート != E楽器パート.UNKNOWN ) && !pChip.bHit ) &&
				       ( ( pChip.nバーからの距離dot[ instIndex ] < -40 ) && ( this.e指定時刻からChipのJUDGEを返す( CSound管理.rc演奏用タイマ.n現在時刻, pChip, nInputAdjustTime ) == E判定.Miss ) ) )
				    {
    				    this.tチップのヒット処理( CSound管理.rc演奏用タイマ.n現在時刻, pChip );
	    			}
                }

                if( pChip.nバーからの距離dot[ instIndex ] < -150 )
                {
                    pChip.bHit = true;
                }

                if( chip現在処理中の連打チップ != null )
                {
                    if( chip現在処理中の連打チップ.nチャンネル番号 >= 0x97 && chip現在処理中の連打チップ.nチャンネル番号 <= 0x99 )//|| pChip.nチャンネル番号 == 0x9A )
                    {
				        if ( ( !chip現在処理中の連打チップ.bHit ) &&
                           ( ( chip現在処理中の連打チップ.nバーからの距離dot.Taiko < -500 ) && ( chip現在処理中の連打チップ.n発声時刻ms <= CSound管理.rc演奏用タイマ.n現在時刻ms && chip現在処理中の連打チップ.nノーツ終了時刻ms >= CSound管理.rc演奏用タイマ.n現在時刻ms ) ) )
                           //( ( chip現在処理中の連打チップ.nバーからのノーツ末端距離dot.Taiko < -500 ) && ( chip現在処理中の連打チップ.n発声時刻ms <= CSound管理.rc演奏用タイマ.n現在時刻ms && chip現在処理中の連打チップ.nノーツ終了時刻ms >= CSound管理.rc演奏用タイマ.n現在時刻ms ) ) )
                           //( ( pChip.n発声時刻ms <= CSound管理.rc演奏用タイマ.n現在時刻ms && pChip.nノーツ終了時刻ms >= CSound管理.rc演奏用タイマ.n現在時刻ms ) ) )
		    		    {
                            if( CDTXMania.ConfigIni.b太鼓パートAutoPlay )
    		    		        this.tチップのヒット処理( CSound管理.rc演奏用タイマ.n現在時刻, chip現在処理中の連打チップ );
	    		    	}
                    }
                }
                
				switch ( pChip.nチャンネル番号 )
				{
					#region [ 01: BGM ]
					case 0x01:	// BGM
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
							if ( configIni.bBGM音を発声する )
							{
								dTX.tチップの再生( pChip, CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻 + pChip.n発声時刻ms, (int) Eレーン.BGM, dTX.nモニタを考慮した音量( E楽器パート.UNKNOWN ) );
							}
						}
						break;
					#endregion
					#region [ 03: BPM変更 ]
					case 0x03:	// BPM変更
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
							this.actPlayInfo.dbBPM = ( pChip.n整数値 * ( ( (double) configIni.n演奏速度 ) / 20.0 ) ) + dTX.BASEBPM;
						}
						break;
					#endregion
					#region [ 04, 07, 55, 56,57, 58, 59, 60:レイヤーBGA(消した) ]
					case 0x04:	// レイヤーBGA
					case 0x07:
					case 0x55:
					case 0x56:
					case 0x57:
					case 0x58:
					case 0x59:
					case 0x60:
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
						}
						break;
					#endregion
					#region [ 08: BPM変更(拡張) ]
					case 0x08:	// BPM変更(拡張)
                        //CDTXMania.act文字コンソール.tPrint( 414 + pChip.nバーからの距離dot.Drums + 4, 192, C文字コンソール.Eフォント種別.白, "BRANCH START" + "  " + pChip.n整数値.ToString() );
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
                            if( pChip.nコース == this.n現在のコース )
                            {
							    if ( dTX.listBPM.ContainsKey( pChip.n整数値・内部番号 ) )
							    {
								    //this.actPlayInfo.dbBPM = ( dTX.listBPM[ pChip.n整数値・内部番号 ].dbBPM値 * ( ( (double) configIni.n演奏速度 ) / 20.0 ) );// + dTX.BASEBPM;
							    }
                                //double bpm = ( dTX.listBPM[ pChip.n整数値・内部番号 ].dbBPM値 * ( ( (double) configIni.n演奏速度 ) / 20.0 ) );
                                //int nUnit = (int)((60.0 / ( bpm ) / this.actChara.nキャラクター通常モーション枚数 ) * 1000 );
                                //int nUnit_gogo = (int)((60.0 / ( bpm ) / this.actChara.nキャラクターゴーゴーモーション枚数 ) * 1000 );
                                //this.actChara.ct通常モーション = new CCounter( 0, this.actChara.nキャラクター通常モーション枚数 - 1, nUnit, CDTXMania.Timer );
                                //this.actChara.ctゴーゴーモーション = new CCounter(0, this.actChara.nキャラクターゴーゴーモーション枚数 - 1, nUnit_gogo * 2, CDTXMania.Timer);

                            }

						}
						break;
					#endregion
					#region [ 11-1a: ドラム演奏 ]
					case 0x11:	// ドラム演奏
					case 0x12:
					case 0x13:
					case 0x14:
					case 0x15:
					case 0x16:
					case 0x17:
					case 0x18:
					case 0x19:
					case 0x1a:
                    case 0x1b:
                    case 0x1c:
						//this.t進行描画・チップ・ドラムス( configIni, ref dTX, ref pChip );
                        //this.t進行描画・チップ本体・ドラムス( configIni, ref dTX, ref pChip );
						break;
					#endregion
					#region [ 1f: フィルインサウンド(ドラム) ]
					case 0x1f:	// フィルインサウンド(ドラム)
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
							this.r現在の歓声Chip.Drums = pChip;
						}
						break;
					#endregion
					#region [ 20-27: ギター演奏 ]
					case 0x20:	// ギター演奏
					case 0x21:
					case 0x22:
					case 0x23:
					case 0x24:
					case 0x25:
					case 0x26:
					case 0x27:
						this.t進行描画・チップ・ギターベース( configIni, ref dTX, ref pChip, E楽器パート.GUITAR );
						break;
					#endregion
					#region [ 28: ウェイリング(ギター) ]
					case 0x28:	// ウェイリング(ギター)
						this.t進行描画・チップ・ギター・ウェイリング( configIni, ref dTX, ref pChip );
						break;
					#endregion
					#region [ 2f: ウェイリングサウンド(ギター) ]
					case 0x2f:	// ウェイリングサウンド(ギター)
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Guitar < 0 ) )
						{
							pChip.bHit = true;
							this.r現在の歓声Chip.Guitar = pChip;
						}
						break;
					#endregion
					#region [ 31-3a: 不可視チップ配置(ドラム) ]
					case 0x31:	// 不可視チップ配置(ドラム)
					case 0x32:
					case 0x33:
					case 0x34:
					case 0x35:
					case 0x36:
					case 0x37:
					case 0x38:
					case 0x39:
					case 0x3a:
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
						}
						break;
					#endregion
					#region [ 50: 小節線 ]
					case 0x50:	// 小節線
						{
                            if ( !pChip.bHit && ( pChip.nバーからの距離dot.Taiko < 0 ) )
						    {
                                if( this.actPlayInfo.n小節番号 == 0 )
                                {
                                    double dbUnit = ( ( ( 60.0f / ( (float)CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) ) ) / this.actChara.arモーション番号.Length );
                                    double dbUnit_gogo = ( ( ( 60.0 / ( CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) ) ) / this.actChara.arゴーゴーモーション番号.Length );

                                    dbUnit = Math.Ceiling( dbUnit * 1000.0 );
                                    dbUnit = dbUnit / 1000.0;

                                    this.actChara.tStart_NormalMotion( dbUnit );
                                    //this.actChara.ct通常モーション = new CCounter( 0, this.actChara.arモーション番号.Length - 1, dbUnit, CSound管理.rc演奏用タイマ );
                                    this.actChara.ctゴーゴーモーション = new CCounter( 0, this.actChara.arゴーゴーモーション番号.Length - 1, dbUnit_gogo * 2, CSound管理.rc演奏用タイマ );

                                    if( this.actChara.nキャラクタークリアモーション枚数 != 0 )
                                    {
                                        double dbUnit_clear = ( ( ( 60.0 / ( CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) ) ) / this.actChara.arクリアモーション番号.Length );
                                        this.actChara.ctクリア通常モーション = new CCounter( 0, this.actChara.arクリアモーション番号.Length - 1, dbUnit_clear * 2, CSound管理.rc演奏用タイマ );
                                    }
                                    if( this.actChara.nキャラクターMAX通常モーション枚数 != 0 )
                                    {
                                        double dbUnit_max = ( ( ( 60.0 / ( CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) ) ) / this.actChara.ar黄色モーション番号.Length );
                                        this.actChara.ctMAX通常モーション = new CCounter( 0, this.actChara.ar黄色モーション番号.Length - 1, dbUnit_max * 2, CSound管理.rc演奏用タイマ );
                                    }
                                    if( this.actChara.nキャラクターMAXゴーゴーモーション枚数 != 0 )
                                    {
                                        double dbUnit_max_gogo = ( ( ( 60.0 / ( CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) ) ) / this.actChara.ar黄色ゴーゴーモーション番号.Length );
                                        this.actChara.ctMAXゴーゴーモーション = new CCounter( 0, this.actChara.ar黄色ゴーゴーモーション番号.Length - 1, dbUnit_max_gogo * 2, CSound管理.rc演奏用タイマ );
                                    }
                                }
                            }
							this.t進行描画・チップ・小節線( configIni, ref dTX, ref pChip );
							break;
						}
					#endregion
					#region [ 51: 拍線 ]
					case 0x51:	// 拍線
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
						}
						if ( ( ePlayMode == E楽器パート.DRUMS ) && ( configIni.eDark != Eダークモード.FULL ) && pChip.b可視 && ( this.txチップ != null ) )
						{
                            //太鼓では拍線を使わない。
							//this.txチップ.t2D描画( CDTXMania.app.Device, 295, configIni.bReverse.Drums ? ( ( 0x38 + pChip.nバーからの距離dot.Drums ) - 1 ) : ( ( 567 - pChip.nバーからの距離dot.Drums ) - 1 ), new Rectangle( 0, 772, 559, 2 ) );
						}
						break;
					#endregion
					#region [ 52: MIDIコーラス ]
					case 0x52:	// MIDIコーラス
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
						}
						break;
					#endregion
                    #region[ 53: なし ]
                    case 0x53:
						break;
					#endregion
					#region [ 54: 動画再生 ]
					case 0x54:	// 動画再生
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
							if ( configIni.bAVI有効 )
							{
								switch ( pChip.eAVI種別 )
								{
									case EAVI種別.AVI:
										if ( pChip.rAVI != null )
										{
											this.actAVI.Start( pChip.nチャンネル番号, pChip.rAVI, pChip.rDShow, 278, 355, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, pChip.n発声時刻ms );
										}
										break;
									case EAVI種別.Unknown:
										if ( pChip.rAVI != null || pChip.rDShow != null )
										{
											this.actAVI.Start( pChip.nチャンネル番号, pChip.rAVI, pChip.rDShow, 278, 355, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, pChip.n発声時刻ms );
										}
										break;
								}
							}
						}
						break;
					#endregion
					#region [ 61-92: 自動再生(BGM, SE) ]
					case 0x61:
					case 0x62:
					case 0x63:
					case 0x64:	// 自動再生(BGM, SE)
					case 0x65:
					case 0x66:
					case 0x67:
					case 0x68:
					case 0x69:
					case 0x70:
					case 0x71:
					case 0x72:
					case 0x73:
					case 0x74:
					case 0x75:
					case 0x76:
					case 0x77:
					case 0x78:
					case 0x79:
					case 0x80:
					case 0x81:
					case 0x82:
					case 0x83:
					case 0x90:
					case 0x91:
					case 0x92:
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
							if ( configIni.bBGM音を発声する )
							{
								//dTX.tWavの再生停止( this.n最後に再生したBGMの実WAV番号[ pChip.nチャンネル番号 - 0x61 ] );
								//dTX.tチップの再生( pChip, CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻 + pChip.n発声時刻ms, ( int ) Eレーン.BGM, dTX.nモニタを考慮した音量( E楽器パート.UNKNOWN ) );
								//this.n最後に再生したBGMの実WAV番号[ pChip.nチャンネル番号 - 0x61 ] = pChip.n整数値・内部番号;
							}
						}
						break;
					#endregion

                    #region[ 93～9F: 太鼓 ]
                    //現状未実装の部分もあるが、念のために予約しておく。
                    case 0x93: //ドン
                    case 0x94: //カッ
                    case 0x95: //ドン(大)
                    case 0x96: //カッ(大)
                    //case 0x9C: //未実装(なんかやりたい)
                        {
                            //if( pChip.nコース == this.n現在のコース )
                            //{
                            //    if( pChip.n分岐回数 == this.n分岐した回数 + 1 && pChip.nコース == this.n次回のコース )
                            //    {
                            //        this.t進行描画・チップ・Taiko_A( configIni, ref dTX, ref pChip );
                            //    }
                            //    else if( pChip.n分岐回数 == this.n分岐した回数 + 1 && pChip.nコース != this.n次回のコース )
                            //    {
                            //        pChip.b可視 = false;
                            //    }
                            //    else
                            //    {
                            //        pChip.b可視 = true;

                            //        if( pChip.nコース != this.n現在のコース )
                            //            pChip.b可視 = false;
                            //        this.t進行描画・チップ・Taiko( configIni, ref dTX, ref pChip );
                            //    }
                            //}
                            //if( pChip.nコース == this.n現在のコース )
                            {
                                //pChip.b可視 = true;
                                this.t進行描画・チップ・Taiko( configIni, ref dTX, ref pChip );
                            }
                            //else
                            {
                                //pChip.bHit = true;
                                //pChip.b可視 = false;
                                //continue;
                                //this.t進行描画・チップ・Taiko( configIni, ref dTX, ref pChip );
                            }
                        }
                        break;

                    case 0x97: //連打
                    case 0x98: //連打(大)
                    case 0x99: //風船
                    case 0x9A: //連打終了
                    case 0x9B:
                        {
                            //2015.03.28 kairera0467
                            //描画順序を変えるため、メイン処理だけをこちらに残して描画処理は分離。

                            //this.t進行描画・チップ・Taiko連打(configIni, ref dTX, ref pChip);
                            int t = (int)CSound管理.rc演奏用タイマ.n現在時刻ms;

                            //2015.04.13 kairera0467 ここを外さないと恋文2000の連打に対応できず、ここをつけないと他のコースと重なっている連打をどうにもできない。
                            //常時実行メソッドに渡したら対応できた!?
                            //if ((!pChip.bHit && (pChip.nバーからの距離dot.Drums < 0)))
                            {
                                if ((pChip.n発声時刻ms <= (int)CSound管理.rc演奏用タイマ.n現在時刻ms && pChip.nノーツ終了時刻ms >= (int)CSound管理.rc演奏用タイマ.n現在時刻ms) && pChip.nチャンネル番号 != 0x9A)
                                {
                                    //if( this.n現在のコース == pChip.nコース )
                                    if( pChip.b可視 == true )
                                        this.chip現在処理中の連打チップ = pChip;
                                }
                            }




                            if ((!pChip.bHit && (pChip.nバーからの距離dot.Drums < 0)) && pChip.nチャンネル番号 != 0x9A)
                            {
                                this.n連打終了時間ms = pChip.nノーツ終了時刻ms;
                            }
                            else if ((!pChip.bHit && (pChip.nバーからの距離dot.Drums < 0)) && pChip.nチャンネル番号 == 0x9A)
                            {
                                this.b連打中 = false;
                                this.actChara.b風船連打中 = false;
                                pChip.bHit = true;
                                if( chip現在処理中の連打チップ != null )
                                    chip現在処理中の連打チップ.bHit = true;
                                this.eRollState = E連打State.none;
                            }
                        }
                        break;

                    //0x9C BPM変化(アニメーション用)
                    case 0x9C:
                        //CDTXMania.act文字コンソール.tPrint( 414 + pChip.nバーからの距離dot.Taiko + 8, 192, C文字コンソール.Eフォント種別.白, "BPMCHANGE" );
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
                            if( pChip.nコース == this.n現在のコース )
                            {
							    if ( dTX.listBPM.ContainsKey( pChip.n整数値・内部番号 ) )
							    {
								    this.actPlayInfo.dbBPM = ( dTX.listBPM[ pChip.n整数値・内部番号 ].dbBPM値 * ( ( (double) configIni.n演奏速度 ) / 20.0 ) );// + dTX.BASEBPM;
							    }
                                double bpm = ( dTX.listBPM[ pChip.n整数値・内部番号 ].dbBPM値 * ( ( (double) configIni.n演奏速度 ) / 20.0 ) );
                                double dbUnit = ( ( ( 60.0 / ( bpm ) ) ) / this.actChara.arモーション番号.Length );
                                double dbUnit_gogo = ( ( 60.0 / bpm )  / this.actChara.arゴーゴーモーション番号.Length );

                                this.actChara.ct通常モーション = new CCounter( 0, this.actChara.arモーション番号.Length - 1, dbUnit, CSound管理.rc演奏用タイマ );
                                this.actChara.ctゴーゴーモーション = new CCounter( 0, this.actChara.arゴーゴーモーション番号.Length - 1, dbUnit_gogo * 2, CSound管理.rc演奏用タイマ );

                                if( this.actChara.nキャラクタークリアモーション枚数 != 0 )
                                {
                                    double dbUnit_clear = ( ( ( 60.0 / ( bpm ) ) ) / this.actChara.arクリアモーション番号.Length );
                                    this.actChara.ctクリア通常モーション = new CCounter( 0, this.actChara.arクリアモーション番号.Length - 1, dbUnit_clear * 2, CSound管理.rc演奏用タイマ );
                                }
                                if( this.actChara.nキャラクターMAX通常モーション枚数 != 0 )
                                {
                                    double dbUnit_max = ( ( ( 60.0 / ( bpm ) ) ) / this.actChara.ar黄色モーション番号.Length );
                                    this.actChara.ctMAX通常モーション = new CCounter( 0, this.actChara.ar黄色モーション番号.Length - 1, dbUnit_max * 2, CSound管理.rc演奏用タイマ );
                                }
                                if( this.actChara.nキャラクターMAXゴーゴーモーション枚数 != 0 )
                                {
                                    double dbUnit_max_gogo = ( ( ( 60.0 / ( bpm ) ) ) / this.actChara.ar黄色ゴーゴーモーション番号.Length );
                                    this.actChara.ctMAXゴーゴーモーション = new CCounter( 0, this.actChara.ar黄色ゴーゴーモーション番号.Length - 1, dbUnit_max_gogo * 2, CSound管理.rc演奏用タイマ );
                                }
                            }

						}
                        break;

                    case 0x9D: //SCROLL
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
							if ( dTX.listSCROLL.ContainsKey( pChip.n整数値・内部番号 ) )
							{
								//this.actPlayInfo.dbBPM = ( dTX.listBPM[ pChip.n整数値・内部番号 ].dbBPM値 * ( ( (double) configIni.n演奏速度 ) / 20.0 ) );// + dTX.BASEBPM;
							}
						}
                        break;

                    case 0x9E: //ゴーゴータイム
                        if( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
                        {
                            pChip.bHit = true;
                            this.bIsGOGOTIME = true;
                            CDTXMania.stage演奏ドラム画面.actLaneTaiko.GOGOSTART();
                        }
                        break;
                    case 0x9F: //ゴーゴータイム
                        if( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
                        {
                            pChip.bHit = true;
                            this.bIsGOGOTIME = false;
                        }
                        break;
                    #endregion


                    #region [ 84-89: 仮: override sound ]	// #26338 2011.11.8 yyagi
                    case 0x84:	// HH (HO/HC)
					case 0x85:	// CY
					case 0x86:	// RD
					case 0x87:	// LC
					case 0x88:	// Guitar
					case 0x89:	// Bass
					// mute sound (auto)
					// 4A: 84: HH (HO/HC)
					// 4B: 85: CY
					// 4C: 86: RD
					// 4D: 87: LC
					// 2A: 88: Gt
					// AA: 89: Bs

					//	CDTXMania.DTX.tWavの再生停止( this.n最後に再生した実WAV番号.Guitar );
					//	CDTXMania.DTX.tチップの再生( pChip, n再生開始システム時刻ms, 8, n音量, bモニタ, b音程をずらして再生 );
					//	this.n最後に再生した実WAV番号.Guitar = pChip.n整数値・内部番号;

					//	protected void tサウンド再生( CDTX.CChip pChip, long n再生開始システム時刻ms, E楽器パート part, int n音量, bool bモニタ, bool b音程をずらして再生 )
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
							E楽器パート[] p = { E楽器パート.DRUMS, E楽器パート.DRUMS, E楽器パート.DRUMS, E楽器パート.DRUMS, E楽器パート.GUITAR, E楽器パート.BASS };

							E楽器パート pp =  p[ pChip.nチャンネル番号 - 0x84 ];
							
//							if ( pp == E楽器パート.DRUMS ) {			// pChip.nチャンネル番号= ..... HHとか、ドラムの場合は変える。
//								//            HC    CY    RD    LC
//								int[] ch = { 0x11, 0x16, 0x19, 0x1A };
//								pChip.nチャンネル番号 = ch[ pChip.nチャンネル番号 - 0x84 ]; 
//							}
							//this.tサウンド再生( pChip, CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻 + pChip.n発声時刻ms, pp, dTX.nモニタを考慮した音量( pp ) );
						}
						break;
					#endregion

					#region [ a0-a7: ベース演奏 ]
					case 0xa0:	// ベース演奏
					case 0xa1:
					case 0xa2:
					case 0xa3:
					case 0xa4:
					case 0xa5:
					case 0xa6:
					case 0xa7:
						this.t進行描画・チップ・ギターベース( configIni, ref dTX, ref pChip, E楽器パート.BASS );
						break;
					#endregion
					#region [ a8: ウェイリング(ベース) ]
					case 0xa8:	// ウェイリング(ベース)
						this.t進行描画・チップ・ベース・ウェイリング( configIni, ref dTX, ref pChip );
						break;
					#endregion
					#region [ af: ウェイリングサウンド(ベース) ]
					case 0xaf:	// ウェイリングサウンド(ベース)
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Bass < 0 ) )
						{
							pChip.bHit = true;
							this.r現在の歓声Chip.Bass = pChip;
						}
						break;
					#endregion
					#region [ b1-b9, bc: 空打ち音設定(ドラム) ]
					case 0xb1:	// 空打ち音設定(ドラム)
					case 0xb2:
					case 0xb3:
					case 0xb4:
					case 0xb5:
					case 0xb6:
					case 0xb7:
					case 0xb8:
					case 0xb9:
					case 0xbc:
						this.t進行描画・チップ・空打ち音設定・ドラム( configIni, ref dTX, ref pChip );
						break;
					#endregion
					#region [ ba: 空打ち音設定(ギター) ]
					case 0xba:	// 空打ち音設定(ギター)
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Guitar < 0 ) )
						{
							pChip.bHit = true;
							this.r現在の空うちギターChip = pChip;
							pChip.nチャンネル番号 = 0x20;
						}
						break;
					#endregion
					#region [ bb: 空打ち音設定(ベース) ]
					case 0xbb:	// 空打ち音設定(ベース)
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Bass < 0 ) )
						{
							pChip.bHit = true;
							this.r現在の空うちベースChip = pChip;
							pChip.nチャンネル番号 = 0xA0;
						}
						break;
					#endregion
					#region [ c4, c7, d5-d9, e0: BGA画像入れ替え(消した) ]
					case 0xc4:
					case 0xc7:
					case 0xd5:
					case 0xd6:	// BGA画像入れ替え
					case 0xd7:
					case 0xd8:
					case 0xd9:
                    //case 0xe0:
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
						}
						break;
					#endregion
					#region [ da: ミキサーへチップ音追加 ]
					case 0xDA:
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
//Debug.WriteLine( "[DA(AddMixer)] BAR=" + pChip.n発声位置 / 384 + " ch=" + pChip.nチャンネル番号.ToString( "x2" ) + ", wav=" + pChip.n整数値.ToString( "x2" ) + ", time=" + pChip.n発声時刻ms );
							pChip.bHit = true;
							if ( listWAV.ContainsKey( pChip.n整数値・内部番号 ) )	// 参照が遠いので後日最適化する
							{
								CDTX.CWAV wc = listWAV[ pChip.n整数値・内部番号 ];
								for ( int i = 0; i < nPolyphonicSounds; i++ )
								{
									if ( wc.rSound[ i ] != null )
									{
										//CDTXMania.Sound管理.AddMixer( wc.rSound[ i ] );
										AddMixer( wc.rSound[ i ], pChip.b演奏終了後も再生が続くチップである );
									}
								}
							}
						}
						break;
					#endregion
					#region [ db: ミキサーからチップ音削除 ]
					case 0xDB:
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
//Debug.WriteLine( "[DB(RemoveMixer)] BAR=" + pChip.n発声位置 / 384 + " ch=" + pChip.nチャンネル番号.ToString( "x2" ) + ", wav=" + pChip.n整数値.ToString( "x2" ) + ", time=" + pChip.n発声時刻ms );
							pChip.bHit = true;
							if ( listWAV.ContainsKey( pChip.n整数値・内部番号 ) )	// 参照が遠いので後日最適化する
							{
							    CDTX.CWAV wc = listWAV[ pChip.n整数値・内部番号 ];
							    for ( int i = 0; i < nPolyphonicSounds; i++ )
							    {
									if ( wc.rSound[ i ] != null )
									{
										//CDTXMania.Sound管理.RemoveMixer( wc.rSound[ i ] );
										if ( !wc.rSound[ i ].b演奏終了後も再生が続くチップである )	// #32248 2013.10.16 yyagi
										{															// DTX終了後も再生が続くチップの0xDB登録をなくすことはできず。
											RemoveMixer( wc.rSound[ i ] );							// (ミキサー解除のタイミングが遅延する場合の対応が面倒なので。)
										}															// そこで、代わりにフラグをチェックしてミキサー削除ロジックへの遷移をカットする。
									}
							    }
							}
						}
						break;
                    #endregion

                    #region[ dc-df:太鼓(特殊命令) ]
                    case 0xDC: //DELAY
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
							if ( dTX.listDELAY.ContainsKey( pChip.n整数値・内部番号 ) )
							{
								//this.actPlayInfo.dbBPM = ( dTX.listBPM[ pChip.n整数値・内部番号 ].dbBPM値 * ( ( (double) configIni.n演奏速度 ) / 20.0 ) );// + dTX.BASEBPM;
							}
						}
                        break;
                    case 0xDD: //譜面分岐条件リセット
                        if( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
                        {
                            this.tBranchReset();
                            pChip.bHit = true;
                        }
                        break;
                    case 0xDE: //譜面分岐スタート
                        //可視化
                        //CDTXMania.act文字コンソール.tPrint( 414 + pChip.nバーからの距離dot.Taiko + 4, 192, C文字コンソール.Eフォント種別.白, "BRANCH START" + "  " + pChip.n整数値.ToString() );
                        if( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
                        {
                            if( !this.bLEVELHOLD )
                            {
                                this.tBranchJudge(this.nBranch_roll, this.nBranch_Perfect, this.nBranch_Good, this.nBranch_Miss);
                                this.t分岐処理( this.n次回のコース, CDTXMania.DTX.listBRANCH[ this.n分岐した回数 ].n命令時のChipList番号 );
                                CDTXMania.stage演奏ドラム画面.actLaneTaiko.t分岐レイヤー・コース変化( this.n現在のコース, this.n次回のコース );
                                CDTXMania.stage演奏ドラム画面.actMtaiko.tBranchEvent( this.n現在のコース, this.n次回のコース );
                                if( CDTXMania.DTX.listBRANCH[ this.n分岐した回数 ].n分岐の種類 == 0 )
                                {
                                    this.n現在のコース = this.n次回のコース;
                                }
                            }
                            //if( n現在のコース == pChip.nコース )
                                this.n分岐した回数++;

                            if( CDTXMania.ConfigIni.bAutoSection )
                            {
                                this.tBranchReset();
                            }


                            pChip.bHit = true;
                        }
                        break;
                    
                    case 0xDF:
                        //CDTXMania.act文字コンソール.tPrint( 414 + pChip.nバーからの距離dot.Taiko + 4, 192 + 16, C文字コンソール.Eフォント種別.白, "0XDF");
                        if( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
                        {
                            //精度分岐だとなんでか知らんが0xDE→0xDFにならない...
                            this.n現在のコース = this.n次回のコース;
                            this.b強制的に分岐させた = false;
                            this.chip現在処理中の連打チップ = null;

                            pChip.bHit = true;
                        }
                        break;
                    case 0xE0:
                        if( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
                        {
                            //#BARLINEONと#BARLINEOFF
                            //演奏中は使用しません。
                        }
                        break;
                    case 0xE1:
                        if( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
                        {
                            if( this.n現在のコース == pChip.nコース )
                            {
                                //LEVELHOLD
                                this.bLEVELHOLD = true;
                            }
                        }
                        break;
                    #endregion

                    #region[ ff: 譜面の強制終了 ]
                    //バグで譜面がとてつもないことになっているため、#ENDがきたらこれを差し込む。
                    case 0xFF:
                        if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
                            return true;
                        }
                        break;
					#endregion
					#region [ その他(未定義) ]
					default:
						if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
						{
							pChip.bHit = true;
						}
						break;
					#endregion 


                }

            }
			return false;
		}

        protected bool t進行描画・チップ・連打( E楽器パート ePlayMode )
		{
			if ( ( base.eフェーズID == CStage.Eフェーズ.演奏_STAGE_FAILED ) || ( base.eフェーズID == CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト ) )
			{
				return true;
			}
			if ( ( this.n現在のトップChip == -1 ) || ( this.n現在のトップChip >= listChip.Count ) )
			{
				return true;
			}
			if ( this.n現在のトップChip == -1 )
			{
				return true;
			}

			//double speed = 264.0;	// BPM150の時の1小節の長さ[dot]
			const double speed = 324.0;	// BPM150の時の1小節の長さ[dot]

			//double ScrollSpeedDrums = (( this.act譜面スクロール速度.db現在の譜面スクロール速度.Drums + 1.0 ) * speed ) * 0.5 * 37.5 / 60000.0;
            double ScrollSpeedDrums = ((  this.act譜面スクロール速度.db現在の譜面スクロール速度.Drums + 1.0 ) * speed ) * 0.5 * 37.5 / 60000.0;
			double ScrollSpeedGuitar = ( this.act譜面スクロール速度.db現在の譜面スクロール速度.Guitar + 1.0 ) * 0.5 * 0.5 * 37.5 * speed / 60000.0;
			double ScrollSpeedBass = ( this.act譜面スクロール速度.db現在の譜面スクロール速度.Bass + 1.0 ) * 0.5 * 0.5 * 37.5 * speed / 60000.0;
            double ScrollSpeedTaiko = (( this.act譜面スクロール速度.db現在の譜面スクロール速度.Drums + 1.0 ) * speed ) * 0.5 * 37.5 / 60000.0;

			CDTX dTX = CDTXMania.DTX;
			CConfigIni configIni = CDTXMania.ConfigIni;
            this.bUseBranch = dTX.bチップがある.Branch;

            //for ( int nCurrentTopChip = this.n現在のトップChip; nCurrentTopChip < dTX.listChip.Count; nCurrentTopChip++ )
            for ( int nCurrentTopChip = dTX.listChip.Count - 1; nCurrentTopChip > 0; nCurrentTopChip-- )
			{
				CDTX.CChip pChip = dTX.listChip[ nCurrentTopChip ];
//Debug.WriteLine( "nCurrentTopChip=" + nCurrentTopChip + ", ch=" + pChip.nチャンネル番号.ToString("x2") + ", 発音位置=" + pChip.n発声位置 + ", 発声時刻ms=" + pChip.n発声時刻ms );
				pChip.nバーからの距離dot.Drums = (int) ( ( pChip.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻 ) * ScrollSpeedDrums );
				pChip.nバーからの距離dot.Guitar = (int) ( ( pChip.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻 ) * ScrollSpeedGuitar );
				pChip.nバーからの距離dot.Bass = (int) ( ( pChip.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻 ) * ScrollSpeedBass );
                pChip.nバーからの距離dot.Taiko = (int) ( ( ( pChip.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻 ) * pChip.dbBPM * pChip.dbSCROLL * ( this.act譜面スクロール速度.db現在の譜面スクロール速度.Drums + 1.5 ) ) / 628.7 );
                pChip.nバーからのノーツ末端距離dot.Drums = 0;
                pChip.nバーからのノーツ末端距離dot.Guitar = 0;
                pChip.nバーからのノーツ末端距離dot.Bass = 0;
                if( pChip.nノーツ終了時刻ms != 0 )
                    pChip.nバーからのノーツ末端距離dot.Taiko = (int) ( ( ( pChip.nノーツ終了時刻ms - CSound管理.rc演奏用タイマ.n現在時刻 ) * pChip.dbBPM * pChip.dbSCROLL * ( this.act譜面スクロール速度.db現在の譜面スクロール速度.Drums + 1.5 ) ) / 628.7 );

				bool bPChipIsAutoPlay = bCheckAutoPlay( pChip );

				int nInputAdjustTime = ( bPChipIsAutoPlay || (pChip.e楽器パート == E楽器パート.UNKNOWN) )? 0 : this.nInputAdjustTimeMs[ (int) pChip.e楽器パート ];

				int instIndex = (int) pChip.e楽器パート;

                if( pChip.nチャンネル番号 >= 0x93 && pChip.nチャンネル番号 <= 0x96 )//|| pChip.nチャンネル番号 == 0x9A )
                {
				    if ( ( !pChip.bHit ) &&
                       ( ( ( pChip.n発声時刻ms + 120 ) < CSound管理.rc演奏用タイマ.n現在時刻ms ) && ( this.e指定時刻からChipのJUDGEを返す( CSound管理.rc演奏用タイマ.n現在時刻, pChip, nInputAdjustTime ) == E判定.Miss ) ) )
                       //( ( pChip.nバーからの距離dot.Taiko < -40 ) && ( this.e指定時刻からChipのJUDGEを返す( CSound管理.rc演奏用タイマ.n現在時刻, pChip, nInputAdjustTime ) == E判定.Miss ) ) )
				    {
    				    this.tチップのヒット処理( CSound管理.rc演奏用タイマ.n現在時刻, pChip );
	    			}
                }
                else if( pChip.nチャンネル番号 >= 0x97 && pChip.nチャンネル番号 <= 0x98 )//|| pChip.nチャンネル番号 == 0x9A )
                {
				    if ( ( !pChip.bHit ) &&
                       ( ( pChip.nバーからのノーツ末端距離dot.Taiko < -500 ) ) )
				    {
    				    this.tチップのヒット処理( CSound管理.rc演奏用タイマ.n現在時刻, pChip );
	    			}
                }
                else
                {
				    if ( ( ( pChip.e楽器パート != E楽器パート.UNKNOWN ) && !pChip.bHit ) &&
				       ( ( pChip.nバーからの距離dot[ instIndex ] < -40 ) && ( this.e指定時刻からChipのJUDGEを返す( CSound管理.rc演奏用タイマ.n現在時刻, pChip, nInputAdjustTime ) == E判定.Miss ) ) )
				    {
    				    this.tチップのヒット処理( CSound管理.rc演奏用タイマ.n現在時刻, pChip );
	    			}
                }

				switch ( pChip.nチャンネル番号 )
				{
                    #region[ 97～9B: 連打 ]
                    case 0x97: //連打
                    case 0x98: //連打(大)
                    case 0x99: //風船
                    case 0x9A: //連打終了
                    case 0x9B:
                        {
                            this.t進行描画・チップ・Taiko連打( configIni, ref dTX, ref pChip );
                        }
                        break;
                    #endregion
                }

            }
			return false;
		}

        public void tBranchReset()
        {
            this.nBranch_roll = 0;
            this.nBranch_Perfect = 0;
            this.nBranch_Good = 0;
            this.nBranch_Miss = 0;
        }

        public void tBranchJudge( int n連打数, int n良, int n可, int n不可 )
        {
            if( this.b強制的に分岐させた ) return;

            int n種類 = CDTXMania.DTX.listBRANCH[this.n分岐した回数].n分岐の種類;

            double dbRate = 0;

            if( ( n良 + n可 + n不可 ) != 0 )
            {
                dbRate = ((double)n良 / (double)(n良 + n可 + n不可)) * 100.0;
            }


            if( n種類 == 0 )
            {
                if( dbRate < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A )
                {
                    this.n次回のコース = 0;
                }
                else if( dbRate >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A && dbRate < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                {
                    this.n次回のコース = 1;
                }
                else if( dbRate >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                {
                    this.n次回のコース = 2;
                }
            }
            else if( n種類 == 1 )
            {
                if( n連打数 < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A )
                {
                    this.n次回のコース = 0;
                }
                else if( n連打数 >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A && n連打数 < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                {
                    this.n次回のコース = 1;
                }
                else if( n連打数 >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                {
                    this.n次回のコース = 2;
                }

                this.nBranch_roll = 0;
            }
        }

        public int nBranchJudge( int n連打数, int n良, int n可, int n不可 )
        {

            int n種類 = CDTXMania.DTX.listBRANCH[this.n分岐した回数].n分岐の種類;
            int n次回のコース = 0;

            double dbRate = 0;

            if( ( n良 + n可 + n不可 ) != 0 )
            {
                dbRate = ((double)n良 / (double)(n良 + n可 + n不可)) * 100.0;
            }


            if( n種類 == 0 )
            {
                if( dbRate < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A )
                {
                    n次回のコース = 0;
                }
                else if( dbRate >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A && dbRate < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                {
                    n次回のコース = 1;
                }
                else if( dbRate >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                {
                    n次回のコース = 2;
                }
            }
            else if( n種類 == 1 )
            {
                if( n連打数 < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A )
                {
                    n次回のコース = 0;
                }
                else if( n連打数 >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A && n連打数 < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                {
                    n次回のコース = 1;
                }
                else if( n連打数 >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                {
                    n次回のコース = 2;
                }
            }

            return n次回のコース;
        }
        public void t分岐処理( int n分岐先, int n分岐開始位置のChip番号 )
        {
            int n消すコース1 = 1;
            int n消すコース2 = 2;

            switch( n分岐先 )
            {
                case 0:
                    n消すコース1 = 1;
                    n消すコース2 = 2;
                    break;
                case 1:
                    n消すコース1 = 0;
                    n消すコース2 = 2;
                    break;
                case 2:
                    n消すコース1 = 0;
                    n消すコース2 = 1;
                    break;
            }
            //2015.06.24 ソート処理で正確な番号が取得できなくなっていたので、とりあえずこれで対応。
            //2015.07.21 「卓球de脱臼」でバグが発生するのを修正完了。未ヒットチップを未来方向のみ検索して対応。
            

            //ソート後の譜面分岐開始位置のchip番号を正常に取得できないため、ここで現在の時刻から一番近い位置の音符を消す処理を作る必要がある。
            //CDTX.CChip chipNoHit = this.r指定時刻に一番近い未ヒットChip( CSound管理.rc演奏用タイマ.n現在時刻ms, 0xDF, 0, 10000 );
            CDTX.CChip chipNoHit = this.r指定時刻に一番近い未ヒットChip( CSound管理.rc演奏用タイマ.n現在時刻ms + 1, 0xDF, 0, 10000 ); //とりあえず検索開始を1ms後にして対応。
            if( chipNoHit == null )
                return;

            n分岐開始位置のChip番号 = chipNoHit.n整数値;
            

            for( int A = n分岐開始位置のChip番号; A < CDTXMania.DTX.listChip.Count; A++ )
            {
                //if( CDTXMania.DTX.listChip[ A ].n発声時刻ms < CDTXMania.DTX.listBRANCH[ this.n分岐した回数 ].db分岐時間ms )
                if( CDTXMania.DTX.listChip[ A ].n整数値 < n分岐開始位置のChip番号 )
                {
                    CDTXMania.DTX.listChip[ A ].b可視 = true;
                    continue;
                }

                if( CDTXMania.DTX.listChip[ A ].nチャンネル番号 == 0x01 ) continue;
                //if( CDTXMania.DTX.listChip[ A ].nチャンネル番号 == 0x50 ) continue;
                if( CDTXMania.DTX.listChip[ A ].nチャンネル番号 == 0x9C ) continue;
                if( CDTXMania.DTX.listChip[ A ].nチャンネル番号 == 0xDD ) continue;
                if( CDTXMania.DTX.listChip[ A ].nチャンネル番号 == 0xDE ) continue;
                if( CDTXMania.DTX.listChip[ A ].nチャンネル番号 == 0xDF ) continue;

                if( CDTXMania.DTX.listChip[ A ].nコース == n消すコース1 || CDTXMania.DTX.listChip[ A ].nコース == n消すコース2 )
                {
                    CDTXMania.DTX.listChip[ A ].b可視 = false;
                }
                else
                {
                    CDTXMania.DTX.listChip[ A ].b可視 = true;
                    CDTXMania.DTX.listChip[ A ].eNoteState = ENoteState.none;
                }
            }
        }

		public void t再読込()
		{
			CDTXMania.DTX.t全チップの再生停止とミキサーからの削除();
			this.eフェードアウト完了時の戻り値 = E演奏画面の戻り値.再読込・再演奏;
			base.eフェーズID = CStage.Eフェーズ.演奏_再読込;
			this.bPAUSE = false;
		}

		public void t停止()
		{
			CDTXMania.DTX.t全チップの再生停止とミキサーからの削除();
			this.actAVI.Stop();
			this.actPanel.Stop();				// PANEL表示停止
			CDTXMania.Timer.t一時停止();		// 再生時刻カウンタ停止

			this.n現在のトップChip = CDTXMania.DTX.listChip.Count - 1;	// 終端にシーク

			// 自分自身のOn活性化()相当の処理もすべき。
		}

		public void t演奏位置の変更( int nStartBar )
		{
			// まず全サウンドオフにする
			CDTXMania.DTX.t全チップの再生停止();
			this.actAVI.Stop();

			#region [ 再生開始小節の変更 ]
			nStartBar++;									// +1が必要

			#region [ 演奏済みフラグのついたChipをリセットする ]
			for ( int i = 0; i < CDTXMania.DTX.listChip.Count; i++ )
			{
				CDTX.CChip pChip = CDTXMania.DTX.listChip[ i ];
				if ( pChip.bHit )
				{
					CDTX.CChip p = (CDTX.CChip) pChip.Clone();
					p.bHit = false;
					CDTXMania.DTX.listChip[ i ] = p;
				}
			}
			#endregion

			#region [ 処理を開始するチップの特定 ]
			//for ( int i = this.n現在のトップChip; i < CDTXMania.DTX.listChip.Count; i++ )
			bool bSuccessSeek = false;
			for ( int i = 0; i < CDTXMania.DTX.listChip.Count; i++ )
			{
				CDTX.CChip pChip = CDTXMania.DTX.listChip[ i ];
				if ( pChip.n発声位置 < 384 * nStartBar )
				{
					continue;
				}
				else
				{
					bSuccessSeek = true;
					this.n現在のトップChip = i;
					break;
				}
			}
			if ( !bSuccessSeek )
			{
				// this.n現在のトップChip = CDTXMania.DTX.listChip.Count - 1;
				this.n現在のトップChip = 0;		// 対象小節が存在しないなら、最初から再生
			}
			#endregion

			#region [ 演奏開始の発声時刻msを取得し、タイマに設定 ]
			int nStartTime = CDTXMania.DTX.listChip[ this.n現在のトップChip ].n発声時刻ms;

			CSound管理.rc演奏用タイマ.tリセット();	// これでPAUSE解除されるので、次のPAUSEチェックは不要
			//if ( !this.bPAUSE )
			//{
				CSound管理.rc演奏用タイマ.t一時停止();
			//}
			CSound管理.rc演奏用タイマ.n現在時刻 = nStartTime;
			#endregion

			List<CSound> pausedCSound = new List<CSound>();

			#region [ BGMやギターなど、演奏開始のタイミングで再生がかかっているサウンドのの途中再生開始 ] // (CDTXのt入力・行解析・チップ配置()で小節番号が+1されているのを削っておくこと)
			for ( int i = this.n現在のトップChip; i >= 0; i-- )
			{
				CDTX.CChip pChip = CDTXMania.DTX.listChip[ i ];
				int nDuration = pChip.GetDuration();

				if ( ( pChip.n発声時刻ms + nDuration > 0 ) && ( pChip.n発声時刻ms <= nStartTime ) && ( nStartTime <= pChip.n発声時刻ms + nDuration ) )
				{
					if ( pChip.bWAVを使うチャンネルである && ( pChip.nチャンネル番号 >> 4 ) != 0xB )	// wav系チャンネル、且つ、空打ちチップではない
					{
						CDTX.CWAV wc;
						bool b = CDTXMania.DTX.listWAV.TryGetValue( pChip.n整数値・内部番号, out wc );
						if ( !b ) continue;

						if ( ( wc.bIsBGMSound && CDTXMania.ConfigIni.bBGM音を発声する ) || ( !wc.bIsBGMSound ) )
						{
							CDTXMania.DTX.tチップの再生( pChip, CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻 + pChip.n発声時刻ms, (int) Eレーン.BGM, CDTXMania.DTX.nモニタを考慮した音量( E楽器パート.UNKNOWN ) );
							#region [ PAUSEする ]
							int j = wc.n現在再生中のサウンド番号;
							if ( wc.rSound[ j ] != null )
							{
							    wc.rSound[ j ].t再生を一時停止する();
							    wc.rSound[ j ].t再生位置を変更する( nStartTime - pChip.n発声時刻ms );
							    pausedCSound.Add( wc.rSound[ j ] );
							}
							#endregion
						}
					}
				}
			}
			#endregion
			#region [ 演奏開始時点で既に表示されているBGAとAVIの、シークと再生 ]
			this.actAVI.SkipStart( nStartTime );
			#endregion
			#region [ PAUSEしていたサウンドを一斉に再生再開する(ただしタイマを止めているので、ここではまだ再生開始しない) ]
			foreach ( CSound cs in pausedCSound )
			{
				cs.tサウンドを再生する();
			}
			pausedCSound.Clear();
			pausedCSound = null;
			#endregion
			#region [ タイマを再開して、PAUSEから復帰する ]
			CSound管理.rc演奏用タイマ.n現在時刻 = nStartTime;
			CDTXMania.Timer.tリセット();						// これでPAUSE解除されるので、3行先の再開()は不要
			CDTXMania.Timer.n現在時刻 = nStartTime;				// Debug表示のTime: 表記を正しくするために必要
			CSound管理.rc演奏用タイマ.t再開();
			//CDTXMania.Timer.t再開();
			this.bPAUSE = false;								// システムがPAUSE状態だったら、強制解除
			this.actPanel.Start();
			#endregion
			#endregion
		}


		/// <summary>
		/// DTXV用の設定をする。(全AUTOなど)
		/// 元の設定のバックアップなどはしないので、あとでConfig.iniを上書き保存しないこと。
		/// </summary>
		protected void tDTXV用の設定()
		{
			CDTXMania.ConfigIni.bAutoPlay.HH = true;
			CDTXMania.ConfigIni.bAutoPlay.SD = true;
			CDTXMania.ConfigIni.bAutoPlay.BD = true;
			CDTXMania.ConfigIni.bAutoPlay.HT = true;
			CDTXMania.ConfigIni.bAutoPlay.LT = true;
			CDTXMania.ConfigIni.bAutoPlay.CY = true;
			CDTXMania.ConfigIni.bAutoPlay.FT = true;
			CDTXMania.ConfigIni.bAutoPlay.RD = true;
			CDTXMania.ConfigIni.bAutoPlay.LC = true;
            CDTXMania.ConfigIni.bAutoPlay.LP = true;
            CDTXMania.ConfigIni.bAutoPlay.LBD = true;
			CDTXMania.ConfigIni.bAutoPlay.GtR = true;
			CDTXMania.ConfigIni.bAutoPlay.GtB = true;
			CDTXMania.ConfigIni.bAutoPlay.GtB = true;
			CDTXMania.ConfigIni.bAutoPlay.GtPick = true;
			CDTXMania.ConfigIni.bAutoPlay.GtW = true;
			CDTXMania.ConfigIni.bAutoPlay.BsR = true;
			CDTXMania.ConfigIni.bAutoPlay.BsB = true;
			CDTXMania.ConfigIni.bAutoPlay.BsB = true;
			CDTXMania.ConfigIni.bAutoPlay.BsPick = true;
			CDTXMania.ConfigIni.bAutoPlay.BsW = true;

			this.bIsAutoPlay = CDTXMania.ConfigIni.bAutoPlay;

			CDTXMania.ConfigIni.bAVI有効 = true;
			CDTXMania.ConfigIni.bBGA有効 = true;
			for ( int i = 0; i < 3; i++ )
			{
				CDTXMania.ConfigIni.bGraph[ i ] = false;
				CDTXMania.ConfigIni.bHidden[ i ] = false;
				CDTXMania.ConfigIni.bLeft[ i ] = false;
				CDTXMania.ConfigIni.bLight[ i ] = false;
				CDTXMania.ConfigIni.bReverse[ i ] = false;
				CDTXMania.ConfigIni.bSudden[ i ] = false;
				CDTXMania.ConfigIni.eInvisible[ i ] = EInvisible.OFF;
				CDTXMania.ConfigIni.eRandom[ i ] = Eランダムモード.OFF;
				CDTXMania.ConfigIni.n表示可能な最小コンボ数[ i ] = 65535;
				CDTXMania.ConfigIni.判定文字表示位置[ i ] = E判定文字表示位置.表示OFF;
				// CDTXMania.ConfigIni.n譜面スクロール速度[ i ] = CDTXMania.ConfigIni.nViewerScrollSpeed[ i ];	// これだけはOn活性化()で行うこと。
																												// そうしないと、演奏開始直後にスクロール速度が変化して見苦しい。
			}

			CDTXMania.ConfigIni.eDark = Eダークモード.OFF;

			CDTXMania.ConfigIni.b演奏情報を表示する = CDTXMania.ConfigIni.bViewerShowDebugStatus;
			CDTXMania.ConfigIni.bフィルイン有効 = true;
			CDTXMania.ConfigIni.bScoreIniを出力する = false;
			CDTXMania.ConfigIni.bSTAGEFAILED有効 = false;
			CDTXMania.ConfigIni.bTight = false;
			CDTXMania.ConfigIni.bストイックモード = false;
			CDTXMania.ConfigIni.bドラム打音を発声する = true;
			CDTXMania.ConfigIni.bBGM音を発声する = true;

			CDTXMania.ConfigIni.nRisky = 0;
			CDTXMania.ConfigIni.nShowLagType = 0;
			CDTXMania.ConfigIni.bドラムコンボ表示 = true;
		}


		private bool bCheckAutoPlay( CDTX.CChip pChip )
		{
			bool bPChipIsAutoPlay = false;
			bool bGtBsR = ( ( pChip.nチャンネル番号 & 4 ) > 0 );
			bool bGtBsG = ( ( pChip.nチャンネル番号 & 2 ) > 0 );
			bool bGtBsB = ( ( pChip.nチャンネル番号 & 1 ) > 0 );
			bool bGtBsW = ( ( pChip.nチャンネル番号 & 0x0F ) == 0x08 );
			bool bGtBsO = ( ( pChip.nチャンネル番号 & 0x0F ) == 0x00 );
			//if ( (
			//        ( ( pChip.e楽器パート == E楽器パート.DRUMS ) && bIsAutoPlay[ this.nチャンネル0Atoレーン07[ pChip.nチャンネル番号 - 0x11 ] ] ) ||
			//        ( ( pChip.e楽器パート == E楽器パート.GUITAR ) && bIsAutoPlay.Guitar ) ) ||
			//        ( ( pChip.e楽器パート == E楽器パート.BASS ) && bIsAutoPlay.Bass )
			//  )
			////				if ((pChip.e楽器パート == E楽器パート.DRUMS) && bIsAutoPlay[this.nチャンネル0Atoレーン07[pChip.nチャンネル番号 - 0x11]])
			//{
			//    bPChipIsAutoPlay = true;
			//}

            if( pChip.nチャンネル番号 >= 0x93 && pChip.nチャンネル番号 <= 0x9F )
                return true;

			if ( pChip.e楽器パート == E楽器パート.DRUMS )
			{
				if ( bIsAutoPlay[ this.nチャンネル0Atoレーン07[ pChip.nチャンネル番号 - 0x11 ] ] )
				{
					bPChipIsAutoPlay = true;
				}
			}
			else if ( pChip.e楽器パート == E楽器パート.GUITAR )
			{
				//Trace.TraceInformation( "chip:{0}{1}{2} ", bGtBsR, bGtBsG, bGtBsB );
				//Trace.TraceInformation( "auto:{0}{1}{2} ", bIsAutoPlay[ (int) Eレーン.GtR ], bIsAutoPlay[ (int) Eレーン.GtG ], bIsAutoPlay[ (int) Eレーン.GtB ]);
				bPChipIsAutoPlay = true;
				if ( bIsAutoPlay[ (int) Eレーン.GtPick ] == false ) bPChipIsAutoPlay = false;
				else
				{
					if ( bGtBsR == true && bIsAutoPlay[ (int) Eレーン.GtR ] == false ) bPChipIsAutoPlay = false;
					else if ( bGtBsG == true && bIsAutoPlay[ (int) Eレーン.GtG ] == false ) bPChipIsAutoPlay = false;
					else if ( bGtBsB == true && bIsAutoPlay[ (int) Eレーン.GtB ] == false ) bPChipIsAutoPlay = false;
					else if ( bGtBsW == true && bIsAutoPlay[ (int) Eレーン.GtW ] == false ) bPChipIsAutoPlay = false;
					else if ( bGtBsO == true &&
						( bIsAutoPlay[ (int) Eレーン.GtR ] == false || bIsAutoPlay[ (int) Eレーン.GtG ] == false || bIsAutoPlay[ (int) Eレーン.GtB ] == false ) )
						bPChipIsAutoPlay = false;
				}
				//Trace.TraceInformation( "{0:x2}: {1}", pChip.nチャンネル番号, bPChipIsAutoPlay.ToString() );
			}
			else if ( pChip.e楽器パート == E楽器パート.BASS )
			{
				bPChipIsAutoPlay = true;
				if ( bIsAutoPlay[ (int) Eレーン.BsPick ] == false ) bPChipIsAutoPlay = false;
				else
				{
					if ( bGtBsR == true && bIsAutoPlay[ (int) Eレーン.BsR ] == false ) bPChipIsAutoPlay = false;
					else if ( bGtBsG == true && bIsAutoPlay[ (int) Eレーン.BsG ] == false ) bPChipIsAutoPlay = false;
					else if ( bGtBsB == true && bIsAutoPlay[ (int) Eレーン.BsB ] == false ) bPChipIsAutoPlay = false;
					else if ( bGtBsW == true && bIsAutoPlay[ (int) Eレーン.BsW ] == false ) bPChipIsAutoPlay = false;
					else if ( bGtBsO == true &&
						( bIsAutoPlay[ (int) Eレーン.BsR ] == false || bIsAutoPlay[ (int) Eレーン.BsG ] == false || bIsAutoPlay[ (int) Eレーン.BsB ] == false ) )
						bPChipIsAutoPlay = false;
				}
			}
			return bPChipIsAutoPlay;
		}

		protected abstract void t進行描画・チップ・ドラムス( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip );
		protected abstract void t進行描画・チップ本体・ドラムス( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip );
		protected abstract void t進行描画・チップ・Taiko( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip );
		protected abstract void t進行描画・チップ・Taiko連打( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip );
		//protected abstract void t進行描画・チップ・ギター( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip );
		protected abstract void t進行描画・チップ・ギターベース( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip, E楽器パート inst );

		protected void t進行描画・チップ・ギターベース( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip, E楽器パート inst,
			int barYNormal, int barYReverse, int showRangeY0, int showRangeY1, int openXg, int openXb,
			int rectOpenOffsetX, int rectOpenOffsetY, int openChipWidth, int chipHeight,
			int chipWidth, int guitarNormalX, int guitarLeftyX, int bassNormalX, int bassLeftyX, int drawDeltaX, int chipTexDeltaX )
		{
			int instIndex = (int) inst;
			if ( configIni.bGuitar有効 )
			{
				#region [ Invisible処理 ]
				if ( configIni.eInvisible[ instIndex ] != EInvisible.OFF )
				{
					cInvisibleChip.SetInvisibleStatus( ref pChip );
				}
				#endregion
				else
				{
					#region [ Hidden/Sudden処理 ]
					if ( configIni.bSudden[ instIndex ] )
					{
						pChip.b可視 = pChip.nバーからの距離dot[ instIndex ] < 200;
					}
					if ( configIni.bHidden[ instIndex ] && ( pChip.nバーからの距離dot[ instIndex ] < 100 ) )
					{
						pChip.b可視 = false;
					}
					#endregion
				}

				bool bChipHasR = ( ( pChip.nチャンネル番号 & 4 ) > 0 );
				bool bChipHasG = ( ( pChip.nチャンネル番号 & 2 ) > 0 );
				bool bChipHasB = ( ( pChip.nチャンネル番号 & 1 ) > 0 );
				bool bChipHasW = ( ( pChip.nチャンネル番号 & 0x0F ) == 0x08 );
				bool bChipIsO = ( ( pChip.nチャンネル番号 & 0x0F ) == 0x00 );

				//if ( ( configIni.bAutoPlay.Guitar && !pChip.bHit ) && ( pChip.nバーからの距離dot.Guitar < 0 ) )
				if ( ( !pChip.bHit ) && ( pChip.nバーからの距離dot[ instIndex ] < 0 ) )
				{
					int lo = ( inst == E楽器パート.GUITAR ) ? 0 : 3;	// lane offset
					bool autoR = ( inst == E楽器パート.GUITAR ) ? bIsAutoPlay.GtR : bIsAutoPlay.BsR;
					bool autoG = ( inst == E楽器パート.GUITAR ) ? bIsAutoPlay.GtG : bIsAutoPlay.BsG;
					bool autoB = ( inst == E楽器パート.GUITAR ) ? bIsAutoPlay.GtB : bIsAutoPlay.BsB;
					bool autoPick = ( inst == E楽器パート.GUITAR ) ? bIsAutoPlay.GtPick : bIsAutoPlay.BsPick;
					bool pushingR = CDTXMania.Pad.b押されている( inst, Eパッド.R );
					bool pushingG = CDTXMania.Pad.b押されている( inst, Eパッド.G );
					bool pushingB = CDTXMania.Pad.b押されている( inst, Eパッド.B );

					cInvisibleChip.StartSemiInvisible( inst );
					#region [ Chip Fire effects ]
					bool bSuccessOPEN = bChipIsO && ( autoR || !pushingR ) && ( autoG || !pushingG ) && ( autoB || !pushingB );
					if ( ( bChipHasR && ( autoR || pushingR ) && autoPick ) || bSuccessOPEN )
					{
						this.actChipFireGB.Start( 0 + lo, 演奏判定ライン座標 );
					}
					if ( ( bChipHasG && ( autoG || pushingG ) && autoPick ) || bSuccessOPEN )
					{
						this.actChipFireGB.Start( 1 + lo, 演奏判定ライン座標 );
					}
					if ( ( bChipHasB && ( autoB || pushingB ) && autoPick ) || bSuccessOPEN )
					{
						this.actChipFireGB.Start( 2 + lo, 演奏判定ライン座標 );
					}
					#endregion
					#region [ autopick ]
					if ( autoPick )
					{
						bool bMiss = true;
						if ( bChipHasR == autoR && bChipHasG == autoG && bChipHasB == autoB )		// autoレーンとチップレーン一致時はOK
						{																			// この条件を加えないと、同時に非autoレーンを押下している時にNGとなってしまう。
							bMiss = false;
						}
						else if ( ( autoR || ( bChipHasR == pushingR ) ) && ( autoG || ( bChipHasG == pushingG ) ) && ( autoB || ( bChipHasB == pushingB ) ) )
							// ( bChipHasR == ( pushingR | autoR ) ) && ( bChipHasG == ( pushingG | autoG ) ) && ( bChipHasB == ( pushingB | autoB ) ) )
						{
							bMiss = false;
						}
						else if ( ( ( bChipIsO == true ) && ( !pushingR | autoR ) && ( !pushingG | autoG ) && ( !pushingB | autoB ) ) )	// OPEN時
						{
							bMiss = false;
						}
						pChip.bHit = true;
						this.tサウンド再生( pChip, CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻 + pChip.n発声時刻ms, inst, dTX.nモニタを考慮した音量( inst ), false, bMiss );
						this.r次にくるギターChip = null;
						if ( !bMiss )
						{
							this.tチップのヒット処理( pChip.n発声時刻ms, pChip );
						}
						else
						{
							pChip.nLag = 0;		// tチップのヒット処理()の引数最後がfalseの時はpChip.nLagを計算しないため、ここでAutoPickかつMissのLag=0を代入
							this.tチップのヒット処理( pChip.n発声時刻ms, pChip, false );
						}
						int chWailingChip = ( inst == E楽器パート.GUITAR ) ? 0x28 : 0xA8;
						CDTX.CChip item = this.r指定時刻に一番近い未ヒットChip( pChip.n発声時刻ms, chWailingChip, this.nInputAdjustTimeMs[ instIndex ], 140 );
						if ( item != null && !bMiss )
						{
							this.queWailing[ instIndex ].Enqueue( item );
						}
					}
					#endregion
				}
				return;
			}	// end of "if configIni.bGuitar有効"
			if ( !pChip.bHit && ( pChip.nバーからの距離dot[ instIndex ] < 0 ) )	// Guitar/Bass無効の場合は、自動演奏する
			{
				pChip.bHit = true;
				this.tサウンド再生( pChip, CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻 + pChip.n発声時刻ms, inst, dTX.nモニタを考慮した音量( inst ) );
			}
		}

		
		protected virtual void t進行描画・チップ・ギターベース・ウェイリング( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip, E楽器パート inst )
		{
			int indexInst = (int) inst;

			pChip.bHit = true;
		}
		protected virtual void t進行描画・チップ・ギター・ウェイリング( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip )
		{
			t進行描画・チップ・ギターベース・ウェイリング( configIni, ref dTX, ref pChip, E楽器パート.GUITAR );
		}
		protected abstract void t進行描画・チップ・フィルイン( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip );
		protected abstract void t進行描画・チップ・小節線( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip );
		//protected abstract void t進行描画・チップ・ベース( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip );
		protected virtual void t進行描画・チップ・ベース・ウェイリング( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip )
		{
			t進行描画・チップ・ギターベース・ウェイリング( configIni, ref dTX, ref pChip, E楽器パート.BASS );
		}
		protected abstract void t進行描画・チップ・空打ち音設定・ドラム( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip );
		protected void t進行描画・チップアニメ()
		{
            if( this.b初めての進行描画 )
            {
                this.n制御タイマ = FDK.CSound管理.rc演奏用タイマ.n現在時刻;
            }

            long num = FDK.CSound管理.rc演奏用タイマ.n現在時刻;
			if( num < this.n制御タイマ )
			{
				this.n制御タイマ = num;
			}
			while( ( num - this.n制御タイマ ) >= 1000 )
			{
				if( this.n現在の音符の顔番号 == 0 )
				{
					this.n現在の音符の顔番号 = 1;
		        }
				else if( this.n現在の音符の顔番号 == 1 )
				{
					this.n現在の音符の顔番号 = 0;
		        }

                if( this.actCombo.n現在のコンボ数.Drums < 50 )
                {
                    this.n制御タイマ += 500;
                }
                else if(this.actCombo.n現在のコンボ数.Drums >= 50 && this.actCombo.n現在のコンボ数.Drums < 150)
                {
                    this.n制御タイマ += 400;
                }
                else if( this.actCombo.n現在のコンボ数.Drums >= 150 && this.actCombo.n現在のコンボ数.Drums < 250 )
                {
                    this.n制御タイマ += 300;
                }
                else if( this.actCombo.n現在のコンボ数.Drums >= 250 && this.actCombo.n現在のコンボ数.Drums < 300 )
                {
                    this.n制御タイマ += 200;
                }
                else if( this.actCombo.n現在のコンボ数.Drums >= 300 )
                {
                    this.n制御タイマ += 80;
                }
                else
                {
                    this.n制御タイマ += 500;
                }

		    }

            //CDTXMania.act文字コンソール.tPrint(0, 0, C文字コンソール.Eフォント種別.白, this.n現在の音符の顔番号.ToString());

            // 2015.03.17.kairera0467 CCounterだと途中で間隔とかを変更できなかったので廃止。

            //for ( int i = 0; i < 3; i++ )			// 0=drums, 1=guitar, 2=bass
            //{
            //    if ( this.ctチップ模様アニメ[ i ] != null )
            //    {
            //        this.ctチップ模様アニメ[ i ].t進行Loop();
            //    }

            //    if (this.actCombo.n現在のコンボ数.Drums >= 150 && this.actCombo.n現在のコンボ数.Drums <= 249)
            //    {
            //        this.ctチップ模様アニメ[0] = new CCounter(0, 1, 400, CDTXMania.Timer);
            //        this.ctチップ模様アニメ[i].t進行Loop();
            //    }
            //    else if (this.actCombo.n現在のコンボ数.Drums >= 250 && this.actCombo.n現在のコンボ数.Drums <= 299)
            //    {
            //        this.ctチップ模様アニメ[0] = new CCounter(0, 1, 200, CDTXMania.Timer);
            //        this.ctチップ模様アニメ[i].t進行Loop();
            //    }
            //    else if (this.actCombo.n現在のコンボ数.Drums >= 300)
            //    {
            //        this.ctチップ模様アニメ[0] = new CCounter(0, 1, 50, CDTXMania.Timer);
            //        this.ctチップ模様アニメ[i].t進行Loop();
            //    }

            //}
            //if ( this.ctWailingチップ模様アニメ != null )
            //{
            //    this.ctWailingチップ模様アニメ.t進行Loop();
            //}

            if( this.actChara.ct通常モーション != null )
            {
                //this.actChara.ct通常モーション.t進行LoopDb();
            }
            if( this.actChara.ctクリア通常モーション != null )
            {
                this.actChara.ctクリア通常モーション.t進行Loop();
            }
            if( this.actChara.ctゴーゴーモーション != null )
            {
                this.actChara.ctゴーゴーモーション.t進行LoopDb();
            }
		}

		protected bool t進行描画・フェードイン・アウト()
		{
			switch ( base.eフェーズID )
			{
				case CStage.Eフェーズ.共通_フェードイン:
					if ( this.actFI.On進行描画() != 0 )
					{
						base.eフェーズID = CStage.Eフェーズ.共通_通常状態;
					}
					break;

				case CStage.Eフェーズ.共通_フェードアウト:
				case CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト:
					if ( this.actFO.On進行描画() != 0 )
					{
						return true;
					}
					break;

				case CStage.Eフェーズ.演奏_STAGE_CLEAR_フェードアウト:
					if ( this.actFOClear.On進行描画() == 0 )
					{
						break;
					}
					return true;
		
			}
			return false;
		}
		protected void t進行描画・レーンフラッシュD()
		{
			//if ( ( CDTXMania.ConfigIni.eDark == Eダークモード.OFF ) && ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED ) && ( base.eフェーズID != CStage.Eフェーズ.演奏_STAGE_FAILED_フェードアウト ) )
			{
				this.actLaneFlushD.On進行描画();
			}
		}
		protected void t進行描画・レーンフラッシュGB()
		{
			if ( ( CDTXMania.ConfigIni.eDark == Eダークモード.OFF ) && CDTXMania.ConfigIni.bGuitar有効 )
			{
				this.actLaneFlushGB.On進行描画();
			}
		}
		protected abstract void t進行描画・演奏情報();
		protected void t進行描画・演奏情報(int x, int y)
		{
			if ( !CDTXMania.ConfigIni.b演奏情報を表示しない )
			{
				this.actPlayInfo.t進行描画( x, y );
			}
		}
		protected void t進行描画・背景()
		{
			if ( this.tx背景 != null )
			{
				this.tx背景.t2D描画( CDTXMania.app.Device, 0, 0 );
			}
		}

		protected void t進行描画・判定ライン()
		{
			if ( CDTXMania.ConfigIni.eDark != Eダークモード.FULL )
			{
				int y = CDTXMania.ConfigIni.bReverse.Drums ? 53 - 演奏判定ライン座標.nJudgeLinePosY_delta.Drums : 567 + 演奏判定ライン座標.nJudgeLinePosY_delta.Drums;
																// #31602 2013.6.23 yyagi 描画遅延対策として、判定ラインの表示位置をオフセット調整できるようにする
				if ( this.txヒットバー != null )
				{
				    this.txヒットバー.t2D描画( CDTXMania.app.Device, 295, y, new Rectangle( 0, 0, 558, 6 ) );
				}
			}
		}
		protected void t進行描画・判定文字列()
		{
			this.actJudgeString.t進行描画( 演奏判定ライン座標 );
		}
		protected void t進行描画・判定文字列1・通常位置指定の場合()
		{
			if ( ( (E判定文字表示位置) CDTXMania.ConfigIni.判定文字表示位置.Drums ) != E判定文字表示位置.コンボ下 )	// 判定ライン上または横
			{
				this.actJudgeString.t進行描画( 演奏判定ライン座標 );
			}
		}
		protected void t進行描画・判定文字列2・判定ライン上指定の場合()
		{
			if ( ( (E判定文字表示位置) CDTXMania.ConfigIni.判定文字表示位置.Drums ) == E判定文字表示位置.コンボ下 )	// 判定ライン上または横
			{
				this.actJudgeString.t進行描画( 演奏判定ライン座標 );
			}
		}

		protected void t進行描画・譜面スクロール速度()
		{
			this.act譜面スクロール速度.On進行描画();
		}

		protected abstract void t背景テクスチャの生成();
		protected void t背景テクスチャの生成( string DefaultBgFilename, Rectangle bgrect, string bgfilename )
		{
            try
            {
                this.tx背景 = CDTXMania.tテクスチャの生成( CSkin.Path( DefaultBgFilename ) );
            }
            catch
            {
                this.tx背景 = null;
            }
		}

		protected virtual void t入力処理・ギター()
		{
			t入力処理・ギターベース( E楽器パート.GUITAR );
		}
		protected virtual void t入力処理・ベース()
		{
			t入力処理・ギターベース( E楽器パート.BASS );
		}


		protected virtual void t入力処理・ギターベース(E楽器パート inst)
		{
			int indexInst = (int) inst;
			#region [ スクロール速度変更 ]
			if ( CDTXMania.Pad.b押されている( inst, Eパッド.Decide ) && CDTXMania.Pad.b押された( inst, Eパッド.B ) )
			{
				CDTXMania.ConfigIni.n譜面スクロール速度[indexInst] = Math.Min( CDTXMania.ConfigIni.n譜面スクロール速度[indexInst] + 1, 0x7cf );
			}
			if ( CDTXMania.Pad.b押されている( inst, Eパッド.Decide ) && CDTXMania.Pad.b押された( inst, Eパッド.R ) )
			{
				CDTXMania.ConfigIni.n譜面スクロール速度[indexInst] = Math.Max( CDTXMania.ConfigIni.n譜面スクロール速度[indexInst] - 1, 0 );
			}
			#endregion

			if ( !CDTXMania.ConfigIni.bGuitar有効 || !CDTXMania.DTX.bチップがある[indexInst] )
			{
				return;
			}

			int R = ( inst == E楽器パート.GUITAR ) ? 0 : 3;
			int G = R + 1;
			int B = R + 2;
			bool autoW =	( inst == E楽器パート.GUITAR ) ? bIsAutoPlay.GtW : bIsAutoPlay.BsW;
			bool autoR =	( inst == E楽器パート.GUITAR ) ? bIsAutoPlay.GtR : bIsAutoPlay.BsR;
			bool autoG =	( inst == E楽器パート.GUITAR ) ? bIsAutoPlay.GtG : bIsAutoPlay.BsG;
			bool autoB =	( inst == E楽器パート.GUITAR ) ? bIsAutoPlay.GtB : bIsAutoPlay.BsB;
			bool autoPick =	( inst == E楽器パート.GUITAR ) ? bIsAutoPlay.GtPick : bIsAutoPlay.BsPick;
			int nAutoW = ( autoW ) ? 8 : 0;
			int nAutoR = ( autoR ) ? 4 : 0;
			int nAutoG = ( autoG ) ? 2 : 0;
			int nAutoB = ( autoB ) ? 1 : 0;
			int nAutoMask = nAutoW | nAutoR | nAutoG | nAutoB;

//			if ( bIsAutoPlay[ (int) Eレーン.Guitar - 1 + indexInst ] )	// このような、バグの入りやすい書き方(GT/BSのindex値が他と異なる)はいずれ見直したい
//			{
			CDTX.CChip chip = this.r次に来る指定楽器Chipを更新して返す(inst);
			if ( chip != null )	
			{
			}
//			else
			{
				int pushingR = CDTXMania.Pad.b押されている( inst, Eパッド.R ) ? 4 : 0;
				this.t入力メソッド記憶( inst );
				int pushingG = CDTXMania.Pad.b押されている( inst, Eパッド.G ) ? 2 : 0;
				this.t入力メソッド記憶( inst );
				int pushingB = CDTXMania.Pad.b押されている( inst, Eパッド.B ) ? 1 : 0;
				this.t入力メソッド記憶( inst );
				int flagRGB = pushingR | pushingG | pushingB;

				// auto pickだとここから先に行かないので注意
				List<STInputEvent> events = CDTXMania.Pad.GetEvents( inst, Eパッド.Pick );
				if ( ( events != null ) && ( events.Count > 0 ) )
				{
					foreach ( STInputEvent eventPick in events )
					{
						if ( !eventPick.b押された )
						{
							continue;
						}
						this.t入力メソッド記憶( inst );
						long nTime = eventPick.nTimeStamp - CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻;
						int chWailingSound = ( inst == E楽器パート.GUITAR ) ? 0x2F : 0xAF;
						CDTX.CChip pChip = this.r指定時刻に一番近い未ヒットChip( nTime, chWailingSound, this.nInputAdjustTimeMs[indexInst] );	// E楽器パート.GUITARなチップ全てにヒットする
						E判定 e判定 = this.e指定時刻からChipのJUDGEを返す( nTime, pChip, this.nInputAdjustTimeMs[indexInst] );
//Trace.TraceInformation("ch={0:x2}, mask1={1:x1}, mask2={2:x2}", pChip.nチャンネル番号,  ( pChip.nチャンネル番号 & ~nAutoMask ) & 0x0F, ( flagRGB & ~nAutoMask) & 0x0F );
						if ( ( pChip != null ) && ( ( ( pChip.nチャンネル番号 & ~nAutoMask ) & 0x0F ) == ( ( flagRGB & ~nAutoMask) & 0x0F ) ) && ( e判定 != E判定.Miss ) )
						{
							bool bChipHasR = ( ( pChip.nチャンネル番号 & 4 ) > 0 );
							bool bChipHasG = ( ( pChip.nチャンネル番号 & 2 ) > 0 );
							bool bChipHasB = ( ( pChip.nチャンネル番号 & 1 ) > 0 );
							bool bChipHasW = ( ( pChip.nチャンネル番号 & 0x0F ) == 0x08 );
							bool bChipIsO = ( ( pChip.nチャンネル番号 & 0x0F ) == 0x00 );
							bool bSuccessOPEN = bChipIsO && ( autoR || pushingR == 0 ) && ( autoG || pushingG == 0 ) && ( autoB || pushingB == 0 );
							if ( ( bChipHasR && ( autoR || pushingR != 0 ) ) || bSuccessOPEN )
							//if ( ( pushingR != 0 ) || autoR || ( flagRGB == 0 ) )
							{
								this.actChipFireGB.Start( R, 演奏判定ライン座標 );
							}
							if ( ( bChipHasG && ( autoG || pushingG != 0 ) ) || bSuccessOPEN )
							//if ( ( pushingG != 0 ) || autoG || ( flagRGB == 0 ) )
							{
								this.actChipFireGB.Start( G, 演奏判定ライン座標 );
							}
							if ( ( bChipHasB && ( autoB || pushingB != 0 ) ) || bSuccessOPEN )
							//if ( ( pushingB != 0 ) || autoB || ( flagRGB == 0 ) )
							{
								this.actChipFireGB.Start( B, 演奏判定ライン座標 );
							}
							this.tチップのヒット処理( nTime, pChip );
							this.tサウンド再生( pChip, CSound管理.rc演奏用タイマ.nシステム時刻, inst, CDTXMania.ConfigIni.n手動再生音量, CDTXMania.ConfigIni.b演奏音を強調する[indexInst], e判定 == E判定.Poor );
							int chWailingChip = ( inst == E楽器パート.GUITAR ) ? 0x28 : 0xA8;
							CDTX.CChip item = this.r指定時刻に一番近い未ヒットChip( nTime, chWailingChip, this.nInputAdjustTimeMs[ indexInst ], 140 );
							if ( item != null )
							{
								this.queWailing[indexInst].Enqueue( item );
							}
							continue;
						}

						// 以下、間違いレーンでのピック時
						CDTX.CChip NoChipPicked = ( inst == E楽器パート.GUITAR ) ? this.r現在の空うちギターChip : this.r現在の空うちベースChip;
						if ( ( NoChipPicked != null ) || ( ( NoChipPicked = this.r指定時刻に一番近いChip・ヒット未済問わず不可視考慮( nTime, chWailingSound, this.nInputAdjustTimeMs[indexInst] ) ) != null ) )
						{
							this.tサウンド再生( NoChipPicked, CSound管理.rc演奏用タイマ.nシステム時刻, inst, CDTXMania.ConfigIni.n手動再生音量, CDTXMania.ConfigIni.b演奏音を強調する[indexInst], true );
						}
						if ( !CDTXMania.ConfigIni.bLight[indexInst] )
						{
							this.tチップのヒット処理・BadならびにTight時のMiss( inst );
						}
					}
				}
				List<STInputEvent> list = CDTXMania.Pad.GetEvents(inst, Eパッド.Wail );
				if ( ( list != null ) && ( list.Count > 0 ) )
				{
					foreach ( STInputEvent eventWailed in list )
					{
						if ( !eventWailed.b押された )
						{
							continue;
						}
						DoWailingFromQueue( inst, eventWailed.nTimeStamp,  autoW );
					}
				}
			}
		}

		private void DoWailingFromQueue( E楽器パート inst, long nTimeStamp_Wailed,  bool autoW )
		{
			int indexInst = (int) inst;
			long nTimeWailed = nTimeStamp_Wailed - CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻;
			CDTX.CChip chipWailing;
			while ( ( this.queWailing[ indexInst ].Count > 0 ) && ( ( chipWailing = this.queWailing[ indexInst ].Dequeue() ) != null ) )
			{
				if ( ( nTimeWailed - chipWailing.n発声時刻ms ) <= 1000 )		// #24245 2011.1.26 yyagi: 800 -> 1000
				{
					chipWailing.bHit = true;
					this.actWailingBonus.Start( inst, this.r現在の歓声Chip[ indexInst ] );
					//if ( !bIsAutoPlay[indexInst] )
					if ( !autoW )
					{
						int nCombo = ( this.actCombo.n現在のコンボ数[ indexInst ] < 500 ) ? this.actCombo.n現在のコンボ数[ indexInst ] : 500;
						this.actScore.Add( inst, bIsAutoPlay, nCombo * 3000L );		// #24245 2011.1.26 yyagi changed DRUMS->BASS, add nCombo conditions
					}
				}
			}
		}

        protected void tスコアの初期化()
        {
            //一打目の処理落ちがひどいので、あらかじめここで点数の計算をしておく。
            int nInit = CDTXMania.DTX.nScoreInit[ 0, CDTXMania.stage選曲.n確定された曲の難易度 ];
            int nDiff = CDTXMania.DTX.nScoreDiff[ CDTXMania.stage選曲.n確定された曲の難易度 ];
            int nAddScore = 0;
            int[] n倍率 = { 0, 1, 2, 4, 8 };

            if( CDTXMania.ConfigIni.nScoreMode == 1 )
            {
                for( int i = 0; i < 11; i++ )
                {
                    this.nScore[ i ] = (int)( nInit + ( nDiff * ( i ) ) );
                }
            }
            else if( CDTXMania.ConfigIni.nScoreMode == 2 )
            {
                for( int i = 0; i < 5; i++ )
                {
                    this.nScore[ i ] = (int)( nInit + ( nDiff * n倍率[ i ] ) );

                    this.nScore[ i ] = (int)( this.nScore[ i ] / 10.0 );
                    this.nScore[ i ] = this.nScore[ i ] * 10;

                }

                //this.nScore[ 0 ] = (int)nInit;
                //this.nScore[ 1 ] = (int)( nInit + nDiff );
                //this.nScore[ 2 ] = (int)( nInit + ( nDiff * 2 ) );
                //this.nScore[ 3 ] = (int)( nInit + ( nDiff * 4 ) );
                //this.nScore[ 4 ] = (int)( nInit + ( nDiff * 8 ) );


                

            }
        }
        #endregion
	}
}
