﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Diagnostics;
using System.Threading;
using SlimDX;
using SlimDX.Direct3D9;
using FDK;

namespace DTXMania
{
	internal class CStage演奏ドラム画面 : CStage演奏画面共通
	{
		// コンストラクタ

		public CStage演奏ドラム画面()
		{
			base.eステージID = CStage.Eステージ.演奏;
			base.eフェーズID = CStage.Eフェーズ.共通_通常状態;
			base.b活性化してない = true;
			base.list子Activities.Add( this.actPad = new CAct演奏Drumsパッド() );
			base.list子Activities.Add( this.actCombo = new CAct演奏DrumsコンボDGB() );
			base.list子Activities.Add( this.actDANGER = new CAct演奏DrumsDanger() );
			base.list子Activities.Add( this.actChipFireD = new CAct演奏DrumsチップファイアD() );
			base.list子Activities.Add( this.actChipFireTaiko = new CAct演奏Drums飛んでいく音符() );
            base.list子Activities.Add( this.actChipFireGB = new CAct演奏DrumsチップファイアGB());
            base.list子Activities.Add( this.actGauge = new CAct演奏Drumsゲージ() );
            base.list子Activities.Add( this.actGraph = new CAct演奏Drumsグラフ() ); // #24074 2011.01.23 add ikanick
			base.list子Activities.Add( this.actJudgeString = new CAct演奏Drums判定文字列() );
			base.list子Activities.Add( this.actLaneFlushD = new CAct演奏DrumsレーンフラッシュD() );
			base.list子Activities.Add( this.actLaneFlushGB = new CAct演奏DrumsレーンフラッシュGB() );
			base.list子Activities.Add( this.actRGB = new CAct演奏DrumsRGB() );
			base.list子Activities.Add( this.actScore = new CAct演奏Drumsスコア() );
			base.list子Activities.Add( this.actStatusPanels = new CAct演奏Drumsステータスパネル() );
			base.list子Activities.Add( this.actWailingBonus = new CAct演奏DrumsWailingBonus() );
			base.list子Activities.Add( this.act譜面スクロール速度 = new CAct演奏スクロール速度() );
			base.list子Activities.Add( this.actAVI = new CAct演奏AVI() );
			base.list子Activities.Add( this.actPanel = new CAct演奏パネル文字列() );
			base.list子Activities.Add( this.actStageFailed = new CAct演奏ステージ失敗() );
			base.list子Activities.Add( this.actPlayInfo = new CAct演奏演奏情報() );
			//base.list子Activities.Add( this.actFI = new CActFIFOBlack() );
            base.list子Activities.Add( this.actFI = new CActFIFOStart() );
			base.list子Activities.Add( this.actFO = new CActFIFOBlack() );
			base.list子Activities.Add( this.actFOClear = new CActFIFOResult() );
            base.list子Activities.Add( this.actLane = new CAct演奏Drumsレーン() );
            base.list子Activities.Add( this.actDrumSet = new CAct演奏Drumsドラムセット() );
            base.list子Activities.Add( this.actBPMBarD = new CAct演奏DrumsBPMバー() );
            base.list子Activities.Add( this.actMtaiko = new CAct演奏DrumsMtaiko() );
            base.list子Activities.Add( this.actLaneTaiko = new CAct演奏Drumsレーン太鼓() );
            base.list子Activities.Add( this.actRoll = new CAct演奏Drums連打() );
            base.list子Activities.Add( this.actBalloon = new CAct演奏Drums風船() );
            base.list子Activities.Add( this.actChara = new CAct演奏Drumsキャラクター() );
            
		}


		// メソッド

		public void t演奏結果を格納する( out CScoreIni.C演奏記録 Drums, out CScoreIni.C演奏記録 Guitar, out CScoreIni.C演奏記録 Bass, out CDTX.CChip[] r空打ちドラムチップ )
		{
			base.t演奏結果を格納する・ドラム( out Drums );
			base.t演奏結果を格納する・ギター( out Guitar );
			base.t演奏結果を格納する・ベース( out Bass );

			r空打ちドラムチップ = new CDTX.CChip[ 10 ];
			for ( int i = 0; i < 10; i++ )
			{
				r空打ちドラムチップ[ i ] = this.r空うちChip( E楽器パート.DRUMS, (Eパッド) i );
				if( r空打ちドラムチップ[ i ] == null )
				{
					r空打ちドラムチップ[ i ] = this.r指定時刻に一番近いChip・ヒット未済問わず不可視考慮( CSound管理.rc演奏用タイマ.n現在時刻, this.nパッド0Atoチャンネル0A[ i ], this.nInputAdjustTimeMs.Drums );
				}
			}

//			if ( CDTXMania.ConfigIni.bIsSwappedGuitarBass )		// #24063 2011.1.24 yyagi Gt/Bsを入れ替えていたなら、演奏結果も入れ替える
//			{
//				CScoreIni.C演奏記録 t;
//				t = Guitar;
//				Guitar = Bass;
//				Bass = t;
//			
//				CDTXMania.DTX.SwapGuitarBassInfos();			// 譜面情報も元に戻す
//			}
		}


		// CStage 実装

		public override void On活性化()
		{
			this.bフィルイン中 = false;
            this.n待機中の大音符の座標 = 0;

            base.tスコアの初期化();
			base.On活性化();

			// MODIFY_BEGIN #25398 2011.06.07 FROM
			if( CDTXMania.bコンパクトモード )
			{
				var score = new Cスコア();
				CDTXMania.Songs管理.tScoreIniを読み込んで譜面情報を設定する( CDTXMania.strコンパクトモードファイル + ".score.ini", ref score );
				this.actGraph.dbグラフ値目標_渡 = score.譜面情報.最大スキル[ 0 ];
			}
			else
			{
				this.actGraph.dbグラフ値目標_渡 = CDTXMania.stage選曲.r確定されたスコア.譜面情報.最大スキル[ 0 ];	// #24074 2011.01.23 add ikanick
			}
			// MODIFY_END #25398
			dtLastQueueOperation = DateTime.MinValue;

            int nUnit = (int)( ( ( 60.0 / ( CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) ) ) * 1000.0 / this.actChara.arモーション番号.Length );
            int nUnit_gogo = (int)((60.0 / ( CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) / this.actChara.arゴーゴーモーション番号.Length ) * 1000 );

            double dbUnit = ( ( ( 60.0 / ( CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) ) ) / this.actChara.arモーション番号.Length );
            double dbUnit_gogo = ( ( ( 60.0 / ( CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) ) ) / this.actChara.arゴーゴーモーション番号.Length );

            dbUnit = Math.Ceiling( dbUnit * 1000.0 );
            dbUnit = dbUnit / 1000.0;

            this.actChara.ct通常モーション = new CCounter( 0, this.actChara.arモーション番号.Length - 1, dbUnit, CSound管理.rc演奏用タイマ );
            this.actChara.ctゴーゴーモーション = new CCounter( 0, this.actChara.arゴーゴーモーション番号.Length - 1, dbUnit_gogo * 2, CSound管理.rc演奏用タイマ );

            if( this.actChara.nキャラクタークリアモーション枚数 != 0 )
            {
                double dbUnit_clear = ( ( ( 60.0 / ( CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) ) ) / this.actChara.arクリアモーション番号.Length );
                this.actChara.ctクリア通常モーション = new CCounter( 0, this.actChara.arクリアモーション番号.Length - 1, dbUnit_clear * 2, CSound管理.rc演奏用タイマ );
            }
            if( this.actChara.nキャラクターMAX通常モーション枚数 != 0 )
            {
                double dbUnit_max = ( ( ( 60.0 / ( CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) ) ) / this.actChara.ar黄色モーション番号.Length );
                this.actChara.ctMAX通常モーション = new CCounter( 0, this.actChara.ar黄色モーション番号.Length - 1, dbUnit_max * 2, CSound管理.rc演奏用タイマ );
            }
            if( this.actChara.nキャラクターMAXゴーゴーモーション枚数 != 0 )
            {
                double dbUnit_max_gogo = ( ( ( 60.0 / ( CDTXMania.stage演奏ドラム画面.actPlayInfo.dbBPM ) ) ) / this.actChara.ar黄色ゴーゴーモーション番号.Length );
                this.actChara.ctMAXゴーゴーモーション = new CCounter( 0, this.actChara.ar黄色ゴーゴーモーション番号.Length - 1, dbUnit_max_gogo * 2, CSound管理.rc演奏用タイマ );
            }


            //try
            //{
            //    this.stream = new StreamWriter("noteTest.txt", false);
            //}
            //catch (Exception ex)
            //{
            //    this.stream.Close();
            //    this.stream = new StreamWriter("noteTest.txt", false);
            //}

		}
		public override void On非活性化()
		{
			base.On非活性化();
		}
		public override void OnManagedリソースの作成()
		{
			if( !base.b活性化してない )
			{
				//this.t背景テクスチャの生成();
				this.tx太鼓ノーツ = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_taiko_notes.png" ) );
				this.txSenotes = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_senotes.png" ) );
				this.tx小節線 = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_bar_line.png" ) );
				this.tx小節線_branch = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_bar_line_branch.png" ) );

                this.soundRed = CDTXMania.Sound管理.tサウンドを生成する( CSkin.Path( @"Sounds\dong.ogg" ) );
                this.soundBlue = CDTXMania.Sound管理.tサウンドを生成する( CSkin.Path( @"Sounds\ka.ogg" ) );

                
				base.OnManagedリソースの作成();
			}
		}
		public override void OnManagedリソースの解放()
		{
			if( !base.b活性化してない )
			{
				//CDTXMania.tテクスチャの解放( ref this.tx背景 );
				CDTXMania.tテクスチャの解放( ref this.txヒットバー );
				CDTXMania.tテクスチャの解放( ref this.txヒットバーGB );
				CDTXMania.tテクスチャの解放( ref this.txチップ );
                CDTXMania.tテクスチャの解放( ref this.tx太鼓ノーツ );
                CDTXMania.tテクスチャの解放( ref this.txSenotes );
                CDTXMania.tテクスチャの解放( ref this.tx小節線 );
                CDTXMania.tテクスチャの解放( ref this.tx小節線_branch );
				CDTXMania.tテクスチャの解放( ref this.txレーンフレームGB );
				//CDTXMania.tテクスチャの解放( ref this.txWailing枠 );

                this.soundRed.t解放する();
                this.soundBlue.t解放する();
				base.OnManagedリソースの解放();
			}
		}
		public override int On進行描画()
		{
			base.sw.Start();
			if( !base.b活性化してない )
			{
				bool bIsFinishedPlaying = false;
				bool bIsFinishedFadeout = false;
				#region [ 初めての進行描画 ]
				if ( base.b初めての進行描画 )
				{
                    CSound管理.rc演奏用タイマ.tリセット();
					CDTXMania.Timer.tリセット();
					this.ctチップ模様アニメ.Drums = new CCounter( 0, 1, 500, CDTXMania.Timer );
					this.ctチップ模様アニメ.Guitar = new CCounter( 0, 0x17, 20, CDTXMania.Timer );
					this.ctチップ模様アニメ.Bass = new CCounter( 0, 0x17, 20, CDTXMania.Timer );
					this.ctチップ模様アニメ.Taiko = new CCounter( 0, 1, 500, CDTXMania.Timer );
					this.ctWailingチップ模様アニメ = new CCounter( 0, 4, 50, CDTXMania.Timer );

					// this.actChipFireD.Start( Eレーン.HH );	// #31554 2013.6.12 yyagi
					// 初チップヒット時のもたつき回避。最初にactChipFireD.Start()するときにJITが掛かって？
					// ものすごく待たされる(2回目以降と比べると2,3桁tick違う)。そこで最初の画面フェードインの間に
					// 一発Start()を掛けてJITの結果を生成させておく。

					base.eフェーズID = CStage.Eフェーズ.共通_フェードイン;
					this.actFI.tフェードイン開始();

					if ( CDTXMania.DTXVmode.Enabled )			// DTXVモードなら
					{
						#region [ DTXV用の再生設定にする(全AUTOなど) ]
						tDTXV用の設定();
						#endregion
						t演奏位置の変更( CDTXMania.DTXVmode.nStartBar );
					}

					CDTXMania.Sound管理.tDisableUpdateBufferAutomatically();
					base.b初めての進行描画 = false;
				}
				#endregion
				if ( ( CDTXMania.ConfigIni.nRisky != 0 && this.actGauge.IsFailed( E楽器パート.TAIKO ) ) && ( base.eフェーズID == CStage.Eフェーズ.共通_通常状態 ) )
				{
					this.actStageFailed.Start();
					CDTXMania.DTX.t全チップの再生停止();
					base.eフェーズID = CStage.Eフェーズ.演奏_STAGE_FAILED;
				}
                if( CDTXMania.DTX.listAVI.Count == 0 ) //背景動画があったら背景画像を描画しない。
				    this.t進行描画・背景();
				this.t進行描画・MIDIBGM();

				this.t進行描画・AVI();
                //this.t進行描画・ドラムセット();
                //this.t進行描画・BPMバー();
                this.t進行描画・パネル文字列();
				//this.t進行描画・ステータスパネル();
                //this.t進行描画・グラフ();   // #24074 2011.01.23 add ikanick


				//this.t進行描画・DANGER();
				//this.t進行描画・判定ライン();
				if ( this.e判定表示優先度 == E判定表示優先度.Chipより下 )
				{
					//this.t進行描画・判定文字列1・通常位置指定の場合();
					this.t進行描画・コンボ();
				}

				this.t進行描画・譜面スクロール速度();
				this.t進行描画・チップアニメ();
                this.actLaneTaiko.On進行描画();
                //this.t進行描画・レーン();
				//this.t進行描画・レーンフラッシュD();


                this.t進行描画・ゲージ();
				bIsFinishedPlaying = this.t進行描画・チップ( E楽器パート.DRUMS );
                this.t進行描画・チップ・連打( E楽器パート.DRUMS );
                if( CDTXMania.ConfigIni.bChara )
                    this.actChara.On進行描画();
                this.actMtaiko.On進行描画();



			    this.t進行描画・コンボ();
				this.t進行描画・スコア();
				//this.t進行描画・ドラムパッド();
                this.t進行描画・チップファイアD();
                this.t進行描画・チップファイアTaiko();
                this.t進行描画・判定文字列1・通常位置指定の場合();
                this.t進行描画・演奏情報();
				this.t進行描画・STAGEFAILED();

                this.t全体制御メソッド();

                //CDTXMania.act文字コンソール.tPrint( 0, 0, C文字コンソール.Eフォント種別.白, ( (int)this.eRollState ).ToString() );
                //CDTXMania.act文字コンソール.tPrint( 0, 0, C文字コンソール.Eフォント種別.白, this.n大音符入力開始時刻ms.ToString() );
                //CDTXMania.act文字コンソール.tPrint( 0, 16, C文字コンソール.Eフォント種別.白, this.b大音符待機中.ToString() );



				bIsFinishedFadeout = this.t進行描画・フェードイン・アウト();
				if( bIsFinishedPlaying && ( base.eフェーズID == CStage.Eフェーズ.共通_通常状態 ) )
				{
                    //this.stream.Close();
					if ( CDTXMania.DTXVmode.Enabled )
					{
						if ( CDTXMania.Timer.b停止していない )
						{
							this.actPanel.Stop();				// PANEL表示停止
						    CDTXMania.Timer.t一時停止();		// 再生時刻カウンタ停止
						}
						Thread.Sleep( 5 );
						// DTXCからの次のメッセージを待ち続ける
					}
					else
					{
						this.eフェードアウト完了時の戻り値 = E演奏画面の戻り値.ステージクリア;
						base.eフェーズID = CStage.Eフェーズ.演奏_STAGE_CLEAR_フェードアウト;
						this.actFOClear.tフェードアウト開始();
					}
				}
				if ( this.eフェードアウト完了時の戻り値 == E演奏画面の戻り値.再読込・再演奏 )
				{
					bIsFinishedFadeout = true;
				}
				if( bIsFinishedFadeout )
				{
					Debug.WriteLine( "Total On進行描画=" + sw.ElapsedMilliseconds + "ms" );
					return (int) this.eフェードアウト完了時の戻り値;
				}

				ManageMixerQueue();

				// キー入力

				if( CDTXMania.act現在入力を占有中のプラグイン == null )
					this.tキー入力();
			}
			base.sw.Stop();
			return 0;
		}

		// その他

		#region [ private ]
		//-----------------

		public CAct演奏DrumsチップファイアD actChipFireD;

		private CAct演奏Drumsグラフ actGraph;   // #24074 2011.01.23 add ikanick
		private CAct演奏Drumsパッド actPad;
        public CAct演奏Drumsレーン actLane;
        public CAct演奏DrumsMtaiko actMtaiko;
        public CAct演奏Drumsレーン太鼓 actLaneTaiko;
        public CAct演奏Drumsドラムセット actDrumSet;
        public CAct演奏DrumsBPMバー actBPMBarD;
		private bool bフィルイン中;
		private readonly Eパッド[] eチャンネルtoパッド = new Eパッド[]
		{
			Eパッド.HH, Eパッド.SD, Eパッド.BD, Eパッド.HT,
			Eパッド.LT, Eパッド.CY, Eパッド.FT, Eパッド.HHO,
			Eパッド.RD, Eパッド.UNKNOWN, Eパッド.UNKNOWN, Eパッド.LC,
            Eパッド.LP, Eパッド.LBD
		};
        private int[] nチャンネルtoX座標 = new int[] { 370, 470, 582, 527, 645, 748, 694, 373, 815, 298, 419, 419 };
		private CTexture txヒットバーGB;
		private CTexture txレーンフレームGB;
        private CTexture tx太鼓ノーツ;
        private CTexture txSenotes;
        private CTexture tx小節線;
        private CTexture tx小節線_branch;

        public float nGauge = 0.0f;

        private StreamWriter stream;

        private int n待機中の大音符の座標;
		//-----------------

		private bool bフィルイン区間の最後のChipである( CDTX.CChip pChip )
		{
			if( pChip == null )
			{
				return false;
			}
			int num = pChip.n発声位置;
			for( int i = listChip.IndexOf( pChip ) + 1; i < listChip.Count; i++ )
			{
				pChip = listChip[ i ];
				if( ( pChip.nチャンネル番号 == 0x53 ) && ( pChip.n整数値 == 2 ) )
				{
					return true;
				}
				if( ( ( pChip.nチャンネル番号 >= 0x11 ) && ( pChip.nチャンネル番号 <= 0x1C ) ) && ( ( pChip.n発声位置 - num ) > 0x18 ) )
				{
					return false;
				}
			}
			return true;
		}

		protected override E判定 tチップのヒット処理( long nHitTime, CDTX.CChip pChip, bool bCorrectLane )
		{
			E判定 eJudgeResult = tチップのヒット処理( nHitTime, pChip, E楽器パート.DRUMS, bCorrectLane, 0 );
			// #24074 2011.01.23 add ikanick
			this.actGraph.dbグラフ値現在_渡 = CScoreIni.t演奏型スキルを計算して返す( CDTXMania.DTX.n可視チップ数.Drums, this.nヒット数・Auto含まない.Drums.Perfect, this.nヒット数・Auto含まない.Drums.Great, this.nヒット数・Auto含まない.Drums.Good, this.nヒット数・Auto含まない.Drums.Poor, this.nヒット数・Auto含まない.Drums.Miss, E楽器パート.DRUMS,  bIsAutoPlay );
			return eJudgeResult;
		}

		protected override void tチップのヒット処理・BadならびにTight時のMiss( E楽器パート part )
		{
			this.tチップのヒット処理・BadならびにTight時のMiss( part, 0, E楽器パート.DRUMS );
		}
		protected override void tチップのヒット処理・BadならびにTight時のMiss( E楽器パート part, int nLane )
		{
			this.tチップのヒット処理・BadならびにTight時のMiss( part, nLane, E楽器パート.DRUMS );
		}

        private bool tドラムヒット処理( long nHitTime, Eパッド type, CDTX.CChip pChip, int n強弱度合い0to127)
		{
            return this.tドラムヒット処理( nHitTime, type, pChip, n強弱度合い0to127, false );
        }
		private bool tドラムヒット処理( long nHitTime, Eパッド type, CDTX.CChip pChip, int n強弱度合い0to127, bool b両手入力 )
		{
            int nInput = 0;

            switch( type )
            {
                case Eパッド.LRed:
                case Eパッド.RRed:
                    nInput = 0;
                    if( b両手入力 )
                        nInput = 2;
                    break;
                case Eパッド.LBlue:
                case Eパッド.RBlue:
                    nInput = 1;
                    if( b両手入力 )
                        nInput = 3;
                    break;
            }


		    if( pChip == null )
			{
				return false;
			}
			int index = pChip.nチャンネル番号;
			if ( ( index >= 0x93 ) && ( index <= 0x94 ) )
			{
				index -= 0x93;
			}
			else if ( ( index >= 0x95 ) && ( index <= 0x96 ) )
			{
				index -= 0x95;
			}
            else if( pChip.nチャンネル番号 >= 0x97 && pChip.nチャンネル番号 <= 0x99 )
            {
			    this.tチップのヒット処理( nHitTime, pChip, E楽器パート.TAIKO, true, nInput );
                return true;
            }
            else
            {
                return false;
            }
            

			int nLane = index;
			int nPad = index;

			int nInputAdjustTime = 0;
			E判定 e判定 = this.e指定時刻からChipのJUDGEを返す( nHitTime, pChip, nInputAdjustTime );
			if( e判定 == E判定.Miss )
			{
				return false;
			}
			this.tチップのヒット処理( nHitTime, pChip, E楽器パート.TAIKO, true, nInput );
            
			if( ( e判定 != E判定.Poor ) && ( e判定 != E判定.Miss ) )
			{
                CDTXMania.stage演奏ドラム画面.actLaneTaiko.Start( pChip.nチャンネル番号, e判定, b両手入力 );

                int nFly = 0;
                switch(pChip.nチャンネル番号)
                {
                    case 0x93:
                        nFly = 1;
                        break;
                    case 0x94:
                        nFly = 2;
                        break;
                    case 0x95:
                        nFly = b両手入力 ? 3 : 1;
                        break;
                    case 0x96:
                        nFly = b両手入力 ? 4 : 2;
                        break;
                    default:
                        nFly = 1;
                        break;
                }


                this.actChipFireTaiko.Start( nFly );
			}

			return true;
		}

		protected override void ドラムスクロール速度アップ()
		{
			CDTXMania.ConfigIni.n譜面スクロール速度.Drums = Math.Min( CDTXMania.ConfigIni.n譜面スクロール速度.Drums + 1, 1999 );
		}
		protected override void ドラムスクロール速度ダウン()
		{
			CDTXMania.ConfigIni.n譜面スクロール速度.Drums = Math.Max( CDTXMania.ConfigIni.n譜面スクロール速度.Drums - 1, 0 );
		}

	
		protected override void t進行描画・AVI()
		{
			base.t進行描画・AVI( 0, 0 );
		}
		protected override void t進行描画・DANGER()
		{
//			this.actDANGER.t進行描画( this.actGauge.db現在のゲージ値.Drums < 0.3, false, false );
			this.actDANGER.t進行描画( this.actGauge.IsDanger(E楽器パート.DRUMS), false, false );
		}

		protected override void t進行描画・Wailing枠()
		{
		}
		private void t進行描画・ギターベースフレーム()
		{
		}
		private void t進行描画・ギターベース判定ライン()		// yyagi: ギタレボモードとは座標が違うだけですが、まとめづらかったのでそのまま放置してます。
		{
		}

		private void t進行描画・グラフ()        
        {
			if ( !CDTXMania.ConfigIni.bストイックモード && !CDTXMania.ConfigIni.bドラムが全部オートプレイである && CDTXMania.ConfigIni.bGraph.Drums )
			{
                this.actGraph.On進行描画();
            }
        }

		private void t進行描画・チップファイアD()
		{
			this.actChipFireD.On進行描画();
		}

		private void t進行描画・チップファイアTaiko()
		{
			this.actChipFireTaiko.On進行描画();
		}

		private void t進行描画・ドラムパッド()
		{
			if( CDTXMania.ConfigIni.eDark != Eダークモード.FULL )
			{
				this.actPad.On進行描画();
			}
		}
		protected override void t進行描画・パネル文字列()
		{
			base.t進行描画・パネル文字列( 336, 427 );
		}

		protected override void t進行描画・演奏情報()
		{
			base.t進行描画・演奏情報( 1000, 257 );
		}

		protected override void t入力処理・ドラム()
		{
			for( int nPad = 0; nPad < (int) Eパッド.MAX; nPad++ )		// #27029 2012.1.4 from: <10 to <=10; Eパッドの要素が１つ（HP）増えたため。
																		//		  2012.1.5 yyagi: (int)Eパッド.MAX に変更。Eパッドの要素数への依存を無くすため。
			{
				List<STInputEvent> listInputEvent = CDTXMania.Pad.GetEvents( E楽器パート.DRUMS, (Eパッド) nPad );

				if( ( listInputEvent == null ) || ( listInputEvent.Count == 0 ) )
					continue;

				this.t入力メソッド記憶( E楽器パート.DRUMS );

				#region [ 打ち分けグループ調整 ]
				//-----------------------------
				EHHGroup eHHGroup = CDTXMania.ConfigIni.eHHGroup;
				EFTGroup eFTGroup = CDTXMania.ConfigIni.eFTGroup;
				ECYGroup eCYGroup = CDTXMania.ConfigIni.eCYGroup;
                EBDGroup eBDGroup = CDTXMania.ConfigIni.eBDGroup;

				if( !CDTXMania.DTX.bチップがある.Ride && ( eCYGroup == ECYGroup.打ち分ける ) )
				{
					eCYGroup = ECYGroup.共通;
				}
				if( !CDTXMania.DTX.bチップがある.HHOpen && ( eHHGroup == EHHGroup.全部打ち分ける ) )
				{
					eHHGroup = EHHGroup.左シンバルのみ打ち分ける;
				}
				if( !CDTXMania.DTX.bチップがある.HHOpen && ( eHHGroup == EHHGroup.ハイハットのみ打ち分ける ) )
				{
					eHHGroup = EHHGroup.全部共通;
				}
				if( !CDTXMania.DTX.bチップがある.LeftCymbal && ( eHHGroup == EHHGroup.全部打ち分ける ) )
				{
					eHHGroup = EHHGroup.ハイハットのみ打ち分ける;
				}
				if( !CDTXMania.DTX.bチップがある.LeftCymbal && ( eHHGroup == EHHGroup.左シンバルのみ打ち分ける ) )
				{
					eHHGroup = EHHGroup.全部共通;
				}
				//-----------------------------
				#endregion

				foreach( STInputEvent inputEvent in listInputEvent )
				{
					if( !inputEvent.b押された )
						continue;

					long nTime = inputEvent.nTimeStamp - CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻;
					//int nPad09 = ( nPad == (int) Eパッド.HP ) ? (int) Eパッド.BD : nPad;		// #27029 2012.1.5 yyagi
					//int nInputAdjustTime = bIsAutoPlay[ this.nチャンネル0Atoレーン07[ nPad ] ] ? 0 : nInputAdjustTimeMs.Drums;
                    int nInputAdjustTime = 0;

					bool bHitted = false;

                    int nLane = 0;
                    int nHand = 0;
                    int nChannel = 0;

                    switch (nPad)
                    {
                        case 12:
                            nLane = 0;
                            nHand = 0;
                            nChannel = 0x93;
                            //CDTXMania.Skin.soundRed.t再生する();
                            this.soundRed.t再生を開始する();
                            break;
                        case 13:
                            nLane = 0;
                            nHand = 1;
                            nChannel = 0x93;
                            //CDTXMania.Skin.soundRed.t再生する();
                            this.soundRed.t再生を開始する();
                            break;
                        case 14:
                            nLane = 1;
                            nHand = 0;
                            nChannel = 0x94;
                            //CDTXMania.Skin.soundBlue.t再生する();
                            this.soundBlue.t再生を開始する();
                            break;
                        case 15:
                            nLane = 1;
                            nHand = 1;
                            nChannel = 0x94;
                            //CDTXMania.Skin.soundBlue.t再生する();
                            this.soundBlue.t再生を開始する();
                            break;
                    }

                    CDTXMania.stage演奏ドラム画面.actLaneFlushD.Start(nLane, 127);

                    CDTXMania.stage演奏ドラム画面.actMtaiko.tMtaikoEvent(nChannel, nHand);



                    //2015.03.19 kairera0467 Chipを1つにまとめて1つのレーン扱いにする。
                    CDTX.CChip chipNoHit = this.r指定時刻に一番近い未ヒットChipを過去方向優先で検索する( nTime, nInputAdjustTime );
                    E判定 e判定 = ( chipNoHit != null ) ? this.e指定時刻からChipのJUDGEを返す( nTime, chipNoHit, nInputAdjustTime ) : E判定.Miss;

                    if( this.b連打中 )
                    {
                        chipNoHit = this.chip現在処理中の連打チップ;
                        e判定 = E判定.Perfect;
                    }



                    if( chipNoHit == null )
                    {
                        break;
                    }


                    //if (this.stream != null)
                    //    this.stream.WriteLine("channel:{0} course:{1} judge:{2} DBSCROLL:{3}", chipNoHit.nチャンネル番号, chipNoHit.nコース, e判定, chipNoHit.fBMSCROLLTime );

					#region [ (A) ヒットしていればヒット処理して次の inputEvent へ ]
					//-----------------------------
					switch( ( (Eパッド) nPad ) )
					{
						case Eパッド.HH:
							#region [ HHとLC(groupingしている場合) のヒット処理 ]
							//-----------------------------
							{
								if( inputEvent.nVelocity <= CDTXMania.ConfigIni.nVelocityMin.HH )
									continue;	// 電子ドラムによる意図的なクロストークを無効にする

								CDTX.CChip chipHC = this.r指定時刻に一番近い未ヒットChip( nTime, 0x11, nInputAdjustTime );	// HiHat Close
								CDTX.CChip chipHO = this.r指定時刻に一番近い未ヒットChip( nTime, 0x18, nInputAdjustTime );	// HiHat Open
								CDTX.CChip chipLC = this.r指定時刻に一番近い未ヒットChip( nTime, 0x1a, nInputAdjustTime );	// LC
								E判定 e判定HC = ( chipHC != null ) ? this.e指定時刻からChipのJUDGEを返す( nTime, chipHC, nInputAdjustTime ) : E判定.Miss;
								E判定 e判定HO = ( chipHO != null ) ? this.e指定時刻からChipのJUDGEを返す( nTime, chipHO, nInputAdjustTime ) : E判定.Miss;
								E判定 e判定LC = ( chipLC != null ) ? this.e指定時刻からChipのJUDGEを返す( nTime, chipLC, nInputAdjustTime ) : E判定.Miss;
								switch( eHHGroup )
								{
									case EHHGroup.ハイハットのみ打ち分ける:
										#region [ HCとLCのヒット処理 ]
										//-----------------------------
										if( ( e判定HC != E判定.Miss ) && ( e判定LC != E判定.Miss ) )
										{
											if( chipHC.n発声位置 < chipLC.n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
											}
											else if( chipHC.n発声位置 > chipLC.n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipLC, inputEvent.nVelocity );
											}
											else
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
												this.tドラムヒット処理( nTime, Eパッド.HH, chipLC, inputEvent.nVelocity );
											}
											bHitted = true;
										}
										else if( e判定HC != E判定.Miss )
										{
											this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
											bHitted = true;
										}
										else if( e判定LC != E判定.Miss )
										{
											this.tドラムヒット処理( nTime, Eパッド.HH, chipLC, inputEvent.nVelocity );
											bHitted = true;
										}
										if( !bHitted )
											break;
										continue;
									//-----------------------------
										#endregion

									case EHHGroup.左シンバルのみ打ち分ける:
										#region [ HCとHOのヒット処理 ]
										//-----------------------------
										if( ( e判定HC != E判定.Miss ) && ( e判定HO != E判定.Miss ) )
										{
											if( chipHC.n発声位置 < chipHO.n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
											}
											else if( chipHC.n発声位置 > chipHO.n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHO, inputEvent.nVelocity );
											}
											else
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHO, inputEvent.nVelocity );
											}
											bHitted = true;
										}
										else if( e判定HC != E判定.Miss )
										{
											this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
											bHitted = true;
										}
										else if( e判定HO != E判定.Miss )
										{
											this.tドラムヒット処理( nTime, Eパッド.HH, chipHO, inputEvent.nVelocity );
											bHitted = true;
										}
										if( !bHitted )
											break;
										continue;
									//-----------------------------
										#endregion

									case EHHGroup.全部共通:
										#region [ HC,HO,LCのヒット処理 ]
										//-----------------------------
										if( ( ( e判定HC != E判定.Miss ) && ( e判定HO != E判定.Miss ) ) && ( e判定LC != E判定.Miss ) )
										{
											CDTX.CChip chip;
											CDTX.CChip[] chipArray = new CDTX.CChip[] { chipHC, chipHO, chipLC };
											// ここから、chipArrayをn発生位置の小さい順に並び替える
											if( chipArray[ 1 ].n発声位置 > chipArray[ 2 ].n発声位置 )
											{
												chip = chipArray[ 1 ];
												chipArray[ 1 ] = chipArray[ 2 ];
												chipArray[ 2 ] = chip;
											}
											if( chipArray[ 0 ].n発声位置 > chipArray[ 1 ].n発声位置 )
											{
												chip = chipArray[ 0 ];
												chipArray[ 0 ] = chipArray[ 1 ];
												chipArray[ 1 ] = chip;
											}
											if( chipArray[ 1 ].n発声位置 > chipArray[ 2 ].n発声位置 )
											{
												chip = chipArray[ 1 ];
												chipArray[ 1 ] = chipArray[ 2 ];
												chipArray[ 2 ] = chip;
											}
											this.tドラムヒット処理( nTime, Eパッド.HH, chipArray[ 0 ], inputEvent.nVelocity );
											if( chipArray[ 0 ].n発声位置 == chipArray[ 1 ].n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipArray[ 1 ], inputEvent.nVelocity );
											}
											if( chipArray[ 0 ].n発声位置 == chipArray[ 2 ].n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipArray[ 2 ], inputEvent.nVelocity );
											}
											bHitted = true;
										}
										else if( ( e判定HC != E判定.Miss ) && ( e判定HO != E判定.Miss ) )
										{
											if( chipHC.n発声位置 < chipHO.n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
											}
											else if( chipHC.n発声位置 > chipHO.n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHO, inputEvent.nVelocity );
											}
											else
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHO, inputEvent.nVelocity );
											}
											bHitted = true;
										}
										else if( ( e判定HC != E判定.Miss ) && ( e判定LC != E判定.Miss ) )
										{
											if( chipHC.n発声位置 < chipLC.n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
											}
											else if( chipHC.n発声位置 > chipLC.n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipLC, inputEvent.nVelocity );
											}
											else
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
												this.tドラムヒット処理( nTime, Eパッド.HH, chipLC, inputEvent.nVelocity );
											}
											bHitted = true;
										}
										else if( ( e判定HO != E判定.Miss ) && ( e判定LC != E判定.Miss ) )
										{
											if( chipHO.n発声位置 < chipLC.n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHO, inputEvent.nVelocity );
											}
											else if( chipHO.n発声位置 > chipLC.n発声位置 )
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipLC, inputEvent.nVelocity );
											}
											else
											{
												this.tドラムヒット処理( nTime, Eパッド.HH, chipHO, inputEvent.nVelocity );
												this.tドラムヒット処理( nTime, Eパッド.HH, chipLC, inputEvent.nVelocity );
											}
											bHitted = true;
										}
										else if( e判定HC != E判定.Miss )
										{
											this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
											bHitted = true;
										}
										else if( e判定HO != E判定.Miss )
										{
											this.tドラムヒット処理( nTime, Eパッド.HH, chipHO, inputEvent.nVelocity );
											bHitted = true;
										}
										else if( e判定LC != E判定.Miss )
										{
											this.tドラムヒット処理( nTime, Eパッド.HH, chipLC, inputEvent.nVelocity );
											bHitted = true;
										}
										if( !bHitted )
											break;
										continue;
									//-----------------------------
										#endregion

									default:
										#region [ 全部打ち分け時のヒット処理 ]
										//-----------------------------
										if( e判定HC != E判定.Miss )
										{
											this.tドラムヒット処理( nTime, Eパッド.HH, chipHC, inputEvent.nVelocity );
											bHitted = true;
										}
										if( !bHitted )
											break;
										continue;
									//-----------------------------
										#endregion
								}
								if( !bHitted )
									break;
								continue;
							}
						    //-----------------------------
							#endregion

                        case Eパッド.LRed:
                            #region[ 面のヒット処理 ]
                            //-----------------------------
                            {
								if( e判定 != E判定.Miss && chipNoHit.nチャンネル番号 == 0x93 )
								{
									this.tドラムヒット処理( nTime, Eパッド.LRed, chipNoHit, inputEvent.nVelocity );
									bHitted = true;
								}
								if( e判定 != E判定.Miss && chipNoHit.nチャンネル番号 == 0x95 )
								{
                                    if( chipNoHit.eNoteState == ENoteState.none )
                                    {
                                        float time = chipNoHit.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻ms;
                                        if (time < 110)
                                        {
                                            chipNoHit.nProcessTime = (int)CSound管理.rc演奏用タイマ.n現在時刻ms;
                                            chipNoHit.eNoteState = ENoteState.wait;
                                            this.nWaitButton = 2;
                                        }
                                    }
                                    else if (chipNoHit.eNoteState == ENoteState.wait)
                                    {
                                        float time = chipNoHit.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻ms;
                                        int nWaitTime = CDTXMania.ConfigIni.n両手判定の待ち時間;
                                        if( this.nWaitButton == 1 && time < 110 && chipNoHit.nProcessTime + nWaitTime > (int)CSound管理.rc演奏用タイマ.n現在時刻ms )
                                        {
                                            this.tドラムヒット処理(nTime, Eパッド.LRed, chipNoHit, inputEvent.nVelocity, true);
                                            bHitted = true;
                                            this.nWaitButton = 0;
                                        }
                                        else if (this.nWaitButton == 2 && time < 110 && chipNoHit.nProcessTime + nWaitTime < (int)CSound管理.rc演奏用タイマ.n現在時刻ms)
                                        {
                                            this.tドラムヒット処理(nTime, Eパッド.LRed, chipNoHit, inputEvent.nVelocity);
                                            bHitted = true;
                                            this.nWaitButton = 0;
                                        }
                                    }
								}
                                if( e判定 != E判定.Miss && ( chipNoHit.nチャンネル番号 == 0x97 || chipNoHit.nチャンネル番号 == 0x98 || chipNoHit.nチャンネル番号 == 0x99 || chipNoHit.nチャンネル番号 == 0x9A ) )
                                {
						            this.tドラムヒット処理( nTime, Eパッド.LRed, chipNoHit, inputEvent.nVelocity );
                                }


                                if( !bHitted )
                                    break;
                                continue;
                            }
                            //-----------------------------
                            #endregion

                        case Eパッド.RRed:
                            #region[ 面のヒット処理 ]
                            //-----------------------------
                            {
                                if( e判定 != E判定.Miss && chipNoHit.nチャンネル番号 == 0x93 )
								{
									this.tドラムヒット処理( nTime, Eパッド.RRed, chipNoHit, inputEvent.nVelocity );
									bHitted = true;
								}
                                if( e判定 != E判定.Miss && chipNoHit.nチャンネル番号 == 0x95 )
                                {
                                    if (chipNoHit.eNoteState == ENoteState.none)
                                    {
                                        float time = chipNoHit.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻ms;
                                        if (time < 110)
                                        {
                                            chipNoHit.nProcessTime = (int)CSound管理.rc演奏用タイマ.n現在時刻ms;
                                            this.n待機中の大音符の座標 = chipNoHit.nバーからの距離dot.Taiko;
                                            chipNoHit.eNoteState = ENoteState.wait;
                                            this.nWaitButton = 1;
                                        }
                                    }
                                    else if (chipNoHit.eNoteState == ENoteState.wait)
                                    {
                                        float time = chipNoHit.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻ms;
                                        int nWaitTime = CDTXMania.ConfigIni.n両手判定の待ち時間;
                                        if( this.nWaitButton == 2 && time < 110 && chipNoHit.nProcessTime + nWaitTime > (int)CSound管理.rc演奏用タイマ.n現在時刻ms )
                                        {
                                            this.tドラムヒット処理(nTime, Eパッド.RRed, chipNoHit, inputEvent.nVelocity, true);
                                            bHitted = true;
                                            this.nWaitButton = 0;
                                            break;
                                        }
                                        else if (this.nWaitButton == 2 && time < 110 && chipNoHit.nProcessTime + nWaitTime < (int)CSound管理.rc演奏用タイマ.n現在時刻ms)
                                        {
                                            this.tドラムヒット処理(nTime, Eパッド.RRed, chipNoHit, inputEvent.nVelocity);
                                            bHitted = true;
                                            this.nWaitButton = 0;
                                        }
                                    }
								}
                                if( e判定 != E判定.Miss && ( chipNoHit.nチャンネル番号 == 0x97 || chipNoHit.nチャンネル番号 == 0x98 || chipNoHit.nチャンネル番号 == 0x99 ) )
                                {
						            this.tドラムヒット処理( nTime, Eパッド.RRed, chipNoHit, inputEvent.nVelocity );
                                }

                                if( !bHitted )
                                    break;

                                continue;
                            }
                            //-----------------------------
                            #endregion

                        case Eパッド.LBlue:
                            #region[ ふちのヒット処理 ]
                            //-----------------------------
                            {
								if( e判定 != E判定.Miss && chipNoHit.nチャンネル番号 == 0x94 )
								{
									this.tドラムヒット処理( nTime, Eパッド.LBlue, chipNoHit, inputEvent.nVelocity );
									bHitted = true;
								}
                                if( e判定 != E判定.Miss && chipNoHit.nチャンネル番号 == 0x96 )
								{
                                    if (chipNoHit.eNoteState == ENoteState.none)
                                    {
                                        float time = chipNoHit.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻ms;
                                        if (time < 110)
                                        {
                                            chipNoHit.nProcessTime = (int)CSound管理.rc演奏用タイマ.n現在時刻ms;
                                            chipNoHit.eNoteState = ENoteState.wait;
                                            this.nWaitButton = 2;
                                        }
                                    }
                                    else if (chipNoHit.eNoteState == ENoteState.wait)
                                    {
                                        float time = chipNoHit.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻ms;
                                        int nWaitTime = CDTXMania.ConfigIni.n両手判定の待ち時間;
                                        if (this.nWaitButton == 1 && time < 110 && chipNoHit.nProcessTime + nWaitTime > (int)CSound管理.rc演奏用タイマ.n現在時刻ms)
                                        {
                                            this.tドラムヒット処理(nTime, Eパッド.LBlue, chipNoHit, inputEvent.nVelocity, true);
                                            bHitted = true;
                                            this.nWaitButton = 0;
                                        }
                                        else if (this.nWaitButton == 2 && time < 110 && chipNoHit.nProcessTime + nWaitTime < (int)CSound管理.rc演奏用タイマ.n現在時刻ms)
                                        {
                                            this.tドラムヒット処理(nTime, Eパッド.LBlue, chipNoHit, inputEvent.nVelocity);
                                            bHitted = true;
                                            this.nWaitButton = 0;
                                        }
                                    }
								}
                                if( e判定 != E判定.Miss && ( chipNoHit.nチャンネル番号 == 0x97 || chipNoHit.nチャンネル番号 == 0x98 ) )
                                {
						            this.tドラムヒット処理( nTime, Eパッド.LBlue, chipNoHit, inputEvent.nVelocity );
                                }

                                if( !bHitted )
                                    break;
                                continue;
                            }
                            //-----------------------------
                            #endregion


                        case Eパッド.RBlue:
                            #region[ ふちのヒット処理 ]
                            //-----------------------------
                            {
								if( e判定 != E判定.Miss && chipNoHit.nチャンネル番号 == 0x94 )
								{
									this.tドラムヒット処理( nTime, Eパッド.RBlue, chipNoHit, inputEvent.nVelocity );
									bHitted = true;
								}
                                if( e判定 != E判定.Miss && chipNoHit.nチャンネル番号 == 0x96 )
								{
                                    if (chipNoHit.eNoteState == ENoteState.none)
                                    {
                                        float time = chipNoHit.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻ms;
                                        if (time < 110)
                                        {
                                            chipNoHit.nProcessTime = (int)CSound管理.rc演奏用タイマ.n現在時刻ms;
                                            this.n待機中の大音符の座標 = chipNoHit.nバーからの距離dot.Taiko;
                                            chipNoHit.eNoteState = ENoteState.wait;
                                            this.nWaitButton = 1;
                                        }
                                    }
                                    else if (chipNoHit.eNoteState == ENoteState.wait)
                                    {
                                        float time = chipNoHit.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻ms;
                                        int nWaitTime = CDTXMania.ConfigIni.n両手判定の待ち時間;
                                        if (this.nWaitButton == 2 && time < 110 && chipNoHit.nProcessTime + nWaitTime > (int)CSound管理.rc演奏用タイマ.n現在時刻ms)
                                        {
                                            this.tドラムヒット処理(nTime, Eパッド.RBlue, chipNoHit, inputEvent.nVelocity, true);
                                            bHitted = true;
                                            this.nWaitButton = 0;
                                            break;
                                        }
                                        else if (this.nWaitButton == 2 && time < 110 && chipNoHit.nProcessTime + nWaitTime < (int)CSound管理.rc演奏用タイマ.n現在時刻ms)
                                        {
                                            this.tドラムヒット処理(nTime, Eパッド.RBlue, chipNoHit, inputEvent.nVelocity);
                                            bHitted = true;
                                            this.nWaitButton = 0;
                                        }
                                    }
                                }
                                if( e判定 != E判定.Miss && ( chipNoHit.nチャンネル番号 == 0x97 || chipNoHit.nチャンネル番号 == 0x98) )
                                {
						            this.tドラムヒット処理( nTime, Eパッド.RBlue, chipNoHit, inputEvent.nVelocity );
                                }

                                if( !bHitted )
                                    break;
                                continue;
                            }
                            //-----------------------------
                            #endregion
					}
					//-----------------------------
					#endregion
					#region [ (B) ヒットしてなかった場合は、レーンフラッシュ、パッドアニメ、空打ち音再生を実行 ]
					//-----------------------------
					int pad = nPad;	// 以下、nPad の代わりに pad を用いる。（成りすまし用）
					// BAD or TIGHT 時の処理。
					if( CDTXMania.ConfigIni.bTight )
						this.tチップのヒット処理・BadならびにTight時のMiss( E楽器パート.DRUMS, 0 );
					//-----------------------------
					#endregion
				}
			}
		}

		// t入力処理・ドラム()からメソッドを抽出したもの。
		/// <summary>
		/// chipArrayの中を, n発生位置の小さい順に並べる + nullを大きい方に退かす。セットでe判定Arrayも並べ直す。
		/// </summary>
		/// <param name="chipArray">ソート対象chip群</param>
		/// <param name="e判定Array">ソート対象e判定群</param>
		/// <param name="NumOfChips">チップ数</param>
		private static void SortChipsByNTime( CDTX.CChip[] chipArray, E判定[] e判定Array, int NumOfChips )
		{
			for ( int i = 0; i < NumOfChips - 1; i++ )
			{
				//num9 = 2;
				//while( num9 > num8 )
				for ( int j = NumOfChips - 1; j > i; j-- )
				{
					if ( ( chipArray[ j - 1 ] == null ) || ( ( chipArray[ j ] != null ) && ( chipArray[ j - 1 ].n発声位置 > chipArray[ j ].n発声位置 ) ) )
					{
						// swap
						CDTX.CChip chipTemp = chipArray[ j - 1 ];
						chipArray[ j - 1 ] = chipArray[ j ];
						chipArray[ j ] = chipTemp;
						E判定 e判定Temp = e判定Array[ j - 1 ];
						e判定Array[ j - 1 ] = e判定Array[ j ];
						e判定Array[ j ] = e判定Temp;
					}
					//num9--;
				}
				//num8++;
			}
		}

		protected override void t背景テクスチャの生成()
		{
			Rectangle bgrect = new Rectangle( 0, 0, 1280, 720 );
			string DefaultBgFilename = @"Graphics\7_background.png";
			string BgFilename = "";
			base.t背景テクスチャの生成( DefaultBgFilename, bgrect, BgFilename );
		}
		protected override void t進行描画・チップ・Taiko( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip )
        {
            int nLane = 0;
            #region[作り直したもの]
            if( pChip.b可視 )
            {
                if( !pChip.bHit /*&& pChip.b可視*/ )
				{
                    int x = 414 + pChip.nバーからの距離dot.Taiko;
                    int y = 192;

                    #region[ 両手待ち時 ]
                    float time = pChip.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻ms;
                    if( pChip.eNoteState == ENoteState.wait )
                    {
                        x = 414;
                    }
                    #endregion

                    if( ( 1400 > x ) )
                    {
                        if( this.tx太鼓ノーツ != null )
                        {
                            //int num9 = this.actCombo.n現在のコンボ数.Drums >= 50 ? this.ctチップ模様アニメ.Drums.n現在の値 * 130 : 0;
                            int num9 = this.actCombo.n現在のコンボ数.Drums >= 50 ? base.n現在の音符の顔番号 * 130 : 0;
                            switch ( pChip.nチャンネル番号 )
                            {
                                case 0x93:
                                    x = ( x + 10 ) - ( ( int ) ( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
                                    if( this.tx太鼓ノーツ != null )
                                    {
                                        this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 130, num9, 130, 130 ) );
                                        this.txSenotes.t2D描画( CDTXMania.app.Device, x - 2, y + 131, new Rectangle( 0, 30 * pChip.nSenote, 136, 30 ) );
                                        //CDTXMania.act文字コンソール.tPrint( x + 60, y + 140, C文字コンソール.Eフォント種別.白, pChip.nSenote.ToString() );
                                    }
                                    break;

                                case 0x94:
                                    x = ( x + 10 ) - ( ( int ) ( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
                                    if( this.tx太鼓ノーツ != null )
                                    {
                                        this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 260, num9, 130, 130) );
                                        this.txSenotes.t2D描画( CDTXMania.app.Device, x - 2, y + 131, new Rectangle( 0, 30 * pChip.nSenote, 136, 30 ) );
                                        //CDTXMania.act文字コンソール.tPrint( x + 60, y + 140, C文字コンソール.Eフォント種別.白, pChip.nSenote.ToString() );
                                    }
                                    nLane = 1;
                                    break;
                                  
                                case 0x95:
                                    x = ( x + 10 ) - ( ( int )( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
                                    if( this.tx太鼓ノーツ != null )
                                    {
                                        this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 390, num9, 130, 130 ) );
                                        this.txSenotes.t2D描画( CDTXMania.app.Device, x - 2, y + 131, new Rectangle( 0, 30 * pChip.nSenote, 136, 30 ) );
                                        //CDTXMania.act文字コンソール.tPrint( x + 60, y + 140, C文字コンソール.Eフォント種別.白, pChip.nSenote.ToString() );
                                    }
                                    break;

                                case 0x96:
                                    x = ( x + 10 ) - ( ( int )( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
                                    if( this.tx太鼓ノーツ != null )
                                    {
                                        this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 520, num9, 130, 130 ) );
                                        this.txSenotes.t2D描画( CDTXMania.app.Device, x - 2, y + 131, new Rectangle( 0, 30 * pChip.nSenote, 136, 30 ) );
                                        //CDTXMania.act文字コンソール.tPrint( x + 60, y + 140, C文字コンソール.Eフォント種別.白, pChip.nSenote.ToString() );
                                    }
                                    nLane = 1;
                                    break;

                            }
                        }
                    }
                    else if( x < -1000 )
                    {
                        //pChip.bHit = true;
                    }
                }
                else
                {
                    return;
                }

				//int indexSevenLanes = this.nチャンネル0Atoレーン07[ pChip.nチャンネル番号 - 0x11 ];
				if ( ( !pChip.bHit ) && ( pChip.nバーからの距離dot.Drums < 0 ) )
				{
                    if( CDTXMania.ConfigIni.b太鼓パートAutoPlay )
                    {
					    pChip.bHit = true;
                        this.actChipFireTaiko.Start( pChip.nチャンネル番号 - 0x92 );
                        this.actLaneFlushD.Start( nLane, 127f );
                        this.actMtaiko.tMtaikoEvent( pChip.nチャンネル番号, this.nHand );

                        int n大音符 = ( pChip.nチャンネル番号 == 0x95 || pChip.nチャンネル番号 == 0x96 ? 2 : 0);
					    
                        this.tチップのヒット処理( pChip.n発声時刻ms, pChip, E楽器パート.TAIKO, true, nLane + n大音符 );
                        this.tサウンド再生( pChip, pChip.n発声時刻ms, E楽器パート.TAIKO, dTX.nモニタを考慮した音量( E楽器パート.DRUMS ) );
                    }


					//cInvisibleChip.StartSemiInvisible( E楽器パート.DRUMS );
				}
				//break;
				return;
            }
            else
            {
                //pChip.bHit = true;

                return;
            }

            #endregion
            
			#region[古いの]
            //if ( configIni.bDrums有効 )
            //{
            //    #region [ Invisible処理 ]
            //    if ( configIni.eInvisible.Drums != EInvisible.OFF )
            //    {
            //        cInvisibleChip.SetInvisibleStatus( ref pChip );
            //    }
            //    #endregion
            //    else
            //    {
            //        #region [ Sudden処理 ]
            //        if ( configIni.bSudden.Drums )
            //        {
            //            if ( pChip.nバーからの距離dot.Drums < 200 )
            //            {
            //                pChip.b可視 = true;
            //                pChip.n透明度 = 0xff;
            //            }
            //            else if ( pChip.nバーからの距離dot.Drums < 250 )
            //            {
            //                pChip.b可視 = true;
            //                pChip.n透明度 = 0xff - ( (int) ( ( ( (double) ( pChip.nバーからの距離dot.Drums - 200 ) ) * 255.0 ) / 50.0 ) );
            //            }
            //            else
            //            {
            //                pChip.b可視 = false;
            //                pChip.n透明度 = 0;
            //            }
            //        }
            //        #endregion
            //        #region [ Hidden処理 ]
            //        if ( configIni.bHidden.Drums )
            //        {
            //            if ( pChip.nバーからの距離dot.Drums < 100 )
            //            {
            //                pChip.b可視 = false;
            //            }
            //            else if ( pChip.nバーからの距離dot.Drums < 150 )
            //            {
            //                pChip.b可視 = true;
            //                pChip.n透明度 = (int) ( ( ( (double) ( pChip.nバーからの距離dot.Drums - 100 ) ) * 255.0 ) / 50.0 );
            //            }
            //        }
            //        #endregion
            //    }
            //    if ( !pChip.bHit && pChip.b可視 )
            //    {
            //        int x = 414 + pChip.nバーからの距離dot.Taiko;
            //        int y = 192;
            //        int num9 = this.actCombo.n現在のコンボ数.Drums >= 50 ? this.ctチップ模様アニメ.Drums.n現在の値 * 130 : 0;
            //        switch ( pChip.nチャンネル番号 )
            //        {
            //            case 0x93:
            //                x = ( x + 10 ) - ( ( int ) ( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
            //                if( this.tx太鼓ノーツ != null )
            //                {
            //                    this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 130, num9, 130, 130 ) );
            //                }
            //                break;

            //            case 0x94:
            //                x = ( x + 10 ) - ( ( int ) ( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
            //                if( this.tx太鼓ノーツ != null )
            //                {
            //                    this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 260, num9, 130, 130) );
            //                }
            //                break;

            //            case 0x95:
            //                x = ( x + 10 ) - ( ( int )( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
            //                if( this.tx太鼓ノーツ != null )
            //                {
            //                    this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 390, num9, 130, 130 ) );
            //                }
            //                break;

            //            case 0x96:
            //                x = ( x + 10 ) - ( ( int )( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
            //                if( this.tx太鼓ノーツ != null )
            //                {
            //                    this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 520, num9, 130, 130 ) );
            //                }
            //                break;

            //        }
            //        if ( this.txチップ != null )
            //        {
            //            this.txチップ.vc拡大縮小倍率 = new Vector3( 1f, 1f, 1f );
            //            this.txチップ.n透明度 = 0xff;
            //        }
            //    }
            //    else
            //    {
            //        pChip.bHit = true;
            //    }

            //    //int indexSevenLanes = this.nチャンネル0Atoレーン07[ pChip.nチャンネル番号 - 0x11 ];
            //    if ( ( !pChip.bHit ) && ( pChip.nバーからの距離dot.Drums < 0 ) )
            //    {
            //        pChip.bHit = true;
            //        //this.actLaneFlushD.Start( (Eレーン) indexSevenLanes, ( (float) CInput管理.n通常音量 ) / 127f );
            //        //bool flag = this.bフィルイン中;
            //        //bool flag2 = this.bフィルイン中 && this.bフィルイン区間の最後のChipである( pChip );
            //        //bool flag3 = flag2;
            //        // #31602 2013.6.24 yyagi 判定ラインの表示位置をずらしたら、チップのヒットエフェクトの表示もずらすために、nJudgeLine..を追加
            //        //this.actDrumSet.Start( this.nチャンネル0Atoパッド08[ pChip.nチャンネル番号 - 0x11 ] );
            //        this.tサウンド再生( pChip, CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻 + pChip.n発声時刻ms, E楽器パート.TAIKO, dTX.nモニタを考慮した音量( E楽器パート.DRUMS ) );
            //        this.tチップのヒット処理( pChip.n発声時刻ms, pChip );
            //        //cInvisibleChip.StartSemiInvisible( E楽器パート.DRUMS );
            //    }
            //    //break;
            //    return;
            //}	// end of "if configIni.bDrums有効"
            //if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
            //{
            //    this.tサウンド再生( pChip, CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻 + pChip.n発声時刻ms, E楽器パート.DRUMS, dTX.nモニタを考慮した音量( E楽器パート.DRUMS ) );
            //    pChip.bHit = true;
            //}
            #endregion
        }
		protected override void t進行描画・チップ・Taiko連打( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip )
        {
            #region[作り直したもの]
            if( pChip.b可視 )
            {
                int x = 349 + pChip.nバーからの距離dot.Taiko + 10;
                int x末端 = 349 + pChip.nバーからのノーツ末端距離dot.Taiko + 10;
                int y = 192;
                if( ( 1400 > x ) )
                {
                    if( this.tx太鼓ノーツ != null )
                    {
                        //int num9 = this.actCombo.n現在のコンボ数.Drums >= 50 ? this.ctチップ模様アニメ.Drums.n現在の値 * 130 : 0;
                        int num9 = this.actCombo.n現在のコンボ数.Drums >= 50 ? base.n現在の音符の顔番号 * 130 : 0;
                        if (pChip.nチャンネル番号 == 0x97)
                        {
                            //x = ( x + 10 ) - ( ( int ) ( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
                            int index = x末端 - x; //連打の距離

                            this.tx太鼓ノーツ.vc拡大縮小倍率.X = index - 65;
                            this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x + 65, y, new Rectangle( 780, 0, 1, 130 ) );
                            this.tx太鼓ノーツ.vc拡大縮小倍率.X = 1.0f;
                            this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 650, num9, 130, 130 ) );

                            this.txSenotes.vc拡大縮小倍率.X = index - 34;
                            this.txSenotes.t2D描画( CDTXMania.app.Device, x + 90, y + 131, new Rectangle( 60, 240, 1, 30 ) );
                            this.txSenotes.vc拡大縮小倍率.X = 1.0f;
                            this.txSenotes.t2D描画( CDTXMania.app.Device, x, y + 131, new Rectangle(0, 30 * pChip.nSenote, 136, 30));
                            this.txSenotes.t2D描画( CDTXMania.app.Device, x + 30, y + 131, new Rectangle(0, 240, 60, 30));
                            //CDTXMania.act文字コンソール.tPrint( x + 60, y + 140, C文字コンソール.Eフォント種別.白, pChip.nSenote.ToString() );
                            //CDTXMania.act文字コンソール.tPrint(x, y - 58, C文字コンソール.Eフォント種別.白, pChip.dbBPM.ToString());
                            //CDTXMania.act文字コンソール.tPrint(x, y - 42, C文字コンソール.Eフォント種別.白, pChip.dbSCROLL.ToString());
                            //CDTXMania.act文字コンソール.tPrint(x, y - 26, C文字コンソール.Eフォント種別.白, pChip.n発声時刻ms.ToString());
                            //CDTXMania.act文字コンソール.tPrint(x, y - 10, C文字コンソール.Eフォント種別.白, pChip.nノーツ終了時刻ms.ToString());
                        }
                        if( pChip.nチャンネル番号 == 0x98 )
                        {
                            //x = ( x + 10 ) - ( ( int ) ( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
                            int index = x末端 - x; //連打の距離

                            this.tx太鼓ノーツ.vc拡大縮小倍率.X = index - 65;
                            this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x + 65, y, new Rectangle( 1170, 0, 1, 130 ) );
                            this.tx太鼓ノーツ.vc拡大縮小倍率.X = 1.0f;
                            this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 1040, num9, 130, 130 ) );

                            this.txSenotes.vc拡大縮小倍率.X = index - 60;
                            this.txSenotes.t2D描画( CDTXMania.app.Device, x + 116, y + 131, new Rectangle( 60, 240, 1, 30 ) );
                            this.txSenotes.vc拡大縮小倍率.X = 1.0f;
                            this.txSenotes.t2D描画(CDTXMania.app.Device, x - 2, y + 131, new Rectangle(0, 30 * pChip.nSenote, 136, 30));
                            this.txSenotes.t2D描画(CDTXMania.app.Device, x + 56, y + 131, new Rectangle(0, 240, 60, 30));
                            //CDTXMania.act文字コンソール.tPrint(x, y - 26, C文字コンソール.Eフォント種別.白, pChip.n発声時刻ms.ToString());
                            //CDTXMania.act文字コンソール.tPrint( x, y - 10, C文字コンソール.Eフォント種別.白, pChip.nノーツ終了時刻ms.ToString() );
                            //CDTXMania.act文字コンソール.tPrint( x + 60, y + 140, C文字コンソール.Eフォント種別.白, pChip.nSenote.ToString() );
                        }
                        if( pChip.nチャンネル番号 == 0x99 )
                        {
                            if( pChip.n発声時刻ms < CSound管理.rc演奏用タイマ.n現在時刻ms && pChip.nノーツ終了時刻ms > CSound管理.rc演奏用タイマ.n現在時刻ms )
                                x = 349;
                            this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 1430, num9, 260, 130 ) );

                            this.txSenotes.t2D描画(CDTXMania.app.Device, x - 2, y + 131, new Rectangle(0, 30 * pChip.nSenote, 136, 30));
                        }
                        if( pChip.nチャンネル番号 == 0x9A )
                        {
                            //大きい連打か小さい連打かの区別方法を考えてなかったよちくしょう
                            this.tx太鼓ノーツ.vc拡大縮小倍率.X = 1.0f;
                            int n = 0;
                            switch( pChip.n連打音符State )
                            {
                                case 5:
                                    n = 910;
                                    break;
                                case 6:
                                    n = 1300;
                                    break;
                                default:
                                    n = 910;
                                    break;
                            }
                            if( pChip.n連打音符State != 7 )
                            {
                                this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( n, num9, 130, 130 ) );//大音符:1170
                                this.txSenotes.t2D描画(CDTXMania.app.Device, x + 56, y + 131, new Rectangle( 58, 270, 78, 30 ) );
                            }


                            //CDTXMania.act文字コンソール.tPrint(x, y - 10, C文字コンソール.Eフォント種別.白, pChip.n発声時刻ms.ToString());
                            //CDTXMania.act文字コンソール.tPrint(x, y - 26, C文字コンソール.Eフォント種別.白, pChip.n連打音符State.ToString());
                            //CDTXMania.act文字コンソール.tPrint(x, y - 42, C文字コンソール.Eフォント種別.白, pChip.dbSCROLL.ToString());
                            //CDTXMania.act文字コンソール.tPrint(x, y - 58, C文字コンソール.Eフォント種別.白, pChip.dbBPM.ToString());

                        }
                    }
                }
            }
            if( pChip.n発声時刻ms < CSound管理.rc演奏用タイマ.n現在時刻ms && pChip.nノーツ終了時刻ms > CSound管理.rc演奏用タイマ.n現在時刻ms )
            {
                //時間内でかつ0x9Aじゃないならならヒット処理
                if( pChip.nチャンネル番号 != 0x9A && CDTXMania.ConfigIni.b太鼓パートAutoPlay )
                    this.tチップのヒット処理( pChip.n発声時刻ms, pChip );
            }
            #endregion


            #region[古いの]
            //if ( configIni.bDrums有効 )
            //{
            //    if( !pChip.bHit && pChip.b可視 )
            //    {
            //        int x = 349 + pChip.nバーからの距離dot.Taiko + 10;
            //        int x末端 = 349 + pChip.nバーからのノーツ末端距離dot.Taiko + 10;
            //        int y = 192;

            //        if( ( 1280 > x ) )
            //        {
            //            if( this.tx太鼓ノーツ != null )
            //            {
            //                int num9 = this.actCombo.n現在のコンボ数.Drums >= 50 ? this.ctチップ模様アニメ.Drums.n現在の値 * 130 : 0;
            //                if( pChip.nチャンネル番号 == 0x97 )
            //                {
            //                    //x = ( x + 10 ) - ( ( int ) ( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
            //                    int index = x末端 - x; //連打の距離

            //                    this.tx太鼓ノーツ.vc拡大縮小倍率.X = index - 65;
            //                    this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x + 65, y, new Rectangle( 780, 0, 1, 130 ) );
            //                    this.tx太鼓ノーツ.vc拡大縮小倍率.X = 1.0f;
            //                    this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 650, num9, 130, 130 ) );

            //                    CDTXMania.act文字コンソール.tPrint( x, y - 30, C文字コンソール.Eフォント種別.白, pChip.n発声時刻ms.ToString() );
            //                    CDTXMania.act文字コンソール.tPrint( x, y - 10, C文字コンソール.Eフォント種別.白, pChip.nノーツ終了時刻ms.ToString() );

            //                    this.n9AFlag = 5;
            //                }
            //                if( pChip.nチャンネル番号 == 0x98 )
            //                {
            //                    //x = ( x + 10 ) - ( ( int ) ( ( 130.0 * pChip.dbチップサイズ倍率 ) / 2.0 ) );
            //                    int index = x末端 - x; //連打の距離

            //                    this.tx太鼓ノーツ.vc拡大縮小倍率.X = index - 65;
            //                    this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x + 65, y, new Rectangle( 1170, 0, 1, 130 ) );
            //                    this.tx太鼓ノーツ.vc拡大縮小倍率.X = 1.0f;
            //                    this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( 1040, num9, 130, 130 ) );

            //                    this.n9AFlag = 6;
            //                }
            //                if( pChip.nチャンネル番号 == 0x9A )
            //                {
            //                    //大きい連打か小さい連打かの区別方法を考えてなかったよちくしょう
            //                    this.tx太鼓ノーツ.vc拡大縮小倍率.X = 1.0f;
            //                    int n = 0;
            //                    switch( base.n9AFlag )
            //                    {
            //                        case 5:
            //                            n = 910;
            //                            break;
            //                        case 6:
            //                            n = 1300;
            //                            break;
            //                        case 7:
            //                            n = -130;
            //                            break;
            //                        default:
            //                            n = 910;
            //                            break;
            //                    }
            //                    this.tx太鼓ノーツ.t2D描画( CDTXMania.app.Device, x, y, new Rectangle( n, num9, 130, 130 ) );//大音符:1170
            //                    CDTXMania.act文字コンソール.tPrint( x, y - 10, C文字コンソール.Eフォント種別.白, pChip.n発声時刻ms.ToString() );
            //                    CDTXMania.act文字コンソール.tPrint( x, y - 26, C文字コンソール.Eフォント種別.白, this.n9AFlag.ToString() );
            //                }
            //            }

            //            if( /*pChip.nバーからのノーツ末端距離dot.Taiko > 0 &&*/ pChip.nチャンネル番号 != 0x9A )
            //            {
            //                this.tチップのヒット処理( pChip.n発声時刻ms, pChip );
            //                pChip.bHit = false;
            //            }
            //            else
            //            {
            //                pChip.bHit = false;
            //            }
            //        }
            //        else if( pChip.nバーからのノーツ末端距離dot.Taiko < 0 && pChip.nチャンネル番号 != 0x9A )
            //        {
            //            pChip.bHit = true;
            //        }
            //    }
            //}
            #endregion
		}

		protected override void t進行描画・チップ・ドラムス( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip )
		{
			if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
			{
				this.tサウンド再生( pChip, CSound管理.rc演奏用タイマ.n前回リセットした時のシステム時刻 + pChip.n発声時刻ms, E楽器パート.DRUMS, dTX.nモニタを考慮した音量( E楽器パート.DRUMS ) );
				pChip.bHit = true;
			}
		}
        protected override void t進行描画・チップ本体・ドラムス( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip )
		{
		}
		protected override void t進行描画・チップ・ギターベース( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip, E楽器パート inst )
		{
		}
		protected override void t進行描画・チップ・ギター・ウェイリング( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip )
		{
		}
		protected override void t進行描画・チップ・フィルイン( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip )
		{

		}

		protected override void t進行描画・チップ・ベース・ウェイリング( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip )
		{
		}
		protected override void t進行描画・チップ・空打ち音設定・ドラム( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip )
		{
			if ( !pChip.bHit && ( pChip.nバーからの距離dot.Drums < 0 ) )
			{
				pChip.bHit = true;
				this.r現在の空うちドラムChip[ (int) this.eチャンネルtoパッド[ pChip.nチャンネル番号 - 0xb1 ] ] = pChip;
				//pChip.nチャンネル番号 = ( pChip.nチャンネル番号 != 0xbc ) ? ( ( pChip.nチャンネル番号 - 0xb1 ) + 0x11 ) : 0x1a;
			}
		}
		protected override void t進行描画・チップ・小節線( CConfigIni configIni, ref CDTX dTX, ref CDTX.CChip pChip )
		{
			int n小節番号plus1 = pChip.n発声位置 / 384;
            int x = 414 + pChip.nバーからの距離dot.Taiko;
            int y = 192;
			if ( !pChip.bHit && ( pChip.nバーからの距離dot.Taiko < 0 ) )
			{
				pChip.bHit = true;
				this.actPlayInfo.n小節番号 = n小節番号plus1 - 1;
				if ( configIni.bWave再生位置自動調整機能有効 && ( bIsDirectSound || bUseOSTimer ) )
				{
					dTX.tWave再生位置自動補正();
				}
			}
			if ( configIni.b演奏情報を表示する )
			{
				int n小節番号 = n小節番号plus1 - 1;
                   if( x >= 310 )
				    CDTXMania.act文字コンソール.tPrint( x + 8, y - 26, C文字コンソール.Eフォント種別.白, n小節番号.ToString() );
				    //CDTXMania.act文字コンソール.tPrint( x + 8, y - 10, C文字コンソール.Eフォント種別.白, pChip.dbBPM.ToString() );
			}
			if ( ( pChip.b可視 ) && ( this.tx小節線 != null ) )
			{
                if( x >= 0 )
                {
                    if( pChip.bBranch )
                    {
                        this.tx小節線_branch.t2D描画( CDTXMania.app.Device, x + 8, y, new Rectangle( 0, 0, 3, 130 ) );
                    }
                    else
                    {
                        this.tx小節線.t2D描画( CDTXMania.app.Device, x + 8, y, new Rectangle( 0, 0, 3, 130 ) );
                    }
                }
			}
		}

        protected void t進行描画・レーン()
        {
            this.actLane.On進行描画();
        }

        protected void t進行描画・ドラムセット()
        {
            this.actDrumSet.On進行描画();
        }

        public void t進行描画・BPMバー()
        {
            this.actBPMBarD.On進行描画();
        }

        /// <summary>
        /// 全体にわたる制御をする。
        /// </summary>
        public void t全体制御メソッド()
        {
            int t = (int)CSound管理.rc演奏用タイマ.n現在時刻ms;
            //CDTXMania.act文字コンソール.tPrint( 0, 16, C文字コンソール.Eフォント種別.白, t.ToString() );

            if( this.chip現在処理中の連打チップ != null )
            {
                int n = this.chip現在処理中の連打チップ.nチャンネル番号;


                if( this.chip現在処理中の連打チップ.nチャンネル番号 == 0x97 || this.chip現在処理中の連打チップ.nチャンネル番号 == 0x98 )
                {
                    if( ( this.chip現在処理中の連打チップ.n発声時刻ms <= (int)CSound管理.rc演奏用タイマ.n現在時刻ms && this.chip現在処理中の連打チップ.nノーツ終了時刻ms >= (int)CSound管理.rc演奏用タイマ.n現在時刻ms ) && this.n現在の連打数 != 0 )
                        this.actRoll.On進行描画( this.n現在の連打数 );
                    else
                        this.n現在の連打数 = 0;
                }
                else if( this.chip現在処理中の連打チップ.nチャンネル番号 == 0x99 && this.b連打中 == true )
                //else if( this.chip現在処理中の連打チップ.nチャンネル番号 == 0x99 && this.actChara.b風船連打中 == true )
                {
                    //if (this.chip現在処理中の連打チップ.n発声時刻ms <= (int)CSound管理.rc演奏用タイマ.n現在時刻ms && this.chip現在処理中の連打チップ.nノーツ終了時刻ms >= (int)CSound管理.rc演奏用タイマ.n現在時刻ms)
                    if( this.chip現在処理中の連打チップ.n発声時刻ms <= (int)CSound管理.rc演奏用タイマ.n現在時刻ms && this.chip現在処理中の連打チップ.nノーツ終了時刻ms + 500 >= (int)CSound管理.rc演奏用タイマ.n現在時刻ms)
                        this.actBalloon.On進行描画(this.n風船残り);
                    else
                        this.n現在の連打数 = 0;
                }
            }

            #region[ 譜面分岐ガイド建設予定地 ]
            //現在実験状態です。
            //画像などが完成したらメソッドorクラスとして分離します。

            float f現在の精度 = 0;
            int n種類 = 0;
            int n次回分岐までの小節数 = 0;
            string strNext = "BRANCH END";

            if( ( this.n分岐した回数 < CDTXMania.DTX.listBRANCH.Count ) && CDTXMania.ConfigIni.bBranchGuide && !CDTXMania.ConfigIni.b太鼓パートAutoPlay )
            {
                f現在の精度 = 0;
                n種類 = CDTXMania.DTX.listBRANCH[this.n分岐した回数].n分岐の種類;
                strNext = "NORMAL";
                n次回分岐までの小節数 = ( CDTXMania.DTX.listBRANCH[this.n分岐した回数].n現在の小節 - 2 ) - CDTXMania.stage演奏ドラム画面.actPlayInfo.n小節番号;

                if( CDTXMania.stage演奏ドラム画面.actPlayInfo.n小節番号 < 0 )
                {
                    n次回分岐までの小節数 = CDTXMania.DTX.listBRANCH[this.n分岐した回数].n現在の小節 - 2;
                }

                if( ( this.nBranch_Perfect + this.nBranch_Good + this.nBranch_Miss ) != 0 )
                {
                    f現在の精度 = ((float)this.nBranch_Perfect / (float)(this.nBranch_Perfect + this.nBranch_Good + this.nBranch_Miss)) * 100.0f;
                }

                if( n種類 == 0 )
                {
                    if( f現在の精度 < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A )
                    {
                        strNext = "NORMAL";
                    }
                    else if( f現在の精度 >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A && f現在の精度 < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                    {
                        strNext = "EXPERT";
                    }
                    else if( f現在の精度 >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                    {
                        strNext = "MASTER";
                    }

                    CDTXMania.act文字コンソール.tPrint( 0, 128, C文字コンソール.Eフォント種別.白, f現在の精度.ToString() );
                }
                if( n種類 == 1 )
                {
                    if( this.nBranch_roll < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A )
                    {
                        strNext = "NORMAL";
                    }
                    else if( this.nBranch_roll >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値A && this.nBranch_roll < CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                    {
                        strNext = "EXPERT";
                    }
                    else if( this.nBranch_roll >= CDTXMania.DTX.listBRANCH[this.n分岐した回数].n条件数値B )
                    {
                        strNext = "MASTER";
                    }

                    CDTXMania.act文字コンソール.tPrint( 0, 128, C文字コンソール.Eフォント種別.白, this.nBranch_roll.ToString() );
                }


                CDTXMania.act文字コンソール.tPrint( 0, 160, C文字コンソール.Eフォント種別.白, string.Format( "NEXT BRANCH:{0:##0}", n次回分岐までの小節数.ToString() ) );
                CDTXMania.act文字コンソール.tPrint( 0, 362, C文字コンソール.Eフォント種別.白, string.Format( "NEXT BRANCH INFO:{0:##0} , {1:##0}", CDTXMania.DTX.listBRANCH[ this.n分岐した回数 ].n条件数値A.ToString(), CDTXMania.DTX.listBRANCH[ this.n分岐した回数 ].n条件数値B.ToString() ) );
                CDTXMania.act文字コンソール.tPrint( 0, 144, C文字コンソール.Eフォント種別.白, strNext.ToString() );
            }
            else if( ( this.n分岐した回数 >= CDTXMania.DTX.listBRANCH.Count ) && CDTXMania.ConfigIni.bBranchGuide && !CDTXMania.ConfigIni.b太鼓パートAutoPlay  )
            {
                CDTXMania.act文字コンソール.tPrint( 0, 144, C文字コンソール.Eフォント種別.白, strNext.ToString() );
            }
            #endregion

            #region[ 片手判定をこっちに持ってきてみる。]
            //常時イベントが発生しているメソッドのほうがいいんじゃないかという予想。
            CDTX.CChip chipNoHit = this.r指定時刻に一番近い未ヒットChip((int)CSound管理.rc演奏用タイマ.n現在時刻ms, 0);
            E判定 e判定 = (chipNoHit != null) ? this.e指定時刻からChipのJUDGEを返す(chipNoHit.nProcessTime, chipNoHit, 0) : E判定.Miss;

            if( chipNoHit != null )
            {
                C文字コンソール.Eフォント種別 eColor = chipNoHit.nチャンネル番号 == 0x97 ? C文字コンソール.Eフォント種別.赤 : C文字コンソール.Eフォント種別.白;
                //CDTXMania.act文字コンソール.tPrint(0, 0 + 32, eColor, (chipNoHit.nチャンネル番号).ToString("x"));
            }

            if( chipNoHit != null && ( chipNoHit.nチャンネル番号 == 0x95 || chipNoHit.nチャンネル番号 == 0x96 ) )
            {

                float timeC = chipNoHit.n発声時刻ms - CSound管理.rc演奏用タイマ.n現在時刻ms;
                int nWaitTime = CDTXMania.ConfigIni.n両手判定の待ち時間;
                if (chipNoHit.eNoteState == ENoteState.wait && timeC < 110 && chipNoHit.nProcessTime + nWaitTime <= (int)CSound管理.rc演奏用タイマ.n現在時刻ms)
                {
                    this.tドラムヒット処理(chipNoHit.nProcessTime, Eパッド.RRed, chipNoHit, 127);
                    this.nWaitButton = 0;
                    chipNoHit.eNoteState = ENoteState.none;
                    chipNoHit.bHit = true;
                }
            }
            #endregion

            string strNull = "Found";
            //CDTXMania.act文字コンソール.tPrint(0, 0, C文字コンソール.Eフォント種別.白, (this.b連打中).ToString());
            if( this.chip現在処理中の連打チップ == null )
            {
                //strNull = "null";

                if( chipNoHit != null )
                {
                    //こっちでchip現在処理中の連打チップを管理してみる。
                    //とりあえず連打チップ発声時刻の1ミリ秒前に割り当てみる。
                    if( chipNoHit.nチャンネル番号 >= 0x97 && chipNoHit.nチャンネル番号 <= 0x99 )
                    {
                        //if( chipNoHit.n発声時刻ms - 1 == CSound管理.rc演奏用タイマ.n現在時刻ms )
                        {
                            //if( chipNoHit.nコース == this.n現在のコース )
                            //    chip現在処理中の連打チップ = chipNoHit;
                        }
                    }
                }


            }

            //CDTXMania.act文字コンソール.tPrint(0, 0, C文字コンソール.Eフォント種別.白, this.nGauge.ToString());
            //CDTXMania.act文字コンソール.tPrint(0, 0, C文字コンソール.Eフォント種別.白, this.actChara.ct通常モーション.db現在の経過時間.ToString());
            //CDTXMania.act文字コンソール.tPrint(0, 0 + 16, C文字コンソール.Eフォント種別.白, this.actChara.ct通常モーション.db現在の値.ToString());

        }

		#endregion
	}
}
