/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.mathematics.zinc.core;

import java.util.function.IntSupplier;

public class ZincTransform {
    public double pixelsPerX = 100.0;
    public double pixelsPerY = 100.0;
    public double centerCoordX = 0.0;
    public double centerCoordY = 0.0;
    public IntSupplier supplierScreenWidth;
    public IntSupplier supplierScreenHeight;

    public ZincTransform(IntSupplier supplierScreenWidth, IntSupplier supplierScreenHeight) {
        this.supplierScreenWidth = supplierScreenWidth;
        this.supplierScreenHeight = supplierScreenHeight;
    }

    public double getCoordX(double screenX) {
        return this.centerCoordX + (screenX - (double)(this.getScreenWidth() / 2)) / this.pixelsPerX;
    }

    public double getCoordY(double screenY) {
        return -(this.centerCoordY + (screenY - (double)(this.getScreenHeight() / 2)) / this.pixelsPerY);
    }

    public double getScreenX(double coordX) {
        return (coordX - this.centerCoordX) * this.pixelsPerX + (double)(this.getScreenWidth() / 2);
    }

    public double getScreenY(double coordY) {
        return (-coordY - this.centerCoordY) * this.pixelsPerY + (double)(this.getScreenHeight() / 2);
    }

    public int getScreenWidth() {
        return this.supplierScreenWidth.getAsInt();
    }

    public int getScreenHeight() {
        return this.supplierScreenHeight.getAsInt();
    }
}

