/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.nitrogen.modules.rendering;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import mirrg.applet.nitrogen.NitrogenEventApplet;
import mirrg.event.nitrogen.INitrogenEventManager;

public class BackBuffer {
    private int imageType;
    private BufferedImage buffer;
    private Graphics2D graphics;

    public BackBuffer(int imageType) {
        this.imageType = imageType;
    }

    public synchronized void rebuffer(int width, int height) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        BufferedImage buffer = new BufferedImage(width, height, this.imageType);
        Graphics2D graphics = buffer.createGraphics();
        if (this.buffer != null) {
            graphics.drawImage((Image)this.buffer, 0, 0, null);
        }
        this.set(buffer, graphics);
    }

    public synchronized void set(BufferedImage bufferSafety, Graphics2D graphicsSafety) {
        this.buffer = bufferSafety;
        this.graphics = graphicsSafety;
    }

    public synchronized BufferedImage getBuffer() {
        return this.buffer;
    }

    public synchronized Graphics2D getGraphics() {
        return this.graphics;
    }

    public synchronized int getWidth() {
        return this.buffer.getWidth();
    }

    public synchronized int getHeight() {
        return this.buffer.getHeight();
    }

    public void clear() {
        this.getGraphics().clearRect(0, 0, this.getWidth(), this.getHeight());
    }

    public synchronized void flip(BackBuffer other) {
        Object tmp = this.buffer;
        this.buffer = other.buffer;
        other.buffer = tmp;
        tmp = this.graphics;
        this.graphics = other.graphics;
        other.graphics = tmp;
    }

    public void subscribeEvent(INitrogenEventManager eventManager) {
        eventManager.register(NitrogenEventApplet.Rebuffer.class, event -> this.rebuffer(event.width, event.height));
    }
}

