/*
 * Decompiled with CFR 0.152.
 */
package mirrg.compile.iodine;

import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mirrg.compile.iodine.CompileManager;
import mirrg.compile.iodine.INode;
import mirrg.struct.hydrogen.Tuple3;
import mirrg.util.hydrogen.HString;

public class CompileResult<T> {
    public CompileManager<T> compileManager;
    public String source;
    public boolean success = false;
    public INode<T> syntax;
    private ArrayList<ArrayList<Supplier<String>>> messages = new ArrayList();

    public CompileResult(CompileManager<T> compileManager, String source) {
        this.compileManager = compileManager;
        this.source = source;
    }

    public void registerMessage(Integer start, Supplier<String> supplier) {
        while (start >= this.messages.size()) {
            this.messages.add(new ArrayList());
        }
        this.messages.get(start).add(supplier);
    }

    public Tuple3<int[], String[], Stream<String>> getMessages() {
        int start = this.messages.size() - 1;
        if (start == -1) {
            return new Tuple3<int[], String[], Stream<String>>(new int[]{0, 1, 0}, new String[]{"", ""}, Stream.empty());
        }
        HString.LineProvider lineProvider = HString.getLineProvider(this.source);
        int row = lineProvider.getLineNumber(start);
        int column = start - lineProvider.getStartIndex(row);
        String line = lineProvider.getContent(row);
        String left = line.substring(Math.max(column - 20, 0), column);
        String right = line.substring(column, Math.min(column + 20, line.length()));
        return new Tuple3<int[], String[], Stream<String>>(new int[]{start, row, column}, new String[]{left, right}, this.messages.get(start).stream().map(Supplier::get).distinct());
    }

    public void setMessages(ArrayList<ArrayList<Supplier<String>>> messages) {
        this.messages = messages;
    }

    public String getMessageString() {
        Tuple3<int[], String[], Stream<String>> messages2 = this.getMessages();
        return String.format("(L:%s, C:%s) '%s#%s'", messages2.getX()[1], messages2.getX()[2], messages2.getY()[0], messages2.getY()[1]) + "\n" + messages2.getZ().map(message -> String.format("    %s", message)).collect(Collectors.joining("\n"));
    }
}

