/*
 * Decompiled with CFR 0.152.
 */
package mirrg.compile.iodine.statements;

import java.util.function.Predicate;
import java.util.function.Supplier;
import mirrg.compile.iodine.CompileArguments;
import mirrg.compile.iodine.EnumCaseSensitivity;
import mirrg.compile.iodine.INode;
import mirrg.compile.iodine.statements.ITagToken;
import mirrg.compile.iodine.statements.StatementCreatorNode;
import mirrg.util.hydrogen.HString;

public class StatementToken<T extends ITagToken>
extends StatementCreatorNode<T> {
    public String token;
    public EnumCaseSensitivity caseSensitivity;
    public Predicate<Character> predicateCharactorIsTokenable;

    public StatementToken(Supplier<T> creatorTag, String token, EnumCaseSensitivity caseSensitivity, Predicate<Character> predicateCharactorIsTokenable) {
        super(creatorTag);
        this.token = token;
        this.caseSensitivity = caseSensitivity;
        this.predicateCharactorIsTokenable = predicateCharactorIsTokenable;
    }

    public StatementToken(Supplier<T> creatorTag, String token, boolean isIdentifier) {
        this(creatorTag, token, EnumCaseSensitivity.ALL, ch -> {
            if (isIdentifier) {
                if ('a' <= ch.charValue() && ch.charValue() <= 'z') {
                    return true;
                }
                if ('A' <= ch.charValue() && ch.charValue() <= 'Z') {
                    return true;
                }
                if ('0' <= ch.charValue() && ch.charValue() <= '9') {
                    return true;
                }
                return '_' == ch.charValue();
            }
            return false;
        });
    }

    @Override
    public INode<? extends T> parse(CompileArguments compileArguments, int start, Predicate<INode<T>> predicateNode) {
        block8: {
            String source = compileArguments.getSource();
            if (!(start + this.token.length() > source.length() || start + this.token.length() < source.length() && this.predicateCharactorIsTokenable.test(Character.valueOf(source.charAt(start + this.token.length()))))) {
                for (int i = 0; i < this.token.length(); ++i) {
                    char t = this.token.charAt(i);
                    char s = source.charAt(start + i);
                    switch (this.caseSensitivity) {
                        case ALL: {
                            break;
                        }
                        case HEAD: {
                            if (i != 0) break;
                            t = HString.toUpperCase(t);
                            s = HString.toUpperCase(s);
                            break;
                        }
                        case NONE: {
                            t = HString.toUpperCase(t);
                            s = HString.toUpperCase(s);
                            break;
                        }
                    }
                    if (t == s) {
                        continue;
                    }
                    break block8;
                }
                String string = source.substring(start, start + this.token.length());
                INode node = this.createNode(start, string.length());
                ((ITagToken)node.getTag()).set(string, this.token);
                return predicateNode.test(node) ? node : null;
            }
        }
        compileArguments.registerMessage(start, () -> "\u6b21\u306e\u30c8\u30fc\u30af\u30f3\u304c\u8003\u3048\u3089\u308c\u307e\u3059: '" + this.token + "'");
        return null;
    }
}

