/*
 * Decompiled with CFR 0.152.
 */
package mirrg.compile.iodine.util;

import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import mirrg.compile.iodine.INode;
import mirrg.compile.iodine.IStatement;
import mirrg.compile.iodine.statements.ITagPattern;
import mirrg.compile.iodine.statements.ITagToken;
import mirrg.compile.iodine.statements.StatementPattern;
import mirrg.compile.iodine.statements.StatementToken;
import mirrg.compile.iodine.statements.StatementVoid;
import mirrg.compile.iodine.statements.connection.ITagParent;
import mirrg.compile.iodine.statements.connection.StatementLoop;
import mirrg.compile.iodine.statements.connection.StatementSerial;
import mirrg.compile.iodine.statements.wrapper.StatementFilter;
import mirrg.compile.iodine.statements.wrapper.StatementMap;
import mirrg.compile.iodine.statements.wrapper.StatementOptional;
import mirrg.compile.iodine.statements.wrapper.StatementOr;
import mirrg.compile.iodine.statements.wrapper.StatementWrapper;
import mirrg.compile.iodine.util.ITagOperator;
import mirrg.compile.iodine.util.StatementOperator;

public class HStatements {
    public static <IN extends OUT, OUT> IStatement<OUT> wrap(IStatement<IN> in) {
        return new StatementWrapper(in);
    }

    public static <T extends ITagPattern> StatementPattern<T> pattern(Supplier<T> supplierTag, String pattern, String messageString) {
        return new StatementPattern<T>(supplierTag, Pattern.compile(pattern), messageString);
    }

    public static <T extends ITagToken> StatementToken<T> token(Supplier<T> supplierTag, String token, boolean isIdentifier) {
        return new StatementToken<T>(supplierTag, token, isIdentifier);
    }

    public static <T extends ITagOperator<E, O>, E, O> StatementOperator<T, E, O> operator(Supplier<T> supplierTag, IStatement<E> expression, IStatement<O> operator) {
        return new StatementOperator<T, E, O>(supplierTag, expression, operator);
    }

    public static <T> StatementOr<T> or() {
        return new StatementOr();
    }

    public static <T> StatementSerial<T> serial(Supplier<T> supplierTag) {
        return new StatementSerial<T>(supplierTag);
    }

    public static <T extends ITagParent<C>, C> StatementLoop<T, C> loop(Supplier<T> supplierTag, IntPredicate predicateLength, IStatement<C> statement) {
        return new StatementLoop<T, C>(supplierTag, predicateLength, statement);
    }

    public static <T extends ITagParent<C>, C> StatementLoop<T, C> loop(Supplier<T> supplierTag, IStatement<C> statement) {
        return HStatements.loop(supplierTag, length -> true, statement);
    }

    public static <T> StatementOptional<T> optional(Supplier<T> supplierTag, IStatement<T> statement) {
        return new StatementOptional<T>(supplierTag, statement);
    }

    public static <T> StatementVoid<T> voidStatement(Supplier<T> supplierTag) {
        return new StatementVoid<T>(supplierTag);
    }

    public static <T> IStatement<T> filter(IStatement<T> statement, Predicate<INode<T>> predicate) {
        return new StatementFilter<T>(statement, predicate);
    }

    public static <IN, OUT> IStatement<OUT> map(IStatement<IN> in, Function<IN, OUT> function) {
        return new StatementMap<IN, OUT>(in, function);
    }
}

