/*
 * Decompiled with CFR 0.152.
 */
package mirrg.game.complexcanvas.wulfenite.script;

import java.util.ArrayList;
import java.util.stream.Collectors;
import mirrg.compile.iodine.CompileResult;
import mirrg.compile.iodine.INode;
import mirrg.game.complexcanvas.wulfenite.script.IWulfeniteScript;
import mirrg.struct.hydrogen.Tuple;
import mirrg.util.hydrogen.HString;

public class ArgumentWulfeniteScriptValidate {
    public final CompileResult<IWulfeniteScript> result;
    private ArrayList<Tuple<INode<?>, String>> messages = new ArrayList();
    public StackFrameRoot stackFrameRoot = new StackFrameRoot();
    public RegisterFrameRoot registerFrameRoot = new RegisterFrameRoot();

    public ArgumentWulfeniteScriptValidate(CompileResult<IWulfeniteScript> result) {
        this.result = result;
    }

    public void addMessage(INode<?> parent, String message) {
        this.messages.add(new Tuple(parent, message));
    }

    public String getMessageString() {
        HString.LineProvider lineProvider = HString.getLineProvider(this.result.source);
        return this.messages.stream().map(message -> {
            int start = ((INode)message.getX()).getStart();
            int row = lineProvider.getLineNumber(start);
            int column = start - lineProvider.getStartIndex(row);
            String line = lineProvider.getContent(row);
            String left = line.substring(Math.max(column - 20, 0), column);
            String right = line.substring(column, Math.min(column + 20, line.length()));
            return String.format("(L:%s, C:%s) '%s#%s' %s", row, column, left, right, message.getY());
        }).collect(Collectors.joining("\n"));
    }

    public static class RegisterFrame {
        private RegisterFrameRoot registerFrameRoot;
        public RegisterFrame parent;
        private int registerCount;

        public RegisterFrame(RegisterFrameRoot registerFrameRoot, RegisterFrame parent) {
            this.registerFrameRoot = registerFrameRoot;
            this.parent = parent;
        }

        public int defineRegister() {
            ++this.registerCount;
            int index = this.getRegisterCount();
            if (this.registerFrameRoot.maxRegisterCount < index) {
                this.registerFrameRoot.maxRegisterCount = index;
            }
            return index - 1;
        }

        public int getRegisterCount() {
            return this.registerCount + (this.parent == null ? 0 : this.parent.getRegisterCount());
        }
    }

    public static class RegisterFrameRoot {
        private RegisterFrame registerFrame = new RegisterFrame(this, null);
        public int maxRegisterCount = 0;

        public RegisterFrame getRegisterFrame() {
            return this.registerFrame;
        }

        public void pushRegisterFrame() {
            this.registerFrame = new RegisterFrame(this, this.registerFrame);
        }

        public void popRegisterFrame() {
            this.registerFrame = this.registerFrame.parent;
        }
    }

    public static class StackFrame {
        private StackFrameRoot stackFrameRoot;
        public StackFrame parent;
        private ArrayList<String> variables = new ArrayList();

        public StackFrame(StackFrameRoot stackFrameRoot, StackFrame parent) {
            this.stackFrameRoot = stackFrameRoot;
            this.parent = parent;
        }

        public boolean containsVariable(String name) {
            if (this.variables.contains(name)) {
                return true;
            }
            return this.parent == null ? false : this.parent.containsVariable(name);
        }

        public Integer defineVariable(String name) {
            if (this.containsVariable(name)) {
                return null;
            }
            this.variables.add(name);
            int index = this.getVariablesCount();
            if (this.stackFrameRoot.maxVariableCount < index) {
                this.stackFrameRoot.maxVariableCount = index;
            }
            return index - 1;
        }

        public int getVariablesCount() {
            return this.variables.size() + (this.parent == null ? 0 : this.parent.getVariablesCount());
        }

        public Integer getVariableIndex(String name) {
            int index = this.variables.indexOf(name);
            if (index != -1) {
                return index + (this.parent == null ? 0 : this.parent.getVariablesCount());
            }
            return this.parent == null ? null : this.parent.getVariableIndex(name);
        }
    }

    public static class StackFrameRoot {
        private StackFrame stackFrame = new StackFrame(this, null);
        public int maxVariableCount = 0;

        public StackFrame getStackFrame() {
            return this.stackFrame;
        }

        public void pushStackFrame() {
            this.stackFrame = new StackFrame(this, this.stackFrame);
        }

        public void popStackFrame() {
            this.stackFrame = this.stackFrame.parent;
        }
    }
}

