/*
 * Decompiled with CFR 0.152.
 */
package mirrg.util.hydrogen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HString {
    static final Pattern PATTERN_NUMBER = Pattern.compile("\\A[0-9]+");
    static final Pattern PATTERN_NOT_NUMBER = Pattern.compile("\\A[^0-9]+");
    private static Pattern lineBreak = Pattern.compile("(?:\n|\r\n?)");

    public static int compareWithNumber(String a, String b) {
        return HString.compareWithNumberImpl(a, b, String::compareTo);
    }

    public static int compareWithNumberIgnoreCase(String a, String b) {
        return HString.compareWithNumberImpl(a, b, String::compareToIgnoreCase);
    }

    public static int compareWithNumberImpl(String a, String b, Comparator<String> comparator) {
        String sb;
        String sa;
        int compare;
        SplitStringStream sssa = new SplitStringStream(a);
        SplitStringStream sssb = new SplitStringStream(b);
        do {
            boolean inNumber = sssa.isNextStringInNumber();
            sa = sssa.getNext();
            sb = sssb.getNext();
            if (sa == null) {
                if (sb != null) {
                    return -1;
                }
                return 0;
            }
            if (sb == null) {
                return 1;
            }
            if (!inNumber) continue;
            int la = sa.length();
            int lb = sb.length();
            int length = Math.max(la, lb);
            sa = HString.rept('0', length - la) + sa;
            sb = HString.rept('0', length - lb) + sb;
        } while ((compare = comparator.compare(sa, sb)) == 0);
        return compare > 0 ? 1 : -1;
    }

    public static String rept(char ch, int t) {
        StringBuffer sb = new StringBuffer(t);
        for (int i = 0; i < t; ++i) {
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String rept(String string, int t) {
        StringBuffer sb = new StringBuffer(string.length() + t);
        for (int i = 0; i < t; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static String toString(double d) {
        StringBuffer sb = new StringBuffer(String.format("%.12f", d));
        while (sb.charAt(sb.length() - 1) == '0') {
            sb.setLength(sb.length() - 1);
        }
        if (sb.charAt(sb.length() - 1) == '.') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Integer parseInt10(String string) {
        try {
            return Integer.parseInt(string, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static char toUpperCase(char ch) {
        if ('a' <= ch && ch <= 'z') {
            ch = (char)(ch - 32);
        }
        return ch;
    }

    public static char toLowerCase(char ch) {
        if ('A' <= ch && ch <= 'Z') {
            ch = (char)(ch + 32);
        }
        return ch;
    }

    public static LineProvider getLineProvider(String text) {
        LineProvider lineProvider = new LineProvider();
        Matcher matcher = lineBreak.matcher(text);
        lineProvider.text = text;
        lineProvider.lines = 1;
        lineProvider.lineNumberToCharacterIndex.put(1, 0);
        lineProvider.entries.add(new int[]{1, 0});
        int indexPreviousStartIndex = 0;
        while (matcher.find()) {
            int indexStartMatch = matcher.start();
            int lengthLineBreak = matcher.group(0).length();
            lineProvider.lineNumberToCharacterIndex.put(lineProvider.lines + 1, indexStartMatch + lengthLineBreak);
            lineProvider.entries.add(new int[]{lineProvider.lines + 1, indexStartMatch + lengthLineBreak});
            lineProvider.contentLengthes.add(indexStartMatch - indexPreviousStartIndex);
            lineProvider.lineLengthes.add(indexStartMatch + lengthLineBreak - indexPreviousStartIndex);
            indexPreviousStartIndex = indexStartMatch + lengthLineBreak;
            ++lineProvider.lines;
        }
        lineProvider.contentLengthes.add(text.length() - indexPreviousStartIndex);
        lineProvider.lineLengthes.add(text.length() - indexPreviousStartIndex);
        return lineProvider;
    }

    public static String getEffectiveExpression(double value, int effectiveDigit) {
        if (effectiveDigit < 0) {
            return String.format("%.0f", value);
        }
        return String.format("%." + effectiveDigit + "f", value);
    }

    public static class LineProvider {
        protected String text;
        protected Hashtable<Integer, Integer> lineNumberToCharacterIndex = new Hashtable();
        protected ArrayList<int[]> entries = new ArrayList();
        protected ArrayList<Integer> contentLengthes = new ArrayList();
        protected ArrayList<Integer> lineLengthes = new ArrayList();
        protected int lines;

        public String getText() {
            return this.text;
        }

        public int getLineCount() {
            return this.lines;
        }

        public int getLineNumber(int characterIndex) {
            if (characterIndex < 0) {
                throw new IllegalArgumentException("characterIndex must be >= 0: " + characterIndex);
            }
            if (characterIndex >= this.text.length()) {
                return this.entries.get(this.entries.size() - 1)[0];
            }
            int now = 0;
            for (int[] entry : this.entries) {
                if (characterIndex >= entry[1]) {
                    now = entry[0];
                    continue;
                }
                return now;
            }
            return now;
        }

        public Set<Map.Entry<Integer, Integer>> entrySet() {
            return this.lineNumberToCharacterIndex.entrySet();
        }

        public int getStartIndex(int lineNumber) {
            return this.lineNumberToCharacterIndex.get(lineNumber);
        }

        public int getContentLength(int lineNumber) {
            return this.contentLengthes.get(lineNumber - 1);
        }

        public String getContent(int lineNumber) {
            return this.text.substring(this.getStartIndex(lineNumber), this.getStartIndex(lineNumber) + this.getContentLength(lineNumber));
        }

        public int getLineLength(int lineNumber) {
            return this.lineLengthes.get(lineNumber - 1);
        }

        public String getLine(int lineNumber) {
            return this.text.substring(this.getStartIndex(lineNumber), this.getStartIndex(lineNumber) + this.getLineLength(lineNumber));
        }
    }

    public static class SplitStringStream {
        private String string;
        private boolean inNumber;

        public SplitStringStream(String string) {
            this.string = string;
            this.inNumber = false;
        }

        public String getNext() {
            if (this.string.isEmpty()) {
                return null;
            }
            Pattern pattern = this.inNumber ? PATTERN_NUMBER : PATTERN_NOT_NUMBER;
            this.inNumber = !this.inNumber;
            Matcher m = pattern.matcher(this.string);
            if (!m.find()) {
                return "";
            }
            this.string = this.string.substring(m.end());
            return m.group();
        }

        public boolean isNextStringInNumber() {
            return this.inNumber;
        }
    }
}

