/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.ssdp.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class SearchResponse {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private InetAddress addr;
    private int status = 0;
    private Map<String, String> headers = new HashMap<String, String>();

    public SearchResponse(DatagramPacket packet) throws IOException {
        this(packet.getData(), packet.getOffset(), packet.getLength());
        this.addr = packet.getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResponse(byte[] buf, int offset, int length) throws IOException {
        try (BufferedReader r = null;){
            int i;
            char c;
            int j;
            r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buf, offset, length), UTF_8));
            String header = r.readLine();
            for (j = i = header.indexOf(32) + 1; j < header.length() && '0' <= (c = header.charAt(j)) && c <= '9'; ++j) {
            }
            if (j > i) {
                String line;
                this.status = Integer.parseInt(header.substring(i, j));
                while ((line = r.readLine()) != null) {
                    i = line.indexOf(58);
                    if (i <= 0) continue;
                    String key = line.substring(0, i);
                    String value = line.substring(i + 1).trim();
                    this.headers.put(key.toUpperCase(), value);
                }
            }
        }
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public int getStatus() {
        return this.status;
    }

    public String getHeader(String key) {
        if (key == null) {
            return null;
        }
        return this.headers.get(key.toUpperCase());
    }
}

