package net.osdn.util.ssdp.client;

import net.osdn.util.ssdp.Device;

/** ネットワーク上のデバイスを検索結果を受け取るためのコールバック・インターフェースです。

 * {@link SsdpClient#discover(DiscoveryCallback)}
 * {@link SsdpClient#discover(int, DiscoveryCallback)}
 */
public interface DiscoveryCallback {
	
	/** ネットワーク上のデバイスから応答がありデバイス情報が取得できたときに呼び出されます。
	 * 
	 * @param device デバイス情報を格納しているオブジェクト
	 */
	void discovered(Device device);
	
	/** 指定時間が経過してデバイス検索が終了したときに呼び出されます。
	 * 
	 */
	void done();
}
