/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey.log;

import java.io.IOException;
import java.io.OutputStream;

public class LoggingOutputStream
extends OutputStream {
    private OutputStream out;
    private OutputStream log;
    private Runnable callback;

    public LoggingOutputStream(OutputStream out, OutputStream log, Runnable callback) {
        this.out = out;
        this.log = log;
        this.callback = callback;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        try {
            this.log.write(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        try {
            this.log.write(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        try {
            this.log.write(b, off, len);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        try {
            this.log.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        try {
            this.log.close();
            if (this.callback != null) {
                this.callback.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

