/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey.log;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import net.osdn.util.jersey.log.FileManager;
import net.osdn.util.jersey.log.ProcessIdentifier;
import net.osdn.util.jersey.log.UniqueDatetime;

public class InvocationLogger
implements InvocationHandler {
    private static final Pattern SIMPLE_NAME = Pattern.compile("[^.<@]+\\.");
    private static final NullObject NULL = new NullObject();

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        try {
            this.log(obj, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Object result = method.invoke(obj, args);
            if (result == null) {
                try {
                    if (InvocationLogger.isProduceMediaTypeJson(method)) {
                        result = NULL;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (Throwable t) {
            try {
                this.logThrowable(obj, method, t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw t;
        }
    }

    private static boolean isProduceMediaTypeJson(Method method) {
        Annotation[] annotations = method.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                Annotation annotation = annotations[i];
                if (!(annotation instanceof Produces)) continue;
                Produces produces = (Produces)annotation;
                for (String s : produces.value()) {
                    if (!"application/json".equals(s)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(Object obj, Object[] args) throws IOException {
        ContainerRequestContext requestContext = InvocationLogger.getRequestContext(obj);
        if (requestContext == null) {
            return;
        }
        ResourceInfo resourceInfo = InvocationLogger.getResourceInfo(obj);
        if (resourceInfo == null) {
            return;
        }
        String base = UniqueDatetime.get() + "-" + ProcessIdentifier.getId() + String.format("-%08x", requestContext.hashCode());
        File rsc0 = new File(FileManager.TMP_DIR, base + "-req.rsc.tmp");
        File rsc1 = new File(FileManager.TMP_DIR, base + "-req.rsc");
        Class cls = resourceInfo.getResourceClass();
        Method method = resourceInfo.getResourceMethod();
        try (BufferedWriter w = null;){
            int i;
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rsc0), StandardCharsets.UTF_8));
            Annotation[] clsAnnotations = cls.getAnnotations();
            if (clsAnnotations != null) {
                w.write("Class-Annotations: ");
                for (int i2 = 0; i2 < clsAnnotations.length; ++i2) {
                    w.write(InvocationLogger.getSimpleName(clsAnnotations[i2]));
                    if (i2 + 1 >= clsAnnotations.length) continue;
                    w.write(44);
                    w.write(32);
                }
                w.write(13);
                w.write(10);
            }
            w.write("Class: ");
            w.write(cls.getName());
            w.write(13);
            w.write(10);
            Annotation[] methodAnnotations = method.getAnnotations();
            if (methodAnnotations != null) {
                w.write("Method-Annotations: ");
                for (i = 0; i < methodAnnotations.length; ++i) {
                    w.write(InvocationLogger.getSimpleName(methodAnnotations[i]));
                    if (i + 1 >= methodAnnotations.length) continue;
                    w.write(44);
                    w.write(32);
                }
                w.write(13);
                w.write(10);
            }
            w.write("Method: ");
            w.write(InvocationLogger.getSimpleName(method.getGenericReturnType()));
            w.write(32);
            w.write(method.getName());
            w.write(13);
            w.write(10);
            if (method.getParameterCount() > 0) {
                for (i = 0; i < method.getParameterCount(); ++i) {
                    w.write("Parameter: ");
                    Annotation[] annotations = method.getParameterAnnotations()[i];
                    for (int j = 0; j < annotations.length; ++j) {
                        w.write(InvocationLogger.getSimpleName(annotations[j]));
                        w.write(32);
                    }
                    w.write(InvocationLogger.getSimpleName(method.getGenericParameterTypes()[i]));
                    if (method.getParameters()[i].isNamePresent()) {
                        w.write(32);
                        w.write(method.getParameters()[i].getName());
                    }
                    try {
                        w.write(" = " + args[i]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    w.write(13);
                    w.write(10);
                }
            }
            w.close();
            w = null;
            rsc0.renameTo(rsc1);
            FileManager.append(rsc1);
        }
    }

    private void logThrowable(Object obj, Method method, Throwable t) {
        PrintWriter logWriter = InvocationLogger.getLogWriter(obj);
        if (logWriter == null) {
            return;
        }
        if (t instanceof InvocationTargetException) {
            t = t.getCause();
        }
        Class<?> cls = obj.getClass();
        StringBuilder sb = new StringBuilder();
        sb.append("---- EXCEPTION START ----\r\n");
        while (t != null) {
            int i;
            sb.append(t + "\r\n");
            StackTraceElement[] stes = t.getStackTrace();
            int count = stes.length;
            for (i = 0; i < stes.length - 1; ++i) {
                if (!stes[i].getClassName().equals(cls.getName()) || !stes[i].getMethodName().equals(method.getName())) continue;
                count = i + 1;
                break;
            }
            for (i = 0; i < count; ++i) {
                StackTraceElement ste = stes[i];
                sb.append("\tat " + ste + "\r\n");
            }
            if ((t = t.getCause()) == null) continue;
            sb.append("Caused by: ");
        }
        sb.append("---- EXCEPTION END   ----");
        logWriter.print(sb.toString());
    }

    private static ContainerRequestContext getRequestContext(Object obj) {
        Method getRequestContext = null;
        try {
            getRequestContext = obj.getClass().getMethod("getRequestContext", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        if (getRequestContext == null) {
            return null;
        }
        ContainerRequestContext requestContext = null;
        try {
            requestContext = (ContainerRequestContext)getRequestContext.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return requestContext;
    }

    private static ResourceInfo getResourceInfo(Object obj) {
        Method getResourceInfo = null;
        try {
            getResourceInfo = obj.getClass().getMethod("getResourceInfo", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        if (getResourceInfo == null) {
            return null;
        }
        ResourceInfo resourceInfo = null;
        try {
            resourceInfo = (ResourceInfo)getResourceInfo.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return resourceInfo;
    }

    private static PrintWriter getLogWriter(Object obj) {
        Method getLogWriter = null;
        try {
            getLogWriter = obj.getClass().getMethod("getLogWriter", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        if (getLogWriter == null) {
            return null;
        }
        PrintWriter logWriter = null;
        try {
            logWriter = (PrintWriter)getLogWriter.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return logWriter;
    }

    private static String getSimpleName(Type genericType) {
        return InvocationLogger.getSimpleName(genericType.getTypeName());
    }

    private static String getSimpleName(Annotation annotation) {
        return InvocationLogger.getSimpleName(annotation.toString());
    }

    private static String getSimpleName(String genericTypeName) {
        StringBuffer sb = new StringBuffer();
        Matcher m = SIMPLE_NAME.matcher(genericTypeName);
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static class NullObjectSerializer
    extends JsonSerializer<NullObject> {
        public void serialize(NullObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeNull();
        }
    }

    @JsonSerialize(using=NullObjectSerializer.class)
    public static class NullObject {
    }
}

