/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import net.osdn.util.jersey.log.FileManager;
import net.osdn.util.jersey.log.LoggingInputStream;
import net.osdn.util.jersey.log.ProcessIdentifier;
import net.osdn.util.jersey.log.UniqueDatetime;

@Provider
@PreMatching
@Priority(value=4999)
public class RequestLogger
implements ContainerRequestFilter {
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private HttpServletRequest httpServletRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String base = UniqueDatetime.get() + "-" + ProcessIdentifier.getId() + String.format("-%08x", requestContext.hashCode());
        File hdr0 = new File(FileManager.TMP_DIR, base + "-req.hdr.tmp");
        File hdr1 = new File(FileManager.TMP_DIR, base + "-req.hdr");
        final File bdy0 = new File(FileManager.TMP_DIR, base + "-req.bdy.tmp");
        final File bdy1 = new File(FileManager.TMP_DIR, base + "-req.bdy");
        try (BufferedWriter w = null;){
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(hdr0), StandardCharsets.UTF_8));
            String ipAddress = this.httpServletRequest.getHeader("X-FORWARDED-FOR");
            if (ipAddress == null) {
                ipAddress = this.httpServletRequest.getRemoteAddr();
            }
            w.write(ipAddress);
            w.write(13);
            w.write(10);
            w.write(this.httpServletRequest.getMethod());
            w.write(32);
            w.write(this.httpServletRequest.getRequestURI());
            if (this.httpServletRequest.getQueryString() != null) {
                w.write(63);
                w.write(this.httpServletRequest.getQueryString());
            }
            w.write(32);
            w.write(this.httpServletRequest.getProtocol());
            w.write(13);
            w.write(10);
            for (String headerName : requestContext.getHeaders().keySet()) {
                String headerValue = requestContext.getHeaderString(headerName);
                w.write(headerName);
                w.write(58);
                w.write(32);
                w.write(headerValue);
                w.write(13);
                w.write(10);
            }
            w.write(13);
            w.write(10);
            w.close();
            w = null;
            hdr0.renameTo(hdr1);
            FileManager.append(hdr1);
        }
        if (requestContext.hasEntity()) {
            FileOutputStream log = new FileOutputStream(bdy0);
            LoggingInputStream input = new LoggingInputStream(requestContext.getEntityStream(), log, new Runnable(){

                @Override
                public void run() {
                    bdy0.renameTo(bdy1);
                    FileManager.append(bdy1);
                }
            });
            requestContext.setEntityStream((InputStream)input);
        }
    }
}

