/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey.log;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class UniqueDatetime {
    private static ZoneOffset defaultZoneOffset = OffsetDateTime.now().getOffset();
    private static long startTimeMillis = System.currentTimeMillis();
    private static long startNanoTime = System.nanoTime();
    private static long lastTime;

    public static synchronized long get() {
        long value;
        while (true) {
            long t;
            if (Math.abs((t = startTimeMillis * 1000000L + (System.nanoTime() - startNanoTime)) / 1000000L - System.currentTimeMillis()) >= 50L) {
                startTimeMillis = System.currentTimeMillis();
                startNanoTime = System.nanoTime();
                continue;
            }
            long nanoOfSecond = t % 1000000000L;
            long epochSecond = (t - nanoOfSecond) / 1000000000L;
            LocalDateTime ldt = LocalDateTime.ofEpochSecond(epochSecond, (int)nanoOfSecond, defaultZoneOffset);
            value = ldt.getYear();
            value *= 100L;
            value += (long)ldt.getMonthValue();
            value *= 100L;
            value += (long)ldt.getDayOfMonth();
            value *= 100L;
            value += (long)ldt.getHour();
            value *= 100L;
            value += (long)ldt.getMinute();
            value *= 100L;
            value += (long)ldt.getSecond();
            value *= 100000L;
            if ((value += (long)(ldt.getNano() / 10000)) != lastTime) break;
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {}
        }
        lastTime = value;
        return value;
    }
}

