package net.osdn.util.sql;

import java.util.Iterator;

/** ResultSetの各行をオブジェクトに変換していく拡張for文で使用可能な反復可能オブジェクトです。
 * 
 * @param <E> イテレーターから返される要素の型
 */
public class ObjectIterable<E> implements Iterable<E> {

	private ObjectIterator<E> iterator;
	
	/** 指定した{@link ObjectIterator}で反復可能オブジェクトを作成します。
	 * 
	 * @param iterator イテレーター
	 */
	public ObjectIterable(ObjectIterator<E> iterator) {
		this.iterator = iterator;
	}
	
	/** 型Eの要素のイテレーターを返します。
	 * 
	 * @return イテレーター
	 */
	@Override
	public Iterator<E> iterator() {
		return iterator;
	}
}
