package net.osdn.util.jersey;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

public abstract class AbstractParam<T> {
	
	private final T value;
	private final String original;
	
	public AbstractParam(String param) throws WebApplicationException {
		this.original = param;
		try {
			this.value = parse(param);
		} catch(Throwable e) {
			Response response = Response
				.status(Status.BAD_REQUEST)
				.entity("Invalid parameter: " + param + " (" + e.getMessage() + ")")
				.build();
			throw new WebApplicationException(response);
		}
	}
	
	public T getValue() {
		return value;
	}
	
	public String getOriginalParam() {
		return this.original;
	}
	
	@Override
	public String toString() {
		if(value == null) {
			return null;
		}
		return value.toString();
	}
	
	protected abstract T parse(String param) throws Throwable;
}
