package net.osdn.util.jersey;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.YearMonth;
import java.util.Date;

import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;

import com.fasterxml.jackson.databind.ObjectMapper;

@Provider
public class JacksonParamConverterProvider implements ParamConverterProvider {

	private ObjectMapper mapper = new JacksonConfig().getContext(null);
	
	@Override
	public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
		//System.out.println("# JacksonParamConverterProvider.getConverter: rawType=" + rawType + ", genericType=" + genericType + ", annotations=" + annotations);
		
		Class<?> jsonBaseType = null;
		if(rawType == String.class
				|| rawType == LocalDateTime.class
				|| rawType == LocalDate.class
				|| rawType == LocalTime.class
				|| rawType == OffsetDateTime.class
				|| rawType == OffsetTime.class
				|| rawType == YearMonth.class
				|| rawType == java.sql.Timestamp.class
				|| rawType == java.sql.Date.class
				|| rawType == java.sql.Time.class
				|| rawType == Date.class) {
			jsonBaseType = String.class;
		}
		
		return new JacksonParamConverter<>(mapper, rawType, genericType, jsonBaseType);
	}
}
