package net.osdn.util.jersey.aspect;

import java.lang.reflect.Method;

/** JAX-RSリソース・メソッド呼び出しの各局面で呼び出されるハンドラー。
 * 
 */
public interface AspectHandler {

	/** リソース・メソッドの実行前に呼び出されます。
	 * 
	 * @param obj メソッドが呼び出されるリソースクラスのインスタンス。
	 * @param method 呼び出されるインターフェースメソッドに対応するインスタンス。
	 * @param args メソッド呼び出し時に渡される引数値を格納するオブジェクト配列。インタフェースメソッドが引数をとらない場合、null となる。プリミティブ型引数は java.lang.Integer または java.lang.Boolean のような適切なプリミティブ型ラッパークラスのインスタンスにラップされる。
	 */
	void onBeforeExecution(Object obj, Method method, Object[] args);
	
	/** リソースメソッドの実行後に呼び出されます。
	 * メソッドが例外がスローされた場合も、この onAfterExecution は呼び出されます。
	 * 
	 * @param obj メソッドが呼び出されるリソースクラスのインスタンス。
	 * @param method 呼び出されるインターフェースメソッドに対応するインスタンス。
	 * @param args メソッド呼び出し時に渡される引数値を格納するオブジェクト配列。インタフェースメソッドが引数をとらない場合、null となる。プリミティブ型引数は java.lang.Integer または java.lang.Boolean のような適切なプリミティブ型ラッパークラスのインスタンスにラップされる。
	 */
	void onAfterExecution(Object obj, Method method, Object[] args);
	
	/** リソースメソッドの実行から復帰した後に呼び出されます。
	 * リソースメソッドが例外をスローした場合、この onAfterReturning は呼び出されません。
	 * 
	 * @param obj メソッドが呼び出されるリソースクラスのインスタンス。
	 * @param method 呼び出されるインターフェースメソッドに対応するインスタンス。
	 * @param args メソッド呼び出し時に渡される引数値を格納するオブジェクト配列。インタフェースメソッドが引数をとらない場合、null となる。プリミティブ型引数は java.lang.Integer または java.lang.Boolean のような適切なプリミティブ型ラッパークラスのインスタンスにラップされる。
	 * @param value リソースメソッドがの戻り値。
	 */
	void onAfterReturning(Object obj, Method method, Object[] args, Object value);
	
	/** リソースメソッドの実行で例外がスローされた後に呼び出されます。
	 * 
	 * @param obj メソッドが呼び出されるリソースクラスのインスタンス。
	 * @param method 呼び出されるインターフェースメソッドに対応するインスタンス。
	 * @param args メソッド呼び出し時に渡される引数値を格納するオブジェクト配列。インタフェースメソッドが引数をとらない場合、null となる。プリミティブ型引数は java.lang.Integer または java.lang.Boolean のような適切なプリミティブ型ラッパークラスのインスタンスにラップされる。
	 * @param e リソースメソッドがスローした例外のインスタンス。
	 */
	void onAfterThrowing(Object obj, Method method, Object[] args, Throwable e);

	
	/** AspectHandler.onAfterThrowingを呼び出すべきではない例外クラスに付与するマーカーインターフェースです。
	 * 
	 */
	public static interface Ignore {
	}
}
