/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import net.osdn.util.jersey.aspect.AspectHandler;

public class InvocationHandler
implements java.lang.reflect.InvocationHandler {
    private static final NullObject NULL = new NullObject();
    private AspectHandler aspectHandler;

    public InvocationHandler(AspectHandler aspectHandler) {
        this.aspectHandler = aspectHandler;
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        try {
            if (this.aspectHandler != null) {
                try {
                    this.aspectHandler.onBeforeExecution(obj, method, args);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Object result = method.invoke(obj, args);
            if (this.aspectHandler != null) {
                try {
                    this.aspectHandler.onAfterReturning(obj, method, args, result);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.aspectHandler.onAfterExecution(obj, method, args);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (result == null) {
                try {
                    if (InvocationHandler.isProduceMediaTypeJson(method)) {
                        result = NULL;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (InvocationTargetException t) {
            Throwable e;
            if (this.aspectHandler != null && (e = t.getTargetException()) != null && !(e instanceof WebApplicationException) && !(e instanceof AspectHandler.Ignore)) {
                try {
                    this.aspectHandler.onAfterThrowing(obj, method, args, e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.aspectHandler.onAfterExecution(obj, method, args);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw t;
        }
    }

    private static boolean isProduceMediaTypeJson(Method method) {
        Annotation[] annotations = method.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                Annotation annotation = annotations[i];
                if (!(annotation instanceof Produces)) continue;
                Produces produces = (Produces)annotation;
                for (String s : produces.value()) {
                    if (!"application/json".equals(s)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class NullObjectSerializer
    extends JsonSerializer<NullObject> {
        public void serialize(NullObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeNull();
        }
    }

    @JsonSerialize(using=NullObjectSerializer.class)
    public static class NullObject {
    }
}

