/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ParamConverter;

public class JacksonParamConverter<T>
implements ParamConverter<T> {
    private ObjectMapper mapper;
    private Class<T> rawType;
    private Type genericType;
    private Class<?> jsonBaseType;

    public JacksonParamConverter(ObjectMapper mapper, Class<T> rawType, Type genericType, Class<?> jsonBaseType) {
        this.mapper = mapper;
        this.rawType = rawType;
        this.genericType = genericType;
        this.jsonBaseType = jsonBaseType;
    }

    public T fromString(String json) {
        if (json == null || json.equals("null")) {
            return null;
        }
        try {
            if (this.jsonBaseType == String.class) {
                json = this.normalize(json);
            }
            if (this.genericType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)this.genericType;
                Class<T> collectionClass = this.rawType;
                Class elementClass = (Class)pType.getActualTypeArguments()[0];
                CollectionType collectionType = TypeFactory.defaultInstance().constructCollectionType(collectionClass, elementClass);
                return (T)this.mapper.readValue(json, (JavaType)collectionType);
            }
            return (T)this.mapper.readValue(json, this.rawType);
        }
        catch (Exception e) {
            String message = "Invalid parameter as a " + this.rawType.getSimpleName() + ": " + json;
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)("400 Bad Request\r\n\r\n" + message)).build();
            throw new WebApplicationException((Throwable)e, response);
        }
    }

    public String toString(T object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"500 Internal Server Error").build();
            throw new WebApplicationException((Throwable)e, response);
        }
    }

    private String normalize(String string) throws JsonProcessingException {
        boolean isValid = false;
        try {
            JsonToken secondToken;
            JsonParser parser = this.mapper.getFactory().createParser(string);
            JsonToken firstToken = parser.nextToken();
            if (firstToken == JsonToken.VALUE_STRING && (secondToken = parser.nextToken()) == null) {
                isValid = true;
            }
        }
        catch (JsonParseException jsonParseException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!isValid) {
            string = this.mapper.writeValueAsString((Object)string);
        }
        return string;
    }
}

