package net.osdn.util.sql;

import java.sql.DatabaseMetaData;

/** 既定のSQL文構築ビルダーです。
 * 
 * <p>このクラスの{@link #isAcceptable(DatabaseMetaData)}メソッドは常にtrueを返します。
 * この既定の構文ビルダーはデータベース固有の構文ビルダーが見つからない場合に
 * 自動的に使われるように構成されているため、{@link StatementBuilder#add(StatementBuilder)}で
 * 追加する必要はありません。</p>
 * 
 */
public class DefaultStatementBuilder extends StatementBuilder {
	
	/** 指定されたデータベース・メタデータが、この構文ビルダーに適合するかどうかチェックします。
	 * 
	 * このメソッドは常に true を返します。
	 * 
	 * @param md データベース・メタデータ
	 * @return 常に true を返します。
	 */
	@Override
	public boolean isAcceptable(DatabaseMetaData md) {
		return true;
	}

}
