package net.osdn.util.sql;

/** {@link ORMapper}や{@link DataSource}でPOJOの代わり渡すことができるクラスです。
 * 
 * <p>{@link ORMapper}や{@link DataSource}でPOJOを使用すると、
 * POJOのクラス名が暗黙的にテーブル名として扱われます。
 * POJOのクラス名とテーブル名を一致させるのが難しい場合、代わりにTableを使用することができます。
 * Tableのコンストラクタではテーブル名を指定することができます。
 * POJOの代わりにTableを使用するとクラス名ではなくコンストラクタで明示的に指定した値がテーブル名として使用されます。</p>
 *
 * <p>通常、このクラスを直接使うことはありません。 
 * このクラスを継承したサブクラスを作成し、そのサブクラスにテーブルの列と対応するフィールドを定義して使用します。</p>
 * 
 */
public abstract class Table {

	private String tableName;
	
	/** 指定したテーブル名でインスタンスを作成します。
	 * 
	 * @param tableName テーブル名
	 */
	public Table(String tableName) {
		this.tableName = tableName;
	}
	
	/** テーブル名を取得します。
	 * 
	 * @return テーブル名
	 */
	public String getTableName() {
		return tableName;
	}
}
