/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import net.osdn.util.jersey.RawString;

@Provider
@Produces(value={"application/json"})
public class RawStringMessageBodyWriter
implements MessageBodyWriter<RawString> {
    private static final byte[] NULL = "null".getBytes();

    public long getSize(RawString s, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == RawString.class && mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public void writeTo(RawString s, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (s == null) {
            entityStream.write(NULL);
        } else {
            byte[] buf = s.toString().getBytes(StandardCharsets.UTF_8);
            entityStream.write(buf);
        }
    }
}

