/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import net.osdn.util.jersey.fastpack.BytePacker;

@Provider
@Produces(value={"application/json"})
public class ResultSetMessageBodyWriter
implements MessageBodyWriter<Object> {
    @Context
    private HttpHeaders requestHeaders;

    public long getSize(Object rs, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ResultSet.class.isAssignableFrom(type);
    }

    public void writeTo(Object obj, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ResultSet rs = (ResultSet)obj;
        boolean isDirectSQLite = this.requestHeaders != null && this.requestHeaders.getHeaderString("X-DirectSQLite") != null;
        int rowCount = ResultSetMessageBodyWriter.getRowCount(rs);
        if (rowCount >= 0) {
            httpHeaders.add((Object)"X-RowCount", (Object)rowCount);
        }
        try {
            int columnCount = rs.getMetaData().getColumnCount();
            httpHeaders.add((Object)"X-ColumnCount", (Object)columnCount);
            if (isDirectSQLite) {
                httpHeaders.add((Object)"Content-Type", (Object)"application/octet-stream");
                this.writeFastPack(entityStream, rs);
            } else {
                this.writeJson(entityStream, rs);
            }
            Statement st = rs.getStatement();
            Connection cn = null;
            if (st != null) {
                cn = st.getConnection();
            }
            rs.close();
            if (st != null) {
                st.close();
            }
            if (cn != null) {
                cn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void writeJson(OutputStream entityStream, ResultSet rs) throws IOException, SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        String[] columnNames = new String[columnCount + 1];
        int[] columnTypes = new int[columnCount + 1];
        for (int i = 1; i <= columnCount; ++i) {
            columnNames[i] = meta.getColumnLabel(i);
            columnTypes[i] = meta.getColumnType(i);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(entityStream, "UTF-8"));
        writer.write("[\n");
        boolean isNotFirst = false;
        while (rs.next()) {
            if (isNotFirst) {
                writer.write(",\n");
            } else {
                isNotFirst = true;
            }
            writer.write("{ ");
            for (int i = 1; i <= columnCount; ++i) {
                writer.write(34);
                writer.write(columnNames[i]);
                writer.write("\":\"");
                switch (columnTypes[i]) {
                    case 91: 
                    case 92: 
                    case 93: {
                        Timestamp date = rs.getTimestamp(i);
                        String s = ISO8601Utils.format((Date)date, (boolean)true, (TimeZone)TimeZone.getDefault());
                        writer.write(s);
                        break;
                    }
                    case -7: 
                    case 16: {
                        writer.write(rs.getBoolean(i) ? "true" : "false");
                        break;
                    }
                    default: {
                        writer.write(rs.getString(i));
                    }
                }
                writer.write("\"");
                if (i + 1 > columnCount) continue;
                writer.write(", ");
            }
            writer.write(" }");
        }
        writer.write("\n]");
        writer.close();
    }

    private void writeFastPack(OutputStream entityStream, ResultSet rs) throws IOException, SQLException {
        int i;
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        String[] columnNames = new String[columnCount + 1];
        int[] columnTypes = new int[columnCount + 1];
        block17: for (int i2 = 1; i2 <= columnCount; ++i2) {
            columnNames[i2] = meta.getColumnLabel(i2);
            int columnType = meta.getColumnType(i2);
            switch (columnType) {
                case -7: 
                case 16: {
                    columnTypes[i2] = 16;
                    continue block17;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    columnTypes[i2] = -5;
                    continue block17;
                }
                case 6: 
                case 7: 
                case 8: {
                    columnTypes[i2] = 8;
                    continue block17;
                }
                case 2: 
                case 3: {
                    if (meta.getScale(i2) == 0) {
                        if (meta.getPrecision(i2) <= 18) {
                            columnTypes[i2] = -5;
                            continue block17;
                        }
                        columnTypes[i2] = 8;
                        continue block17;
                    }
                    columnTypes[i2] = 8;
                    continue block17;
                }
                case 91: 
                case 92: 
                case 93: {
                    columnTypes[i2] = 93;
                    continue block17;
                }
                default: {
                    columnTypes[i2] = columnType;
                }
            }
        }
        BytePacker packer = new BytePacker(entityStream);
        packer.writeLong(columnCount);
        block18: for (i = 1; i <= columnCount; ++i) {
            packer.writeString(columnNames[i]);
            switch (columnTypes[i]) {
                case -5: 
                case 16: 
                case 93: {
                    packer.writeLong(76L);
                    continue block18;
                }
                case 8: {
                    packer.writeLong(68L);
                    continue block18;
                }
                default: {
                    packer.writeLong(83L);
                }
            }
        }
        while (rs.next()) {
            block20: for (i = 1; i <= columnCount; ++i) {
                switch (columnTypes[i]) {
                    case 93: {
                        Timestamp dt = rs.getTimestamp(i);
                        if (rs.wasNull()) {
                            packer.writeNull();
                            continue block20;
                        }
                        long l = ((Date)dt).getTime();
                        packer.writeLong(l);
                        continue block20;
                    }
                    case 16: {
                        boolean b = rs.getBoolean(i);
                        if (rs.wasNull()) {
                            packer.writeNull();
                            continue block20;
                        }
                        long l = b ? 1L : 0L;
                        packer.writeLong(l);
                        continue block20;
                    }
                    case -5: {
                        long l = rs.getLong(i);
                        if (rs.wasNull()) {
                            packer.writeNull();
                            continue block20;
                        }
                        packer.writeLong(l);
                        continue block20;
                    }
                    case 8: {
                        double d = rs.getDouble(i);
                        if (rs.wasNull()) {
                            packer.writeNull();
                            continue block20;
                        }
                        packer.writeDouble(d);
                        continue block20;
                    }
                    default: {
                        String s = rs.getString(i);
                        if (rs.wasNull()) {
                            packer.writeNull();
                            continue block20;
                        }
                        packer.writeString(s);
                    }
                }
            }
        }
        entityStream.close();
    }

    private static int getRowCount(ResultSet rs) {
        int rowCount = -1;
        try {
            rs.last();
            rowCount = rs.getRow();
            rs.beforeFirst();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return rowCount;
    }
}

