package net.osdn.util.rest.client;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonObjectIterator<E> implements Iterator<E> {

	private Class<E> type;
	private ObjectMapper mapper;
	private JsonParser parser;
	private JsonToken token = JsonToken.NOT_AVAILABLE;
	private int size = -1;

	public JsonObjectIterator(Class<E> type, ObjectMapper mapper, JsonParser parser) {
		this(type, mapper, parser, -1);
	}

	public JsonObjectIterator(Class<E> type, ObjectMapper mapper, JsonParser parser, int size) {
		this.type = type;
		this.mapper = mapper;
		this.parser = parser;
		this.size = size;
	}
	
	public int size() {
		return this.size;
	}
	
	@Override
	public boolean hasNext() {
		if(token == null) {
			return false;
		}
		try {
			return seek();
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public E next() {
		try {
			if(seek()) {
				token = JsonToken.NOT_AVAILABLE;
				E obj = mapper.readValue(parser, type);
				return obj;
			} else {
				throw new NoSuchElementException();
			}
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	private boolean seek() throws JsonParseException, IOException {
		do {
			if(token == JsonToken.VALUE_NULL
					|| token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE
					|| token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT
					|| token == JsonToken.VALUE_STRING
					|| token == JsonToken.START_OBJECT) {
				return true;
			}
		} while((token = parser.nextToken()) != null);

		return false;
	}

	@Override
	public void remove() {
	}
}
