/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.rest.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class JsonObjectIterator<E>
implements Iterator<E> {
    private Class<E> type;
    private ObjectMapper mapper;
    private JsonParser parser;
    private JsonToken token = JsonToken.NOT_AVAILABLE;
    private int size = -1;

    public JsonObjectIterator(Class<E> type, ObjectMapper mapper, JsonParser parser) {
        this(type, mapper, parser, -1);
    }

    public JsonObjectIterator(Class<E> type, ObjectMapper mapper, JsonParser parser, int size) {
        this.type = type;
        this.mapper = mapper;
        this.parser = parser;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    @Override
    public boolean hasNext() {
        if (this.token == null) {
            return false;
        }
        try {
            return this.seek();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public E next() {
        try {
            if (this.seek()) {
                this.token = JsonToken.NOT_AVAILABLE;
                Object obj = this.mapper.readValue(this.parser, this.type);
                return (E)obj;
            }
            throw new NoSuchElementException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean seek() throws JsonParseException, IOException {
        do {
            if (this.token != JsonToken.VALUE_NULL && this.token != JsonToken.VALUE_FALSE && this.token != JsonToken.VALUE_TRUE && this.token != JsonToken.VALUE_NUMBER_INT && this.token != JsonToken.VALUE_NUMBER_FLOAT && this.token != JsonToken.VALUE_STRING && this.token != JsonToken.START_OBJECT) continue;
            return true;
        } while ((this.token = this.parser.nextToken()) != null);
        return false;
    }

    @Override
    public void remove() {
    }
}

