# Generated by Django 2.2.14 on 2020-08-28 11:24

import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='AdType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('unit', models.CharField(blank=True, db_column='unit', max_length=50, null=True, verbose_name='unit')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'ad_type',
                'verbose_name_plural': 'ad_types',
                'db_table': 'ad_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='AllowType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'allow_type',
                'verbose_name_plural': 'allow_types',
                'db_table': 'allow_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Area',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('kana', models.CharField(blank=True, db_column='kana', db_index=True, max_length=100, null=True, verbose_name='kana')),
                ('pref_id', models.IntegerField(db_column='pref_id', db_index=True, default=0, verbose_name='pref_id')),
                ('lat', models.FloatField(db_column='lat', db_index=True, default=0, verbose_name='lat')),
                ('lng', models.FloatField(db_column='lng', db_index=True, default=0, verbose_name='lng')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'area',
                'verbose_name_plural': 'areas',
                'db_table': 'area',
                'ordering': ['pref_id', 'kana', 'id'],
            },
        ),
        migrations.CreateModel(
            name='ArrivalType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'arrival_type',
                'verbose_name_plural': 'arrival_types',
                'db_table': 'arrival_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='BalconyType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'balcony_type',
                'verbose_name_plural': 'balcony_types',
                'db_table': 'balcony_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='BathType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'bath_type',
                'verbose_name_plural': 'bath_types',
                'db_table': 'bath_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='BikeParkingType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_exist', models.BooleanField(db_column='is_exist', default=False, verbose_name='is_exist')),
                ('is_paid', models.BooleanField(db_column='is_paid', default=False, verbose_name='is_paid')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'bike_parking_type',
                'verbose_name_plural': 'bike_parking_types',
                'db_table': 'bike_parking_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Building',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('oid', models.CharField(db_column='oid', db_index=True, max_length=50, unique=True, verbose_name='oid')),
                ('file_oid', models.CharField(db_column='file_oid', db_index=True, max_length=50, unique=True, verbose_name='file_oid')),
                ('building_code', models.CharField(blank=True, db_column='building_code', db_index=True, max_length=20, null=True, verbose_name='building_code')),
                ('building_name', models.CharField(blank=True, db_column='building_name', db_index=True, max_length=100, null=True, verbose_name='building_name')),
                ('building_kana', models.CharField(blank=True, db_column='building_kana', db_index=True, max_length=100, null=True, verbose_name='building_kana')),
                ('building_old_name', models.CharField(blank=True, db_column='building_old_name', max_length=100, null=True, verbose_name='building_old_name')),
                ('postal_code', models.CharField(blank=True, db_column='postal_code', max_length=10, null=True, verbose_name='postal_code')),
                ('pref_id', models.IntegerField(db_column='pref_id', db_index=True, default=0, verbose_name='pref_id')),
                ('city_id', models.IntegerField(db_column='city_id', db_index=True, default=0, verbose_name='city_id')),
                ('town_address', models.CharField(blank=True, db_column='town_address', max_length=255, null=True, verbose_name='town_address')),
                ('town_name', models.CharField(blank=True, db_column='town_name', max_length=100, null=True, verbose_name='town_name')),
                ('house_no', models.CharField(blank=True, db_column='house_no', max_length=100, null=True, verbose_name='house_no')),
                ('building_no', models.CharField(blank=True, db_column='building_no', max_length=100, null=True, verbose_name='building_no')),
                ('lat', models.FloatField(db_column='lat', db_index=True, default=0, verbose_name='lat')),
                ('lng', models.FloatField(db_column='lng', db_index=True, default=0, verbose_name='lng')),
                ('area_id', models.IntegerField(db_column='area_id', db_index=True, default=0, verbose_name='area_id')),
                ('elementary_school_id', models.IntegerField(db_column='elementary_school_id', db_index=True, default=0, verbose_name='elementary_school_id')),
                ('elementary_school_distance', models.IntegerField(db_column='elementary_school_distance', default=0, verbose_name='elementary_school_distance')),
                ('junior_high_school_id', models.IntegerField(db_column='junior_high_school_id', db_index=True, default=0, verbose_name='junior_high_school_id')),
                ('junior_high_school_distance', models.IntegerField(db_column='junior_high_school_distance', default=0, verbose_name='junior_high_school_distance')),
                ('around_note', models.CharField(blank=True, db_column='around_note', max_length=255, null=True, verbose_name='around_note')),
                ('management_type_id', models.IntegerField(db_column='management_type_id', db_index=True, default=0, verbose_name='management_type_id')),
                ('department_id', models.IntegerField(db_column='department_id', db_index=True, default=0, verbose_name='department_id')),
                ('staff_id1', models.IntegerField(db_column='staff_id1', db_index=True, default=0, verbose_name='staff_id1')),
                ('staff_id2', models.IntegerField(db_column='staff_id2', db_index=True, default=0, verbose_name='staff_id2')),
                ('priority_level', models.IntegerField(db_column='priority_level', db_index=True, default=50, verbose_name='priority_level')),
                ('agency_department_id', models.IntegerField(db_column='agency_department_id', default=0, verbose_name='agency_department_id')),
                ('owner_id', models.IntegerField(db_column='owner_id', db_index=True, default=0, verbose_name='owner_id')),
                ('owner_note', models.CharField(blank=True, db_column='owner_note', max_length=255, null=True, verbose_name='owner_note')),
                ('trader_id', models.IntegerField(db_column='trader_id', db_index=True, default=0, verbose_name='trader_id')),
                ('register_address', models.CharField(blank=True, db_column='register_address', max_length=255, null=True, verbose_name='register_address')),
                ('register_name', models.CharField(blank=True, db_column='register_name', max_length=255, null=True, verbose_name='register_name')),
                ('register_building_no', models.CharField(blank=True, db_column='register_building_no', max_length=255, null=True, verbose_name='register_building_no')),
                ('register_no', models.CharField(blank=True, db_column='register_no', max_length=50, null=True, verbose_name='register_no')),
                ('arrival_type_id1', models.IntegerField(db_column='arrival_type_id1', default=0, verbose_name='arrival_type_id1')),
                ('station_id1', models.IntegerField(db_column='station_id1', db_index=True, default=0, verbose_name='station_id1')),
                ('station_time1', models.IntegerField(db_column='station_time1', default=0, verbose_name='station_time1')),
                ('bus_stop1', models.CharField(blank=True, db_column='bus_stop1', max_length=50, null=True, verbose_name='bus_stop1')),
                ('bus_stop_time1', models.IntegerField(db_column='bus_stop_time1', default=0, verbose_name='bus_stop_time1')),
                ('arrival_type_id2', models.IntegerField(db_column='arrival_type_id2', default=0, verbose_name='arrival_type_id2')),
                ('station_id2', models.IntegerField(db_column='station_id2', db_index=True, default=0, verbose_name='station_id2')),
                ('station_time2', models.IntegerField(db_column='station_time2', default=0, verbose_name='station_time2')),
                ('bus_stop2', models.CharField(blank=True, db_column='bus_stop2', max_length=50, null=True, verbose_name='bus_stop2')),
                ('bus_stop_time2', models.IntegerField(db_column='bus_stop_time2', default=0, verbose_name='bus_stop_time2')),
                ('arrival_type_id3', models.IntegerField(db_column='arrival_type_id3', default=0, verbose_name='arrival_type_id3')),
                ('station_id3', models.IntegerField(db_column='station_id3', db_index=True, default=0, verbose_name='station_id3')),
                ('station_time3', models.IntegerField(db_column='station_time3', default=0, verbose_name='station_time3')),
                ('bus_stop3', models.CharField(blank=True, db_column='bus_stop3', max_length=50, null=True, verbose_name='bus_stop3')),
                ('bus_stop_time3', models.IntegerField(db_column='bus_stop_time3', default=0, verbose_name='bus_stop_time3')),
                ('building_type_id', models.IntegerField(db_column='building_type_id', db_index=True, default=0, verbose_name='building_type_id')),
                ('building_type_comment', models.CharField(blank=True, db_column='building_type_comment', max_length=100, null=True, verbose_name='building_type_comment')),
                ('structure_id', models.IntegerField(db_column='structure_id', default=0, verbose_name='structure_id')),
                ('structure_comment', models.CharField(blank=True, db_column='structure_comment', max_length=100, null=True, verbose_name='structure_comment')),
                ('building_rooms', models.IntegerField(db_column='building_rooms', default=0, verbose_name='building_rooms')),
                ('building_floors', models.IntegerField(db_column='building_floors', default=0, verbose_name='building_floors')),
                ('building_undergrounds', models.IntegerField(db_column='building_undergrounds', default=0, verbose_name='building_undergrounds')),
                ('build_year', models.IntegerField(db_column='build_year', db_index=True, default=1970, verbose_name='build_year')),
                ('build_month', models.IntegerField(db_column='build_month', default=1, verbose_name='build_month')),
                ('bike_parking_type_id', models.IntegerField(db_column='bike_parking_type_id', default=0, verbose_name='bike_parking_type_id')),
                ('with_bike_parking_roof', models.BooleanField(db_column='with_bike_parking_roof', default=False, verbose_name='with_bike_parking_roof')),
                ('bike_parking_fee_lower', models.IntegerField(db_column='bike_parking_fee_lower', default=0, verbose_name='bike_parking_fee_lower')),
                ('bike_parking_fee_upper', models.IntegerField(db_column='bike_parking_fee_upper', default=0, verbose_name='bike_parking_fee_upper')),
                ('bike_parking_fee_tax_type_id', models.IntegerField(db_column='bike_parking_fee_tax_type_id', default=0, verbose_name='bike_parking_fee_tax_type_id')),
                ('bike_parking_note', models.CharField(blank=True, db_column='bike_parking_note', max_length=255, null=True, verbose_name='bike_parking_note')),
                ('garage_type_id', models.IntegerField(db_column='garage_type_id', db_index=True, default=0, verbose_name='garage_type_id')),
                ('garage_status_id', models.IntegerField(db_column='garage_status_id', default=0, verbose_name='garage_status_id')),
                ('garage_distance', models.IntegerField(db_column='garage_distance', default=0, verbose_name='garage_distance')),
                ('garage_fee_lower', models.IntegerField(db_column='garage_fee_lower', default=0, verbose_name='garage_fee_lower')),
                ('garage_fee_upper', models.IntegerField(db_column='garage_fee_upper', default=0, verbose_name='garage_fee_upper')),
                ('garage_fee_tax_type_id', models.IntegerField(db_column='garage_fee_tax_type_id', default=0, verbose_name='garage_fee_tax_type_id')),
                ('garage_charge_lower', models.IntegerField(db_column='garage_charge_lower', default=0, verbose_name='garage_charge_lower')),
                ('garage_charge_upper', models.IntegerField(db_column='garage_charge_upper', default=0, verbose_name='garage_charge_upper')),
                ('garage_charge_tax_type_id', models.IntegerField(db_column='garage_charge_tax_type_id', default=0, verbose_name='garage_charge_tax_type_id')),
                ('garage_note', models.CharField(blank=True, db_column='garage_note', max_length=255, null=True, verbose_name='garage_note')),
                ('building_management_company', models.CharField(blank=True, db_column='building_management_company', max_length=100, null=True, verbose_name='building_management_company')),
                ('building_management_address', models.CharField(blank=True, db_column='building_management_address', max_length=255, null=True, verbose_name='building_management_address')),
                ('building_management_tel', models.CharField(blank=True, db_column='building_management_tel', max_length=20, null=True, verbose_name='building_management_tel')),
                ('building_management_no', models.CharField(blank=True, db_column='building_management_no', max_length=50, null=True, verbose_name='building_management_no')),
                ('building_management_note', models.CharField(blank=True, db_column='building_management_note', max_length=255, null=True, verbose_name='building_management_note')),
                ('agreement_existence_id', models.IntegerField(db_column='agreement_existence_id', default=0, verbose_name='agreement_existence_id')),
                ('apartment_manager_comment', models.CharField(blank=True, db_column='apartment_manager_comment', max_length=100, null=True, verbose_name='apartment_manager_comment')),
                ('auto_lock_no', models.CharField(blank=True, db_column='auto_lock_no', max_length=20, null=True, verbose_name='auto_lock_no')),
                ('is_hidden_vacancy', models.BooleanField(db_column='is_hidden_vacancy', db_index=True, default=False, verbose_name='is_hidden_vacancy')),
                ('is_vacancy_recommend', models.BooleanField(db_column='is_vacancy_recommend', db_index=True, default=False, verbose_name='is_vacancy_recommend')),
                ('vacancy_rent_comment', models.CharField(blank=True, db_column='vacancy_rent_comment', max_length=100, null=True, verbose_name='vacancy_rent_comment')),
                ('vacancy_condo_fees_comment', models.CharField(blank=True, db_column='vacancy_condo_fees_comment', max_length=100, null=True, verbose_name='vacancy_condo_fees_comment')),
                ('vacancy_water_comment', models.CharField(blank=True, db_column='vacancy_water_comment', max_length=100, null=True, verbose_name='vacancy_water_comment')),
                ('vacancy_electric_comment', models.CharField(blank=True, db_column='vacancy_electric_comment', max_length=100, null=True, verbose_name='vacancy_electric_comment')),
                ('vacancy_gas_comment', models.CharField(blank=True, db_column='vacancy_gas_comment', max_length=100, null=True, verbose_name='vacancy_gas_comment')),
                ('vacancy_internet_comment', models.CharField(blank=True, db_column='vacancy_internet_comment', max_length=100, null=True, verbose_name='vacancy_internet_comment')),
                ('vacancy_cancel_notice_comment', models.CharField(blank=True, db_column='vacancy_cancel_notice_comment', max_length=100, null=True, verbose_name='vacancy_cancel_notice_comment')),
                ('vacancy_short_cancel_comment', models.CharField(blank=True, db_column='vacancy_short_cancel_comment', max_length=100, null=True, verbose_name='vacancy_short_cancel_comment')),
                ('vacancy_payment_comment', models.CharField(blank=True, db_column='vacancy_payment_comment', max_length=100, null=True, verbose_name='vacancy_payment_comment')),
                ('vacancy_guarantee_comment', models.CharField(blank=True, db_column='vacancy_guarantee_comment', max_length=100, null=True, verbose_name='vacancy_guarantee_comment')),
                ('vacancy_insurance_comment', models.CharField(blank=True, db_column='vacancy_insurance_comment', max_length=100, null=True, verbose_name='vacancy_insurance_comment')),
                ('vacancy_guarantor_limit_comment', models.CharField(blank=True, db_column='vacancy_guarantor_limit_comment', max_length=100, null=True, verbose_name='vacancy_guarantor_limit_comment')),
                ('vacancy_document_price_comment', models.CharField(blank=True, db_column='vacancy_document_price_comment', max_length=100, null=True, verbose_name='vacancy_document_price_comment')),
                ('vacancy_renewal_fee_comment', models.CharField(blank=True, db_column='vacancy_renewal_fee_comment', max_length=100, null=True, verbose_name='vacancy_renewal_fee_comment')),
                ('vacancy_renewal_charge_comment', models.CharField(blank=True, db_column='vacancy_renewal_charge_comment', max_length=100, null=True, verbose_name='vacancy_renewal_charge_comment')),
                ('vacancy_auto_lock_comment', models.CharField(blank=True, db_column='vacancy_auto_lock_comment', max_length=100, null=True, verbose_name='vacancy_auto_lock_comment')),
                ('vacancy_security_comment', models.CharField(blank=True, db_column='vacancy_security_comment', max_length=100, null=True, verbose_name='vacancy_security_comment')),
                ('vacancy_bike_parking_comment', models.CharField(blank=True, db_column='vacancy_bike_parking_comment', max_length=100, null=True, verbose_name='vacancy_bike_parking_comment')),
                ('vacancy_garage_comment', models.CharField(blank=True, db_column='vacancy_garage_comment', max_length=100, null=True, verbose_name='vacancy_garage_comment')),
                ('vacancy_cleaning_comment', models.CharField(blank=True, db_column='vacancy_cleaning_comment', max_length=100, null=True, verbose_name='vacancy_cleaning_comment')),
                ('vacancy_change_lock_comment', models.CharField(blank=True, db_column='vacancy_change_lock_comment', max_length=100, null=True, verbose_name='vacancy_change_lock_comment')),
                ('vacancy_portal_note', models.CharField(blank=True, db_column='vacancy_portal_note', max_length=255, null=True, verbose_name='vacancy_portal_note')),
                ('vacancy_catch_copy', models.CharField(blank=True, db_column='vacancy_catch_copy', max_length=100, null=True, verbose_name='vacancy_catch_copy')),
                ('vacancy_appeal', models.CharField(blank=True, db_column='vacancy_appeal', max_length=255, null=True, verbose_name='vacancy_appeal')),
                ('vacancy_note', models.TextField(blank=True, db_column='vacancy_note', max_length=2000, null=True, verbose_name='vacancy_note')),
                ('is_hidden_web', models.BooleanField(db_column='is_hidden_web', db_index=True, default=False, verbose_name='is_hidden_web')),
                ('web_catch_copy', models.CharField(blank=True, db_column='web_catch_copy', max_length=100, null=True, verbose_name='web_catch_copy')),
                ('web_appeal', models.CharField(blank=True, db_column='web_appeal', max_length=255, null=True, verbose_name='web_appeal')),
                ('web_note', models.TextField(blank=True, db_column='web_note', max_length=2000, null=True, verbose_name='web_note')),
                ('tenant_note', models.TextField(blank=True, db_column='tenant_note', max_length=2000, null=True, verbose_name='tenant_note')),
                ('garbage_note', models.TextField(blank=True, db_column='garbage_note', max_length=2000, null=True, verbose_name='garbage_note')),
                ('private_note', models.TextField(blank=True, db_column='private_note', max_length=2000, null=True, verbose_name='private_note')),
                ('management_note', models.TextField(blank=True, db_column='management_note', max_length=2000, null=True, verbose_name='management_note')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'building',
                'verbose_name_plural': 'buildings',
                'db_table': 'building',
                'ordering': ['building_kana', 'id'],
            },
        ),
        migrations.CreateModel(
            name='BuildingFacility',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('facility_id', models.IntegerField(db_column='facility_id', db_index=True, default=0, verbose_name='facility_id')),
                ('facility_name', models.CharField(blank=True, db_column='facility_name', max_length=100, null=True, verbose_name='facility_name')),
                ('distance', models.IntegerField(db_column='distance', default=0, verbose_name='distance')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('building_picture_id', models.IntegerField(db_column='building_picture_id', default=0, verbose_name='building_picture_id')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'building_facility',
                'verbose_name_plural': 'building_facilities',
                'db_table': 'building_facility',
                'ordering': ['building_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='BuildingFile',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('file_name', models.CharField(db_column='file_name', max_length=255, verbose_name='file_name')),
                ('cache_name', models.CharField(db_column='cache_name', max_length=255, verbose_name='cache_name')),
                ('file_title', models.CharField(blank=True, db_column='file_title', max_length=255, null=True, verbose_name='file_title')),
                ('is_publish_web', models.BooleanField(db_column='is_publish_web', db_index=True, default=False, verbose_name='is_publish_web')),
                ('is_publish_vacancy', models.BooleanField(db_column='is_publish_vacancy', db_index=True, default=True, verbose_name='is_publish_vacancy')),
                ('comment', models.CharField(blank=True, db_column='comment', max_length=50, null=True, verbose_name='comment')),
                ('note', models.CharField(blank=True, db_column='note', max_length=255, null=True, verbose_name='note')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'building_file',
                'verbose_name_plural': 'building_files',
                'db_table': 'building_file',
                'ordering': ['building_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='BuildingGarage',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('garage_name', models.CharField(db_column='garage_name', max_length=100, verbose_name='garage_name')),
                ('garage_fee', models.IntegerField(db_column='garage_fee', default=0, verbose_name='garage_fee')),
                ('garage_fee_tax_type_id', models.IntegerField(db_column='garage_fee_tax_type_id', default=0, verbose_name='garage_fee_tax_type_id')),
                ('garage_charge', models.IntegerField(db_column='garage_charge', default=0, verbose_name='garage_charge')),
                ('garage_charge_tax_type_id', models.IntegerField(db_column='garage_charge_tax_type_id', default=0, verbose_name='garage_charge_tax_type_id')),
                ('garage_deposit', models.IntegerField(db_column='garage_deposit', default=0, verbose_name='garage_deposit')),
                ('garage_deposit_tax_type_id', models.IntegerField(db_column='garage_deposit_tax_type_id', default=0, verbose_name='garage_deposit_tax_type_id')),
                ('certification_fee', models.IntegerField(db_column='certification_fee', default=0, verbose_name='certification_fee')),
                ('certification_fee_tax_type_id', models.IntegerField(db_column='certification_fee_tax_type_id', default=0, verbose_name='certification_fee_tax_type_id')),
                ('initial_cost_name1', models.CharField(blank=True, db_column='initial_cost_name1', max_length=100, null=True, verbose_name='initial_cost_name1')),
                ('initial_cost1', models.IntegerField(db_column='initial_cost1', default=0, verbose_name='initial_cost1')),
                ('initial_cost_tax_type_id1', models.IntegerField(db_column='initial_cost_tax_type_id1', default=0, verbose_name='initial_cost_tax_type_id1')),
                ('initial_cost_name2', models.CharField(blank=True, db_column='initial_cost_name2', max_length=100, null=True, verbose_name='initial_cost_name2')),
                ('initial_cost2', models.IntegerField(db_column='initial_cost2', default=0, verbose_name='initial_cost2')),
                ('initial_cost_tax_type_id2', models.IntegerField(db_column='initial_cost_tax_type_id2', default=0, verbose_name='initial_cost_tax_type_id2')),
                ('initial_cost_name3', models.CharField(blank=True, db_column='initial_cost_name3', max_length=100, null=True, verbose_name='initial_cost_name3')),
                ('initial_cost3', models.IntegerField(db_column='initial_cost3', default=0, verbose_name='initial_cost3')),
                ('initial_cost_tax_type_id3', models.IntegerField(db_column='initial_cost_tax_type_id3', default=0, verbose_name='initial_cost_tax_type_id3')),
                ('garage_status_id', models.IntegerField(db_column='garage_status_id', db_index=True, default=0, verbose_name='garage_status_id')),
                ('allow_no_room', models.BooleanField(db_column='allow_no_room', db_index=True, default=False, verbose_name='allow_no_room')),
                ('width', models.DecimalField(db_column='width', decimal_places=2, default=0, max_digits=12, verbose_name='width')),
                ('length', models.DecimalField(db_column='length', decimal_places=2, default=0, max_digits=12, verbose_name='length')),
                ('height', models.DecimalField(db_column='height', decimal_places=2, default=0, max_digits=12, verbose_name='height')),
                ('comment', models.CharField(blank=True, db_column='comment', max_length=100, null=True, verbose_name='comment')),
                ('note', models.CharField(blank=True, db_column='note', max_length=255, null=True, verbose_name='note')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'building_garage',
                'verbose_name_plural': 'building_garages',
                'db_table': 'building_garage',
                'ordering': ['building_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='BuildingLandmark',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('landmark_id', models.IntegerField(db_column='landmark_id', db_index=True, default=0, verbose_name='landmark_id')),
                ('distance', models.IntegerField(db_column='distance', default=0, verbose_name='distance')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'building_landmark',
                'verbose_name_plural': 'building_landmarks',
                'db_table': 'building_landmark',
                'ordering': ['building_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='BuildingMovie',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('file_name', models.CharField(db_column='file_name', max_length=255, verbose_name='file_name')),
                ('cache_name', models.CharField(db_column='cache_name', max_length=255, verbose_name='cache_name')),
                ('movie_type_id', models.IntegerField(db_column='movie_type_id', db_index=True, default=0, verbose_name='movie_type_id')),
                ('is_publish_web', models.BooleanField(db_column='is_publish_web', db_index=True, default=True, verbose_name='is_publish_web')),
                ('is_publish_vacancy', models.BooleanField(db_column='is_publish_vacancy', db_index=True, default=True, verbose_name='is_publish_vacancy')),
                ('comment', models.CharField(blank=True, db_column='comment', max_length=50, null=True, verbose_name='comment')),
                ('note', models.CharField(blank=True, db_column='note', max_length=255, null=True, verbose_name='note')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'building_movie',
                'verbose_name_plural': 'building_movies',
                'db_table': 'building_movie',
                'ordering': ['building_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='BuildingPanorama',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('file_name', models.CharField(db_column='file_name', max_length=255, verbose_name='file_name')),
                ('cache_name', models.CharField(db_column='cache_name', max_length=255, verbose_name='cache_name')),
                ('panorama_type_id', models.IntegerField(db_column='panorama_type_id', db_index=True, default=0, verbose_name='panorama_type_id')),
                ('is_publish_web', models.BooleanField(db_column='is_publish_web', db_index=True, default=True, verbose_name='is_publish_web')),
                ('is_publish_vacancy', models.BooleanField(db_column='is_publish_vacancy', db_index=True, default=True, verbose_name='is_publish_vacancy')),
                ('comment', models.CharField(blank=True, db_column='comment', max_length=50, null=True, verbose_name='comment')),
                ('note', models.CharField(blank=True, db_column='note', max_length=255, null=True, verbose_name='note')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'building_panorama',
                'verbose_name_plural': 'building_panoramas',
                'db_table': 'building_panorama',
                'ordering': ['building_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='BuildingPicture',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('file_name', models.CharField(db_column='file_name', max_length=255, verbose_name='file_name')),
                ('cache_name_thumb', models.CharField(db_column='cache_name_thumb', max_length=255, verbose_name='cache_name_thumb')),
                ('cache_name_s', models.CharField(db_column='cache_name_s', max_length=255, verbose_name='cache_name_s')),
                ('cache_name_m', models.CharField(db_column='cache_name_m', max_length=255, verbose_name='cache_name_m')),
                ('cache_name_l', models.CharField(db_column='cache_name_l', max_length=255, verbose_name='cache_name_l')),
                ('cache_name_org', models.CharField(db_column='cache_name_org', max_length=255, verbose_name='cache_name_org')),
                ('picture_type_id', models.IntegerField(db_column='picture_type_id', db_index=True, default=0, verbose_name='picture_type_id')),
                ('is_publish_web', models.BooleanField(db_column='is_publish_web', db_index=True, default=True, verbose_name='is_publish_web')),
                ('is_publish_vacancy', models.BooleanField(db_column='is_publish_vacancy', db_index=True, default=True, verbose_name='is_publish_vacancy')),
                ('comment', models.CharField(blank=True, db_column='comment', max_length=50, null=True, verbose_name='comment')),
                ('note', models.CharField(blank=True, db_column='note', max_length=255, null=True, verbose_name='note')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'building_picture',
                'verbose_name_plural': 'building_pictures',
                'db_table': 'building_picture',
                'ordering': ['building_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='BuildingType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_residential', models.BooleanField(db_column='is_residential', default=False, verbose_name='is_residential')),
                ('is_building', models.BooleanField(db_column='is_building', default=False, verbose_name='is_building')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'building_type',
                'verbose_name_plural': 'building_types',
                'db_table': 'building_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('pref_id', models.IntegerField(db_column='pref_id', db_index=True, default=0, verbose_name='pref_id')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('lat', models.FloatField(db_column='lat', db_index=True, default=0, verbose_name='lat')),
                ('lng', models.FloatField(db_column='lng', db_index=True, default=0, verbose_name='lng')),
                ('is_trading_area', models.BooleanField(db_column='is_trading_area', db_index=True, default=False, verbose_name='is_trading_area')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'city',
                'verbose_name_plural': 'cities',
                'db_table': 'city',
                'ordering': ['pref_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='CityArea',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('city_id', models.IntegerField(db_column='city_id', db_index=True, default=0, verbose_name='city_id')),
                ('area_id', models.IntegerField(db_column='area_id', default=0, verbose_name='area_id')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'city_area',
                'verbose_name_plural': 'city_areas',
                'db_table': 'city_area',
                'ordering': ['city_id', 'area_id', 'id'],
            },
        ),
        migrations.CreateModel(
            name='CityElementarySchool',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('city_id', models.IntegerField(db_column='city_id', db_index=True, default=0, verbose_name='city_id')),
                ('school_id', models.IntegerField(db_column='school_id', default=0, verbose_name='school_id')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'city_elementary_school',
                'verbose_name_plural': 'city_elementary_schools',
                'db_table': 'city_elementary_school',
                'ordering': ['city_id', 'school_id', 'id'],
            },
        ),
        migrations.CreateModel(
            name='CityJuniorHighSchool',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('city_id', models.IntegerField(db_column='city_id', db_index=True, default=0, verbose_name='city_id')),
                ('school_id', models.IntegerField(db_column='school_id', default=0, verbose_name='school_id')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'city_junior_high_school',
                'verbose_name_plural': 'city_junior_high_schools',
                'db_table': 'city_junior_high_school',
                'ordering': ['city_id', 'school_id', 'id'],
            },
        ),
        migrations.CreateModel(
            name='CleaningType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_paid', models.BooleanField(db_column='is_paid', default=False, verbose_name='is_paid')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'cleaning_type',
                'verbose_name_plural': 'cleaning_types',
                'db_table': 'cleaning_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('api_key', models.CharField(blank=True, db_column='api_key', max_length=50, null=True, verbose_name='api_key')),
                ('internal_api_key', models.CharField(blank=True, db_column='internal_api_key', max_length=50, null=True, verbose_name='internal_api_key')),
                ('company_name', models.CharField(blank=True, db_column='company_name', db_index=True, max_length=100, null=True, verbose_name='company_name')),
                ('company_kana', models.CharField(blank=True, db_column='company_kana', db_index=True, max_length=100, null=True, verbose_name='company_kana')),
                ('shop_name', models.CharField(blank=True, db_column='shop_name', max_length=100, null=True, verbose_name='shop_name')),
                ('postal_code', models.CharField(blank=True, db_column='postal_code', max_length=10, null=True, verbose_name='postal_code')),
                ('address', models.CharField(blank=True, db_column='address', max_length=255, null=True, verbose_name='address')),
                ('tel', models.CharField(blank=True, db_column='tel', max_length=20, null=True, verbose_name='tel')),
                ('fax', models.CharField(blank=True, db_column='fax', max_length=20, null=True, verbose_name='fax')),
                ('mail', models.EmailField(blank=True, db_column='mail', max_length=254, null=True, verbose_name='mail')),
                ('agency_no', models.CharField(blank=True, db_column='agency_no', max_length=50, null=True, verbose_name='agency_no')),
                ('pm_no', models.CharField(blank=True, db_column='pm_no', max_length=50, null=True, verbose_name='pm_no')),
                ('water_mark', models.CharField(blank=True, db_column='water_mark', max_length=50, null=True, verbose_name='water_mark')),
                ('is_default', models.BooleanField(db_column='is_default', default=True, verbose_name='is_default')),
            ],
            options={
                'verbose_name': 'company',
                'verbose_name_plural': 'companies',
                'db_table': 'company',
                'ordering': ['company_kana', 'id'],
            },
        ),
        migrations.CreateModel(
            name='CondoFeesType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'condo_fees_type',
                'verbose_name_plural': 'condo_fees_types',
                'db_table': 'condo_fees_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('department_name', models.CharField(blank=True, db_column='department_name', db_index=True, max_length=100, null=True, verbose_name='department_name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('postal_code', models.CharField(blank=True, db_column='postal_code', max_length=10, null=True, verbose_name='postal_code')),
                ('address', models.CharField(blank=True, db_column='address', max_length=255, null=True, verbose_name='address')),
                ('tel', models.CharField(blank=True, db_column='tel', max_length=20, null=True, verbose_name='tel')),
                ('fax', models.CharField(blank=True, db_column='fax', max_length=20, null=True, verbose_name='fax')),
                ('mail', models.EmailField(blank=True, db_column='mail', max_length=254, null=True, verbose_name='mail')),
                ('is_publish_vacancy', models.BooleanField(db_column='is_publish_vacancy', db_index=True, default=True, verbose_name='is_publish_vacancy')),
                ('note', models.TextField(blank=True, db_column='note', max_length=2000, null=True, verbose_name='note')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'department',
                'verbose_name_plural': 'departments',
                'db_table': 'department',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='DepositNotation',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('unit', models.CharField(blank=True, db_column='unit', max_length=50, null=True, verbose_name='unit')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'deposit_notation',
                'verbose_name_plural': 'deposit_notations',
                'db_table': 'deposit_notation',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='DepositType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('coefficient', models.IntegerField(db_column='coefficient', default=0, verbose_name='coefficient')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'deposit_type',
                'verbose_name_plural': 'deposit_types',
                'db_table': 'deposit_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Direction',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'direction',
                'verbose_name_plural': 'directions',
                'db_table': 'direction',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='DocumentFile',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('file_name', models.CharField(db_column='file_name', max_length=255, verbose_name='file_name')),
                ('cache_name', models.CharField(db_column='cache_name', max_length=255, verbose_name='cache_name')),
                ('file_title', models.CharField(blank=True, db_column='file_title', max_length=255, null=True, verbose_name='file_title')),
                ('is_publish_web', models.BooleanField(db_column='is_publish_web', db_index=True, default=False, verbose_name='is_publish_web')),
                ('is_publish_vacancy', models.BooleanField(db_column='is_publish_vacancy', db_index=True, default=True, verbose_name='is_publish_vacancy')),
                ('comment', models.CharField(blank=True, db_column='comment', max_length=50, null=True, verbose_name='comment')),
                ('note', models.CharField(blank=True, db_column='note', max_length=255, null=True, verbose_name='note')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'document_file',
                'verbose_name_plural': 'document_files',
                'db_table': 'document_file',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='ElectricType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'electric_type',
                'verbose_name_plural': 'electric_types',
                'db_table': 'electric_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='ElementarySchool',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('pref_id', models.IntegerField(db_column='pref_id', db_index=True, default=0, verbose_name='pref_id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('kana', models.CharField(blank=True, db_column='kana', db_index=True, max_length=100, null=True, verbose_name='kana')),
                ('lat', models.FloatField(db_column='lat', db_index=True, default=0, verbose_name='lat')),
                ('lng', models.FloatField(db_column='lng', db_index=True, default=0, verbose_name='lng')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'elementary_school',
                'verbose_name_plural': 'elementary_schools',
                'db_table': 'elementary_school',
                'ordering': ['pref_id', 'kana', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Equipment',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=100, verbose_name='name')),
                ('short_name', models.CharField(db_column='short_name', max_length=50, verbose_name='short_name')),
                ('category_id', models.IntegerField(db_column='category_id', db_index=True, default=0, verbose_name='category_id')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'equipment',
                'verbose_name_plural': 'equipments',
                'db_table': 'equipment',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='EquipmentCategory',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_residence', models.BooleanField(db_column='is_residence', default=False, verbose_name='is_residence')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'equipment_category',
                'verbose_name_plural': 'equipment_categories',
                'db_table': 'equipment_category',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Existence',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'existence',
                'verbose_name_plural': 'existences',
                'db_table': 'existence',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Facility',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'facility',
                'verbose_name_plural': 'facilities',
                'db_table': 'facility',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='FreeRentType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'free_rent_type',
                'verbose_name_plural': 'free_rent_types',
                'db_table': 'free_rent_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='GarageStatus',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'garage_status',
                'verbose_name_plural': 'garage_statuses',
                'db_table': 'garage_status',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='GarageType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_exist', models.BooleanField(db_column='is_exist', default=False, verbose_name='is_exist')),
                ('is_free', models.BooleanField(db_column='is_free', default=False, verbose_name='is_free')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'garage_type',
                'verbose_name_plural': 'garage_types',
                'db_table': 'garage_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='GasType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'gas_type',
                'verbose_name_plural': 'gas_types',
                'db_table': 'gas_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='GuaranteeCompany',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(blank=True, db_column='name', max_length=50, null=True, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'guarantee_company',
                'verbose_name_plural': 'guarantee_companies',
                'db_table': 'guarantee_company',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='GuaranteeType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'guarantee_type',
                'verbose_name_plural': 'guarantee_types',
                'db_table': 'guarantee_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='InsuranceCompany',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(blank=True, db_column='name', max_length=50, null=True, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'insurance_company',
                'verbose_name_plural': 'insurance_companies',
                'db_table': 'insurance_company',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='InsuranceType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_specified', models.BooleanField(db_column='is_specified', default=False, verbose_name='is_specified')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'insurance_type',
                'verbose_name_plural': 'insurance_types',
                'db_table': 'insurance_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='InternetType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'internet_type',
                'verbose_name_plural': 'internet_types',
                'db_table': 'internet_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='JuniorHighSchool',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('pref_id', models.IntegerField(db_column='pref_id', db_index=True, default=0, verbose_name='pref_id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('kana', models.CharField(blank=True, db_column='kana', db_index=True, max_length=100, null=True, verbose_name='kana')),
                ('lat', models.FloatField(db_column='lat', db_index=True, default=0, verbose_name='lat')),
                ('lng', models.FloatField(db_column='lng', db_index=True, default=0, verbose_name='lng')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'junior_high_school',
                'verbose_name_plural': 'junior_high_schools',
                'db_table': 'junior_high_school',
                'ordering': ['pref_id', 'kana', 'id'],
            },
        ),
        migrations.CreateModel(
            name='KeyMoneyNotation',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('unit', models.CharField(blank=True, db_column='unit', max_length=50, null=True, verbose_name='unit')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'key_money_notation',
                'verbose_name_plural': 'key_money_notations',
                'db_table': 'key_money_notation',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='KeyMoneyType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('coefficient', models.IntegerField(db_column='coefficient', default=0, verbose_name='coefficient')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'key_money_type',
                'verbose_name_plural': 'key_money_types',
                'db_table': 'key_money_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='KitchenRangeType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'kitchen_range_type',
                'verbose_name_plural': 'kitchen_range_types',
                'db_table': 'kitchen_range_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='KitchenType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('notation', models.CharField(blank=True, db_column='notation', max_length=50, null=True, verbose_name='notation')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'kitchen_type',
                'verbose_name_plural': 'kitchen_types',
                'db_table': 'kitchen_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Landmark',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('landmark_type_id', models.IntegerField(db_column='landmark_type_id', db_index=True, default=0, verbose_name='landmark_type_id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('kana', models.CharField(blank=True, db_column='kana', db_index=True, max_length=100, null=True, verbose_name='kana')),
                ('short_name', models.CharField(blank=True, db_column='short_name', max_length=50, null=True, verbose_name='short_name')),
                ('lat', models.FloatField(db_column='lat', db_index=True, default=0, verbose_name='lat')),
                ('lng', models.FloatField(db_column='lng', db_index=True, default=0, verbose_name='lng')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'landmark',
                'verbose_name_plural': 'landmarks',
                'db_table': 'landmark',
                'ordering': ['landmark_type_id', 'priority', 'kana', 'id'],
            },
        ),
        migrations.CreateModel(
            name='LandmarkType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'landmark_type',
                'verbose_name_plural': 'landmark_types',
                'db_table': 'landmark_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='LayoutType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('room_count', models.IntegerField(db_column='room_count', db_index=True, default=0, verbose_name='room_count')),
                ('category_id', models.IntegerField(db_column='category_id', db_index=True, default=0, verbose_name='category_id')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'layout_type',
                'verbose_name_plural': 'layout_types',
                'db_table': 'layout_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='LayoutTypeCategory',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_searchable', models.BooleanField(db_column='is_searchable', default=False, verbose_name='is_searchable')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'layout_type_category',
                'verbose_name_plural': 'layout_type_categories',
                'db_table': 'layout_type_category',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='ManagementInfo',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('information', models.CharField(db_column='information', max_length=255, verbose_name='information')),
                ('link_url', models.URLField(blank=True, db_column='link_url', null=True, verbose_name='link_url')),
                ('start_date', models.CharField(db_column='start_date', db_index=True, max_length=10, verbose_name='start_date')),
                ('end_date', models.CharField(db_column='end_date', db_index=True, max_length=10, verbose_name='end_date')),
                ('is_emphasized', models.BooleanField(db_column='is_emphasized', default=False, verbose_name='is_emphasized')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'management_info',
                'verbose_name_plural': 'management_infos',
                'db_table': 'management_info',
                'ordering': ['priority', '-start_date', 'end_date', 'id'],
            },
        ),
        migrations.CreateModel(
            name='ManagementType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_own', models.BooleanField(db_column='is_own', default=False, verbose_name='is_own')),
                ('is_entrusted', models.BooleanField(db_column='is_entrusted', default=False, verbose_name='is_entrusted')),
                ('is_condo_management', models.BooleanField(db_column='is_condo_management', default=False, verbose_name='is_condo_management')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'management_type',
                'verbose_name_plural': 'management_types',
                'db_table': 'management_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='MonthDay',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('from_day', models.IntegerField(db_column='from_day', db_index=True, default=0, verbose_name='from_day')),
                ('to_day', models.IntegerField(db_column='to_day', db_index=True, default=0, verbose_name='to_day')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'month_day',
                'verbose_name_plural': 'month_days',
                'db_table': 'month_day',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='MovieType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_building', models.BooleanField(db_column='is_building', default=False, verbose_name='is_building')),
                ('is_room', models.BooleanField(db_column='is_room', default=False, verbose_name='is_room')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'movie_type',
                'verbose_name_plural': 'movie_types',
                'db_table': 'movie_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Owner',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('owner_name', models.CharField(db_column='owner_name', db_index=True, max_length=255, verbose_name='owner_name')),
                ('owner_kana', models.CharField(blank=True, db_column='owner_kana', db_index=True, max_length=255, null=True, verbose_name='owner_kana')),
                ('is_corporation', models.BooleanField(db_column='is_corporation', default=False, verbose_name='is_corporation')),
                ('corporation_owner_name', models.CharField(blank=True, db_column='corporation_owner_name', db_index=True, max_length=255, null=True, verbose_name='corporation_owner_name')),
                ('postal_code', models.CharField(blank=True, db_column='postal_code', max_length=10, null=True, verbose_name='postal_code')),
                ('address', models.CharField(blank=True, db_column='address', max_length=255, null=True, verbose_name='address')),
                ('tel1', models.CharField(blank=True, db_column='tel1', max_length=20, null=True, verbose_name='tel1')),
                ('tel2', models.CharField(blank=True, db_column='tel2', max_length=20, null=True, verbose_name='tel2')),
                ('fax', models.CharField(blank=True, db_column='fax', max_length=20, null=True, verbose_name='fax')),
                ('mail', models.EmailField(blank=True, db_column='mail', max_length=254, null=True, verbose_name='mail')),
                ('staff_id', models.IntegerField(db_column='staff_id', db_index=True, default=0, verbose_name='staff_id')),
                ('note', models.TextField(blank=True, db_column='note', max_length=2000, null=True, verbose_name='note')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'owner',
                'verbose_name_plural': 'owners',
                'db_table': 'owner',
                'ordering': ['owner_kana', 'id'],
            },
        ),
        migrations.CreateModel(
            name='OwnerFeeType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'owner_fee_type',
                'verbose_name_plural': 'owner_fee_types',
                'db_table': 'owner_fee_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='PanoramaType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_building', models.BooleanField(db_column='is_building', default=False, verbose_name='is_building')),
                ('is_room', models.BooleanField(db_column='is_room', default=False, verbose_name='is_room')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'panorama_type',
                'verbose_name_plural': 'panorama_types',
                'db_table': 'panorama_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='PaymentFeeType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'payment_fee_type',
                'verbose_name_plural': 'payment_fee_types',
                'db_table': 'payment_fee_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='PaymentType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'payment_type',
                'verbose_name_plural': 'payment_types',
                'db_table': 'payment_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='PetType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_ok', models.BooleanField(db_column='is_ok', default=False, verbose_name='is_ok')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'pet_type',
                'verbose_name_plural': 'pet_types',
                'db_table': 'pet_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='PictureType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_building', models.BooleanField(db_column='is_building', default=False, verbose_name='is_building')),
                ('is_room', models.BooleanField(db_column='is_room', default=False, verbose_name='is_room')),
                ('is_building_exterior', models.BooleanField(db_column='is_building_exterior', default=False, verbose_name='is_building_exterior')),
                ('is_layout', models.BooleanField(db_column='is_layout', default=False, verbose_name='is_layout')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'picture_type',
                'verbose_name_plural': 'picture_types',
                'db_table': 'picture_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='PostalCode',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('postal_code', models.CharField(db_column='postal_code', db_index=True, max_length=20, verbose_name='postal_code')),
                ('pref_id', models.IntegerField(db_column='pref_id', db_index=True, default=0, verbose_name='pref_id')),
                ('city_id', models.IntegerField(db_column='city_id', db_index=True, default=0, verbose_name='city_id')),
                ('pref_name', models.CharField(blank=True, db_column='pref_name', max_length=50, null=True, verbose_name='pref_name')),
                ('city_name', models.CharField(blank=True, db_column='city_name', max_length=50, null=True, verbose_name='city_name')),
                ('town_name', models.CharField(blank=True, db_column='town_name', max_length=100, null=True, verbose_name='town_name')),
                ('pref_kana', models.CharField(blank=True, db_column='pref_kana', db_index=True, max_length=50, null=True, verbose_name='pref_kana')),
                ('city_kana', models.CharField(blank=True, db_column='city_kana', db_index=True, max_length=50, null=True, verbose_name='city_kana')),
                ('town_kana', models.CharField(blank=True, db_column='town_kana', db_index=True, max_length=100, null=True, verbose_name='town_kana')),
            ],
            options={
                'verbose_name': 'postal_code',
                'verbose_name_plural': 'postal_codes',
                'db_table': 'postal_code',
                'ordering': ['postal_code', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Pref',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_trading_area', models.BooleanField(db_column='is_trading_area', db_index=True, default=False, verbose_name='is_trading_area')),
            ],
            options={
                'verbose_name': 'pref',
                'verbose_name_plural': 'prefs',
                'db_table': 'pref',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Railway',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('short_name', models.CharField(blank=True, db_column='short_name', max_length=50, null=True, verbose_name='short_name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_trading', models.BooleanField(db_column='is_trading', db_index=True, default=False, verbose_name='is_trading')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'railway',
                'verbose_name_plural': 'railways',
                'db_table': 'railway',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='RenewalFeeNotation',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('header', models.CharField(blank=True, db_column='header', max_length=50, null=True, verbose_name='header')),
                ('unit', models.CharField(blank=True, db_column='unit', max_length=50, null=True, verbose_name='unit')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'renewal_fee_notation',
                'verbose_name_plural': 'renewal_fee_notations',
                'db_table': 'renewal_fee_notation',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='RentalType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('short_name', models.CharField(blank=True, db_column='short_name', max_length=50, null=True, verbose_name='short_name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_residential', models.BooleanField(db_column='is_residential', default=False, verbose_name='is_residential')),
                ('is_non_residential', models.BooleanField(db_column='is_non_residential', default=False, verbose_name='is_non_residential')),
                ('is_land', models.BooleanField(db_column='is_land', default=False, verbose_name='is_land')),
                ('is_limited_rent', models.BooleanField(db_column='is_limited_rent', default=False, verbose_name='is_limited_rent')),
                ('is_sublease', models.BooleanField(db_column='is_sublease', default=False, verbose_name='is_sublease')),
                ('is_own', models.BooleanField(db_column='is_own', default=False, verbose_name='is_own')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'rental_type',
                'verbose_name_plural': 'rental_types',
                'db_table': 'rental_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Room',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('oid', models.CharField(db_column='oid', db_index=True, max_length=50, unique=True, verbose_name='oid')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('room_no', models.CharField(blank=True, db_column='room_no', db_index=True, max_length=20, null=True, verbose_name='room_no')),
                ('room_floor', models.IntegerField(db_column='room_floor', default=0, verbose_name='room_floor')),
                ('room_auth_level_id', models.IntegerField(db_column='room_auth_level_id', db_index=True, default=0, verbose_name='room_auth_level_id')),
                ('rental_type_id', models.IntegerField(db_column='rental_type_id', default=0, verbose_name='rental_type_id')),
                ('is_sublease', models.BooleanField(db_column='is_sublease', db_index=True, default=False, verbose_name='is_sublease')),
                ('is_condo_management', models.BooleanField(db_column='is_condo_management', db_index=True, default=False, verbose_name='is_condo_management')),
                ('condo_owner_id', models.IntegerField(db_column='condo_owner_id', db_index=True, default=0, verbose_name='condo_owner_id')),
                ('is_entrusted', models.BooleanField(db_column='is_entrusted', db_index=True, default=False, verbose_name='is_entrusted')),
                ('condo_trader_id', models.IntegerField(db_column='condo_trader_id', db_index=True, default=0, verbose_name='condo_trader_id')),
                ('room_status_id', models.IntegerField(db_column='room_status_id', db_index=True, default=0, verbose_name='room_status_id')),
                ('vacancy_status_id', models.IntegerField(db_column='vacancy_status_id', db_index=True, default=0, verbose_name='vacancy_status_id')),
                ('vacancy_status_note', models.TextField(blank=True, db_column='vacancy_status_note', max_length=2000, null=True, verbose_name='vacancy_status_note')),
                ('live_start_year', models.IntegerField(db_column='live_start_year', default=0, verbose_name='live_start_year')),
                ('live_start_month', models.IntegerField(db_column='live_start_month', default=0, verbose_name='live_start_month')),
                ('live_start_day_id', models.IntegerField(db_column='live_start_day_id', default=0, verbose_name='live_start_day_id')),
                ('live_start_note', models.CharField(blank=True, db_column='live_start_note', max_length=255, null=True, verbose_name='live_start_note')),
                ('cancel_scheduled_year', models.IntegerField(db_column='cancel_scheduled_year', default=0, verbose_name='cancel_scheduled_year')),
                ('cancel_scheduled_month', models.IntegerField(db_column='cancel_scheduled_month', default=0, verbose_name='cancel_scheduled_month')),
                ('cancel_scheduled_day_id', models.IntegerField(db_column='cancel_scheduled_day_id', default=0, verbose_name='cancel_scheduled_day_id')),
                ('cancel_scheduled_note', models.CharField(blank=True, db_column='cancel_scheduled_note', max_length=255, null=True, verbose_name='cancel_scheduled_note')),
                ('is_publish_vacancy', models.BooleanField(db_column='is_publish_vacancy', db_index=True, default=True, verbose_name='is_publish_vacancy')),
                ('vacancy_start_date', models.CharField(blank=True, db_column='vacancy_start_date', db_index=True, max_length=10, null=True, verbose_name='vacancy_start_date')),
                ('vacancy_end_date', models.CharField(blank=True, db_column='vacancy_end_date', db_index=True, max_length=10, null=True, verbose_name='vacancy_end_date')),
                ('vacancy_catch_copy', models.CharField(blank=True, db_column='vacancy_catch_copy', max_length=100, null=True, verbose_name='vacancy_catch_copy')),
                ('vacancy_appeal', models.CharField(blank=True, db_column='vacancy_appeal', max_length=255, null=True, verbose_name='vacancy_appeal')),
                ('vacancy_note', models.TextField(blank=True, db_column='vacancy_note', max_length=2000, null=True, verbose_name='vacancy_note')),
                ('pending_trader_name', models.CharField(blank=True, db_column='pending_trader_name', max_length=100, null=True, verbose_name='pending_trader_name')),
                ('pending_start_date', models.CharField(blank=True, db_column='pending_start_date', max_length=10, null=True, verbose_name='pending_start_date')),
                ('pending_end_date', models.CharField(blank=True, db_column='pending_end_date', max_length=10, null=True, verbose_name='pending_end_date')),
                ('pending_note', models.CharField(blank=True, db_column='pending_note', max_length=255, null=True, verbose_name='pending_note')),
                ('is_publish_web', models.BooleanField(db_column='is_publish_web', db_index=True, default=True, verbose_name='is_publish_web')),
                ('web_catch_copy', models.CharField(blank=True, db_column='web_catch_copy', max_length=100, null=True, verbose_name='web_catch_copy')),
                ('web_appeal', models.CharField(blank=True, db_column='web_appeal', max_length=255, null=True, verbose_name='web_appeal')),
                ('web_note', models.TextField(blank=True, db_column='web_note', max_length=2000, null=True, verbose_name='web_note')),
                ('layout_type_id', models.IntegerField(db_column='layout_type_id', db_index=True, default=0, verbose_name='layout_type_id')),
                ('western_style_room1', models.DecimalField(db_column='western_style_room1', decimal_places=2, default=0, max_digits=5, verbose_name='western_style_room1')),
                ('western_style_room2', models.DecimalField(db_column='western_style_room2', decimal_places=2, default=0, max_digits=5, verbose_name='western_style_room2')),
                ('western_style_room3', models.DecimalField(db_column='western_style_room3', decimal_places=2, default=0, max_digits=5, verbose_name='western_style_room3')),
                ('western_style_room4', models.DecimalField(db_column='western_style_room4', decimal_places=2, default=0, max_digits=5, verbose_name='western_style_room4')),
                ('western_style_room5', models.DecimalField(db_column='western_style_room5', decimal_places=2, default=0, max_digits=5, verbose_name='western_style_room5')),
                ('western_style_room6', models.DecimalField(db_column='western_style_room6', decimal_places=2, default=0, max_digits=5, verbose_name='western_style_room6')),
                ('western_style_room7', models.DecimalField(db_column='western_style_room7', decimal_places=2, default=0, max_digits=5, verbose_name='western_style_room7')),
                ('western_style_room8', models.DecimalField(db_column='western_style_room8', decimal_places=2, default=0, max_digits=5, verbose_name='western_style_room8')),
                ('western_style_room9', models.DecimalField(db_column='western_style_room9', decimal_places=2, default=0, max_digits=5, verbose_name='western_style_room9')),
                ('western_style_room10', models.DecimalField(db_column='western_style_room10', decimal_places=2, default=0, max_digits=5, verbose_name='western_style_room10')),
                ('japanese_style_room1', models.DecimalField(db_column='japanese_style_room1', decimal_places=2, default=0, max_digits=5, verbose_name='japanese_style_room1')),
                ('japanese_style_room2', models.DecimalField(db_column='japanese_style_room2', decimal_places=2, default=0, max_digits=5, verbose_name='japanese_style_room2')),
                ('japanese_style_room3', models.DecimalField(db_column='japanese_style_room3', decimal_places=2, default=0, max_digits=5, verbose_name='japanese_style_room3')),
                ('japanese_style_room4', models.DecimalField(db_column='japanese_style_room4', decimal_places=2, default=0, max_digits=5, verbose_name='japanese_style_room4')),
                ('japanese_style_room5', models.DecimalField(db_column='japanese_style_room5', decimal_places=2, default=0, max_digits=5, verbose_name='japanese_style_room5')),
                ('japanese_style_room6', models.DecimalField(db_column='japanese_style_room6', decimal_places=2, default=0, max_digits=5, verbose_name='japanese_style_room6')),
                ('japanese_style_room7', models.DecimalField(db_column='japanese_style_room7', decimal_places=2, default=0, max_digits=5, verbose_name='japanese_style_room7')),
                ('japanese_style_room8', models.DecimalField(db_column='japanese_style_room8', decimal_places=2, default=0, max_digits=5, verbose_name='japanese_style_room8')),
                ('japanese_style_room9', models.DecimalField(db_column='japanese_style_room9', decimal_places=2, default=0, max_digits=5, verbose_name='japanese_style_room9')),
                ('japanese_style_room10', models.DecimalField(db_column='japanese_style_room10', decimal_places=2, default=0, max_digits=5, verbose_name='japanese_style_room10')),
                ('kitchen_type_id1', models.IntegerField(db_column='kitchen_type_id1', default=0, verbose_name='kitchen_type_id1')),
                ('kitchen1', models.DecimalField(db_column='kitchen1', decimal_places=2, default=0, max_digits=5, verbose_name='kitchen1')),
                ('kitchen_type_id2', models.IntegerField(db_column='kitchen_type_id2', default=0, verbose_name='kitchen_type_id2')),
                ('kitchen2', models.DecimalField(db_column='kitchen2', decimal_places=2, default=0, max_digits=5, verbose_name='kitchen2')),
                ('kitchen_type_id3', models.IntegerField(db_column='kitchen_type_id3', default=0, verbose_name='kitchen_type_id3')),
                ('kitchen3', models.DecimalField(db_column='kitchen3', decimal_places=2, default=0, max_digits=5, verbose_name='kitchen3')),
                ('store_room1', models.DecimalField(db_column='store_room1', decimal_places=2, default=0, max_digits=5, verbose_name='store_room1')),
                ('store_room2', models.DecimalField(db_column='store_room2', decimal_places=2, default=0, max_digits=5, verbose_name='store_room2')),
                ('store_room3', models.DecimalField(db_column='store_room3', decimal_places=2, default=0, max_digits=5, verbose_name='store_room3')),
                ('loft1', models.DecimalField(db_column='loft1', decimal_places=2, default=0, max_digits=5, verbose_name='loft1')),
                ('loft2', models.DecimalField(db_column='loft2', decimal_places=2, default=0, max_digits=5, verbose_name='loft2')),
                ('sun_room1', models.DecimalField(db_column='sun_room1', decimal_places=2, default=0, max_digits=5, verbose_name='sun_room1')),
                ('sun_room2', models.DecimalField(db_column='sun_room2', decimal_places=2, default=0, max_digits=5, verbose_name='sun_room2')),
                ('layout_note', models.CharField(blank=True, db_column='layout_note', max_length=255, null=True, verbose_name='layout_note')),
                ('room_area', models.DecimalField(db_column='room_area', decimal_places=2, default=0, max_digits=5, verbose_name='room_area')),
                ('direction_id', models.IntegerField(db_column='direction_id', db_index=True, default=0, verbose_name='direction_id')),
                ('balcony_type_id', models.IntegerField(db_column='balcony_type_id', default=0, verbose_name='balcony_type_id')),
                ('balcony_area', models.DecimalField(db_column='balcony_area', decimal_places=2, default=0, max_digits=5, verbose_name='balcony_area')),
                ('rent', models.IntegerField(db_column='rent', db_index=True, default=0, verbose_name='rent')),
                ('rent_upper', models.IntegerField(db_column='rent_upper', db_index=True, default=0, verbose_name='rent_upper')),
                ('trader_rent', models.IntegerField(db_column='trader_rent', db_index=True, default=0, verbose_name='trader_rent')),
                ('rent_tax_type_id', models.IntegerField(db_column='rent_tax_type_id', default=0, verbose_name='rent_tax_type_id')),
                ('rent_hidden', models.BooleanField(db_column='rent_hidden', default=False, verbose_name='rent_hidden')),
                ('condo_fees_type_id', models.IntegerField(db_column='condo_fees_type_id', default=0, verbose_name='condo_fees_type_id')),
                ('condo_fees', models.IntegerField(db_column='condo_fees', default=0, verbose_name='condo_fees')),
                ('condo_fees_tax_type_id', models.IntegerField(db_column='condo_fees_tax_type_id', default=0, verbose_name='condo_fees_tax_type_id')),
                ('water_cost_type_id', models.IntegerField(db_column='water_cost_type_id', default=0, verbose_name='water_cost_type_id')),
                ('water_cost', models.IntegerField(db_column='water_cost', default=0, verbose_name='water_cost')),
                ('water_cost_tax_type_id', models.IntegerField(db_column='water_cost_tax_type_id', default=0, verbose_name='water_cost_tax_type_id')),
                ('water_check_type_id', models.IntegerField(db_column='water_check_type_id', default=0, verbose_name='water_check_type_id')),
                ('payment_type_id', models.IntegerField(db_column='payment_type_id', default=0, verbose_name='payment_type_id')),
                ('payment_fee_type_id', models.IntegerField(db_column='payment_fee_type_id', default=0, verbose_name='payment_fee_type_id')),
                ('payment_fee', models.IntegerField(db_column='payment_fee', default=0, verbose_name='payment_fee')),
                ('payment_fee_tax_type_id', models.IntegerField(db_column='payment_fee_tax_type_id', default=0, verbose_name='payment_fee_tax_type_id')),
                ('monthly_cost_name1', models.CharField(blank=True, db_column='monthly_cost_name1', max_length=100, null=True, verbose_name='monthly_cost_name1')),
                ('monthly_cost1', models.IntegerField(db_column='monthly_cost1', default=0, verbose_name='monthly_cost1')),
                ('monthly_cost_tax_type_id1', models.IntegerField(db_column='monthly_cost_tax_type_id1', default=0, verbose_name='monthly_cost_tax_type_id1')),
                ('monthly_cost_name2', models.CharField(blank=True, db_column='monthly_cost_name2', max_length=100, null=True, verbose_name='monthly_cost_name2')),
                ('monthly_cost2', models.IntegerField(db_column='monthly_cost2', default=0, verbose_name='monthly_cost2')),
                ('monthly_cost_tax_type_id2', models.IntegerField(db_column='monthly_cost_tax_type_id2', default=0, verbose_name='monthly_cost_tax_type_id2')),
                ('monthly_cost_name3', models.CharField(blank=True, db_column='monthly_cost_name3', max_length=100, null=True, verbose_name='monthly_cost_name3')),
                ('monthly_cost3', models.IntegerField(db_column='monthly_cost3', default=0, verbose_name='monthly_cost3')),
                ('monthly_cost_tax_type_id3', models.IntegerField(db_column='monthly_cost_tax_type_id3', default=0, verbose_name='monthly_cost_tax_type_id3')),
                ('monthly_cost_name4', models.CharField(blank=True, db_column='monthly_cost_name4', max_length=100, null=True, verbose_name='monthly_cost_name4')),
                ('monthly_cost4', models.IntegerField(db_column='monthly_cost4', default=0, verbose_name='monthly_cost4')),
                ('monthly_cost_tax_type_id4', models.IntegerField(db_column='monthly_cost_tax_type_id4', default=0, verbose_name='monthly_cost_tax_type_id4')),
                ('monthly_cost_name5', models.CharField(blank=True, db_column='monthly_cost_name5', max_length=100, null=True, verbose_name='monthly_cost_name5')),
                ('monthly_cost5', models.IntegerField(db_column='monthly_cost5', default=0, verbose_name='monthly_cost5')),
                ('monthly_cost_tax_type_id5', models.IntegerField(db_column='monthly_cost_tax_type_id5', default=0, verbose_name='monthly_cost_tax_type_id5')),
                ('monthly_cost_name6', models.CharField(blank=True, db_column='monthly_cost_name6', max_length=100, null=True, verbose_name='monthly_cost_name6')),
                ('monthly_cost6', models.IntegerField(db_column='monthly_cost6', default=0, verbose_name='monthly_cost6')),
                ('monthly_cost_tax_type_id6', models.IntegerField(db_column='monthly_cost_tax_type_id6', default=0, verbose_name='monthly_cost_tax_type_id6')),
                ('monthly_cost_name7', models.CharField(blank=True, db_column='monthly_cost_name7', max_length=100, null=True, verbose_name='monthly_cost_name7')),
                ('monthly_cost7', models.IntegerField(db_column='monthly_cost7', default=0, verbose_name='monthly_cost7')),
                ('monthly_cost_tax_type_id7', models.IntegerField(db_column='monthly_cost_tax_type_id7', default=0, verbose_name='monthly_cost_tax_type_id7')),
                ('monthly_cost_name8', models.CharField(blank=True, db_column='monthly_cost_name8', max_length=100, null=True, verbose_name='monthly_cost_name8')),
                ('monthly_cost8', models.IntegerField(db_column='monthly_cost8', default=0, verbose_name='monthly_cost8')),
                ('monthly_cost_tax_type_id8', models.IntegerField(db_column='monthly_cost_tax_type_id8', default=0, verbose_name='monthly_cost_tax_type_id8')),
                ('monthly_cost_name9', models.CharField(blank=True, db_column='monthly_cost_name9', max_length=100, null=True, verbose_name='monthly_cost_name9')),
                ('monthly_cost9', models.IntegerField(db_column='monthly_cost9', default=0, verbose_name='monthly_cost9')),
                ('monthly_cost_tax_type_id9', models.IntegerField(db_column='monthly_cost_tax_type_id9', default=0, verbose_name='monthly_cost_tax_type_id9')),
                ('monthly_cost_name10', models.CharField(blank=True, db_column='monthly_cost_name10', max_length=100, null=True, verbose_name='monthly_cost_name10')),
                ('monthly_cost10', models.IntegerField(db_column='monthly_cost10', default=0, verbose_name='monthly_cost10')),
                ('monthly_cost_tax_type_id10', models.IntegerField(db_column='monthly_cost_tax_type_id10', default=0, verbose_name='monthly_cost_tax_type_id10')),
                ('monthly_cost_note', models.TextField(blank=True, db_column='monthly_cost_note', max_length=2000, null=True, verbose_name='monthly_cost_note')),
                ('deposit_type_id1', models.IntegerField(db_column='deposit_type_id1', default=0, verbose_name='deposit_type_id1')),
                ('deposit_notation_id1', models.IntegerField(db_column='deposit_notation_id1', default=0, verbose_name='deposit_notation_id1')),
                ('deposit_value1', models.DecimalField(db_column='deposit_value1', decimal_places=2, default=0, max_digits=12, verbose_name='deposit_value1')),
                ('deposit_tax_type_id1', models.IntegerField(db_column='deposit_tax_type_id1', default=0, verbose_name='deposit_tax_type_id1')),
                ('deposit_comment1', models.CharField(blank=True, db_column='deposit_comment1', max_length=100, null=True, verbose_name='deposit_comment1')),
                ('deposit_type_id2', models.IntegerField(db_column='deposit_type_id2', default=0, verbose_name='deposit_type_id2')),
                ('deposit_notation_id2', models.IntegerField(db_column='deposit_notation_id2', default=0, verbose_name='deposit_notation_id2')),
                ('deposit_value2', models.DecimalField(db_column='deposit_value2', decimal_places=2, default=0, max_digits=12, verbose_name='deposit_value2')),
                ('deposit_tax_type_id2', models.IntegerField(db_column='deposit_tax_type_id2', default=0, verbose_name='deposit_tax_type_id2')),
                ('deposit_comment2', models.CharField(blank=True, db_column='deposit_comment2', max_length=100, null=True, verbose_name='deposit_comment2')),
                ('key_money_type_id1', models.IntegerField(db_column='key_money_type_id1', default=0, verbose_name='key_money_type_id1')),
                ('key_money_notation_id1', models.IntegerField(db_column='key_money_notation_id1', default=0, verbose_name='key_money_notation_id1')),
                ('key_money_value1', models.DecimalField(db_column='key_money_value1', decimal_places=2, default=0, max_digits=12, verbose_name='key_money_value1')),
                ('key_money_tax_type_id1', models.IntegerField(db_column='key_money_tax_type_id1', default=0, verbose_name='key_money_tax_type_id1')),
                ('key_money_comment1', models.CharField(blank=True, db_column='key_money_comment1', max_length=100, null=True, verbose_name='key_money_comment1')),
                ('key_money_type_id2', models.IntegerField(db_column='key_money_type_id2', default=0, verbose_name='key_money_type_id2')),
                ('key_money_notation_id2', models.IntegerField(db_column='key_money_notation_id2', default=0, verbose_name='key_money_notation_id2')),
                ('key_money_value2', models.DecimalField(db_column='key_money_value2', decimal_places=2, default=0, max_digits=12, verbose_name='key_money_value2')),
                ('key_money_tax_type_id2', models.IntegerField(db_column='key_money_tax_type_id2', default=0, verbose_name='key_money_tax_type_id2')),
                ('key_money_comment2', models.CharField(blank=True, db_column='key_money_comment2', max_length=100, null=True, verbose_name='key_money_comment2')),
                ('contract_years', models.IntegerField(db_column='contract_years', default=0, verbose_name='contract_years')),
                ('contract_months', models.IntegerField(db_column='contract_months', default=0, verbose_name='contract_months')),
                ('renewal_fee_notation_id', models.IntegerField(db_column='renewal_fee_notation_id', default=0, verbose_name='renewal_fee_notation_id')),
                ('renewal_fee_value', models.DecimalField(db_column='renewal_fee_value', decimal_places=2, default=0, max_digits=12, verbose_name='renewal_fee_value')),
                ('renewal_fee_tax_type_id', models.IntegerField(db_column='renewal_fee_tax_type_id', default=0, verbose_name='renewal_fee_tax_type_id')),
                ('renewal_charge_existence_id', models.IntegerField(db_column='renewal_charge_existence_id', default=0, verbose_name='renewal_charge_existence_id')),
                ('renewal_charge', models.IntegerField(db_column='renewal_charge', default=0, verbose_name='renewal_charge')),
                ('renewal_charge_tax_type_id', models.IntegerField(db_column='renewal_charge_tax_type_id', default=0, verbose_name='renewal_charge_tax_type_id')),
                ('is_auto_renewal', models.BooleanField(db_column='is_auto_renewal', default=False, verbose_name='is_auto_renewal')),
                ('renewal_note', models.CharField(blank=True, db_column='renewal_note', max_length=255, null=True, verbose_name='renewal_note')),
                ('recontract_fee_existence_id', models.IntegerField(db_column='recontract_fee_existence_id', default=0, verbose_name='recontract_fee_existence_id')),
                ('recontract_fee', models.IntegerField(db_column='recontract_fee', default=0, verbose_name='recontract_fee')),
                ('recontract_fee_tax_type_id', models.IntegerField(db_column='recontract_fee_tax_type_id', default=0, verbose_name='recontract_fee_tax_type_id')),
                ('recontract_note', models.CharField(blank=True, db_column='recontract_note', max_length=255, null=True, verbose_name='recontract_note')),
                ('insurance_type_id', models.IntegerField(db_column='insurance_type_id', default=0, verbose_name='insurance_type_id')),
                ('insurance_company', models.CharField(blank=True, db_column='insurance_company', max_length=100, null=True, verbose_name='insurance_company')),
                ('insurance_years', models.IntegerField(db_column='insurance_years', default=0, verbose_name='insurance_years')),
                ('insurance_fee', models.IntegerField(db_column='insurance_fee', default=0, verbose_name='insurance_fee')),
                ('insurance_fee_tax_type_id', models.IntegerField(db_column='insurance_fee_tax_type_id', default=0, verbose_name='insurance_fee_tax_type_id')),
                ('guarantee_type_id', models.IntegerField(db_column='guarantee_type_id', default=0, verbose_name='guarantee_type_id')),
                ('guarantee_company', models.CharField(blank=True, db_column='guarantee_company', max_length=100, null=True, verbose_name='guarantee_company')),
                ('guarantee_fee', models.CharField(blank=True, db_column='guarantee_fee', max_length=255, null=True, verbose_name='guarantee_fee')),
                ('document_cost_existence_id', models.IntegerField(db_column='document_cost_existence_id', default=0, verbose_name='document_cost_existence_id')),
                ('document_cost', models.IntegerField(db_column='document_cost', default=0, verbose_name='document_cost')),
                ('document_cost_tax_type_id', models.IntegerField(db_column='document_cost_tax_type_id', default=0, verbose_name='document_cost_tax_type_id')),
                ('document_cost_comment', models.CharField(blank=True, db_column='document_cost_comment', max_length=100, null=True, verbose_name='document_cost_comment')),
                ('key_change_cost_existence_id', models.IntegerField(db_column='key_change_cost_existence_id', default=0, verbose_name='key_change_cost_existence_id')),
                ('key_change_cost', models.IntegerField(db_column='key_change_cost', default=0, verbose_name='key_change_cost')),
                ('key_change_cost_tax_type_id', models.IntegerField(db_column='key_change_cost_tax_type_id', default=0, verbose_name='key_change_cost_tax_type_id')),
                ('key_change_comment', models.CharField(blank=True, db_column='key_change_comment', max_length=100, null=True, verbose_name='key_change_comment')),
                ('initial_cost_name1', models.CharField(blank=True, db_column='initial_cost_name1', max_length=100, null=True, verbose_name='initial_cost_name1')),
                ('initial_cost1', models.IntegerField(db_column='initial_cost1', default=0, verbose_name='initial_cost1')),
                ('initial_cost_tax_type_id1', models.IntegerField(db_column='initial_cost_tax_type_id1', default=0, verbose_name='initial_cost_tax_type_id1')),
                ('initial_cost_name2', models.CharField(blank=True, db_column='initial_cost_name2', max_length=100, null=True, verbose_name='initial_cost_name2')),
                ('initial_cost2', models.IntegerField(db_column='initial_cost2', default=0, verbose_name='initial_cost2')),
                ('initial_cost_tax_type_id2', models.IntegerField(db_column='initial_cost_tax_type_id2', default=0, verbose_name='initial_cost_tax_type_id2')),
                ('initial_cost_name3', models.CharField(blank=True, db_column='initial_cost_name3', max_length=100, null=True, verbose_name='initial_cost_name3')),
                ('initial_cost3', models.IntegerField(db_column='initial_cost3', default=0, verbose_name='initial_cost3')),
                ('initial_cost_tax_type_id3', models.IntegerField(db_column='initial_cost_tax_type_id3', default=0, verbose_name='initial_cost_tax_type_id3')),
                ('initial_cost_name4', models.CharField(blank=True, db_column='initial_cost_name4', max_length=100, null=True, verbose_name='initial_cost_name4')),
                ('initial_cost4', models.IntegerField(db_column='initial_cost4', default=0, verbose_name='initial_cost4')),
                ('initial_cost_tax_type_id4', models.IntegerField(db_column='initial_cost_tax_type_id4', default=0, verbose_name='initial_cost_tax_type_id4')),
                ('initial_cost_name5', models.CharField(blank=True, db_column='initial_cost_name5', max_length=100, null=True, verbose_name='initial_cost_name5')),
                ('initial_cost5', models.IntegerField(db_column='initial_cost5', default=0, verbose_name='initial_cost5')),
                ('initial_cost_tax_type_id5', models.IntegerField(db_column='initial_cost_tax_type_id5', default=0, verbose_name='initial_cost_tax_type_id5')),
                ('initial_cost_name6', models.CharField(blank=True, db_column='initial_cost_name6', max_length=100, null=True, verbose_name='initial_cost_name6')),
                ('initial_cost6', models.IntegerField(db_column='initial_cost6', default=0, verbose_name='initial_cost6')),
                ('initial_cost_tax_type_id6', models.IntegerField(db_column='initial_cost_tax_type_id6', default=0, verbose_name='initial_cost_tax_type_id6')),
                ('initial_cost_name7', models.CharField(blank=True, db_column='initial_cost_name7', max_length=100, null=True, verbose_name='initial_cost_name7')),
                ('initial_cost7', models.IntegerField(db_column='initial_cost7', default=0, verbose_name='initial_cost7')),
                ('initial_cost_tax_type_id7', models.IntegerField(db_column='initial_cost_tax_type_id7', default=0, verbose_name='initial_cost_tax_type_id7')),
                ('initial_cost_name8', models.CharField(blank=True, db_column='initial_cost_name8', max_length=100, null=True, verbose_name='initial_cost_name8')),
                ('initial_cost8', models.IntegerField(db_column='initial_cost8', default=0, verbose_name='initial_cost8')),
                ('initial_cost_tax_type_id8', models.IntegerField(db_column='initial_cost_tax_type_id8', default=0, verbose_name='initial_cost_tax_type_id8')),
                ('initial_cost_name9', models.CharField(blank=True, db_column='initial_cost_name9', max_length=100, null=True, verbose_name='initial_cost_name9')),
                ('initial_cost9', models.IntegerField(db_column='initial_cost9', default=0, verbose_name='initial_cost9')),
                ('initial_cost_tax_type_id9', models.IntegerField(db_column='initial_cost_tax_type_id9', default=0, verbose_name='initial_cost_tax_type_id9')),
                ('initial_cost_name10', models.CharField(blank=True, db_column='initial_cost_name10', max_length=100, null=True, verbose_name='initial_cost_name10')),
                ('initial_cost10', models.IntegerField(db_column='initial_cost10', default=0, verbose_name='initial_cost10')),
                ('initial_cost_tax_type_id10', models.IntegerField(db_column='initial_cost_tax_type_id10', default=0, verbose_name='initial_cost_tax_type_id10')),
                ('initial_cost_note', models.TextField(blank=True, db_column='initial_cost_note', max_length=2000, null=True, verbose_name='initial_cost_note')),
                ('free_rent_type_id', models.IntegerField(db_column='free_rent_type_id', default=0, verbose_name='free_rent_type_id')),
                ('free_rent_months', models.IntegerField(db_column='free_rent_months', default=0, verbose_name='free_rent_months')),
                ('free_rent_limit_year', models.IntegerField(db_column='free_rent_limit_year', default=0, verbose_name='free_rent_limit_year')),
                ('free_rent_limit_month', models.IntegerField(db_column='free_rent_limit_month', default=0, verbose_name='free_rent_limit_month')),
                ('cancel_notice_limit', models.IntegerField(db_column='cancel_notice_limit', default=0, verbose_name='cancel_notice_limit')),
                ('cancel_note', models.CharField(blank=True, db_column='cancel_note', max_length=255, null=True, verbose_name='cancel_note')),
                ('short_cancel_note', models.CharField(blank=True, db_column='short_cancel_note', max_length=255, null=True, verbose_name='short_cancel_note')),
                ('cleaning_type_id', models.IntegerField(db_column='cleaning_type_id', default=0, verbose_name='cleaning_type_id')),
                ('cleaning_cost', models.IntegerField(db_column='cleaning_cost', default=0, verbose_name='cleaning_cost')),
                ('cleaning_cost_tax_type_id', models.IntegerField(db_column='cleaning_cost_tax_type_id', default=0, verbose_name='cleaning_cost_tax_type_id')),
                ('cleaning_note', models.CharField(blank=True, db_column='cleaning_note', max_length=255, null=True, verbose_name='cleaning_note')),
                ('special_agreement', models.TextField(blank=True, db_column='special_agreement', max_length=2000, null=True, verbose_name='special_agreement')),
                ('electric_type_id', models.IntegerField(db_column='electric_type_id', default=0, verbose_name='electric_type_id')),
                ('electric_comment', models.CharField(blank=True, db_column='electric_comment', max_length=100, null=True, verbose_name='electric_comment')),
                ('gas_type_id', models.IntegerField(db_column='gas_type_id', default=0, verbose_name='gas_type_id')),
                ('gas_comment', models.CharField(blank=True, db_column='gas_comment', max_length=100, null=True, verbose_name='gas_comment')),
                ('bath_type_id', models.IntegerField(db_column='bath_type_id', default=0, verbose_name='bath_type_id')),
                ('bath_comment', models.CharField(blank=True, db_column='bath_comment', max_length=100, null=True, verbose_name='bath_comment')),
                ('toilet_type_id', models.IntegerField(db_column='toilet_type_id', default=0, verbose_name='toilet_type_id')),
                ('toilet_comment', models.CharField(blank=True, db_column='toilet_comment', max_length=100, null=True, verbose_name='toilet_comment')),
                ('kitchen_range_type_id', models.IntegerField(db_column='kitchen_range_type_id', default=0, verbose_name='kitchen_range_type_id')),
                ('kitchen_range_comment', models.CharField(blank=True, db_column='kitchen_range_comment', max_length=100, null=True, verbose_name='kitchen_range_comment')),
                ('internet_type_id', models.IntegerField(db_column='internet_type_id', default=0, verbose_name='internet_type_id')),
                ('internet_comment', models.CharField(blank=True, db_column='internet_comment', max_length=100, null=True, verbose_name='internet_comment')),
                ('washer_type_id', models.IntegerField(db_column='washer_type_id', default=0, verbose_name='washer_type_id')),
                ('washer_comment', models.CharField(blank=True, db_column='washer_comment', max_length=100, null=True, verbose_name='washer_comment')),
                ('pet_type_id', models.IntegerField(db_column='pet_type_id', default=0, verbose_name='pet_type_id')),
                ('pet_comment', models.CharField(blank=True, db_column='pet_comment', max_length=100, null=True, verbose_name='pet_comment')),
                ('instrument_type_id', models.IntegerField(db_column='instrument_type_id', default=0, verbose_name='instrument_type_id')),
                ('live_together_type_id', models.IntegerField(db_column='live_together_type_id', default=0, verbose_name='live_together_type_id')),
                ('children_type_id', models.IntegerField(db_column='children_type_id', default=0, verbose_name='children_type_id')),
                ('share_type_id', models.IntegerField(db_column='share_type_id', default=0, verbose_name='share_type_id')),
                ('non_japanese_type_id', models.IntegerField(db_column='non_japanese_type_id', default=0, verbose_name='non_japanese_type_id')),
                ('only_woman_type_id', models.IntegerField(db_column='only_woman_type_id', default=0, verbose_name='only_woman_type_id')),
                ('only_man_type_id', models.IntegerField(db_column='only_man_type_id', default=0, verbose_name='only_man_type_id')),
                ('corp_contract_type_id', models.IntegerField(db_column='corp_contract_type_id', default=0, verbose_name='corp_contract_type_id')),
                ('student_type_id', models.IntegerField(db_column='student_type_id', default=0, verbose_name='student_type_id')),
                ('new_student_type_id', models.IntegerField(db_column='new_student_type_id', default=0, verbose_name='new_student_type_id')),
                ('welfare_type_id', models.IntegerField(db_column='welfare_type_id', default=0, verbose_name='welfare_type_id')),
                ('office_use_type_id', models.IntegerField(db_column='office_use_type_id', default=0, verbose_name='office_use_type_id')),
                ('constraint_note', models.CharField(blank=True, db_column='constraint_note', max_length=255, null=True, verbose_name='constraint_note')),
                ('reform_comment', models.CharField(blank=True, db_column='reform_comment', max_length=100, null=True, verbose_name='reform_comment')),
                ('reform_year', models.IntegerField(db_column='reform_year', default=0, verbose_name='reform_year')),
                ('reform_month', models.IntegerField(db_column='reform_month', default=0, verbose_name='reform_month')),
                ('reform_note', models.CharField(blank=True, db_column='reform_note', max_length=255, null=True, verbose_name='reform_note')),
                ('trader_publish_type_id', models.IntegerField(db_column='trader_publish_type_id', default=0, verbose_name='trader_publish_type_id')),
                ('trader_publish_note', models.CharField(blank=True, db_column='trader_publish_note', max_length=255, null=True, verbose_name='trader_publish_note')),
                ('trader_portal_type_id', models.IntegerField(db_column='trader_portal_type_id', default=0, verbose_name='trader_portal_type_id')),
                ('trader_portal_note', models.CharField(blank=True, db_column='trader_portal_note', max_length=255, null=True, verbose_name='trader_portal_note')),
                ('ad_type_id', models.IntegerField(db_column='ad_type_id', default=0, verbose_name='ad_type_id')),
                ('ad_value', models.DecimalField(db_column='ad_value', decimal_places=2, default=0, max_digits=12, verbose_name='ad_value')),
                ('ad_tax_type_id', models.IntegerField(db_column='ad_tax_type_id', default=0, verbose_name='ad_tax_type_id')),
                ('trader_ad_type_id', models.IntegerField(db_column='trader_ad_type_id', default=0, verbose_name='trader_ad_type_id')),
                ('trader_ad_value', models.DecimalField(db_column='trader_ad_value', decimal_places=2, default=0, max_digits=12, verbose_name='trader_ad_value')),
                ('trader_ad_tax_type_id', models.IntegerField(db_column='trader_ad_tax_type_id', default=0, verbose_name='trader_ad_tax_type_id')),
                ('owner_fee_type_id', models.IntegerField(db_column='owner_fee_type_id', default=0, verbose_name='owner_fee_type_id')),
                ('key_no', models.CharField(blank=True, db_column='key_no', max_length=50, null=True, verbose_name='key_no')),
                ('key_place_note', models.CharField(blank=True, db_column='key_place_note', max_length=255, null=True, verbose_name='key_place_note')),
                ('private_note', models.TextField(blank=True, db_column='private_note', max_length=2000, null=True, verbose_name='private_note')),
                ('management_note', models.TextField(blank=True, db_column='management_note', max_length=2000, null=True, verbose_name='management_note')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'room',
                'verbose_name_plural': 'rooms',
                'db_table': 'room',
                'ordering': ['building_id', 'room_no', 'id'],
            },
        ),
        migrations.CreateModel(
            name='RoomAuthLevel',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('level', models.IntegerField(db_column='level', db_index=True, default=0, verbose_name='level')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'room_auth_levels',
                'verbose_name_plural': 'room_auth_levels',
                'db_table': 'room_auth_level',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='RoomEquipment',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('room_id', models.IntegerField(db_column='room_id', db_index=True, default=0, verbose_name='room_id')),
                ('equipment_id', models.IntegerField(db_column='equipment_id', db_index=True, default=0, verbose_name='equipment_id')),
                ('is_remained', models.BooleanField(db_column='is_remained', default=False, verbose_name='is_remained')),
                ('note', models.TextField(blank=True, db_column='note', max_length=2000, null=True, verbose_name='note')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'room_equipment',
                'verbose_name_plural': 'room_equipments',
                'db_table': 'room_equipment',
                'ordering': ['building_id', 'room_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='RoomMovie',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('room_id', models.IntegerField(db_column='room_id', db_index=True, default=0, verbose_name='room_id')),
                ('file_name', models.CharField(db_column='file_name', max_length=255, verbose_name='file_name')),
                ('cache_name', models.CharField(db_column='cache_name', max_length=255, verbose_name='cache_name')),
                ('movie_type_id', models.IntegerField(db_column='movie_type_id', db_index=True, default=0, verbose_name='movie_type_id')),
                ('is_publish_web', models.BooleanField(db_column='is_publish_web', db_index=True, default=True, verbose_name='is_publish_web')),
                ('is_publish_vacancy', models.BooleanField(db_column='is_publish_vacancy', db_index=True, default=True, verbose_name='is_publish_vacancy')),
                ('comment', models.CharField(blank=True, db_column='comment', max_length=50, null=True, verbose_name='comment')),
                ('note', models.CharField(blank=True, db_column='note', max_length=255, null=True, verbose_name='note')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'room_movie',
                'verbose_name_plural': 'room_movies',
                'db_table': 'room_movie',
                'ordering': ['building_id', 'room_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='RoomPanorama',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('room_id', models.IntegerField(db_column='room_id', db_index=True, default=0, verbose_name='room_id')),
                ('file_name', models.CharField(db_column='file_name', max_length=255, verbose_name='file_name')),
                ('cache_name', models.CharField(db_column='cache_name', max_length=255, verbose_name='cache_name')),
                ('panorama_type_id', models.IntegerField(db_column='panorama_type_id', db_index=True, default=0, verbose_name='panorama_type_id')),
                ('is_publish_web', models.BooleanField(db_column='is_publish_web', db_index=True, default=True, verbose_name='is_publish_web')),
                ('is_publish_vacancy', models.BooleanField(db_column='is_publish_vacancy', db_index=True, default=True, verbose_name='is_publish_vacancy')),
                ('comment', models.CharField(blank=True, db_column='comment', max_length=50, null=True, verbose_name='comment')),
                ('note', models.CharField(blank=True, db_column='note', max_length=255, null=True, verbose_name='note')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'room_panorama',
                'verbose_name_plural': 'room_panoramas',
                'db_table': 'room_panorama',
                'ordering': ['building_id', 'room_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='RoomPicture',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('room_id', models.IntegerField(db_column='room_id', db_index=True, default=0, verbose_name='room_id')),
                ('file_name', models.CharField(db_column='file_name', max_length=255, verbose_name='file_name')),
                ('cache_name_thumb', models.CharField(db_column='cache_name_thumb', max_length=255, verbose_name='cache_name_thumb')),
                ('cache_name_s', models.CharField(db_column='cache_name_s', max_length=255, verbose_name='cache_name_s')),
                ('cache_name_m', models.CharField(db_column='cache_name_m', max_length=255, verbose_name='cache_name_m')),
                ('cache_name_l', models.CharField(db_column='cache_name_l', max_length=255, verbose_name='cache_name_l')),
                ('cache_name_org', models.CharField(db_column='cache_name_org', max_length=255, verbose_name='cache_name_org')),
                ('picture_type_id', models.IntegerField(db_column='picture_type_id', db_index=True, default=0, verbose_name='picture_type_id')),
                ('is_publish_web', models.BooleanField(db_column='is_publish_web', db_index=True, default=True, verbose_name='is_publish_web')),
                ('is_publish_vacancy', models.BooleanField(db_column='is_publish_vacancy', db_index=True, default=True, verbose_name='is_publish_vacancy')),
                ('comment', models.CharField(blank=True, db_column='comment', max_length=50, null=True, verbose_name='comment')),
                ('note', models.CharField(blank=True, db_column='note', max_length=255, null=True, verbose_name='note')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'room_picture',
                'verbose_name_plural': 'room_pictures',
                'db_table': 'room_picture',
                'ordering': ['building_id', 'room_id', 'priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='RoomStatus',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('for_rent', models.BooleanField(db_column='for_rent', default=False, verbose_name='for_rent')),
                ('is_pending', models.BooleanField(db_column='is_pending', default=False, verbose_name='is_pending')),
                ('will_be_canceled', models.BooleanField(db_column='will_be_canceled', default=False, verbose_name='will_be_canceled')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'room_status',
                'verbose_name_plural': 'room_statuses',
                'db_table': 'room_status',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='RoomStatusLog',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('room_id', models.IntegerField(db_column='room_id', db_index=True, default=0, verbose_name='room_id')),
                ('room_status_id', models.IntegerField(db_column='room_status_id', db_index=True, default=0, verbose_name='room_status_id')),
                ('last_room_status_id', models.IntegerField(db_column='last_room_status_id', db_index=True, default=0, verbose_name='last_room_status_id')),
                ('created_at', models.DateTimeField(db_column='created_at', db_index=True, default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
            ],
            options={
                'verbose_name': 'room_status_log',
                'verbose_name_plural': 'room_status_logs',
                'db_table': 'room_status_log',
                'ordering': ['building_id', 'room_id', 'created_at', 'id'],
            },
        ),
        migrations.CreateModel(
            name='RoomVacancyTheme',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('building_id', models.IntegerField(db_column='building_id', db_index=True, default=0, verbose_name='building_id')),
                ('room_id', models.IntegerField(db_column='room_id', db_index=True, default=0, verbose_name='room_id')),
                ('vacancy_theme_id', models.IntegerField(db_column='vacancy_theme_id', db_index=True, default=0, verbose_name='vacancy_theme_id')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'room_vacancy_theme',
                'verbose_name_plural': 'room_vacancy_themes',
                'db_table': 'room_vacancy_theme',
                'ordering': ['building_id', 'room_id', 'vacancy_theme_id', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Staff',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('department_id', models.IntegerField(db_column='department_id', db_index=True, default=0, verbose_name='department_id')),
                ('first_name', models.CharField(blank=True, db_column='first_name', max_length=50, null=True, verbose_name='first_name')),
                ('last_name', models.CharField(blank=True, db_column='last_name', max_length=50, null=True, verbose_name='last_name')),
                ('post_name', models.CharField(blank=True, db_column='post_name', max_length=50, null=True, verbose_name='post_name')),
                ('vacancy_name', models.CharField(blank=True, db_column='vacancy_name', max_length=100, null=True, verbose_name='vacancy_name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('tel1', models.CharField(blank=True, db_column='tel1', max_length=20, null=True, verbose_name='tel1')),
                ('tel2', models.CharField(blank=True, db_column='tel2', max_length=20, null=True, verbose_name='tel2')),
                ('mail', models.EmailField(blank=True, db_column='mail', max_length=254, null=True, verbose_name='mail')),
                ('is_pm_staff', models.BooleanField(db_column='is_pm_staff', db_index=True, default=True, verbose_name='is_pm_staff')),
                ('is_publish_vacancy', models.BooleanField(db_column='is_publish_vacancy', db_index=True, default=True, verbose_name='is_publish_vacancy')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'staff',
                'verbose_name_plural': 'staffs',
                'db_table': 'staff',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Station',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('railway_id', models.IntegerField(db_column='railway_id', db_index=True, default=0, verbose_name='railway_id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_trading', models.BooleanField(db_column='is_trading', db_index=True, default=False, verbose_name='is_trading')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'station',
                'verbose_name_plural': 'stations',
                'db_table': 'station',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Structure',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('short_name', models.CharField(blank=True, db_column='short_name', max_length=50, null=True, verbose_name='short_name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'structure',
                'verbose_name_plural': 'structures',
                'db_table': 'structure',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='TaxType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'tax_type',
                'verbose_name_plural': 'tax_types',
                'db_table': 'tax_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='ToiletType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'toilet_type',
                'verbose_name_plural': 'toilet_types',
                'db_table': 'toilet_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Trader',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('trader_group_id', models.IntegerField(db_column='trader_group_id', db_index=True, default=0, verbose_name='trader_group_id')),
                ('trader_name', models.CharField(db_column='trader_name', db_index=True, max_length=255, verbose_name='trader_name')),
                ('trader_kana', models.CharField(blank=True, db_column='trader_kana', db_index=True, max_length=255, null=True, verbose_name='trader_kana')),
                ('postal_code', models.CharField(blank=True, db_column='postal_code', max_length=10, null=True, verbose_name='postal_code')),
                ('address', models.CharField(blank=True, db_column='address', max_length=255, null=True, verbose_name='address')),
                ('tel1', models.CharField(blank=True, db_column='tel1', max_length=20, null=True, verbose_name='tel1')),
                ('tel2', models.CharField(blank=True, db_column='tel2', max_length=20, null=True, verbose_name='tel2')),
                ('fax', models.CharField(blank=True, db_column='fax', max_length=20, null=True, verbose_name='fax')),
                ('mail', models.EmailField(blank=True, db_column='mail', max_length=254, null=True, verbose_name='mail')),
                ('no_trading', models.BooleanField(db_column='no_trading', default=False, verbose_name='no_trading')),
                ('no_portal', models.BooleanField(db_column='no_portal', default=False, verbose_name='no_portal')),
                ('note', models.TextField(blank=True, db_column='note', max_length=2000, null=True, verbose_name='note')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'trader',
                'verbose_name_plural': 'traders',
                'db_table': 'trader',
                'ordering': ['trader_kana', 'id'],
            },
        ),
        migrations.CreateModel(
            name='TraderGroup',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('trader_group_name', models.CharField(db_column='trader_group_name', db_index=True, max_length=255, verbose_name='trader_group_name')),
                ('trader_group_kana', models.CharField(blank=True, db_column='trader_group_kana', db_index=True, max_length=255, null=True, verbose_name='trader_group_kana')),
                ('note', models.TextField(blank=True, db_column='note', max_length=2000, null=True, verbose_name='note')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('created_user_id', models.IntegerField(db_column='created_user_id', db_index=True, default=0, verbose_name='created_user_id')),
                ('updated_at', models.DateTimeField(db_column='updated_at', default=django.utils.timezone.now, verbose_name='updated_at')),
                ('updated_user_id', models.IntegerField(db_column='updated_user_id', db_index=True, default=0, verbose_name='updated_user_id')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
                ('is_deleted', models.BooleanField(db_column='is_deleted', db_index=True, default=False, verbose_name='is_deleted')),
            ],
            options={
                'verbose_name': 'trader_group',
                'verbose_name_plural': 'trader_groups',
                'db_table': 'trader_group',
                'ordering': ['trader_group_kana', 'id'],
            },
        ),
        migrations.CreateModel(
            name='TransferStation',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('station_id', models.IntegerField(db_column='station_id', db_index=True, default=0, verbose_name='station_id')),
                ('transfer_station_id', models.IntegerField(db_column='transfer_station_id', default=0, verbose_name='transfer_station_id')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'transfer_station',
                'verbose_name_plural': 'transfer_stations',
                'db_table': 'transfer_station',
                'ordering': ['station_id', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputBikeParking',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_bike_parking',
                'verbose_name_plural': 'vacancy_input_bike_parkings',
                'db_table': 'vacancy_input_bike_parking',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputCancelNotice',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_cancel_notice',
                'verbose_name_plural': 'vacancy_input_cancel_notices',
                'db_table': 'vacancy_input_cancel_notice',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputChangeLock',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_change_lock',
                'verbose_name_plural': 'vacancy_input_change_locks',
                'db_table': 'vacancy_input_change_lock',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputCleaning',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_cleaning',
                'verbose_name_plural': 'vacancy_input_cleanings',
                'db_table': 'vacancy_input_cleaning',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputDocumentPrice',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_document_price',
                'verbose_name_plural': 'vacancy_input_document_prices',
                'db_table': 'vacancy_input_document_price',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputElectric',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_electric',
                'verbose_name_plural': 'vacancy_input_electrics',
                'db_table': 'vacancy_input_electric',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputGarage',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_garage',
                'verbose_name_plural': 'vacancy_input_garages',
                'db_table': 'vacancy_input_garage',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputGas',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_gas',
                'verbose_name_plural': 'vacancy_input_gases',
                'db_table': 'vacancy_input_gas',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputGuarantee',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_guarantee',
                'verbose_name_plural': 'vacancy_input_guarantees',
                'db_table': 'vacancy_input_guarantee',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputGuarantorLimit',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_guarantor_limit',
                'verbose_name_plural': 'vacancy_input_guarantor_limits',
                'db_table': 'vacancy_input_guarantor_limit',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputInsurance',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_insurance',
                'verbose_name_plural': 'vacancy_input_insurances',
                'db_table': 'vacancy_input_insurance',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputInternet',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_internet',
                'verbose_name_plural': 'vacancy_input_internets',
                'db_table': 'vacancy_input_internet',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputPayment',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_payment',
                'verbose_name_plural': 'vacancy_input_payments',
                'db_table': 'vacancy_input_payment',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputPortal',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_portal',
                'verbose_name_plural': 'vacancy_input_portals',
                'db_table': 'vacancy_input_portal',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputRenewalCharge',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_renewal_charge',
                'verbose_name_plural': 'vacancy_input_renewal_charges',
                'db_table': 'vacancy_input_renewal_charge',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputShortCancel',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_short_cancel',
                'verbose_name_plural': 'vacancy_input_short_cancels',
                'db_table': 'vacancy_input_short_cancel',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyInputWater',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('input_contents', models.CharField(db_column='input_contents', max_length=255, verbose_name='input_contents')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_input_water',
                'verbose_name_plural': 'vacancy_input_waters',
                'db_table': 'vacancy_input_water',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyLevel',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('level', models.IntegerField(db_column='level', db_index=True, default=0, verbose_name='level')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_level',
                'verbose_name_plural': 'vacancy_levels',
                'db_table': 'auth_vacancy_level',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyStatus',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_status',
                'verbose_name_plural': 'vacancy_statuses',
                'db_table': 'vacancy_status',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyTheme',
            fields=[
                ('id', models.AutoField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('title', models.CharField(blank=True, db_column='title', max_length=100, null=True, verbose_name='title')),
                ('description', models.CharField(blank=True, db_column='description', max_length=255, null=True, verbose_name='description')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('room_auth_level_id', models.IntegerField(db_column='room_auth_level_id', db_index=True, default=0, verbose_name='room_auth_level_id')),
                ('is_publish', models.BooleanField(db_column='is_publish', default=False, verbose_name='is_publish')),
                ('created_at', models.DateTimeField(db_column='created_at', default=django.utils.timezone.now, verbose_name='created_at')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'vacancy_theme',
                'verbose_name_plural': 'vacancy_themes',
                'db_table': 'vacancy_theme',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='WasherType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_ok', models.BooleanField(db_column='is_ok', default=False, verbose_name='is_ok')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'washer_type',
                'verbose_name_plural': 'washer_types',
                'db_table': 'washer_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='WaterCheckType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'water_check_type',
                'verbose_name_plural': 'water_check_types',
                'db_table': 'water_check_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='WaterCostType',
            fields=[
                ('id', models.IntegerField(db_column='id', primary_key=True, serialize=False, verbose_name='id')),
                ('name', models.CharField(db_column='name', max_length=50, verbose_name='name')),
                ('priority', models.IntegerField(db_column='priority', db_index=True, default=100, verbose_name='priority')),
                ('is_stopped', models.BooleanField(db_column='is_stopped', db_index=True, default=False, verbose_name='is_stopped')),
            ],
            options={
                'verbose_name': 'water_cost_type',
                'verbose_name_plural': 'water_cost_types',
                'db_table': 'water_cost_type',
                'ordering': ['priority', 'id'],
            },
        ),
        migrations.CreateModel(
            name='VacancyUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(db_column='username', db_index=True, error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('display_name', models.CharField(blank=True, db_column='display_name', max_length=100, null=True, verbose_name='display_name')),
                ('email', models.EmailField(blank=True, db_column='email', max_length=254, null=True, verbose_name='email address')),
                ('is_staff', models.BooleanField(db_column='is_staff', default=False, verbose_name='staff status')),
                ('is_active', models.BooleanField(db_column='is_active', default=True, verbose_name='active')),
                ('is_company', models.BooleanField(db_column='is_company', default=False, verbose_name='is_company')),
                ('level_id', models.IntegerField(db_column='level_id', db_index=True, default=0, verbose_name='level_id')),
                ('allow_org_image', models.BooleanField(db_column='allow_org_image', default=False, verbose_name='allow_org_image')),
                ('trader_name', models.CharField(blank=True, db_column='trader_name', max_length=100, null=True, verbose_name='trader_name')),
                ('trader_department_name', models.CharField(blank=True, db_column='trader_department_name', max_length=100, null=True, verbose_name='trader_department_name')),
                ('trader_department_tel', models.CharField(blank=True, db_column='trader_department_tel', max_length=20, null=True, verbose_name='trader_department_tel')),
                ('trader_department_address', models.CharField(blank=True, db_column='trader_department_address', max_length=255, null=True, verbose_name='trader_department_address')),
                ('note', models.CharField(blank=True, db_column='note', max_length=255, null=True, verbose_name='note')),
                ('date_joined', models.DateTimeField(db_column='date_joined', default=django.utils.timezone.now, verbose_name='date joined')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='vacancy_user_set', related_query_name='vacancy_user', to='auth.Group', verbose_name='vacancy groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='vacancy_user_set', related_query_name='vacancy_user', to='auth.Permission', verbose_name='vacancy user permissions')),
            ],
            options={
                'verbose_name': 'vacancy_user',
                'verbose_name_plural': 'vacancy_users',
                'db_table': 'auth_vacancy_user',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(db_column='username', db_index=True, error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, db_column='first_name', max_length=30, null=True, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, db_column='last_name', max_length=150, null=True, verbose_name='last name')),
                ('staff_id', models.IntegerField(db_column='staff_id', db_index=True, default=0, verbose_name='staff_id')),
                ('email', models.EmailField(blank=True, db_column='email', max_length=254, null=True, verbose_name='email address')),
                ('is_company', models.BooleanField(db_column='is_company', default=False, verbose_name='is_company')),
                ('is_company_admin', models.BooleanField(db_column='is_company_admin', default=False, verbose_name='is_company_admin')),
                ('is_staff', models.BooleanField(db_column='is_staff', default=False, verbose_name='staff status')),
                ('is_active', models.BooleanField(db_column='is_active', default=True, verbose_name='active')),
                ('date_joined', models.DateTimeField(db_column='date_joined', default=django.utils.timezone.now, verbose_name='date joined')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'db_table': 'auth_user',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
    ]
