import sys, codecs, configparser, os

from PyQt5.QtWidgets import (QVBoxLayout, QLineEdit,QGridLayout,
 QApplication, QLabel, QMenu, QWidget, QHBoxLayout,QDialog,
 QAction, QTextEdit,QPushButton, qApp, QMessageBox, QInputDialog,
 QMainWindow, QFrame, QFileDialog, QCheckBox, QProgressBar,
 QListWidget, QCompleter, QComboBox)
from PyQt5.QtGui import (QIcon, QFont, QColor, QPixmap, QDrag, QPainter,
 QBrush, QPen,QStandardItem,QStandardItemModel)
from PyQt5.QtCore import (QCoreApplication, Qt, QObject, pyqtSignal,
 QMimeData, )


#######################################
#プロジェクトにファイルの登録
#######################################

class regist_File(QWidget):



    def __init__(self, cate,labe,fi,*args,parent=None):
        super(regist_File, self).__init__()

        self.Category=""
        self.Label=""
        #print(cate,labe)
        self.ca=cate
        self.la=labe
        self.fi=fi
        #print(self.ca,self.la,self.fi)
        self.filename=""

        if args != ():
            self.cateE=args[0]
            self.labeE=args[1]
            self.fileE=args[2]
            self.file_path=self.fileE
        else:
            self.cateE=""
            self.labeE=""
            self.fileE=""
        #print(args)

        self.regist_file(cate,labe,fi)

    def regist_file(self,cate,labe,fi):
        self.w=QDialog()
        label = QLabel()
        label.setText('プロジェクトにファイルを追加')

        file_select_button=QPushButton("ファイルの参照")
        file_select_button.clicked.connect(self.open_file)

        self.selected_file=QLineEdit()

        self.selected_file_box=QHBoxLayout()
        self.selected_file_box.addWidget(file_select_button)
        self.selected_file_box.addWidget(self.selected_file)

        self.selected_file.textChanged.connect(self.onActivated3)

#################################################################
        label_v_box=QVBoxLayout()
        label_label=QLabel()
        label_label.setText('ラベル名')
        self.auto_label_checkbox = QCheckBox("ファイル名をラベル名として使用", self)
        self.auto_label_checkbox.setToolTip("ファイル名をラベル名として使用する")
        self.auto_label_checkbox.stateChanged.connect(self.auto_label_name)
        self.label_name=QLineEdit()
        self.label_name.textChanged.connect(self.onActivated2)
        label_v_box.addWidget(label_label)
        label_v_box.addWidget(self.label_name)
        label_v_box.addWidget(self.auto_label_checkbox)

#################################################################
        category_label=QLabel()
        category_label.setText('カテゴリー名')
#################################################################
        model = QStandardItemModel( self )
        cate = set(cate)
        for elm in cate:
            item = QStandardItem( elm )
            model.setItem( model.rowCount(), 0, item )
        # Completer機能付き入力ウィジェットのベースとなるComboBoxを作成。
        self.category_name = QComboBox( self )
        # QLineEditを#ComboBoxにセット。
        self.category_name.setEditable(True)
        self.category_name.setLineEdit
        self.category_name.setModel( model )
        # 入力を初期化
        self.category_name.lineEdit().setText( '' )
        self.category_name.editTextChanged[str].connect(self.onActivated1)
#################################################################

        hbox2=QHBoxLayout()
        hbox2.addStretch(1)
        cancelB=QPushButton("キャンセル")
        cancelB.clicked.connect(self.w.close)

        regist_button=QPushButton("プロジェクトに追加")
        regist_button.clicked.connect(self.regist_file_to_project)
        hbox2.addWidget(regist_button)
        hbox2.addWidget(cancelB)

        layout=QVBoxLayout()
        layout.addWidget(label)

        layout.addLayout(self.selected_file_box)
        layout.addStretch(1)
        layout.addLayout(label_v_box)
        layout.addStretch(1)
        layout.addWidget(category_label)
        layout.addWidget(self.category_name)
        layout.addStretch(1)
        layout.addLayout(hbox2)
        self.w.setLayout(layout)

        self.w.setGeometry(650, 650, 300, 300)

        self.w.setWindowTitle("新規プロジェクトの作成")

####################################################################

        if self.fileE!="":
            self.selected_file.setText(self.fileE)

        if self.cateE!="":
            self.category_name.lineEdit().setText(self.cateE)

        if self.labeE!="":
            self.label_name.setText(self.labeE)

####################################################################

    def auto_label_name(self):
        if self.auto_label_checkbox.checkState()==2:
            if self.file_path=="":
                #print("ファイルを先に登録してください")
                message=QMessageBox.information(self,"お知らせ",  "ファイルを先に登録してください", QMessageBox.Ok)
            else:
                #file_name=self.filename.split(".")
                #file_name=file_name[0]
                filename=self.file_path.split("/")
                filename=filename[-1]
                filename=filename.split(".")
                filename=filename[0]
                self.label_name.setText(filename)
        else:
            self.label_name.setText("")

    def open_file(self):
        folder_path=os.getcwd()

        frame=QFileDialog.getOpenFileName(self, "ファイルの選択", folder_path,filter=("text files(*.txt)"))

        filepath=frame[0]
        filename=frame[0].split("/")
        filename=filename[-1]
        self.file_path=filepath
        #print(self.file_path)
        self.filename=filename

        check=0
        for n in self.fi:
            if n==filename:
                check +=1
            else:
                pass

        if check>0:
            #print("かぶってるよ")
            message=QMessageBox.information(self,"お知らせ",  "同一のファイルが選択されています", QMessageBox.Ok)
        else:
            self.selected_file.setText(self.file_path)

    def onActivated1(self,currentText):
        self.Category=currentText

    def onActivated2(self,currentText):
        self.Label=currentText

    def onActivated3(self,currentText):
        if self.auto_label_checkbox.checkState()==2:
            file_name=self.filename.split(".")
            file_name=file_name[0]
            self.label_name.setText(file_name)
        else:
            pass

    def regist_file_to_project(self):

        if self.selected_file.text()=="":
            message=QMessageBox.information(self,"お知らせ",  "ファイル名が選択されていません", QMessageBox.Ok)
            #print("ないよ")
            pass
        else:
            check=0
            if self.Label != "":
                for n in self.la:
                    if n == self.Label:
                        check += 1
                    else:
                        pass
            else:
                pass
            if check > 0:
                #print("かぶっちゃいや")
                message=QMessageBox.information(self,"お知らせ",  "同一のファイルが選択されています", QMessageBox.Ok)
            elif self.Category !="" and self.Label=="":
                #print("カテゴリー名ではなくラベル名を記入してください")
                message=QMessageBox.information(self,"お知らせ",  "カテゴリー名ではなくラベル名を記入してください", QMessageBox.Ok)

            else:
                g = codecs.open("cala_temp.txt","w","utf-8")
                g.write(self.Category + "," +self.Label + "," + self.file_path)
                g.close()
                self.w.close()

    def show(self):
        self.w.exec_()

if __name__=="__main__":
    app=QApplication(sys.argv)

    cate=["a","b"]
    labe=["c","d"]
    fi=["e","f"]

    ex=regist_File(cate,labe,fi)
    regist_File(cate,labe,fi).show()
    sys.exit(app.exec_())
