import sys, configparser, time, os

from PyQt5.QtWidgets import (QVBoxLayout, QLineEdit,QGridLayout,
 QApplication, QLabel, QMenu, QWidget, QHBoxLayout,QDialog,
 QAction, QTextEdit,QPushButton, qApp, QMessageBox, QInputDialog,
 QMainWindow, QFrame, QFileDialog, QCheckBox, QProgressBar,
 QListWidget, QCompleter, QComboBox,QRadioButton,QButtonGroup)
from PyQt5.QtGui import (QIcon, QFont, QColor, QPixmap, QDrag, QPainter,
 QBrush, QPen,QStandardItem,QStandardItemModel)
from PyQt5.QtCore import (QCoreApplication, Qt, QObject, pyqtSignal,
 QMimeData, )

from word_count_window import Word_Count
from similarity_calcuration import Similarity_Calcuration

class Similarity_SubWindow(QWidget):
    def __init__(self, project):
        super(Similarity_SubWindow, self).__init__()

        g = open("window_temp.txt","w")
        g.write("0")
        g.close()

        self.project = project
        self.similarity_subwindow()

    def similarity_subwindow(self):
        self.w=QDialog()

        radio_v_box=QVBoxLayout()
        #v_box= QVBoxLayout()

        button=QPushButton("頻出語の参照")
        button.clicked.connect(lambda: self.showD(self.w, self.project))

        word_v_box=QVBoxLayout()

        wordA_h_box=QHBoxLayout()
        woAlabel=QLabel("単語1")
        self.wordA=QLineEdit()
        wordA_h_box.addWidget(woAlabel)
        wordA_h_box.addWidget(self.wordA)
        wordA_h_box.addStretch(1)

        peke_h_box=QHBoxLayout()
        peke=QLabel("×")
        peke_h_box.addStretch(1)
        peke_h_box.addWidget(peke)
        peke_h_box.addStretch(1)

        wordB_h_box=QHBoxLayout()
        woBlabel=QLabel("単語2")
        self.wordB=QLineEdit()
        wordB_h_box.addWidget(woBlabel)
        wordB_h_box.addWidget(self.wordB)
        wordB_h_box.addStretch(1)

        cal_h_box=QHBoxLayout()
        self.cal_button=QPushButton("計算")
        cal_h_box.addStretch(1)
        cal_h_box.addWidget(self.cal_button)
        self.cal_button.clicked.connect(self.calcuration)

        word_v_box.addLayout(wordA_h_box)
        word_v_box.addLayout(peke_h_box)
        word_v_box.addLayout(wordB_h_box)
        word_v_box.addLayout(cal_h_box)
        word_v_box.addStretch(1)

        radio_h_box = QHBoxLayout()
        self.content_word = QRadioButton("内容語") #基本形を使用
        self.all_word = QRadioButton("全出現語")  #表層形を使用
        self.content_word.toggle()
        self.button_group = QButtonGroup()
        self.button_group.addButton(self.content_word)
        self.button_group.addButton(self.all_word)
        radio_h_box.addWidget(self.content_word)
        radio_h_box.addWidget(self.all_word)

        count_h_box = QHBoxLayout()
        text_label = QLabel("出現回数")
        self.min = QLineEdit()
        self.min.setToolTip("参照する単語の最低出現回数を設定してください")
        self.min.setText("3")
        count_label = QLabel("回以上")
        count_h_box.addWidget(text_label)
        count_h_box.addStretch(2)
        count_h_box.addWidget(self.min)
        count_h_box.addWidget(count_label)

        radio_v_box.addWidget(button)
        radio_v_box.addLayout(radio_h_box)
        radio_v_box.addLayout(count_h_box)
        radio_v_box.addStretch(1)

        radio_box=QHBoxLayout()
        radio_box.addLayout(word_v_box)
        radio_box.addStretch(1)
        radio_box.addLayout(radio_v_box)

        result_h_box=QHBoxLayout()
        self.res_label=QLabel()
        self.result_label=QLabel()
        result_h_box.addWidget(self.res_label)
        result_h_box.addWidget(self.result_label)

        main_v_layout=QVBoxLayout()

        close_h_box=QHBoxLayout()
        close_button = QPushButton("閉じる", self)
        close_button.clicked.connect(self.exit)
        close_h_box.addStretch(1)
        close_h_box.addWidget(close_button)

        main_v_layout.addLayout(radio_box)
        main_v_layout.addLayout(result_h_box)
        main_v_layout.addLayout(close_h_box)


        self.w.setGeometry(300, 300, 500, 200)
        self.w.setWindowTitle("類似度の計算")

        self.w.setLayout(main_v_layout)

    def calcuration(self):
        wordA=self.wordA.text()
        wordB=self.wordB.text()

        if wordA == "" or wordB == "":
            #print("単語を入力してください")
            message=QMessageBox.information(self,"お知らせ", "単語を入力してください", QMessageBox.Ok)
        else:
            result=Similarity_Calcuration(self.project, wordA, wordB).result

            if result == "nothing" or result == 0.0:
                message=QMessageBox.information(self,"お知らせ", "登録されていない単語ではないですか？", QMessageBox.Ok)
            else:
                self.res_label.setText(wordA + "と" + wordB + "の類似度は")
                self.result_label.setText(str(result))

    def showD(self, w, project):

        cfg=configparser.ConfigParser()
        file_path = project + ".ini"
        cfg.read(file_path)
        original_data_type=cfg['project']["original_data_type"]

        if int(original_data_type) == 1:
            #print("このプロジェクトでは使用できません")
            message=QMessageBox.information(self,"お知らせ", "このプロジェクトでは使用できません", QMessageBox.Ok)
        else:
            g = open("window_temp.txt","r")
            p=g.readline()
            g.close()

            if p == "0":
                content_word_check = 0
                if self.content_word.isChecked() == True:
                    content_word_check=0
                else:
                    content_word_check=1

                Word_Count(w, project, content_word_check, self.min.text())

            elif p == "1":
                #print("すでにウィンドウが開かれています")
                message=QMessageBox.information(self,"お知らせ", "すでにウィンドウが開かれています", QMessageBox.Ok)
            else:
                #print("error")
                message=QMessageBox.information(self,"お知らせ", "error", QMessageBox.Ok)


    def closeEvent(self, event):
        os.remove("./window_temp.txt")
        time.sleep(0.1)
        self.w.close()

    def show(self):
        self.w.show()

    def exit(self):
        os.remove("./window_temp.txt")
        time.sleep(0.1)
        self.w.close()

if __name__ == "__main__":
    app=QApplication(sys.argv)
    project = "ok_table"
    #Similarity_SubWindow(project)
    Similarity_SubWindow(project).show()
    #Similarity_SubWindow(project).w.show()
    sys.exit(app.exec_())
