import sys, configparser, time, os, configparser, codecs

def setup():
    make_main_config()
    time.sleep(0.1)
    make_projects_config()
    time.sleep(0.1)

    if os.name == "nt":
        make_mecabrc()
        time.sleep(0.1)
        make_mysqlconf()
        time.sleep(0.1)


    else:
        pass

def make_mecabrc():

    root_path = os.getcwd()
    mecab_path = root_path + "/mecab/bin/mecabrc"
    g = codecs.open(mecab_path,"w","utf-8")

    dictionary = "dicdir = " + root_path + "/mecab/dic"
    dictionary = dictionary.replace("\\", "/")
    g.write(dictionary)
    g.close()

def make_mysqlconf():
    root_path = os.getcwd()
    mysql_ini_path = root_path + "/mysql/my_2.ini"
    g = codecs.open(mysql_ini_path,"w","utf-8")
    g.close()

    g = codecs.open(mysql_ini_path,"a","utf-8")

    mysql_path = root_path + "/mysql"
    mysql_path = mysql_path.replace("\\", ",")

    configurations = [
    "[mysqld]",
    "innodb_buffer_pool_size = 64M",
    "innodb_file_per_table = 1",
    "innodb-status-output = 0",
    "innodb-status-output-locks = 0",
    "default-storage-engine = innodb",
    "log_bin = mysql-bin",
    "basedir = " + mysql_path,
    "datadir = " + mysql_path + "/data",
    "tmpdir = " + mysql_path + ",temp",
    "port = 3306",
    "server_id = 1",
    "character-set-server = utf8",
    "collation-server = utf8_general_ci",
    "transaction-isolation = REPEATABLE-READ",
    "log_output = FILE",
    "log_error_verbosity = 3",
    'log_error = "' + mysql_path + '/logs/mysqld_error.log"'
    "general_log = 1",
    'general_log_file = "' + mysql_path + '/logs/general_query_all.log"',
    "log-slow-admin-statements = 1",
    "log-queries-not-using-indexes = 1",
    "slow_query_log = 1",
    "long_query_time = 1",
    'slow_query_log_file = "' + mysql_path + '/logs/slow_query.log"',
    "log_syslog = 0",
    "log_timestamps = SYSTEM"
    "sql_mode = ONLY_FULL_GROUP_BY,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION,STRICT_TRANS_TABLES",
    "explicit_defaults_for_timestamp = true",
    "default_password_lifetime = 0",
    'secure-file-priv = "' + mysql_path + '/logs"',
    "[mysql]",
    "default-character-set = utf8mb4",
    "show-warnings"
    ]

    for n in configurations:
        g.write(n)
        g.write("\r\n")

    g.close()

def make_main_config():
    g = codecs.open("main_config","w","utf-8")

    a = "my_id!vector^"
    b = "my_pass!to^"
    c = "projects!no_use^"
    d = "root_path!" + os.getcwd() + "^"
    d = d.replace("\\", "/")
    e = "using_os!" + os.name + "^"
    f = "lost!loss"

    con = a + b + c + d + e + f

    g.write(con)
    g.close()

def make_projects_config():
    g = codecs.open("projects_config","w","utf-8")
    g.write("")
    g.close()


if __name__=="__main__":
    setup()
