#######################################
#CSVデータを新規プロジェクトに登録
#######################################

import sys, configparser, csv, time, codecs, os

from PyQt5.QtWidgets import (QVBoxLayout, QLineEdit,QGridLayout,
 QApplication, QLabel, QMenu, QWidget, QHBoxLayout,QDialog,
 QAction, QTextEdit,QPushButton, qApp, QMessageBox, QInputDialog,
 QMainWindow, QFrame, QFileDialog, QCheckBox, QProgressBar,
 QListWidget, QCompleter, QComboBox, QTreeView, QAbstractItemView)
from PyQt5.QtGui import (QIcon, QFont, QColor, QPixmap, QDrag, QPainter,
 QBrush, QPen,QStandardItem,QStandardItemModel)
from PyQt5.QtCore import (QCoreApplication, Qt, QObject, pyqtSignal,
 QMimeData, QAbstractItemModel, QModelIndex)

from write_project_ini import write_pro_ini
from mysql_create_database import main_create_database
from mysql_reserved_word import reserved_word_check

class Model(QAbstractItemModel):
    headers = 'A列', 'B列', 'C列'
    items = []

    def __init__(self, parent=None):
        super(Model, self).__init__(parent)

    def index(self, row, column, parent=QModelIndex()):
        return self.createIndex(row, column, None)

    def parent(self, child):
        return QModelIndex()

    def rowCount(self, parent=QModelIndex()):
        return len(self.items)

    def columnCount(self, parent=QModelIndex()):
        return len(self.headers)

    def data(self, index, role=Qt.DisplayRole):
        if role == Qt.DisplayRole:
            try:
                return self.items[index.row()][index.column()]
            except:
                return
        return

    def headerData(self, section, orientation, role=Qt.DisplayRole):
        if role != Qt.DisplayRole:
            return
        if orientation == Qt.Horizontal:
            return self.headers[section]

    def addRow(self, n):
        self.beginInsertRows(QModelIndex(), len(self.items), 1)
        self.items.append(n)
        self.endInsertRows()

    def removeRows(self):
        rowIndexes=[]
        rowIndexes.extend([0,1,2])
        for row in sorted(rowIndexes, reverse=True):
            self.beginRemoveRows(QModelIndex(), row, row + 1)
            #print(self.items[row])
            del self.items[row]
            self.endRemoveRows()

class View(QTreeView):
    def __init__(self, parent=None):
        super(View, self).__init__(parent)
        self.setItemsExpandable(False)
        self.setIndentation(0)
        self.setSelectionMode(QAbstractItemView.ExtendedSelection)

    def drawBranches(self, painter, rect, index):
        return

class new_project_csv_SubWindow(QWidget):

    def __init__(self,p):
        super(new_project_csv_SubWindow,self).__init__()

        self.p=p

        self.filepath=""

        self.open_project()

    def open_project(self):
        self.w=QDialog()

        labelA=QLabel()
        labelA.setText("プロジェクト名を入力してください")

        project_name_label=QLabel()
        project_name_label.setText("プロジェクト名")
        self.project_named=QLineEdit()

        vbox=QVBoxLayout()
        self.check_cate_use=QCheckBox("カテゴリー分けを行っている")
        self.check_label_use=QCheckBox("ラベル分けを行っている")
        vbox.addWidget(self.check_label_use)
        vbox.addWidget(self.check_cate_use)


        hbox2=QHBoxLayout()
        hbox2.addWidget(project_name_label)
        hbox2.addWidget(self.project_named)

        label=QLabel()
        label.setText('csvファイルの選択')

        select_bin_file=QPushButton("参照")
        select_bin_file.clicked.connect(self.open_file)

        self.file_name=QLineEdit()

        hbox=QHBoxLayout()
        hbox.addWidget(select_bin_file)
        hbox.addWidget(self.file_name)

##################################################################
        self.check_cate_use.stateChanged.connect(self.category_change)
        self.check_cate_use.stateChanged.connect(self.warning_label_check)
        self.check_label_use.stateChanged.connect(self.label_change)
        self.check_label_use.stateChanged.connect(self.warning_label_check)

        self.view=View(self)
        self.model=Model(self)
        self.view.setModel(self.model)

        hbox5=QHBoxLayout()
        self.label_comboA=QLabel("A列")
        self.label_comboB=QLabel("B列")
        self.label_comboC=QLabel("C列")
        hbox5.addWidget(self.label_comboA)
        hbox5.addWidget(self.label_comboB)
        hbox5.addWidget(self.label_comboC)

        hbox4=QHBoxLayout()
        self.comboA=QComboBox(self)
        self.comboA.addItem("テキスト")
        self.comboB=QComboBox(self)
        self.comboC=QComboBox(self)

        hbox4.addWidget(self.comboA)
        hbox4.addWidget(self.comboB)
        hbox4.addWidget(self.comboC)
##################################################################
        cancel=QPushButton("キャンセル")
        cancel.clicked.connect(self.cancel_processing)

        regist=QPushButton("登録")
        regist.clicked.connect(self.regist)

        hbox3=QHBoxLayout()
        hbox3.addStretch(1)
        hbox3.addWidget(regist)
        hbox3.addWidget(cancel)

        layout = QVBoxLayout()
        layout.addWidget(labelA)
        layout.addLayout(hbox2)
        layout.addStretch(1)
        layout.addWidget(label)
        layout.addLayout(hbox)
        layout.addStretch(1)
        layout.addLayout(vbox)
        layout.addStretch(1)
        layout.addWidget(self.view)
        layout.addStretch(1)
        layout.addLayout(hbox5)
        layout.addLayout(hbox4)
        layout.addStretch(1)
        layout.addLayout(hbox3)

        self.w.setLayout(layout)
        self.w.setWindowTitle('csvデータの登録')

        self.w.setGeometry(650, 300, 350, 500)

##############################################################
    def cancel_processing(self):
        g = open("select_project_temp.txt","w")
        g.write("")
        g.close()
        Model().items.clear()
        self.w.close()

    def warning_label_check(self):
        if self.check_cate_use.checkState()==2 and self.check_label_use.checkState()==0:
            #print("カテゴリーだけを登録することはできません")
            message=QMessageBox.information(self, "お知らせ","カテゴリーだけを登録することはできません", QMessageBox.Ok)


    def category_change(self):
        self.comboA.clear()
        self.comboB.clear()
        self.comboC.clear()

        if self.check_cate_use.checkState()==0 and self.check_label_use.checkState()==0:
            self.comboA.addItem("テキスト")
        elif self.check_cate_use.checkState()==2 and self.check_label_use.checkState()==0:
            self.comboA.addItem("テキスト")
        elif self.check_cate_use.checkState()==0 and self.check_label_use.checkState()==2:
            self.comboA.addItem("テキスト")
            self.comboA.addItem("ラベル")
            self.comboB.addItem("テキスト")
            self.comboB.addItem("ラベル")
        else:
            self.comboA.addItem("テキスト")
            self.comboA.addItem("ラベル")
            self.comboA.addItem("カテゴリー")

            self.comboB.addItem("テキスト")
            self.comboB.addItem("ラベル")
            self.comboB.addItem("カテゴリー")

            self.comboC.addItem("テキスト")
            self.comboC.addItem("ラベル")
            self.comboC.addItem("カテゴリー")


    def label_change(self):
        self.comboA.clear()
        self.comboB.clear()
        self.comboC.clear()

        if self.check_cate_use.checkState()==0 and self.check_label_use.checkState()==0:
            self.comboA.addItem("テキスト")
        elif self.check_cate_use.checkState()==2 and self.check_label_use.checkState()==0:
            self.comboA.addItem("テキスト")
        elif self.check_cate_use.checkState()==0 and self.check_label_use.checkState()==2:
            self.comboA.addItem("テキスト")
            self.comboA.addItem("ラベル")
            self.comboB.addItem("テキスト")
            self.comboB.addItem("ラベル")
        else:
            self.comboA.addItem("テキスト")
            self.comboA.addItem("ラベル")
            self.comboA.addItem("カテゴリー")
            self.comboB.addItem("テキスト")
            self.comboB.addItem("ラベル")
            self.comboB.addItem("カテゴリー")
            self.comboC.addItem("テキスト")
            self.comboC.addItem("ラベル")
            self.comboC.addItem("カテゴリー")
##############################################################

    def regist(self):
        data_check=self.select_cate_labe_column()
        combo_check=self.check_combobox()

        ch=0
        for n in self.p:
            if n == self.project_named.text():
                ch += 1
            else:
                pass

        ch2=reserved_word_check(self.project_named.text())  #プロジェクト名が予約語ではないかをチェックし、予約語であれば1を返す

        if data_check==0:
            pass
        elif combo_check==0:
            pass
        else:
            if self.project_named.text()=="":
                #print("プロジェクト名を入力してください")
                message=QMessageBox.information(self,"お知らせ", "プロジェクト名を入力してください", QMessageBox.Ok)
            elif ch2 > 0:
                #print("その単語は予約語のため使用できません")
                message=QMessageBox.information(self,"お知らせ",  "その単語は予約語のため使用できません", QMessageBox.Ok)
            elif self.file_name_check != self.file_name.text():
                #print("ファイル名が一致しません")
                message=QMessageBox.information(self,"お知らせ",  "ファイル名が一致しません", QMessageBox.Ok)
            elif ch > 0:
                #print("同名のプロジェクトが存在します")
                message=QMessageBox.information(self,"お知らせ",  "同名のプロジェクトが存在します", QMessageBox.Ok)
            else:
                if self.file_name.text()=="":
                    #print("ファイルを登録してください")
                    message=QMessageBox.information(self,"お知らせ",  "ファイルを登録してください", QMessageBox.Ok)
                else:
                    g = open("select_project_temp.txt","w")
                    aa=self.project_named.text()
                    g.write(aa)
                    g.close()

            ##############################################################
            #プロジェクトにiniファイルを登録
            ##############################################################
                    if self.comboA.currentText() == "テキスト":
                        text_column_no = "1"
                    elif self.comboB.currentText() == "テキスト":
                        text_column_no = "2"
                    elif self.comboC.currentText() == "テキスト":
                        text_column_no = "3"
                    else:
                        text_column_no="0"

                    if self.comboA.currentText() == "ラベル":
                        label_column_no = "1"
                    elif self.comboB.currentText() == "ラベル":
                        label_column_no = "2"
                    elif self.comboC.currentText() == "ラベル":
                        label_column_no = "3"
                    else:
                        label_column_no="0"

                    if self.comboA.currentText() == "カテゴリー":
                        category_column_no = "1"
                    elif self.comboB.currentText() == "カテゴリー":
                        category_column_no = "2"
                    elif self.comboC.currentText() == "カテゴリー":
                        category_column_no = "3"
                    else:
                        category_column_no="0"

                    write_pro_ini(self.project_named.text()).main(
                    text_column_no=text_column_no,
                    label_column_no=label_column_no,
                    category_column_no=category_column_no,
                    original_data_type="3",
                    csv_path=self.filepath
                    )   #iniファイルにプロジェクトを登録

                    time.sleep(0.1)

                    ##############################################################
                    #プロジェクトデータベースを作成
                    ##############################################################

                    main_create_database(self.project_named.text())

                    Model().items.clear()

                    self.w.close()

##############################################################

    def open_file(self):
        if len(Model().items) > 0:
            Model().removeRows()
        else:
            folder_path = os.getcwd()
            frame=QFileDialog.getOpenFileName(self, "ファイルの選択", folder_path,filter=("ｃｓｖ files(*.csv)"))

            filepath=frame[0]
            self.filepath=filepath
            filename=frame[0].split("/")
            filename=filename[-1]
            self.file_name_check=filename

            #CSVファイルの列数のチェック
            if filepath == "":
                pass
            else:
                with codecs.open(self.filepath, encoding = "utf-8") as f:
                    reader=csv.reader(f)
                    excess_line=[]
                    for i,row in enumerate(reader):
                        if len(row) > 3:
                            excess_line.append( i + 1 )
                        else:
                            pass
                    if len(excess_line)>0:
                        a = str(excess_line) + "行目の列が超過しています"
                        message=QMessageBox.information(self,"お知らせ",  a, QMessageBox.Ok)
                        #print(excess_line, "行目の列が超過しています")
                    else:
                        self.file_name.setText(filename)

                        if filepath=="":
                            #print("ファイルを登録しろ")
                            message=QMessageBox.information(self,"お知らせ",  "ファイルを登録してください", QMessageBox.Ok)
                        else:
                            #ツリービューにCSV内のデータを送る
                            with codecs.open(self.filepath, encoding = "utf-8") as f:
                                readers=csv.reader(f)
                                count=0
                                for n in readers:
                                    if count<3:
                                        self.model.addRow(n)
                                        count += 1
                                    else:
                                        break

##############################################################

    def select_cate_labe_column(self):
        if self.filepath=="":
            #print("ファイルが登録されていません")
            message=QMessageBox.information(self,"お知らせ",  "ファイルが登録されていません", QMessageBox.Ok)
            return 0
        else:
            #self.file_name.setText(filename)
            a=self.check_cate_use.checkState()
            b=self.check_label_use.checkState()
            self.collumns = (a+b)/2+1
            #print(self.collumns)

            with codecs.open(self.filepath, encoding = "utf-8") as f:
                reader=csv.reader(f)
                shortage_line=[]
                excess_line=[]
                for i,row in enumerate(reader):
                    if len(row)==0:
                        pass
                    elif len(row) < self.collumns:
                        shortage_line.append(i + 1)
                    elif len(row) > self.collumns:
                        excess_line.append(i + 1)
                    else:
                        pass

                if len(shortage_line):
                    a = str(shortage_line) + "行目のデータが足りません"
                    #print(shortage_line,"行目のデータが足りません")
                    message=QMessageBox.information(self,"お知らせ",  a, QMessageBox.Ok)
                    return 0
                elif len(excess_line):
                    a = str(excess_line) + "行目のデータが多すぎます"
                    #print(excess_line,"行目のデータが多すぎます")
                    message=QMessageBox.information(self,"お知らせ",  "保存するデータがありません", QMessageBox.Ok)
                    return 0
                else:
                    return 1

    def check_combobox(self):
        if self.comboB.currentText()=="" and self.comboC.currentText()=="":
            return 1
        elif self.comboA.currentText() == self.comboB.currentText():
            message=QMessageBox.information(self,"お知らせ",  "カラムの設定に重複があります", QMessageBox.Ok)
            #print("カラムの設定に重複があります")
            return 0
        elif self.comboA.currentText() == self.comboC.currentText():
            message=QMessageBox.information(self, "お知らせ", "カラムの設定に重複があります", QMessageBox.Ok)
            #print("カラムの設定に重複があります")
            return 0
        elif self.comboB.currentText() == self.comboC.currentText():
            message=QMessageBox.information(self, "お知らせ", "カラムの設定に重複があります", QMessageBox.Ok)
            #print("カラムの設定に重複があります")
            return 0



    def show(self):
        self.w.exec_()

if __name__=="__main__":
    app=QApplication(sys.argv)
    p=["a","b"]

    ex=new_project_csv_SubWindow(p)
    new_project_csv_SubWindow(p).show()
    sys.exit(app.exec_())
