<?php

// データをもらう
$videoid = htmlspecialchars($_GET['id']);
$videoheight = htmlspecialchars($_GET['height']);
if ($videoheight < 100)
{
	$videoheight = 100;
}
$videowidth = htmlspecialchars($_GET['width']);
if ($videowidth < 100)
{
	$videowidth = 100;
}

//
$xml = file_get_contents("http://ext.nicovideo.jp/api/getthumbinfo/$videoid");
$xmlObject = simplexml_load_string($xml);

$tag_xml =  "http://ext.nicovideo.jp/api/getthumbinfo/$videoid";
$tag_xmlObject = simplexml_load_file($tag_xml);
$data = get_object_vars($tag_xmlObject);


// ヘッダを挿入
head();

// --------------------

// ここにソースを書きます。
// --------------------


// IDは$videoid。
print <<<HTML
<p>動画IDは{$videoid}です。</p>
<hr />
<h2>動画</h2>
<script type="text/javascript" src="http://ext.nicovideo.jp/thumb_watch/{$videoid}?w={$videowidth}&h={$videoheight}"></script><noscript><a href="http://www.nicovideo.jp/watch/{$videoid}">【ニコニコ動画】</a>
</noscript>
<hr />
<h2>動画情報</h2>
HTML;
// 動画ID
print "<h3>動画ID</h3>\n<p>";
print( (string)$xmlObject->thumb->video_id);
print "</p>\n";
// タイトル
print "<h3>タイトル</h3>\n<p>";
print( (string)$xmlObject->thumb->title);
print "</p>\n";

// 動画説明
print "<h3>動画説明</h3>\n<p>";
print( (string)$xmlObject->thumb->description);
print "</p>\n";

// 長さ
print "<h3>長さ</h3>\n<p>";
print( (string)$xmlObject->thumb->length);
print "</p>\n";

// 再生回数
print "<h3>再生回数</h3>\n<p>";
print( (string)$xmlObject->thumb->view_counter);
print "</p>\n";

// コメント数
print "<h3>コメント数</h3>\n<p>";
print( (string)$xmlObject->thumb->comment_num);
print "</p>\n";

// マイリスト数
print "<h3>マイリスト数</h3>\n<p>";
print( (string)$xmlObject->thumb->mylist_counter);
print "</p>\n";

// 新着コメント
print "<h3>新着コメント</h3>\n<p>";
print( (string)$xmlObject->thumb->last_res_body);
print "</p>\n";

// タグ
print "<h3>タグ</h3>\n<ul>";
$count = 0;
// 十回繰り返す
while ($count <= 10) {
	print "<li>";
	print( (string)$xmlObject->thumb->tags->tag[$count]);
	$count++;
	print "</li>";
}
print "</ul>";

// 投稿者情報

// IDセット
$user_id = $xmlObject->thumb->user_id;

print "<h3>投稿者情報</h3>\n<p>";
print "ID：";
print( (string)$xmlObject->thumb->user_id);
print "&nbsp;名前：";
print "<a href=\"http://www.nicovideo.jp/user/{$user_id}\" target=\"_blank\">";
print( (string)$xmlObject->thumb->user_nickname);
print "</a></p><p>";
$user_img = $xmlObject->thumb->user_icon_url;
print "<img src=\"{$user_img}\">";
print "</p>\n";

print <<<HTML
<hr />
<h2>リンク</h2>
<p><a href="http://www.nicovideo.jp/watch/{$videoid}" target="_blank">ニコニコ動画で見る！</a></p>
<p><a href="http://www.nicovideo.jp/user/{$user_id}" target="_blank">投稿者のプロフィール</a></p>
<p><a href="http://www.nicovideo.jp/" target="_blank">ニコニコTOP</a></p>
<p><a href="http://www.nicovideo.jp/video_top" target="_blank">ニコニコ動画TOP</a></p>
<hr />
HTML;


// --------------------
// ソース ここまで

// フッタを挿入
foot();
// --------------------



// 以下、サブルーチン集

// ヘッダ処理
function head()
{
	print <<<HTML
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta name="Keywords" content="ニコニコ,2525,外部プレーヤ" />
<meta name="Description" content="ニコニコ動画の動画をアカウント無しで視聴できるウェブアプリケーション。" />
<style type="text/css">
body{
background: linear-gradient(#BFE6FB, #FFFFFF);
text-align: center;
}
</style>
<meta charset="UTF-8">
<title>2525ビューワ</title>
</head>
<body>
<p align="center"><a href="./">■戻る■</a></p>
HTML;
}

// --------------------

// フッタ処理
function foot()
{
	print <<<HTML
<p align="center"><a href="./">■戻る■</a></p>
<p align="right">Cording by Light.<a href="http://light-tv.club/">LIGHT-TV</a></p>
</body>
</html>
HTML;
}
// --------------------

?>