/*
 * vhelpdesk - Frontend of namazu.
 * This program has borrowed the code from mini-commander_applet. 
 */

#include <glib/gi18n.h>
#include <panel-applet.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

typedef struct {
	PanelApplet *applet;
	GtkWidget *entry;
} VHD;

static gboolean
send_button_to_entry_event (GtkWidget *widget, GdkEventButton *event, VHD *vhd)
{
	gboolean visible;

	if (event->button == 1) {
	/*
		gtk_widget_grab_focus (vhd->entry);
		return TRUE;
	*/
		g_object_get(vhd->entry, "visible", &visible, NULL);
		g_object_set(vhd->entry, "visible", !visible, NULL);

		return	TRUE;
	}
	
	return FALSE;
}

static gboolean button_press_cb (GtkEntry *entry, GdkEventButton *event, VHD *vhd)
{
	panel_applet_request_focus (vhd->applet, event->time);

	return FALSE;
}

void entry_activate (GtkEntry *entry, VHD *vhd)
{
	GtkWidget *dialog;
	gchar *search_str;
	gchar *cmd_str;

	/* enter pressed -> exec vhelpdesk.sh */
	search_str = g_locale_from_utf8(
			gtk_entry_get_text(GTK_ENTRY(vhd->entry)),
			-1, NULL, NULL, NULL);
	cmd_str = g_strdup_printf("vhelpdesk %s", search_str);
	gdk_spawn_command_line_on_screen (
			gtk_widget_get_screen (GTK_WIDGET (vhd->applet)),
			cmd_str, NULL);

	g_free (search_str);
	g_free (cmd_str);
}

static void
applet_destroyed (GtkWidget *widget, VHD *vhd)
{
	g_free (vhd);
}

static gboolean
vhelpdesk_applet_fill (PanelApplet *applet,
		const gchar *iid,
		gpointer data)
{
	VHD *vhd;
	GtkWidget *entry;
	GtkWidget *image;
	GtkWidget *hbox;

	if (strcmp (iid, "OAFIID:VHelpDeskApplet") != 0)
		return FALSE;

	vhd = g_new0 (VHD, 1);
	vhd->applet = applet;
	hbox = gtk_hbox_new (FALSE, 2);
	image = gtk_image_new_from_stock(GTK_STOCK_DIALOG_QUESTION, 24);
	gtk_box_pack_start (GTK_BOX(hbox), image, FALSE, FALSE, 0);
	vhd->entry = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX(hbox), vhd->entry, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (applet), hbox);

	g_signal_connect (vhd->entry, "activate",
			G_CALLBACK (entry_activate), vhd);
	g_signal_connect (vhd->entry, "button_press_event",
			G_CALLBACK (button_press_cb), vhd);
	g_signal_connect (vhd->applet, "button_press_event",
			G_CALLBACK (send_button_to_entry_event), vhd);
	g_signal_connect (vhd->applet, "destroy", G_CALLBACK (applet_destroyed), vhd);

	gtk_widget_show_all (GTK_WIDGET (applet));

	return TRUE;
}

PANEL_APPLET_BONOBO_FACTORY ("OAFIID:VHelpDeskApplet_Factory",
		PANEL_TYPE_APPLET,
		"an applet that is frontend of namazu.",
		"0",
		vhelpdesk_applet_fill,
		NULL);
