/***********************************************************************
 * VirtualDub Modification for OGM
 *
 * Copyright (C) 2002 Cyrius
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or visit http://www.gnu.org/copyleft/gpl.html
 *
 ***********************************************************************
 *
 *
 *
 */

#ifndef __OGMCOMMON_H__
#define __OGMCOMMON_H__

#include "OGMCommonDefs.h"
#include <malloc.h>
#include <stdio.h>

#define __OGM_CAN_CUT_FIRST_PACKET__

struct comment_list {
	char *tag;
	char *comment;
	comment_list *next;

	void *operator new(unsigned int nAlloc) {
		comment_list *list = (comment_list *)malloc(nAlloc);
		if(list) {
			list->tag = NULL;
			list->comment = NULL;
			list->next = NULL;
		}
		return list;
	}

	void operator delete(void *old_list) {
		comment_list *list = (comment_list *)old_list;
		if(list->tag)
			delete list->tag;
		if(list->comment)
			delete list->comment;
		free(old_list);
	}
};

#endif /* __OGMCOMMON_H__ */