// SmartRipperInfoFile.h: interface for the SmartRipperInfoFile class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SMARTRIPPERINFOFILE_H__48C32E46_B503_11D6_A8C8_00B0D08CE1E8__INCLUDED_)
#define AFX_SMARTRIPPERINFOFILE_H__48C32E46_B503_11D6_A8C8_00B0D08CE1E8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <vector>
#include <string>

class SmartRipperInfoFile  
{
public:
	SmartRipperInfoFile(const char *);
	SmartRipperInfoFile() {}
	void Init(const char *);
	~SmartRipperInfoFile();

	const std::vector<std::string> & GetFiles(void) {return m_Files;}
	int GetFrames(void) {return m_Frames;}
	const std::string & GetName(void) {return m_Name;}
	const std::vector<std::string> & GetAudioStreams(void) {return m_AudioStreams;}
	const std::vector<unsigned int> & GetAudioTracks(void) {return m_AudioTracks;}
private:
	std::vector<std::string> m_Files;
	std::string m_Name;
	int m_Frames;
	std::vector<unsigned int> m_Chapters;
	std::string m_VideoStream;
	std::vector<std::string> m_AudioStreams;
	std::vector<unsigned int> m_AudioTracks;
	// because the first stream in m_AudioStreams is not always 0x80, we keep the right value here.
};

#endif // !defined(AFX_SMARTRIPPERINFOFILE_H__48C32E46_B503_11D6_A8C8_00B0D08CE1E8__INCLUDED_)
