//	VirtualDub - Video processing and capture application
//	Copyright (C) 1998-2001 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef f_VIRTUALDUB_COMMAND_H
#define f_VIRTUALDUB_COMMAND_H

#include <windows.h>
#include <vfw.h>

#include "AVIOutput.h"

class InputFile;
//class AVIOutput;
class VideoSource;
class AudioSource;
class IDubber;
class DubOptions;
class FrameSubset;

extern InputFile			*inputAVI;

extern AVIOutput			*outputAVI;

extern VideoSource			*inputVideoAVI;

extern AudioSource			*inputAudio;
extern AudioSource			*inputAudioAVI;
extern AudioSource			*inputAudioWAV;
extern AudioSource			*inputAudioCBRMP3;
extern AudioSource			*inputAudioMP3;
extern AudioSource			*inputAudioAC3;
extern AudioSource			*inputAudioOGG;

extern AudioSource			*inputAudio2;
extern AudioSource			*inputAudio2AVI;
extern AudioSource			*inputAudio2WAV;
extern AudioSource			*inputAudio2CBRMP3;
extern AudioSource			*inputAudio2MP3;
extern AudioSource			*inputAudio2AC3;
extern AudioSource			*inputAudio2OGG;

extern FrameSubset			*inputSubset;

enum {
	AUDIOIN_NONE	= 0,
	AUDIOIN_AVI		= 1,
	AUDIOIN_WAVE	= 2,
	AUDIOIN_CBRMP3	= 3,
	AUDIOIN_MP3		= 4,
	AUDIOIN_AC3		= 5,
	AUDIOIN_OGG		= 6
};

extern int					audioInputMode;
extern int					audio2InputMode;
extern IDubber				*g_dubber;

extern COMPVARS			g_Vcompression;
extern COMPVARS			g_Vcompression2;
extern WAVEFORMATEX		*g_ACompressionFormat;
extern DWORD			g_ACompressionFormatSize;
extern WAVEFORMATEX		*g_A2CompressionFormat;
extern DWORD			g_A2CompressionFormatSize;

extern BOOL				g_drawDecompressedFrame;
extern BOOL				g_showStatusWindow;
extern BOOL				g_syncroBlit;
extern BOOL				g_vertical;

///////////////////////////

enum {
	FILETYPE_AUTODETECT		= 0,
	FILETYPE_AVI			= 1,
	FILETYPE_MPEG			= 2,
	FILETYPE_ASF			= 3,
	FILETYPE_STRIPEDAVI		= 4,
	FILETYPE_AVICOMPAT		= 5,
	FILETYPE_IMAGE			= 6,
	FILETYPE_AUTODETECT2	= 7,
	FILETYPE_MPEG2TXTFILE	= 8
//==============================//
//=====  MODIFICATION OGM  =====//
//=====    -= Cyrius =-    =====//
//BEGIN ========================//
	,FILETYPE_OGM			= 9
//END ==========================//
//==============================//
//=====  MODIFICATION PNG  =====//
//=====    -= Cyrius =-    =====//
//BEGIN ========================//
	,FILETYPE_IMAGE_PNG	= 10
//END ==========================//
};

void OpenAVI(char *szFile, int iFileType, bool fExtendedOpen, bool fQuiet=false, bool fAutoscan=false, const char *pInputOpts=0);
void AppendAVI(const char *pszFile);
void AppendAVIAutoscan(const char *pszFile);
void SetAudioSource();
void CloseAVI(bool bKeepOGMStreams=false);
void OpenWAV(char *szFile, bool secondary=false);
void CloseWAV(bool secondary=false);
void OpenCBRMP3(char *szFile, bool secondary=false);// pulco 09/12/2002
void CloseCBRMP3(bool secondary=false);
void OpenMP3(char *szFile, bool secondary=false);
void CloseMP3(bool secondary=false);
// 12/11/2002, Cyrius : added boolean
void OpenAC3(char *szFile, bool secondary=false, bool frame_boundary=false);
void CloseAC3(bool secondary=false);
void OpenOGG(char *szFile, bool secondary=false);
void CloseOGG(bool secondary=false);
void CloseNewAVI();
void SaveWAV(char *szFilename, bool fProp = false, DubOptions *quick_opts=NULL, bool skipWAVHeader=false);
void SaveAVI(char *szFilename, _avi_info *infos, bool fProp = false, DubOptions *quick_opts=NULL, bool fCompatibility=false);
//==============================//
//=====  MODIFICATION OGM  =====//
//=====    -= Cyrius =-    =====//
//BEGIN ========================//
void OpenOGMInputFile(char *szFile, int type, long offset);
void AddInputAudioStream(int stream, long offset);
void AddInputTextStream(int stream, long offset);
void RemoveInputStreams(void);
void DeleteComments(void);
void AddVideoComment(char *tag, char *comment);
void AddAudioComment(char *tag, char *comment);
void AddAudio2Comment(char *tag, char *comment);
void AddComment(int index, int type, char *tag, char *comment);
void SaveOGM(char *szFilename, bool fProp = false, DubOptions *quick_opts=NULL, bool fCompatibility=false);
void CloseOGMInputs(void);
//END ==========================//
void SaveStripedAVI(char *szFile);
void SaveStripeMaster(char *szFile);
void SaveSegmentedAVI(char *szFilename, bool fProp, DubOptions *quick_opts, long lSpillThreshold, long lSpillFrameThreshold);
void SaveImageSequence(const char *szPrefix, const char *szSuffix, int minDigits, bool fProp, DubOptions *quick_opts, int targetFormat);
void SetSelectionStart(long ms);
void SetSelectionEnd(long ms);
void RemakePositionSlider();
void RecalcPositionTimeConstant();
void EnsureSubset();
void ScanForUnreadableFrames(FrameSubset *pSubset, VideoSource *pVideoSource);

#endif
