/***********************************************************************
 * VirtualDubMod project
 *
 * Copyright (C) 2002
 *
 * File added by Cyrius
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or visit http://www.gnu.org/copyleft/gpl.html
 *
 ***********************************************************************
 *
 *
 *
 */

#ifndef __AUDIOOUTPUT_H__
#define __AUDIOOUTPUT_H__

#include "OGMOutput.h"
#include "../AudioSource.h"


class AudioOutputFile : public OGMOutputFile {
protected:
	static char	szME[];
	bool		bAddWAVHeader;
	bool		fHeaderOpen;
	DWORD		dwBytesWritten;
	AudioSource *audioSource;

	void _writeHdr(void *data, long len);
	void _seekHdr(__int64 i64NewPos);
	void _write(void *data, int len);
public:
	AudioOutputFile(bool bAddWAVHeader);

	virtual BOOL init(const char *szFile, LONG xSize, LONG ySize, BOOL videoIn, BOOL audioIn, BOOL audioIn2, LONG bufferSize, BOOL is_interleaved);
	virtual void write_headers(void);
	virtual int add_stream(OGMAudioSource *audioSource, comment_list *comments);
	virtual BOOL process_data(int serial, bool key_frame, LPVOID buffer, LONG length, LONG nSamples);
	BOOL finalize(void);
};


#endif /* __AUDIOOUTPUT_H__ */