/*
** Copyright (C) 2004-2005 AT Consultancy
**
** This program is free software; you can redistribute it and/or modify it
** under the terms of the GNU General Public License as published by the
** Free Software Foundation; either version 2, or (at your option) any
** later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** -----------------------------------------------------------------------
**
** DO NOT MODIFY THESE VALUES (would make old cowfiles unusable)
*/
#define	MAPUNIT		1024		/* blocksize for bit in bitmap       */
#define	MUSHIFT		10		/* bitshift  for bit in bitmap       */
#define	MUMASK		0x3ff		/* bitmask   for bit in bitmap       */

#define	COWMAGIC	0x574f437f	/* byte-swapped '7f C O W'           */
#define	COWDIRTY	0x01
#define	COWVERSION	1

struct cowhead
{
	int		magic;		/* identifies a cowfile              */
	short		version;	/* version of cowhead                */
	short		flags;    	/* flags indicating status           */
	unsigned long	mapunit;	/* blocksize per bit in bitmap       */
	unsigned long	mapsize;	/* total size of bitmap (bytes)      */
	unsigned long	doffset;	/* start-offset datablocks in cow    */
	unsigned long	rdoblocks;	/* size of related read-only file    */
	unsigned long	rdochecksum;	/* checksum of the read-only file    */
	unsigned long	cowused;	/* number of datablocks used in cow  */
};

#define COWDEVDIR	"/dev/cow/"
#define COWDEVICE	COWDEVDIR "%ld"
#define COWCONTROL	COWDEVDIR "ctl"

#define COWCTL		255
#define MAXCOWS		COWCTL

#define COWPROCDIR	"/proc/cow/"
#define COWPROCFILE	COWPROCDIR "%d"

/*
** ioctl related stuff
*/
#define ANYDEV		((unsigned long)-1)

struct cowpair
{
	unsigned char	*rdofile;	/* pathname of the rdofile           */
	unsigned char	*cowfile;	/* pathname of the cowfile           */
	unsigned short	rdoflen;	/* length of rdofile pathname        */
	unsigned short	cowflen;	/* length of cowfile pathname        */
	unsigned long	device;		/* requested/returned device number  */
};

#define	COWSYNC		_IO  ('C', 1)
#define	COWMKPAIR	_IOW ('C', 2, struct cowpair)
#define	COWRMPAIR	_IOW ('C', 3, unsigned long)
