#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>
#include <limits.h>  /* PATH_MAX */
#include <dirent.h>  /* opendir() */

#include "viverrc.h"
#include "paclist.h"
#include "fbcolors.h"
#include "applypaclist.h"

#define COMMAND_MAX 1024

static bool dir_exists(char *path);

const static char *rcdir_path;
const static char *pacdir_path;


void wait_thread(pac *needed)
{
	pthread_mutex_lock(&needed->applied_mutex);
	while (needed->applied == false) {
		pthread_cond_wait(&needed->applied_cond, &needed->applied_mutex);
	}
	pthread_mutex_unlock(&needed->applied_mutex);
}

void apply_start(pac *target)
{
	char resources_dir_path[PATH_MAX+1];
	char cmd[COMMAND_MAX];
	char conf_path[PATH_MAX+1];
	int i;

	if (target->use != Special) {  /* Special_LAST_DUMMY_ */
		if (target->use == Yes) {
			sprintf(conf_path, "%s/%s.conf", target->in_role_path, target->info.name);
		} else if (target->use == YesButNotInRole) {
			/* ǥե.confȤ */
			sprintf(conf_path, "%s/%s/%s.conf", pacdir_path, target->dirname, target->info.name);
		}

		sprintf(resources_dir_path, "%s/%s/resources", pacdir_path, target->dirname);

		if (dir_exists(resources_dir_path)) {
			sprintf(cmd, "cd %s && ../start %s %s/%s", resources_dir_path, conf_path, rcdir_path,PAC_OUTPUT_DIR);
		} else {
			sprintf(cmd, "cd %s/%s && ./start %s %s/%s", pacdir_path,target->dirname, conf_path, rcdir_path,PAC_OUTPUT_DIR);
		}

		for (i=0; target->need[i] != NULL; i++) {
			wait_thread(target->need[i]);
		}

		printf("%s%s started.%s\n", FB_MSG, target->info.name, FB_NORMAL);
		system(cmd);
	}

	pthread_mutex_lock(&target->applied_mutex);
	target->applied = true;
	pthread_cond_broadcast(&target->applied_cond);
	pthread_mutex_unlock(&target->applied_mutex);
}

void apply_paclist(pac *cue_last, char *arg_rcdir_path, char *arg_pacdir_path)
{
	pthread_t *thread;
	int i;
	pac *apply_this;
	int num_paclist;

	rcdir_path = arg_rcdir_path;
	pacdir_path = arg_pacdir_path;

	num_paclist = paclist_count(cue_last);
	apply_this = cue_last->next;  /* cue_last_LAST _LASTϺǸ˳Ϥ */
	thread = malloc(sizeof(pthread_t) * num_paclist);  /* 쵤malloc()Ƥޤ */
	for (i=0; i < num_paclist - 1; i++) {  /* _LASTʳ򳫻 */
		if (apply_this->use) {
			pthread_create(&thread[i], NULL, (void*)apply_start, (void*)apply_this);
		}
		apply_this = apply_this->next;
	}
	pthread_create(&thread[i], NULL, (void*)apply_start, (void*)cue_last);  /* _LAST򳫻 */
	for (i=0; i < num_paclist; i++) {  /* _LASTޤjoin */
		if (apply_this->use) {
			pthread_join(thread[i], NULL);
		}
	}
}

static bool dir_exists(char *path)
{
	DIR *dir;
	if ( (dir = opendir(path)) != NULL ) {
		closedir(dir);
		return true;
	} else {
		return false;
	}
}
