#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>  /* opendir() */

#include "paclist.h"
#include "fbcolors.h"
#include "getpaclist.h"


void get_paclist(pac* cue_last, const char* pacdir_path)
{
	DIR *pacdir;
	struct dirent *pacdir_line;
	pac *new_pac_tmp;
	int dirlen;

	if ( (pacdir = opendir(pacdir_path)) == NULL ) {
		fprintf(stderr, "%sCan't open pac dir.%s\n", FB_ERROR, FB_NORMAL);
		exit(2);
	}

	while ( (pacdir_line = readdir(pacdir)) != NULL ) {
		dirlen = strlen(pacdir_line->d_name);
		if (dirlen < 5) { continue; }
		if (strcmp(&pacdir_line->d_name[ dirlen - 4 ], ".pac") != 0)
			continue;  /* 4ʸ".pac"ǤϤʤ */
		if ( (new_pac_tmp = malloc(sizeof(pac))) == NULL ) {
			/* free()paclist_clean()ǹԤ */
			fprintf(stderr, "%sCan't allocate memory for pac. Rest pacs are ignored.%s\n", FB_WARN, FB_NORMAL);
			break;
		}
		initialize_pac(new_pac_tmp);
		strcpy(new_pac_tmp->dirname, pacdir_line->d_name);
		paclist_addpac(cue_last, new_pac_tmp);
	}

	closedir(pacdir);
}
