#ifndef __BUNDLE_INFO_H_INCLUDED
#define __BUNDLE_INFO_H_INCLUDED 1

#include "bundle_depend.h"
#include "version.h"
#include <string>
#include <map>
#include <istream>

namespace RUNES {


class BundleParser;

class BundleInfo {
friend class BundleParser;
public:
	BundleInfo();
	~BundleInfo();
public:
	const std::string& getName(void)    const;
	const Version&     getVersion(void) const;
	const std::string& getRelease(void) const;
	const std::string& getBuild(void)   const;
	const std::string& getArch(void)    const;
	const BDLogicAND&  getDepend(void)  const;
	const bool getSummary(const std::string& lang, std::string* result) const;
	const bool getDescription(const std::string& lang, std::string* result) const;
	const std::list<std::string> getPreOrder (void)  const;
	const std::list<std::string> getPostOrder(void) const;
	void show(void) const;
private:
	std::string m_name;
	Version m_version;
	std::string m_release;
	std::string m_build;
	std::string m_arch;
	std::string m_license;
	std::string m_packager;
	std::map<std::string, std::string> m_summary;
	std::map<std::string, std::string> m_description;
	BDLogicAND m_depend;

	// XXX:
	// BDLogicAND m_recommend;
	// Summary
	// Description
	// Port
	// Parameters
	// Parameters_namespace
};


class Element;
class BundleInfoHolder {
public:
	BundleInfoHolder();
	virtual ~BundleInfoHolder();
protected:
	void parseInfo(std::istream& source_stream);
	void parseInfo(const Element& document);
public:
	const std::string& getName(void)    const { return m_info.getName();    }
	const Version&     getVersion(void) const { return m_info.getVersion(); }
	const std::string& getRelease(void) const { return m_info.getRelease(); }
	const std::string& getBuild(void)   const { return m_info.getBuild();   }
	const std::string& getArch(void)    const { return m_info.getArch();    }
	const BDLogicAND&  getDepend(void)  const { return m_info.getDepend();  }
	const bool getSummary(const std::string& lang, std::string* result) const	{ return m_info.getSummary(lang, result);	}
	const bool getDescription(const std::string& lang, std::string* result) const	{ return m_info.getDescription(lang, result);	}
	const std::list<std::string> getPreOrder(void)  const { return m_info.getPreOrder();  }
	const std::list<std::string> getPostOrder(void) const { return m_info.getPostOrder(); }
protected:
	BundleInfo m_info;
};


}  // namespace RUNES

#endif /* bundle_info.h */
